theory lineardecision_LinearEquationsDecision_gauss_jordanqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "mach.matrix_Matrix63" "Why3STD.debug_Debug"
begin
typedecl  coeff
typedecl  a
consts infix_pl :: "a \<Rightarrow> a \<Rightarrow> a"
consts infix_as :: "a \<Rightarrow> a \<Rightarrow> a"
consts prefix_mn :: "a \<Rightarrow> a"
consts azero :: "a"
consts aone :: "a"
consts ale :: "a \<Rightarrow> a \<Rightarrow> bool"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Unit_def_l:   "infix_pl azero x = x"
  for x :: "a"
axiomatization where Unit_def_r:   "infix_pl x azero = x"
  for x :: "a"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = azero"
  for x :: "a"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = azero"
  for x :: "a"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "a"
  and y :: "a"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "a"
  and z :: "a"
  and x :: "a"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "a"
  and y :: "a"
axiomatization where Unitary:   "infix_as aone x = x"
  for x :: "a"
axiomatization where NonTrivialRing:   "\<not>azero = aone"
axiomatization where Refl:   "ale x x"
  for x :: "a"
axiomatization where Trans:   "ale x z"
 if "ale x y"
 and "ale y z"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Antisymm:   "x = y"
 if "ale x y"
 and "ale y x"
  for x :: "a"
  and y :: "a"
axiomatization where Total:   "ale x y \<or> ale y x"
  for x :: "a"
  and y :: "a"
axiomatization where ZeroLessOne:   "ale azero aone"
axiomatization where CompatOrderAdd:   "ale (infix_pl x z) (infix_pl y z)"
 if "ale x y"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where CompatOrderMult:   "ale (infix_as x z) (infix_as y z)"
 if "ale x y"
 and "ale azero z"
  for x :: "a"
  and y :: "a"
  and z :: "a"
consts infix_mn :: "a \<Rightarrow> a \<Rightarrow> a"
axiomatization where sub_def:   "infix_mn a1 a2 = infix_pl a1 (prefix_mn a2)"
  for a1 :: "a"
  and a2 :: "a"
typedecl  vars
typedecl  cvars
consts interp :: "coeff \<Rightarrow> cvars \<Rightarrow> a"
consts czero :: "coeff"
consts cone :: "coeff"
axiomatization where zero_def:   "interp czero y = azero"
  for y :: "cvars"
axiomatization where one_def:   "interp cone y = aone"
  for y :: "cvars"
consts eq :: "coeff \<Rightarrow> coeff \<Rightarrow> bool"
axiomatization where eq'spec:   "interp a1 y = interp b y"
 if "eq a1 b"
  for a1 :: "coeff"
  and b :: "coeff"
  and y :: "cvars"
typedecl  vars1
datatype  expr = Term "coeff" "int" | Add "expr" "expr" | Cst "coeff"
fun valid_expr :: "expr \<Rightarrow> _"
  where "valid_expr (Term x i) = ((0 :: int) \<le> i)" for x i
      | "valid_expr (Cst x) = True" for x
      | "valid_expr (Add e1 e2) = (valid_expr e1 \<and> valid_expr e2)" for e1 e2
fun expr_bound :: "expr \<Rightarrow> int \<Rightarrow> _"
  where "expr_bound (Term x i) b = ((0 :: int) \<le> i \<and> i \<le> b)" for x i b
      | "expr_bound (Cst x) b = True" for x b
      | "expr_bound (Add e1 e2) b = (expr_bound e1 b \<and> expr_bound e2 b)" for e1 e2 b
fun interp1 :: "expr \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> cvars \<Rightarrow> a"
  where "interp1 (Term c v) y z = infix_as (interp c z) (y v)" for c v y z
      | "interp1 (Add e1 e2) y z = infix_pl (interp1 e1 y z) (interp1 e2 y z)" for e1 e2 y z
      | "interp1 (Cst c) y z = interp c z" for c y z
typedecl  equality
typedecl  "context"
definition valid_eq :: "expr \<times> expr \<Rightarrow> _"
  where "valid_eq eq1 \<longleftrightarrow> (case eq1 of (e1, e2) \<Rightarrow> valid_expr e1 \<and> valid_expr e2)" for eq1
definition eq_bound :: "expr \<times> expr \<Rightarrow> int \<Rightarrow> _"
  where "eq_bound eq1 b \<longleftrightarrow> (case eq1 of (e1, e2) \<Rightarrow> expr_bound e1 b \<and> expr_bound e2 b)" for eq1 b
fun valid_ctx :: "(expr \<times> expr) list \<Rightarrow> _"
  where "valid_ctx (Nil :: (expr \<times> expr) list) = True"
      | "valid_ctx (Cons eq1 t) = (valid_eq eq1 \<and> valid_ctx t)" for eq1 t
fun ctx_bound :: "(expr \<times> expr) list \<Rightarrow> int \<Rightarrow> _"
  where "ctx_bound (Nil :: (expr \<times> expr) list) b = True" for b
      | "ctx_bound (Cons eq1 t) b = (eq_bound eq1 b \<and> ctx_bound t b)" for eq1 t b
definition interp_eq :: "expr \<times> expr \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> cvars \<Rightarrow> bool"
  where "interp_eq g y z = (if case g of (g1, g2) \<Rightarrow> interp1 g1 y z = interp1 g2 y z then True else False)" for g y z
fun interp_ctx :: "(expr \<times> expr) list \<Rightarrow> expr \<times> expr \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> cvars \<Rightarrow> bool"
  where "interp_ctx l g y z = (if case l of Nil \<Rightarrow> interp_eq g y z = True | Cons h t \<Rightarrow> interp_eq h y z = True \<longrightarrow> interp_ctx t g y z = True then True else False)" for l g y z
consts infix_eqeq :: "coeff array63 \<Rightarrow> coeff array63 \<Rightarrow> bool"
axiomatization where infix_eqeq'spec'0:   "array63_length a1 = array63_length b"
 if "infix_eqeq a1 b"
  for a1 :: "coeff array63"
  and b :: "coeff array63"
axiomatization where infix_eqeq'spec'1:   "\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (array63_length a1) \<longrightarrow> eq (array63_elts a1 ! nat i) (array63_elts b ! nat i)"
 if "infix_eqeq a1 b"
  for a1 :: "coeff array63"
  and b :: "coeff array63"
consts max_var :: "expr \<Rightarrow> int"
axiomatization where max_var'def:   "case e of Term _ i \<Rightarrow> max_var e = i | Cst _ \<Rightarrow> max_var e = (0 :: int) | Add e1 e2 \<Rightarrow> max_var e = max (max_var e1) (max_var e2)"
 if "valid_expr e"
  for e :: "expr"
axiomatization where max_var'spec'0:   "(0 :: int) \<le> max_var e"
 if "valid_expr e"
  for e :: "expr"
axiomatization where max_var'spec:   "expr_bound e (max_var e)"
 if "valid_expr e"
  for e :: "expr"
consts max_var_e :: "expr \<times> expr \<Rightarrow> int"
axiomatization where max_var_e'def:   "case e of (e1, e2) \<Rightarrow> max_var_e e = max (max_var e1) (max_var e2)"
 if "valid_eq e"
  for e :: "expr \<times> expr"
axiomatization where max_var_e'spec'0:   "(0 :: int) \<le> max_var_e e"
 if "valid_eq e"
  for e :: "expr \<times> expr"
axiomatization where max_var_e'spec:   "eq_bound e (max_var_e e)"
 if "valid_eq e"
  for e :: "expr \<times> expr"
consts max_var_ctx :: "(expr \<times> expr) list \<Rightarrow> int"
axiomatization where max_var_ctx'def:   "case l of Nil \<Rightarrow> max_var_ctx l = (0 :: int) | Cons e t \<Rightarrow> max_var_ctx l = max (max_var_e e) (max_var_ctx t)"
 if "valid_ctx l"
  for l :: "(expr \<times> expr) list"
axiomatization where max_var_ctx'spec'0:   "(0 :: int) \<le> max_var_ctx l"
 if "valid_ctx l"
  for l :: "(expr \<times> expr) list"
axiomatization where max_var_ctx'spec:   "ctx_bound l (max_var_ctx l)"
 if "valid_ctx l"
  for l :: "(expr \<times> expr) list"
definition atom :: "expr \<Rightarrow> _"
  where "atom e \<longleftrightarrow> (case e of Add _ _ \<Rightarrow> False | _ \<Rightarrow> True)" for e
theorem gauss_jordan'vc:
  fixes a1 :: "coeff matrix"
  assumes fact0: "(1 :: int) \<le> sint (rows a1)"
  assumes fact1: "(1 :: int) \<le> sint (columns a1)"
  shows "let n :: 63 word = rows a1; m :: 63 word = columns a1 in (\<forall>(a2 :: coeff matrix). rows a2 = rows a1 \<and> columns a2 = columns a1 \<longrightarrow> (\<forall>(i :: 63 word) (j :: 63 word). ((0 :: int) \<le> sint i \<and> sint i \<le> sint n) \<and> (0 :: int) \<le> sint j \<and> sint j < sint m \<longrightarrow> (\<not>sint n \<le> sint i \<longrightarrow> (let o1 :: coeff = czero in valid_index a2 i j \<and> (let o2 :: coeff = get_unsafe a2 (sint i) (sint j) in (eq o2 o1 \<longrightarrow> (\<forall>(y :: cvars). interp o2 y = interp o1 y)) \<longrightarrow> eq o2 o1 \<longrightarrow> int'63_in_bounds (sint i + (1 :: int)) \<and> (\<forall>(o3 :: 63 word). sint o3 = sint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint n - sint i \<and> sint n - sint o3 < sint n - sint i) \<and> ((0 :: int) \<le> sint o3 \<and> sint o3 \<le> sint n) \<and> (0 :: int) \<le> sint j \<and> sint j < sint m)))) \<and> (\<forall>(result :: 63 word). (if sint n \<le> sint i then result = n else let o1 :: coeff = czero; o2 :: coeff = get_unsafe a2 (sint i) (sint j) in (eq o2 o1 \<longrightarrow> (\<forall>(y :: cvars). interp o2 y = interp o1 y)) \<and> (if eq o2 o1 then \<exists>(o3 :: 63 word). sint o3 = sint i + (1 :: int) \<and> (sint o3 \<le> sint result \<and> sint result \<le> sint n) \<and> (sint result < sint n \<longrightarrow> \<not>eq (elts a2 (sint result) (sint j)) czero) else result = i)) \<longrightarrow> (sint i \<le> sint result \<and> sint result \<le> sint n) \<and> (sint result < sint n \<longrightarrow> \<not>eq (elts a2 (sint result) (sint j)) czero)))) \<and> (0 :: int) \<le> sint n \<and> (\<forall>(pivots :: 63 word array63). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint n \<longrightarrow> array63_elts pivots ! nat i = (0 :: 63 word)) \<and> array63_length pivots = n \<longrightarrow> int'63_in_bounds (sint m - (2 :: int)) \<and> (\<forall>(o1 :: 63 word). sint o1 = sint m - (2 :: int) \<longrightarrow> ((0 :: int) \<le> sint o1 + (1 :: int) \<longrightarrow> ((-(1 :: int) \<le> -(1 :: int) \<and> -(1 :: int) < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> -(1 :: int) \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> -(1 :: int) \<longrightarrow> sint (array63_elts pivots ! nat i1) < sint (array63_elts pivots ! nat i2)) \<and> ((0 :: int) \<le> -(1 :: int) \<longrightarrow> sint (array63_elts pivots ! nat (-(1 :: int))) < (0 :: int))) \<and> (\<forall>(r :: 63 word) (pivots1 :: 63 word array63) (a2 :: coeff matrix). array63_length pivots1 = array63_length pivots \<longrightarrow> rows a2 = rows a1 \<and> columns a2 = columns a1 \<longrightarrow> (\<forall>(j :: 63 word). let j1 :: int = sint j in ((0 :: int) \<le> j1 \<and> j1 \<le> sint o1) \<and> (-(1 :: int) \<le> sint r \<and> sint r < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint r \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots1 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint r \<longrightarrow> sint (array63_elts pivots1 ! nat i1) < sint (array63_elts pivots1 ! nat i2)) \<and> ((0 :: int) \<le> sint r \<longrightarrow> sint (array63_elts pivots1 ! nat (sint r)) < j1) \<longrightarrow> int'63_in_bounds (sint r + (1 :: int)) \<and> (\<forall>(o2 :: 63 word). sint o2 = sint r + (1 :: int) \<longrightarrow> (((0 :: int) \<le> sint o2 \<and> sint o2 \<le> sint n) \<and> (0 :: int) \<le> sint j \<and> sint j < sint m) \<and> (\<forall>(k :: 63 word). (sint o2 \<le> sint k \<and> sint k \<le> sint n) \<and> (sint k < sint n \<longrightarrow> \<not>eq (elts a2 (sint k) (sint j)) czero) \<longrightarrow> (if sint k < sint n then int'63_in_bounds (sint r + (1 :: int)) \<and> (\<forall>(o3 :: 63 word). sint o3 = sint r + (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint o3 \<and> sint o3 < sint (array63_length pivots1)) \<and> (\<forall>(pivots2 :: 63 word array63). array63_length pivots2 = array63_length pivots1 \<longrightarrow> array63_elts pivots2 = (array63_elts pivots1)[nat (sint o3) := j] \<longrightarrow> valid_index a2 k j \<and> \<not>eq (get_unsafe a2 (sint k) (sint j)) czero \<and> (\<forall>(o4 :: coeff). \<not>eq o4 czero \<longrightarrow> (((0 :: int) \<le> sint k \<and> sint k < sint (rows a2)) \<and> \<not>eq o4 czero) \<and> (\<forall>(a3 :: coeff matrix). rows a3 = rows a2 \<and> columns a3 = columns a2 \<longrightarrow> (sint k = sint o3 \<longrightarrow> k = o3) \<longrightarrow> (if \<not>k = o3 then (((0 :: int) \<le> sint k \<and> sint k < sint (rows a3)) \<and> (0 :: int) \<le> sint o3 \<and> sint o3 < sint (rows a3)) \<and> (\<forall>(a4 :: coeff matrix). rows a4 = rows a3 \<and> columns a4 = columns a3 \<longrightarrow> int'63_in_bounds (sint n - (1 :: int)) \<and> (\<forall>(o5 :: 63 word). sint o5 = sint n - (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint o5 + (1 :: int) \<longrightarrow> (\<forall>(a5 :: coeff matrix). rows a5 = rows a4 \<and> columns a5 = columns a4 \<longrightarrow> (\<forall>(i :: 63 word). let i1 :: int = sint i in (0 :: int) \<le> i1 \<and> i1 \<le> sint o5 \<longrightarrow> (sint i = sint o3 \<longrightarrow> i = o3) \<longrightarrow> \<not>i = o3 \<longrightarrow> valid_index a5 i j \<and> (\<forall>(o6 :: coeff). (\<forall>(v :: cvars). interp o6 v = prefix_mn (interp (get_unsafe a5 (sint i) (sint j)) v)) \<longrightarrow> ((0 :: int) \<le> sint o3 \<and> sint o3 < sint (rows a5)) \<and> (0 :: int) \<le> sint i \<and> sint i < sint (rows a5))) \<and> (-(1 :: int) \<le> sint o3 \<and> sint o3 < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint o3 \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots2 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat i1) < sint (array63_elts pivots2 ! nat i2)) \<and> ((0 :: int) \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat (sint o3)) < j1 + (1 :: int)))) \<and> (sint o5 + (1 :: int) < (0 :: int) \<longrightarrow> (-(1 :: int) \<le> sint o3 \<and> sint o3 < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint o3 \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots2 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat i1) < sint (array63_elts pivots2 ! nat i2)) \<and> ((0 :: int) \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat (sint o3)) < j1 + (1 :: int))))) else int'63_in_bounds (sint n - (1 :: int)) \<and> (\<forall>(o5 :: 63 word). sint o5 = sint n - (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint o5 + (1 :: int) \<longrightarrow> (\<forall>(a4 :: coeff matrix). rows a4 = rows a3 \<and> columns a4 = columns a3 \<longrightarrow> (\<forall>(i :: 63 word). let i1 :: int = sint i in (0 :: int) \<le> i1 \<and> i1 \<le> sint o5 \<longrightarrow> (sint i = sint o3 \<longrightarrow> i = o3) \<longrightarrow> \<not>i = o3 \<longrightarrow> valid_index a4 i j \<and> (\<forall>(o6 :: coeff). (\<forall>(v :: cvars). interp o6 v = prefix_mn (interp (get_unsafe a4 (sint i) (sint j)) v)) \<longrightarrow> ((0 :: int) \<le> sint o3 \<and> sint o3 < sint (rows a4)) \<and> (0 :: int) \<le> sint i \<and> sint i < sint (rows a4))) \<and> (-(1 :: int) \<le> sint o3 \<and> sint o3 < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint o3 \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots2 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat i1) < sint (array63_elts pivots2 ! nat i2)) \<and> ((0 :: int) \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat (sint o3)) < j1 + (1 :: int)))) \<and> (sint o5 + (1 :: int) < (0 :: int) \<longrightarrow> (-(1 :: int) \<le> sint o3 \<and> sint o3 < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint o3 \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots2 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat i1) < sint (array63_elts pivots2 ! nat i2)) \<and> ((0 :: int) \<le> sint o3 \<longrightarrow> sint (array63_elts pivots2 ! nat (sint o3)) < j1 + (1 :: int))))))))) else (-(1 :: int) \<le> sint r \<and> sint r < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint r \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots1 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint r \<longrightarrow> sint (array63_elts pivots1 ! nat i1) < sint (array63_elts pivots1 ! nat i2)) \<and> ((0 :: int) \<le> sint r \<longrightarrow> sint (array63_elts pivots1 ! nat (sint r)) < j1 + (1 :: int)))))) \<and> ((-(1 :: int) \<le> sint r \<and> sint r < sint n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i \<le> sint r \<longrightarrow> (0 :: int) \<le> sint (array63_elts pivots1 ! nat i)) \<and> (\<forall>(i1 :: int) (i2 :: int). (0 :: int) \<le> i1 \<and> i1 < i2 \<and> i2 \<le> sint r \<longrightarrow> sint (array63_elts pivots1 ! nat i1) < sint (array63_elts pivots1 ! nat i2)) \<and> ((0 :: int) \<le> sint r \<longrightarrow> sint (array63_elts pivots1 ! nat (sint r)) < sint o1 + (1 :: int)) \<longrightarrow> \<not>sint r < (0 :: int) \<longrightarrow> (0 :: int) \<le> sint m \<and> (\<forall>(v :: coeff array63). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint m \<longrightarrow> array63_elts v ! nat i = czero) \<and> array63_length v = m \<longrightarrow> ((0 :: int) \<le> sint r + (1 :: int) \<longrightarrow> (\<forall>(v1 :: coeff array63). array63_length v1 = array63_length v \<longrightarrow> (\<forall>(i :: 63 word). let i1 :: int = sint i in (0 :: int) \<le> i1 \<and> i1 \<le> sint r \<longrightarrow> int'63_in_bounds (sint m - (1 :: int)) \<and> (\<forall>(o2 :: 63 word). sint o2 = sint m - (1 :: int) \<longrightarrow> valid_index a2 i o2 \<and> ((0 :: int) \<le> sint i \<and> sint i < sint (array63_length pivots1)) \<and> (let o3 :: 63 word = array63_elts pivots1 ! nat (sint i) in (0 :: int) \<le> sint o3 \<and> sint o3 < sint (array63_length v1)))) \<and> array63_length v1 = columns a2)) \<and> (sint r + (1 :: int) < (0 :: int) \<longrightarrow> array63_length v = columns a2))))) \<and> (sint o1 + (1 :: int) < (0 :: int) \<longrightarrow> \<not>-(1 :: int) < (0 :: int) \<longrightarrow> (0 :: int) \<le> sint m \<and> (\<forall>(v :: coeff array63). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint m \<longrightarrow> array63_elts v ! nat i = czero) \<and> array63_length v = m \<longrightarrow> ((0 :: int) \<le> -(1 :: int) + (1 :: int) \<longrightarrow> (\<forall>(v1 :: coeff array63). array63_length v1 = array63_length v \<longrightarrow> (\<forall>(i :: 63 word). let i1 :: int = sint i in (0 :: int) \<le> i1 \<and> i1 \<le> -(1 :: int) \<longrightarrow> int'63_in_bounds (sint m - (1 :: int)) \<and> (\<forall>(o2 :: 63 word). sint o2 = sint m - (1 :: int) \<longrightarrow> valid_index a1 i o2 \<and> ((0 :: int) \<le> sint i \<and> sint i < sint (array63_length pivots)) \<and> (let o3 :: 63 word = array63_elts pivots ! nat (sint i) in (0 :: int) \<le> sint o3 \<and> sint o3 < sint (array63_length v1)))) \<and> array63_length v1 = columns a1)) \<and> (-(1 :: int) + (1 :: int) < (0 :: int) \<longrightarrow> array63_length v = columns a1)))))"
  sorry
end
