theory lineardecision_LinearEquationsDecision_linear_decisionqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "mach.matrix_Matrix63" "Why3STD.debug_Debug"
begin
typedecl  coeff
typedecl  a
consts infix_pl :: "a \<Rightarrow> a \<Rightarrow> a"
consts infix_as :: "a \<Rightarrow> a \<Rightarrow> a"
consts prefix_mn :: "a \<Rightarrow> a"
consts azero :: "a"
consts aone :: "a"
consts ale :: "a \<Rightarrow> a \<Rightarrow> bool"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Unit_def_l:   "infix_pl azero x = x"
  for x :: "a"
axiomatization where Unit_def_r:   "infix_pl x azero = x"
  for x :: "a"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = azero"
  for x :: "a"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = azero"
  for x :: "a"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "a"
  and y :: "a"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "a"
  and z :: "a"
  and x :: "a"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "a"
  and y :: "a"
axiomatization where Unitary:   "infix_as aone x = x"
  for x :: "a"
axiomatization where NonTrivialRing:   "\<not>azero = aone"
axiomatization where Refl:   "ale x x"
  for x :: "a"
axiomatization where Trans:   "ale x z"
 if "ale x y"
 and "ale y z"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Antisymm:   "x = y"
 if "ale x y"
 and "ale y x"
  for x :: "a"
  and y :: "a"
axiomatization where Total:   "ale x y \<or> ale y x"
  for x :: "a"
  and y :: "a"
axiomatization where ZeroLessOne:   "ale azero aone"
axiomatization where CompatOrderAdd:   "ale (infix_pl x z) (infix_pl y z)"
 if "ale x y"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where CompatOrderMult:   "ale (infix_as x z) (infix_as y z)"
 if "ale x y"
 and "ale azero z"
  for x :: "a"
  and y :: "a"
  and z :: "a"
consts infix_mn :: "a \<Rightarrow> a \<Rightarrow> a"
axiomatization where sub_def:   "infix_mn a1 a2 = infix_pl a1 (prefix_mn a2)"
  for a1 :: "a"
  and a2 :: "a"
typedecl  vars
typedecl  cvars
consts interp :: "coeff \<Rightarrow> cvars \<Rightarrow> a"
consts czero :: "coeff"
consts cone :: "coeff"
axiomatization where zero_def:   "interp czero y = azero"
  for y :: "cvars"
axiomatization where one_def:   "interp cone y = aone"
  for y :: "cvars"
consts eq :: "coeff \<Rightarrow> coeff \<Rightarrow> bool"
axiomatization where eq'spec:   "interp a1 y = interp b y"
 if "eq a1 b"
  for a1 :: "coeff"
  and b :: "coeff"
  and y :: "cvars"
typedecl  vars1
datatype  expr = Term "coeff" "int" | Add "expr" "expr" | Cst "coeff"
fun valid_expr :: "expr \<Rightarrow> _"
  where "valid_expr (Term x i) = ((0 :: int) \<le> i)" for x i
      | "valid_expr (Cst x) = True" for x
      | "valid_expr (Add e1 e2) = (valid_expr e1 \<and> valid_expr e2)" for e1 e2
fun expr_bound :: "expr \<Rightarrow> int \<Rightarrow> _"
  where "expr_bound (Term x i) b = ((0 :: int) \<le> i \<and> i \<le> b)" for x i b
      | "expr_bound (Cst x) b = True" for x b
      | "expr_bound (Add e1 e2) b = (expr_bound e1 b \<and> expr_bound e2 b)" for e1 e2 b
fun interp1 :: "expr \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> cvars \<Rightarrow> a"
  where "interp1 (Term c v) y z = infix_as (interp c z) (y v)" for c v y z
      | "interp1 (Add e1 e2) y z = infix_pl (interp1 e1 y z) (interp1 e2 y z)" for e1 e2 y z
      | "interp1 (Cst c) y z = interp c z" for c y z
typedecl  equality
typedecl  "context"
definition valid_eq :: "expr \<times> expr \<Rightarrow> _"
  where "valid_eq eq1 \<longleftrightarrow> (case eq1 of (e1, e2) \<Rightarrow> valid_expr e1 \<and> valid_expr e2)" for eq1
definition eq_bound :: "expr \<times> expr \<Rightarrow> int \<Rightarrow> _"
  where "eq_bound eq1 b \<longleftrightarrow> (case eq1 of (e1, e2) \<Rightarrow> expr_bound e1 b \<and> expr_bound e2 b)" for eq1 b
fun valid_ctx :: "(expr \<times> expr) list \<Rightarrow> _"
  where "valid_ctx (Nil :: (expr \<times> expr) list) = True"
      | "valid_ctx (Cons eq1 t) = (valid_eq eq1 \<and> valid_ctx t)" for eq1 t
fun ctx_bound :: "(expr \<times> expr) list \<Rightarrow> int \<Rightarrow> _"
  where "ctx_bound (Nil :: (expr \<times> expr) list) b = True" for b
      | "ctx_bound (Cons eq1 t) b = (eq_bound eq1 b \<and> ctx_bound t b)" for eq1 t b
definition interp_eq :: "expr \<times> expr \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> cvars \<Rightarrow> bool"
  where "interp_eq g y z = (if case g of (g1, g2) \<Rightarrow> interp1 g1 y z = interp1 g2 y z then True else False)" for g y z
fun interp_ctx :: "(expr \<times> expr) list \<Rightarrow> expr \<times> expr \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> cvars \<Rightarrow> bool"
  where "interp_ctx l g y z = (if case l of Nil \<Rightarrow> interp_eq g y z = True | Cons h t \<Rightarrow> interp_eq h y z = True \<longrightarrow> interp_ctx t g y z = True then True else False)" for l g y z
consts infix_eqeq :: "coeff array63 \<Rightarrow> coeff array63 \<Rightarrow> bool"
axiomatization where infix_eqeq'spec'0:   "array63_length a1 = array63_length b"
 if "infix_eqeq a1 b"
  for a1 :: "coeff array63"
  and b :: "coeff array63"
axiomatization where infix_eqeq'spec'1:   "\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (array63_length a1) \<longrightarrow> eq (array63_elts a1 ! nat i) (array63_elts b ! nat i)"
 if "infix_eqeq a1 b"
  for a1 :: "coeff array63"
  and b :: "coeff array63"
consts max_var :: "expr \<Rightarrow> int"
axiomatization where max_var'def:   "case e of Term _ i \<Rightarrow> max_var e = i | Cst _ \<Rightarrow> max_var e = (0 :: int) | Add e1 e2 \<Rightarrow> max_var e = max (max_var e1) (max_var e2)"
 if "valid_expr e"
  for e :: "expr"
axiomatization where max_var'spec'0:   "(0 :: int) \<le> max_var e"
 if "valid_expr e"
  for e :: "expr"
axiomatization where max_var'spec:   "expr_bound e (max_var e)"
 if "valid_expr e"
  for e :: "expr"
consts max_var_e :: "expr \<times> expr \<Rightarrow> int"
axiomatization where max_var_e'def:   "case e of (e1, e2) \<Rightarrow> max_var_e e = max (max_var e1) (max_var e2)"
 if "valid_eq e"
  for e :: "expr \<times> expr"
axiomatization where max_var_e'spec'0:   "(0 :: int) \<le> max_var_e e"
 if "valid_eq e"
  for e :: "expr \<times> expr"
axiomatization where max_var_e'spec:   "eq_bound e (max_var_e e)"
 if "valid_eq e"
  for e :: "expr \<times> expr"
consts max_var_ctx :: "(expr \<times> expr) list \<Rightarrow> int"
axiomatization where max_var_ctx'def:   "case l of Nil \<Rightarrow> max_var_ctx l = (0 :: int) | Cons e t \<Rightarrow> max_var_ctx l = max (max_var_e e) (max_var_ctx t)"
 if "valid_ctx l"
  for l :: "(expr \<times> expr) list"
axiomatization where max_var_ctx'spec'0:   "(0 :: int) \<le> max_var_ctx l"
 if "valid_ctx l"
  for l :: "(expr \<times> expr) list"
axiomatization where max_var_ctx'spec:   "ctx_bound l (max_var_ctx l)"
 if "valid_ctx l"
  for l :: "(expr \<times> expr) list"
definition atom :: "expr \<Rightarrow> _"
  where "atom e \<longleftrightarrow> (case e of Add _ _ \<Rightarrow> False | _ \<Rightarrow> True)" for e
consts to_list :: "'a array63 \<Rightarrow> 63 word \<Rightarrow> 63 word \<Rightarrow> 'a list"
theorem linear_decision'vc:
  fixes g :: "expr"
  fixes g1 :: "expr"
  fixes l :: "(expr \<times> expr) list"
  shows "let g2 :: expr \<times> expr = (g, g1) in valid_ctx l \<and> valid_eq g2 \<and> int (length l) < (100000 :: int) \<longrightarrow> valid_ctx l \<and> (let o1 :: int = max_var_ctx l in (0 :: int) \<le> o1 \<and> ctx_bound l o1 \<longrightarrow> valid_eq g2 \<and> (let o2 :: int = max_var_e g2 in (0 :: int) \<le> o2 \<and> eq_bound g2 o2 \<longrightarrow> (let nv :: int = max o2 o1 in (\<not>(100000 :: int) \<le> nv \<longrightarrow> nv < (100000 :: int)) \<and> (nv < (100000 :: int) \<longrightarrow> int'63_in_bounds nv \<and> (\<forall>(nv1 :: 63 word). sint nv1 = nv \<longrightarrow> (let o3 :: int = int (length l) in int'63_in_bounds o3 \<and> (\<forall>(ll :: 63 word). sint ll = o3 \<longrightarrow> int'63_in_bounds (sint nv1 + (1 :: int)) \<and> (\<forall>(o4 :: 63 word). sint o4 = sint nv1 + (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint ll \<and> (0 :: int) \<le> sint o4) \<and> (\<forall>(a1 :: coeff matrix). rows a1 = ll \<and> columns a1 = o4 \<and> (\<forall>(i :: int) (j :: int). ((0 :: int) \<le> i \<and> i < sint ll) \<and> (0 :: int) \<le> j \<and> j < sint o4 \<longrightarrow> get_unsafe a1 i j = czero) \<longrightarrow> (0 :: int) \<le> sint ll \<and> (\<forall>(b :: coeff array63). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint ll \<longrightarrow> array63_elts b ! nat i = czero) \<and> array63_length b = ll \<longrightarrow> int'63_in_bounds (sint nv1 + (1 :: int)) \<and> (\<forall>(o5 :: 63 word). sint o5 = sint nv1 + (1 :: int) \<longrightarrow> (0 :: int) \<le> sint o5 \<and> (\<forall>(v :: coeff array63). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint o5 \<longrightarrow> array63_elts v ! nat i = czero) \<and> array63_length v = o5 \<longrightarrow> (\<forall>(a2 :: coeff matrix). rows a2 = rows a1 \<and> columns a2 = columns a1 \<longrightarrow> (\<forall>(ex :: expr) (i :: 63 word). ((0 :: int) \<le> sint i \<and> sint i < int (length l)) \<and> expr_bound ex (sint nv1) \<longrightarrow> (case ex of Cst c \<Rightarrow> True | Term c j \<Rightarrow> int'63_in_bounds j \<and> (\<forall>(j1 :: 63 word). sint j1 = j \<longrightarrow> valid_index a2 i j1 \<and> (\<forall>(o6 :: coeff). (\<forall>(v1 :: cvars). interp o6 v1 = infix_pl (interp (get_unsafe a2 (sint i) (sint j1)) v1) (interp c v1)) \<longrightarrow> valid_index a2 i j1)) | Add e1 e2 \<Rightarrow> ((case ex of Term _ _ \<Rightarrow> False | Add f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Cst _ \<Rightarrow> False) \<and> ((0 :: int) \<le> sint i \<and> sint i < int (length l)) \<and> expr_bound e1 (sint nv1)) \<and> (case ex of Term _ _ \<Rightarrow> False | Add f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Cst _ \<Rightarrow> False) \<and> ((0 :: int) \<le> sint i \<and> sint i < int (length l)) \<and> expr_bound e2 (sint nv1)))) \<and> (\<forall>(b1 :: coeff array63). array63_length b1 = array63_length b \<longrightarrow> (\<forall>(ctx :: (expr \<times> expr) list) (i :: 63 word). ctx_bound ctx (sint nv1) \<and> int (length l) - sint i = int (length ctx) \<and> (0 :: int) \<le> sint i \<and> sint i \<le> int (length l) \<longrightarrow> (case ctx of Nil \<Rightarrow> True | Cons e t \<Rightarrow> (\<forall>(ex :: expr) (c :: coeff). (\<forall>(y :: int \<Rightarrow> a) (z :: cvars). interp_eq e y z = True \<longleftrightarrow> interp_eq (ex, Cst c) y z = True) \<and> (\<forall>(b2 :: int). eq_bound e b2 \<longrightarrow> expr_bound ex b2) \<longrightarrow> (let o6 :: coeff = czero in (eq c o6 \<longrightarrow> (\<forall>(y :: cvars). interp c y = interp o6 y)) \<longrightarrow> (if \<not>eq c o6 then ((0 :: int) \<le> sint i \<and> sint i < sint (array63_length b1)) \<and> (\<forall>(o7 :: coeff). (\<forall>(v1 :: cvars). interp o7 v1 = infix_pl (interp (array63_elts b1 ! nat (sint i)) v1) (interp c v1)) \<longrightarrow> ((0 :: int) \<le> sint i \<and> sint i < sint (array63_length b1)) \<and> (\<forall>(b2 :: coeff array63). array63_length b2 = array63_length b1 \<longrightarrow> array63_elts b2 = (array63_elts b1)[nat (sint i) := o7] \<longrightarrow> (((0 :: int) \<le> sint i \<and> sint i < int (length l)) \<and> expr_bound ex (sint nv1)) \<and> int'63_in_bounds (sint i + (1 :: int)) \<and> (\<forall>(o8 :: 63 word). sint o8 = sint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> int (length l) - sint i \<and> int (length l) - sint o8 < int (length l) - sint i) \<and> ctx_bound t (sint nv1) \<and> int (length l) - sint o8 = int (length t) \<and> (0 :: int) \<le> sint o8 \<and> sint o8 \<le> int (length l)))) \<and> int'63_in_bounds (sint i + (1 :: int)) \<and> (\<forall>(o7 :: 63 word). sint o7 = sint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> int (length l) - sint i \<and> int (length l) - sint o7 < int (length l) - sint i) \<and> ctx_bound t (sint nv1) \<and> int (length l) - sint o7 = int (length t) \<and> (0 :: int) \<le> sint o7 \<and> sint o7 \<le> int (length l)) else (((0 :: int) \<le> sint i \<and> sint i < int (length l)) \<and> expr_bound ex (sint nv1)) \<and> int'63_in_bounds (sint i + (1 :: int)) \<and> (\<forall>(o7 :: 63 word). sint o7 = sint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> int (length l) - sint i \<and> int (length l) - sint o7 < int (length l) - sint i) \<and> ctx_bound t (sint nv1) \<and> int (length l) - sint o7 = int (length t) \<and> (0 :: int) \<le> sint o7 \<and> sint o7 \<le> int (length l))))) \<and> int'63_in_bounds (sint i + (1 :: int)) \<and> (\<forall>(o6 :: 63 word). sint o6 = sint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> int (length l) - sint i \<and> int (length l) - sint o6 < int (length l) - sint i) \<and> ctx_bound t (sint nv1) \<and> int (length l) - sint o6 = int (length t) \<and> (0 :: int) \<le> sint o6 \<and> sint o6 \<le> int (length l))))) \<and> (\<forall>(v1 :: coeff array63). array63_length v1 = array63_length v \<longrightarrow> (\<forall>(ex :: expr). expr_bound ex (sint nv1) \<longrightarrow> (case ex of Cst c \<Rightarrow> True | Term c j \<Rightarrow> int'63_in_bounds j \<and> (\<forall>(j1 :: 63 word). sint j1 = j \<longrightarrow> ((0 :: int) \<le> sint j1 \<and> sint j1 < sint (array63_length v1)) \<and> (\<forall>(o6 :: coeff). (\<forall>(v2 :: cvars). interp o6 v2 = infix_pl (interp (array63_elts v1 ! nat (sint j1)) v2) (interp c v2)) \<longrightarrow> (0 :: int) \<le> sint j1 \<and> sint j1 < sint (array63_length v1))) | Add e1 e2 \<Rightarrow> ((case ex of Term _ _ \<Rightarrow> False | Add f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Cst _ \<Rightarrow> False) \<and> expr_bound e1 (sint nv1)) \<and> (case ex of Term _ _ \<Rightarrow> False | Add f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Cst _ \<Rightarrow> False) \<and> expr_bound e2 (sint nv1)))) \<and> (ctx_bound l (sint nv1) \<and> int (length l) - (0 :: int) = int (length l) \<and> (0 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> int (length l)) \<and> (\<forall>(b1 :: coeff array63) (a2 :: coeff matrix). array63_length b1 = array63_length b \<longrightarrow> rows a2 = rows a1 \<and> columns a2 = columns a1 \<longrightarrow> (\<forall>(ex :: expr) (d :: coeff). (\<forall>(y :: int \<Rightarrow> a) (z :: cvars). interp_eq g2 y z = True \<longleftrightarrow> interp_eq (ex, Cst d) y z = True) \<and> (\<forall>(b2 :: int). eq_bound g2 b2 \<longrightarrow> expr_bound ex b2) \<longrightarrow> expr_bound ex (sint nv1) \<and> (\<forall>(v1 :: coeff array63). array63_length v1 = array63_length v \<longrightarrow> (rows a2 = array63_length b1 \<and> sint (columns a2) < (4611686018427387903 :: int)) \<and> (\<forall>(ab :: coeff matrix). rows ab = rows a2 \<and> sint (columns ab) = sint (columns a2) + (1 :: int) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < sint (rows a2) \<longrightarrow> (0 :: int) \<le> j \<and> j < sint (columns a2) \<longrightarrow> elts ab i j = elts a2 i j) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (rows a2) \<longrightarrow> elts ab i (sint (columns a2)) = array63_elts b1 ! nat i) \<longrightarrow> sint (array63_length v1) < (4611686018427387903 :: int) \<and> (\<forall>(cd :: coeff array63). sint (array63_length cd) = sint (array63_length v1) + (1 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < sint (array63_length v1) \<longrightarrow> array63_elts cd ! nat k = array63_elts v1 ! nat k) \<and> array63_elts cd ! nat (sint (array63_length v1)) = d \<longrightarrow> (\<forall>(ab' :: coeff matrix). rows ab' = columns ab \<and> columns ab' = rows ab \<longrightarrow> (rows ab' = array63_length cd \<and> sint (columns ab') < (4611686018427387903 :: int)) \<and> (\<forall>(o6 :: coeff matrix). rows o6 = rows ab' \<and> sint (columns o6) = sint (columns ab') + (1 :: int) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < sint (rows ab') \<longrightarrow> (0 :: int) \<le> j \<and> j < sint (columns ab') \<longrightarrow> elts o6 i j = elts ab' i j) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (rows ab') \<longrightarrow> elts o6 i (sint (columns ab')) = array63_elts cd ! nat i) \<longrightarrow> ((1 :: int) \<le> sint (rows o6) \<and> (1 :: int) \<le> sint (columns o6)) \<and> (\<forall>(o7 :: coeff matrix). rows o7 = rows o6 \<and> columns o7 = columns o6 \<longrightarrow> (\<forall>(o8 :: coeff array63 option). (case o8 of Some r \<Rightarrow> array63_length r = columns o7 | None \<Rightarrow> True) \<longrightarrow> (case o8 of Some r \<Rightarrow> ((0 :: int) \<le> (0 :: int) \<and> sint ll \<le> sint (array63_length r)) \<and> ((\<forall>(y :: int \<Rightarrow> a) (z :: cvars). interp_ctx l g2 y z = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> a) (z :: cvars). interp_ctx l g2 y z = True)) | None \<Rightarrow> True))))))))))))))))))))))"
  sorry
end
