theory lineardecision_MP64Coeffs_add_sub_expqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.debug_Debug" "../../lib/isabelle/lineardecision_RationalCoeffs"
begin
typedecl  evars
datatype  exp = Lit "int" | Var "int" | Plus "exp" "exp" | Minus "exp" | Sub "exp" "exp"
typedecl  t
definition qinterp :: "int \<times> int \<Rightarrow> real"
  where "qinterp q = (case q of (n, d) \<Rightarrow> real_of_int n / real_of_int d)" for q
fun interp_exp :: "exp \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> int"
  where "interp_exp (Lit n) y = n" for n y
      | "interp_exp (Var v) y = y v" for v y
      | "interp_exp (Plus e1 e2) y = interp_exp e1 y + interp_exp e2 y" for e1 e2 y
      | "interp_exp (Sub e1 e2) y = interp_exp e1 y - interp_exp e2 y" for e1 e2 y
      | "interp_exp (Minus e') y = -interp_exp e' y" for e' y
definition minterp :: "(int \<times> int) \<times> exp \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> real"
  where "minterp t1 y = (case t1 of (q, e) \<Rightarrow> qinterp q * real_of_int ((18446744073709551615 :: int) + (1 :: int)) powr real_of_int (interp_exp e y))" for t1 y
theorem add_sub_exp'vc:
  fixes e2 :: "exp"
  fixes s :: "bool"
  fixes e1 :: "exp"
  shows "\<forall>(e :: exp) (a :: exp) (s :: bool). (case a of Lit x \<Rightarrow> (case e of Lit x1 \<Rightarrow> (\<forall>(o1 :: exp). (if s = True then o1 = Lit (x1 + x) else o1 = Lit (x1 - x)) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) | Var x1 \<Rightarrow> (\<forall>(r :: exp) (result :: bool). (if x = (0 :: int) then r = Var x1 \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Minus x1 \<Rightarrow> (\<forall>(r :: exp) (result :: bool). (if x = (0 :: int) then r = Minus x1 \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Plus x1 x2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then r1 = x2 \<and> result = True else r1 = Plus r x2 \<and> result = True) | _ \<Rightarrow> r1 = Plus r x2 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp (Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | Sub x1 x2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then (\<forall>(y :: int \<Rightarrow> int). interp_exp r1 y = -interp_exp x2 y) \<and> result = True else r1 = Sub r x2 \<and> result = True) | _ \<Rightarrow> r1 = Sub r x2 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (\<forall>(r2 :: exp) (result :: bool). (if b1 = True then r2 = Sub x1 r1 \<and> result = True else if s = True then r2 = Sub (Plus x1 a) x2 \<and> result = False else r2 = Sub x1 (Plus x2 a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y)))))) | Var x \<Rightarrow> (case e of Lit x1 \<Rightarrow> (\<forall>(r :: exp) (result :: bool). (if x1 = (0 :: int) then (if s = True then r = Var x else r = Minus (Var x)) \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Minus x1 \<Rightarrow> (case x1 of Var x2 \<Rightarrow> (\<forall>(o1 :: bool). (if s = True then o1 = (if x = x2 then True else False) else o1 = False) \<longrightarrow> (\<forall>(r :: exp) (result :: bool). (if o1 = True then r = Lit (0 :: int) \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | _ \<Rightarrow> True) | Var x1 \<Rightarrow> (\<forall>(r :: exp) (result :: bool). (if s = True then r = Plus e a \<and> result = False else if x1 = x then r = Lit (0 :: int) \<and> result = True else r = Sub e a \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Plus x1 x2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then r1 = x2 \<and> result = True else r1 = Plus r x2 \<and> result = True) | _ \<Rightarrow> r1 = Plus r x2 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp (Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | Sub x1 x2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then (\<forall>(y :: int \<Rightarrow> int). interp_exp r1 y = -interp_exp x2 y) \<and> result = True else r1 = Sub r x2 \<and> result = True) | _ \<Rightarrow> r1 = Sub r x2 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (\<forall>(r2 :: exp) (result :: bool). (if b1 = True then r2 = Sub x1 r1 \<and> result = True else if s = True then r2 = Sub (Plus x1 a) x2 \<and> result = False else r2 = Sub x1 (Plus x2 a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y)))))) | Minus x \<Rightarrow> (case x of Var x1 \<Rightarrow> (case e of Lit x2 \<Rightarrow> (\<forall>(r :: exp) (result :: bool). (if x2 = (0 :: int) then (if s = True then r = Minus x else r = x) \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Var x2 \<Rightarrow> (\<forall>(o1 :: bool). (if s = True then o1 = (if x2 = x1 then True else False) else o1 = False) \<longrightarrow> (\<forall>(r :: exp) (result :: bool). (if o1 = True then r = Lit (0 :: int) \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | Minus x2 \<Rightarrow> (case x2 of Var x3 \<Rightarrow> (\<forall>(o1 :: bool). (if \<not>s = True then o1 = (if x3 = x1 then True else False) else o1 = False) \<longrightarrow> (\<forall>(r :: exp) (result :: bool). (if o1 = True then r = Lit (0 :: int) \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | _ \<Rightarrow> (\<forall>(o1 :: exp). (if s = True then o1 = Plus e a else o1 = Sub e a) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y))) | Plus x2 x3 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x2 y + interp_exp a y else interp_exp r y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then r1 = x3 \<and> result = True else r1 = Plus r x3 \<and> result = True) | _ \<Rightarrow> r1 = Plus r x3 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x3 \<or> f1 = x3 | Minus f \<Rightarrow> f = x3 | Sub f f1 \<Rightarrow> f = x3 \<or> f1 = x3) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp x3 y + interp_exp a y else interp_exp r1 y = interp_exp x3 y - interp_exp a y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp (Plus x2 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x2 r1) y = interp_exp e y - interp_exp a y)))) | Sub x2 x3 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x2 y + interp_exp a y else interp_exp r y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then (\<forall>(y :: int \<Rightarrow> int). interp_exp r1 y = -interp_exp x3 y) \<and> result = True else r1 = Sub r x3 \<and> result = True) | _ \<Rightarrow> r1 = Sub r x3 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x3 \<or> f1 = x3 | Minus f \<Rightarrow> f = x3 | Sub f f1 \<Rightarrow> f = x3 \<or> f1 = x3) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp r1 y = interp_exp x3 y + interp_exp a y else interp_exp r1 y = interp_exp x3 y - interp_exp a y) \<longrightarrow> (\<forall>(r2 :: exp) (result :: bool). (if b1 = True then r2 = Sub x2 r1 \<and> result = True else if s = True then r2 = Sub (Plus x2 a) x3 \<and> result = False else r2 = Sub x2 (Plus x3 a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y)))))) | _ \<Rightarrow> (case e of Lit x1 \<Rightarrow> (\<forall>(r :: exp) (result :: bool). (if x1 = (0 :: int) then (if s = True then r = Minus x else r = x) \<and> result = True else (if s = True then r = Plus e a else r = Sub e a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Minus x1 \<Rightarrow> (\<forall>(o1 :: exp). (if s = True then o1 = Plus e a else o1 = Sub e a) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) | Plus x1 x2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then r1 = x2 \<and> result = True else r1 = Plus r x2 \<and> result = True) | _ \<Rightarrow> r1 = Plus r x2 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp (Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | Sub x1 x2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then (\<forall>(y :: int \<Rightarrow> int). interp_exp r1 y = -interp_exp x2 y) \<and> result = True else r1 = Sub r x2 \<and> result = True) | _ \<Rightarrow> r1 = Sub r x2 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) \<longrightarrow> (\<forall>(r2 :: exp) (result :: bool). (if b1 = True then r2 = Sub x1 r1 \<and> result = True else if s = True then r2 = Sub (Plus x1 a) x2 \<and> result = False else r2 = Sub x1 (Plus x2 a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) | _ \<Rightarrow> True)) | _ \<Rightarrow> (case e of Plus x x1 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x \<or> f1 = x | Minus f \<Rightarrow> f = x | Sub f f1 \<Rightarrow> f = x \<or> f1 = x) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x y + interp_exp a y else interp_exp r y = interp_exp x y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then r1 = x1 \<and> result = True else r1 = Plus r x1 \<and> result = True) | _ \<Rightarrow> r1 = Plus r x1 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp x1 y + interp_exp a y else interp_exp r1 y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp (Plus x r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x r1) y = interp_exp e y - interp_exp a y)))) | Sub x x1 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x \<or> f1 = x | Minus f \<Rightarrow> f = x | Sub f f1 \<Rightarrow> f = x \<or> f1 = x) \<and> (\<forall>(r :: exp) (b :: bool). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp x y + interp_exp a y else interp_exp r y = interp_exp x y - interp_exp a y) \<longrightarrow> (if b = True then (case r of Lit n \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(r1 :: exp) (result :: bool). (case r of Lit n \<Rightarrow> (if n = (0 :: int) then (\<forall>(y :: int \<Rightarrow> int). interp_exp r1 y = -interp_exp x1 y) \<and> result = True else r1 = Sub r x1 \<and> result = True) | _ \<Rightarrow> r1 = Sub r x1 \<and> result = True) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (case e of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<and> (\<forall>(r1 :: exp) (b1 :: bool). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp r1 y = interp_exp x1 y + interp_exp a y else interp_exp r1 y = interp_exp x1 y - interp_exp a y) \<longrightarrow> (\<forall>(r2 :: exp) (result :: bool). (if b1 = True then r2 = Sub x r1 \<and> result = True else if s = True then r2 = Sub (Plus x a) x1 \<and> result = False else r2 = Sub x (Plus x1 a) \<and> result = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) | _ \<Rightarrow> True))"
  and "case e2 of Plus e1' e2' \<Rightarrow> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1' \<or> f1 = e1' | Minus f \<Rightarrow> f = e1' | Sub f f1 \<Rightarrow> f = e1' \<or> f1 = e1') \<and> (\<forall>(r :: exp). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e1 y + interp_exp e1' y else interp_exp r y = interp_exp e1 y - interp_exp e1' y) \<longrightarrow> (case r of Lit n \<Rightarrow> (if n = (0 :: int) then \<forall>(result :: exp). (if s = True then result = e2' else \<forall>(y :: int \<Rightarrow> int). interp_exp result y = -interp_exp e2' y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y) else ((case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2' \<or> f1 = e2' | Minus f \<Rightarrow> f = e2' | Sub f f1 \<Rightarrow> f = e2' \<or> f1 = e2') \<or> e2 = e2' \<and> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = r \<or> f1 = r | Minus f \<Rightarrow> f = r | Sub f f1 \<Rightarrow> f = r \<or> f1 = r)) \<and> (\<forall>(result :: exp). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y))) | _ \<Rightarrow> ((case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2' \<or> f1 = e2' | Minus f \<Rightarrow> f = e2' | Sub f f1 \<Rightarrow> f = e2' \<or> f1 = e2') \<or> e2 = e2' \<and> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = r \<or> f1 = r | Minus f \<Rightarrow> f = r | Sub f f1 \<Rightarrow> f = r \<or> f1 = r)) \<and> (\<forall>(result :: exp). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y)))) | Sub e1' e2' \<Rightarrow> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1' \<or> f1 = e1' | Minus f \<Rightarrow> f = e1' | Sub f f1 \<Rightarrow> f = e1' \<or> f1 = e1') \<and> (\<forall>(r :: exp). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp r y = interp_exp e1 y + interp_exp e1' y else interp_exp r y = interp_exp e1 y - interp_exp e1' y) \<longrightarrow> (case r of Lit n \<Rightarrow> (if n = (0 :: int) then \<forall>(result :: exp). (if s = True then \<forall>(y :: int \<Rightarrow> int). interp_exp result y = -interp_exp e2' y else result = e2') \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y) else ((case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2' \<or> f1 = e2' | Minus f \<Rightarrow> f = e2' | Sub f f1 \<Rightarrow> f = e2' \<or> f1 = e2') \<or> e2 = e2' \<and> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = r \<or> f1 = r | Minus f \<Rightarrow> f = r | Sub f f1 \<Rightarrow> f = r \<or> f1 = r)) \<and> (\<forall>(result :: exp). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y))) | _ \<Rightarrow> ((case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2' \<or> f1 = e2' | Minus f \<Rightarrow> f = e2' | Sub f f1 \<Rightarrow> f = e2' \<or> f1 = e2') \<or> e2 = e2' \<and> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = r \<or> f1 = r | Minus f \<Rightarrow> f = r | Sub f f1 \<Rightarrow> f = r \<or> f1 = r)) \<and> (\<forall>(result :: exp). (\<forall>(y :: int \<Rightarrow> int). if \<not>s = True then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y)))) | _ \<Rightarrow> (\<forall>(o1 :: exp). (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp o1 y = interp_exp e1 y + interp_exp e2 y else interp_exp o1 y = interp_exp e1 y - interp_exp e2 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). if s = True then interp_exp o1 y = interp_exp e1 y + interp_exp e2 y else interp_exp o1 y = interp_exp e1 y - interp_exp e2 y))"
  sorry
end
