theory lineardecision_MP64Coeffs_pure_same_expqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.debug_Debug" "../../lib/isabelle/lineardecision_RationalCoeffs"
begin
typedecl  evars
datatype  exp = Lit "int" | Var "int" | Plus "exp" "exp" | Minus "exp" | Sub "exp" "exp"
typedecl  t
definition qinterp :: "int \<times> int \<Rightarrow> real"
  where "qinterp q = (case q of (n, d) \<Rightarrow> real_of_int n / real_of_int d)" for q
fun interp_exp :: "exp \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> int"
  where "interp_exp (Lit n) y = n" for n y
      | "interp_exp (Var v) y = y v" for v y
      | "interp_exp (Plus e1 e2) y = interp_exp e1 y + interp_exp e2 y" for e1 e2 y
      | "interp_exp (Sub e1 e2) y = interp_exp e1 y - interp_exp e2 y" for e1 e2 y
      | "interp_exp (Minus e') y = -interp_exp e' y" for e' y
definition minterp :: "(int \<times> int) \<times> exp \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> real"
  where "minterp t1 y = (case t1 of (q, e) \<Rightarrow> qinterp q * real_of_int ((18446744073709551615 :: int) + (1 :: int)) powr real_of_int (interp_exp e y))" for t1 y
theorem pure_same_exp'vc:
  fixes e2 :: "exp"
  fixes e1 :: "exp"
  shows "case e2 of Lit x \<Rightarrow> (case e1 of Lit x1 \<Rightarrow> True | _ \<Rightarrow> True) | Var x \<Rightarrow> (case e1 of Var x1 \<Rightarrow> True | _ \<Rightarrow> True) | Minus x \<Rightarrow> (case e1 of Minus x1 \<Rightarrow> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1) \<or> e1 = x1 \<and> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x \<or> f1 = x | Minus f \<Rightarrow> f = x | Sub f f1 \<Rightarrow> f = x \<or> f1 = x) | _ \<Rightarrow> True) | Plus x x1 \<Rightarrow> (case e1 of Plus x2 x3 \<Rightarrow> (((case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<or> e1 = x2 \<and> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x \<or> f1 = x | Minus f \<Rightarrow> f = x | Sub f f1 \<Rightarrow> f = x \<or> f1 = x)) \<and> ((\<forall>(y :: int \<Rightarrow> int). interp_exp x2 y = interp_exp x y) \<longrightarrow> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x3 \<or> f1 = x3 | Minus f \<Rightarrow> f = x3 | Sub f f1 \<Rightarrow> f = x3 \<or> f1 = x3) \<or> e1 = x3 \<and> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1))) \<and> (\<forall>(o1 :: bool). (\<exists>(o2 :: bool). (o2 = True \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp x2 y = interp_exp x y)) \<and> (if o2 = True then o1 = True \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp x3 y = interp_exp x1 y) else o1 = False)) \<longrightarrow> \<not>o1 = True \<longrightarrow> ((case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x2 \<or> f1 = x2 | Minus f \<Rightarrow> f = x2 | Sub f f1 \<Rightarrow> f = x2 \<or> f1 = x2) \<or> e1 = x2 \<and> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x1 \<or> f1 = x1 | Minus f \<Rightarrow> f = x1 | Sub f f1 \<Rightarrow> f = x1 \<or> f1 = x1)) \<and> ((\<forall>(y :: int \<Rightarrow> int). interp_exp x2 y = interp_exp x1 y) \<longrightarrow> (case e1 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x3 \<or> f1 = x3 | Minus f \<Rightarrow> f = x3 | Sub f f1 \<Rightarrow> f = x3 \<or> f1 = x3) \<or> e1 = x3 \<and> (case e2 of Lit _ \<Rightarrow> False | Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = x \<or> f1 = x | Minus f \<Rightarrow> f = x | Sub f f1 \<Rightarrow> f = x \<or> f1 = x))) | _ \<Rightarrow> True) | _ \<Rightarrow> True"
  and "(case e2 of Lit x \<Rightarrow> (case e1 of Lit x1 \<Rightarrow> True = (if x1 = x then True else False) | _ \<Rightarrow> True = False) | Var x \<Rightarrow> (case e1 of Var x1 \<Rightarrow> True = (if x1 = x then True else False) | _ \<Rightarrow> True = False) | Minus x \<Rightarrow> (case e1 of Minus x1 \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp x1 y = interp_exp x y) | _ \<Rightarrow> True = False) | Plus x x1 \<Rightarrow> (case e1 of Plus x2 x3 \<Rightarrow> (\<exists>(o1 :: bool). (\<exists>(o2 :: bool). (o2 = True \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp x2 y = interp_exp x y)) \<and> (if o2 = True then o1 = True \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp x3 y = interp_exp x1 y) else o1 = False)) \<and> (if o1 = True then True else \<exists>(o2 :: bool). (o2 = True \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp x2 y = interp_exp x1 y)) \<and> (if o2 = True then \<forall>(y :: int \<Rightarrow> int). interp_exp x3 y = interp_exp x y else True = False))) | _ \<Rightarrow> True = False) | _ \<Rightarrow> True = False) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). interp_exp e1 y = interp_exp e2 y)"
  sorry
end
