import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.NumOf
import Why3.mach.matrix.Matrix63
import Why3.debug.Debug
import pearl.multiprecision.lib.lean.lineardecision.RationalCoeffs
import pearl.multiprecision.lib.lean.lineardecision.MP64Coeffs
import pearl.multiprecision.lib.lean.lineardecision.LinearDecisionRationalMP
import pearl.multiprecision.lib.lean.lineardecision.LinearDecisionIntMP
open Classical
open Lean4Why3
namespace lineardecision_EqPropMP_prop_ctxqtvc
noncomputable def expr_bound' : LinearDecisionIntMP.expr' -> ℤ -> Prop
  | (LinearDecisionIntMP.expr'.Sum e1 e2), b => expr_bound' e1 b ∧ expr_bound' e2 b
  | (LinearDecisionIntMP.expr'.Diff e1 e2), b => expr_bound' e1 b ∧ expr_bound' e2 b
  | (LinearDecisionIntMP.expr'.ProdL e1 x), b => expr_bound' e1 b
  | (LinearDecisionIntMP.expr'.ProdR x e1), b => expr_bound' e1 b
  | (LinearDecisionIntMP.expr'.Var n), b => (0 : ℤ) ≤ n ∧ n ≤ b
  | (LinearDecisionIntMP.expr'.Coeff x), b => True
noncomputable def eq_bound' (eq : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') (b : ℤ) := match eq with | (e1, e2) => expr_bound' e1 b ∧ expr_bound' e2 b
noncomputable def ctx_bound' : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') -> ℤ -> Prop
  | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), b => True
  | (List.cons eq t), b => eq_bound' eq b ∧ ctx_bound' t b
axiom max_var' : LinearDecisionIntMP.expr' -> ℤ
axiom max_var''def (e : LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_expr' e) : match e with | LinearDecisionIntMP.expr'.Var i => max_var' e = i | LinearDecisionIntMP.expr'.Coeff _ => max_var' e = (0 : ℤ) | LinearDecisionIntMP.expr'.Sum e1 e2 => max_var' e = max (max_var' e1) (max_var' e2) | LinearDecisionIntMP.expr'.Diff e1 e2 => max_var' e = max (max_var' e1) (max_var' e2) | LinearDecisionIntMP.expr'.ProdL e1 _ => max_var' e = max_var' e1 | LinearDecisionIntMP.expr'.ProdR _ e1 => max_var' e = max_var' e1
axiom max_var''spec'0 (e : LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_expr' e) : (0 : ℤ) ≤ max_var' e
axiom max_var''spec (e : LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_expr' e) : expr_bound' e (max_var' e)
axiom max_var_e' : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' -> ℤ
axiom max_var_e''def (e : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_eq' e) : match e with | (e1, e2) => max_var_e' e = max (max_var' e1) (max_var' e2)
axiom max_var_e''spec'0 (e : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_eq' e) : (0 : ℤ) ≤ max_var_e' e
axiom max_var_e''spec (e : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_eq' e) : eq_bound' e (max_var_e' e)
axiom max_var_ctx' : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') -> ℤ
axiom max_var_ctx''def (l : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) (fact0 : LinearDecisionIntMP.valid_ctx' l) : match l with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => max_var_ctx' l = (0 : ℤ) | List.cons e t => max_var_ctx' l = max (max_var_e' e) (max_var_ctx' t)
axiom max_var_ctx''spec'0 (l : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) (fact0 : LinearDecisionIntMP.valid_ctx' l) : (0 : ℤ) ≤ max_var_ctx' l
axiom max_var_ctx''spec (l : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) (fact0 : LinearDecisionIntMP.valid_ctx' l) : ctx_bound' l (max_var_ctx' l)
noncomputable def ctx_impl_ctx' : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') -> List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') -> Prop
  | c1, ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => True
  | c1, (List.cons eq t) => ctx_impl_ctx' c1 t ∧ (∀(y : ℤ -> ℤ) (z : ℤ -> ℤ), y = z → LinearDecisionIntMP.interp_ctx' c1 eq y z = true)
noncomputable def ctx_holds' : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') -> (ℤ -> ℤ) -> (ℤ -> ℤ) -> Prop
  | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), y, z => True
  | (List.cons h t), y, z => LinearDecisionIntMP.interp_eq' h y z = true ∧ ctx_holds' t y z
noncomputable def is_eq_tbl (a : List (Option MP64Coeffs.exp)) (l : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) := ∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a) → (match a[Int.toNat i]! with | Option.none => True | Option.some e => (∀(y : ℤ -> ℤ) (z : ℤ -> ℤ), y = z → ctx_holds' l y z → MP64Coeffs.interp_exp (MP64Coeffs.exp.Var i) z = MP64Coeffs.interp_exp e z))
axiom fc :  {α : Type} -> [Inhabited α] -> List α -> α -> ℤ -> Bool
axiom fc'def {α : Type} [Inhabited α] (a : List α) (v : α) (i : ℤ) : (fc a v i = true) = (a[Int.toNat i]! = v)
lemma prop_ctx'vc (g : LinearDecisionIntMP.expr') (g1 : LinearDecisionIntMP.expr') (l : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) : let g2 : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (g, g1); LinearDecisionIntMP.valid_ctx' l ∧ LinearDecisionIntMP.valid_eq' g2 → LinearDecisionIntMP.valid_eq' g2 ∧ (let o1 : ℤ := max_var_e' g2; (0 : ℤ) ≤ o1 ∧ eq_bound' g2 o1 → LinearDecisionIntMP.valid_ctx' l ∧ (let o2 : ℤ := max_var_ctx' l; (0 : ℤ) ≤ o2 ∧ ctx_bound' l o2 → (let m : ℤ := max o2 o1; let o3 : ℤ := m + (1 : ℤ); (0 : ℤ) ≤ o3 ∧ (∀(a : List (Option MP64Coeffs.exp)), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o3 → a[Int.toNat i]! = Option.none) ∧ Int.ofNat (List.length a) = o3 → (∀(e : LinearDecisionIntMP.expr'), (match e with | LinearDecisionIntMP.expr'.Var i => True | LinearDecisionIntMP.expr'.Sum e1 e2 => (match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.ProdL f _ => f = e2 | LinearDecisionIntMP.expr'.ProdR _ f => f = e2 | LinearDecisionIntMP.expr'.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ (∀(o4 : Option MP64Coeffs.exp), (match o4 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e2 y y = MP64Coeffs.interp_exp ex y)) → (match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ (∀(o5 : Option MP64Coeffs.exp), (match o5 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e1 y y = MP64Coeffs.interp_exp ex y)) → (match o4 with | Option.some x => (match o5 with | Option.some x1 => True | _ => True) | _ => True))) | LinearDecisionIntMP.expr'.Diff e1 e2 => (match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.ProdL f _ => f = e2 | LinearDecisionIntMP.expr'.ProdR _ f => f = e2 | LinearDecisionIntMP.expr'.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ (∀(o4 : Option MP64Coeffs.exp), (match o4 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e2 y y = MP64Coeffs.interp_exp ex y)) → (match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ (∀(o5 : Option MP64Coeffs.exp), (match o5 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e1 y y = MP64Coeffs.interp_exp ex y)) → (match o4 with | Option.some x => (match o5 with | Option.some x1 => True | _ => True) | _ => True))) | LinearDecisionIntMP.expr'.Coeff (LinearDecisionIntMP.t.I n) => True | _ => True) ∧ (∀(result : Option MP64Coeffs.exp), (match e with | LinearDecisionIntMP.expr'.Var i => result = Option.some (MP64Coeffs.exp.Var i) | LinearDecisionIntMP.expr'.Sum e1 e2 => (∃(o4 : Option MP64Coeffs.exp), (match o4 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e2 y y = MP64Coeffs.interp_exp ex y)) ∧ (∃(o5 : Option MP64Coeffs.exp), (match o5 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e1 y y = MP64Coeffs.interp_exp ex y)) ∧ (match o4 with | Option.some x => (match o5 with | Option.some x1 => result = Option.some (MP64Coeffs.exp.Plus x1 x) | _ => result = Option.none) | _ => result = Option.none))) | LinearDecisionIntMP.expr'.Diff e1 e2 => (∃(o4 : Option MP64Coeffs.exp), (match o4 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e2 y y = MP64Coeffs.interp_exp ex y)) ∧ (∃(o5 : Option MP64Coeffs.exp), (match o5 with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e1 y y = MP64Coeffs.interp_exp ex y)) ∧ (match o4 with | Option.some x => (match o5 with | Option.some x1 => result = Option.some (MP64Coeffs.exp.Sub x1 x) | _ => result = Option.none) | _ => result = Option.none))) | LinearDecisionIntMP.expr'.Coeff (LinearDecisionIntMP.t.I n) => result = Option.some (MP64Coeffs.exp.Lit n) | _ => result = Option.none) → (match result with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' e y y = MP64Coeffs.interp_exp ex y)))) ∧ (∀(a1 : List (Option MP64Coeffs.exp)), List.length a1 = List.length a → (∀(eq : LinearDecisionIntMP.expr') (eq1 : LinearDecisionIntMP.expr'), let eq2 : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (eq, eq1); eq_bound' eq2 m → (match eq1 with | LinearDecisionIntMP.expr'.Var x => (match eq with | LinearDecisionIntMP.expr'.Var x1 => (∀(r : Option MP64Coeffs.exp), (match r with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' eq1 y y = MP64Coeffs.interp_exp ex y)) → (match r with | Option.none => (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl a1 (List.cons eq2 l1)) | Option.some ex => (let o4 : Option MP64Coeffs.exp := Option.some ex; ((0 : ℤ) ≤ x1 ∧ x1 < Int.ofNat (List.length a1)) ∧ (List.length (List.set a1 (Int.toNat x1) o4) = List.length a1 → getElem! (List.set a1 (Int.toNat x1) o4) ∘ Int.toNat = Function.update (getElem! a1 ∘ Int.toNat) x1 o4 → (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl (List.set a1 (Int.toNat x1) o4) (List.cons eq2 l1)))))) | _ => (∀(r : Option MP64Coeffs.exp), (match r with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' eq y y = MP64Coeffs.interp_exp ex y)) → (match r with | Option.none => (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl a1 (List.cons eq2 l1)) | Option.some ex => (let o4 : Option MP64Coeffs.exp := Option.some ex; ((0 : ℤ) ≤ x ∧ x < Int.ofNat (List.length a1)) ∧ (List.length (List.set a1 (Int.toNat x) o4) = List.length a1 → getElem! (List.set a1 (Int.toNat x) o4) ∘ Int.toNat = Function.update (getElem! a1 ∘ Int.toNat) x o4 → (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl (List.set a1 (Int.toNat x) o4) (List.cons eq2 l1))))))) | _ => (match eq with | LinearDecisionIntMP.expr'.Var x => (∀(r : Option MP64Coeffs.exp), (match r with | Option.none => True | Option.some ex => (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp' eq1 y y = MP64Coeffs.interp_exp ex y)) → (match r with | Option.none => (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl a1 (List.cons eq2 l1)) | Option.some ex => (let o4 : Option MP64Coeffs.exp := Option.some ex; ((0 : ℤ) ≤ x ∧ x < Int.ofNat (List.length a1)) ∧ (List.length (List.set a1 (Int.toNat x) o4) = List.length a1 → getElem! (List.set a1 (Int.toNat x) o4) ∘ Int.toNat = Function.update (getElem! a1 ∘ Int.toNat) x o4 → (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl (List.set a1 (Int.toNat x) o4) (List.cons eq2 l1)))))) | _ => (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 → is_eq_tbl a1 (List.cons eq2 l1)))))) ∧ (∀(a1 : List (Option MP64Coeffs.exp)), List.length a1 = List.length a → (∀(l1 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a1 ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) ∧ ctx_bound' l1 m → (match l1 with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => is_eq_tbl a1 l1 | List.cons eq l2 => ((match l1 with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => False | List.cons _ f => f = l2) ∧ is_eq_tbl a1 ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) ∧ ctx_bound' l2 m) ∧ (∀(a2 : List (Option MP64Coeffs.exp)), List.length a2 = List.length a1 → is_eq_tbl a2 l2 → eq_bound' eq m ∧ (∀(a3 : List (Option MP64Coeffs.exp)), List.length a3 = List.length a2 → (∀(l3 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), is_eq_tbl a2 l3 → is_eq_tbl a3 (List.cons eq l3)) → is_eq_tbl a3 l1))))) ∧ (is_eq_tbl a ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) ∧ ctx_bound' l m) ∧ (∀(a1 : List (Option MP64Coeffs.exp)), List.length a1 = List.length a → is_eq_tbl a1 l → (let o4 : ℤ := m + (1 : ℤ); (0 : ℤ) ≤ o4 ∧ (∀(seen : List Bool), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < o4 → seen[Int.toNat i]! = false) ∧ Int.ofNat (List.length seen) = o4 → (∀(seen1 : List Bool) (a2 : List (Option MP64Coeffs.exp)), List.length seen1 = List.length seen → List.length a2 = List.length a1 → (∀(i : ℤ), is_eq_tbl a2 l ∧ seen1[Int.toNat i]! = false → (∀(seen2 : List Bool) (a3 : List (Option MP64Coeffs.exp)), List.length seen2 = List.length seen1 → List.length a3 = List.length a2 → (∀(e : MP64Coeffs.exp), is_eq_tbl a3 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen2)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1)) → (match e with | MP64Coeffs.exp.Lit _ => is_eq_tbl a3 l | MP64Coeffs.exp.Var j => (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length seen2) → (if ¬seen2[Int.toNat j]! = true then (((0 : ℤ) ≤ Int.ofNat (List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen2)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ is_eq_tbl a3 l ∧ seen2[Int.toNat j]! = false) ∧ (∀(seen3 : List Bool) (a4 : List (Option MP64Coeffs.exp)), List.length seen3 = List.length seen2 → List.length a4 = List.length a3 → is_eq_tbl a4 l ∧ seen3[Int.toNat j]! = true ∧ (∀(j1 : ℤ), seen2[Int.toNat j1]! = true → seen3[Int.toNat j1]! = true) → (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a4) → (∀(result : MP64Coeffs.exp), (match a4[Int.toNat j]! with | Option.none => result = e | Option.some e' => result = e') → is_eq_tbl a4 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp result y) ∧ (∀(j1 : ℤ), seen2[Int.toNat j1]! = true → seen3[Int.toNat j1]! = true))) else (0 : ℤ) ≤ j ∧ j < Int.ofNat (List.length a3) → (∀(result : MP64Coeffs.exp), (match a3[Int.toNat j]! with | Option.none => result = e | Option.some e' => result = e') → is_eq_tbl a3 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp result y))) | MP64Coeffs.exp.Plus e1 e2 => ((match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e2 ∨ f1 = e2 | MP64Coeffs.exp.Minus f => f = e2 | MP64Coeffs.exp.Sub f f1 => f = e2 ∨ f1 = e2) ∧ is_eq_tbl a3 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen2)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ (∀(seen3 : List Bool) (a4 : List (Option MP64Coeffs.exp)), List.length seen3 = List.length seen2 → List.length a4 = List.length a3 → (∀(o5 : MP64Coeffs.exp), is_eq_tbl a4 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e2 y = MP64Coeffs.interp_exp o5 y) ∧ (∀(j : ℤ), seen2[Int.toNat j]! = true → seen3[Int.toNat j]! = true) → ((match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ is_eq_tbl a4 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen3)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ (∀(seen4 : List Bool) (a5 : List (Option MP64Coeffs.exp)), List.length seen4 = List.length seen3 → List.length a5 = List.length a4 → (∀(o6 : MP64Coeffs.exp), is_eq_tbl a5 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o6 y) ∧ (∀(j : ℤ), seen3[Int.toNat j]! = true → seen4[Int.toNat j]! = true) → is_eq_tbl a5 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Plus o6 o5) y) ∧ (∀(j : ℤ), seen2[Int.toNat j]! = true → seen4[Int.toNat j]! = true))))) | MP64Coeffs.exp.Sub e1 e2 => ((match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e2 ∨ f1 = e2 | MP64Coeffs.exp.Minus f => f = e2 | MP64Coeffs.exp.Sub f f1 => f = e2 ∨ f1 = e2) ∧ is_eq_tbl a3 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen2)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ (∀(seen3 : List Bool) (a4 : List (Option MP64Coeffs.exp)), List.length seen3 = List.length seen2 → List.length a4 = List.length a3 → (∀(o5 : MP64Coeffs.exp), is_eq_tbl a4 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e2 y = MP64Coeffs.interp_exp o5 y) ∧ (∀(j : ℤ), seen2[Int.toNat j]! = true → seen3[Int.toNat j]! = true) → ((match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ is_eq_tbl a4 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen3)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ (∀(seen4 : List Bool) (a5 : List (Option MP64Coeffs.exp)), List.length seen4 = List.length seen3 → List.length a5 = List.length a4 → (∀(o6 : MP64Coeffs.exp), is_eq_tbl a5 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o6 y) ∧ (∀(j : ℤ), seen3[Int.toNat j]! = true → seen4[Int.toNat j]! = true) → is_eq_tbl a5 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Sub o6 o5) y) ∧ (∀(j : ℤ), seen2[Int.toNat j]! = true → seen4[Int.toNat j]! = true))))) | MP64Coeffs.exp.Minus e1 => ((match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ is_eq_tbl a3 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen2)) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ (∀(seen3 : List Bool) (a4 : List (Option MP64Coeffs.exp)), List.length seen3 = List.length seen2 → List.length a4 = List.length a3 → (∀(o5 : MP64Coeffs.exp), is_eq_tbl a4 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o5 y) ∧ (∀(j : ℤ), seen2[Int.toNat j]! = true → seen3[Int.toNat j]! = true) → is_eq_tbl a4 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Minus o5) y) ∧ (∀(j : ℤ), seen2[Int.toNat j]! = true → seen3[Int.toNat j]! = true)))))) ∧ (List.length (List.set seen1 (Int.toNat i) true) = List.length seen1 → (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length (List.set seen1 (Int.toNat i) true)) → ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a2)) ∧ (match a2[Int.toNat i]! with | Option.none => is_eq_tbl a2 l ∧ (List.set seen1 (Int.toNat i) true)[Int.toNat i]! = true ∧ (∀(j : ℤ), seen1[Int.toNat j]! = true → (List.set seen1 (Int.toNat i) true)[Int.toNat j]! = true) | Option.some e => (is_eq_tbl a2 l ∧ List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) (List.set seen1 (Int.toNat i) true))) < List.count false (List.drop (0 : ℕ) (List.take (Int.toNat (m + (1 : ℤ)) - (0 : ℕ)) seen1))) ∧ (∀(seen2 : List Bool) (a3 : List (Option MP64Coeffs.exp)), List.length seen2 = List.length (List.set seen1 (Int.toNat i) true) → List.length a3 = List.length a2 → (∀(o5 : MP64Coeffs.exp), is_eq_tbl a3 l ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp o5 y) ∧ (∀(j : ℤ), (List.set seen1 (Int.toNat i) true)[Int.toNat j]! = true → seen2[Int.toNat j]! = true) → (let o6 : Option MP64Coeffs.exp := Option.some o5; ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a3)) ∧ (List.length (List.set a3 (Int.toNat i) o6) = List.length a3 → getElem! (List.set a3 (Int.toNat i) o6) ∘ Int.toNat = Function.update (getElem! a3 ∘ Int.toNat) i o6 → is_eq_tbl (List.set a3 (Int.toNat i) o6) l ∧ seen2[Int.toNat i]! = true ∧ (∀(j : ℤ), seen1[Int.toNat j]! = true → seen2[Int.toNat j]! = true))))))))) ∧ ((0 : ℤ) ≤ m + (1 : ℤ) → is_eq_tbl a1 l ∧ (∀(seen1 : List Bool) (a2 : List (Option MP64Coeffs.exp)), List.length seen1 = List.length seen → List.length a2 = List.length a1 → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i ≤ m) ∧ is_eq_tbl a2 l → ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length seen1)) ∧ (if ¬seen1[Int.toNat i]! = true then (is_eq_tbl a2 l ∧ seen1[Int.toNat i]! = false) ∧ (∀(seen2 : List Bool) (a3 : List (Option MP64Coeffs.exp)), List.length seen2 = List.length seen1 → List.length a3 = List.length a2 → is_eq_tbl a3 l ∧ seen2[Int.toNat i]! = true ∧ (∀(j : ℤ), seen1[Int.toNat j]! = true → seen2[Int.toNat j]! = true) → is_eq_tbl a3 l) else is_eq_tbl a2 l)) ∧ (is_eq_tbl a2 l → (∀(e : MP64Coeffs.exp), match e with | MP64Coeffs.exp.Lit _ => True | MP64Coeffs.exp.Var i => (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a2) → (∀(result : MP64Coeffs.exp), (match a2[Int.toNat i]! with | Option.some e' => result = e' | Option.none => result = e) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp result y)) | MP64Coeffs.exp.Plus e1 e2 => (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e2 ∨ f1 = e2 | MP64Coeffs.exp.Minus f => f = e2 | MP64Coeffs.exp.Sub f f1 => f = e2 ∨ f1 = e2) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e2 y = MP64Coeffs.interp_exp o5 y) → (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o6 y) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Plus o6 o5) y))) | MP64Coeffs.exp.Sub e1 e2 => (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e2 ∨ f1 = e2 | MP64Coeffs.exp.Minus f => f = e2 | MP64Coeffs.exp.Sub f f1 => f = e2 ∨ f1 = e2) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e2 y = MP64Coeffs.interp_exp o5 y) → (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o6 y) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Sub o6 o5) y))) | MP64Coeffs.exp.Minus e1 => (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o5 y) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Minus o5) y))) ∧ (∀(c : LinearDecisionIntMP.t), match c with | LinearDecisionIntMP.t.I _ => (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff c) y y = true) | LinearDecisionIntMP.t.E e => (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp o5 y) → (let result : LinearDecisionIntMP.t := LinearDecisionIntMP.t.E o5; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff result) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c y → LinearDecisionIntMP.pos_exp result y))) | LinearDecisionIntMP.t.R => (let result : LinearDecisionIntMP.t := LinearDecisionIntMP.t.R; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff result) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c y → LinearDecisionIntMP.pos_exp result y))) ∧ (∀(c : LinearDecisionIntMP.cprod), match c with | LinearDecisionIntMP.cprod.C c1 => (∀(o5 : LinearDecisionIntMP.t), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c1, LinearDecisionIntMP.expr'.Coeff o5) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c1 y → LinearDecisionIntMP.pos_exp o5 y) → (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.cprod.C o5; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod result y))) | LinearDecisionIntMP.cprod.Times c1 c2 => (match c with | LinearDecisionIntMP.cprod.C _ => False | LinearDecisionIntMP.cprod.Times f f1 => f = c2 ∨ f1 = c2) ∧ (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c2 y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c2 y → LinearDecisionIntMP.pos_cprod o5 y) → (match c with | LinearDecisionIntMP.cprod.C _ => False | LinearDecisionIntMP.cprod.Times f f1 => f = c1 ∨ f1 = c1) ∧ (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c1 y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c1 y → LinearDecisionIntMP.pos_cprod o6 y) → (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.cprod.Times o6 o5; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod result y))))) ∧ (∀(e : LinearDecisionIntMP.expr'), expr_bound' e m ∧ LinearDecisionIntMP.valid_expr' e → (match e with | LinearDecisionIntMP.expr'.Var _ => expr_bound' e m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, e) y y = true) ∧ LinearDecisionIntMP.valid_expr' e | LinearDecisionIntMP.expr'.ProdL e1 c => (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod o5 y) → ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.ProdL o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.ProdR c e1 => ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o5 y) → (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.ProdR o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.Sum e1 e2 => ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.ProdL f _ => f = e2 | LinearDecisionIntMP.expr'.ProdR _ f => f = e2 | LinearDecisionIntMP.expr'.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e2 y → LinearDecisionIntMP.pos_expr' o5 y) → ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.Sum o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.Diff e1 e2 => ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.ProdL f _ => f = e2 | LinearDecisionIntMP.expr'.ProdR _ f => f = e2 | LinearDecisionIntMP.expr'.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e2 y → LinearDecisionIntMP.pos_expr' o5 y) → ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.Diff o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.Coeff c => (∀(o5 : LinearDecisionIntMP.t), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff o5) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c y → LinearDecisionIntMP.pos_exp o5 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.Coeff o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y))))) ∧ (∀(a3 : LinearDecisionIntMP.expr') (b : LinearDecisionIntMP.expr'), let eq : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (a3, b); eq_bound' eq m ∧ LinearDecisionIntMP.valid_eq' eq → (expr_bound' b m ∧ LinearDecisionIntMP.valid_expr' b) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (b, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' b y → LinearDecisionIntMP.pos_expr' o5 y) → (expr_bound' a3 m ∧ LinearDecisionIntMP.valid_expr' a3) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (a3, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' a3 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (o6, o5); eq_bound' result m ∧ (∀(y : ℤ -> ℤ), (LinearDecisionIntMP.interp_ctx' l eq y y = true) = (LinearDecisionIntMP.interp_ctx' l result y y = true)) ∧ LinearDecisionIntMP.valid_eq' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_eq' eq y → LinearDecisionIntMP.pos_eq' result y))))) ∧ (∀(acc : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), ctx_bound' acc m ∧ ctx_impl_ctx' l acc ∧ LinearDecisionIntMP.valid_ctx' acc → (match acc with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => (let result : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') := ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')); ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ List.length result = List.length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' acc y → LinearDecisionIntMP.pos_ctx' result y)) | List.cons h t => (eq_bound' h m ∧ LinearDecisionIntMP.valid_eq' h) ∧ (∀(h' : LinearDecisionIntMP.expr') (h'1 : LinearDecisionIntMP.expr'), let h'2 : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (h', h'1); eq_bound' h'2 m ∧ (∀(y : ℤ -> ℤ), (LinearDecisionIntMP.interp_ctx' l h y y = true) = (LinearDecisionIntMP.interp_ctx' l h'2 y y = true)) ∧ LinearDecisionIntMP.valid_eq' h'2 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_eq' h y → LinearDecisionIntMP.pos_eq' h'2 y) → ((match acc with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => False | List.cons _ f => f = t) ∧ ctx_bound' t m ∧ ctx_impl_ctx' l t ∧ LinearDecisionIntMP.valid_ctx' t) ∧ (∀(t' : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), ctx_bound' t' m ∧ ctx_impl_ctx' l t' ∧ List.length t' = List.length t ∧ LinearDecisionIntMP.valid_ctx' t' ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' t y → LinearDecisionIntMP.pos_ctx' t' y) → (let result : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') := List.cons h'2 t'; ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ List.length result = List.length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' acc y → LinearDecisionIntMP.pos_ctx' result y)))))) ∧ (eq_bound' g2 m ∧ LinearDecisionIntMP.valid_eq' g2) ∧ (∀(o5 : LinearDecisionIntMP.expr') (o6 : LinearDecisionIntMP.expr'), let o7 : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (o5, o6); eq_bound' o7 m ∧ (∀(y : ℤ -> ℤ), (LinearDecisionIntMP.interp_ctx' l g2 y y = true) = (LinearDecisionIntMP.interp_ctx' l o7 y y = true)) ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_eq' g2 y → LinearDecisionIntMP.pos_eq' o7 y) → (ctx_bound' l m ∧ ctx_impl_ctx' l l ∧ LinearDecisionIntMP.valid_ctx' l) ∧ (∀(o8 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), ctx_bound' o8 m ∧ ctx_impl_ctx' l o8 ∧ List.length o8 = List.length l ∧ LinearDecisionIntMP.valid_ctx' o8 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' l y → LinearDecisionIntMP.pos_ctx' o8 y) → List.length o8 = List.length l ∧ (LinearDecisionIntMP.valid_ctx' o8 ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp_ctx' o8 o7 y y = true → LinearDecisionIntMP.interp_ctx' l g2 y y = true)) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' l y → LinearDecisionIntMP.pos_eq' g2 y → LinearDecisionIntMP.pos_ctx' o8 y ∧ LinearDecisionIntMP.pos_eq' o7 y)))))) ∧ (m + (1 : ℤ) < (0 : ℤ) → (∀(e : MP64Coeffs.exp), match e with | MP64Coeffs.exp.Lit _ => True | MP64Coeffs.exp.Var i => (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length a1) → (∀(result : MP64Coeffs.exp), (match a1[Int.toNat i]! with | Option.some e' => result = e' | Option.none => result = e) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp result y)) | MP64Coeffs.exp.Plus e1 e2 => (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e2 ∨ f1 = e2 | MP64Coeffs.exp.Minus f => f = e2 | MP64Coeffs.exp.Sub f f1 => f = e2 ∨ f1 = e2) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e2 y = MP64Coeffs.interp_exp o5 y) → (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o6 y) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Plus o6 o5) y))) | MP64Coeffs.exp.Sub e1 e2 => (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e2 ∨ f1 = e2 | MP64Coeffs.exp.Minus f => f = e2 | MP64Coeffs.exp.Sub f f1 => f = e2 ∨ f1 = e2) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e2 y = MP64Coeffs.interp_exp o5 y) → (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o6 y) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Sub o6 o5) y))) | MP64Coeffs.exp.Minus e1 => (match e with | MP64Coeffs.exp.Lit _ => False | MP64Coeffs.exp.Var _ => False | MP64Coeffs.exp.Plus f f1 => f = e1 ∨ f1 = e1 | MP64Coeffs.exp.Minus f => f = e1 | MP64Coeffs.exp.Sub f f1 => f = e1 ∨ f1 = e1) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e1 y = MP64Coeffs.interp_exp o5 y) → (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp (MP64Coeffs.exp.Minus o5) y))) ∧ (∀(c : LinearDecisionIntMP.t), match c with | LinearDecisionIntMP.t.I _ => (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff c) y y = true) | LinearDecisionIntMP.t.E e => (∀(o5 : MP64Coeffs.exp), (∀(y : ℤ -> ℤ), ctx_holds' l y y → MP64Coeffs.interp_exp e y = MP64Coeffs.interp_exp o5 y) → (let result : LinearDecisionIntMP.t := LinearDecisionIntMP.t.E o5; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff result) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c y → LinearDecisionIntMP.pos_exp result y))) | LinearDecisionIntMP.t.R => (let result : LinearDecisionIntMP.t := LinearDecisionIntMP.t.R; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff result) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c y → LinearDecisionIntMP.pos_exp result y))) ∧ (∀(c : LinearDecisionIntMP.cprod), match c with | LinearDecisionIntMP.cprod.C c1 => (∀(o5 : LinearDecisionIntMP.t), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c1, LinearDecisionIntMP.expr'.Coeff o5) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c1 y → LinearDecisionIntMP.pos_exp o5 y) → (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.cprod.C o5; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod result y))) | LinearDecisionIntMP.cprod.Times c1 c2 => (match c with | LinearDecisionIntMP.cprod.C _ => False | LinearDecisionIntMP.cprod.Times f f1 => f = c2 ∨ f1 = c2) ∧ (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c2 y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c2 y → LinearDecisionIntMP.pos_cprod o5 y) → (match c with | LinearDecisionIntMP.cprod.C _ => False | LinearDecisionIntMP.cprod.Times f f1 => f = c1 ∨ f1 = c1) ∧ (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c1 y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c1 y → LinearDecisionIntMP.pos_cprod o6 y) → (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.cprod.Times o6 o5; (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod result y))))) ∧ (∀(e : LinearDecisionIntMP.expr'), expr_bound' e m ∧ LinearDecisionIntMP.valid_expr' e → (match e with | LinearDecisionIntMP.expr'.Var _ => expr_bound' e m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, e) y y = true) ∧ LinearDecisionIntMP.valid_expr' e | LinearDecisionIntMP.expr'.ProdL e1 c => (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod o5 y) → ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.ProdL o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.ProdR c e1 => ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o5 y) → (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_cprod c y → LinearDecisionIntMP.pos_cprod o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.ProdR o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.Sum e1 e2 => ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.ProdL f _ => f = e2 | LinearDecisionIntMP.expr'.ProdR _ f => f = e2 | LinearDecisionIntMP.expr'.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e2 y → LinearDecisionIntMP.pos_expr' o5 y) → ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.Sum o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.Diff e1 e2 => ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.ProdL f _ => f = e2 | LinearDecisionIntMP.expr'.ProdR _ f => f = e2 | LinearDecisionIntMP.expr'.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e2 y → LinearDecisionIntMP.pos_expr' o5 y) → ((match e with | LinearDecisionIntMP.expr'.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.ProdL f _ => f = e1 | LinearDecisionIntMP.expr'.ProdR _ f => f = e1 | LinearDecisionIntMP.expr'.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.expr'.Var _ => False | LinearDecisionIntMP.expr'.Coeff _ => False) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e1 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.Diff o6 o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y)))) | LinearDecisionIntMP.expr'.Coeff c => (∀(o5 : LinearDecisionIntMP.t), (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.expr'.Coeff c, LinearDecisionIntMP.expr'.Coeff o5) y y = true) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_exp c y → LinearDecisionIntMP.pos_exp o5 y) → (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.expr'.Coeff o5; expr_bound' result m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' e y → LinearDecisionIntMP.pos_expr' result y))))) ∧ (∀(a2 : LinearDecisionIntMP.expr') (b : LinearDecisionIntMP.expr'), let eq : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (a2, b); eq_bound' eq m ∧ LinearDecisionIntMP.valid_eq' eq → (expr_bound' b m ∧ LinearDecisionIntMP.valid_expr' b) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (b, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' b y → LinearDecisionIntMP.pos_expr' o5 y) → (expr_bound' a2 m ∧ LinearDecisionIntMP.valid_expr' a2) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.interp_eq' (a2, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_expr' a2 y → LinearDecisionIntMP.pos_expr' o6 y) → (let result : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (o6, o5); eq_bound' result m ∧ (∀(y : ℤ -> ℤ), (LinearDecisionIntMP.interp_ctx' l eq y y = true) = (LinearDecisionIntMP.interp_ctx' l result y y = true)) ∧ LinearDecisionIntMP.valid_eq' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_eq' eq y → LinearDecisionIntMP.pos_eq' result y))))) ∧ (∀(acc : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), ctx_bound' acc m ∧ ctx_impl_ctx' l acc ∧ LinearDecisionIntMP.valid_ctx' acc → (match acc with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => (let result : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') := ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')); ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ List.length result = List.length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' acc y → LinearDecisionIntMP.pos_ctx' result y)) | List.cons h t => (eq_bound' h m ∧ LinearDecisionIntMP.valid_eq' h) ∧ (∀(h' : LinearDecisionIntMP.expr') (h'1 : LinearDecisionIntMP.expr'), let h'2 : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (h', h'1); eq_bound' h'2 m ∧ (∀(y : ℤ -> ℤ), (LinearDecisionIntMP.interp_ctx' l h y y = true) = (LinearDecisionIntMP.interp_ctx' l h'2 y y = true)) ∧ LinearDecisionIntMP.valid_eq' h'2 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_eq' h y → LinearDecisionIntMP.pos_eq' h'2 y) → ((match acc with | ([] : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')) => False | List.cons _ f => f = t) ∧ ctx_bound' t m ∧ ctx_impl_ctx' l t ∧ LinearDecisionIntMP.valid_ctx' t) ∧ (∀(t' : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), ctx_bound' t' m ∧ ctx_impl_ctx' l t' ∧ List.length t' = List.length t ∧ LinearDecisionIntMP.valid_ctx' t' ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' t y → LinearDecisionIntMP.pos_ctx' t' y) → (let result : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr') := List.cons h'2 t'; ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ List.length result = List.length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' acc y → LinearDecisionIntMP.pos_ctx' result y)))))) ∧ (eq_bound' g2 m ∧ LinearDecisionIntMP.valid_eq' g2) ∧ (∀(o5 : LinearDecisionIntMP.expr') (o6 : LinearDecisionIntMP.expr'), let o7 : LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr' := (o5, o6); eq_bound' o7 m ∧ (∀(y : ℤ -> ℤ), (LinearDecisionIntMP.interp_ctx' l g2 y y = true) = (LinearDecisionIntMP.interp_ctx' l o7 y y = true)) ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_eq' g2 y → LinearDecisionIntMP.pos_eq' o7 y) → (ctx_bound' l m ∧ ctx_impl_ctx' l l ∧ LinearDecisionIntMP.valid_ctx' l) ∧ (∀(o8 : List (LinearDecisionIntMP.expr' × LinearDecisionIntMP.expr')), ctx_bound' o8 m ∧ ctx_impl_ctx' l o8 ∧ List.length o8 = List.length l ∧ LinearDecisionIntMP.valid_ctx' o8 ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' l y → LinearDecisionIntMP.pos_ctx' o8 y) → List.length o8 = List.length l ∧ (LinearDecisionIntMP.valid_ctx' o8 ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : ℤ -> ℤ), LinearDecisionIntMP.interp_ctx' o8 o7 y y = true → LinearDecisionIntMP.interp_ctx' l g2 y y = true)) ∧ (∀(y : ℤ -> ℤ), ctx_holds' l y y → LinearDecisionIntMP.pos_ctx' l y → LinearDecisionIntMP.pos_eq' g2 y → LinearDecisionIntMP.pos_ctx' o8 y ∧ LinearDecisionIntMP.pos_eq' o7 y)))))))))))
  := sorry
end lineardecision_EqPropMP_prop_ctxqtvc
