import Why3.Base
import Why3.why3.Ref.Ref
import Why3.debug.Debug
import pearl.multiprecision.lib.lean.lineardecision.RationalCoeffs
open Classical
open Lean4Why3
namespace lineardecision_MP64Coeffs_add_sub_expqtvc
axiom evars : Type
axiom inhabited_axiom_evars : Inhabited evars
attribute [instance] inhabited_axiom_evars
inductive exp where
  | Lit : ℤ -> exp
  | Var : ℤ -> exp
  | Plus : exp -> exp -> exp
  | Minus : exp -> exp
  | Sub : exp -> exp -> exp
axiom inhabited_axiom_exp : Inhabited exp
attribute [instance] inhabited_axiom_exp
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
noncomputable def qinterp (q : ℤ × ℤ) := match q with | (n, d) => Int.to_Real n / Int.to_Real d
noncomputable def interp_exp : exp -> (ℤ -> ℤ) -> ℤ
  | (exp.Lit n), y => n
  | (exp.Var v), y => y v
  | (exp.Plus e1 e2), y => interp_exp e1 y + interp_exp e2 y
  | (exp.Sub e1 e2), y => interp_exp e1 y - interp_exp e2 y
  | (exp.Minus e'), y => -interp_exp e' y
noncomputable def minterp (t1 : (ℤ × ℤ) × exp) (y : ℤ -> ℤ) := match t1 with | (q, e) => qinterp q * HPow.hPow (Int.to_Real ((18446744073709551615 : ℤ) + (1 : ℤ))) (Int.to_Real (interp_exp e y))
lemma add_sub_exp'vc (e2 : exp) (s : Bool) (e1 : exp) : (∀(e : exp) (a : exp) (s : Bool), match a with | exp.Lit x => (match e with | exp.Lit x1 => (∀(o1 : exp), (if s = true then o1 = exp.Lit (x1 + x) else o1 = exp.Lit (x1 - x)) → (∀(y : ℤ -> ℤ), if s = true then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) | exp.Var x1 => (∀(r : exp) (result : Bool), (if x = (0 : ℤ) then r = exp.Var x1 ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | exp.Minus x1 => (∀(r : exp) (result : Bool), (if x = (0 : ℤ) then r = exp.Minus x1 ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | exp.Plus x1 x2 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then r1 = x2 ∧ result = true else r1 = exp.Plus r x2 ∧ result = true) | _ => r1 = exp.Plus r x2 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp (exp.Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (exp.Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | exp.Sub x1 x2 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then (∀(y : ℤ -> ℤ), interp_exp r1 y = -interp_exp x2 y) ∧ result = true else r1 = exp.Sub r x2 ∧ result = true) | _ => r1 = exp.Sub r x2 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) → (∀(r2 : exp) (result : Bool), (if b1 = true then r2 = exp.Sub x1 r1 ∧ result = true else if s = true then r2 = exp.Sub (exp.Plus x1 a) x2 ∧ result = false else r2 = exp.Sub x1 (exp.Plus x2 a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y)))))) | exp.Var x => (match e with | exp.Lit x1 => (∀(r : exp) (result : Bool), (if x1 = (0 : ℤ) then (if s = true then r = exp.Var x else r = exp.Minus (exp.Var x)) ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | exp.Minus x1 => (match x1 with | exp.Var x2 => (∀(o1 : Bool), (if s = true then o1 = (if x = x2 then true else false) else o1 = false) → (∀(r : exp) (result : Bool), (if o1 = true then r = exp.Lit (0 : ℤ) ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | _ => True) | exp.Var x1 => (∀(r : exp) (result : Bool), (if s = true then r = exp.Plus e a ∧ result = false else if x1 = x then r = exp.Lit (0 : ℤ) ∧ result = true else r = exp.Sub e a ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | exp.Plus x1 x2 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then r1 = x2 ∧ result = true else r1 = exp.Plus r x2 ∧ result = true) | _ => r1 = exp.Plus r x2 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp (exp.Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (exp.Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | exp.Sub x1 x2 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then (∀(y : ℤ -> ℤ), interp_exp r1 y = -interp_exp x2 y) ∧ result = true else r1 = exp.Sub r x2 ∧ result = true) | _ => r1 = exp.Sub r x2 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) → (∀(r2 : exp) (result : Bool), (if b1 = true then r2 = exp.Sub x1 r1 ∧ result = true else if s = true then r2 = exp.Sub (exp.Plus x1 a) x2 ∧ result = false else r2 = exp.Sub x1 (exp.Plus x2 a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y)))))) | exp.Minus x => (match x with | exp.Var x1 => (match e with | exp.Lit x2 => (∀(r : exp) (result : Bool), (if x2 = (0 : ℤ) then (if s = true then r = exp.Minus x else r = x) ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | exp.Var x2 => (∀(o1 : Bool), (if s = true then o1 = (if x2 = x1 then true else false) else o1 = false) → (∀(r : exp) (result : Bool), (if o1 = true then r = exp.Lit (0 : ℤ) ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | exp.Minus x2 => (match x2 with | exp.Var x3 => (∀(o1 : Bool), (if ¬s = true then o1 = (if x3 = x1 then true else false) else o1 = false) → (∀(r : exp) (result : Bool), (if o1 = true then r = exp.Lit (0 : ℤ) ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | _ => (∀(o1 : exp), (if s = true then o1 = exp.Plus e a else o1 = exp.Sub e a) → (∀(y : ℤ -> ℤ), if s = true then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y))) | exp.Plus x2 x3 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x2 y + interp_exp a y else interp_exp r y = interp_exp x2 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then r1 = x3 ∧ result = true else r1 = exp.Plus r x3 ∧ result = true) | _ => r1 = exp.Plus r x3 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x3 ∨ f1 = x3 | exp.Minus f => f = x3 | exp.Sub f f1 => f = x3 ∨ f1 = x3) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp x3 y + interp_exp a y else interp_exp r1 y = interp_exp x3 y - interp_exp a y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp (exp.Plus x2 r1) y = interp_exp e y + interp_exp a y else interp_exp (exp.Plus x2 r1) y = interp_exp e y - interp_exp a y)))) | exp.Sub x2 x3 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x2 y + interp_exp a y else interp_exp r y = interp_exp x2 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then (∀(y : ℤ -> ℤ), interp_exp r1 y = -interp_exp x3 y) ∧ result = true else r1 = exp.Sub r x3 ∧ result = true) | _ => r1 = exp.Sub r x3 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x3 ∨ f1 = x3 | exp.Minus f => f = x3 | exp.Sub f f1 => f = x3 ∨ f1 = x3) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp r1 y = interp_exp x3 y + interp_exp a y else interp_exp r1 y = interp_exp x3 y - interp_exp a y) → (∀(r2 : exp) (result : Bool), (if b1 = true then r2 = exp.Sub x2 r1 ∧ result = true else if s = true then r2 = exp.Sub (exp.Plus x2 a) x3 ∧ result = false else r2 = exp.Sub x2 (exp.Plus x3 a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y)))))) | _ => (match e with | exp.Lit x1 => (∀(r : exp) (result : Bool), (if x1 = (0 : ℤ) then (if s = true then r = exp.Minus x else r = x) ∧ result = true else (if s = true then r = exp.Plus e a else r = exp.Sub e a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | exp.Minus x1 => (∀(o1 : exp), (if s = true then o1 = exp.Plus e a else o1 = exp.Sub e a) → (∀(y : ℤ -> ℤ), if s = true then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) | exp.Plus x1 x2 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then r1 = x2 ∧ result = true else r1 = exp.Plus r x2 ∧ result = true) | _ => r1 = exp.Plus r x2 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp (exp.Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (exp.Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | exp.Sub x1 x2 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then (∀(y : ℤ -> ℤ), interp_exp r1 y = -interp_exp x2 y) ∧ result = true else r1 = exp.Sub r x2 ∧ result = true) | _ => r1 = exp.Sub r x2 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x2 ∨ f1 = x2 | exp.Minus f => f = x2 | exp.Sub f f1 => f = x2 ∨ f1 = x2) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) → (∀(r2 : exp) (result : Bool), (if b1 = true then r2 = exp.Sub x1 r1 ∧ result = true else if s = true then r2 = exp.Sub (exp.Plus x1 a) x2 ∧ result = false else r2 = exp.Sub x1 (exp.Plus x2 a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) | _ => True)) | _ => (match e with | exp.Plus x x1 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x ∨ f1 = x | exp.Minus f => f = x | exp.Sub f f1 => f = x ∨ f1 = x) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x y + interp_exp a y else interp_exp r y = interp_exp x y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then r1 = x1 ∧ result = true else r1 = exp.Plus r x1 ∧ result = true) | _ => r1 = exp.Plus r x1 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp x1 y + interp_exp a y else interp_exp r1 y = interp_exp x1 y - interp_exp a y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp (exp.Plus x r1) y = interp_exp e y + interp_exp a y else interp_exp (exp.Plus x r1) y = interp_exp e y - interp_exp a y)))) | exp.Sub x x1 => (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x ∨ f1 = x | exp.Minus f => f = x | exp.Sub f f1 => f = x ∨ f1 = x) ∧ (∀(r : exp) (b : Bool), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp x y + interp_exp a y else interp_exp r y = interp_exp x y - interp_exp a y) → (if b = true then (match r with | exp.Lit n => True | _ => True) ∧ (∀(r1 : exp) (result : Bool), (match r with | exp.Lit n => (if n = (0 : ℤ) then (∀(y : ℤ -> ℤ), interp_exp r1 y = -interp_exp x1 y) ∧ result = true else r1 = exp.Sub r x1 ∧ result = true) | _ => r1 = exp.Sub r x1 ∧ result = true) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = x1 ∨ f1 = x1 | exp.Minus f => f = x1 | exp.Sub f f1 => f = x1 ∨ f1 = x1) ∧ (∀(r1 : exp) (b1 : Bool), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp r1 y = interp_exp x1 y + interp_exp a y else interp_exp r1 y = interp_exp x1 y - interp_exp a y) → (∀(r2 : exp) (result : Bool), (if b1 = true then r2 = exp.Sub x r1 ∧ result = true else if s = true then r2 = exp.Sub (exp.Plus x a) x1 ∧ result = false else r2 = exp.Sub x (exp.Plus x1 a) ∧ result = false) → (∀(y : ℤ -> ℤ), if s = true then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) | _ => True)) ∧ (match e2 with | exp.Plus e1' e2' => (match e2 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = e1' ∨ f1 = e1' | exp.Minus f => f = e1' | exp.Sub f f1 => f = e1' ∨ f1 = e1') ∧ (∀(r : exp), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e1 y + interp_exp e1' y else interp_exp r y = interp_exp e1 y - interp_exp e1' y) → (match r with | exp.Lit n => (if n = (0 : ℤ) then ∀(result : exp), (if s = true then result = e2' else ∀(y : ℤ -> ℤ), interp_exp result y = -interp_exp e2' y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y) else ((match e2 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = e2' ∨ f1 = e2' | exp.Minus f => f = e2' | exp.Sub f f1 => f = e2' ∨ f1 = e2') ∨ e2 = e2' ∧ (match e1 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = r ∨ f1 = r | exp.Minus f => f = r | exp.Sub f f1 => f = r ∨ f1 = r)) ∧ (∀(result : exp), (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y))) | _ => ((match e2 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = e2' ∨ f1 = e2' | exp.Minus f => f = e2' | exp.Sub f f1 => f = e2' ∨ f1 = e2') ∨ e2 = e2' ∧ (match e1 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = r ∨ f1 = r | exp.Minus f => f = r | exp.Sub f f1 => f = r ∨ f1 = r)) ∧ (∀(result : exp), (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y)))) | exp.Sub e1' e2' => (match e2 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = e1' ∨ f1 = e1' | exp.Minus f => f = e1' | exp.Sub f f1 => f = e1' ∨ f1 = e1') ∧ (∀(r : exp), (∀(y : ℤ -> ℤ), if s = true then interp_exp r y = interp_exp e1 y + interp_exp e1' y else interp_exp r y = interp_exp e1 y - interp_exp e1' y) → (match r with | exp.Lit n => (if n = (0 : ℤ) then ∀(result : exp), (if s = true then ∀(y : ℤ -> ℤ), interp_exp result y = -interp_exp e2' y else result = e2') → (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y) else ((match e2 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = e2' ∨ f1 = e2' | exp.Minus f => f = e2' | exp.Sub f f1 => f = e2' ∨ f1 = e2') ∨ e2 = e2' ∧ (match e1 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = r ∨ f1 = r | exp.Minus f => f = r | exp.Sub f f1 => f = r ∨ f1 = r)) ∧ (∀(result : exp), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y))) | _ => ((match e2 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = e2' ∨ f1 = e2' | exp.Minus f => f = e2' | exp.Sub f f1 => f = e2' ∨ f1 = e2') ∨ e2 = e2' ∧ (match e1 with | exp.Lit _ => False | exp.Var _ => False | exp.Plus f f1 => f = r ∨ f1 = r | exp.Minus f => f = r | exp.Sub f f1 => f = r ∨ f1 = r)) ∧ (∀(result : exp), (∀(y : ℤ -> ℤ), if ¬s = true then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y)))) | _ => (∀(o1 : exp), (∀(y : ℤ -> ℤ), if s = true then interp_exp o1 y = interp_exp e1 y + interp_exp e2 y else interp_exp o1 y = interp_exp e1 y - interp_exp e2 y) → (∀(y : ℤ -> ℤ), if s = true then interp_exp o1 y = interp_exp e1 y + interp_exp e2 y else interp_exp o1 y = interp_exp e1 y - interp_exp e2 y)))
  := sorry
end lineardecision_MP64Coeffs_add_sub_expqtvc
