From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.int.NumOf.
Require Import Why3.mach.matrix.Matrix63.
Require Import Why3.debug.Debug.
Require Import multiprecision.lineardecision.RationalCoeffs.
Require Import multiprecision.lineardecision.MP64Coeffs.
Require Import multiprecision.lineardecision.LinearDecisionRationalMP.
Require Import multiprecision.lineardecision.LinearDecisionIntMP.
Open Scope Z_scope.
Program Fixpoint expr_bound' (e : LinearDecisionIntMP.expr') (b : Z) : Prop :=
match e with | LinearDecisionIntMP.Sum e1 e2 => expr_bound' e1 b ∧ expr_bound' e2 b | LinearDecisionIntMP.Diff e1 e2 => expr_bound' e1 b ∧ expr_bound' e2 b | LinearDecisionIntMP.ProdL e1 _ => expr_bound' e1 b | LinearDecisionIntMP.ProdR _ e1 => expr_bound' e1 b | LinearDecisionIntMP.Var n => 0%Z ≤ n ∧ n ≤ b | LinearDecisionIntMP.Coeff _ => True end.
Admit Obligations.
Definition eq_bound' (eq : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') (b : Z) := match eq with | (e1, e2) => expr_bound' e1 b ∧ expr_bound' e2 b end.
Program Fixpoint ctx_bound' (ctx : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) (b : Z) : Prop :=
match ctx with | [] => True | cons eq t => eq_bound' eq b ∧ ctx_bound' t b end.
Admit Obligations.
Axiom max_var' : LinearDecisionIntMP.expr' -> Z.
Axiom max_var''def : forall  (e : LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_expr' e), match e with | LinearDecisionIntMP.Var i => max_var' e = i | LinearDecisionIntMP.Coeff _ => max_var' e = 0%Z | LinearDecisionIntMP.Sum e1 e2 => max_var' e = Z.max (max_var' e1) (max_var' e2) | LinearDecisionIntMP.Diff e1 e2 => max_var' e = Z.max (max_var' e1) (max_var' e2) | LinearDecisionIntMP.ProdL e1 _ => max_var' e = max_var' e1 | LinearDecisionIntMP.ProdR _ e1 => max_var' e = max_var' e1 end.
Axiom max_var''spec'0 : forall  (e : LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_expr' e), 0%Z ≤ max_var' e.
Axiom max_var''spec : forall  (e : LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_expr' e), expr_bound' e (max_var' e).
Axiom max_var_e' : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' -> Z.
Axiom max_var_e''def : forall  (e : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_eq' e), match e with | (e1, e2) => max_var_e' e = Z.max (max_var' e1) (max_var' e2) end.
Axiom max_var_e''spec'0 : forall  (e : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_eq' e), 0%Z ≤ max_var_e' e.
Axiom max_var_e''spec : forall  (e : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') (fact0 : LinearDecisionIntMP.valid_eq' e), eq_bound' e (max_var_e' e).
Axiom max_var_ctx' : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') -> Z.
Axiom max_var_ctx''def : forall  (l : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) (fact0 : LinearDecisionIntMP.valid_ctx' l), match l with | [] => max_var_ctx' l = 0%Z | cons e t => max_var_ctx' l = Z.max (max_var_e' e) (max_var_ctx' t) end.
Axiom max_var_ctx''spec'0 : forall  (l : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) (fact0 : LinearDecisionIntMP.valid_ctx' l), 0%Z ≤ max_var_ctx' l.
Axiom max_var_ctx''spec : forall  (l : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) (fact0 : LinearDecisionIntMP.valid_ctx' l), ctx_bound' l (max_var_ctx' l).
Program Fixpoint ctx_impl_ctx' (c1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) (c2 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) : Prop :=
match c2 with | [] => True | cons eq t => ctx_impl_ctx' c1 t ∧ (∀(y : Z -> Z) (z : Z -> Z), y = z -> LinearDecisionIntMP.interp_ctx' c1 eq y z = true) end.
Admit Obligations.
Program Fixpoint ctx_holds' (c : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) (y : Z -> Z) (z : Z -> Z) : Prop :=
match c with | [] => True | cons h t => LinearDecisionIntMP.interp_eq' h y z = true ∧ ctx_holds' t y z end.
Admit Obligations.
Definition is_eq_tbl (a : list (option MP64Coeffs.exp)) (l : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) := ∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length a) -> (match nth (Z.to_nat i) a inhabitant with | None => True | Some e => (∀(y : Z -> Z) (z : Z -> Z), y = z -> ctx_holds' l y z -> interp_exp (MP64Coeffs.Var i) z = interp_exp e z) end).
Axiom fc : forall {α : Type} `{Inhabited α}, list α -> α -> Z -> bool.
Axiom fc'def : forall  {α : Type} `{Inhabited α} (a : list α) (v : α) (i : Z), (fc a v i = true) = (nth (Z.to_nat i) a inhabitant = v).
Lemma prop_ctx'vc (g : LinearDecisionIntMP.expr') (g1 : LinearDecisionIntMP.expr') (l : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) : let g2 : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (g, g1) in LinearDecisionIntMP.valid_ctx' l ∧ LinearDecisionIntMP.valid_eq' g2 -> LinearDecisionIntMP.valid_eq' g2 ∧ (let o1 : Z := max_var_e' g2 in 0%Z ≤ o1 ∧ eq_bound' g2 o1 -> LinearDecisionIntMP.valid_ctx' l ∧ (let o2 : Z := max_var_ctx' l in 0%Z ≤ o2 ∧ ctx_bound' l o2 -> (let m : Z := Z.max o2 o1 in let o3 : Z := m + 1%Z in 0%Z ≤ o3 ∧ (∀(a : list (option MP64Coeffs.exp)), (∀(i : Z), 0%Z ≤ i ∧ i < o3 -> nth (Z.to_nat i) a inhabitant = None) ∧ Z.of_nat (length a) = o3 -> (∀(e : LinearDecisionIntMP.expr'), (match e with | LinearDecisionIntMP.Var i => True | LinearDecisionIntMP.Sum e1 e2 => (match e with | LinearDecisionIntMP.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.ProdL f _ => f = e2 | LinearDecisionIntMP.ProdR _ f => f = e2 | LinearDecisionIntMP.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ (∀(o4 : option MP64Coeffs.exp), (match o4 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e2 y y = interp_exp ex y) end) -> (match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ (∀(o5 : option MP64Coeffs.exp), (match o5 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e1 y y = interp_exp ex y) end) -> (match o4 with | Some x => (match o5 with | Some x1 => True | _ => True end) | _ => True end))) | LinearDecisionIntMP.Diff e1 e2 => (match e with | LinearDecisionIntMP.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.ProdL f _ => f = e2 | LinearDecisionIntMP.ProdR _ f => f = e2 | LinearDecisionIntMP.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ (∀(o4 : option MP64Coeffs.exp), (match o4 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e2 y y = interp_exp ex y) end) -> (match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ (∀(o5 : option MP64Coeffs.exp), (match o5 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e1 y y = interp_exp ex y) end) -> (match o4 with | Some x => (match o5 with | Some x1 => True | _ => True end) | _ => True end))) | LinearDecisionIntMP.Coeff (I n) => True | _ => True end) ∧ (∀(result : option MP64Coeffs.exp), (match e with | LinearDecisionIntMP.Var i => result = Some (MP64Coeffs.Var i) | LinearDecisionIntMP.Sum e1 e2 => (∃(o4 : option MP64Coeffs.exp), (match o4 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e2 y y = interp_exp ex y) end) ∧ (∃(o5 : option MP64Coeffs.exp), (match o5 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e1 y y = interp_exp ex y) end) ∧ (match o4 with | Some x => (match o5 with | Some x1 => result = Some (Plus x1 x) | _ => result = None end) | _ => result = None end))) | LinearDecisionIntMP.Diff e1 e2 => (∃(o4 : option MP64Coeffs.exp), (match o4 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e2 y y = interp_exp ex y) end) ∧ (∃(o5 : option MP64Coeffs.exp), (match o5 with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e1 y y = interp_exp ex y) end) ∧ (match o4 with | Some x => (match o5 with | Some x1 => result = Some (Sub x1 x) | _ => result = None end) | _ => result = None end))) | LinearDecisionIntMP.Coeff (I n) => result = Some (Lit n) | _ => result = None end) -> (match result with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' e y y = interp_exp ex y) end))) ∧ (∀(a1 : list (option MP64Coeffs.exp)), length a1 = length a -> (∀(eq : LinearDecisionIntMP.expr') (eq1 : LinearDecisionIntMP.expr'), let eq2 : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (eq, eq1) in eq_bound' eq2 m -> (match eq1 with | LinearDecisionIntMP.Var x => (match eq with | LinearDecisionIntMP.Var x1 => (∀(r : option MP64Coeffs.exp), (match r with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' eq1 y y = interp_exp ex y) end) -> (match r with | None => (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl a1 (cons eq2 l1)) | Some ex => (let o4 : option MP64Coeffs.exp := Some ex in (0%Z ≤ x1 ∧ x1 < Z.of_nat (length a1)) ∧ (length (set_list a1 (Z.to_nat x1) o4) = length a1 -> nth_i (set_list a1 (Z.to_nat x1) o4) = fun_updt (nth_i a1) x1 o4 -> (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl (set_list a1 (Z.to_nat x1) o4) (cons eq2 l1)))) end)) | _ => (∀(r : option MP64Coeffs.exp), (match r with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' eq y y = interp_exp ex y) end) -> (match r with | None => (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl a1 (cons eq2 l1)) | Some ex => (let o4 : option MP64Coeffs.exp := Some ex in (0%Z ≤ x ∧ x < Z.of_nat (length a1)) ∧ (length (set_list a1 (Z.to_nat x) o4) = length a1 -> nth_i (set_list a1 (Z.to_nat x) o4) = fun_updt (nth_i a1) x o4 -> (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl (set_list a1 (Z.to_nat x) o4) (cons eq2 l1)))) end)) end) | _ => (match eq with | LinearDecisionIntMP.Var x => (∀(r : option MP64Coeffs.exp), (match r with | None => True | Some ex => (∀(y : Z -> Z), LinearDecisionIntMP.interp' eq1 y y = interp_exp ex y) end) -> (match r with | None => (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl a1 (cons eq2 l1)) | Some ex => (let o4 : option MP64Coeffs.exp := Some ex in (0%Z ≤ x ∧ x < Z.of_nat (length a1)) ∧ (length (set_list a1 (Z.to_nat x) o4) = length a1 -> nth_i (set_list a1 (Z.to_nat x) o4) = fun_updt (nth_i a1) x o4 -> (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl (set_list a1 (Z.to_nat x) o4) (cons eq2 l1)))) end)) | _ => (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 l1 -> is_eq_tbl a1 (cons eq2 l1)) end) end))) ∧ (∀(a1 : list (option MP64Coeffs.exp)), length a1 = length a -> (∀(l1 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a1 ([] : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) ∧ ctx_bound' l1 m -> (match l1 with | [] => is_eq_tbl a1 l1 | cons eq l2 => ((match l1 with | [] => False | cons _ f => f = l2 end) ∧ is_eq_tbl a1 ([] : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) ∧ ctx_bound' l2 m) ∧ (∀(a2 : list (option MP64Coeffs.exp)), length a2 = length a1 -> is_eq_tbl a2 l2 -> eq_bound' eq m ∧ (∀(a3 : list (option MP64Coeffs.exp)), length a3 = length a2 -> (∀(l3 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), is_eq_tbl a2 l3 -> is_eq_tbl a3 (cons eq l3)) -> is_eq_tbl a3 l1)) end))) ∧ (is_eq_tbl a ([] : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) ∧ ctx_bound' l m) ∧ (∀(a1 : list (option MP64Coeffs.exp)), length a1 = length a -> is_eq_tbl a1 l -> (let o4 : Z := m + 1%Z in 0%Z ≤ o4 ∧ (∀(seen : list bool), (∀(i : Z), 0%Z ≤ i ∧ i < o4 -> nth (Z.to_nat i) seen inhabitant = false) ∧ Z.of_nat (length seen) = o4 -> (∀(seen1 : list bool) (a2 : list (option MP64Coeffs.exp)), length seen1 = length seen -> length a2 = length a1 -> (∀(i : Z), is_eq_tbl a2 l ∧ nth (Z.to_nat i) seen1 inhabitant = false -> (∀(seen2 : list bool) (a3 : list (option MP64Coeffs.exp)), length seen2 = length seen1 -> length a3 = length a2 -> (∀(e : MP64Coeffs.exp), is_eq_tbl a3 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen2)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false) -> (match e with | Lit _ => is_eq_tbl a3 l | MP64Coeffs.Var j => 0%Z ≤ j ∧ j < Z.of_nat (length seen2) -> (if decide (¬ nth (Z.to_nat j) seen2 inhabitant = true) then ((0%Z ≤ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false) ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen2)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ is_eq_tbl a3 l ∧ nth (Z.to_nat j) seen2 inhabitant = false) ∧ (∀(seen3 : list bool) (a4 : list (option MP64Coeffs.exp)), length seen3 = length seen2 -> length a4 = length a3 -> is_eq_tbl a4 l ∧ nth (Z.to_nat j) seen3 inhabitant = true ∧ (∀(j1 : Z), nth (Z.to_nat j1) seen2 inhabitant = true -> nth (Z.to_nat j1) seen3 inhabitant = true) -> 0%Z ≤ j ∧ j < Z.of_nat (length a4) -> (∀(result : MP64Coeffs.exp), (match nth (Z.to_nat j) a4 inhabitant with | None => result = e | Some e' => result = e' end) -> is_eq_tbl a4 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp result y) ∧ (∀(j1 : Z), nth (Z.to_nat j1) seen2 inhabitant = true -> nth (Z.to_nat j1) seen3 inhabitant = true))) else 0%Z ≤ j ∧ j < Z.of_nat (length a3) -> (∀(result : MP64Coeffs.exp), (match nth (Z.to_nat j) a3 inhabitant with | None => result = e | Some e' => result = e' end) -> is_eq_tbl a3 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp result y))) | Plus e1 e2 => ((match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e2 ∨ f1 = e2 | Minus f => f = e2 | Sub f f1 => f = e2 ∨ f1 = e2 end) ∧ is_eq_tbl a3 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen2)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ (∀(seen3 : list bool) (a4 : list (option MP64Coeffs.exp)), length seen3 = length seen2 -> length a4 = length a3 -> (∀(o5 : MP64Coeffs.exp), is_eq_tbl a4 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e2 y = interp_exp o5 y) ∧ (∀(j : Z), nth (Z.to_nat j) seen2 inhabitant = true -> nth (Z.to_nat j) seen3 inhabitant = true) -> ((match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ is_eq_tbl a4 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen3)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ (∀(seen4 : list bool) (a5 : list (option MP64Coeffs.exp)), length seen4 = length seen3 -> length a5 = length a4 -> (∀(o6 : MP64Coeffs.exp), is_eq_tbl a5 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o6 y) ∧ (∀(j : Z), nth (Z.to_nat j) seen3 inhabitant = true -> nth (Z.to_nat j) seen4 inhabitant = true) -> is_eq_tbl a5 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Plus o6 o5) y) ∧ (∀(j : Z), nth (Z.to_nat j) seen2 inhabitant = true -> nth (Z.to_nat j) seen4 inhabitant = true))))) | Sub e1 e2 => ((match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e2 ∨ f1 = e2 | Minus f => f = e2 | Sub f f1 => f = e2 ∨ f1 = e2 end) ∧ is_eq_tbl a3 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen2)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ (∀(seen3 : list bool) (a4 : list (option MP64Coeffs.exp)), length seen3 = length seen2 -> length a4 = length a3 -> (∀(o5 : MP64Coeffs.exp), is_eq_tbl a4 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e2 y = interp_exp o5 y) ∧ (∀(j : Z), nth (Z.to_nat j) seen2 inhabitant = true -> nth (Z.to_nat j) seen3 inhabitant = true) -> ((match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ is_eq_tbl a4 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen3)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ (∀(seen4 : list bool) (a5 : list (option MP64Coeffs.exp)), length seen4 = length seen3 -> length a5 = length a4 -> (∀(o6 : MP64Coeffs.exp), is_eq_tbl a5 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o6 y) ∧ (∀(j : Z), nth (Z.to_nat j) seen3 inhabitant = true -> nth (Z.to_nat j) seen4 inhabitant = true) -> is_eq_tbl a5 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Sub o6 o5) y) ∧ (∀(j : Z), nth (Z.to_nat j) seen2 inhabitant = true -> nth (Z.to_nat j) seen4 inhabitant = true))))) | Minus e1 => ((match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ is_eq_tbl a3 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen2)) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ (∀(seen3 : list bool) (a4 : list (option MP64Coeffs.exp)), length seen3 = length seen2 -> length a4 = length a3 -> (∀(o5 : MP64Coeffs.exp), is_eq_tbl a4 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o5 y) ∧ (∀(j : Z), nth (Z.to_nat j) seen2 inhabitant = true -> nth (Z.to_nat j) seen3 inhabitant = true) -> is_eq_tbl a4 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Minus o5) y) ∧ (∀(j : Z), nth (Z.to_nat j) seen2 inhabitant = true -> nth (Z.to_nat j) seen3 inhabitant = true))) end))) ∧ (length (set_list seen1 (Z.to_nat i) true) = length seen1 -> 0%Z ≤ i ∧ i < Z.of_nat (length (set_list seen1 (Z.to_nat i) true)) -> (0%Z ≤ i ∧ i < Z.of_nat (length a2)) ∧ (match nth (Z.to_nat i) a2 inhabitant with | None => is_eq_tbl a2 l ∧ nth (Z.to_nat i) (set_list seen1 (Z.to_nat i) true) inhabitant = true ∧ (∀(j : Z), nth (Z.to_nat j) seen1 inhabitant = true -> nth (Z.to_nat j) (set_list seen1 (Z.to_nat i) true) inhabitant = true) | Some e => (is_eq_tbl a2 l ∧ Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) (set_list seen1 (Z.to_nat i) true))) false) < Z.of_nat (count_occ' (drop 0%nat (take (Z.to_nat (m + 1%Z) - 0%nat) seen1)) false)) ∧ (∀(seen2 : list bool) (a3 : list (option MP64Coeffs.exp)), length seen2 = length (set_list seen1 (Z.to_nat i) true) -> length a3 = length a2 -> (∀(o5 : MP64Coeffs.exp), is_eq_tbl a3 l ∧ (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp o5 y) ∧ (∀(j : Z), nth (Z.to_nat j) (set_list seen1 (Z.to_nat i) true) inhabitant = true -> nth (Z.to_nat j) seen2 inhabitant = true) -> (let o6 : option MP64Coeffs.exp := Some o5 in (0%Z ≤ i ∧ i < Z.of_nat (length a3)) ∧ (length (set_list a3 (Z.to_nat i) o6) = length a3 -> nth_i (set_list a3 (Z.to_nat i) o6) = fun_updt (nth_i a3) i o6 -> is_eq_tbl (set_list a3 (Z.to_nat i) o6) l ∧ nth (Z.to_nat i) seen2 inhabitant = true ∧ (∀(j : Z), nth (Z.to_nat j) seen1 inhabitant = true -> nth (Z.to_nat j) seen2 inhabitant = true))))) end)))) ∧ (0%Z ≤ m + 1%Z -> is_eq_tbl a1 l ∧ (∀(seen1 : list bool) (a2 : list (option MP64Coeffs.exp)), length seen1 = length seen -> length a2 = length a1 -> (∀(i : Z), (0%Z ≤ i ∧ i ≤ m) ∧ is_eq_tbl a2 l -> (0%Z ≤ i ∧ i < Z.of_nat (length seen1)) ∧ (if decide (¬ nth (Z.to_nat i) seen1 inhabitant = true) then (is_eq_tbl a2 l ∧ nth (Z.to_nat i) seen1 inhabitant = false) ∧ (∀(seen2 : list bool) (a3 : list (option MP64Coeffs.exp)), length seen2 = length seen1 -> length a3 = length a2 -> is_eq_tbl a3 l ∧ nth (Z.to_nat i) seen2 inhabitant = true ∧ (∀(j : Z), nth (Z.to_nat j) seen1 inhabitant = true -> nth (Z.to_nat j) seen2 inhabitant = true) -> is_eq_tbl a3 l) else is_eq_tbl a2 l)) ∧ (is_eq_tbl a2 l -> (∀(e : MP64Coeffs.exp), (match e with | Lit _ => True | MP64Coeffs.Var i => 0%Z ≤ i ∧ i < Z.of_nat (length a2) -> (∀(result : MP64Coeffs.exp), (match nth (Z.to_nat i) a2 inhabitant with | Some e' => result = e' | None => result = e end) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp result y)) | Plus e1 e2 => (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e2 ∨ f1 = e2 | Minus f => f = e2 | Sub f f1 => f = e2 ∨ f1 = e2 end) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e2 y = interp_exp o5 y) -> (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o6 y) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Plus o6 o5) y))) | Sub e1 e2 => (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e2 ∨ f1 = e2 | Minus f => f = e2 | Sub f f1 => f = e2 ∨ f1 = e2 end) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e2 y = interp_exp o5 y) -> (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o6 y) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Sub o6 o5) y))) | Minus e1 => (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o5 y) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Minus o5) y)) end)) ∧ (∀(c : LinearDecisionIntMP.t), (match c with | I _ => (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff c) y y = true) | E e => (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp o5 y) -> (let result : LinearDecisionIntMP.t := E o5 in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff result) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c y -> pos_exp result y))) | LinearDecisionIntMP.R => (let result : LinearDecisionIntMP.t := LinearDecisionIntMP.R in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff result) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c y -> pos_exp result y)) end)) ∧ (∀(c : LinearDecisionIntMP.cprod), (match c with | LinearDecisionIntMP.C c1 => (∀(o5 : LinearDecisionIntMP.t), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c1, LinearDecisionIntMP.Coeff o5) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c1 y -> pos_exp o5 y) -> (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.C o5 in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod result y))) | LinearDecisionIntMP.Times c1 c2 => (match c with | LinearDecisionIntMP.C _ => False | LinearDecisionIntMP.Times f f1 => f = c2 ∨ f1 = c2 end) ∧ (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c2 y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c2 y -> pos_cprod o5 y) -> (match c with | LinearDecisionIntMP.C _ => False | LinearDecisionIntMP.Times f f1 => f = c1 ∨ f1 = c1 end) ∧ (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c1 y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c1 y -> pos_cprod o6 y) -> (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.Times o6 o5 in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod result y)))) end)) ∧ (∀(e : LinearDecisionIntMP.expr'), expr_bound' e m ∧ LinearDecisionIntMP.valid_expr' e -> (match e with | LinearDecisionIntMP.Var _ => expr_bound' e m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, e) y y = true) ∧ LinearDecisionIntMP.valid_expr' e | LinearDecisionIntMP.ProdL e1 c => (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod o5 y) -> ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.ProdL o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.ProdR c e1 => ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o5 y) -> (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.ProdR o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.Sum e1 e2 => ((match e with | LinearDecisionIntMP.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.ProdL f _ => f = e2 | LinearDecisionIntMP.ProdR _ f => f = e2 | LinearDecisionIntMP.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e2 y -> pos_expr' o5 y) -> ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.Sum o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.Diff e1 e2 => ((match e with | LinearDecisionIntMP.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.ProdL f _ => f = e2 | LinearDecisionIntMP.ProdR _ f => f = e2 | LinearDecisionIntMP.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e2 y -> pos_expr' o5 y) -> ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.Diff o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.Coeff c => (∀(o5 : LinearDecisionIntMP.t), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff o5) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c y -> pos_exp o5 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.Coeff o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y))) end)) ∧ (∀(a3 : LinearDecisionIntMP.expr') (b : LinearDecisionIntMP.expr'), let eq : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (a3, b) in eq_bound' eq m ∧ LinearDecisionIntMP.valid_eq' eq -> (expr_bound' b m ∧ LinearDecisionIntMP.valid_expr' b) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (b, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' b y -> pos_expr' o5 y) -> (expr_bound' a3 m ∧ LinearDecisionIntMP.valid_expr' a3) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (a3, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' a3 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (o6, o5) in eq_bound' result m ∧ (∀(y : Z -> Z), (LinearDecisionIntMP.interp_ctx' l eq y y = true) = (LinearDecisionIntMP.interp_ctx' l result y y = true)) ∧ LinearDecisionIntMP.valid_eq' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_eq' eq y -> pos_eq' result y))))) ∧ (∀(acc : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), ctx_bound' acc m ∧ ctx_impl_ctx' l acc ∧ LinearDecisionIntMP.valid_ctx' acc -> (match acc with | [] => (let result : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') := ([] : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) in ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ length result = length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' acc y -> pos_ctx' result y)) | cons h t => (eq_bound' h m ∧ LinearDecisionIntMP.valid_eq' h) ∧ (∀(h' : LinearDecisionIntMP.expr') (h'1 : LinearDecisionIntMP.expr'), let h'2 : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (h', h'1) in eq_bound' h'2 m ∧ (∀(y : Z -> Z), (LinearDecisionIntMP.interp_ctx' l h y y = true) = (LinearDecisionIntMP.interp_ctx' l h'2 y y = true)) ∧ LinearDecisionIntMP.valid_eq' h'2 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_eq' h y -> pos_eq' h'2 y) -> ((match acc with | [] => False | cons _ f => f = t end) ∧ ctx_bound' t m ∧ ctx_impl_ctx' l t ∧ LinearDecisionIntMP.valid_ctx' t) ∧ (∀(t' : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), ctx_bound' t' m ∧ ctx_impl_ctx' l t' ∧ length t' = length t ∧ LinearDecisionIntMP.valid_ctx' t' ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' t y -> pos_ctx' t' y) -> (let result : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') := cons h'2 t' in ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ length result = length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' acc y -> pos_ctx' result y)))) end)) ∧ (eq_bound' g2 m ∧ LinearDecisionIntMP.valid_eq' g2) ∧ (∀(o5 : LinearDecisionIntMP.expr') (o6 : LinearDecisionIntMP.expr'), let o7 : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (o5, o6) in eq_bound' o7 m ∧ (∀(y : Z -> Z), (LinearDecisionIntMP.interp_ctx' l g2 y y = true) = (LinearDecisionIntMP.interp_ctx' l o7 y y = true)) ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_eq' g2 y -> pos_eq' o7 y) -> (ctx_bound' l m ∧ ctx_impl_ctx' l l ∧ LinearDecisionIntMP.valid_ctx' l) ∧ (∀(o8 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), ctx_bound' o8 m ∧ ctx_impl_ctx' l o8 ∧ length o8 = length l ∧ LinearDecisionIntMP.valid_ctx' o8 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' l y -> pos_ctx' o8 y) -> length o8 = length l ∧ (LinearDecisionIntMP.valid_ctx' o8 ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : Z -> Z), LinearDecisionIntMP.interp_ctx' o8 o7 y y = true -> LinearDecisionIntMP.interp_ctx' l g2 y y = true)) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' l y -> pos_eq' g2 y -> pos_ctx' o8 y ∧ pos_eq' o7 y)))))) ∧ (m + 1%Z < 0%Z -> (∀(e : MP64Coeffs.exp), (match e with | Lit _ => True | MP64Coeffs.Var i => 0%Z ≤ i ∧ i < Z.of_nat (length a1) -> (∀(result : MP64Coeffs.exp), (match nth (Z.to_nat i) a1 inhabitant with | Some e' => result = e' | None => result = e end) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp result y)) | Plus e1 e2 => (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e2 ∨ f1 = e2 | Minus f => f = e2 | Sub f f1 => f = e2 ∨ f1 = e2 end) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e2 y = interp_exp o5 y) -> (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o6 y) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Plus o6 o5) y))) | Sub e1 e2 => (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e2 ∨ f1 = e2 | Minus f => f = e2 | Sub f f1 => f = e2 ∨ f1 = e2 end) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e2 y = interp_exp o5 y) -> (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ (∀(o6 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o6 y) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Sub o6 o5) y))) | Minus e1 => (match e with | Lit _ => False | MP64Coeffs.Var _ => False | Plus f f1 => f = e1 ∨ f1 = e1 | Minus f => f = e1 | Sub f f1 => f = e1 ∨ f1 = e1 end) ∧ (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e1 y = interp_exp o5 y) -> (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp (Minus o5) y)) end)) ∧ (∀(c : LinearDecisionIntMP.t), (match c with | I _ => (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff c) y y = true) | E e => (∀(o5 : MP64Coeffs.exp), (∀(y : Z -> Z), ctx_holds' l y y -> interp_exp e y = interp_exp o5 y) -> (let result : LinearDecisionIntMP.t := E o5 in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff result) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c y -> pos_exp result y))) | LinearDecisionIntMP.R => (let result : LinearDecisionIntMP.t := LinearDecisionIntMP.R in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff result) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c y -> pos_exp result y)) end)) ∧ (∀(c : LinearDecisionIntMP.cprod), (match c with | LinearDecisionIntMP.C c1 => (∀(o5 : LinearDecisionIntMP.t), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c1, LinearDecisionIntMP.Coeff o5) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c1 y -> pos_exp o5 y) -> (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.C o5 in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod result y))) | LinearDecisionIntMP.Times c1 c2 => (match c with | LinearDecisionIntMP.C _ => False | LinearDecisionIntMP.Times f f1 => f = c2 ∨ f1 = c2 end) ∧ (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c2 y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c2 y -> pos_cprod o5 y) -> (match c with | LinearDecisionIntMP.C _ => False | LinearDecisionIntMP.Times f f1 => f = c1 ∨ f1 = c1 end) ∧ (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c1 y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c1 y -> pos_cprod o6 y) -> (let result : LinearDecisionIntMP.cprod := LinearDecisionIntMP.Times o6 o5 in (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c result y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod result y)))) end)) ∧ (∀(e : LinearDecisionIntMP.expr'), expr_bound' e m ∧ LinearDecisionIntMP.valid_expr' e -> (match e with | LinearDecisionIntMP.Var _ => expr_bound' e m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, e) y y = true) ∧ LinearDecisionIntMP.valid_expr' e | LinearDecisionIntMP.ProdL e1 c => (∀(o5 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o5 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod o5 y) -> ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.ProdL o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.ProdR c e1 => ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o5 y) -> (∀(o6 : LinearDecisionIntMP.cprod), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_c c y y = LinearDecisionIntMP.interp_c o6 y y) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_cprod c y -> pos_cprod o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.ProdR o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.Sum e1 e2 => ((match e with | LinearDecisionIntMP.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.ProdL f _ => f = e2 | LinearDecisionIntMP.ProdR _ f => f = e2 | LinearDecisionIntMP.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e2 y -> pos_expr' o5 y) -> ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.Sum o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.Diff e1 e2 => ((match e with | LinearDecisionIntMP.Sum f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.ProdL f _ => f = e2 | LinearDecisionIntMP.ProdR _ f => f = e2 | LinearDecisionIntMP.Diff f f1 => f = e2 ∨ f1 = e2 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e2 m ∧ LinearDecisionIntMP.valid_expr' e2) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e2, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e2 y -> pos_expr' o5 y) -> ((match e with | LinearDecisionIntMP.Sum f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.ProdL f _ => f = e1 | LinearDecisionIntMP.ProdR _ f => f = e1 | LinearDecisionIntMP.Diff f f1 => f = e1 ∨ f1 = e1 | LinearDecisionIntMP.Var _ => False | LinearDecisionIntMP.Coeff _ => False end) ∧ expr_bound' e1 m ∧ LinearDecisionIntMP.valid_expr' e1) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e1, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e1 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.Diff o6 o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y)))) | LinearDecisionIntMP.Coeff c => (∀(o5 : LinearDecisionIntMP.t), (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (LinearDecisionIntMP.Coeff c, LinearDecisionIntMP.Coeff o5) y y = true) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_exp c y -> pos_exp o5 y) -> (let result : LinearDecisionIntMP.expr' := LinearDecisionIntMP.Coeff o5 in expr_bound' result m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (e, result) y y = true) ∧ LinearDecisionIntMP.valid_expr' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' e y -> pos_expr' result y))) end)) ∧ (∀(a2 : LinearDecisionIntMP.expr') (b : LinearDecisionIntMP.expr'), let eq : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (a2, b) in eq_bound' eq m ∧ LinearDecisionIntMP.valid_eq' eq -> (expr_bound' b m ∧ LinearDecisionIntMP.valid_expr' b) ∧ (∀(o5 : LinearDecisionIntMP.expr'), expr_bound' o5 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (b, o5) y y = true) ∧ LinearDecisionIntMP.valid_expr' o5 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' b y -> pos_expr' o5 y) -> (expr_bound' a2 m ∧ LinearDecisionIntMP.valid_expr' a2) ∧ (∀(o6 : LinearDecisionIntMP.expr'), expr_bound' o6 m ∧ (∀(y : Z -> Z), ctx_holds' l y y -> LinearDecisionIntMP.interp_eq' (a2, o6) y y = true) ∧ LinearDecisionIntMP.valid_expr' o6 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_expr' a2 y -> pos_expr' o6 y) -> (let result : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (o6, o5) in eq_bound' result m ∧ (∀(y : Z -> Z), (LinearDecisionIntMP.interp_ctx' l eq y y = true) = (LinearDecisionIntMP.interp_ctx' l result y y = true)) ∧ LinearDecisionIntMP.valid_eq' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_eq' eq y -> pos_eq' result y))))) ∧ (∀(acc : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), ctx_bound' acc m ∧ ctx_impl_ctx' l acc ∧ LinearDecisionIntMP.valid_ctx' acc -> (match acc with | [] => (let result : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') := ([] : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')) in ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ length result = length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' acc y -> pos_ctx' result y)) | cons h t => (eq_bound' h m ∧ LinearDecisionIntMP.valid_eq' h) ∧ (∀(h' : LinearDecisionIntMP.expr') (h'1 : LinearDecisionIntMP.expr'), let h'2 : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (h', h'1) in eq_bound' h'2 m ∧ (∀(y : Z -> Z), (LinearDecisionIntMP.interp_ctx' l h y y = true) = (LinearDecisionIntMP.interp_ctx' l h'2 y y = true)) ∧ LinearDecisionIntMP.valid_eq' h'2 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_eq' h y -> pos_eq' h'2 y) -> ((match acc with | [] => False | cons _ f => f = t end) ∧ ctx_bound' t m ∧ ctx_impl_ctx' l t ∧ LinearDecisionIntMP.valid_ctx' t) ∧ (∀(t' : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), ctx_bound' t' m ∧ ctx_impl_ctx' l t' ∧ length t' = length t ∧ LinearDecisionIntMP.valid_ctx' t' ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' t y -> pos_ctx' t' y) -> (let result : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr') := cons h'2 t' in ctx_bound' result m ∧ ctx_impl_ctx' l result ∧ length result = length acc ∧ LinearDecisionIntMP.valid_ctx' result ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' acc y -> pos_ctx' result y)))) end)) ∧ (eq_bound' g2 m ∧ LinearDecisionIntMP.valid_eq' g2) ∧ (∀(o5 : LinearDecisionIntMP.expr') (o6 : LinearDecisionIntMP.expr'), let o7 : LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr' := (o5, o6) in eq_bound' o7 m ∧ (∀(y : Z -> Z), (LinearDecisionIntMP.interp_ctx' l g2 y y = true) = (LinearDecisionIntMP.interp_ctx' l o7 y y = true)) ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_eq' g2 y -> pos_eq' o7 y) -> (ctx_bound' l m ∧ ctx_impl_ctx' l l ∧ LinearDecisionIntMP.valid_ctx' l) ∧ (∀(o8 : list (LinearDecisionIntMP.expr' * LinearDecisionIntMP.expr')), ctx_bound' o8 m ∧ ctx_impl_ctx' l o8 ∧ length o8 = length l ∧ LinearDecisionIntMP.valid_ctx' o8 ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' l y -> pos_ctx' o8 y) -> length o8 = length l ∧ (LinearDecisionIntMP.valid_ctx' o8 ∧ LinearDecisionIntMP.valid_eq' o7 ∧ (∀(y : Z -> Z), LinearDecisionIntMP.interp_ctx' o8 o7 y y = true -> LinearDecisionIntMP.interp_ctx' l g2 y y = true)) ∧ (∀(y : Z -> Z), ctx_holds' l y y -> pos_ctx' l y -> pos_eq' g2 y -> pos_ctx' o8 y ∧ pos_eq' o7 y))))))))))).
Admitted.
