From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.debug.Debug.
Require Import multiprecision.lineardecision.RationalCoeffs.
Open Scope Z_scope.
Axiom evars : Type.
Axiom evars_inhabited : Inhabited evars.
Global Existing Instance evars_inhabited.
Axiom evars_countable : Countable evars.
Global Existing Instance evars_countable.
Inductive exp :=
  | Lit : Z -> exp
  | Var : Z -> exp
  | Plus : exp -> exp -> exp
  | Minus : exp -> exp
  | Sub : exp -> exp -> exp.
Axiom exp_inhabited : Inhabited exp.
Global Existing Instance exp_inhabited.
Axiom exp_countable : Countable exp.
Global Existing Instance exp_countable.
Axiom t : Type.
Axiom t_inhabited : Inhabited t.
Global Existing Instance t_inhabited.
Axiom t_countable : Countable t.
Global Existing Instance t_countable.
Definition qinterp (q : Z * Z) : R := match q with | (n, d) => Rdiv (Rdefinitions.IZR n) (Rdefinitions.IZR d) end.
Program Fixpoint interp_exp (e : exp) (y : Z -> Z) : Z :=
match e with | Lit n => n | Var v => y v | Plus e1 e2 => interp_exp e1 y + interp_exp e2 y | Sub e1 e2 => interp_exp e1 y - interp_exp e2 y | Minus e' => - interp_exp e' y end.
Admit Obligations.
Definition minterp (t1 : Z * Z * exp) (y : Z -> Z) : R := match t1 with | (q, e) => Rmult (qinterp q) (Rpower (Rdefinitions.IZR (18446744073709551615%Z + 1%Z)) (Rdefinitions.IZR (interp_exp e y))) end.
Lemma add_sub_exp'vc (e2 : exp) (s : bool) (e1 : exp) : (∀(e : exp) (a : exp) (s : bool), (match a with | Lit x => (match e with | Lit x1 => (∀(o1 : exp), (if decide (s = true) then o1 = Lit (x1 + x) else o1 = Lit (x1 - x)) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) | Var x1 => (∀(r : exp) (result : bool), (if decide (x = 0%Z) then r = Var x1 ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Minus x1 => (∀(r : exp) (result : bool), (if decide (x = 0%Z) then r = Minus x1 ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Plus x1 x2 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then r1 = x2 ∧ result = true else r1 = Plus r x2 ∧ result = true) | _ => r1 = Plus r x2 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp (Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | Sub x1 x2 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then (∀(y : Z -> Z), interp_exp r1 y = - interp_exp x2 y) ∧ result = true else r1 = Sub r x2 ∧ result = true) | _ => r1 = Sub r x2 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) -> (∀(r2 : exp) (result : bool), (if decide (b1 = true) then r2 = Sub x1 r1 ∧ result = true else if decide (s = true) then r2 = Sub (Plus x1 a) x2 ∧ result = false else r2 = Sub x1 (Plus x2 a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) end) | Var x => (match e with | Lit x1 => (∀(r : exp) (result : bool), (if decide (x1 = 0%Z) then (if decide (s = true) then r = Var x else r = Minus (Var x)) ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Minus x1 => (match x1 with | Var x2 => (∀(o1 : bool), (if decide (s = true) then o1 = (if decide (x = x2) then true else false) else o1 = false) -> (∀(r : exp) (result : bool), (if decide (o1 = true) then r = Lit 0%Z ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | _ => True end) | Var x1 => (∀(r : exp) (result : bool), (if decide (s = true) then r = Plus e a ∧ result = false else if decide (x1 = x) then r = Lit 0%Z ∧ result = true else r = Sub e a ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Plus x1 x2 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then r1 = x2 ∧ result = true else r1 = Plus r x2 ∧ result = true) | _ => r1 = Plus r x2 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp (Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | Sub x1 x2 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then (∀(y : Z -> Z), interp_exp r1 y = - interp_exp x2 y) ∧ result = true else r1 = Sub r x2 ∧ result = true) | _ => r1 = Sub r x2 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) -> (∀(r2 : exp) (result : bool), (if decide (b1 = true) then r2 = Sub x1 r1 ∧ result = true else if decide (s = true) then r2 = Sub (Plus x1 a) x2 ∧ result = false else r2 = Sub x1 (Plus x2 a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) end) | Minus x => (match x with | Var x1 => (match e with | Lit x2 => (∀(r : exp) (result : bool), (if decide (x2 = 0%Z) then (if decide (s = true) then r = Minus x else r = x) ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Var x2 => (∀(o1 : bool), (if decide (s = true) then o1 = (if decide (x2 = x1) then true else false) else o1 = false) -> (∀(r : exp) (result : bool), (if decide (o1 = true) then r = Lit 0%Z ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | Minus x2 => (match x2 with | Var x3 => (∀(o1 : bool), (if decide (¬ s = true) then o1 = (if decide (x3 = x1) then true else false) else o1 = false) -> (∀(r : exp) (result : bool), (if decide (o1 = true) then r = Lit 0%Z ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y))) | _ => (∀(o1 : exp), (if decide (s = true) then o1 = Plus e a else o1 = Sub e a) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) end) | Plus x2 x3 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x2 y + interp_exp a y else interp_exp r y = interp_exp x2 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then r1 = x3 ∧ result = true else r1 = Plus r x3 ∧ result = true) | _ => r1 = Plus r x3 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x3 ∨ f1 = x3 | Minus f => f = x3 | Sub f f1 => f = x3 ∨ f1 = x3 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp x3 y + interp_exp a y else interp_exp r1 y = interp_exp x3 y - interp_exp a y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp (Plus x2 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x2 r1) y = interp_exp e y - interp_exp a y)))) | Sub x2 x3 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x2 y + interp_exp a y else interp_exp r y = interp_exp x2 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then (∀(y : Z -> Z), interp_exp r1 y = - interp_exp x3 y) ∧ result = true else r1 = Sub r x3 ∧ result = true) | _ => r1 = Sub r x3 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x3 ∨ f1 = x3 | Minus f => f = x3 | Sub f f1 => f = x3 ∨ f1 = x3 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp r1 y = interp_exp x3 y + interp_exp a y else interp_exp r1 y = interp_exp x3 y - interp_exp a y) -> (∀(r2 : exp) (result : bool), (if decide (b1 = true) then r2 = Sub x2 r1 ∧ result = true else if decide (s = true) then r2 = Sub (Plus x2 a) x3 ∧ result = false else r2 = Sub x2 (Plus x3 a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) end) | _ => (match e with | Lit x1 => (∀(r : exp) (result : bool), (if decide (x1 = 0%Z) then (if decide (s = true) then r = Minus x else r = x) ∧ result = true else (if decide (s = true) then r = Plus e a else r = Sub e a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e y + interp_exp a y else interp_exp r y = interp_exp e y - interp_exp a y)) | Minus x1 => (∀(o1 : exp), (if decide (s = true) then o1 = Plus e a else o1 = Sub e a) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp o1 y = interp_exp e y + interp_exp a y else interp_exp o1 y = interp_exp e y - interp_exp a y)) | Plus x1 x2 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then r1 = x2 ∧ result = true else r1 = Plus r x2 ∧ result = true) | _ => r1 = Plus r x2 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp (Plus x1 r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x1 r1) y = interp_exp e y - interp_exp a y)))) | Sub x1 x2 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x1 y + interp_exp a y else interp_exp r y = interp_exp x1 y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then (∀(y : Z -> Z), interp_exp r1 y = - interp_exp x2 y) ∧ result = true else r1 = Sub r x2 ∧ result = true) | _ => r1 = Sub r x2 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x2 ∨ f1 = x2 | Minus f => f = x2 | Sub f f1 => f = x2 ∨ f1 = x2 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp r1 y = interp_exp x2 y + interp_exp a y else interp_exp r1 y = interp_exp x2 y - interp_exp a y) -> (∀(r2 : exp) (result : bool), (if decide (b1 = true) then r2 = Sub x1 r1 ∧ result = true else if decide (s = true) then r2 = Sub (Plus x1 a) x2 ∧ result = false else r2 = Sub x1 (Plus x2 a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) | _ => True end) end) | _ => (match e with | Plus x x1 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x ∨ f1 = x | Minus f => f = x | Sub f f1 => f = x ∨ f1 = x end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x y + interp_exp a y else interp_exp r y = interp_exp x y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then r1 = x1 ∧ result = true else r1 = Plus r x1 ∧ result = true) | _ => r1 = Plus r x1 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp x1 y + interp_exp a y else interp_exp r1 y = interp_exp x1 y - interp_exp a y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp (Plus x r1) y = interp_exp e y + interp_exp a y else interp_exp (Plus x r1) y = interp_exp e y - interp_exp a y)))) | Sub x x1 => (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x ∨ f1 = x | Minus f => f = x | Sub f f1 => f = x ∨ f1 = x end) ∧ (∀(r : exp) (b : bool), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp x y + interp_exp a y else interp_exp r y = interp_exp x y - interp_exp a y) -> (if decide (b = true) then (match r with | Lit n => True | _ => True end) ∧ (∀(r1 : exp) (result : bool), (match r with | Lit n => (if decide (n = 0%Z) then (∀(y : Z -> Z), interp_exp r1 y = - interp_exp x1 y) ∧ result = true else r1 = Sub r x1 ∧ result = true) | _ => r1 = Sub r x1 ∧ result = true end) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r1 y = interp_exp e y + interp_exp a y else interp_exp r1 y = interp_exp e y - interp_exp a y)) else (match e with | Lit _ => False | Var _ => False | Plus f f1 => f = x1 ∨ f1 = x1 | Minus f => f = x1 | Sub f f1 => f = x1 ∨ f1 = x1 end) ∧ (∀(r1 : exp) (b1 : bool), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp r1 y = interp_exp x1 y + interp_exp a y else interp_exp r1 y = interp_exp x1 y - interp_exp a y) -> (∀(r2 : exp) (result : bool), (if decide (b1 = true) then r2 = Sub x r1 ∧ result = true else if decide (s = true) then r2 = Sub (Plus x a) x1 ∧ result = false else r2 = Sub x (Plus x1 a) ∧ result = false) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp r2 y = interp_exp e y + interp_exp a y else interp_exp r2 y = interp_exp e y - interp_exp a y))))) | _ => True end) end)) ∧ (match e2 with | Plus e1' e2' => (match e2 with | Lit _ => False | Var _ => False | Plus f f1 => f = e1' ∨ f1 = e1' | Minus f => f = e1' | Sub f f1 => f = e1' ∨ f1 = e1' end) ∧ (∀(r : exp), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e1 y + interp_exp e1' y else interp_exp r y = interp_exp e1 y - interp_exp e1' y) -> (match r with | Lit n => (if decide (n = 0%Z) then ∀(result : exp), (if decide (s = true) then result = e2' else ∀(y : Z -> Z), interp_exp result y = - interp_exp e2' y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y) else ((match e2 with | Lit _ => False | Var _ => False | Plus f f1 => f = e2' ∨ f1 = e2' | Minus f => f = e2' | Sub f f1 => f = e2' ∨ f1 = e2' end) ∨ e2 = e2' ∧ (match e1 with | Lit _ => False | Var _ => False | Plus f f1 => f = r ∨ f1 = r | Minus f => f = r | Sub f f1 => f = r ∨ f1 = r end)) ∧ (∀(result : exp), (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y))) | _ => ((match e2 with | Lit _ => False | Var _ => False | Plus f f1 => f = e2' ∨ f1 = e2' | Minus f => f = e2' | Sub f f1 => f = e2' ∨ f1 = e2' end) ∨ e2 = e2' ∧ (match e1 with | Lit _ => False | Var _ => False | Plus f f1 => f = r ∨ f1 = r | Minus f => f = r | Sub f f1 => f = r ∨ f1 = r end)) ∧ (∀(result : exp), (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y)) end)) | Sub e1' e2' => (match e2 with | Lit _ => False | Var _ => False | Plus f f1 => f = e1' ∨ f1 = e1' | Minus f => f = e1' | Sub f f1 => f = e1' ∨ f1 = e1' end) ∧ (∀(r : exp), (∀(y : Z -> Z), if decide (s = true) then interp_exp r y = interp_exp e1 y + interp_exp e1' y else interp_exp r y = interp_exp e1 y - interp_exp e1' y) -> (match r with | Lit n => (if decide (n = 0%Z) then ∀(result : exp), (if decide (s = true) then ∀(y : Z -> Z), interp_exp result y = - interp_exp e2' y else result = e2') -> (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y) else ((match e2 with | Lit _ => False | Var _ => False | Plus f f1 => f = e2' ∨ f1 = e2' | Minus f => f = e2' | Sub f f1 => f = e2' ∨ f1 = e2' end) ∨ e2 = e2' ∧ (match e1 with | Lit _ => False | Var _ => False | Plus f f1 => f = r ∨ f1 = r | Minus f => f = r | Sub f f1 => f = r ∨ f1 = r end)) ∧ (∀(result : exp), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y))) | _ => ((match e2 with | Lit _ => False | Var _ => False | Plus f f1 => f = e2' ∨ f1 = e2' | Minus f => f = e2' | Sub f f1 => f = e2' ∨ f1 = e2' end) ∨ e2 = e2' ∧ (match e1 with | Lit _ => False | Var _ => False | Plus f f1 => f = r ∨ f1 = r | Minus f => f = r | Sub f f1 => f = r ∨ f1 = r end)) ∧ (∀(result : exp), (∀(y : Z -> Z), if decide (¬ s = true) then interp_exp result y = interp_exp r y + interp_exp e2' y else interp_exp result y = interp_exp r y - interp_exp e2' y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp result y = interp_exp e1 y + interp_exp e2 y else interp_exp result y = interp_exp e1 y - interp_exp e2 y)) end)) | _ => (∀(o1 : exp), (∀(y : Z -> Z), if decide (s = true) then interp_exp o1 y = interp_exp e1 y + interp_exp e2 y else interp_exp o1 y = interp_exp e1 y - interp_exp e2 y) -> (∀(y : Z -> Z), if decide (s = true) then interp_exp o1 y = interp_exp e1 y + interp_exp e2 y else interp_exp o1 y = interp_exp e1 y - interp_exp e2 y)) end).
Admitted.
