import Mathlib

open Classical

namespace Lean4Why3

instance {n : Nat} : HShiftLeft (BitVec n) Int (BitVec n) where
  hShiftLeft x k := x <<< k.toNat

instance {n : Nat} : HShiftRight (BitVec n) Int (BitVec n) where
  hShiftRight x k := x >>> k.toNat

abbrev sshiftRight'i {n : ℕ} (a : BitVec n) (s : Int) : BitVec n := a.sshiftRight s.toNat

abbrev make_str_i (size : Int) := String.mk (List.replicate (Int.toNat size) 'a')
abbrev _root_.List.create_i {α} (n : ℤ) (f : ℤ -> α) := (List.range n.toNat).map f
abbrev _root_.List.create {α} (n : ℕ) (f : ℕ -> α) := (List.range n).map f

abbrev _root_.Bool.imp (a b : Bool) : Bool := !a || b

abbrev _root_.List.replicate_i {α} (n : ℤ) (x : α) := List.replicate (Int.toNat n) x

abbrev take_i {α : Type} (n : ℤ) (l : List α) := List.take n.toNat l
abbrev drop_i {α : Type} (n : ℤ) (l : List α) := List.drop n.toNat l

abbrev getElem_i! {α : Type} [Inhabited α] (l : List α) (i : Int) := l[i.toNat]!
abbrev getElem_i? {α : Type} (l : List α) (i : Int) := l[i.toNat]?

abbrev length_i {α : Type} (l : List α) := Int.ofNat l.length
abbrev slice {α : Type} (l : List α) (i j : Nat) : List α :=
  (l.drop i).take (j - i)
abbrev slice_i {α : Type} (l : List α) (i j : Int) : List α :=
  (l.drop i.toNat).take (j.toNat - i.toNat)

abbrev Sorted {α : Type} [LE α] (l : List α) := List.Sorted LE.le l
abbrev _root_.List.set_i {α : Type} (l : List α) (n : ℤ) (a : α) :=
  List.set l n.toNat a

abbrev implication (P : Prop) (Q : Prop) := P -> Q

noncomputable def map_occ {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := {n | l ≤ n ∧ n < u ∧ m n = v }.ncard
noncomputable abbrev map_occ_i {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := Int.ofNat (map_occ (v : α) (m : Int -> α) (l : Int) u)

abbrev _root_.BitVec.toUInt {n : Nat} (x : BitVec n) := Int.ofNat x.toNat

abbrev int'16_max : BitVec 16 := 32767
abbrev int'16_min : BitVec 16 := -32768
abbrev int'31_max : BitVec 31 := 1073741823
abbrev int'31_min : BitVec 31 := -1073741824
abbrev int'32_max : BitVec 32 := 2147483647
abbrev int'32_min : BitVec 32 := -2147483648
abbrev int'63_max : BitVec 63 := 4611686018427387903
abbrev int'63_min : BitVec 63 := -4611686018427387904
abbrev int'64_max : BitVec 64 := 9223372036854775807
abbrev int'64_min : BitVec 64 := -9223372036854775808
abbrev uint'16_max : BitVec 16 := 65535
abbrev uint'16_min : BitVec 16 := 0
abbrev uint'31_max : BitVec 31 := 2147483647
abbrev uint'31_min : BitVec 31 := 0
abbrev uint'32_max : BitVec 32 := 4294967295
abbrev uint'32_min : BitVec 32 := 0
abbrev uint'63_max : BitVec 63 := 9223372036854775807
abbrev uint'63_min : BitVec 63 := 0
abbrev uint'64_max : BitVec 64 := 18446744073709551615
abbrev uint'64_min : BitVec 64 := 0

abbrev int'16_in_bounds (x : Int) := int'16_min.toInt ≤ x ∧ x ≤ int'16_max.toInt
abbrev int'31_in_bounds (x : Int) := int'31_min.toInt ≤ x ∧ x ≤ int'31_max.toInt
abbrev int'32_in_bounds (x : Int) := int'32_min.toInt ≤ x ∧ x ≤ int'32_max.toInt
abbrev int'63_in_bounds (x : Int) := int'63_min.toInt ≤ x ∧ x ≤ int'63_max.toInt
abbrev int'64_in_bounds (x : Int) := int'64_min.toInt ≤ x ∧ x ≤ int'64_max.toInt
abbrev uint'8_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ 256
abbrev uint'16_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'16_max.toUInt
abbrev uint'31_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'31_max.toUInt
abbrev uint'32_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'32_max.toUInt
abbrev uint'63_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'63_max.toUInt
abbrev uint'64_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'64_max.toUInt

axiom array31 : Type -> Type
axiom array32 : Type -> Type
axiom array63 : Type -> Type

axiom array31_elts : {α : Type} -> array31 α -> Int -> α
axiom array32_elts : {α : Type} -> array32 α -> Int -> α
axiom array63_elts : {α : Type} -> array63 α -> List α

noncomputable abbrev array63_nth {α : Type} [Inhabited α] (a : array63 α) (i : Int) := (array63_elts a)[i.toNat]!

axiom array31_length : {α : Type} -> array31 α -> BitVec 31
axiom array32_length : {α : Type} -> array32 α -> BitVec 32
axiom array63_length : {α : Type} -> array63 α -> BitVec 63

abbrev is_none {α : Type} (x : Option α) := x = none
abbrev is_nil {α : Type} (x : List α) := x = []

abbrev _root_.List.rev_append {α : Type} (a : List α) (b : List α) := a.reverse ++ b
abbrev _root_.Finset.is_empty {α : Type} (s : Finset α) := s = ∅
abbrev _root_.Finset.filter' {α : Type} (s : Finset α) (p : α → Prop) [DecidablePred p] : Finset α
  := Finset.filter p s

abbrev _root_.Finset.card_i {α : Type} (s : Finset α) := Int.ofNat s.card

abbrev int_power (x : Int) (n : Int) := x ^ n.toNat
abbrev bv2_power (n : Int) := Int.ofNat (2 ^ n.toNat)

abbrev take_bit_i {n : Nat} (x : BitVec n) (i : Int) := x[i.toNat]!
abbrev take_bit_bv {n m : Nat} (x : BitVec n) (i : BitVec m) := x[i.toNat]!

noncomputable def _root_.Finset.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default
noncomputable def _root_.Set.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default

noncomputable abbrev _root_.BitVec.eq_sub {m : Nat} (a b : BitVec m) (i n : Nat) :=
  BitVec.extractLsb (i+n-1) i a = BitVec.extractLsb (i+n-1) i b

noncomputable abbrev _root_.BitVec.eq_sub_i {m : Nat} (a b : BitVec m) (i n : Int) :=
  BitVec.eq_sub a b i.toNat n.toNat

noncomputable abbrev _root_.BitVec.eq_sub_bv {m : Nat} {m1 : Nat} {m2 : Nat} (a b : BitVec m) (i : BitVec m1) (n : BitVec m2) :=
  BitVec.eq_sub a b i.toNat n.toNat

abbrev w8_size_bv := (8 : BitVec 8)
abbrev w16_size_bv := (16 : BitVec 16)
abbrev w32_size_bv := (32 : BitVec 32)
abbrev w64_size_bv := (64 : BitVec 64)
abbrev w128_size_bv := (128 : BitVec 128)
abbrev w256_size_bv := (256 : BitVec 256)
abbrev w8_size_i := (8 : Int)
abbrev w16_size_i := (16 : Int)
abbrev w32_size_i := (32 : Int)
abbrev w64_size_i := (64 : Int)
abbrev w128_size_i := (128 : Int)
abbrev w256_size_i := (256 : Int)

abbrev _root_.Finset.erase' {α : Type} [DecidableEq α] (a : α) (s : Finset α) : Finset α
  := Finset.erase s a

abbrev _root_.BitVec.sge {n : ℕ} (x y : BitVec n) := BitVec.sle y x
abbrev _root_.BitVec.sgt {n : ℕ} (x y : BitVec n) := BitVec.slt y x

abbrev _root_.BitVec.sshiftRight_i {n : ℕ} (x : BitVec n) (s : ℤ) := BitVec.sshiftRight x s.toNat
abbrev _root_.BitVec.sshiftRight_bv {n m : ℕ} (x : BitVec n) (s : BitVec m)
  := BitVec.sshiftRight x s.toNat

abbrev _root_.BitVec.rotateLeft_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateLeft x n.toNat
abbrev _root_.BitVec.rotateLeft_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateLeft x n.toNat

abbrev _root_.BitVec.rotateRight_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateRight x n.toNat
abbrev _root_.BitVec.rotateRight_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateRight x n.toNat

abbrev _root_.Multiset.count_i {α : Type} [DecidableEq α] (a : α) (s : Multiset α)
  := Int.ofNat (s.count a)

abbrev _root_.Multiset.card_i {α : Type} (S : Multiset α) := Int.ofNat S.card

abbrev _root_.Int.gcd_i (a : ℤ) (b : ℤ) := Int.ofNat (Int.gcd a b)

abbrev _root_.Int.Prime (p : ℤ) := Nat.Prime p.toNat
abbrev _root_.Int.Coprime (a b : ℤ) := Nat.Coprime a.toNat b.toNat

abbrev _root_.Set.remove {α : Type} (x : α) (A : Set α) := A \ {x}
abbrev _root_.Set.filter {α : Type} (S : Set α) (P : α -> Bool) := {x ∈ S | P x }

abbrev _root_.Option.the {α : Type} [Inhabited α] (opt : Option α) := opt.getD default

noncomputable abbrev _root_.Finmap.lookup! {K : Type} {V : Type} [Inhabited V] (m : Finmap (fun _ : K => V)) (k : K) :=
  (Finmap.lookup k m).getD default

noncomputable abbrev _root_.Finmap.mapsto {K V : Type} (k : K) (v : V) (m : Finmap (fun _ : K => V))
  := Finmap.lookup k m = some v

abbrev _root_.Finmap.is_empty {K V : Type} (m : Finmap (fun _ : K => V)) := m = ∅
abbrev _root_.Finmap.size {K V : Type} (m : Finmap (fun _ : K => V)) := m.keys.card

abbrev _root_.Finset.min'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.min with
  | ⊤        => default
  | .some a  => a

abbrev _root_.Finset.max'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.max with
  | ⊥        => default
  | .some a  => a

abbrev arrayExchange {α} [Inhabited α] (a1 a2 : List α) (i j : Int) : Prop :=
  let i' := i.toNat
  let j' := j.toNat
  a1 = (a2.set i' a1[j']!).set j' (a1[i']!)

abbrev _root_.List.permut_sub {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ (0 ≤ l ∧ l ≤ a1.length) ∧ (0 ≤ u ∧ u ≤ a1.length) ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.permut_sub' {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ slice a1 0 l = slice a2 0 l ∧
  slice a1 u a1.length = slice a2 u a1.length ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.foldr' {α β} (f : α -> β -> β) (l : List α) (x : β) := List.foldr f x l

abbrev _root_.Int.to_Real (z : ℤ) : ℝ := z

abbrev _root_.List.mem' {α} (eq : α -> α -> Bool) (x : α) (l : List α) := List.all l (eq x)

noncomputable abbrev _root_.Real.truncate (x : ℝ) : ℤ := if 0 ≤ x then Int.floor x  else Int.ceil x

alias _root_.Math.abs := abs

end Lean4Why3

open Classical
open Lean4Why3

namespace Ref
structure ref (α : Type) where
  contents : α
axiom inhabited_axiom_ref {α : Type} [Inhabited α] : Inhabited (ref α)
attribute [instance] inhabited_axiom_ref
end Ref
namespace Const
axiom const :  {α : Type} -> [Inhabited α] ->  {β : Type} -> [Inhabited β] -> β -> α -> β
axiom const'def {α : Type} {β : Type} [Inhabited α] [Inhabited β] (v : β) (x : α) : (const : β -> α -> β) v x = v
end Const
namespace MapEq
noncomputable def map_eq_sub {α : Type} [Inhabited α] (a1 : ℤ -> α) (a2 : ℤ -> α) (l : ℤ) (u : ℤ) := ∀(i : ℤ), l ≤ i ∧ i < u → a1 i = a2 i
end MapEq
namespace Unsigned
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
axiom max : ℤ
axiom to_int : t -> ℤ
noncomputable def in_bounds (n : ℤ) := (0 : ℤ) ≤ n ∧ n ≤ max
axiom to_int_in_bounds (n : t) : in_bounds (to_int n)
axiom extensionality (x : t) (y : t) (fact0 : to_int x = to_int y) : x = y
axiom zero_unsigned : t
axiom zero_unsigned_is_zero : to_int zero_unsigned = (0 : ℤ)
axiom radix : ℤ
axiom radix_def : radix = max + (1 : ℤ)
end Unsigned
namespace C
noncomputable def in_us_bounds (n : ℤ) := (0 : ℤ) ≤ n ∧ n ≤ (4294967295 : ℤ)
noncomputable def in_bounds (n : ℤ) := -(2147483648 : ℤ) ≤ n ∧ n ≤ (2147483647 : ℤ)
axiom zone : Type
axiom inhabited_axiom_zone : Inhabited zone
attribute [instance] inhabited_axiom_zone
axiom null_zone : zone
axiom ptr : Type -> Type
axiom inhabited_axiom_ptr {α : Type} [Inhabited α] : Inhabited (ptr α)
attribute [instance] inhabited_axiom_ptr
axiom data :  {α : Type} -> [Inhabited α] -> ptr α -> List α
axiom offset :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom min :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom max :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom writable :  {α : Type} -> [Inhabited α] -> ptr α -> Bool
axiom zone1 :  {α : Type} -> [Inhabited α] -> ptr α -> zone
noncomputable def plength {α : Type} [Inhabited α] (p : ptr α) := Int.ofNat (List.length (data p))
noncomputable def pelts {α : Type} [Inhabited α] (p : ptr α) := getElem! (data p) ∘ Int.toNat
axiom is_not_null :  {α : Type} -> [Inhabited α] -> ptr α -> Prop
axiom is_not_null'spec {α : Type} [Inhabited α] (p : ptr α) : is_not_null p = (¬zone1 p = null_zone)
noncomputable def valid_ptr_shift {α : Type} [Inhabited α] (p : ptr α) (i : ℤ) := min p ≤ offset p + i ∧ offset p + i < max p
noncomputable def valid {α : Type} [Inhabited α] (p : ptr α) (sz : ℤ) := in_bounds sz ∧ (0 : ℤ) ≤ sz ∧ ((0 : ℤ) ≤ min p ∧ min p ≤ offset p) ∧ offset p + sz ≤ max p ∧ max p ≤ plength p
axiom valid_itv_to_shift {α : Type} [Inhabited α] (p : ptr α) (sz : ℤ) (i : ℤ) (fact0 : valid p sz) (fact1 : (0 : ℤ) ≤ i) (fact2 : i < sz) : valid_ptr_shift p i
end C
namespace Config
end Config
namespace Types
axiom limb : Type
axiom inhabited_axiom_limb : Inhabited limb
attribute [instance] inhabited_axiom_limb
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
end Types
namespace Int32Eq
end Int32Eq
namespace UInt64Eq
end UInt64Eq
namespace Lemmas
noncomputable def map_eq_sub_shift {α : Type} [Inhabited α] (x : ℤ -> α) (y : ℤ -> α) (xi : ℤ) (yi : ℤ) (sz : ℤ) := ∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < sz → x (xi + i) = y (yi + i)
axiom value_sub : (ℤ -> BitVec 64) -> ℤ -> ℤ -> ℤ
axiom value_sub'def (n : ℤ) (m : ℤ) (x : ℤ -> BitVec 64) : if n < m then value_sub x n m = BitVec.toUInt (x n) + ((18446744073709551615 : ℤ) + (1 : ℤ)) * value_sub x (n + (1 : ℤ)) m else value_sub x n m = (0 : ℤ)
noncomputable def value (x : C.ptr (BitVec 64)) (sz : ℤ) := value_sub (C.pelts x) (C.offset x) (C.offset x + sz)
end Lemmas
namespace Alias
axiom mem : Type
axiom inhabited_axiom_mem : Inhabited mem
attribute [instance] inhabited_axiom_mem
axiom zr : mem -> C.zone
axiom zx : mem -> C.zone
axiom zy : mem -> C.zone
axiom mr : mem -> BitVec 32
axiom mx : mem -> BitVec 32
axiom my : mem -> BitVec 32
axiom lr : mem -> BitVec 32
axiom lx : mem -> BitVec 32
axiom ly : mem -> BitVec 32
axiom ok : mem -> Bool
noncomputable def identical (p1 : C.ptr (BitVec 64)) (p2 : C.ptr (BitVec 64)) := C.data p1 = C.data p2 ∧ C.offset p1 = C.offset p2 ∧ C.min p1 = C.min p2 ∧ C.max p1 = C.max p2 ∧ C.zone1 p1 = C.zone1 p2
end Alias
namespace Util
end Util
namespace UtilOld
end UtilOld
namespace Compare
noncomputable def compare_int (x : ℤ) (y : ℤ) := if x < y then -(1 : ℤ) else if x = y then (0 : ℤ) else (1 : ℤ)
end Compare
namespace LogicalUtil
end LogicalUtil
namespace Logical
end Logical
namespace LogicalOld
end LogicalOld
namespace Z
axiom mpz_ptr : Type
axiom inhabited_axiom_mpz_ptr : Inhabited mpz_ptr
attribute [instance] inhabited_axiom_mpz_ptr
axiom mpz_eq : mpz_ptr -> mpz_ptr -> Prop
axiom mpz_eq'spec (x : mpz_ptr) (y : mpz_ptr) : mpz_eq x y = (x = y)
axiom mpz_memo : Type
axiom inhabited_axiom_mpz_memo : Inhabited mpz_memo
attribute [instance] inhabited_axiom_mpz_memo
axiom abs_value_of : mpz_memo -> mpz_ptr -> ℤ
axiom alloc : mpz_memo -> mpz_ptr -> ℤ
axiom abs_size : mpz_memo -> mpz_ptr -> ℤ
axiom sgn : mpz_memo -> mpz_ptr -> ℤ
axiom readers : mpz_memo -> mpz_ptr -> ℤ
axiom zones : mpz_memo -> mpz_ptr -> C.zone
axiom mpz_memo'invariant (self : mpz_memo) (p : mpz_ptr) : (0 : ℤ) ≤ alloc self p ∧ (sgn self p = (1 : ℤ) ∨ sgn self p = -(1 : ℤ)) ∧ abs_size self p ≤ alloc self p ∧ (0 : ℤ) ≤ abs_size self p ∧ abs_size self p ≤ (2147483647 : ℤ) ∧ (0 : ℤ) ≤ abs_value_of self p ∧ ((1 : ℤ) ≤ abs_size self p → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs_size self p - (1 : ℤ))) ≤ abs_value_of self p) ∧ abs_value_of self p < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs_size self p))
noncomputable def value_of (x : mpz_ptr) (memo : mpz_memo) := sgn memo x * abs_value_of memo x
noncomputable def sgn_value (p : C.ptr (BitVec 64)) (sz : BitVec 32) := if (0 : ℤ) ≤ BitVec.toInt sz then Lemmas.value p (BitVec.toInt sz) else -Lemmas.value p (-BitVec.toInt sz)
noncomputable def mpz_unchanged (x : mpz_ptr) (memo1 : mpz_memo) (memo2 : mpz_memo) := readers memo1 x = readers memo2 x ∧ (-(2 : ℤ) < readers memo1 x → abs_value_of memo1 x = abs_value_of memo2 x ∧ alloc memo1 x = alloc memo2 x ∧ abs_size memo1 x = abs_size memo2 x ∧ sgn memo1 x = sgn memo2 x ∧ zones memo1 x = zones memo2 x)
structure mpz_struct where
  addr : mpz_ptr
axiom inhabited_axiom_mpz_struct : Inhabited mpz_struct
attribute [instance] inhabited_axiom_mpz_struct
end Z
namespace Zutil
axiom mpz_mem : Type
axiom inhabited_axiom_mpz_mem : Inhabited mpz_mem
attribute [instance] inhabited_axiom_mpz_mem
axiom ptr : mpz_mem -> Z.mpz_ptr
axiom ok : mpz_mem -> Bool
end Zutil
namespace mpz_div2exp_Zdiv2exp_wmpz_tdiv_q_2expqtvc
lemma wmpz_tdiv_q_2exp'vc (mpz : Z.mpz_memo) (r : Z.mpz_ptr) (u : Z.mpz_ptr) (cnt : BitVec 64) (fact0 : (1 : ℤ) ≤ Z.alloc mpz r) (fact1 : (1 : ℤ) ≤ Z.alloc mpz u) (fact2 : Z.readers mpz r = (0 : ℤ)) (fact3 : Z.readers mpz u = (0 : ℤ)) (fact4 : Z.abs_size mpz u + Int.tdiv (BitVec.toUInt cnt) (64 : ℤ) + (1 : ℤ) ≤ (2147483647 : ℤ)) : -(2 : ℤ) < Z.readers mpz u ∧ (∀(un : BitVec 32), BitVec.toInt un = Z.sgn mpz u * Z.abs_size mpz u → (¬(64 : ℤ) = (0 : ℤ) ∧ uint'64_in_bounds (Int.tdiv (BitVec.toUInt cnt) (64 : ℤ))) ∧ (∀(o1 : BitVec 64), BitVec.toUInt o1 = Int.tdiv (BitVec.toUInt cnt) (64 : ℤ) → BitVec.toUInt o1 ≤ (2147483647 : ℤ) ∧ (∀(limb_cnt : BitVec 32), BitVec.toInt limb_cnt = BitVec.toUInt o1 → -(2147483648 : ℤ) < BitVec.toInt un ∧ (∀(o2 : BitVec 32), BitVec.toInt o2 = abs (BitVec.toInt un) → int'32_in_bounds (BitVec.toInt o2 - BitVec.toInt limb_cnt) ∧ (∀(o3 : BitVec 32), BitVec.toInt o3 = BitVec.toInt o2 - BitVec.toInt limb_cnt → (if BitVec.toInt o3 ≤ (0 : ℤ) then (-(1 : ℤ) ≤ Z.readers mpz r ∧ Z.readers mpz r ≤ (0 : ℤ)) ∧ (∀(mpz1 : Z.mpz_memo), Z.alloc mpz1 = Z.alloc mpz ∧ Z.sgn mpz1 = Z.sgn mpz ∧ Z.readers mpz1 = Z.readers mpz ∧ Z.zones mpz1 = Z.zones mpz → (∀(y : Z.mpz_ptr), ¬y = r → Z.mpz_unchanged y mpz1 mpz) ∧ Z.abs_size mpz1 r = (0 : ℤ) ∧ Z.abs_value_of mpz1 r = (0 : ℤ) → Z.value_of r mpz1 = Int.tdiv (Z.value_of u mpz) (HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt cnt))) ∧ (∀(x : Z.mpz_ptr), ¬x = r → Z.mpz_unchanged x mpz1 mpz) ∧ Z.readers mpz1 r = (0 : ℤ) ∧ Z.readers mpz1 u = (0 : ℤ)) else (Z.readers mpz r = (0 : ℤ) ∧ (1 : ℤ) ≤ Z.alloc mpz r) ∧ (∀(mpz1 : Z.mpz_memo), Z.sgn mpz1 = Z.sgn mpz → (∀(rp : C.ptr (BitVec 64)), (∀(y : Z.mpz_ptr), ¬y = r → Z.mpz_unchanged y mpz1 mpz) ∧ Z.readers mpz1 r = -(1 : ℤ) ∧ Z.abs_value_of mpz1 r = Lemmas.value rp (Z.abs_size mpz1 r) ∧ Z.zones mpz1 r = C.zone1 rp ∧ C.offset rp = (0 : ℤ) ∧ C.plength rp = Z.alloc mpz1 r ∧ C.min rp = (0 : ℤ) ∧ C.max rp = C.plength rp ∧ C.writable rp = true ∧ Z.abs_size mpz1 r = Z.abs_size mpz r ∧ Lemmas.value rp (Z.abs_size mpz r) = Z.abs_value_of mpz r ∧ (if Z.alloc mpz r < BitVec.toInt o3 then Z.alloc mpz1 r = BitVec.toInt o3 else Z.alloc mpz1 r = Z.alloc mpz r) → (¬(64 : ℤ) = (0 : ℤ) ∧ uint'64_in_bounds (Int.tmod (BitVec.toUInt cnt) (64 : ℤ))) ∧ (∀(c : BitVec 64), BitVec.toUInt c = Int.tmod (BitVec.toUInt cnt) (64 : ℤ) → Z.mpz_eq u r = (u = r) → (if Z.mpz_eq u r then (C.min rp ≤ C.offset rp + BitVec.toInt limb_cnt ∧ C.offset rp + BitVec.toInt limb_cnt ≤ C.max rp) ∧ (∀(up : C.ptr (BitVec 64)), C.offset up = C.offset rp + BitVec.toInt limb_cnt ∧ C.plength up = C.plength rp ∧ C.pelts up = C.pelts rp ∧ C.data up = C.data rp ∧ C.min up = C.min rp ∧ C.max up = C.max rp ∧ C.zone1 up = C.zone1 rp ∧ C.writable up = C.writable rp → (∀(o4 : Bool), (BitVec.toUInt c = BitVec.toUInt (0 : BitVec 64) → o4 = true) ∧ (o4 = true → c = (0 : BitVec 64)) → (if ¬o4 = true then (((0 : ℤ) < BitVec.toUInt c ∧ BitVec.toUInt c < (64 : ℤ)) ∧ C.valid up (BitVec.toInt o3) ∧ C.valid rp (BitVec.toInt o3) ∧ (0 : ℤ) < BitVec.toInt o3 ∧ C.writable rp = true ∧ (C.offset rp ≤ C.offset up ∨ C.offset up + BitVec.toInt o3 ≤ C.offset rp)) ∧ (∀(up1 : C.ptr (BitVec 64)) (rp1 : C.ptr (BitVec 64)), C.data up1 = C.data rp1 ∧ List.length (C.data rp1) = List.length (C.data up) ∧ C.offset up1 = C.offset up ∧ C.min up1 = C.min up ∧ C.max up1 = C.max up ∧ C.writable up1 = C.writable up ∧ C.zone1 up1 = C.zone1 up → List.length (C.data rp1) = List.length (C.data rp) ∧ C.offset rp1 = C.offset rp ∧ C.min rp1 = C.min rp ∧ C.max rp1 = C.max rp ∧ C.writable rp1 = C.writable rp ∧ C.zone1 rp1 = C.zone1 rp → (∀(x_m : BitVec 64), BitVec.toUInt x_m + ((18446744073709551615 : ℤ) + (1 : ℤ)) * Lemmas.value rp1 (BitVec.toInt o3) = Lemmas.value up (BitVec.toInt o3) * HPow.hPow (2 : ℤ) (Int.toNat ((64 : ℤ) - BitVec.toUInt c)) ∧ (∀(j : ℤ), j < C.offset rp1 ∨ C.offset rp1 + BitVec.toInt o3 ≤ j → C.pelts rp1 j = C.pelts rp j) ∧ (C.min rp1 = C.min rp ∧ C.max rp1 = C.max rp ∧ C.plength rp1 = C.plength rp) ∧ C.min up1 = C.min up ∧ C.max up1 = C.max up ∧ C.plength up1 = C.plength up → ¬(18446744073709551615 : ℤ) + (1 : ℤ) = (0 : ℤ) ∧ int'32_in_bounds (BitVec.toInt o3 - (1 : ℤ)) ∧ (∀(o5 : BitVec 32), BitVec.toInt o5 = BitVec.toInt o3 - (1 : ℤ) → (C.min rp1 ≤ C.offset rp1 + BitVec.toInt o5 ∧ C.offset rp1 + BitVec.toInt o5 < C.max rp1) ∧ (let o6 : BitVec 64 := C.pelts rp1 (C.offset rp1 + BitVec.toInt o5); ∀(o7 : Bool), (BitVec.toUInt o6 = BitVec.toUInt (0 : BitVec 64) → o7 = true) ∧ (o7 = true → o6 = (0 : BitVec 64)) → (∀(o8 : BitVec 32), (if o7 = true then o8 = (1 : BitVec 32) else o8 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o3 - BitVec.toInt o8) ∧ (∀(o9 : BitVec 32), BitVec.toInt o9 = BitVec.toInt o3 - BitVec.toInt o8 → -(2 : ℤ) < Z.readers mpz1 u ∧ (∀(o10 : BitVec 32), BitVec.toInt o10 = Z.sgn mpz1 u * Z.abs_size mpz1 u → (¬(0 : ℤ) ≤ BitVec.toInt o10 → int'32_in_bounds (-BitVec.toInt o9)) ∧ ((¬(0 : ℤ) ≤ BitVec.toInt o10 → (∃(nrn : BitVec 32), BitVec.toInt nrn = -BitVec.toInt o9)) → -(2 : ℤ) < Z.readers mpz1 u ∧ (∀(o11 : BitVec 32), BitVec.toInt o11 = Z.sgn mpz1 u * Z.abs_size mpz1 u → (¬(0 : ℤ) ≤ BitVec.toInt o11 → int'32_in_bounds (-BitVec.toInt o9)) ∧ (∀(o12 : BitVec 32), (if (0 : ℤ) ≤ BitVec.toInt o11 then o12 = o9 else BitVec.toInt o12 = -BitVec.toInt o9) → (Z.zones mpz1 r = C.zone1 rp1 ∧ Z.readers mpz1 r = -(1 : ℤ) ∧ C.offset rp1 = (0 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ abs (BitVec.toInt o12) ≤ C.plength rp1 ∧ C.plength rp1 = Z.alloc mpz1 r ∧ (¬BitVec.toInt o12 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o12) - (1 : ℤ))) ≤ Lemmas.value rp1 (abs (BitVec.toInt o12)))) ∧ (∀(mpz2 : Z.mpz_memo), Z.alloc mpz2 = Z.alloc mpz1 ∧ Z.readers mpz2 = Z.readers mpz1 ∧ Z.zones mpz2 = Z.zones mpz1 → (∀(y : Z.mpz_ptr), ¬y = r → Z.mpz_unchanged y mpz2 mpz1) ∧ (Z.sgn mpz2 r = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o12) ∧ (Z.sgn mpz2 r = -(1 : ℤ)) = (BitVec.toInt o12 < (0 : ℤ)) ∧ Z.abs_size mpz2 r = abs (BitVec.toInt o12) ∧ Z.abs_value_of mpz2 r = Lemmas.value rp1 (abs (BitVec.toInt o12)) → (Z.zones mpz2 r = C.zone1 rp1 ∧ Z.readers mpz2 r = -(1 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ Z.abs_value_of mpz2 r = Lemmas.value rp1 (Z.abs_size mpz2 r)) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.alloc mpz3 = Z.alloc mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → Z.readers mpz3 r = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = r → Z.readers mpz3 y = Z.readers mpz2 y) → Z.value_of r mpz3 = Int.tdiv (Z.value_of u mpz) (HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt cnt))) ∧ (∀(x : Z.mpz_ptr), ¬x = r → Z.mpz_unchanged x mpz3 mpz) ∧ Z.readers mpz3 r = (0 : ℤ) ∧ Z.readers mpz3 u = (0 : ℤ))))))))))))) else (C.valid up (BitVec.toInt o3) ∧ C.valid rp (BitVec.toInt o3) ∧ C.writable rp = true ∧ (C.offset rp ≤ C.offset up ∨ C.offset up + BitVec.toInt o3 ≤ C.offset rp)) ∧ (∀(up1 : C.ptr (BitVec 64)) (rp1 : C.ptr (BitVec 64)), C.data up1 = C.data rp1 ∧ List.length (C.data rp1) = List.length (C.data up) ∧ C.offset up1 = C.offset up ∧ C.min up1 = C.min up ∧ C.max up1 = C.max up ∧ C.writable up1 = C.writable up ∧ C.zone1 up1 = C.zone1 up → List.length (C.data rp1) = List.length (C.data rp) ∧ C.offset rp1 = C.offset rp ∧ C.min rp1 = C.min rp ∧ C.max rp1 = C.max rp ∧ C.writable rp1 = C.writable rp ∧ C.zone1 rp1 = C.zone1 rp → Lemmas.map_eq_sub_shift (C.pelts rp1) (C.pelts up) (C.offset rp1) (C.offset up1) (BitVec.toInt o3) ∧ (∀(j : ℤ), j < C.offset rp1 ∨ C.offset rp1 + BitVec.toInt o3 ≤ j → C.pelts rp1 j = C.pelts rp j) → -(2 : ℤ) < Z.readers mpz1 u ∧ (∀(o5 : BitVec 32), BitVec.toInt o5 = Z.sgn mpz1 u * Z.abs_size mpz1 u → (¬(0 : ℤ) ≤ BitVec.toInt o5 → int'32_in_bounds (-BitVec.toInt o3)) ∧ ((¬(0 : ℤ) ≤ BitVec.toInt o5 → (∃(nrn : BitVec 32), BitVec.toInt nrn = -BitVec.toInt o3)) → -(2 : ℤ) < Z.readers mpz1 u ∧ (∀(o6 : BitVec 32), BitVec.toInt o6 = Z.sgn mpz1 u * Z.abs_size mpz1 u → (¬(0 : ℤ) ≤ BitVec.toInt o6 → int'32_in_bounds (-BitVec.toInt o3)) ∧ (∀(o7 : BitVec 32), (if (0 : ℤ) ≤ BitVec.toInt o6 then o7 = o3 else BitVec.toInt o7 = -BitVec.toInt o3) → (Z.zones mpz1 r = C.zone1 rp1 ∧ Z.readers mpz1 r = -(1 : ℤ) ∧ C.offset rp1 = (0 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ abs (BitVec.toInt o7) ≤ C.plength rp1 ∧ C.plength rp1 = Z.alloc mpz1 r ∧ (¬BitVec.toInt o7 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o7) - (1 : ℤ))) ≤ Lemmas.value rp1 (abs (BitVec.toInt o7)))) ∧ (∀(mpz2 : Z.mpz_memo), Z.alloc mpz2 = Z.alloc mpz1 ∧ Z.readers mpz2 = Z.readers mpz1 ∧ Z.zones mpz2 = Z.zones mpz1 → (∀(y : Z.mpz_ptr), ¬y = r → Z.mpz_unchanged y mpz2 mpz1) ∧ (Z.sgn mpz2 r = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o7) ∧ (Z.sgn mpz2 r = -(1 : ℤ)) = (BitVec.toInt o7 < (0 : ℤ)) ∧ Z.abs_size mpz2 r = abs (BitVec.toInt o7) ∧ Z.abs_value_of mpz2 r = Lemmas.value rp1 (abs (BitVec.toInt o7)) → (Z.zones mpz2 r = C.zone1 rp1 ∧ Z.readers mpz2 r = -(1 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ Z.abs_value_of mpz2 r = Lemmas.value rp1 (Z.abs_size mpz2 r)) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.alloc mpz3 = Z.alloc mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → Z.readers mpz3 r = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = r → Z.readers mpz3 y = Z.readers mpz2 y) → Z.value_of r mpz3 = Int.tdiv (Z.value_of u mpz) (HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt cnt))) ∧ (∀(x : Z.mpz_ptr), ¬x = r → Z.mpz_unchanged x mpz3 mpz) ∧ Z.readers mpz3 r = (0 : ℤ) ∧ Z.readers mpz3 u = (0 : ℤ))))))))))) else Z.mpz_unchanged u mpz1 mpz ∧ (Z.readers mpz1 u = Z.readers mpz u ∧ (-(2 : ℤ) < Z.readers mpz1 u → Z.abs_value_of mpz1 u = Z.abs_value_of mpz u ∧ Z.alloc mpz1 u = Z.alloc mpz u ∧ Z.abs_size mpz1 u = Z.abs_size mpz u ∧ Z.sgn mpz1 u = Z.sgn mpz u ∧ Z.readers mpz1 u = Z.readers mpz u ∧ Z.zones mpz1 u = Z.zones mpz u) → (0 : ℤ) ≤ Z.readers mpz1 u ∧ (∀(mpz2 : Z.mpz_memo), Z.abs_value_of mpz2 = Z.abs_value_of mpz1 ∧ Z.alloc mpz2 = Z.alloc mpz1 ∧ Z.abs_size mpz2 = Z.abs_size mpz1 ∧ Z.sgn mpz2 = Z.sgn mpz1 ∧ Z.zones mpz2 = Z.zones mpz1 → (∀(up0 : C.ptr (BitVec 64)), Z.readers mpz2 u = Z.readers mpz1 u + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬u = y → Z.readers mpz2 y = Z.readers mpz1 y) ∧ Lemmas.value up0 (Z.abs_size mpz2 u) = Z.abs_value_of mpz2 u ∧ C.plength up0 = Z.alloc mpz2 u ∧ C.offset up0 = (0 : ℤ) ∧ C.min up0 = (0 : ℤ) ∧ C.max up0 = C.plength up0 ∧ C.zone1 up0 = Z.zones mpz2 u → (C.min up0 ≤ C.offset up0 + BitVec.toInt limb_cnt ∧ C.offset up0 + BitVec.toInt limb_cnt ≤ C.max up0) ∧ (∀(up : C.ptr (BitVec 64)), C.offset up = C.offset up0 + BitVec.toInt limb_cnt ∧ C.plength up = C.plength up0 ∧ C.pelts up = C.pelts up0 ∧ C.data up = C.data up0 ∧ C.min up = C.min up0 ∧ C.max up = C.max up0 ∧ C.zone1 up = C.zone1 up0 ∧ C.writable up = C.writable up0 → (∀(o4 : Bool), (BitVec.toUInt c = BitVec.toUInt (0 : BitVec 64) → o4 = true) ∧ (o4 = true → c = (0 : BitVec 64)) → (if ¬o4 = true then (C.valid up (BitVec.toInt o3) ∧ C.valid rp (BitVec.toInt o3) ∧ ((0 : ℤ) < BitVec.toUInt c ∧ BitVec.toUInt c < (64 : ℤ)) ∧ (0 : ℤ) < BitVec.toInt o3 ∧ C.writable rp = true) ∧ (∀(rp1 : C.ptr (BitVec 64)), List.length (C.data rp1) = List.length (C.data rp) ∧ C.offset rp1 = C.offset rp ∧ C.min rp1 = C.min rp ∧ C.max rp1 = C.max rp ∧ C.writable rp1 = C.writable rp ∧ C.zone1 rp1 = C.zone1 rp → (∀(x_m : BitVec 64), BitVec.toUInt x_m + ((18446744073709551615 : ℤ) + (1 : ℤ)) * Lemmas.value rp1 (BitVec.toInt o3) = Lemmas.value up (BitVec.toInt o3) * HPow.hPow (2 : ℤ) (Int.toNat ((64 : ℤ) - BitVec.toUInt c)) → ¬(18446744073709551615 : ℤ) + (1 : ℤ) = (0 : ℤ) ∧ int'32_in_bounds (BitVec.toInt o3 - (1 : ℤ)) ∧ (∀(o5 : BitVec 32), BitVec.toInt o5 = BitVec.toInt o3 - (1 : ℤ) → (C.min rp1 ≤ C.offset rp1 + BitVec.toInt o5 ∧ C.offset rp1 + BitVec.toInt o5 < C.max rp1) ∧ (let o6 : BitVec 64 := C.pelts rp1 (C.offset rp1 + BitVec.toInt o5); ∀(o7 : Bool), (BitVec.toUInt o6 = BitVec.toUInt (0 : BitVec 64) → o7 = true) ∧ (o7 = true → o6 = (0 : BitVec 64)) → (∀(o8 : BitVec 32), (if o7 = true then o8 = (1 : BitVec 32) else o8 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o3 - BitVec.toInt o8) ∧ (∀(o9 : BitVec 32), BitVec.toInt o9 = BitVec.toInt o3 - BitVec.toInt o8 → (Z.zones mpz2 u = C.zone1 up0 ∧ (1 : ℤ) ≤ Z.readers mpz2 u ∧ C.min up0 = (0 : ℤ) ∧ C.max up0 = C.plength up0) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.alloc mpz3 = Z.alloc mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → Z.readers mpz3 u = Z.readers mpz2 u - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = u → Z.readers mpz3 y = Z.readers mpz2 y) → -(2 : ℤ) < Z.readers mpz3 u ∧ (∀(o10 : BitVec 32), BitVec.toInt o10 = Z.sgn mpz3 u * Z.abs_size mpz3 u → (¬(0 : ℤ) ≤ BitVec.toInt o10 → int'32_in_bounds (-BitVec.toInt o9)) ∧ ((¬(0 : ℤ) ≤ BitVec.toInt o10 → (∃(nrn : BitVec 32), BitVec.toInt nrn = -BitVec.toInt o9)) → -(2 : ℤ) < Z.readers mpz3 u ∧ (∀(o11 : BitVec 32), BitVec.toInt o11 = Z.sgn mpz3 u * Z.abs_size mpz3 u → (¬(0 : ℤ) ≤ BitVec.toInt o11 → int'32_in_bounds (-BitVec.toInt o9)) ∧ (∀(o12 : BitVec 32), (if (0 : ℤ) ≤ BitVec.toInt o11 then o12 = o9 else BitVec.toInt o12 = -BitVec.toInt o9) → (Z.zones mpz3 r = C.zone1 rp1 ∧ Z.readers mpz3 r = -(1 : ℤ) ∧ C.offset rp1 = (0 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ abs (BitVec.toInt o12) ≤ C.plength rp1 ∧ C.plength rp1 = Z.alloc mpz3 r ∧ (¬BitVec.toInt o12 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o12) - (1 : ℤ))) ≤ Lemmas.value rp1 (abs (BitVec.toInt o12)))) ∧ (∀(mpz4 : Z.mpz_memo), Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.readers mpz4 = Z.readers mpz3 ∧ Z.zones mpz4 = Z.zones mpz3 → (∀(y : Z.mpz_ptr), ¬y = r → Z.mpz_unchanged y mpz4 mpz3) ∧ (Z.sgn mpz4 r = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o12) ∧ (Z.sgn mpz4 r = -(1 : ℤ)) = (BitVec.toInt o12 < (0 : ℤ)) ∧ Z.abs_size mpz4 r = abs (BitVec.toInt o12) ∧ Z.abs_value_of mpz4 r = Lemmas.value rp1 (abs (BitVec.toInt o12)) → (Z.zones mpz4 r = C.zone1 rp1 ∧ Z.readers mpz4 r = -(1 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ Z.abs_value_of mpz4 r = Lemmas.value rp1 (Z.abs_size mpz4 r)) ∧ (∀(mpz5 : Z.mpz_memo), Z.abs_value_of mpz5 = Z.abs_value_of mpz4 ∧ Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.abs_size mpz5 = Z.abs_size mpz4 ∧ Z.sgn mpz5 = Z.sgn mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → Z.readers mpz5 r = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = r → Z.readers mpz5 y = Z.readers mpz4 y) → Z.value_of r mpz5 = Int.tdiv (Z.value_of u mpz) (HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt cnt))) ∧ (∀(x : Z.mpz_ptr), ¬x = r → Z.mpz_unchanged x mpz5 mpz) ∧ Z.readers mpz5 r = (0 : ℤ) ∧ Z.readers mpz5 u = (0 : ℤ)))))))))))))) else (C.valid up (BitVec.toInt o3) ∧ C.valid rp (BitVec.toInt o3) ∧ C.writable rp = true) ∧ (∀(rp1 : C.ptr (BitVec 64)), List.length (C.data rp1) = List.length (C.data rp) ∧ C.offset rp1 = C.offset rp ∧ C.min rp1 = C.min rp ∧ C.max rp1 = C.max rp ∧ C.writable rp1 = C.writable rp ∧ C.zone1 rp1 = C.zone1 rp → Lemmas.map_eq_sub_shift (C.pelts rp1) (C.pelts up) (C.offset rp1) (C.offset up) (BitVec.toInt o3) ∧ (∀(j : ℤ), j < C.offset rp1 ∨ C.offset rp1 + BitVec.toInt o3 ≤ j → C.pelts rp1 j = C.pelts rp j) → (Z.zones mpz2 u = C.zone1 up0 ∧ (1 : ℤ) ≤ Z.readers mpz2 u ∧ C.min up0 = (0 : ℤ) ∧ C.max up0 = C.plength up0) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.alloc mpz3 = Z.alloc mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → Z.readers mpz3 u = Z.readers mpz2 u - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = u → Z.readers mpz3 y = Z.readers mpz2 y) → -(2 : ℤ) < Z.readers mpz3 u ∧ (∀(o5 : BitVec 32), BitVec.toInt o5 = Z.sgn mpz3 u * Z.abs_size mpz3 u → (¬(0 : ℤ) ≤ BitVec.toInt o5 → int'32_in_bounds (-BitVec.toInt o3)) ∧ ((¬(0 : ℤ) ≤ BitVec.toInt o5 → (∃(nrn : BitVec 32), BitVec.toInt nrn = -BitVec.toInt o3)) → -(2 : ℤ) < Z.readers mpz3 u ∧ (∀(o6 : BitVec 32), BitVec.toInt o6 = Z.sgn mpz3 u * Z.abs_size mpz3 u → (¬(0 : ℤ) ≤ BitVec.toInt o6 → int'32_in_bounds (-BitVec.toInt o3)) ∧ (∀(o7 : BitVec 32), (if (0 : ℤ) ≤ BitVec.toInt o6 then o7 = o3 else BitVec.toInt o7 = -BitVec.toInt o3) → (Z.zones mpz3 r = C.zone1 rp1 ∧ Z.readers mpz3 r = -(1 : ℤ) ∧ C.offset rp1 = (0 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ abs (BitVec.toInt o7) ≤ C.plength rp1 ∧ C.plength rp1 = Z.alloc mpz3 r ∧ (¬BitVec.toInt o7 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o7) - (1 : ℤ))) ≤ Lemmas.value rp1 (abs (BitVec.toInt o7)))) ∧ (∀(mpz4 : Z.mpz_memo), Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.readers mpz4 = Z.readers mpz3 ∧ Z.zones mpz4 = Z.zones mpz3 → (∀(y : Z.mpz_ptr), ¬y = r → Z.mpz_unchanged y mpz4 mpz3) ∧ (Z.sgn mpz4 r = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o7) ∧ (Z.sgn mpz4 r = -(1 : ℤ)) = (BitVec.toInt o7 < (0 : ℤ)) ∧ Z.abs_size mpz4 r = abs (BitVec.toInt o7) ∧ Z.abs_value_of mpz4 r = Lemmas.value rp1 (abs (BitVec.toInt o7)) → (Z.zones mpz4 r = C.zone1 rp1 ∧ Z.readers mpz4 r = -(1 : ℤ) ∧ C.min rp1 = (0 : ℤ) ∧ C.max rp1 = C.plength rp1 ∧ Z.abs_value_of mpz4 r = Lemmas.value rp1 (Z.abs_size mpz4 r)) ∧ (∀(mpz5 : Z.mpz_memo), Z.abs_value_of mpz5 = Z.abs_value_of mpz4 ∧ Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.abs_size mpz5 = Z.abs_size mpz4 ∧ Z.sgn mpz5 = Z.sgn mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → Z.readers mpz5 r = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = r → Z.readers mpz5 y = Z.readers mpz4 y) → Z.value_of r mpz5 = Int.tdiv (Z.value_of u mpz) (HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt cnt))) ∧ (∀(x : Z.mpz_ptr), ¬x = r → Z.mpz_unchanged x mpz5 mpz) ∧ Z.readers mpz5 r = (0 : ℤ) ∧ Z.readers mpz5 u = (0 : ℤ)))))))))))))))))))))))))
  := sorry
end mpz_div2exp_Zdiv2exp_wmpz_tdiv_q_2expqtvc
