import Mathlib

open Classical

namespace Lean4Why3

instance {n : Nat} : HShiftLeft (BitVec n) Int (BitVec n) where
  hShiftLeft x k := x <<< k.toNat

instance {n : Nat} : HShiftRight (BitVec n) Int (BitVec n) where
  hShiftRight x k := x >>> k.toNat

abbrev sshiftRight'i {n : ℕ} (a : BitVec n) (s : Int) : BitVec n := a.sshiftRight s.toNat

abbrev make_str_i (size : Int) := String.mk (List.replicate (Int.toNat size) 'a')
abbrev _root_.List.create_i {α} (n : ℤ) (f : ℤ -> α) := (List.range n.toNat).map f
abbrev _root_.List.create {α} (n : ℕ) (f : ℕ -> α) := (List.range n).map f

abbrev _root_.Bool.imp (a b : Bool) : Bool := !a || b

abbrev _root_.List.replicate_i {α} (n : ℤ) (x : α) := List.replicate (Int.toNat n) x

abbrev take_i {α : Type} (n : ℤ) (l : List α) := List.take n.toNat l
abbrev drop_i {α : Type} (n : ℤ) (l : List α) := List.drop n.toNat l

abbrev getElem_i! {α : Type} [Inhabited α] (l : List α) (i : Int) := l[i.toNat]!
abbrev getElem_i? {α : Type} (l : List α) (i : Int) := l[i.toNat]?

abbrev length_i {α : Type} (l : List α) := Int.ofNat l.length
abbrev slice {α : Type} (l : List α) (i j : Nat) : List α :=
  (l.drop i).take (j - i)
abbrev slice_i {α : Type} (l : List α) (i j : Int) : List α :=
  (l.drop i.toNat).take (j.toNat - i.toNat)

abbrev Sorted {α : Type} [LE α] (l : List α) := List.Sorted LE.le l
abbrev _root_.List.set_i {α : Type} (l : List α) (n : ℤ) (a : α) :=
  List.set l n.toNat a

abbrev implication (P : Prop) (Q : Prop) := P -> Q

noncomputable def map_occ {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := {n | l ≤ n ∧ n < u ∧ m n = v }.ncard
noncomputable abbrev map_occ_i {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := Int.ofNat (map_occ (v : α) (m : Int -> α) (l : Int) u)

abbrev _root_.BitVec.toUInt {n : Nat} (x : BitVec n) := Int.ofNat x.toNat

abbrev int'16_max : BitVec 16 := 32767
abbrev int'16_min : BitVec 16 := -32768
abbrev int'31_max : BitVec 31 := 1073741823
abbrev int'31_min : BitVec 31 := -1073741824
abbrev int'32_max : BitVec 32 := 2147483647
abbrev int'32_min : BitVec 32 := -2147483648
abbrev int'63_max : BitVec 63 := 4611686018427387903
abbrev int'63_min : BitVec 63 := -4611686018427387904
abbrev int'64_max : BitVec 64 := 9223372036854775807
abbrev int'64_min : BitVec 64 := -9223372036854775808
abbrev uint'16_max : BitVec 16 := 65535
abbrev uint'16_min : BitVec 16 := 0
abbrev uint'31_max : BitVec 31 := 2147483647
abbrev uint'31_min : BitVec 31 := 0
abbrev uint'32_max : BitVec 32 := 4294967295
abbrev uint'32_min : BitVec 32 := 0
abbrev uint'63_max : BitVec 63 := 9223372036854775807
abbrev uint'63_min : BitVec 63 := 0
abbrev uint'64_max : BitVec 64 := 18446744073709551615
abbrev uint'64_min : BitVec 64 := 0

abbrev int'16_in_bounds (x : Int) := int'16_min.toInt ≤ x ∧ x ≤ int'16_max.toInt
abbrev int'31_in_bounds (x : Int) := int'31_min.toInt ≤ x ∧ x ≤ int'31_max.toInt
abbrev int'32_in_bounds (x : Int) := int'32_min.toInt ≤ x ∧ x ≤ int'32_max.toInt
abbrev int'63_in_bounds (x : Int) := int'63_min.toInt ≤ x ∧ x ≤ int'63_max.toInt
abbrev int'64_in_bounds (x : Int) := int'64_min.toInt ≤ x ∧ x ≤ int'64_max.toInt
abbrev uint'8_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ 256
abbrev uint'16_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'16_max.toUInt
abbrev uint'31_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'31_max.toUInt
abbrev uint'32_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'32_max.toUInt
abbrev uint'63_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'63_max.toUInt
abbrev uint'64_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'64_max.toUInt

axiom array31 : Type -> Type
axiom array32 : Type -> Type
axiom array63 : Type -> Type

axiom array31_elts : {α : Type} -> array31 α -> Int -> α
axiom array32_elts : {α : Type} -> array32 α -> Int -> α
axiom array63_elts : {α : Type} -> array63 α -> List α

noncomputable abbrev array63_nth {α : Type} [Inhabited α] (a : array63 α) (i : Int) := (array63_elts a)[i.toNat]!

axiom array31_length : {α : Type} -> array31 α -> BitVec 31
axiom array32_length : {α : Type} -> array32 α -> BitVec 32
axiom array63_length : {α : Type} -> array63 α -> BitVec 63

abbrev is_none {α : Type} (x : Option α) := x = none
abbrev is_nil {α : Type} (x : List α) := x = []

abbrev _root_.List.rev_append {α : Type} (a : List α) (b : List α) := a.reverse ++ b
abbrev _root_.Finset.is_empty {α : Type} (s : Finset α) := s = ∅
abbrev _root_.Finset.filter' {α : Type} (s : Finset α) (p : α → Prop) [DecidablePred p] : Finset α
  := Finset.filter p s

abbrev _root_.Finset.card_i {α : Type} (s : Finset α) := Int.ofNat s.card

abbrev int_power (x : Int) (n : Int) := x ^ n.toNat
abbrev bv2_power (n : Int) := Int.ofNat (2 ^ n.toNat)

abbrev take_bit_i {n : Nat} (x : BitVec n) (i : Int) := x[i.toNat]!
abbrev take_bit_bv {n m : Nat} (x : BitVec n) (i : BitVec m) := x[i.toNat]!

noncomputable def _root_.Finset.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default
noncomputable def _root_.Set.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default

noncomputable abbrev _root_.BitVec.eq_sub {m : Nat} (a b : BitVec m) (i n : Nat) :=
  BitVec.extractLsb (i+n-1) i a = BitVec.extractLsb (i+n-1) i b

noncomputable abbrev _root_.BitVec.eq_sub_i {m : Nat} (a b : BitVec m) (i n : Int) :=
  BitVec.eq_sub a b i.toNat n.toNat

noncomputable abbrev _root_.BitVec.eq_sub_bv {m : Nat} {m1 : Nat} {m2 : Nat} (a b : BitVec m) (i : BitVec m1) (n : BitVec m2) :=
  BitVec.eq_sub a b i.toNat n.toNat

abbrev w8_size_bv := (8 : BitVec 8)
abbrev w16_size_bv := (16 : BitVec 16)
abbrev w32_size_bv := (32 : BitVec 32)
abbrev w64_size_bv := (64 : BitVec 64)
abbrev w128_size_bv := (128 : BitVec 128)
abbrev w256_size_bv := (256 : BitVec 256)
abbrev w8_size_i := (8 : Int)
abbrev w16_size_i := (16 : Int)
abbrev w32_size_i := (32 : Int)
abbrev w64_size_i := (64 : Int)
abbrev w128_size_i := (128 : Int)
abbrev w256_size_i := (256 : Int)

abbrev _root_.Finset.erase' {α : Type} [DecidableEq α] (a : α) (s : Finset α) : Finset α
  := Finset.erase s a

abbrev _root_.BitVec.sge {n : ℕ} (x y : BitVec n) := BitVec.sle y x
abbrev _root_.BitVec.sgt {n : ℕ} (x y : BitVec n) := BitVec.slt y x

abbrev _root_.BitVec.sshiftRight_i {n : ℕ} (x : BitVec n) (s : ℤ) := BitVec.sshiftRight x s.toNat
abbrev _root_.BitVec.sshiftRight_bv {n m : ℕ} (x : BitVec n) (s : BitVec m)
  := BitVec.sshiftRight x s.toNat

abbrev _root_.BitVec.rotateLeft_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateLeft x n.toNat
abbrev _root_.BitVec.rotateLeft_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateLeft x n.toNat

abbrev _root_.BitVec.rotateRight_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateRight x n.toNat
abbrev _root_.BitVec.rotateRight_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateRight x n.toNat

abbrev _root_.Multiset.count_i {α : Type} [DecidableEq α] (a : α) (s : Multiset α)
  := Int.ofNat (s.count a)

abbrev _root_.Multiset.card_i {α : Type} (S : Multiset α) := Int.ofNat S.card

abbrev _root_.Int.gcd_i (a : ℤ) (b : ℤ) := Int.ofNat (Int.gcd a b)

abbrev _root_.Int.Prime (p : ℤ) := Nat.Prime p.toNat
abbrev _root_.Int.Coprime (a b : ℤ) := Nat.Coprime a.toNat b.toNat

abbrev _root_.Set.remove {α : Type} (x : α) (A : Set α) := A \ {x}
abbrev _root_.Set.filter {α : Type} (S : Set α) (P : α -> Bool) := {x ∈ S | P x }

abbrev _root_.Option.the {α : Type} [Inhabited α] (opt : Option α) := opt.getD default

noncomputable abbrev _root_.Finmap.lookup! {K : Type} {V : Type} [Inhabited V] (m : Finmap (fun _ : K => V)) (k : K) :=
  (Finmap.lookup k m).getD default

noncomputable abbrev _root_.Finmap.mapsto {K V : Type} (k : K) (v : V) (m : Finmap (fun _ : K => V))
  := Finmap.lookup k m = some v

abbrev _root_.Finmap.is_empty {K V : Type} (m : Finmap (fun _ : K => V)) := m = ∅
abbrev _root_.Finmap.size {K V : Type} (m : Finmap (fun _ : K => V)) := m.keys.card

abbrev _root_.Finset.min'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.min with
  | ⊤        => default
  | .some a  => a

abbrev _root_.Finset.max'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.max with
  | ⊥        => default
  | .some a  => a

abbrev arrayExchange {α} [Inhabited α] (a1 a2 : List α) (i j : Int) : Prop :=
  let i' := i.toNat
  let j' := j.toNat
  a1 = (a2.set i' a1[j']!).set j' (a1[i']!)

abbrev _root_.List.permut_sub {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ (0 ≤ l ∧ l ≤ a1.length) ∧ (0 ≤ u ∧ u ≤ a1.length) ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.permut_sub' {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ slice a1 0 l = slice a2 0 l ∧
  slice a1 u a1.length = slice a2 u a1.length ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.foldr' {α β} (f : α -> β -> β) (l : List α) (x : β) := List.foldr f x l

abbrev _root_.Int.to_Real (z : ℤ) : ℝ := z

abbrev _root_.List.mem' {α} (eq : α -> α -> Bool) (x : α) (l : List α) := List.all l (eq x)

noncomputable abbrev _root_.Real.truncate (x : ℝ) : ℤ := if 0 ≤ x then Int.floor x  else Int.ceil x

alias _root_.Math.abs := abs

end Lean4Why3

open Classical
open Lean4Why3

namespace Ref
structure ref (α : Type) where
  contents : α
axiom inhabited_axiom_ref {α : Type} [Inhabited α] : Inhabited (ref α)
attribute [instance] inhabited_axiom_ref
end Ref
namespace Const
axiom const :  {α : Type} -> [Inhabited α] ->  {β : Type} -> [Inhabited β] -> β -> α -> β
axiom const'def {α : Type} {β : Type} [Inhabited α] [Inhabited β] (v : β) (x : α) : (const : β -> α -> β) v x = v
end Const
namespace MapEq
noncomputable def map_eq_sub {α : Type} [Inhabited α] (a1 : ℤ -> α) (a2 : ℤ -> α) (l : ℤ) (u : ℤ) := ∀(i : ℤ), l ≤ i ∧ i < u → a1 i = a2 i
end MapEq
namespace Unsigned
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
axiom max : ℤ
axiom to_int : t -> ℤ
noncomputable def in_bounds (n : ℤ) := (0 : ℤ) ≤ n ∧ n ≤ max
axiom to_int_in_bounds (n : t) : in_bounds (to_int n)
axiom extensionality (x : t) (y : t) (fact0 : to_int x = to_int y) : x = y
axiom zero_unsigned : t
axiom zero_unsigned_is_zero : to_int zero_unsigned = (0 : ℤ)
axiom radix : ℤ
axiom radix_def : radix = max + (1 : ℤ)
end Unsigned
namespace C
noncomputable def in_us_bounds (n : ℤ) := (0 : ℤ) ≤ n ∧ n ≤ (4294967295 : ℤ)
noncomputable def in_bounds (n : ℤ) := -(2147483648 : ℤ) ≤ n ∧ n ≤ (2147483647 : ℤ)
axiom zone : Type
axiom inhabited_axiom_zone : Inhabited zone
attribute [instance] inhabited_axiom_zone
axiom null_zone : zone
axiom ptr : Type -> Type
axiom inhabited_axiom_ptr {α : Type} [Inhabited α] : Inhabited (ptr α)
attribute [instance] inhabited_axiom_ptr
axiom data :  {α : Type} -> [Inhabited α] -> ptr α -> List α
axiom offset :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom min :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom max :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom writable :  {α : Type} -> [Inhabited α] -> ptr α -> Bool
axiom zone1 :  {α : Type} -> [Inhabited α] -> ptr α -> zone
noncomputable def plength {α : Type} [Inhabited α] (p : ptr α) := Int.ofNat (List.length (data p))
noncomputable def pelts {α : Type} [Inhabited α] (p : ptr α) := getElem! (data p) ∘ Int.toNat
axiom is_not_null :  {α : Type} -> [Inhabited α] -> ptr α -> Prop
axiom is_not_null'spec {α : Type} [Inhabited α] (p : ptr α) : is_not_null p = (¬zone1 p = null_zone)
noncomputable def valid_ptr_shift {α : Type} [Inhabited α] (p : ptr α) (i : ℤ) := min p ≤ offset p + i ∧ offset p + i < max p
noncomputable def valid {α : Type} [Inhabited α] (p : ptr α) (sz : ℤ) := in_bounds sz ∧ (0 : ℤ) ≤ sz ∧ ((0 : ℤ) ≤ min p ∧ min p ≤ offset p) ∧ offset p + sz ≤ max p ∧ max p ≤ plength p
axiom valid_itv_to_shift {α : Type} [Inhabited α] (p : ptr α) (sz : ℤ) (i : ℤ) (fact0 : valid p sz) (fact1 : (0 : ℤ) ≤ i) (fact2 : i < sz) : valid_ptr_shift p i
end C
namespace Config
end Config
namespace Types
axiom limb : Type
axiom inhabited_axiom_limb : Inhabited limb
attribute [instance] inhabited_axiom_limb
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
end Types
namespace Int32Eq
end Int32Eq
namespace UInt64Eq
end UInt64Eq
namespace Lemmas
noncomputable def map_eq_sub_shift {α : Type} [Inhabited α] (x : ℤ -> α) (y : ℤ -> α) (xi : ℤ) (yi : ℤ) (sz : ℤ) := ∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < sz → x (xi + i) = y (yi + i)
axiom value_sub : (ℤ -> BitVec 64) -> ℤ -> ℤ -> ℤ
axiom value_sub'def (n : ℤ) (m : ℤ) (x : ℤ -> BitVec 64) : if n < m then value_sub x n m = BitVec.toUInt (x n) + ((18446744073709551615 : ℤ) + (1 : ℤ)) * value_sub x (n + (1 : ℤ)) m else value_sub x n m = (0 : ℤ)
noncomputable def value (x : C.ptr (BitVec 64)) (sz : ℤ) := value_sub (C.pelts x) (C.offset x) (C.offset x + sz)
end Lemmas
namespace Alias
axiom mem : Type
axiom inhabited_axiom_mem : Inhabited mem
attribute [instance] inhabited_axiom_mem
axiom zr : mem -> C.zone
axiom zx : mem -> C.zone
axiom zy : mem -> C.zone
axiom mr : mem -> BitVec 32
axiom mx : mem -> BitVec 32
axiom my : mem -> BitVec 32
axiom lr : mem -> BitVec 32
axiom lx : mem -> BitVec 32
axiom ly : mem -> BitVec 32
axiom ok : mem -> Bool
noncomputable def identical (p1 : C.ptr (BitVec 64)) (p2 : C.ptr (BitVec 64)) := C.data p1 = C.data p2 ∧ C.offset p1 = C.offset p2 ∧ C.min p1 = C.min p2 ∧ C.max p1 = C.max p2 ∧ C.zone1 p1 = C.zone1 p2
end Alias
namespace Util
end Util
namespace UtilOld
end UtilOld
namespace Compare
noncomputable def compare_int (x : ℤ) (y : ℤ) := if x < y then -(1 : ℤ) else if x = y then (0 : ℤ) else (1 : ℤ)
end Compare
namespace Add
end Add
namespace AddOld
end AddOld
namespace Sub
end Sub
namespace SubOld
end SubOld
namespace Mul
end Mul
namespace Mul_basecase
end Mul_basecase
namespace Valuation
axiom valuation : ℤ -> ℤ -> ℤ
axiom valuation'def (p : ℤ) (n : ℤ) (fact0 : (1 : ℤ) < p) (fact1 : (1 : ℤ) ≤ n) : if Int.tmod n p = (0 : ℤ) then valuation n p = valuation (Int.tdiv n p) p + (1 : ℤ) else valuation n p = (0 : ℤ)
axiom valuation'spec'0 (p : ℤ) (n : ℤ) (fact0 : (1 : ℤ) < p) (fact1 : (1 : ℤ) ≤ n) : (0 : ℤ) ≤ valuation n p
axiom valuation'spec (p : ℤ) (n : ℤ) (fact0 : (1 : ℤ) < p) (fact1 : (1 : ℤ) ≤ n) : HPow.hPow p (Int.toNat (valuation n p)) ∣  n
end Valuation
namespace Add_1
end Add_1
namespace Sub_1
end Sub_1
namespace LogicalUtil
end LogicalUtil
namespace Logical
end Logical
namespace Toom
end Toom
namespace Z
axiom mpz_ptr : Type
axiom inhabited_axiom_mpz_ptr : Inhabited mpz_ptr
attribute [instance] inhabited_axiom_mpz_ptr
axiom mpz_eq : mpz_ptr -> mpz_ptr -> Prop
axiom mpz_eq'spec (x : mpz_ptr) (y : mpz_ptr) : mpz_eq x y = (x = y)
axiom mpz_memo : Type
axiom inhabited_axiom_mpz_memo : Inhabited mpz_memo
attribute [instance] inhabited_axiom_mpz_memo
axiom abs_value_of : mpz_memo -> mpz_ptr -> ℤ
axiom alloc : mpz_memo -> mpz_ptr -> ℤ
axiom abs_size : mpz_memo -> mpz_ptr -> ℤ
axiom sgn : mpz_memo -> mpz_ptr -> ℤ
axiom readers : mpz_memo -> mpz_ptr -> ℤ
axiom zones : mpz_memo -> mpz_ptr -> C.zone
axiom mpz_memo'invariant (self : mpz_memo) (p : mpz_ptr) : (0 : ℤ) ≤ alloc self p ∧ (sgn self p = (1 : ℤ) ∨ sgn self p = -(1 : ℤ)) ∧ abs_size self p ≤ alloc self p ∧ (0 : ℤ) ≤ abs_size self p ∧ abs_size self p ≤ (2147483647 : ℤ) ∧ (0 : ℤ) ≤ abs_value_of self p ∧ ((1 : ℤ) ≤ abs_size self p → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs_size self p - (1 : ℤ))) ≤ abs_value_of self p) ∧ abs_value_of self p < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs_size self p))
noncomputable def value_of (x : mpz_ptr) (memo : mpz_memo) := sgn memo x * abs_value_of memo x
noncomputable def sgn_value (p : C.ptr (BitVec 64)) (sz : BitVec 32) := if (0 : ℤ) ≤ BitVec.toInt sz then Lemmas.value p (BitVec.toInt sz) else -Lemmas.value p (-BitVec.toInt sz)
noncomputable def mpz_unchanged (x : mpz_ptr) (memo1 : mpz_memo) (memo2 : mpz_memo) := readers memo1 x = readers memo2 x ∧ (-(2 : ℤ) < readers memo1 x → abs_value_of memo1 x = abs_value_of memo2 x ∧ alloc memo1 x = alloc memo2 x ∧ abs_size memo1 x = abs_size memo2 x ∧ sgn memo1 x = sgn memo2 x ∧ zones memo1 x = zones memo2 x)
structure mpz_struct where
  addr : mpz_ptr
axiom inhabited_axiom_mpz_struct : Inhabited mpz_struct
attribute [instance] inhabited_axiom_mpz_struct
end Z
namespace Zutil
axiom mpz_mem : Type
axiom inhabited_axiom_mpz_mem : Inhabited mpz_mem
attribute [instance] inhabited_axiom_mpz_mem
axiom ptr : mpz_mem -> Z.mpz_ptr
axiom ok : mpz_mem -> Bool
end Zutil
namespace mpz_mul_Zmul_wmpz_mulqtvc
lemma wmpz_mul'vc (mpz : Z.mpz_memo) (w : Z.mpz_ptr) (u : Z.mpz_ptr) (v : Z.mpz_ptr) (fact0 : (1 : ℤ) ≤ Z.alloc mpz w) (fact1 : (1 : ℤ) ≤ Z.alloc mpz u) (fact2 : (1 : ℤ) ≤ Z.alloc mpz v) (fact3 : Z.readers mpz w = (0 : ℤ)) (fact4 : Z.readers mpz u = (0 : ℤ)) (fact5 : Z.readers mpz v = (0 : ℤ)) (fact6 : Z.abs_size mpz u + Z.abs_size mpz v ≤ (2147483647 : ℤ)) (fact7 : (8 : ℤ) * Z.abs_size mpz u < (2147483647 : ℤ)) (fact8 : (8 : ℤ) * Z.abs_size mpz v < (2147483647 : ℤ)) : -(2 : ℤ) < Z.readers mpz u ∧ (∀(o1 : BitVec 32), BitVec.toInt o1 = Z.sgn mpz u * Z.abs_size mpz u → -(2 : ℤ) < Z.readers mpz v ∧ (∀(o2 : BitVec 32), BitVec.toInt o2 = Z.sgn mpz v * Z.abs_size mpz v → (∀(sign_product : BitVec 32), (BitVec.toInt o1 = (0 : ℤ) → sign_product = o2) ∧ (BitVec.toInt o2 = (0 : ℤ) → sign_product = o1) ∧ ((0 : ℤ) ≤ BitVec.toInt o1 ∧ (0 : ℤ) ≤ BitVec.toInt o2 ∨ BitVec.toInt o1 < (0 : ℤ) ∧ BitVec.toInt o2 < (0 : ℤ) → (0 : ℤ) ≤ BitVec.toInt sign_product) ∧ (BitVec.toInt o1 < (0 : ℤ) ∧ (0 : ℤ) ≤ BitVec.toInt o2 ∨ (0 : ℤ) ≤ BitVec.toInt o1 ∧ BitVec.toInt o2 < (0 : ℤ) → BitVec.toInt sign_product < (0 : ℤ)) → -(2147483648 : ℤ) < BitVec.toInt o1 ∧ (∀(o3 : BitVec 32), BitVec.toInt o3 = abs (BitVec.toInt o1) → -(2147483648 : ℤ) < BitVec.toInt o2 ∧ (∀(o4 : BitVec 32), BitVec.toInt o4 = abs (BitVec.toInt o2) → (if BitVec.toInt o3 < BitVec.toInt o4 then (Z.readers mpz u = (0 : ℤ) ∧ Z.readers mpz v = (0 : ℤ)) ∧ (Z.readers mpz v = (0 : ℤ) ∧ Z.readers mpz u = (0 : ℤ) → (Z.abs_size mpz v = BitVec.toInt o4 ∧ Z.abs_size mpz u = BitVec.toInt o3) ∧ ((1 : ℤ) ≤ Z.alloc mpz v ∧ (1 : ℤ) ≤ Z.alloc mpz u) ∧ BitVec.toInt o3 ≤ BitVec.toInt o4 ∧ BitVec.toInt o4 + BitVec.toInt o3 ≤ (2147483647 : ℤ) ∧ (8 : ℤ) * BitVec.toInt o4 < (2147483647 : ℤ) ∧ (Z.readers mpz w = (0 : ℤ) ∧ Z.readers mpz v = (0 : ℤ) ∧ Z.readers mpz u = (0 : ℤ)) ∧ Z.abs_value_of mpz v * Z.abs_value_of mpz u = Z.abs_value_of mpz u * Z.abs_value_of mpz v ∧ Z.value_of v mpz * Z.value_of u mpz = Z.value_of u mpz * Z.value_of v mpz ∧ (v = u ∧ u = v ∨ True)) else (Z.abs_size mpz u = BitVec.toInt o3 ∧ Z.abs_size mpz v = BitVec.toInt o4) ∧ ((1 : ℤ) ≤ Z.alloc mpz u ∧ (1 : ℤ) ≤ Z.alloc mpz v) ∧ BitVec.toInt o4 ≤ BitVec.toInt o3 ∧ BitVec.toInt o3 + BitVec.toInt o4 ≤ (2147483647 : ℤ) ∧ (8 : ℤ) * BitVec.toInt o3 < (2147483647 : ℤ) ∧ Z.readers mpz w = (0 : ℤ) ∧ Z.readers mpz u = (0 : ℤ) ∧ Z.readers mpz v = (0 : ℤ)) ∧ (∀(vsize : BitVec 32) (usize : BitVec 32) (v1 : Z.mpz_ptr) (u1 : Z.mpz_ptr), (Z.abs_size mpz u1 = BitVec.toInt usize ∧ Z.abs_size mpz v1 = BitVec.toInt vsize) ∧ ((1 : ℤ) ≤ Z.alloc mpz u1 ∧ (1 : ℤ) ≤ Z.alloc mpz v1) ∧ BitVec.toInt vsize ≤ BitVec.toInt usize ∧ BitVec.toInt usize + BitVec.toInt vsize ≤ (2147483647 : ℤ) ∧ (8 : ℤ) * BitVec.toInt usize < (2147483647 : ℤ) ∧ (Z.readers mpz w = (0 : ℤ) ∧ Z.readers mpz u1 = (0 : ℤ) ∧ Z.readers mpz v1 = (0 : ℤ)) ∧ Z.abs_value_of mpz u1 * Z.abs_value_of mpz v1 = Z.abs_value_of mpz u * Z.abs_value_of mpz v ∧ Z.value_of u1 mpz * Z.value_of v1 mpz = Z.value_of u mpz * Z.value_of v mpz ∧ (u1 = u ∧ v1 = v ∨ u1 = v ∧ v1 = u) → (∀(o5 : Bool), (BitVec.toInt vsize = BitVec.toInt (0 : BitVec 32) → o5 = true) ∧ (o5 = true → vsize = (0 : BitVec 32)) → (if o5 = true then (-(1 : ℤ) ≤ Z.readers mpz w ∧ Z.readers mpz w ≤ (0 : ℤ)) ∧ (∀(mpz1 : Z.mpz_memo), Z.alloc mpz1 = Z.alloc mpz ∧ Z.sgn mpz1 = Z.sgn mpz ∧ Z.readers mpz1 = Z.readers mpz ∧ Z.zones mpz1 = Z.zones mpz → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz1 mpz) ∧ Z.abs_size mpz1 w = (0 : ℤ) ∧ Z.abs_value_of mpz1 w = (0 : ℤ) → Z.value_of w mpz1 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz1 mpz) ∧ Z.readers mpz1 w = (0 : ℤ) ∧ Z.readers mpz1 u = (0 : ℤ) ∧ Z.readers mpz1 v = (0 : ℤ)) else Z.mpz_eq u1 w = (u1 = w) → Z.mpz_eq v1 w = (v1 = w) → (∀(o6 : Bool), (BitVec.toInt vsize = BitVec.toInt (1 : BitVec 32) → o6 = true) ∧ (o6 = true → vsize = (1 : BitVec 32)) → (if o6 = true then (0 : ℤ) ≤ Z.readers mpz v1 ∧ (∀(mpz1 : Z.mpz_memo), Z.abs_value_of mpz1 = Z.abs_value_of mpz ∧ Z.alloc mpz1 = Z.alloc mpz ∧ Z.abs_size mpz1 = Z.abs_size mpz ∧ Z.sgn mpz1 = Z.sgn mpz ∧ Z.zones mpz1 = Z.zones mpz → (∀(vp : C.ptr (BitVec 64)), Z.readers mpz1 v1 = Z.readers mpz v1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬v1 = y → Z.readers mpz1 y = Z.readers mpz y) ∧ Lemmas.value vp (Z.abs_size mpz1 v1) = Z.abs_value_of mpz1 v1 ∧ C.plength vp = Z.alloc mpz1 v1 ∧ C.offset vp = (0 : ℤ) ∧ C.min vp = (0 : ℤ) ∧ C.max vp = C.plength vp ∧ C.zone1 vp = Z.zones mpz1 v1 → (C.min vp ≤ C.offset vp ∧ C.offset vp < C.max vp) ∧ (let v0 : BitVec 64 := C.pelts vp (C.offset vp); (Z.zones mpz1 v1 = C.zone1 vp ∧ (1 : ℤ) ≤ Z.readers mpz1 v1 ∧ C.min vp = (0 : ℤ) ∧ C.max vp = C.plength vp) ∧ (∀(mpz2 : Z.mpz_memo), Z.abs_value_of mpz2 = Z.abs_value_of mpz1 ∧ Z.alloc mpz2 = Z.alloc mpz1 ∧ Z.abs_size mpz2 = Z.abs_size mpz1 ∧ Z.sgn mpz2 = Z.sgn mpz1 ∧ Z.zones mpz2 = Z.zones mpz1 → Z.readers mpz2 v1 = Z.readers mpz1 v1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = v1 → Z.readers mpz2 y = Z.readers mpz1 y) → int'32_in_bounds (BitVec.toInt usize + (1 : ℤ)) ∧ (∀(o7 : BitVec 32), BitVec.toInt o7 = BitVec.toInt usize + (1 : ℤ) → (Z.readers mpz2 w = (0 : ℤ) ∧ (1 : ℤ) ≤ Z.alloc mpz2 w) ∧ (∀(mpz3 : Z.mpz_memo), Z.sgn mpz3 = Z.sgn mpz2 → (∀(wp : C.ptr (BitVec 64)), (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz3 mpz2) ∧ Z.readers mpz3 w = -(1 : ℤ) ∧ Z.abs_value_of mpz3 w = Lemmas.value wp (Z.abs_size mpz3 w) ∧ Z.zones mpz3 w = C.zone1 wp ∧ C.offset wp = (0 : ℤ) ∧ C.plength wp = Z.alloc mpz3 w ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp ∧ C.writable wp = true ∧ Z.abs_size mpz3 w = Z.abs_size mpz2 w ∧ Lemmas.value wp (Z.abs_size mpz2 w) = Z.abs_value_of mpz2 w ∧ (if Z.alloc mpz2 w < BitVec.toInt o7 then Z.alloc mpz3 w = BitVec.toInt o7 else Z.alloc mpz3 w = Z.alloc mpz2 w) → (if Z.mpz_eq u1 w then (C.valid wp (BitVec.toInt usize) ∧ C.writable wp = true) ∧ (∀(wp1 : C.ptr (BitVec 64)), List.length (C.data wp1) = List.length (C.data wp) ∧ C.offset wp1 = C.offset wp ∧ C.min wp1 = C.min wp ∧ C.max wp1 = C.max wp ∧ C.writable wp1 = C.writable wp ∧ C.zone1 wp1 = C.zone1 wp → (∀(cy : BitVec 64), Lemmas.value wp1 (BitVec.toInt usize) + HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt usize)) * BitVec.toUInt cy = Lemmas.value wp (BitVec.toInt usize) * BitVec.toUInt v0 ∧ (∀(j : ℤ), j < C.offset wp1 ∨ C.offset wp1 + BitVec.toInt usize ≤ j → C.pelts wp1 j = C.pelts wp j) → ((C.min wp1 ≤ C.offset wp1 + BitVec.toInt usize ∧ C.offset wp1 + BitVec.toInt usize < C.max wp1) ∧ C.writable wp1 = true) ∧ (∀(wp2 : C.ptr (BitVec 64)), List.length (C.data wp2) = List.length (C.data wp1) ∧ C.offset wp2 = C.offset wp1 ∧ C.min wp2 = C.min wp1 ∧ C.max wp2 = C.max wp1 ∧ C.writable wp2 = C.writable wp1 ∧ C.zone1 wp2 = C.zone1 wp1 → C.pelts wp2 = Function.update (C.pelts wp1) (C.offset wp2 + BitVec.toInt usize) cy ∧ C.pelts wp2 (C.offset wp2 + BitVec.toInt usize) = cy → (∀(o8 : Bool), (BitVec.toUInt cy = BitVec.toUInt (0 : BitVec 64) → o8 = true) ∧ (o8 = true → cy = (0 : BitVec 64)) → (∀(o9 : BitVec 32), (if ¬o8 = true then o9 = (1 : BitVec 32) else o9 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt usize + BitVec.toInt o9) ∧ (∀(o10 : BitVec 32), BitVec.toInt o10 = BitVec.toInt usize + BitVec.toInt o9 → ((¬(0 : ℤ) ≤ BitVec.toInt sign_product → int'32_in_bounds (-BitVec.toInt o10) ∧ (∀(us : BitVec 32), BitVec.toInt us = -BitVec.toInt o10 → int'32_in_bounds (-BitVec.toInt o10))) ∧ (∀(result : BitVec 32), (if (0 : ℤ) ≤ BitVec.toInt sign_product then result = o10 else ∃(us : BitVec 32), BitVec.toInt us = -BitVec.toInt o10 ∧ BitVec.toInt result = -BitVec.toInt o10) → Z.sgn_value wp2 result = Z.value_of u mpz * Z.value_of v mpz ∧ abs (BitVec.toInt result) = BitVec.toInt o10)) ∧ (∀(wsize : BitVec 32), Z.sgn_value wp2 wsize = Z.value_of u mpz * Z.value_of v mpz ∧ abs (BitVec.toInt wsize) = BitVec.toInt o10 → (Z.zones mpz3 w = C.zone1 wp2 ∧ Z.readers mpz3 w = -(1 : ℤ) ∧ C.offset wp2 = (0 : ℤ) ∧ C.min wp2 = (0 : ℤ) ∧ C.max wp2 = C.plength wp2 ∧ abs (BitVec.toInt wsize) ≤ C.plength wp2 ∧ C.plength wp2 = Z.alloc mpz3 w ∧ (¬BitVec.toInt wsize = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt wsize) - (1 : ℤ))) ≤ Lemmas.value wp2 (abs (BitVec.toInt wsize)))) ∧ (∀(mpz4 : Z.mpz_memo), Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.readers mpz4 = Z.readers mpz3 ∧ Z.zones mpz4 = Z.zones mpz3 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz4 mpz3) ∧ (Z.sgn mpz4 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt wsize) ∧ (Z.sgn mpz4 w = -(1 : ℤ)) = (BitVec.toInt wsize < (0 : ℤ)) ∧ Z.abs_size mpz4 w = abs (BitVec.toInt wsize) ∧ Z.abs_value_of mpz4 w = Lemmas.value wp2 (abs (BitVec.toInt wsize)) → (Z.zones mpz4 w = C.zone1 wp2 ∧ Z.readers mpz4 w = -(1 : ℤ) ∧ C.min wp2 = (0 : ℤ) ∧ C.max wp2 = C.plength wp2 ∧ Z.abs_value_of mpz4 w = Lemmas.value wp2 (Z.abs_size mpz4 w)) ∧ (∀(mpz5 : Z.mpz_memo), Z.abs_value_of mpz5 = Z.abs_value_of mpz4 ∧ Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.abs_size mpz5 = Z.abs_size mpz4 ∧ Z.sgn mpz5 = Z.sgn mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → Z.readers mpz5 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz5 y = Z.readers mpz4 y) → Z.value_of w mpz5 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz5 mpz) ∧ Z.readers mpz5 w = (0 : ℤ) ∧ Z.readers mpz5 u = (0 : ℤ) ∧ Z.readers mpz5 v = (0 : ℤ)))))))))) else Z.mpz_unchanged u1 mpz3 mpz ∧ (Z.readers mpz3 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz3 u1 → Z.abs_value_of mpz3 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz3 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz3 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz3 u1 = Z.sgn mpz u1 ∧ Z.readers mpz3 u1 = Z.readers mpz u1 ∧ Z.zones mpz3 u1 = Z.zones mpz u1) → (0 : ℤ) ≤ Z.readers mpz3 u1 ∧ (∀(mpz4 : Z.mpz_memo), Z.abs_value_of mpz4 = Z.abs_value_of mpz3 ∧ Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.abs_size mpz4 = Z.abs_size mpz3 ∧ Z.sgn mpz4 = Z.sgn mpz3 ∧ Z.zones mpz4 = Z.zones mpz3 → (∀(up : C.ptr (BitVec 64)), Z.readers mpz4 u1 = Z.readers mpz3 u1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬u1 = y → Z.readers mpz4 y = Z.readers mpz3 y) ∧ Lemmas.value up (Z.abs_size mpz4 u1) = Z.abs_value_of mpz4 u1 ∧ C.plength up = Z.alloc mpz4 u1 ∧ C.offset up = (0 : ℤ) ∧ C.min up = (0 : ℤ) ∧ C.max up = C.plength up ∧ C.zone1 up = Z.zones mpz4 u1 → (C.valid up (BitVec.toInt usize) ∧ C.valid wp (BitVec.toInt usize) ∧ C.writable wp = true) ∧ (∀(wp1 : C.ptr (BitVec 64)), List.length (C.data wp1) = List.length (C.data wp) ∧ C.offset wp1 = C.offset wp ∧ C.min wp1 = C.min wp ∧ C.max wp1 = C.max wp ∧ C.writable wp1 = C.writable wp ∧ C.zone1 wp1 = C.zone1 wp → (∀(cy : BitVec 64), Lemmas.value wp1 (BitVec.toInt usize) + HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt usize)) * BitVec.toUInt cy = Lemmas.value up (BitVec.toInt usize) * BitVec.toUInt v0 ∧ (∀(j : ℤ), j < C.offset wp1 ∨ C.offset wp1 + BitVec.toInt usize ≤ j → C.pelts wp1 j = C.pelts wp j) → (Z.zones mpz4 u1 = C.zone1 up ∧ (1 : ℤ) ≤ Z.readers mpz4 u1 ∧ C.min up = (0 : ℤ) ∧ C.max up = C.plength up) ∧ (∀(mpz5 : Z.mpz_memo), Z.abs_value_of mpz5 = Z.abs_value_of mpz4 ∧ Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.abs_size mpz5 = Z.abs_size mpz4 ∧ Z.sgn mpz5 = Z.sgn mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → Z.readers mpz5 u1 = Z.readers mpz4 u1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = u1 → Z.readers mpz5 y = Z.readers mpz4 y) → ((C.min wp1 ≤ C.offset wp1 + BitVec.toInt usize ∧ C.offset wp1 + BitVec.toInt usize < C.max wp1) ∧ C.writable wp1 = true) ∧ (∀(wp2 : C.ptr (BitVec 64)), List.length (C.data wp2) = List.length (C.data wp1) ∧ C.offset wp2 = C.offset wp1 ∧ C.min wp2 = C.min wp1 ∧ C.max wp2 = C.max wp1 ∧ C.writable wp2 = C.writable wp1 ∧ C.zone1 wp2 = C.zone1 wp1 → C.pelts wp2 = Function.update (C.pelts wp1) (C.offset wp2 + BitVec.toInt usize) cy ∧ C.pelts wp2 (C.offset wp2 + BitVec.toInt usize) = cy → (∀(o8 : Bool), (BitVec.toUInt cy = BitVec.toUInt (0 : BitVec 64) → o8 = true) ∧ (o8 = true → cy = (0 : BitVec 64)) → (∀(o9 : BitVec 32), (if ¬o8 = true then o9 = (1 : BitVec 32) else o9 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt usize + BitVec.toInt o9) ∧ (∀(o10 : BitVec 32), BitVec.toInt o10 = BitVec.toInt usize + BitVec.toInt o9 → ((¬(0 : ℤ) ≤ BitVec.toInt sign_product → int'32_in_bounds (-BitVec.toInt o10) ∧ (∀(us : BitVec 32), BitVec.toInt us = -BitVec.toInt o10 → int'32_in_bounds (-BitVec.toInt o10))) ∧ (∀(result : BitVec 32), (if (0 : ℤ) ≤ BitVec.toInt sign_product then result = o10 else ∃(us : BitVec 32), BitVec.toInt us = -BitVec.toInt o10 ∧ BitVec.toInt result = -BitVec.toInt o10) → Z.sgn_value wp2 result = Z.value_of u mpz * Z.value_of v mpz ∧ abs (BitVec.toInt result) = BitVec.toInt o10)) ∧ (∀(wsize : BitVec 32), Z.sgn_value wp2 wsize = Z.value_of u mpz * Z.value_of v mpz ∧ abs (BitVec.toInt wsize) = BitVec.toInt o10 → (Z.zones mpz5 w = C.zone1 wp2 ∧ Z.readers mpz5 w = -(1 : ℤ) ∧ C.offset wp2 = (0 : ℤ) ∧ C.min wp2 = (0 : ℤ) ∧ C.max wp2 = C.plength wp2 ∧ abs (BitVec.toInt wsize) ≤ C.plength wp2 ∧ C.plength wp2 = Z.alloc mpz5 w ∧ (¬BitVec.toInt wsize = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt wsize) - (1 : ℤ))) ≤ Lemmas.value wp2 (abs (BitVec.toInt wsize)))) ∧ (∀(mpz6 : Z.mpz_memo), Z.alloc mpz6 = Z.alloc mpz5 ∧ Z.readers mpz6 = Z.readers mpz5 ∧ Z.zones mpz6 = Z.zones mpz5 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz6 mpz5) ∧ (Z.sgn mpz6 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt wsize) ∧ (Z.sgn mpz6 w = -(1 : ℤ)) = (BitVec.toInt wsize < (0 : ℤ)) ∧ Z.abs_size mpz6 w = abs (BitVec.toInt wsize) ∧ Z.abs_value_of mpz6 w = Lemmas.value wp2 (abs (BitVec.toInt wsize)) → (Z.zones mpz6 w = C.zone1 wp2 ∧ Z.readers mpz6 w = -(1 : ℤ) ∧ C.min wp2 = (0 : ℤ) ∧ C.max wp2 = C.plength wp2 ∧ Z.abs_value_of mpz6 w = Lemmas.value wp2 (Z.abs_size mpz6 w)) ∧ (∀(mpz7 : Z.mpz_memo), Z.abs_value_of mpz7 = Z.abs_value_of mpz6 ∧ Z.alloc mpz7 = Z.alloc mpz6 ∧ Z.abs_size mpz7 = Z.abs_size mpz6 ∧ Z.sgn mpz7 = Z.sgn mpz6 ∧ Z.zones mpz7 = Z.zones mpz6 → Z.readers mpz7 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz7 y = Z.readers mpz6 y) → Z.value_of w mpz7 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz7 mpz) ∧ Z.readers mpz7 w = (0 : ℤ) ∧ Z.readers mpz7 u = (0 : ℤ) ∧ Z.readers mpz7 v = (0 : ℤ)))))))))))))))))))))) else int'32_in_bounds (BitVec.toInt usize + BitVec.toInt vsize) ∧ (∀(o7 : BitVec 32), BitVec.toInt o7 = BitVec.toInt usize + BitVec.toInt vsize → -(2 : ℤ) < Z.readers mpz w ∧ (∀(o8 : BitVec 32), BitVec.toInt o8 = Z.alloc mpz w → (if BitVec.toInt o8 < BitVec.toInt o7 then ∀(mpz1 : Z.mpz_memo) (memw : Zutil.mpz_mem), Zutil.ok memw = true ∧ Z.readers mpz1 (Zutil.ptr memw) = (0 : ℤ) ∧ Z.alloc mpz1 (Zutil.ptr memw) = (0 : ℤ) ∧ Z.abs_size mpz1 (Zutil.ptr memw) = (0 : ℤ) ∧ Z.readers mpz (Zutil.ptr memw) = -(2 : ℤ) ∧ (∀(x : Z.mpz_ptr), ¬x = Zutil.ptr memw → Z.mpz_unchanged x mpz1 mpz) → Z.readers mpz1 (Zutil.ptr memw) = (0 : ℤ) ∧ (∀(mpz2 : Z.mpz_memo), (∀(x : Z.mpz_ptr), ¬x = Zutil.ptr memw → Z.mpz_unchanged x mpz2 mpz1) ∧ Z.readers mpz2 (Zutil.ptr memw) = (0 : ℤ) ∧ Z.abs_value_of mpz2 (Zutil.ptr memw) = (0 : ℤ) ∧ Z.abs_size mpz2 (Zutil.ptr memw) = (0 : ℤ) ∧ Z.sgn mpz2 (Zutil.ptr memw) = (1 : ℤ) ∧ Z.alloc mpz2 (Zutil.ptr memw) = (1 : ℤ) ∧ ¬Z.zones mpz2 (Zutil.ptr memw) = C.null_zone → (Z.readers mpz2 (Zutil.ptr memw) = (0 : ℤ) ∧ (1 : ℤ) ≤ Z.alloc mpz2 (Zutil.ptr memw)) ∧ (∀(mpz3 : Z.mpz_memo), Z.sgn mpz3 = Z.sgn mpz2 → (∀(wp' : C.ptr (BitVec 64)), (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr memw → Z.mpz_unchanged y mpz3 mpz2) ∧ Z.readers mpz3 (Zutil.ptr memw) = -(1 : ℤ) ∧ Z.abs_value_of mpz3 (Zutil.ptr memw) = Lemmas.value wp' (Z.abs_size mpz3 (Zutil.ptr memw)) ∧ Z.zones mpz3 (Zutil.ptr memw) = C.zone1 wp' ∧ C.offset wp' = (0 : ℤ) ∧ C.plength wp' = Z.alloc mpz3 (Zutil.ptr memw) ∧ C.min wp' = (0 : ℤ) ∧ C.max wp' = C.plength wp' ∧ C.writable wp' = true ∧ Z.abs_size mpz3 (Zutil.ptr memw) = Z.abs_size mpz2 (Zutil.ptr memw) ∧ Lemmas.value wp' (Z.abs_size mpz2 (Zutil.ptr memw)) = Z.abs_value_of mpz2 (Zutil.ptr memw) ∧ (if Z.alloc mpz2 (Zutil.ptr memw) < BitVec.toInt o7 then Z.alloc mpz3 (Zutil.ptr memw) = BitVec.toInt o7 else Z.alloc mpz3 (Zutil.ptr memw) = Z.alloc mpz2 (Zutil.ptr memw)) → Z.mpz_unchanged u1 mpz3 mpz ∧ (Z.readers mpz3 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz3 u1 → Z.abs_value_of mpz3 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz3 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz3 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz3 u1 = Z.sgn mpz u1 ∧ Z.readers mpz3 u1 = Z.readers mpz u1 ∧ Z.zones mpz3 u1 = Z.zones mpz u1) → Z.mpz_unchanged v1 mpz3 mpz ∧ (Z.readers mpz3 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz3 v1 → Z.abs_value_of mpz3 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz3 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz3 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz3 v1 = Z.sgn mpz v1 ∧ Z.readers mpz3 v1 = Z.readers mpz v1 ∧ Z.zones mpz3 v1 = Z.zones mpz v1) → Z.mpz_unchanged w mpz3 mpz ∧ (Z.readers mpz3 w = Z.readers mpz w ∧ (-(2 : ℤ) < Z.readers mpz3 w → Z.abs_value_of mpz3 w = Z.abs_value_of mpz w ∧ Z.alloc mpz3 w = Z.alloc mpz w ∧ Z.abs_size mpz3 w = Z.abs_size mpz w ∧ Z.sgn mpz3 w = Z.sgn mpz w ∧ Z.readers mpz3 w = Z.readers mpz w ∧ Z.zones mpz3 w = Z.zones mpz w) → (Z.zones mpz3 (Zutil.ptr memw) = C.zone1 wp' ∧ Z.readers mpz3 (Zutil.ptr memw) = -(1 : ℤ) ∧ C.min wp' = (0 : ℤ) ∧ C.max wp' = C.plength wp' ∧ Z.abs_value_of mpz3 (Zutil.ptr memw) = Lemmas.value wp' (Z.abs_size mpz3 (Zutil.ptr memw))) ∧ (∀(mpz4 : Z.mpz_memo), Z.abs_value_of mpz4 = Z.abs_value_of mpz3 ∧ Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.abs_size mpz4 = Z.abs_size mpz3 ∧ Z.sgn mpz4 = Z.sgn mpz3 ∧ Z.zones mpz4 = Z.zones mpz3 → Z.readers mpz4 (Zutil.ptr memw) = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr memw → Z.readers mpz4 y = Z.readers mpz3 y) → (0 : ℤ) ≤ Z.readers mpz4 u1 ∧ (∀(mpz5 : Z.mpz_memo), Z.abs_value_of mpz5 = Z.abs_value_of mpz4 ∧ Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.abs_size mpz5 = Z.abs_size mpz4 ∧ Z.sgn mpz5 = Z.sgn mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → (∀(up' : C.ptr (BitVec 64)), Z.readers mpz5 u1 = Z.readers mpz4 u1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬u1 = y → Z.readers mpz5 y = Z.readers mpz4 y) ∧ Lemmas.value up' (Z.abs_size mpz5 u1) = Z.abs_value_of mpz5 u1 ∧ C.plength up' = Z.alloc mpz5 u1 ∧ C.offset up' = (0 : ℤ) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up' ∧ C.zone1 up' = Z.zones mpz5 u1 → (0 : ℤ) ≤ Z.readers mpz5 v1 ∧ (∀(mpz6 : Z.mpz_memo), Z.abs_value_of mpz6 = Z.abs_value_of mpz5 ∧ Z.alloc mpz6 = Z.alloc mpz5 ∧ Z.abs_size mpz6 = Z.abs_size mpz5 ∧ Z.sgn mpz6 = Z.sgn mpz5 ∧ Z.zones mpz6 = Z.zones mpz5 → (∀(vp' : C.ptr (BitVec 64)), Z.readers mpz6 v1 = Z.readers mpz5 v1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬v1 = y → Z.readers mpz6 y = Z.readers mpz5 y) ∧ Lemmas.value vp' (Z.abs_size mpz6 v1) = Z.abs_value_of mpz6 v1 ∧ C.plength vp' = Z.alloc mpz6 v1 ∧ C.offset vp' = (0 : ℤ) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp' ∧ C.zone1 vp' = Z.zones mpz6 v1 → Z.mpz_unchanged (Zutil.ptr memw) mpz6 mpz4 ∧ (Z.readers mpz6 (Zutil.ptr memw) = Z.readers mpz4 (Zutil.ptr memw) ∧ (-(2 : ℤ) < Z.readers mpz6 (Zutil.ptr memw) → Z.abs_value_of mpz6 (Zutil.ptr memw) = Z.abs_value_of mpz4 (Zutil.ptr memw) ∧ Z.alloc mpz6 (Zutil.ptr memw) = Z.alloc mpz4 (Zutil.ptr memw) ∧ Z.abs_size mpz6 (Zutil.ptr memw) = Z.abs_size mpz4 (Zutil.ptr memw) ∧ Z.sgn mpz6 (Zutil.ptr memw) = Z.sgn mpz4 (Zutil.ptr memw) ∧ Z.readers mpz6 (Zutil.ptr memw) = Z.readers mpz4 (Zutil.ptr memw) ∧ Z.zones mpz6 (Zutil.ptr memw) = Z.zones mpz4 (Zutil.ptr memw)) → Z.readers mpz6 (Zutil.ptr memw) = (0 : ℤ) ∧ (∀(mpz7 : Z.mpz_memo), Z.abs_value_of mpz7 = Z.abs_value_of mpz6 ∧ Z.alloc mpz7 = Z.alloc mpz6 ∧ Z.abs_size mpz7 = Z.abs_size mpz6 ∧ Z.sgn mpz7 = Z.sgn mpz6 ∧ Z.zones mpz7 = Z.zones mpz6 → (∀(wp'1 : C.ptr (BitVec 64)), Z.readers mpz7 (Zutil.ptr memw) = -(1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬Zutil.ptr memw = y → Z.readers mpz7 y = Z.readers mpz6 y) ∧ Lemmas.value wp'1 (Z.abs_size mpz7 (Zutil.ptr memw)) = Z.abs_value_of mpz7 (Zutil.ptr memw) ∧ C.plength wp'1 = Z.alloc mpz7 (Zutil.ptr memw) ∧ C.offset wp'1 = (0 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ C.writable wp'1 = true ∧ C.zone1 wp'1 = Z.zones mpz7 (Zutil.ptr memw) → Z.mpz_unchanged u1 mpz7 mpz6 ∧ (Z.readers mpz7 u1 = Z.readers mpz6 u1 ∧ (-(2 : ℤ) < Z.readers mpz7 u1 → Z.abs_value_of mpz7 u1 = Z.abs_value_of mpz6 u1 ∧ Z.alloc mpz7 u1 = Z.alloc mpz6 u1 ∧ Z.abs_size mpz7 u1 = Z.abs_size mpz6 u1 ∧ Z.sgn mpz7 u1 = Z.sgn mpz6 u1 ∧ Z.readers mpz7 u1 = Z.readers mpz6 u1 ∧ Z.zones mpz7 u1 = Z.zones mpz6 u1) → Z.mpz_unchanged v1 mpz7 mpz6 ∧ (Z.readers mpz7 v1 = Z.readers mpz6 v1 ∧ (-(2 : ℤ) < Z.readers mpz7 v1 → Z.abs_value_of mpz7 v1 = Z.abs_value_of mpz6 v1 ∧ Z.alloc mpz7 v1 = Z.alloc mpz6 v1 ∧ Z.abs_size mpz7 v1 = Z.abs_size mpz6 v1 ∧ Z.sgn mpz7 v1 = Z.sgn mpz6 v1 ∧ Z.readers mpz7 v1 = Z.readers mpz6 v1 ∧ Z.zones mpz7 v1 = Z.zones mpz6 v1) → (C.valid up' (BitVec.toInt usize) ∧ C.valid vp' (BitVec.toInt vsize) ∧ C.valid wp'1 (BitVec.toInt usize + BitVec.toInt vsize) ∧ C.writable wp'1 = true ∧ ((0 : ℤ) < BitVec.toInt vsize ∧ BitVec.toInt vsize ≤ BitVec.toInt usize) ∧ (8 : ℤ) * BitVec.toInt usize < (2147483647 : ℤ) ∧ BitVec.toInt usize ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(wp'2 : C.ptr (BitVec 64)), C.offset wp'2 = C.offset wp'1 ∧ C.writable wp'2 = C.writable wp'1 ∧ C.zone1 wp'2 = C.zone1 wp'1 → C.min wp'2 = C.min wp'1 ∧ C.max wp'2 = C.max wp'1 ∧ C.plength wp'2 = C.plength wp'1 ∧ Lemmas.value wp'2 (BitVec.toInt usize + BitVec.toInt vsize) = Lemmas.value up' (BitVec.toInt usize) * Lemmas.value vp' (BitVec.toInt vsize) ∧ (∀(j : ℤ), C.min wp'2 ≤ j ∧ j < C.offset wp'2 ∨ C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize ≤ j ∧ j < C.max wp'2 → C.pelts wp'2 j = C.pelts wp'1 j) → (∀(o9 : Bool), (BitVec.toUInt (C.pelts wp'2 (C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o9 = true) ∧ (o9 = true → C.pelts wp'2 (C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o10 : BitVec 32), (if o9 = true then o10 = (1 : BitVec 32) else o10 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o10) ∧ (∀(wsize' : BitVec 32), BitVec.toInt wsize' = BitVec.toInt o7 - BitVec.toInt o10 → (Z.zones mpz7 u1 = C.zone1 up' ∧ (1 : ℤ) ≤ Z.readers mpz7 u1 ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up') ∧ (∀(mpz8 : Z.mpz_memo), Z.abs_value_of mpz8 = Z.abs_value_of mpz7 ∧ Z.alloc mpz8 = Z.alloc mpz7 ∧ Z.abs_size mpz8 = Z.abs_size mpz7 ∧ Z.sgn mpz8 = Z.sgn mpz7 ∧ Z.zones mpz8 = Z.zones mpz7 → Z.readers mpz8 u1 = Z.readers mpz7 u1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = u1 → Z.readers mpz8 y = Z.readers mpz7 y) → Z.mpz_eq u1 v1 = (u1 = v1) → (¬Z.mpz_eq u1 v1 → Z.mpz_unchanged v1 mpz8 mpz6) ∧ ((¬Z.mpz_eq u1 v1 → Z.readers mpz8 v1 = Z.readers mpz6 v1 ∧ (-(2 : ℤ) < Z.readers mpz8 v1 → Z.abs_value_of mpz8 v1 = Z.abs_value_of mpz6 v1 ∧ Z.alloc mpz8 v1 = Z.alloc mpz6 v1 ∧ Z.abs_size mpz8 v1 = Z.abs_size mpz6 v1 ∧ Z.sgn mpz8 v1 = Z.sgn mpz6 v1 ∧ Z.readers mpz8 v1 = Z.readers mpz6 v1 ∧ Z.zones mpz8 v1 = Z.zones mpz6 v1)) → (Z.zones mpz8 v1 = C.zone1 vp' ∧ (1 : ℤ) ≤ Z.readers mpz8 v1 ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp') ∧ (∀(mpz9 : Z.mpz_memo), Z.abs_value_of mpz9 = Z.abs_value_of mpz8 ∧ Z.alloc mpz9 = Z.alloc mpz8 ∧ Z.abs_size mpz9 = Z.abs_size mpz8 ∧ Z.sgn mpz9 = Z.sgn mpz8 ∧ Z.zones mpz9 = Z.zones mpz8 → Z.readers mpz9 v1 = Z.readers mpz8 v1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = v1 → Z.readers mpz9 y = Z.readers mpz8 y) → Z.mpz_unchanged (Zutil.ptr memw) mpz9 mpz7 ∧ (Z.readers mpz9 (Zutil.ptr memw) = Z.readers mpz7 (Zutil.ptr memw) ∧ (-(2 : ℤ) < Z.readers mpz9 (Zutil.ptr memw) → Z.abs_value_of mpz9 (Zutil.ptr memw) = Z.abs_value_of mpz7 (Zutil.ptr memw) ∧ Z.alloc mpz9 (Zutil.ptr memw) = Z.alloc mpz7 (Zutil.ptr memw) ∧ Z.abs_size mpz9 (Zutil.ptr memw) = Z.abs_size mpz7 (Zutil.ptr memw) ∧ Z.sgn mpz9 (Zutil.ptr memw) = Z.sgn mpz7 (Zutil.ptr memw) ∧ Z.readers mpz9 (Zutil.ptr memw) = Z.readers mpz7 (Zutil.ptr memw) ∧ Z.zones mpz9 (Zutil.ptr memw) = Z.zones mpz7 (Zutil.ptr memw)) → (if True then Z.readers mpz9 w = (0 : ℤ) ∧ (∀(mpz10 : Z.mpz_memo), Z.abs_value_of mpz10 = Z.abs_value_of mpz9 ∧ Z.alloc mpz10 = Z.alloc mpz9 ∧ Z.abs_size mpz10 = Z.abs_size mpz9 ∧ Z.sgn mpz10 = Z.sgn mpz9 ∧ Z.zones mpz10 = Z.zones mpz9 → (∀(wp : C.ptr (BitVec 64)), Z.readers mpz10 w = -(1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz10 y = Z.readers mpz9 y) ∧ Lemmas.value wp (Z.abs_size mpz10 w) = Z.abs_value_of mpz10 w ∧ C.plength wp = Z.alloc mpz10 w ∧ C.offset wp = (0 : ℤ) ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp ∧ C.writable wp = true ∧ C.zone1 wp = Z.zones mpz10 w → (C.offset wp = (0 : ℤ) ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp ∧ C.writable wp = true) ∧ (Z.abs_size mpz10 w ≤ BitVec.toInt o7 ∧ -(1 : ℤ) ≤ Z.readers mpz10 w ∧ Z.readers mpz10 w ≤ (0 : ℤ)) ∧ (∀(mpz11 : Z.mpz_memo), Z.abs_value_of mpz11 = Z.abs_value_of mpz10 ∧ Z.abs_size mpz11 = Z.abs_size mpz10 ∧ Z.sgn mpz11 = Z.sgn mpz10 ∧ Z.readers mpz11 = Z.readers mpz10 ∧ Z.zones mpz11 = Z.zones mpz10 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz11 mpz10) ∧ Z.alloc mpz11 w = BitVec.toInt o7 → (Zutil.ok memw = true ∧ -(1 : ℤ) ≤ Z.readers mpz11 (Zutil.ptr memw) ∧ Z.readers mpz11 (Zutil.ptr memw) ≤ (0 : ℤ)) ∧ (∀(mpz12 : Z.mpz_memo), Z.readers mpz12 (Zutil.ptr memw) = -(2 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr memw → Z.mpz_unchanged y mpz12 mpz11) → Z.mpz_eq u1 w = (u1 = w) → (¬Z.mpz_eq u1 w → Z.mpz_unchanged u1 mpz12 mpz9) ∧ ((¬Z.mpz_eq u1 w → Z.readers mpz12 u1 = Z.readers mpz9 u1 ∧ (-(2 : ℤ) < Z.readers mpz12 u1 → Z.abs_value_of mpz12 u1 = Z.abs_value_of mpz9 u1 ∧ Z.alloc mpz12 u1 = Z.alloc mpz9 u1 ∧ Z.abs_size mpz12 u1 = Z.abs_size mpz9 u1 ∧ Z.sgn mpz12 u1 = Z.sgn mpz9 u1 ∧ Z.readers mpz12 u1 = Z.readers mpz9 u1 ∧ Z.zones mpz12 u1 = Z.zones mpz9 u1)) → Z.mpz_eq v1 w = (v1 = w) → (¬Z.mpz_eq v1 w → Z.mpz_unchanged v1 mpz12 mpz9) ∧ ((¬Z.mpz_eq v1 w → Z.readers mpz12 v1 = Z.readers mpz9 v1 ∧ (-(2 : ℤ) < Z.readers mpz12 v1 → Z.abs_value_of mpz12 v1 = Z.abs_value_of mpz9 v1 ∧ Z.alloc mpz12 v1 = Z.alloc mpz9 v1 ∧ Z.abs_size mpz12 v1 = Z.abs_size mpz9 v1 ∧ Z.sgn mpz12 v1 = Z.sgn mpz9 v1 ∧ Z.readers mpz12 v1 = Z.readers mpz9 v1 ∧ Z.zones mpz12 v1 = Z.zones mpz9 v1)) → Z.mpz_unchanged w mpz12 mpz11 ∧ (Z.readers mpz12 w = Z.readers mpz11 w ∧ (-(2 : ℤ) < Z.readers mpz12 w → Z.abs_value_of mpz12 w = Z.abs_value_of mpz11 w ∧ Z.alloc mpz12 w = Z.alloc mpz11 w ∧ Z.abs_size mpz12 w = Z.abs_size mpz11 w ∧ Z.sgn mpz12 w = Z.sgn mpz11 w ∧ Z.readers mpz12 w = Z.readers mpz11 w ∧ Z.zones mpz12 w = Z.zones mpz11 w) → (∀(o11 : Bool), (BitVec.toUInt (C.pelts wp'2 (C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o11 = true) ∧ (o11 = true → C.pelts wp'2 (C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o12 : BitVec 32), (if o11 = true then o12 = (1 : BitVec 32) else o12 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o12) ∧ (∀(o13 : BitVec 32), BitVec.toInt o13 = BitVec.toInt o7 - BitVec.toInt o12 → (BitVec.toInt sign_product < (0 : ℤ) → int'32_in_bounds (-BitVec.toInt o13)) ∧ (∀(o14 : BitVec 32), (if BitVec.toInt sign_product < (0 : ℤ) then BitVec.toInt o14 = -BitVec.toInt o13 else o14 = o13) → (C.offset wp'2 = (0 : ℤ) ∧ C.writable wp'2 = true ∧ C.min wp'2 = (0 : ℤ) ∧ C.max wp'2 = C.plength wp'2 ∧ C.plength wp'2 = Z.alloc mpz12 w ∧ (Z.readers mpz12 w = (0 : ℤ) ∨ Z.readers mpz12 w = -(1 : ℤ))) ∧ (∀(mpz13 : Z.mpz_memo), Z.alloc mpz13 = Z.alloc mpz12 ∧ Z.abs_size mpz13 = Z.abs_size mpz12 ∧ Z.sgn mpz13 = Z.sgn mpz12 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz13 mpz12) ∧ Z.abs_value_of mpz13 w = Lemmas.value wp'2 (Z.abs_size mpz13 w) ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ Z.zones mpz13 w = C.zone1 wp'2 → (Z.zones mpz13 w = C.zone1 wp'2 ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ C.offset wp'2 = (0 : ℤ) ∧ C.min wp'2 = (0 : ℤ) ∧ C.max wp'2 = C.plength wp'2 ∧ abs (BitVec.toInt o14) ≤ C.plength wp'2 ∧ C.plength wp'2 = Z.alloc mpz13 w ∧ (¬BitVec.toInt o14 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o14) - (1 : ℤ))) ≤ Lemmas.value wp'2 (abs (BitVec.toInt o14)))) ∧ (∀(mpz14 : Z.mpz_memo), Z.alloc mpz14 = Z.alloc mpz13 ∧ Z.readers mpz14 = Z.readers mpz13 ∧ Z.zones mpz14 = Z.zones mpz13 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz14 mpz13) ∧ (Z.sgn mpz14 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o14) ∧ (Z.sgn mpz14 w = -(1 : ℤ)) = (BitVec.toInt o14 < (0 : ℤ)) ∧ Z.abs_size mpz14 w = abs (BitVec.toInt o14) ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'2 (abs (BitVec.toInt o14)) → Z.mpz_eq w (Zutil.ptr memw) = (w = Zutil.ptr memw) → (¬Z.mpz_eq w (Zutil.ptr memw) → Z.mpz_unchanged (Zutil.ptr memw) mpz14 mpz12) ∧ ((¬Z.mpz_eq w (Zutil.ptr memw) → Z.readers mpz14 (Zutil.ptr memw) = Z.readers mpz12 (Zutil.ptr memw) ∧ (-(2 : ℤ) < Z.readers mpz14 (Zutil.ptr memw) → Z.abs_value_of mpz14 (Zutil.ptr memw) = Z.abs_value_of mpz12 (Zutil.ptr memw) ∧ Z.alloc mpz14 (Zutil.ptr memw) = Z.alloc mpz12 (Zutil.ptr memw) ∧ Z.abs_size mpz14 (Zutil.ptr memw) = Z.abs_size mpz12 (Zutil.ptr memw) ∧ Z.sgn mpz14 (Zutil.ptr memw) = Z.sgn mpz12 (Zutil.ptr memw) ∧ Z.readers mpz14 (Zutil.ptr memw) = Z.readers mpz12 (Zutil.ptr memw) ∧ Z.zones mpz14 (Zutil.ptr memw) = Z.zones mpz12 (Zutil.ptr memw))) → (Z.zones mpz14 w = C.zone1 wp'2 ∧ Z.readers mpz14 w = -(1 : ℤ) ∧ C.min wp'2 = (0 : ℤ) ∧ C.max wp'2 = C.plength wp'2 ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'2 (Z.abs_size mpz14 w)) ∧ (∀(mpz15 : Z.mpz_memo), Z.abs_value_of mpz15 = Z.abs_value_of mpz14 ∧ Z.alloc mpz15 = Z.alloc mpz14 ∧ Z.abs_size mpz15 = Z.abs_size mpz14 ∧ Z.sgn mpz15 = Z.sgn mpz14 ∧ Z.zones mpz15 = Z.zones mpz14 → Z.readers mpz15 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz15 y = Z.readers mpz14 y) → Z.mpz_eq u1 w = (u1 = w) → (¬Z.mpz_eq u1 w → Z.mpz_unchanged u1 mpz15 mpz12) ∧ ((¬Z.mpz_eq u1 w → Z.readers mpz15 u1 = Z.readers mpz12 u1 ∧ (-(2 : ℤ) < Z.readers mpz15 u1 → Z.abs_value_of mpz15 u1 = Z.abs_value_of mpz12 u1 ∧ Z.alloc mpz15 u1 = Z.alloc mpz12 u1 ∧ Z.abs_size mpz15 u1 = Z.abs_size mpz12 u1 ∧ Z.sgn mpz15 u1 = Z.sgn mpz12 u1 ∧ Z.readers mpz15 u1 = Z.readers mpz12 u1 ∧ Z.zones mpz15 u1 = Z.zones mpz12 u1)) → Z.mpz_eq v1 w = (v1 = w) → (¬Z.mpz_eq v1 w → Z.mpz_unchanged v1 mpz15 mpz12) ∧ ((¬Z.mpz_eq v1 w → Z.readers mpz15 v1 = Z.readers mpz12 v1 ∧ (-(2 : ℤ) < Z.readers mpz15 v1 → Z.abs_value_of mpz15 v1 = Z.abs_value_of mpz12 v1 ∧ Z.alloc mpz15 v1 = Z.alloc mpz12 v1 ∧ Z.abs_size mpz15 v1 = Z.abs_size mpz12 v1 ∧ Z.sgn mpz15 v1 = Z.sgn mpz12 v1 ∧ Z.readers mpz15 v1 = Z.readers mpz12 v1 ∧ Z.zones mpz15 v1 = Z.zones mpz12 v1)) → Z.mpz_eq u1 u1 → (∀(o15 : Bool), (if Z.mpz_eq u1 u1 then o15 = true else Z.mpz_eq u1 v1 = (u1 = v1) ∧ (if Z.mpz_eq u1 v1 then o15 = true else Z.mpz_eq u1 (Zutil.ptr memw) = (u1 = Zutil.ptr memw) ∧ (if Z.mpz_eq u1 (Zutil.ptr memw) then o15 = true else o15 = (if Z.mpz_eq u1 w then true else false) ∧ (o15 = true) = (u1 = w)))) → (¬o15 = true → Z.mpz_unchanged u1 mpz15 mpz) ∧ ((¬o15 = true → Z.readers mpz15 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz15 u1 → Z.abs_value_of mpz15 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz15 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz15 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz15 u1 = Z.sgn mpz u1 ∧ Z.readers mpz15 u1 = Z.readers mpz u1 ∧ Z.zones mpz15 u1 = Z.zones mpz u1)) → Z.mpz_eq v1 u1 = (v1 = u1) → (∀(o16 : Bool), (if Z.mpz_eq v1 u1 then o16 = true else Z.mpz_eq v1 v1 ∧ (if Z.mpz_eq v1 v1 then o16 = true else Z.mpz_eq v1 (Zutil.ptr memw) = (v1 = Zutil.ptr memw) ∧ (if Z.mpz_eq v1 (Zutil.ptr memw) then o16 = true else o16 = (if Z.mpz_eq v1 w then true else false) ∧ (o16 = true) = (v1 = w)))) → (¬o16 = true → Z.mpz_unchanged v1 mpz15 mpz) ∧ ((¬o16 = true → Z.readers mpz15 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz15 v1 → Z.abs_value_of mpz15 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz15 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz15 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz15 v1 = Z.sgn mpz v1 ∧ Z.readers mpz15 v1 = Z.readers mpz v1 ∧ Z.zones mpz15 v1 = Z.zones mpz v1)) → Z.mpz_unchanged w mpz15 mpz15 ∧ Z.value_of w mpz15 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz15 mpz) ∧ Z.readers mpz15 w = (0 : ℤ) ∧ Z.readers mpz15 u = (0 : ℤ) ∧ Z.readers mpz15 v = (0 : ℤ)))))))))))))))))))))) else ∀(o11 : Bool), (BitVec.toUInt (C.pelts wp'2 (C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o11 = true) ∧ (o11 = true → C.pelts wp'2 (C.offset wp'2 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o12 : BitVec 32), (if o11 = true then o12 = (1 : BitVec 32) else o12 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o12) ∧ (∀(o13 : BitVec 32), BitVec.toInt o13 = BitVec.toInt o7 - BitVec.toInt o12 → (BitVec.toInt sign_product < (0 : ℤ) → int'32_in_bounds (-BitVec.toInt o13)) ∧ (∀(o14 : BitVec 32), (if BitVec.toInt sign_product < (0 : ℤ) then BitVec.toInt o14 = -BitVec.toInt o13 else o14 = o13) → (C.offset wp'2 = (0 : ℤ) ∧ C.writable wp'2 = true ∧ C.min wp'2 = (0 : ℤ) ∧ C.max wp'2 = C.plength wp'2 ∧ C.plength wp'2 = Z.alloc mpz9 w ∧ (Z.readers mpz9 w = (0 : ℤ) ∨ Z.readers mpz9 w = -(1 : ℤ))) ∧ (∀(mpz10 : Z.mpz_memo), Z.alloc mpz10 = Z.alloc mpz9 ∧ Z.abs_size mpz10 = Z.abs_size mpz9 ∧ Z.sgn mpz10 = Z.sgn mpz9 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz10 mpz9) ∧ Z.abs_value_of mpz10 w = Lemmas.value wp'2 (Z.abs_size mpz10 w) ∧ Z.readers mpz10 w = -(1 : ℤ) ∧ Z.zones mpz10 w = C.zone1 wp'2 → (Z.zones mpz10 w = C.zone1 wp'2 ∧ Z.readers mpz10 w = -(1 : ℤ) ∧ C.offset wp'2 = (0 : ℤ) ∧ C.min wp'2 = (0 : ℤ) ∧ C.max wp'2 = C.plength wp'2 ∧ abs (BitVec.toInt o14) ≤ C.plength wp'2 ∧ C.plength wp'2 = Z.alloc mpz10 w ∧ (¬BitVec.toInt o14 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o14) - (1 : ℤ))) ≤ Lemmas.value wp'2 (abs (BitVec.toInt o14)))) ∧ (∀(mpz11 : Z.mpz_memo), Z.alloc mpz11 = Z.alloc mpz10 ∧ Z.readers mpz11 = Z.readers mpz10 ∧ Z.zones mpz11 = Z.zones mpz10 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz11 mpz10) ∧ (Z.sgn mpz11 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o14) ∧ (Z.sgn mpz11 w = -(1 : ℤ)) = (BitVec.toInt o14 < (0 : ℤ)) ∧ Z.abs_size mpz11 w = abs (BitVec.toInt o14) ∧ Z.abs_value_of mpz11 w = Lemmas.value wp'2 (abs (BitVec.toInt o14)) → Z.mpz_eq w (Zutil.ptr memw) = (w = Zutil.ptr memw) → (¬Z.mpz_eq w (Zutil.ptr memw) → Z.mpz_unchanged (Zutil.ptr memw) mpz11 mpz9) ∧ ((¬Z.mpz_eq w (Zutil.ptr memw) → Z.readers mpz11 (Zutil.ptr memw) = Z.readers mpz9 (Zutil.ptr memw) ∧ (-(2 : ℤ) < Z.readers mpz11 (Zutil.ptr memw) → Z.abs_value_of mpz11 (Zutil.ptr memw) = Z.abs_value_of mpz9 (Zutil.ptr memw) ∧ Z.alloc mpz11 (Zutil.ptr memw) = Z.alloc mpz9 (Zutil.ptr memw) ∧ Z.abs_size mpz11 (Zutil.ptr memw) = Z.abs_size mpz9 (Zutil.ptr memw) ∧ Z.sgn mpz11 (Zutil.ptr memw) = Z.sgn mpz9 (Zutil.ptr memw) ∧ Z.readers mpz11 (Zutil.ptr memw) = Z.readers mpz9 (Zutil.ptr memw) ∧ Z.zones mpz11 (Zutil.ptr memw) = Z.zones mpz9 (Zutil.ptr memw))) → (Z.zones mpz11 w = C.zone1 wp'2 ∧ Z.readers mpz11 w = -(1 : ℤ) ∧ C.min wp'2 = (0 : ℤ) ∧ C.max wp'2 = C.plength wp'2 ∧ Z.abs_value_of mpz11 w = Lemmas.value wp'2 (Z.abs_size mpz11 w)) ∧ (∀(mpz12 : Z.mpz_memo), Z.abs_value_of mpz12 = Z.abs_value_of mpz11 ∧ Z.alloc mpz12 = Z.alloc mpz11 ∧ Z.abs_size mpz12 = Z.abs_size mpz11 ∧ Z.sgn mpz12 = Z.sgn mpz11 ∧ Z.zones mpz12 = Z.zones mpz11 → Z.readers mpz12 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz12 y = Z.readers mpz11 y) → Z.mpz_eq u1 w = (u1 = w) → (¬Z.mpz_eq u1 w → Z.mpz_unchanged u1 mpz12 mpz9) ∧ ((¬Z.mpz_eq u1 w → Z.readers mpz12 u1 = Z.readers mpz9 u1 ∧ (-(2 : ℤ) < Z.readers mpz12 u1 → Z.abs_value_of mpz12 u1 = Z.abs_value_of mpz9 u1 ∧ Z.alloc mpz12 u1 = Z.alloc mpz9 u1 ∧ Z.abs_size mpz12 u1 = Z.abs_size mpz9 u1 ∧ Z.sgn mpz12 u1 = Z.sgn mpz9 u1 ∧ Z.readers mpz12 u1 = Z.readers mpz9 u1 ∧ Z.zones mpz12 u1 = Z.zones mpz9 u1)) → Z.mpz_eq v1 w = (v1 = w) → (¬Z.mpz_eq v1 w → Z.mpz_unchanged v1 mpz12 mpz9) ∧ ((¬Z.mpz_eq v1 w → Z.readers mpz12 v1 = Z.readers mpz9 v1 ∧ (-(2 : ℤ) < Z.readers mpz12 v1 → Z.abs_value_of mpz12 v1 = Z.abs_value_of mpz9 v1 ∧ Z.alloc mpz12 v1 = Z.alloc mpz9 v1 ∧ Z.abs_size mpz12 v1 = Z.abs_size mpz9 v1 ∧ Z.sgn mpz12 v1 = Z.sgn mpz9 v1 ∧ Z.readers mpz12 v1 = Z.readers mpz9 v1 ∧ Z.zones mpz12 v1 = Z.zones mpz9 v1)) → Z.mpz_eq u1 u1 → (∀(o15 : Bool), (if Z.mpz_eq u1 u1 then o15 = true else Z.mpz_eq u1 v1 = (u1 = v1) ∧ (if Z.mpz_eq u1 v1 then o15 = true else Z.mpz_eq u1 (Zutil.ptr memw) = (u1 = Zutil.ptr memw) ∧ (if Z.mpz_eq u1 (Zutil.ptr memw) then o15 = true else o15 = (if Z.mpz_eq u1 w then true else false) ∧ (o15 = true) = (u1 = w)))) → (¬o15 = true → Z.mpz_unchanged u1 mpz12 mpz) ∧ ((¬o15 = true → Z.readers mpz12 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz12 u1 → Z.abs_value_of mpz12 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz12 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz12 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz12 u1 = Z.sgn mpz u1 ∧ Z.readers mpz12 u1 = Z.readers mpz u1 ∧ Z.zones mpz12 u1 = Z.zones mpz u1)) → Z.mpz_eq v1 u1 = (v1 = u1) → (∀(o16 : Bool), (if Z.mpz_eq v1 u1 then o16 = true else Z.mpz_eq v1 v1 ∧ (if Z.mpz_eq v1 v1 then o16 = true else Z.mpz_eq v1 (Zutil.ptr memw) = (v1 = Zutil.ptr memw) ∧ (if Z.mpz_eq v1 (Zutil.ptr memw) then o16 = true else o16 = (if Z.mpz_eq v1 w then true else false) ∧ (o16 = true) = (v1 = w)))) → (¬o16 = true → Z.mpz_unchanged v1 mpz12 mpz) ∧ ((¬o16 = true → Z.readers mpz12 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz12 v1 → Z.abs_value_of mpz12 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz12 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz12 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz12 v1 = Z.sgn mpz v1 ∧ Z.readers mpz12 v1 = Z.readers mpz v1 ∧ Z.zones mpz12 v1 = Z.zones mpz v1)) → Z.mpz_unchanged w mpz12 mpz12 ∧ Z.value_of w mpz12 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz12 mpz) ∧ Z.readers mpz12 w = (0 : ℤ) ∧ Z.readers mpz12 u = (0 : ℤ) ∧ Z.readers mpz12 v = (0 : ℤ))))))))))))))))))))))))))))))))))))))) else if Z.mpz_eq u1 w then (0 : ℤ) ≤ Z.readers mpz w ∧ (∀(mpz1 : Z.mpz_memo), Z.abs_value_of mpz1 = Z.abs_value_of mpz ∧ Z.alloc mpz1 = Z.alloc mpz ∧ Z.abs_size mpz1 = Z.abs_size mpz ∧ Z.sgn mpz1 = Z.sgn mpz ∧ Z.zones mpz1 = Z.zones mpz → (∀(wp : C.ptr (BitVec 64)), Z.readers mpz1 w = Z.readers mpz w + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz1 y = Z.readers mpz y) ∧ Lemmas.value wp (Z.abs_size mpz1 w) = Z.abs_value_of mpz1 w ∧ C.plength wp = Z.alloc mpz1 w ∧ C.offset wp = (0 : ℤ) ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp ∧ C.zone1 wp = Z.zones mpz1 w → (0 : ℤ) ≤ BitVec.toInt usize ∧ (∀(o9 : BitVec 32), BitVec.toUInt o9 = BitVec.toInt usize → (0 : ℤ) ≤ BitVec.toUInt o9 ∧ (∀(up : C.ptr (BitVec 64)), C.plength up = BitVec.toUInt o9 ∧ C.offset up = (0 : ℤ) ∧ C.min up = (0 : ℤ) ∧ C.max up = BitVec.toUInt o9 ∧ C.writable up = true → (∀(mpz2 : Z.mpz_memo) (mu : Zutil.mpz_mem), Zutil.ok mu = true ∧ Z.readers mpz2 (Zutil.ptr mu) = (0 : ℤ) ∧ Z.alloc mpz2 (Zutil.ptr mu) = (0 : ℤ) ∧ Z.abs_size mpz2 (Zutil.ptr mu) = (0 : ℤ) ∧ Z.readers mpz1 (Zutil.ptr mu) = -(2 : ℤ) ∧ (∀(x : Z.mpz_ptr), ¬x = Zutil.ptr mu → Z.mpz_unchanged x mpz2 mpz1) → (Z.abs_size mpz2 (Zutil.ptr mu) ≤ BitVec.toInt usize ∧ -(1 : ℤ) ≤ Z.readers mpz2 (Zutil.ptr mu) ∧ Z.readers mpz2 (Zutil.ptr mu) ≤ (0 : ℤ)) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.readers mpz3 = Z.readers mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.mpz_unchanged y mpz3 mpz2) ∧ Z.alloc mpz3 (Zutil.ptr mu) = BitVec.toInt usize → (C.valid wp (BitVec.toInt usize) ∧ C.valid up (BitVec.toInt usize) ∧ C.writable up = true) ∧ (∀(up1 : C.ptr (BitVec 64)), List.length (C.data up1) = List.length (C.data up) ∧ C.offset up1 = C.offset up ∧ C.min up1 = C.min up ∧ C.max up1 = C.max up ∧ C.writable up1 = C.writable up ∧ C.zone1 up1 = C.zone1 up → Lemmas.map_eq_sub_shift (C.pelts up1) (C.pelts wp) (C.offset up1) (C.offset wp) (BitVec.toInt usize) ∧ (∀(j : ℤ), j < C.offset up1 ∨ C.offset up1 + BitVec.toInt usize ≤ j → C.pelts up1 j = C.pelts up j) → (C.offset up1 = (0 : ℤ) ∧ C.writable up1 = true ∧ C.min up1 = (0 : ℤ) ∧ C.max up1 = C.plength up1 ∧ C.plength up1 = Z.alloc mpz3 (Zutil.ptr mu) ∧ (Z.readers mpz3 (Zutil.ptr mu) = (0 : ℤ) ∨ Z.readers mpz3 (Zutil.ptr mu) = -(1 : ℤ))) ∧ (∀(mpz4 : Z.mpz_memo), Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.abs_size mpz4 = Z.abs_size mpz3 ∧ Z.sgn mpz4 = Z.sgn mpz3 → (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.mpz_unchanged y mpz4 mpz3) ∧ Z.abs_value_of mpz4 (Zutil.ptr mu) = Lemmas.value up1 (Z.abs_size mpz4 (Zutil.ptr mu)) ∧ Z.readers mpz4 (Zutil.ptr mu) = -(1 : ℤ) ∧ Z.zones mpz4 (Zutil.ptr mu) = C.zone1 up1 → (Z.zones mpz4 (Zutil.ptr mu) = C.zone1 up1 ∧ Z.readers mpz4 (Zutil.ptr mu) = -(1 : ℤ) ∧ C.offset up1 = (0 : ℤ) ∧ C.min up1 = (0 : ℤ) ∧ C.max up1 = C.plength up1 ∧ abs (BitVec.toInt usize) ≤ C.plength up1 ∧ C.plength up1 = Z.alloc mpz4 (Zutil.ptr mu) ∧ (¬BitVec.toInt usize = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt usize) - (1 : ℤ))) ≤ Lemmas.value up1 (abs (BitVec.toInt usize)))) ∧ (∀(mpz5 : Z.mpz_memo), Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.readers mpz5 = Z.readers mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.mpz_unchanged y mpz5 mpz4) ∧ (Z.sgn mpz5 (Zutil.ptr mu) = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt usize) ∧ (Z.sgn mpz5 (Zutil.ptr mu) = -(1 : ℤ)) = (BitVec.toInt usize < (0 : ℤ)) ∧ Z.abs_size mpz5 (Zutil.ptr mu) = abs (BitVec.toInt usize) ∧ Z.abs_value_of mpz5 (Zutil.ptr mu) = Lemmas.value up1 (abs (BitVec.toInt usize)) → (Z.zones mpz5 (Zutil.ptr mu) = C.zone1 up1 ∧ Z.readers mpz5 (Zutil.ptr mu) = -(1 : ℤ) ∧ C.min up1 = (0 : ℤ) ∧ C.max up1 = C.plength up1 ∧ Z.abs_value_of mpz5 (Zutil.ptr mu) = Lemmas.value up1 (Z.abs_size mpz5 (Zutil.ptr mu))) ∧ (∀(mpz6 : Z.mpz_memo), Z.abs_value_of mpz6 = Z.abs_value_of mpz5 ∧ Z.alloc mpz6 = Z.alloc mpz5 ∧ Z.abs_size mpz6 = Z.abs_size mpz5 ∧ Z.sgn mpz6 = Z.sgn mpz5 ∧ Z.zones mpz6 = Z.zones mpz5 → Z.readers mpz6 (Zutil.ptr mu) = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.readers mpz6 y = Z.readers mpz5 y) → (if Z.mpz_eq v1 w then Z.mpz_unchanged u1 mpz6 mpz1 ∧ (Z.readers mpz6 u1 = Z.readers mpz1 u1 ∧ (-(2 : ℤ) < Z.readers mpz6 u1 → Z.abs_value_of mpz6 u1 = Z.abs_value_of mpz1 u1 ∧ Z.alloc mpz6 u1 = Z.alloc mpz1 u1 ∧ Z.abs_size mpz6 u1 = Z.abs_size mpz1 u1 ∧ Z.sgn mpz6 u1 = Z.sgn mpz1 u1 ∧ Z.readers mpz6 u1 = Z.readers mpz1 u1 ∧ Z.zones mpz6 u1 = Z.zones mpz1 u1) → Z.mpz_unchanged w mpz6 mpz1 ∧ (Z.readers mpz6 w = Z.readers mpz1 w ∧ (-(2 : ℤ) < Z.readers mpz6 w → Z.abs_value_of mpz6 w = Z.abs_value_of mpz1 w ∧ Z.alloc mpz6 w = Z.alloc mpz1 w ∧ Z.abs_size mpz6 w = Z.abs_size mpz1 w ∧ Z.sgn mpz6 w = Z.sgn mpz1 w ∧ Z.readers mpz6 w = Z.readers mpz1 w ∧ Z.zones mpz6 w = Z.zones mpz1 w) → (Z.zones mpz6 w = C.zone1 wp ∧ (1 : ℤ) ≤ Z.readers mpz6 w ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp) ∧ (∀(mpz7 : Z.mpz_memo), Z.abs_value_of mpz7 = Z.abs_value_of mpz6 ∧ Z.alloc mpz7 = Z.alloc mpz6 ∧ Z.abs_size mpz7 = Z.abs_size mpz6 ∧ Z.sgn mpz7 = Z.sgn mpz6 ∧ Z.zones mpz7 = Z.zones mpz6 → Z.readers mpz7 w = Z.readers mpz6 w - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz7 y = Z.readers mpz6 y) → (0 : ℤ) ≤ Z.readers mpz7 (Zutil.ptr mu) ∧ (∀(mpz8 : Z.mpz_memo), Z.abs_value_of mpz8 = Z.abs_value_of mpz7 ∧ Z.alloc mpz8 = Z.alloc mpz7 ∧ Z.abs_size mpz8 = Z.abs_size mpz7 ∧ Z.sgn mpz8 = Z.sgn mpz7 ∧ Z.zones mpz8 = Z.zones mpz7 → (∀(up' : C.ptr (BitVec 64)), Z.readers mpz8 (Zutil.ptr mu) = Z.readers mpz7 (Zutil.ptr mu) + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬Zutil.ptr mu = y → Z.readers mpz8 y = Z.readers mpz7 y) ∧ Lemmas.value up' (Z.abs_size mpz8 (Zutil.ptr mu)) = Z.abs_value_of mpz8 (Zutil.ptr mu) ∧ C.plength up' = Z.alloc mpz8 (Zutil.ptr mu) ∧ C.offset up' = (0 : ℤ) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up' ∧ C.zone1 up' = Z.zones mpz8 (Zutil.ptr mu) → (0 : ℤ) ≤ Z.readers mpz8 (Zutil.ptr mu) ∧ (∀(mpz9 : Z.mpz_memo), Z.abs_value_of mpz9 = Z.abs_value_of mpz8 ∧ Z.alloc mpz9 = Z.alloc mpz8 ∧ Z.abs_size mpz9 = Z.abs_size mpz8 ∧ Z.sgn mpz9 = Z.sgn mpz8 ∧ Z.zones mpz9 = Z.zones mpz8 → (∀(vp' : C.ptr (BitVec 64)), Z.readers mpz9 (Zutil.ptr mu) = Z.readers mpz8 (Zutil.ptr mu) + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬Zutil.ptr mu = y → Z.readers mpz9 y = Z.readers mpz8 y) ∧ Lemmas.value vp' (Z.abs_size mpz9 (Zutil.ptr mu)) = Z.abs_value_of mpz9 (Zutil.ptr mu) ∧ C.plength vp' = Z.alloc mpz9 (Zutil.ptr mu) ∧ C.offset vp' = (0 : ℤ) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp' ∧ C.zone1 vp' = Z.zones mpz9 (Zutil.ptr mu) → Z.mpz_unchanged w mpz9 mpz7 ∧ (Z.readers mpz9 w = Z.readers mpz7 w ∧ (-(2 : ℤ) < Z.readers mpz9 w → Z.abs_value_of mpz9 w = Z.abs_value_of mpz7 w ∧ Z.alloc mpz9 w = Z.alloc mpz7 w ∧ Z.abs_size mpz9 w = Z.abs_size mpz7 w ∧ Z.sgn mpz9 w = Z.sgn mpz7 w ∧ Z.readers mpz9 w = Z.readers mpz7 w ∧ Z.zones mpz9 w = Z.zones mpz7 w) → Z.readers mpz9 w = (0 : ℤ) ∧ (∀(mpz10 : Z.mpz_memo), Z.abs_value_of mpz10 = Z.abs_value_of mpz9 ∧ Z.alloc mpz10 = Z.alloc mpz9 ∧ Z.abs_size mpz10 = Z.abs_size mpz9 ∧ Z.sgn mpz10 = Z.sgn mpz9 ∧ Z.zones mpz10 = Z.zones mpz9 → (∀(wp' : C.ptr (BitVec 64)), Z.readers mpz10 w = -(1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz10 y = Z.readers mpz9 y) ∧ Lemmas.value wp' (Z.abs_size mpz10 w) = Z.abs_value_of mpz10 w ∧ C.plength wp' = Z.alloc mpz10 w ∧ C.offset wp' = (0 : ℤ) ∧ C.min wp' = (0 : ℤ) ∧ C.max wp' = C.plength wp' ∧ C.writable wp' = true ∧ C.zone1 wp' = Z.zones mpz10 w → Z.mpz_unchanged (Zutil.ptr mu) mpz10 mpz9 ∧ (Z.readers mpz10 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz10 (Zutil.ptr mu) → Z.abs_value_of mpz10 (Zutil.ptr mu) = Z.abs_value_of mpz9 (Zutil.ptr mu) ∧ Z.alloc mpz10 (Zutil.ptr mu) = Z.alloc mpz9 (Zutil.ptr mu) ∧ Z.abs_size mpz10 (Zutil.ptr mu) = Z.abs_size mpz9 (Zutil.ptr mu) ∧ Z.sgn mpz10 (Zutil.ptr mu) = Z.sgn mpz9 (Zutil.ptr mu) ∧ Z.readers mpz10 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ Z.zones mpz10 (Zutil.ptr mu) = Z.zones mpz9 (Zutil.ptr mu)) → Z.mpz_unchanged (Zutil.ptr mu) mpz10 mpz9 ∧ (Z.readers mpz10 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz10 (Zutil.ptr mu) → Z.abs_value_of mpz10 (Zutil.ptr mu) = Z.abs_value_of mpz9 (Zutil.ptr mu) ∧ Z.alloc mpz10 (Zutil.ptr mu) = Z.alloc mpz9 (Zutil.ptr mu) ∧ Z.abs_size mpz10 (Zutil.ptr mu) = Z.abs_size mpz9 (Zutil.ptr mu) ∧ Z.sgn mpz10 (Zutil.ptr mu) = Z.sgn mpz9 (Zutil.ptr mu) ∧ Z.readers mpz10 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ Z.zones mpz10 (Zutil.ptr mu) = Z.zones mpz9 (Zutil.ptr mu)) → (C.valid up' (BitVec.toInt usize) ∧ C.valid vp' (BitVec.toInt vsize) ∧ C.valid wp' (BitVec.toInt usize + BitVec.toInt vsize) ∧ C.writable wp' = true ∧ ((0 : ℤ) < BitVec.toInt vsize ∧ BitVec.toInt vsize ≤ BitVec.toInt usize) ∧ (8 : ℤ) * BitVec.toInt usize < (2147483647 : ℤ) ∧ BitVec.toInt usize ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(wp'1 : C.ptr (BitVec 64)), C.offset wp'1 = C.offset wp' ∧ C.writable wp'1 = C.writable wp' ∧ C.zone1 wp'1 = C.zone1 wp' → C.min wp'1 = C.min wp' ∧ C.max wp'1 = C.max wp' ∧ C.plength wp'1 = C.plength wp' ∧ Lemmas.value wp'1 (BitVec.toInt usize + BitVec.toInt vsize) = Lemmas.value up' (BitVec.toInt usize) * Lemmas.value vp' (BitVec.toInt vsize) ∧ (∀(j : ℤ), C.min wp'1 ≤ j ∧ j < C.offset wp'1 ∨ C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize ≤ j ∧ j < C.max wp'1 → C.pelts wp'1 j = C.pelts wp' j) → (∀(o10 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o10 = true) ∧ (o10 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o11 : BitVec 32), (if o10 = true then o11 = (1 : BitVec 32) else o11 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o11) ∧ (∀(wsize' : BitVec 32), BitVec.toInt wsize' = BitVec.toInt o7 - BitVec.toInt o11 → (Z.zones mpz10 (Zutil.ptr mu) = C.zone1 up' ∧ (1 : ℤ) ≤ Z.readers mpz10 (Zutil.ptr mu) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up') ∧ (∀(mpz11 : Z.mpz_memo), Z.abs_value_of mpz11 = Z.abs_value_of mpz10 ∧ Z.alloc mpz11 = Z.alloc mpz10 ∧ Z.abs_size mpz11 = Z.abs_size mpz10 ∧ Z.sgn mpz11 = Z.sgn mpz10 ∧ Z.zones mpz11 = Z.zones mpz10 → Z.readers mpz11 (Zutil.ptr mu) = Z.readers mpz10 (Zutil.ptr mu) - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.readers mpz11 y = Z.readers mpz10 y) → Z.mpz_eq (Zutil.ptr mu) (Zutil.ptr mu) = True → (¬Z.mpz_eq (Zutil.ptr mu) (Zutil.ptr mu) → Z.mpz_unchanged (Zutil.ptr mu) mpz11 mpz9) ∧ ((¬Z.mpz_eq (Zutil.ptr mu) (Zutil.ptr mu) → Z.readers mpz11 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz11 (Zutil.ptr mu) → Z.abs_value_of mpz11 (Zutil.ptr mu) = Z.abs_value_of mpz9 (Zutil.ptr mu) ∧ Z.alloc mpz11 (Zutil.ptr mu) = Z.alloc mpz9 (Zutil.ptr mu) ∧ Z.abs_size mpz11 (Zutil.ptr mu) = Z.abs_size mpz9 (Zutil.ptr mu) ∧ Z.sgn mpz11 (Zutil.ptr mu) = Z.sgn mpz9 (Zutil.ptr mu) ∧ Z.readers mpz11 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ Z.zones mpz11 (Zutil.ptr mu) = Z.zones mpz9 (Zutil.ptr mu))) → (Z.zones mpz11 (Zutil.ptr mu) = C.zone1 vp' ∧ (1 : ℤ) ≤ Z.readers mpz11 (Zutil.ptr mu) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp') ∧ (∀(mpz12 : Z.mpz_memo), Z.abs_value_of mpz12 = Z.abs_value_of mpz11 ∧ Z.alloc mpz12 = Z.alloc mpz11 ∧ Z.abs_size mpz12 = Z.abs_size mpz11 ∧ Z.sgn mpz12 = Z.sgn mpz11 ∧ Z.zones mpz12 = Z.zones mpz11 → Z.readers mpz12 (Zutil.ptr mu) = Z.readers mpz11 (Zutil.ptr mu) - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.readers mpz12 y = Z.readers mpz11 y) → Z.mpz_unchanged w mpz12 mpz10 ∧ (Z.readers mpz12 w = Z.readers mpz10 w ∧ (-(2 : ℤ) < Z.readers mpz12 w → Z.abs_value_of mpz12 w = Z.abs_value_of mpz10 w ∧ Z.alloc mpz12 w = Z.alloc mpz10 w ∧ Z.abs_size mpz12 w = Z.abs_size mpz10 w ∧ Z.sgn mpz12 w = Z.sgn mpz10 w ∧ Z.readers mpz12 w = Z.readers mpz10 w ∧ Z.zones mpz12 w = Z.zones mpz10 w) → (∀(o12 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o12 = true) ∧ (o12 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o13 : BitVec 32), (if o12 = true then o13 = (1 : BitVec 32) else o13 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o13) ∧ (∀(o14 : BitVec 32), BitVec.toInt o14 = BitVec.toInt o7 - BitVec.toInt o13 → (BitVec.toInt sign_product < (0 : ℤ) → int'32_in_bounds (-BitVec.toInt o14)) ∧ (∀(o15 : BitVec 32), (if BitVec.toInt sign_product < (0 : ℤ) then BitVec.toInt o15 = -BitVec.toInt o14 else o15 = o14) → (C.offset wp'1 = (0 : ℤ) ∧ C.writable wp'1 = true ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz12 w ∧ (Z.readers mpz12 w = (0 : ℤ) ∨ Z.readers mpz12 w = -(1 : ℤ))) ∧ (∀(mpz13 : Z.mpz_memo), Z.alloc mpz13 = Z.alloc mpz12 ∧ Z.abs_size mpz13 = Z.abs_size mpz12 ∧ Z.sgn mpz13 = Z.sgn mpz12 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz13 mpz12) ∧ Z.abs_value_of mpz13 w = Lemmas.value wp'1 (Z.abs_size mpz13 w) ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ Z.zones mpz13 w = C.zone1 wp'1 → (Z.zones mpz13 w = C.zone1 wp'1 ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ C.offset wp'1 = (0 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ abs (BitVec.toInt o15) ≤ C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz13 w ∧ (¬BitVec.toInt o15 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o15) - (1 : ℤ))) ≤ Lemmas.value wp'1 (abs (BitVec.toInt o15)))) ∧ (∀(mpz14 : Z.mpz_memo), Z.alloc mpz14 = Z.alloc mpz13 ∧ Z.readers mpz14 = Z.readers mpz13 ∧ Z.zones mpz14 = Z.zones mpz13 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz14 mpz13) ∧ (Z.sgn mpz14 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o15) ∧ (Z.sgn mpz14 w = -(1 : ℤ)) = (BitVec.toInt o15 < (0 : ℤ)) ∧ Z.abs_size mpz14 w = abs (BitVec.toInt o15) ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'1 (abs (BitVec.toInt o15)) → Z.mpz_eq w w → (¬Z.mpz_eq w w → Z.mpz_unchanged w mpz14 mpz12) ∧ ((¬Z.mpz_eq w w → Z.readers mpz14 w = Z.readers mpz12 w ∧ (-(2 : ℤ) < Z.readers mpz14 w → Z.abs_value_of mpz14 w = Z.abs_value_of mpz12 w ∧ Z.alloc mpz14 w = Z.alloc mpz12 w ∧ Z.abs_size mpz14 w = Z.abs_size mpz12 w ∧ Z.sgn mpz14 w = Z.sgn mpz12 w ∧ Z.readers mpz14 w = Z.readers mpz12 w ∧ Z.zones mpz14 w = Z.zones mpz12 w)) → (Z.zones mpz14 w = C.zone1 wp'1 ∧ Z.readers mpz14 w = -(1 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'1 (Z.abs_size mpz14 w)) ∧ (∀(mpz15 : Z.mpz_memo), Z.abs_value_of mpz15 = Z.abs_value_of mpz14 ∧ Z.alloc mpz15 = Z.alloc mpz14 ∧ Z.abs_size mpz15 = Z.abs_size mpz14 ∧ Z.sgn mpz15 = Z.sgn mpz14 ∧ Z.zones mpz15 = Z.zones mpz14 → Z.readers mpz15 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz15 y = Z.readers mpz14 y) → Z.mpz_eq (Zutil.ptr mu) w = (Zutil.ptr mu = w) → (¬Z.mpz_eq (Zutil.ptr mu) w → Z.mpz_unchanged (Zutil.ptr mu) mpz15 mpz12) ∧ ((¬Z.mpz_eq (Zutil.ptr mu) w → Z.readers mpz15 (Zutil.ptr mu) = Z.readers mpz12 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz15 (Zutil.ptr mu) → Z.abs_value_of mpz15 (Zutil.ptr mu) = Z.abs_value_of mpz12 (Zutil.ptr mu) ∧ Z.alloc mpz15 (Zutil.ptr mu) = Z.alloc mpz12 (Zutil.ptr mu) ∧ Z.abs_size mpz15 (Zutil.ptr mu) = Z.abs_size mpz12 (Zutil.ptr mu) ∧ Z.sgn mpz15 (Zutil.ptr mu) = Z.sgn mpz12 (Zutil.ptr mu) ∧ Z.readers mpz15 (Zutil.ptr mu) = Z.readers mpz12 (Zutil.ptr mu) ∧ Z.zones mpz15 (Zutil.ptr mu) = Z.zones mpz12 (Zutil.ptr mu))) → Z.mpz_eq (Zutil.ptr mu) w = (Zutil.ptr mu = w) → (¬Z.mpz_eq (Zutil.ptr mu) w → Z.mpz_unchanged (Zutil.ptr mu) mpz15 mpz12) ∧ ((¬Z.mpz_eq (Zutil.ptr mu) w → Z.readers mpz15 (Zutil.ptr mu) = Z.readers mpz12 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz15 (Zutil.ptr mu) → Z.abs_value_of mpz15 (Zutil.ptr mu) = Z.abs_value_of mpz12 (Zutil.ptr mu) ∧ Z.alloc mpz15 (Zutil.ptr mu) = Z.alloc mpz12 (Zutil.ptr mu) ∧ Z.abs_size mpz15 (Zutil.ptr mu) = Z.abs_size mpz12 (Zutil.ptr mu) ∧ Z.sgn mpz15 (Zutil.ptr mu) = Z.sgn mpz12 (Zutil.ptr mu) ∧ Z.readers mpz15 (Zutil.ptr mu) = Z.readers mpz12 (Zutil.ptr mu) ∧ Z.zones mpz15 (Zutil.ptr mu) = Z.zones mpz12 (Zutil.ptr mu))) → Z.mpz_eq u1 (Zutil.ptr mu) = (u1 = Zutil.ptr mu) → (∀(o16 : Bool), (if Z.mpz_eq u1 (Zutil.ptr mu) then o16 = true else Z.mpz_eq u1 (Zutil.ptr mu) = (u1 = Zutil.ptr mu) ∧ (if Z.mpz_eq u1 (Zutil.ptr mu) then o16 = true else Z.mpz_eq u1 w = (u1 = w) ∧ (if Z.mpz_eq u1 w then o16 = true else o16 = (if Z.mpz_eq u1 w then true else false) ∧ (o16 = true) = (u1 = w)))) → (¬o16 = true → Z.mpz_unchanged u1 mpz15 mpz) ∧ ((¬o16 = true → Z.readers mpz15 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz15 u1 → Z.abs_value_of mpz15 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz15 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz15 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz15 u1 = Z.sgn mpz u1 ∧ Z.readers mpz15 u1 = Z.readers mpz u1 ∧ Z.zones mpz15 u1 = Z.zones mpz u1)) → Z.mpz_eq v1 (Zutil.ptr mu) = (v1 = Zutil.ptr mu) → (∀(o17 : Bool), (if Z.mpz_eq v1 (Zutil.ptr mu) then o17 = true else Z.mpz_eq v1 (Zutil.ptr mu) = (v1 = Zutil.ptr mu) ∧ (if Z.mpz_eq v1 (Zutil.ptr mu) then o17 = true else Z.mpz_eq v1 w = (v1 = w) ∧ (if Z.mpz_eq v1 w then o17 = true else o17 = (if Z.mpz_eq v1 w then true else false) ∧ (o17 = true) = (v1 = w)))) → (¬o17 = true → Z.mpz_unchanged v1 mpz15 mpz) ∧ ((¬o17 = true → Z.readers mpz15 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz15 v1 → Z.abs_value_of mpz15 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz15 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz15 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz15 v1 = Z.sgn mpz v1 ∧ Z.readers mpz15 v1 = Z.readers mpz v1 ∧ Z.zones mpz15 v1 = Z.zones mpz v1)) → (if True then (Zutil.ok mu = true ∧ -(1 : ℤ) ≤ Z.readers mpz15 (Zutil.ptr mu) ∧ Z.readers mpz15 (Zutil.ptr mu) ≤ (0 : ℤ)) ∧ (∀(mpz16 : Z.mpz_memo), Z.readers mpz16 (Zutil.ptr mu) = -(2 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.mpz_unchanged y mpz16 mpz15) → Z.mpz_unchanged w mpz16 mpz15 ∧ (Z.readers mpz16 w = Z.readers mpz15 w ∧ (-(2 : ℤ) < Z.readers mpz16 w → Z.abs_value_of mpz16 w = Z.abs_value_of mpz15 w ∧ Z.alloc mpz16 w = Z.alloc mpz15 w ∧ Z.abs_size mpz16 w = Z.abs_size mpz15 w ∧ Z.sgn mpz16 w = Z.sgn mpz15 w ∧ Z.readers mpz16 w = Z.readers mpz15 w ∧ Z.zones mpz16 w = Z.zones mpz15 w) → Z.value_of w mpz16 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz16 mpz) ∧ Z.readers mpz16 w = (0 : ℤ) ∧ Z.readers mpz16 u = (0 : ℤ) ∧ Z.readers mpz16 v = (0 : ℤ))) else Z.mpz_unchanged w mpz15 mpz15 ∧ Z.value_of w mpz15 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz15 mpz) ∧ Z.readers mpz15 w = (0 : ℤ) ∧ Z.readers mpz15 u = (0 : ℤ) ∧ Z.readers mpz15 v = (0 : ℤ)))))))))))))))))))))))))))))))))))) else Z.mpz_unchanged v1 mpz6 mpz1 ∧ (Z.readers mpz6 v1 = Z.readers mpz1 v1 ∧ (-(2 : ℤ) < Z.readers mpz6 v1 → Z.abs_value_of mpz6 v1 = Z.abs_value_of mpz1 v1 ∧ Z.alloc mpz6 v1 = Z.alloc mpz1 v1 ∧ Z.abs_size mpz6 v1 = Z.abs_size mpz1 v1 ∧ Z.sgn mpz6 v1 = Z.sgn mpz1 v1 ∧ Z.readers mpz6 v1 = Z.readers mpz1 v1 ∧ Z.zones mpz6 v1 = Z.zones mpz1 v1) → Z.mpz_unchanged u1 mpz6 mpz1 ∧ (Z.readers mpz6 u1 = Z.readers mpz1 u1 ∧ (-(2 : ℤ) < Z.readers mpz6 u1 → Z.abs_value_of mpz6 u1 = Z.abs_value_of mpz1 u1 ∧ Z.alloc mpz6 u1 = Z.alloc mpz1 u1 ∧ Z.abs_size mpz6 u1 = Z.abs_size mpz1 u1 ∧ Z.sgn mpz6 u1 = Z.sgn mpz1 u1 ∧ Z.readers mpz6 u1 = Z.readers mpz1 u1 ∧ Z.zones mpz6 u1 = Z.zones mpz1 u1) → Z.mpz_unchanged w mpz6 mpz1 ∧ (Z.readers mpz6 w = Z.readers mpz1 w ∧ (-(2 : ℤ) < Z.readers mpz6 w → Z.abs_value_of mpz6 w = Z.abs_value_of mpz1 w ∧ Z.alloc mpz6 w = Z.alloc mpz1 w ∧ Z.abs_size mpz6 w = Z.abs_size mpz1 w ∧ Z.sgn mpz6 w = Z.sgn mpz1 w ∧ Z.readers mpz6 w = Z.readers mpz1 w ∧ Z.zones mpz6 w = Z.zones mpz1 w) → (Z.zones mpz6 w = C.zone1 wp ∧ (1 : ℤ) ≤ Z.readers mpz6 w ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp) ∧ (∀(mpz7 : Z.mpz_memo), Z.abs_value_of mpz7 = Z.abs_value_of mpz6 ∧ Z.alloc mpz7 = Z.alloc mpz6 ∧ Z.abs_size mpz7 = Z.abs_size mpz6 ∧ Z.sgn mpz7 = Z.sgn mpz6 ∧ Z.zones mpz7 = Z.zones mpz6 → Z.readers mpz7 w = Z.readers mpz6 w - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz7 y = Z.readers mpz6 y) → (0 : ℤ) ≤ Z.readers mpz7 (Zutil.ptr mu) ∧ (∀(mpz8 : Z.mpz_memo), Z.abs_value_of mpz8 = Z.abs_value_of mpz7 ∧ Z.alloc mpz8 = Z.alloc mpz7 ∧ Z.abs_size mpz8 = Z.abs_size mpz7 ∧ Z.sgn mpz8 = Z.sgn mpz7 ∧ Z.zones mpz8 = Z.zones mpz7 → (∀(up' : C.ptr (BitVec 64)), Z.readers mpz8 (Zutil.ptr mu) = Z.readers mpz7 (Zutil.ptr mu) + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬Zutil.ptr mu = y → Z.readers mpz8 y = Z.readers mpz7 y) ∧ Lemmas.value up' (Z.abs_size mpz8 (Zutil.ptr mu)) = Z.abs_value_of mpz8 (Zutil.ptr mu) ∧ C.plength up' = Z.alloc mpz8 (Zutil.ptr mu) ∧ C.offset up' = (0 : ℤ) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up' ∧ C.zone1 up' = Z.zones mpz8 (Zutil.ptr mu) → (0 : ℤ) ≤ Z.readers mpz8 v1 ∧ (∀(mpz9 : Z.mpz_memo), Z.abs_value_of mpz9 = Z.abs_value_of mpz8 ∧ Z.alloc mpz9 = Z.alloc mpz8 ∧ Z.abs_size mpz9 = Z.abs_size mpz8 ∧ Z.sgn mpz9 = Z.sgn mpz8 ∧ Z.zones mpz9 = Z.zones mpz8 → (∀(vp' : C.ptr (BitVec 64)), Z.readers mpz9 v1 = Z.readers mpz8 v1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬v1 = y → Z.readers mpz9 y = Z.readers mpz8 y) ∧ Lemmas.value vp' (Z.abs_size mpz9 v1) = Z.abs_value_of mpz9 v1 ∧ C.plength vp' = Z.alloc mpz9 v1 ∧ C.offset vp' = (0 : ℤ) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp' ∧ C.zone1 vp' = Z.zones mpz9 v1 → Z.mpz_unchanged w mpz9 mpz7 ∧ (Z.readers mpz9 w = Z.readers mpz7 w ∧ (-(2 : ℤ) < Z.readers mpz9 w → Z.abs_value_of mpz9 w = Z.abs_value_of mpz7 w ∧ Z.alloc mpz9 w = Z.alloc mpz7 w ∧ Z.abs_size mpz9 w = Z.abs_size mpz7 w ∧ Z.sgn mpz9 w = Z.sgn mpz7 w ∧ Z.readers mpz9 w = Z.readers mpz7 w ∧ Z.zones mpz9 w = Z.zones mpz7 w) → Z.readers mpz9 w = (0 : ℤ) ∧ (∀(mpz10 : Z.mpz_memo), Z.abs_value_of mpz10 = Z.abs_value_of mpz9 ∧ Z.alloc mpz10 = Z.alloc mpz9 ∧ Z.abs_size mpz10 = Z.abs_size mpz9 ∧ Z.sgn mpz10 = Z.sgn mpz9 ∧ Z.zones mpz10 = Z.zones mpz9 → (∀(wp' : C.ptr (BitVec 64)), Z.readers mpz10 w = -(1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz10 y = Z.readers mpz9 y) ∧ Lemmas.value wp' (Z.abs_size mpz10 w) = Z.abs_value_of mpz10 w ∧ C.plength wp' = Z.alloc mpz10 w ∧ C.offset wp' = (0 : ℤ) ∧ C.min wp' = (0 : ℤ) ∧ C.max wp' = C.plength wp' ∧ C.writable wp' = true ∧ C.zone1 wp' = Z.zones mpz10 w → Z.mpz_unchanged (Zutil.ptr mu) mpz10 mpz9 ∧ (Z.readers mpz10 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz10 (Zutil.ptr mu) → Z.abs_value_of mpz10 (Zutil.ptr mu) = Z.abs_value_of mpz9 (Zutil.ptr mu) ∧ Z.alloc mpz10 (Zutil.ptr mu) = Z.alloc mpz9 (Zutil.ptr mu) ∧ Z.abs_size mpz10 (Zutil.ptr mu) = Z.abs_size mpz9 (Zutil.ptr mu) ∧ Z.sgn mpz10 (Zutil.ptr mu) = Z.sgn mpz9 (Zutil.ptr mu) ∧ Z.readers mpz10 (Zutil.ptr mu) = Z.readers mpz9 (Zutil.ptr mu) ∧ Z.zones mpz10 (Zutil.ptr mu) = Z.zones mpz9 (Zutil.ptr mu)) → Z.mpz_unchanged v1 mpz10 mpz9 ∧ (Z.readers mpz10 v1 = Z.readers mpz9 v1 ∧ (-(2 : ℤ) < Z.readers mpz10 v1 → Z.abs_value_of mpz10 v1 = Z.abs_value_of mpz9 v1 ∧ Z.alloc mpz10 v1 = Z.alloc mpz9 v1 ∧ Z.abs_size mpz10 v1 = Z.abs_size mpz9 v1 ∧ Z.sgn mpz10 v1 = Z.sgn mpz9 v1 ∧ Z.readers mpz10 v1 = Z.readers mpz9 v1 ∧ Z.zones mpz10 v1 = Z.zones mpz9 v1) → (C.valid up' (BitVec.toInt usize) ∧ C.valid vp' (BitVec.toInt vsize) ∧ C.valid wp' (BitVec.toInt usize + BitVec.toInt vsize) ∧ C.writable wp' = true ∧ ((0 : ℤ) < BitVec.toInt vsize ∧ BitVec.toInt vsize ≤ BitVec.toInt usize) ∧ (8 : ℤ) * BitVec.toInt usize < (2147483647 : ℤ) ∧ BitVec.toInt usize ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(wp'1 : C.ptr (BitVec 64)), C.offset wp'1 = C.offset wp' ∧ C.writable wp'1 = C.writable wp' ∧ C.zone1 wp'1 = C.zone1 wp' → C.min wp'1 = C.min wp' ∧ C.max wp'1 = C.max wp' ∧ C.plength wp'1 = C.plength wp' ∧ Lemmas.value wp'1 (BitVec.toInt usize + BitVec.toInt vsize) = Lemmas.value up' (BitVec.toInt usize) * Lemmas.value vp' (BitVec.toInt vsize) ∧ (∀(j : ℤ), C.min wp'1 ≤ j ∧ j < C.offset wp'1 ∨ C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize ≤ j ∧ j < C.max wp'1 → C.pelts wp'1 j = C.pelts wp' j) → (∀(o10 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o10 = true) ∧ (o10 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o11 : BitVec 32), (if o10 = true then o11 = (1 : BitVec 32) else o11 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o11) ∧ (∀(wsize' : BitVec 32), BitVec.toInt wsize' = BitVec.toInt o7 - BitVec.toInt o11 → (Z.zones mpz10 (Zutil.ptr mu) = C.zone1 up' ∧ (1 : ℤ) ≤ Z.readers mpz10 (Zutil.ptr mu) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up') ∧ (∀(mpz11 : Z.mpz_memo), Z.abs_value_of mpz11 = Z.abs_value_of mpz10 ∧ Z.alloc mpz11 = Z.alloc mpz10 ∧ Z.abs_size mpz11 = Z.abs_size mpz10 ∧ Z.sgn mpz11 = Z.sgn mpz10 ∧ Z.zones mpz11 = Z.zones mpz10 → Z.readers mpz11 (Zutil.ptr mu) = Z.readers mpz10 (Zutil.ptr mu) - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.readers mpz11 y = Z.readers mpz10 y) → Z.mpz_eq (Zutil.ptr mu) v1 = (Zutil.ptr mu = v1) → (¬Z.mpz_eq (Zutil.ptr mu) v1 → Z.mpz_unchanged v1 mpz11 mpz9) ∧ ((¬Z.mpz_eq (Zutil.ptr mu) v1 → Z.readers mpz11 v1 = Z.readers mpz9 v1 ∧ (-(2 : ℤ) < Z.readers mpz11 v1 → Z.abs_value_of mpz11 v1 = Z.abs_value_of mpz9 v1 ∧ Z.alloc mpz11 v1 = Z.alloc mpz9 v1 ∧ Z.abs_size mpz11 v1 = Z.abs_size mpz9 v1 ∧ Z.sgn mpz11 v1 = Z.sgn mpz9 v1 ∧ Z.readers mpz11 v1 = Z.readers mpz9 v1 ∧ Z.zones mpz11 v1 = Z.zones mpz9 v1)) → (Z.zones mpz11 v1 = C.zone1 vp' ∧ (1 : ℤ) ≤ Z.readers mpz11 v1 ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp') ∧ (∀(mpz12 : Z.mpz_memo), Z.abs_value_of mpz12 = Z.abs_value_of mpz11 ∧ Z.alloc mpz12 = Z.alloc mpz11 ∧ Z.abs_size mpz12 = Z.abs_size mpz11 ∧ Z.sgn mpz12 = Z.sgn mpz11 ∧ Z.zones mpz12 = Z.zones mpz11 → Z.readers mpz12 v1 = Z.readers mpz11 v1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = v1 → Z.readers mpz12 y = Z.readers mpz11 y) → Z.mpz_unchanged w mpz12 mpz10 ∧ (Z.readers mpz12 w = Z.readers mpz10 w ∧ (-(2 : ℤ) < Z.readers mpz12 w → Z.abs_value_of mpz12 w = Z.abs_value_of mpz10 w ∧ Z.alloc mpz12 w = Z.alloc mpz10 w ∧ Z.abs_size mpz12 w = Z.abs_size mpz10 w ∧ Z.sgn mpz12 w = Z.sgn mpz10 w ∧ Z.readers mpz12 w = Z.readers mpz10 w ∧ Z.zones mpz12 w = Z.zones mpz10 w) → (∀(o12 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o12 = true) ∧ (o12 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o13 : BitVec 32), (if o12 = true then o13 = (1 : BitVec 32) else o13 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o13) ∧ (∀(o14 : BitVec 32), BitVec.toInt o14 = BitVec.toInt o7 - BitVec.toInt o13 → (BitVec.toInt sign_product < (0 : ℤ) → int'32_in_bounds (-BitVec.toInt o14)) ∧ (∀(o15 : BitVec 32), (if BitVec.toInt sign_product < (0 : ℤ) then BitVec.toInt o15 = -BitVec.toInt o14 else o15 = o14) → (C.offset wp'1 = (0 : ℤ) ∧ C.writable wp'1 = true ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz12 w ∧ (Z.readers mpz12 w = (0 : ℤ) ∨ Z.readers mpz12 w = -(1 : ℤ))) ∧ (∀(mpz13 : Z.mpz_memo), Z.alloc mpz13 = Z.alloc mpz12 ∧ Z.abs_size mpz13 = Z.abs_size mpz12 ∧ Z.sgn mpz13 = Z.sgn mpz12 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz13 mpz12) ∧ Z.abs_value_of mpz13 w = Lemmas.value wp'1 (Z.abs_size mpz13 w) ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ Z.zones mpz13 w = C.zone1 wp'1 → (Z.zones mpz13 w = C.zone1 wp'1 ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ C.offset wp'1 = (0 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ abs (BitVec.toInt o15) ≤ C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz13 w ∧ (¬BitVec.toInt o15 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o15) - (1 : ℤ))) ≤ Lemmas.value wp'1 (abs (BitVec.toInt o15)))) ∧ (∀(mpz14 : Z.mpz_memo), Z.alloc mpz14 = Z.alloc mpz13 ∧ Z.readers mpz14 = Z.readers mpz13 ∧ Z.zones mpz14 = Z.zones mpz13 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz14 mpz13) ∧ (Z.sgn mpz14 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o15) ∧ (Z.sgn mpz14 w = -(1 : ℤ)) = (BitVec.toInt o15 < (0 : ℤ)) ∧ Z.abs_size mpz14 w = abs (BitVec.toInt o15) ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'1 (abs (BitVec.toInt o15)) → Z.mpz_eq w w → (¬Z.mpz_eq w w → Z.mpz_unchanged w mpz14 mpz12) ∧ ((¬Z.mpz_eq w w → Z.readers mpz14 w = Z.readers mpz12 w ∧ (-(2 : ℤ) < Z.readers mpz14 w → Z.abs_value_of mpz14 w = Z.abs_value_of mpz12 w ∧ Z.alloc mpz14 w = Z.alloc mpz12 w ∧ Z.abs_size mpz14 w = Z.abs_size mpz12 w ∧ Z.sgn mpz14 w = Z.sgn mpz12 w ∧ Z.readers mpz14 w = Z.readers mpz12 w ∧ Z.zones mpz14 w = Z.zones mpz12 w)) → (Z.zones mpz14 w = C.zone1 wp'1 ∧ Z.readers mpz14 w = -(1 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'1 (Z.abs_size mpz14 w)) ∧ (∀(mpz15 : Z.mpz_memo), Z.abs_value_of mpz15 = Z.abs_value_of mpz14 ∧ Z.alloc mpz15 = Z.alloc mpz14 ∧ Z.abs_size mpz15 = Z.abs_size mpz14 ∧ Z.sgn mpz15 = Z.sgn mpz14 ∧ Z.zones mpz15 = Z.zones mpz14 → Z.readers mpz15 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz15 y = Z.readers mpz14 y) → Z.mpz_eq (Zutil.ptr mu) w = (Zutil.ptr mu = w) → (¬Z.mpz_eq (Zutil.ptr mu) w → Z.mpz_unchanged (Zutil.ptr mu) mpz15 mpz12) ∧ ((¬Z.mpz_eq (Zutil.ptr mu) w → Z.readers mpz15 (Zutil.ptr mu) = Z.readers mpz12 (Zutil.ptr mu) ∧ (-(2 : ℤ) < Z.readers mpz15 (Zutil.ptr mu) → Z.abs_value_of mpz15 (Zutil.ptr mu) = Z.abs_value_of mpz12 (Zutil.ptr mu) ∧ Z.alloc mpz15 (Zutil.ptr mu) = Z.alloc mpz12 (Zutil.ptr mu) ∧ Z.abs_size mpz15 (Zutil.ptr mu) = Z.abs_size mpz12 (Zutil.ptr mu) ∧ Z.sgn mpz15 (Zutil.ptr mu) = Z.sgn mpz12 (Zutil.ptr mu) ∧ Z.readers mpz15 (Zutil.ptr mu) = Z.readers mpz12 (Zutil.ptr mu) ∧ Z.zones mpz15 (Zutil.ptr mu) = Z.zones mpz12 (Zutil.ptr mu))) → Z.mpz_eq v1 w = (v1 = w) → (¬Z.mpz_eq v1 w → Z.mpz_unchanged v1 mpz15 mpz12) ∧ ((¬Z.mpz_eq v1 w → Z.readers mpz15 v1 = Z.readers mpz12 v1 ∧ (-(2 : ℤ) < Z.readers mpz15 v1 → Z.abs_value_of mpz15 v1 = Z.abs_value_of mpz12 v1 ∧ Z.alloc mpz15 v1 = Z.alloc mpz12 v1 ∧ Z.abs_size mpz15 v1 = Z.abs_size mpz12 v1 ∧ Z.sgn mpz15 v1 = Z.sgn mpz12 v1 ∧ Z.readers mpz15 v1 = Z.readers mpz12 v1 ∧ Z.zones mpz15 v1 = Z.zones mpz12 v1)) → Z.mpz_eq u1 (Zutil.ptr mu) = (u1 = Zutil.ptr mu) → (∀(o16 : Bool), (if Z.mpz_eq u1 (Zutil.ptr mu) then o16 = true else Z.mpz_eq u1 v1 = (u1 = v1) ∧ (if Z.mpz_eq u1 v1 then o16 = true else Z.mpz_eq u1 w = (u1 = w) ∧ (if Z.mpz_eq u1 w then o16 = true else o16 = (if Z.mpz_eq u1 w then true else false) ∧ (o16 = true) = (u1 = w)))) → (¬o16 = true → Z.mpz_unchanged u1 mpz15 mpz) ∧ ((¬o16 = true → Z.readers mpz15 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz15 u1 → Z.abs_value_of mpz15 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz15 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz15 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz15 u1 = Z.sgn mpz u1 ∧ Z.readers mpz15 u1 = Z.readers mpz u1 ∧ Z.zones mpz15 u1 = Z.zones mpz u1)) → Z.mpz_eq v1 (Zutil.ptr mu) = (v1 = Zutil.ptr mu) → (∀(o17 : Bool), (if Z.mpz_eq v1 (Zutil.ptr mu) then o17 = true else Z.mpz_eq v1 v1 ∧ (if Z.mpz_eq v1 v1 then o17 = true else Z.mpz_eq v1 w = (v1 = w) ∧ (if Z.mpz_eq v1 w then o17 = true else o17 = (if Z.mpz_eq v1 w then true else false) ∧ (o17 = true) = (v1 = w)))) → (¬o17 = true → Z.mpz_unchanged v1 mpz15 mpz) ∧ ((¬o17 = true → Z.readers mpz15 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz15 v1 → Z.abs_value_of mpz15 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz15 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz15 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz15 v1 = Z.sgn mpz v1 ∧ Z.readers mpz15 v1 = Z.readers mpz v1 ∧ Z.zones mpz15 v1 = Z.zones mpz v1)) → (if True then (Zutil.ok mu = true ∧ -(1 : ℤ) ≤ Z.readers mpz15 (Zutil.ptr mu) ∧ Z.readers mpz15 (Zutil.ptr mu) ≤ (0 : ℤ)) ∧ (∀(mpz16 : Z.mpz_memo), Z.readers mpz16 (Zutil.ptr mu) = -(2 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mu → Z.mpz_unchanged y mpz16 mpz15) → Z.mpz_unchanged w mpz16 mpz15 ∧ (Z.readers mpz16 w = Z.readers mpz15 w ∧ (-(2 : ℤ) < Z.readers mpz16 w → Z.abs_value_of mpz16 w = Z.abs_value_of mpz15 w ∧ Z.alloc mpz16 w = Z.alloc mpz15 w ∧ Z.abs_size mpz16 w = Z.abs_size mpz15 w ∧ Z.sgn mpz16 w = Z.sgn mpz15 w ∧ Z.readers mpz16 w = Z.readers mpz15 w ∧ Z.zones mpz16 w = Z.zones mpz15 w) → Z.value_of w mpz16 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz16 mpz) ∧ Z.readers mpz16 w = (0 : ℤ) ∧ Z.readers mpz16 u = (0 : ℤ) ∧ Z.readers mpz16 v = (0 : ℤ))) else Z.mpz_unchanged w mpz15 mpz15 ∧ Z.value_of w mpz15 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz15 mpz) ∧ Z.readers mpz15 w = (0 : ℤ) ∧ Z.readers mpz15 u = (0 : ℤ) ∧ Z.readers mpz15 v = (0 : ℤ)))))))))))))))))))))))))))))))))))))))))))))))) else if Z.mpz_eq v1 w then (0 : ℤ) ≤ Z.readers mpz w ∧ (∀(mpz1 : Z.mpz_memo), Z.abs_value_of mpz1 = Z.abs_value_of mpz ∧ Z.alloc mpz1 = Z.alloc mpz ∧ Z.abs_size mpz1 = Z.abs_size mpz ∧ Z.sgn mpz1 = Z.sgn mpz ∧ Z.zones mpz1 = Z.zones mpz → (∀(wp : C.ptr (BitVec 64)), Z.readers mpz1 w = Z.readers mpz w + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz1 y = Z.readers mpz y) ∧ Lemmas.value wp (Z.abs_size mpz1 w) = Z.abs_value_of mpz1 w ∧ C.plength wp = Z.alloc mpz1 w ∧ C.offset wp = (0 : ℤ) ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp ∧ C.zone1 wp = Z.zones mpz1 w → (0 : ℤ) ≤ BitVec.toInt vsize ∧ (∀(o9 : BitVec 32), BitVec.toUInt o9 = BitVec.toInt vsize → (0 : ℤ) ≤ BitVec.toUInt o9 ∧ (∀(vp : C.ptr (BitVec 64)), C.plength vp = BitVec.toUInt o9 ∧ C.offset vp = (0 : ℤ) ∧ C.min vp = (0 : ℤ) ∧ C.max vp = BitVec.toUInt o9 ∧ C.writable vp = true → (∀(mpz2 : Z.mpz_memo) (mv : Zutil.mpz_mem), Zutil.ok mv = true ∧ Z.readers mpz2 (Zutil.ptr mv) = (0 : ℤ) ∧ Z.alloc mpz2 (Zutil.ptr mv) = (0 : ℤ) ∧ Z.abs_size mpz2 (Zutil.ptr mv) = (0 : ℤ) ∧ Z.readers mpz1 (Zutil.ptr mv) = -(2 : ℤ) ∧ (∀(x : Z.mpz_ptr), ¬x = Zutil.ptr mv → Z.mpz_unchanged x mpz2 mpz1) → (Z.abs_size mpz2 (Zutil.ptr mv) ≤ BitVec.toInt vsize ∧ -(1 : ℤ) ≤ Z.readers mpz2 (Zutil.ptr mv) ∧ Z.readers mpz2 (Zutil.ptr mv) ≤ (0 : ℤ)) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.readers mpz3 = Z.readers mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mv → Z.mpz_unchanged y mpz3 mpz2) ∧ Z.alloc mpz3 (Zutil.ptr mv) = BitVec.toInt vsize → (C.valid wp (BitVec.toInt vsize) ∧ C.valid vp (BitVec.toInt vsize) ∧ C.writable vp = true) ∧ (∀(vp1 : C.ptr (BitVec 64)), List.length (C.data vp1) = List.length (C.data vp) ∧ C.offset vp1 = C.offset vp ∧ C.min vp1 = C.min vp ∧ C.max vp1 = C.max vp ∧ C.writable vp1 = C.writable vp ∧ C.zone1 vp1 = C.zone1 vp → Lemmas.map_eq_sub_shift (C.pelts vp1) (C.pelts wp) (C.offset vp1) (C.offset wp) (BitVec.toInt vsize) ∧ (∀(j : ℤ), j < C.offset vp1 ∨ C.offset vp1 + BitVec.toInt vsize ≤ j → C.pelts vp1 j = C.pelts vp j) → (C.offset vp1 = (0 : ℤ) ∧ C.writable vp1 = true ∧ C.min vp1 = (0 : ℤ) ∧ C.max vp1 = C.plength vp1 ∧ C.plength vp1 = Z.alloc mpz3 (Zutil.ptr mv) ∧ (Z.readers mpz3 (Zutil.ptr mv) = (0 : ℤ) ∨ Z.readers mpz3 (Zutil.ptr mv) = -(1 : ℤ))) ∧ (∀(mpz4 : Z.mpz_memo), Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.abs_size mpz4 = Z.abs_size mpz3 ∧ Z.sgn mpz4 = Z.sgn mpz3 → (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mv → Z.mpz_unchanged y mpz4 mpz3) ∧ Z.abs_value_of mpz4 (Zutil.ptr mv) = Lemmas.value vp1 (Z.abs_size mpz4 (Zutil.ptr mv)) ∧ Z.readers mpz4 (Zutil.ptr mv) = -(1 : ℤ) ∧ Z.zones mpz4 (Zutil.ptr mv) = C.zone1 vp1 → (Z.zones mpz4 (Zutil.ptr mv) = C.zone1 vp1 ∧ Z.readers mpz4 (Zutil.ptr mv) = -(1 : ℤ) ∧ C.offset vp1 = (0 : ℤ) ∧ C.min vp1 = (0 : ℤ) ∧ C.max vp1 = C.plength vp1 ∧ abs (BitVec.toInt vsize) ≤ C.plength vp1 ∧ C.plength vp1 = Z.alloc mpz4 (Zutil.ptr mv) ∧ (¬BitVec.toInt vsize = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt vsize) - (1 : ℤ))) ≤ Lemmas.value vp1 (abs (BitVec.toInt vsize)))) ∧ (∀(mpz5 : Z.mpz_memo), Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.readers mpz5 = Z.readers mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mv → Z.mpz_unchanged y mpz5 mpz4) ∧ (Z.sgn mpz5 (Zutil.ptr mv) = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt vsize) ∧ (Z.sgn mpz5 (Zutil.ptr mv) = -(1 : ℤ)) = (BitVec.toInt vsize < (0 : ℤ)) ∧ Z.abs_size mpz5 (Zutil.ptr mv) = abs (BitVec.toInt vsize) ∧ Z.abs_value_of mpz5 (Zutil.ptr mv) = Lemmas.value vp1 (abs (BitVec.toInt vsize)) → (Z.zones mpz5 (Zutil.ptr mv) = C.zone1 vp1 ∧ Z.readers mpz5 (Zutil.ptr mv) = -(1 : ℤ) ∧ C.min vp1 = (0 : ℤ) ∧ C.max vp1 = C.plength vp1 ∧ Z.abs_value_of mpz5 (Zutil.ptr mv) = Lemmas.value vp1 (Z.abs_size mpz5 (Zutil.ptr mv))) ∧ (∀(mpz6 : Z.mpz_memo), Z.abs_value_of mpz6 = Z.abs_value_of mpz5 ∧ Z.alloc mpz6 = Z.alloc mpz5 ∧ Z.abs_size mpz6 = Z.abs_size mpz5 ∧ Z.sgn mpz6 = Z.sgn mpz5 ∧ Z.zones mpz6 = Z.zones mpz5 → Z.readers mpz6 (Zutil.ptr mv) = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mv → Z.readers mpz6 y = Z.readers mpz5 y) → Z.mpz_unchanged u1 mpz6 mpz1 ∧ (Z.readers mpz6 u1 = Z.readers mpz1 u1 ∧ (-(2 : ℤ) < Z.readers mpz6 u1 → Z.abs_value_of mpz6 u1 = Z.abs_value_of mpz1 u1 ∧ Z.alloc mpz6 u1 = Z.alloc mpz1 u1 ∧ Z.abs_size mpz6 u1 = Z.abs_size mpz1 u1 ∧ Z.sgn mpz6 u1 = Z.sgn mpz1 u1 ∧ Z.readers mpz6 u1 = Z.readers mpz1 u1 ∧ Z.zones mpz6 u1 = Z.zones mpz1 u1) → Z.mpz_unchanged v1 mpz6 mpz1 ∧ (Z.readers mpz6 v1 = Z.readers mpz1 v1 ∧ (-(2 : ℤ) < Z.readers mpz6 v1 → Z.abs_value_of mpz6 v1 = Z.abs_value_of mpz1 v1 ∧ Z.alloc mpz6 v1 = Z.alloc mpz1 v1 ∧ Z.abs_size mpz6 v1 = Z.abs_size mpz1 v1 ∧ Z.sgn mpz6 v1 = Z.sgn mpz1 v1 ∧ Z.readers mpz6 v1 = Z.readers mpz1 v1 ∧ Z.zones mpz6 v1 = Z.zones mpz1 v1) → Z.mpz_unchanged w mpz6 mpz1 ∧ (Z.readers mpz6 w = Z.readers mpz1 w ∧ (-(2 : ℤ) < Z.readers mpz6 w → Z.abs_value_of mpz6 w = Z.abs_value_of mpz1 w ∧ Z.alloc mpz6 w = Z.alloc mpz1 w ∧ Z.abs_size mpz6 w = Z.abs_size mpz1 w ∧ Z.sgn mpz6 w = Z.sgn mpz1 w ∧ Z.readers mpz6 w = Z.readers mpz1 w ∧ Z.zones mpz6 w = Z.zones mpz1 w) → (Z.zones mpz6 w = C.zone1 wp ∧ (1 : ℤ) ≤ Z.readers mpz6 w ∧ C.min wp = (0 : ℤ) ∧ C.max wp = C.plength wp) ∧ (∀(mpz7 : Z.mpz_memo), Z.abs_value_of mpz7 = Z.abs_value_of mpz6 ∧ Z.alloc mpz7 = Z.alloc mpz6 ∧ Z.abs_size mpz7 = Z.abs_size mpz6 ∧ Z.sgn mpz7 = Z.sgn mpz6 ∧ Z.zones mpz7 = Z.zones mpz6 → Z.readers mpz7 w = Z.readers mpz6 w - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz7 y = Z.readers mpz6 y) → (0 : ℤ) ≤ Z.readers mpz7 u1 ∧ (∀(mpz8 : Z.mpz_memo), Z.abs_value_of mpz8 = Z.abs_value_of mpz7 ∧ Z.alloc mpz8 = Z.alloc mpz7 ∧ Z.abs_size mpz8 = Z.abs_size mpz7 ∧ Z.sgn mpz8 = Z.sgn mpz7 ∧ Z.zones mpz8 = Z.zones mpz7 → (∀(up' : C.ptr (BitVec 64)), Z.readers mpz8 u1 = Z.readers mpz7 u1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬u1 = y → Z.readers mpz8 y = Z.readers mpz7 y) ∧ Lemmas.value up' (Z.abs_size mpz8 u1) = Z.abs_value_of mpz8 u1 ∧ C.plength up' = Z.alloc mpz8 u1 ∧ C.offset up' = (0 : ℤ) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up' ∧ C.zone1 up' = Z.zones mpz8 u1 → (0 : ℤ) ≤ Z.readers mpz8 (Zutil.ptr mv) ∧ (∀(mpz9 : Z.mpz_memo), Z.abs_value_of mpz9 = Z.abs_value_of mpz8 ∧ Z.alloc mpz9 = Z.alloc mpz8 ∧ Z.abs_size mpz9 = Z.abs_size mpz8 ∧ Z.sgn mpz9 = Z.sgn mpz8 ∧ Z.zones mpz9 = Z.zones mpz8 → (∀(vp' : C.ptr (BitVec 64)), Z.readers mpz9 (Zutil.ptr mv) = Z.readers mpz8 (Zutil.ptr mv) + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬Zutil.ptr mv = y → Z.readers mpz9 y = Z.readers mpz8 y) ∧ Lemmas.value vp' (Z.abs_size mpz9 (Zutil.ptr mv)) = Z.abs_value_of mpz9 (Zutil.ptr mv) ∧ C.plength vp' = Z.alloc mpz9 (Zutil.ptr mv) ∧ C.offset vp' = (0 : ℤ) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp' ∧ C.zone1 vp' = Z.zones mpz9 (Zutil.ptr mv) → Z.mpz_unchanged w mpz9 mpz7 ∧ (Z.readers mpz9 w = Z.readers mpz7 w ∧ (-(2 : ℤ) < Z.readers mpz9 w → Z.abs_value_of mpz9 w = Z.abs_value_of mpz7 w ∧ Z.alloc mpz9 w = Z.alloc mpz7 w ∧ Z.abs_size mpz9 w = Z.abs_size mpz7 w ∧ Z.sgn mpz9 w = Z.sgn mpz7 w ∧ Z.readers mpz9 w = Z.readers mpz7 w ∧ Z.zones mpz9 w = Z.zones mpz7 w) → Z.readers mpz9 w = (0 : ℤ) ∧ (∀(mpz10 : Z.mpz_memo), Z.abs_value_of mpz10 = Z.abs_value_of mpz9 ∧ Z.alloc mpz10 = Z.alloc mpz9 ∧ Z.abs_size mpz10 = Z.abs_size mpz9 ∧ Z.sgn mpz10 = Z.sgn mpz9 ∧ Z.zones mpz10 = Z.zones mpz9 → (∀(wp' : C.ptr (BitVec 64)), Z.readers mpz10 w = -(1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz10 y = Z.readers mpz9 y) ∧ Lemmas.value wp' (Z.abs_size mpz10 w) = Z.abs_value_of mpz10 w ∧ C.plength wp' = Z.alloc mpz10 w ∧ C.offset wp' = (0 : ℤ) ∧ C.min wp' = (0 : ℤ) ∧ C.max wp' = C.plength wp' ∧ C.writable wp' = true ∧ C.zone1 wp' = Z.zones mpz10 w → Z.mpz_unchanged u1 mpz10 mpz9 ∧ (Z.readers mpz10 u1 = Z.readers mpz9 u1 ∧ (-(2 : ℤ) < Z.readers mpz10 u1 → Z.abs_value_of mpz10 u1 = Z.abs_value_of mpz9 u1 ∧ Z.alloc mpz10 u1 = Z.alloc mpz9 u1 ∧ Z.abs_size mpz10 u1 = Z.abs_size mpz9 u1 ∧ Z.sgn mpz10 u1 = Z.sgn mpz9 u1 ∧ Z.readers mpz10 u1 = Z.readers mpz9 u1 ∧ Z.zones mpz10 u1 = Z.zones mpz9 u1) → Z.mpz_unchanged (Zutil.ptr mv) mpz10 mpz9 ∧ (Z.readers mpz10 (Zutil.ptr mv) = Z.readers mpz9 (Zutil.ptr mv) ∧ (-(2 : ℤ) < Z.readers mpz10 (Zutil.ptr mv) → Z.abs_value_of mpz10 (Zutil.ptr mv) = Z.abs_value_of mpz9 (Zutil.ptr mv) ∧ Z.alloc mpz10 (Zutil.ptr mv) = Z.alloc mpz9 (Zutil.ptr mv) ∧ Z.abs_size mpz10 (Zutil.ptr mv) = Z.abs_size mpz9 (Zutil.ptr mv) ∧ Z.sgn mpz10 (Zutil.ptr mv) = Z.sgn mpz9 (Zutil.ptr mv) ∧ Z.readers mpz10 (Zutil.ptr mv) = Z.readers mpz9 (Zutil.ptr mv) ∧ Z.zones mpz10 (Zutil.ptr mv) = Z.zones mpz9 (Zutil.ptr mv)) → (C.valid up' (BitVec.toInt usize) ∧ C.valid vp' (BitVec.toInt vsize) ∧ C.valid wp' (BitVec.toInt usize + BitVec.toInt vsize) ∧ C.writable wp' = true ∧ ((0 : ℤ) < BitVec.toInt vsize ∧ BitVec.toInt vsize ≤ BitVec.toInt usize) ∧ (8 : ℤ) * BitVec.toInt usize < (2147483647 : ℤ) ∧ BitVec.toInt usize ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(wp'1 : C.ptr (BitVec 64)), C.offset wp'1 = C.offset wp' ∧ C.writable wp'1 = C.writable wp' ∧ C.zone1 wp'1 = C.zone1 wp' → C.min wp'1 = C.min wp' ∧ C.max wp'1 = C.max wp' ∧ C.plength wp'1 = C.plength wp' ∧ Lemmas.value wp'1 (BitVec.toInt usize + BitVec.toInt vsize) = Lemmas.value up' (BitVec.toInt usize) * Lemmas.value vp' (BitVec.toInt vsize) ∧ (∀(j : ℤ), C.min wp'1 ≤ j ∧ j < C.offset wp'1 ∨ C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize ≤ j ∧ j < C.max wp'1 → C.pelts wp'1 j = C.pelts wp' j) → (∀(o10 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o10 = true) ∧ (o10 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o11 : BitVec 32), (if o10 = true then o11 = (1 : BitVec 32) else o11 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o11) ∧ (∀(wsize' : BitVec 32), BitVec.toInt wsize' = BitVec.toInt o7 - BitVec.toInt o11 → (Z.zones mpz10 u1 = C.zone1 up' ∧ (1 : ℤ) ≤ Z.readers mpz10 u1 ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up') ∧ (∀(mpz11 : Z.mpz_memo), Z.abs_value_of mpz11 = Z.abs_value_of mpz10 ∧ Z.alloc mpz11 = Z.alloc mpz10 ∧ Z.abs_size mpz11 = Z.abs_size mpz10 ∧ Z.sgn mpz11 = Z.sgn mpz10 ∧ Z.zones mpz11 = Z.zones mpz10 → Z.readers mpz11 u1 = Z.readers mpz10 u1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = u1 → Z.readers mpz11 y = Z.readers mpz10 y) → Z.mpz_eq u1 (Zutil.ptr mv) = (u1 = Zutil.ptr mv) → (¬Z.mpz_eq u1 (Zutil.ptr mv) → Z.mpz_unchanged (Zutil.ptr mv) mpz11 mpz9) ∧ ((¬Z.mpz_eq u1 (Zutil.ptr mv) → Z.readers mpz11 (Zutil.ptr mv) = Z.readers mpz9 (Zutil.ptr mv) ∧ (-(2 : ℤ) < Z.readers mpz11 (Zutil.ptr mv) → Z.abs_value_of mpz11 (Zutil.ptr mv) = Z.abs_value_of mpz9 (Zutil.ptr mv) ∧ Z.alloc mpz11 (Zutil.ptr mv) = Z.alloc mpz9 (Zutil.ptr mv) ∧ Z.abs_size mpz11 (Zutil.ptr mv) = Z.abs_size mpz9 (Zutil.ptr mv) ∧ Z.sgn mpz11 (Zutil.ptr mv) = Z.sgn mpz9 (Zutil.ptr mv) ∧ Z.readers mpz11 (Zutil.ptr mv) = Z.readers mpz9 (Zutil.ptr mv) ∧ Z.zones mpz11 (Zutil.ptr mv) = Z.zones mpz9 (Zutil.ptr mv))) → (Z.zones mpz11 (Zutil.ptr mv) = C.zone1 vp' ∧ (1 : ℤ) ≤ Z.readers mpz11 (Zutil.ptr mv) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp') ∧ (∀(mpz12 : Z.mpz_memo), Z.abs_value_of mpz12 = Z.abs_value_of mpz11 ∧ Z.alloc mpz12 = Z.alloc mpz11 ∧ Z.abs_size mpz12 = Z.abs_size mpz11 ∧ Z.sgn mpz12 = Z.sgn mpz11 ∧ Z.zones mpz12 = Z.zones mpz11 → Z.readers mpz12 (Zutil.ptr mv) = Z.readers mpz11 (Zutil.ptr mv) - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mv → Z.readers mpz12 y = Z.readers mpz11 y) → Z.mpz_unchanged w mpz12 mpz10 ∧ (Z.readers mpz12 w = Z.readers mpz10 w ∧ (-(2 : ℤ) < Z.readers mpz12 w → Z.abs_value_of mpz12 w = Z.abs_value_of mpz10 w ∧ Z.alloc mpz12 w = Z.alloc mpz10 w ∧ Z.abs_size mpz12 w = Z.abs_size mpz10 w ∧ Z.sgn mpz12 w = Z.sgn mpz10 w ∧ Z.readers mpz12 w = Z.readers mpz10 w ∧ Z.zones mpz12 w = Z.zones mpz10 w) → (∀(o12 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o12 = true) ∧ (o12 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o13 : BitVec 32), (if o12 = true then o13 = (1 : BitVec 32) else o13 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o13) ∧ (∀(o14 : BitVec 32), BitVec.toInt o14 = BitVec.toInt o7 - BitVec.toInt o13 → (BitVec.toInt sign_product < (0 : ℤ) → int'32_in_bounds (-BitVec.toInt o14)) ∧ (∀(o15 : BitVec 32), (if BitVec.toInt sign_product < (0 : ℤ) then BitVec.toInt o15 = -BitVec.toInt o14 else o15 = o14) → (C.offset wp'1 = (0 : ℤ) ∧ C.writable wp'1 = true ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz12 w ∧ (Z.readers mpz12 w = (0 : ℤ) ∨ Z.readers mpz12 w = -(1 : ℤ))) ∧ (∀(mpz13 : Z.mpz_memo), Z.alloc mpz13 = Z.alloc mpz12 ∧ Z.abs_size mpz13 = Z.abs_size mpz12 ∧ Z.sgn mpz13 = Z.sgn mpz12 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz13 mpz12) ∧ Z.abs_value_of mpz13 w = Lemmas.value wp'1 (Z.abs_size mpz13 w) ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ Z.zones mpz13 w = C.zone1 wp'1 → (Z.zones mpz13 w = C.zone1 wp'1 ∧ Z.readers mpz13 w = -(1 : ℤ) ∧ C.offset wp'1 = (0 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ abs (BitVec.toInt o15) ≤ C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz13 w ∧ (¬BitVec.toInt o15 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o15) - (1 : ℤ))) ≤ Lemmas.value wp'1 (abs (BitVec.toInt o15)))) ∧ (∀(mpz14 : Z.mpz_memo), Z.alloc mpz14 = Z.alloc mpz13 ∧ Z.readers mpz14 = Z.readers mpz13 ∧ Z.zones mpz14 = Z.zones mpz13 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz14 mpz13) ∧ (Z.sgn mpz14 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o15) ∧ (Z.sgn mpz14 w = -(1 : ℤ)) = (BitVec.toInt o15 < (0 : ℤ)) ∧ Z.abs_size mpz14 w = abs (BitVec.toInt o15) ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'1 (abs (BitVec.toInt o15)) → Z.mpz_eq w w → (¬Z.mpz_eq w w → Z.mpz_unchanged w mpz14 mpz12) ∧ ((¬Z.mpz_eq w w → Z.readers mpz14 w = Z.readers mpz12 w ∧ (-(2 : ℤ) < Z.readers mpz14 w → Z.abs_value_of mpz14 w = Z.abs_value_of mpz12 w ∧ Z.alloc mpz14 w = Z.alloc mpz12 w ∧ Z.abs_size mpz14 w = Z.abs_size mpz12 w ∧ Z.sgn mpz14 w = Z.sgn mpz12 w ∧ Z.readers mpz14 w = Z.readers mpz12 w ∧ Z.zones mpz14 w = Z.zones mpz12 w)) → (Z.zones mpz14 w = C.zone1 wp'1 ∧ Z.readers mpz14 w = -(1 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ Z.abs_value_of mpz14 w = Lemmas.value wp'1 (Z.abs_size mpz14 w)) ∧ (∀(mpz15 : Z.mpz_memo), Z.abs_value_of mpz15 = Z.abs_value_of mpz14 ∧ Z.alloc mpz15 = Z.alloc mpz14 ∧ Z.abs_size mpz15 = Z.abs_size mpz14 ∧ Z.sgn mpz15 = Z.sgn mpz14 ∧ Z.zones mpz15 = Z.zones mpz14 → Z.readers mpz15 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz15 y = Z.readers mpz14 y) → Z.mpz_eq u1 w = (u1 = w) → (¬Z.mpz_eq u1 w → Z.mpz_unchanged u1 mpz15 mpz12) ∧ ((¬Z.mpz_eq u1 w → Z.readers mpz15 u1 = Z.readers mpz12 u1 ∧ (-(2 : ℤ) < Z.readers mpz15 u1 → Z.abs_value_of mpz15 u1 = Z.abs_value_of mpz12 u1 ∧ Z.alloc mpz15 u1 = Z.alloc mpz12 u1 ∧ Z.abs_size mpz15 u1 = Z.abs_size mpz12 u1 ∧ Z.sgn mpz15 u1 = Z.sgn mpz12 u1 ∧ Z.readers mpz15 u1 = Z.readers mpz12 u1 ∧ Z.zones mpz15 u1 = Z.zones mpz12 u1)) → Z.mpz_eq (Zutil.ptr mv) w = (Zutil.ptr mv = w) → (¬Z.mpz_eq (Zutil.ptr mv) w → Z.mpz_unchanged (Zutil.ptr mv) mpz15 mpz12) ∧ ((¬Z.mpz_eq (Zutil.ptr mv) w → Z.readers mpz15 (Zutil.ptr mv) = Z.readers mpz12 (Zutil.ptr mv) ∧ (-(2 : ℤ) < Z.readers mpz15 (Zutil.ptr mv) → Z.abs_value_of mpz15 (Zutil.ptr mv) = Z.abs_value_of mpz12 (Zutil.ptr mv) ∧ Z.alloc mpz15 (Zutil.ptr mv) = Z.alloc mpz12 (Zutil.ptr mv) ∧ Z.abs_size mpz15 (Zutil.ptr mv) = Z.abs_size mpz12 (Zutil.ptr mv) ∧ Z.sgn mpz15 (Zutil.ptr mv) = Z.sgn mpz12 (Zutil.ptr mv) ∧ Z.readers mpz15 (Zutil.ptr mv) = Z.readers mpz12 (Zutil.ptr mv) ∧ Z.zones mpz15 (Zutil.ptr mv) = Z.zones mpz12 (Zutil.ptr mv))) → Z.mpz_eq u1 u1 → (∀(o16 : Bool), (if Z.mpz_eq u1 u1 then o16 = true else Z.mpz_eq u1 (Zutil.ptr mv) = (u1 = Zutil.ptr mv) ∧ (if Z.mpz_eq u1 (Zutil.ptr mv) then o16 = true else Z.mpz_eq u1 w = (u1 = w) ∧ (if Z.mpz_eq u1 w then o16 = true else o16 = (if Z.mpz_eq u1 w then true else false) ∧ (o16 = true) = (u1 = w)))) → (¬o16 = true → Z.mpz_unchanged u1 mpz15 mpz) ∧ ((¬o16 = true → Z.readers mpz15 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz15 u1 → Z.abs_value_of mpz15 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz15 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz15 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz15 u1 = Z.sgn mpz u1 ∧ Z.readers mpz15 u1 = Z.readers mpz u1 ∧ Z.zones mpz15 u1 = Z.zones mpz u1)) → Z.mpz_eq v1 u1 = (v1 = u1) → (∀(o17 : Bool), (if Z.mpz_eq v1 u1 then o17 = true else Z.mpz_eq v1 (Zutil.ptr mv) = (v1 = Zutil.ptr mv) ∧ (if Z.mpz_eq v1 (Zutil.ptr mv) then o17 = true else Z.mpz_eq v1 w = (v1 = w) ∧ (if Z.mpz_eq v1 w then o17 = true else o17 = (if Z.mpz_eq v1 w then true else false) ∧ (o17 = true) = (v1 = w)))) → (¬o17 = true → Z.mpz_unchanged v1 mpz15 mpz) ∧ ((¬o17 = true → Z.readers mpz15 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz15 v1 → Z.abs_value_of mpz15 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz15 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz15 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz15 v1 = Z.sgn mpz v1 ∧ Z.readers mpz15 v1 = Z.readers mpz v1 ∧ Z.zones mpz15 v1 = Z.zones mpz v1)) → (if True then (Zutil.ok mv = true ∧ -(1 : ℤ) ≤ Z.readers mpz15 (Zutil.ptr mv) ∧ Z.readers mpz15 (Zutil.ptr mv) ≤ (0 : ℤ)) ∧ (∀(mpz16 : Z.mpz_memo), Z.readers mpz16 (Zutil.ptr mv) = -(2 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = Zutil.ptr mv → Z.mpz_unchanged y mpz16 mpz15) → Z.mpz_unchanged w mpz16 mpz15 ∧ (Z.readers mpz16 w = Z.readers mpz15 w ∧ (-(2 : ℤ) < Z.readers mpz16 w → Z.abs_value_of mpz16 w = Z.abs_value_of mpz15 w ∧ Z.alloc mpz16 w = Z.alloc mpz15 w ∧ Z.abs_size mpz16 w = Z.abs_size mpz15 w ∧ Z.sgn mpz16 w = Z.sgn mpz15 w ∧ Z.readers mpz16 w = Z.readers mpz15 w ∧ Z.zones mpz16 w = Z.zones mpz15 w) → Z.value_of w mpz16 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz16 mpz) ∧ Z.readers mpz16 w = (0 : ℤ) ∧ Z.readers mpz16 u = (0 : ℤ) ∧ Z.readers mpz16 v = (0 : ℤ))) else Z.mpz_unchanged w mpz15 mpz15 ∧ Z.value_of w mpz15 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz15 mpz) ∧ Z.readers mpz15 w = (0 : ℤ) ∧ Z.readers mpz15 u = (0 : ℤ) ∧ Z.readers mpz15 v = (0 : ℤ))))))))))))))))))))))))))))))))))))))))))))))) else (0 : ℤ) ≤ Z.readers mpz u1 ∧ (∀(mpz1 : Z.mpz_memo), Z.abs_value_of mpz1 = Z.abs_value_of mpz ∧ Z.alloc mpz1 = Z.alloc mpz ∧ Z.abs_size mpz1 = Z.abs_size mpz ∧ Z.sgn mpz1 = Z.sgn mpz ∧ Z.zones mpz1 = Z.zones mpz → (∀(up' : C.ptr (BitVec 64)), Z.readers mpz1 u1 = Z.readers mpz u1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬u1 = y → Z.readers mpz1 y = Z.readers mpz y) ∧ Lemmas.value up' (Z.abs_size mpz1 u1) = Z.abs_value_of mpz1 u1 ∧ C.plength up' = Z.alloc mpz1 u1 ∧ C.offset up' = (0 : ℤ) ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up' ∧ C.zone1 up' = Z.zones mpz1 u1 → (0 : ℤ) ≤ Z.readers mpz1 v1 ∧ (∀(mpz2 : Z.mpz_memo), Z.abs_value_of mpz2 = Z.abs_value_of mpz1 ∧ Z.alloc mpz2 = Z.alloc mpz1 ∧ Z.abs_size mpz2 = Z.abs_size mpz1 ∧ Z.sgn mpz2 = Z.sgn mpz1 ∧ Z.zones mpz2 = Z.zones mpz1 → (∀(vp' : C.ptr (BitVec 64)), Z.readers mpz2 v1 = Z.readers mpz1 v1 + (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬v1 = y → Z.readers mpz2 y = Z.readers mpz1 y) ∧ Lemmas.value vp' (Z.abs_size mpz2 v1) = Z.abs_value_of mpz2 v1 ∧ C.plength vp' = Z.alloc mpz2 v1 ∧ C.offset vp' = (0 : ℤ) ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp' ∧ C.zone1 vp' = Z.zones mpz2 v1 → Z.mpz_unchanged w mpz2 mpz ∧ (Z.readers mpz2 w = Z.readers mpz w ∧ (-(2 : ℤ) < Z.readers mpz2 w → Z.abs_value_of mpz2 w = Z.abs_value_of mpz w ∧ Z.alloc mpz2 w = Z.alloc mpz w ∧ Z.abs_size mpz2 w = Z.abs_size mpz w ∧ Z.sgn mpz2 w = Z.sgn mpz w ∧ Z.readers mpz2 w = Z.readers mpz w ∧ Z.zones mpz2 w = Z.zones mpz w) → Z.readers mpz2 w = (0 : ℤ) ∧ (∀(mpz3 : Z.mpz_memo), Z.abs_value_of mpz3 = Z.abs_value_of mpz2 ∧ Z.alloc mpz3 = Z.alloc mpz2 ∧ Z.abs_size mpz3 = Z.abs_size mpz2 ∧ Z.sgn mpz3 = Z.sgn mpz2 ∧ Z.zones mpz3 = Z.zones mpz2 → (∀(wp' : C.ptr (BitVec 64)), Z.readers mpz3 w = -(1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬w = y → Z.readers mpz3 y = Z.readers mpz2 y) ∧ Lemmas.value wp' (Z.abs_size mpz3 w) = Z.abs_value_of mpz3 w ∧ C.plength wp' = Z.alloc mpz3 w ∧ C.offset wp' = (0 : ℤ) ∧ C.min wp' = (0 : ℤ) ∧ C.max wp' = C.plength wp' ∧ C.writable wp' = true ∧ C.zone1 wp' = Z.zones mpz3 w → Z.mpz_unchanged u1 mpz3 mpz2 ∧ (Z.readers mpz3 u1 = Z.readers mpz2 u1 ∧ (-(2 : ℤ) < Z.readers mpz3 u1 → Z.abs_value_of mpz3 u1 = Z.abs_value_of mpz2 u1 ∧ Z.alloc mpz3 u1 = Z.alloc mpz2 u1 ∧ Z.abs_size mpz3 u1 = Z.abs_size mpz2 u1 ∧ Z.sgn mpz3 u1 = Z.sgn mpz2 u1 ∧ Z.readers mpz3 u1 = Z.readers mpz2 u1 ∧ Z.zones mpz3 u1 = Z.zones mpz2 u1) → Z.mpz_unchanged v1 mpz3 mpz2 ∧ (Z.readers mpz3 v1 = Z.readers mpz2 v1 ∧ (-(2 : ℤ) < Z.readers mpz3 v1 → Z.abs_value_of mpz3 v1 = Z.abs_value_of mpz2 v1 ∧ Z.alloc mpz3 v1 = Z.alloc mpz2 v1 ∧ Z.abs_size mpz3 v1 = Z.abs_size mpz2 v1 ∧ Z.sgn mpz3 v1 = Z.sgn mpz2 v1 ∧ Z.readers mpz3 v1 = Z.readers mpz2 v1 ∧ Z.zones mpz3 v1 = Z.zones mpz2 v1) → (C.valid up' (BitVec.toInt usize) ∧ C.valid vp' (BitVec.toInt vsize) ∧ C.valid wp' (BitVec.toInt usize + BitVec.toInt vsize) ∧ C.writable wp' = true ∧ ((0 : ℤ) < BitVec.toInt vsize ∧ BitVec.toInt vsize ≤ BitVec.toInt usize) ∧ (8 : ℤ) * BitVec.toInt usize < (2147483647 : ℤ) ∧ BitVec.toInt usize ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(wp'1 : C.ptr (BitVec 64)), C.offset wp'1 = C.offset wp' ∧ C.writable wp'1 = C.writable wp' ∧ C.zone1 wp'1 = C.zone1 wp' → C.min wp'1 = C.min wp' ∧ C.max wp'1 = C.max wp' ∧ C.plength wp'1 = C.plength wp' ∧ Lemmas.value wp'1 (BitVec.toInt usize + BitVec.toInt vsize) = Lemmas.value up' (BitVec.toInt usize) * Lemmas.value vp' (BitVec.toInt vsize) ∧ (∀(j : ℤ), C.min wp'1 ≤ j ∧ j < C.offset wp'1 ∨ C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize ≤ j ∧ j < C.max wp'1 → C.pelts wp'1 j = C.pelts wp' j) → (∀(o9 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o9 = true) ∧ (o9 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o10 : BitVec 32), (if o9 = true then o10 = (1 : BitVec 32) else o10 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o10) ∧ (∀(wsize' : BitVec 32), BitVec.toInt wsize' = BitVec.toInt o7 - BitVec.toInt o10 → (Z.zones mpz3 u1 = C.zone1 up' ∧ (1 : ℤ) ≤ Z.readers mpz3 u1 ∧ C.min up' = (0 : ℤ) ∧ C.max up' = C.plength up') ∧ (∀(mpz4 : Z.mpz_memo), Z.abs_value_of mpz4 = Z.abs_value_of mpz3 ∧ Z.alloc mpz4 = Z.alloc mpz3 ∧ Z.abs_size mpz4 = Z.abs_size mpz3 ∧ Z.sgn mpz4 = Z.sgn mpz3 ∧ Z.zones mpz4 = Z.zones mpz3 → Z.readers mpz4 u1 = Z.readers mpz3 u1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = u1 → Z.readers mpz4 y = Z.readers mpz3 y) → Z.mpz_eq u1 v1 = (u1 = v1) → (¬Z.mpz_eq u1 v1 → Z.mpz_unchanged v1 mpz4 mpz2) ∧ ((¬Z.mpz_eq u1 v1 → Z.readers mpz4 v1 = Z.readers mpz2 v1 ∧ (-(2 : ℤ) < Z.readers mpz4 v1 → Z.abs_value_of mpz4 v1 = Z.abs_value_of mpz2 v1 ∧ Z.alloc mpz4 v1 = Z.alloc mpz2 v1 ∧ Z.abs_size mpz4 v1 = Z.abs_size mpz2 v1 ∧ Z.sgn mpz4 v1 = Z.sgn mpz2 v1 ∧ Z.readers mpz4 v1 = Z.readers mpz2 v1 ∧ Z.zones mpz4 v1 = Z.zones mpz2 v1)) → (Z.zones mpz4 v1 = C.zone1 vp' ∧ (1 : ℤ) ≤ Z.readers mpz4 v1 ∧ C.min vp' = (0 : ℤ) ∧ C.max vp' = C.plength vp') ∧ (∀(mpz5 : Z.mpz_memo), Z.abs_value_of mpz5 = Z.abs_value_of mpz4 ∧ Z.alloc mpz5 = Z.alloc mpz4 ∧ Z.abs_size mpz5 = Z.abs_size mpz4 ∧ Z.sgn mpz5 = Z.sgn mpz4 ∧ Z.zones mpz5 = Z.zones mpz4 → Z.readers mpz5 v1 = Z.readers mpz4 v1 - (1 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = v1 → Z.readers mpz5 y = Z.readers mpz4 y) → Z.mpz_unchanged w mpz5 mpz3 ∧ (Z.readers mpz5 w = Z.readers mpz3 w ∧ (-(2 : ℤ) < Z.readers mpz5 w → Z.abs_value_of mpz5 w = Z.abs_value_of mpz3 w ∧ Z.alloc mpz5 w = Z.alloc mpz3 w ∧ Z.abs_size mpz5 w = Z.abs_size mpz3 w ∧ Z.sgn mpz5 w = Z.sgn mpz3 w ∧ Z.readers mpz5 w = Z.readers mpz3 w ∧ Z.zones mpz5 w = Z.zones mpz3 w) → (∀(o11 : Bool), (BitVec.toUInt (C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ))) = BitVec.toUInt (0 : BitVec 64) → o11 = true) ∧ (o11 = true → C.pelts wp'1 (C.offset wp'1 + BitVec.toInt usize + BitVec.toInt vsize - (1 : ℤ)) = (0 : BitVec 64)) → (∀(o12 : BitVec 32), (if o11 = true then o12 = (1 : BitVec 32) else o12 = (0 : BitVec 32)) → int'32_in_bounds (BitVec.toInt o7 - BitVec.toInt o12) ∧ (∀(o13 : BitVec 32), BitVec.toInt o13 = BitVec.toInt o7 - BitVec.toInt o12 → (BitVec.toInt sign_product < (0 : ℤ) → int'32_in_bounds (-BitVec.toInt o13)) ∧ (∀(o14 : BitVec 32), (if BitVec.toInt sign_product < (0 : ℤ) then BitVec.toInt o14 = -BitVec.toInt o13 else o14 = o13) → (C.offset wp'1 = (0 : ℤ) ∧ C.writable wp'1 = true ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz5 w ∧ (Z.readers mpz5 w = (0 : ℤ) ∨ Z.readers mpz5 w = -(1 : ℤ))) ∧ (∀(mpz6 : Z.mpz_memo), Z.alloc mpz6 = Z.alloc mpz5 ∧ Z.abs_size mpz6 = Z.abs_size mpz5 ∧ Z.sgn mpz6 = Z.sgn mpz5 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz6 mpz5) ∧ Z.abs_value_of mpz6 w = Lemmas.value wp'1 (Z.abs_size mpz6 w) ∧ Z.readers mpz6 w = -(1 : ℤ) ∧ Z.zones mpz6 w = C.zone1 wp'1 → (Z.zones mpz6 w = C.zone1 wp'1 ∧ Z.readers mpz6 w = -(1 : ℤ) ∧ C.offset wp'1 = (0 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ abs (BitVec.toInt o14) ≤ C.plength wp'1 ∧ C.plength wp'1 = Z.alloc mpz6 w ∧ (¬BitVec.toInt o14 = (0 : ℤ) → HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (abs (BitVec.toInt o14) - (1 : ℤ))) ≤ Lemmas.value wp'1 (abs (BitVec.toInt o14)))) ∧ (∀(mpz7 : Z.mpz_memo), Z.alloc mpz7 = Z.alloc mpz6 ∧ Z.readers mpz7 = Z.readers mpz6 ∧ Z.zones mpz7 = Z.zones mpz6 → (∀(y : Z.mpz_ptr), ¬y = w → Z.mpz_unchanged y mpz7 mpz6) ∧ (Z.sgn mpz7 w = (1 : ℤ)) = ((0 : ℤ) ≤ BitVec.toInt o14) ∧ (Z.sgn mpz7 w = -(1 : ℤ)) = (BitVec.toInt o14 < (0 : ℤ)) ∧ Z.abs_size mpz7 w = abs (BitVec.toInt o14) ∧ Z.abs_value_of mpz7 w = Lemmas.value wp'1 (abs (BitVec.toInt o14)) → Z.mpz_eq w w → (¬Z.mpz_eq w w → Z.mpz_unchanged w mpz7 mpz5) ∧ ((¬Z.mpz_eq w w → Z.readers mpz7 w = Z.readers mpz5 w ∧ (-(2 : ℤ) < Z.readers mpz7 w → Z.abs_value_of mpz7 w = Z.abs_value_of mpz5 w ∧ Z.alloc mpz7 w = Z.alloc mpz5 w ∧ Z.abs_size mpz7 w = Z.abs_size mpz5 w ∧ Z.sgn mpz7 w = Z.sgn mpz5 w ∧ Z.readers mpz7 w = Z.readers mpz5 w ∧ Z.zones mpz7 w = Z.zones mpz5 w)) → (Z.zones mpz7 w = C.zone1 wp'1 ∧ Z.readers mpz7 w = -(1 : ℤ) ∧ C.min wp'1 = (0 : ℤ) ∧ C.max wp'1 = C.plength wp'1 ∧ Z.abs_value_of mpz7 w = Lemmas.value wp'1 (Z.abs_size mpz7 w)) ∧ (∀(mpz8 : Z.mpz_memo), Z.abs_value_of mpz8 = Z.abs_value_of mpz7 ∧ Z.alloc mpz8 = Z.alloc mpz7 ∧ Z.abs_size mpz8 = Z.abs_size mpz7 ∧ Z.sgn mpz8 = Z.sgn mpz7 ∧ Z.zones mpz8 = Z.zones mpz7 → Z.readers mpz8 w = (0 : ℤ) ∧ (∀(y : Z.mpz_ptr), ¬y = w → Z.readers mpz8 y = Z.readers mpz7 y) → Z.mpz_eq u1 w = (u1 = w) → (¬Z.mpz_eq u1 w → Z.mpz_unchanged u1 mpz8 mpz5) ∧ ((¬Z.mpz_eq u1 w → Z.readers mpz8 u1 = Z.readers mpz5 u1 ∧ (-(2 : ℤ) < Z.readers mpz8 u1 → Z.abs_value_of mpz8 u1 = Z.abs_value_of mpz5 u1 ∧ Z.alloc mpz8 u1 = Z.alloc mpz5 u1 ∧ Z.abs_size mpz8 u1 = Z.abs_size mpz5 u1 ∧ Z.sgn mpz8 u1 = Z.sgn mpz5 u1 ∧ Z.readers mpz8 u1 = Z.readers mpz5 u1 ∧ Z.zones mpz8 u1 = Z.zones mpz5 u1)) → Z.mpz_eq v1 w = (v1 = w) → (¬Z.mpz_eq v1 w → Z.mpz_unchanged v1 mpz8 mpz5) ∧ ((¬Z.mpz_eq v1 w → Z.readers mpz8 v1 = Z.readers mpz5 v1 ∧ (-(2 : ℤ) < Z.readers mpz8 v1 → Z.abs_value_of mpz8 v1 = Z.abs_value_of mpz5 v1 ∧ Z.alloc mpz8 v1 = Z.alloc mpz5 v1 ∧ Z.abs_size mpz8 v1 = Z.abs_size mpz5 v1 ∧ Z.sgn mpz8 v1 = Z.sgn mpz5 v1 ∧ Z.readers mpz8 v1 = Z.readers mpz5 v1 ∧ Z.zones mpz8 v1 = Z.zones mpz5 v1)) → Z.mpz_eq u1 u1 → (∀(o15 : Bool), (if Z.mpz_eq u1 u1 then o15 = true else Z.mpz_eq u1 v1 = (u1 = v1) ∧ (if Z.mpz_eq u1 v1 then o15 = true else Z.mpz_eq u1 w = (u1 = w) ∧ (if Z.mpz_eq u1 w then o15 = true else o15 = (if Z.mpz_eq u1 w then true else false) ∧ (o15 = true) = (u1 = w)))) → (¬o15 = true → Z.mpz_unchanged u1 mpz8 mpz) ∧ ((¬o15 = true → Z.readers mpz8 u1 = Z.readers mpz u1 ∧ (-(2 : ℤ) < Z.readers mpz8 u1 → Z.abs_value_of mpz8 u1 = Z.abs_value_of mpz u1 ∧ Z.alloc mpz8 u1 = Z.alloc mpz u1 ∧ Z.abs_size mpz8 u1 = Z.abs_size mpz u1 ∧ Z.sgn mpz8 u1 = Z.sgn mpz u1 ∧ Z.readers mpz8 u1 = Z.readers mpz u1 ∧ Z.zones mpz8 u1 = Z.zones mpz u1)) → Z.mpz_eq v1 u1 = (v1 = u1) → (∀(o16 : Bool), (if Z.mpz_eq v1 u1 then o16 = true else Z.mpz_eq v1 v1 ∧ (if Z.mpz_eq v1 v1 then o16 = true else Z.mpz_eq v1 w = (v1 = w) ∧ (if Z.mpz_eq v1 w then o16 = true else o16 = (if Z.mpz_eq v1 w then true else false) ∧ (o16 = true) = (v1 = w)))) → (¬o16 = true → Z.mpz_unchanged v1 mpz8 mpz) ∧ ((¬o16 = true → Z.readers mpz8 v1 = Z.readers mpz v1 ∧ (-(2 : ℤ) < Z.readers mpz8 v1 → Z.abs_value_of mpz8 v1 = Z.abs_value_of mpz v1 ∧ Z.alloc mpz8 v1 = Z.alloc mpz v1 ∧ Z.abs_size mpz8 v1 = Z.abs_size mpz v1 ∧ Z.sgn mpz8 v1 = Z.sgn mpz v1 ∧ Z.readers mpz8 v1 = Z.readers mpz v1 ∧ Z.zones mpz8 v1 = Z.zones mpz v1)) → Z.mpz_unchanged w mpz8 mpz8 ∧ Z.value_of w mpz8 = Z.value_of u mpz * Z.value_of v mpz ∧ (∀(x : Z.mpz_ptr), ¬x = w → Z.mpz_unchanged x mpz8 mpz) ∧ Z.readers mpz8 w = (0 : ℤ) ∧ Z.readers mpz8 u = (0 : ℤ) ∧ Z.readers mpz8 v = (0 : ℤ)))))))))))))))))))))))))))))))))))))))))))))
  := sorry
end mpz_mul_Zmul_wmpz_mulqtvc
