import Mathlib

open Classical

namespace Lean4Why3

instance {n : Nat} : HShiftLeft (BitVec n) Int (BitVec n) where
  hShiftLeft x k := x <<< k.toNat

instance {n : Nat} : HShiftRight (BitVec n) Int (BitVec n) where
  hShiftRight x k := x >>> k.toNat

abbrev sshiftRight'i {n : ℕ} (a : BitVec n) (s : Int) : BitVec n := a.sshiftRight s.toNat

abbrev make_str_i (size : Int) := String.mk (List.replicate (Int.toNat size) 'a')
abbrev _root_.List.create_i {α} (n : ℤ) (f : ℤ -> α) := (List.range n.toNat).map f
abbrev _root_.List.create {α} (n : ℕ) (f : ℕ -> α) := (List.range n).map f

abbrev _root_.Bool.imp (a b : Bool) : Bool := !a || b

abbrev _root_.List.replicate_i {α} (n : ℤ) (x : α) := List.replicate (Int.toNat n) x

abbrev take_i {α : Type} (n : ℤ) (l : List α) := List.take n.toNat l
abbrev drop_i {α : Type} (n : ℤ) (l : List α) := List.drop n.toNat l

abbrev getElem_i! {α : Type} [Inhabited α] (l : List α) (i : Int) := l[i.toNat]!
abbrev getElem_i? {α : Type} (l : List α) (i : Int) := l[i.toNat]?

abbrev length_i {α : Type} (l : List α) := Int.ofNat l.length
abbrev slice {α : Type} (l : List α) (i j : Nat) : List α :=
  (l.drop i).take (j - i)
abbrev slice_i {α : Type} (l : List α) (i j : Int) : List α :=
  (l.drop i.toNat).take (j.toNat - i.toNat)

abbrev Sorted {α : Type} [LE α] (l : List α) := List.Sorted LE.le l
abbrev _root_.List.set_i {α : Type} (l : List α) (n : ℤ) (a : α) :=
  List.set l n.toNat a

abbrev implication (P : Prop) (Q : Prop) := P -> Q

noncomputable def map_occ {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := {n | l ≤ n ∧ n < u ∧ m n = v }.ncard
noncomputable abbrev map_occ_i {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := Int.ofNat (map_occ (v : α) (m : Int -> α) (l : Int) u)

abbrev _root_.BitVec.toUInt {n : Nat} (x : BitVec n) := Int.ofNat x.toNat

abbrev int'16_max : BitVec 16 := 32767
abbrev int'16_min : BitVec 16 := -32768
abbrev int'31_max : BitVec 31 := 1073741823
abbrev int'31_min : BitVec 31 := -1073741824
abbrev int'32_max : BitVec 32 := 2147483647
abbrev int'32_min : BitVec 32 := -2147483648
abbrev int'63_max : BitVec 63 := 4611686018427387903
abbrev int'63_min : BitVec 63 := -4611686018427387904
abbrev int'64_max : BitVec 64 := 9223372036854775807
abbrev int'64_min : BitVec 64 := -9223372036854775808
abbrev uint'16_max : BitVec 16 := 65535
abbrev uint'16_min : BitVec 16 := 0
abbrev uint'31_max : BitVec 31 := 2147483647
abbrev uint'31_min : BitVec 31 := 0
abbrev uint'32_max : BitVec 32 := 4294967295
abbrev uint'32_min : BitVec 32 := 0
abbrev uint'63_max : BitVec 63 := 9223372036854775807
abbrev uint'63_min : BitVec 63 := 0
abbrev uint'64_max : BitVec 64 := 18446744073709551615
abbrev uint'64_min : BitVec 64 := 0

abbrev int'16_in_bounds (x : Int) := int'16_min.toInt ≤ x ∧ x ≤ int'16_max.toInt
abbrev int'31_in_bounds (x : Int) := int'31_min.toInt ≤ x ∧ x ≤ int'31_max.toInt
abbrev int'32_in_bounds (x : Int) := int'32_min.toInt ≤ x ∧ x ≤ int'32_max.toInt
abbrev int'63_in_bounds (x : Int) := int'63_min.toInt ≤ x ∧ x ≤ int'63_max.toInt
abbrev int'64_in_bounds (x : Int) := int'64_min.toInt ≤ x ∧ x ≤ int'64_max.toInt
abbrev uint'8_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ 256
abbrev uint'16_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'16_max.toUInt
abbrev uint'31_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'31_max.toUInt
abbrev uint'32_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'32_max.toUInt
abbrev uint'63_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'63_max.toUInt
abbrev uint'64_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'64_max.toUInt

axiom array31 : Type -> Type
axiom array32 : Type -> Type
axiom array63 : Type -> Type

axiom array31_elts : {α : Type} -> array31 α -> Int -> α
axiom array32_elts : {α : Type} -> array32 α -> Int -> α
axiom array63_elts : {α : Type} -> array63 α -> List α

noncomputable abbrev array63_nth {α : Type} [Inhabited α] (a : array63 α) (i : Int) := (array63_elts a)[i.toNat]!

axiom array31_length : {α : Type} -> array31 α -> BitVec 31
axiom array32_length : {α : Type} -> array32 α -> BitVec 32
axiom array63_length : {α : Type} -> array63 α -> BitVec 63

abbrev is_none {α : Type} (x : Option α) := x = none
abbrev is_nil {α : Type} (x : List α) := x = []

abbrev _root_.List.rev_append {α : Type} (a : List α) (b : List α) := a.reverse ++ b
abbrev _root_.Finset.is_empty {α : Type} (s : Finset α) := s = ∅
abbrev _root_.Finset.filter' {α : Type} (s : Finset α) (p : α → Prop) [DecidablePred p] : Finset α
  := Finset.filter p s

abbrev _root_.Finset.card_i {α : Type} (s : Finset α) := Int.ofNat s.card

abbrev int_power (x : Int) (n : Int) := x ^ n.toNat
abbrev bv2_power (n : Int) := Int.ofNat (2 ^ n.toNat)

abbrev take_bit_i {n : Nat} (x : BitVec n) (i : Int) := x[i.toNat]!
abbrev take_bit_bv {n m : Nat} (x : BitVec n) (i : BitVec m) := x[i.toNat]!

noncomputable def _root_.Finset.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default
noncomputable def _root_.Set.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default

noncomputable abbrev _root_.BitVec.eq_sub {m : Nat} (a b : BitVec m) (i n : Nat) :=
  BitVec.extractLsb (i+n-1) i a = BitVec.extractLsb (i+n-1) i b

noncomputable abbrev _root_.BitVec.eq_sub_i {m : Nat} (a b : BitVec m) (i n : Int) :=
  BitVec.eq_sub a b i.toNat n.toNat

noncomputable abbrev _root_.BitVec.eq_sub_bv {m : Nat} {m1 : Nat} {m2 : Nat} (a b : BitVec m) (i : BitVec m1) (n : BitVec m2) :=
  BitVec.eq_sub a b i.toNat n.toNat

abbrev w8_size_bv := (8 : BitVec 8)
abbrev w16_size_bv := (16 : BitVec 16)
abbrev w32_size_bv := (32 : BitVec 32)
abbrev w64_size_bv := (64 : BitVec 64)
abbrev w128_size_bv := (128 : BitVec 128)
abbrev w256_size_bv := (256 : BitVec 256)
abbrev w8_size_i := (8 : Int)
abbrev w16_size_i := (16 : Int)
abbrev w32_size_i := (32 : Int)
abbrev w64_size_i := (64 : Int)
abbrev w128_size_i := (128 : Int)
abbrev w256_size_i := (256 : Int)

abbrev _root_.Finset.erase' {α : Type} [DecidableEq α] (a : α) (s : Finset α) : Finset α
  := Finset.erase s a

abbrev _root_.BitVec.sge {n : ℕ} (x y : BitVec n) := BitVec.sle y x
abbrev _root_.BitVec.sgt {n : ℕ} (x y : BitVec n) := BitVec.slt y x

abbrev _root_.BitVec.sshiftRight_i {n : ℕ} (x : BitVec n) (s : ℤ) := BitVec.sshiftRight x s.toNat
abbrev _root_.BitVec.sshiftRight_bv {n m : ℕ} (x : BitVec n) (s : BitVec m)
  := BitVec.sshiftRight x s.toNat

abbrev _root_.BitVec.rotateLeft_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateLeft x n.toNat
abbrev _root_.BitVec.rotateLeft_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateLeft x n.toNat

abbrev _root_.BitVec.rotateRight_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateRight x n.toNat
abbrev _root_.BitVec.rotateRight_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateRight x n.toNat

abbrev _root_.Multiset.count_i {α : Type} [DecidableEq α] (a : α) (s : Multiset α)
  := Int.ofNat (s.count a)

abbrev _root_.Multiset.card_i {α : Type} (S : Multiset α) := Int.ofNat S.card

abbrev _root_.Int.gcd_i (a : ℤ) (b : ℤ) := Int.ofNat (Int.gcd a b)

abbrev _root_.Int.Prime (p : ℤ) := Nat.Prime p.toNat
abbrev _root_.Int.Coprime (a b : ℤ) := Nat.Coprime a.toNat b.toNat

abbrev _root_.Set.remove {α : Type} (x : α) (A : Set α) := A \ {x}
abbrev _root_.Set.filter {α : Type} (S : Set α) (P : α -> Bool) := {x ∈ S | P x }

abbrev _root_.Option.the {α : Type} [Inhabited α] (opt : Option α) := opt.getD default

noncomputable abbrev _root_.Finmap.lookup! {K : Type} {V : Type} [Inhabited V] (m : Finmap (fun _ : K => V)) (k : K) :=
  (Finmap.lookup k m).getD default

noncomputable abbrev _root_.Finmap.mapsto {K V : Type} (k : K) (v : V) (m : Finmap (fun _ : K => V))
  := Finmap.lookup k m = some v

abbrev _root_.Finmap.is_empty {K V : Type} (m : Finmap (fun _ : K => V)) := m = ∅
abbrev _root_.Finmap.size {K V : Type} (m : Finmap (fun _ : K => V)) := m.keys.card

abbrev _root_.Finset.min'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.min with
  | ⊤        => default
  | .some a  => a

abbrev _root_.Finset.max'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.max with
  | ⊥        => default
  | .some a  => a

abbrev arrayExchange {α} [Inhabited α] (a1 a2 : List α) (i j : Int) : Prop :=
  let i' := i.toNat
  let j' := j.toNat
  a1 = (a2.set i' a1[j']!).set j' (a1[i']!)

abbrev _root_.List.permut_sub {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ (0 ≤ l ∧ l ≤ a1.length) ∧ (0 ≤ u ∧ u ≤ a1.length) ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.permut_sub' {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ slice a1 0 l = slice a2 0 l ∧
  slice a1 u a1.length = slice a2 u a1.length ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.foldr' {α β} (f : α -> β -> β) (l : List α) (x : β) := List.foldr f x l

abbrev _root_.Int.to_Real (z : ℤ) : ℝ := z

abbrev _root_.List.mem' {α} (eq : α -> α -> Bool) (x : α) (l : List α) := List.all l (eq x)

noncomputable abbrev _root_.Real.truncate (x : ℝ) : ℤ := if 0 ≤ x then Int.floor x  else Int.ceil x

alias _root_.Math.abs := abs

end Lean4Why3

open Classical
open Lean4Why3

namespace Ref
structure ref (α : Type) where
  contents : α
axiom inhabited_axiom_ref {α : Type} [Inhabited α] : Inhabited (ref α)
attribute [instance] inhabited_axiom_ref
end Ref
namespace Const
axiom const :  {α : Type} -> [Inhabited α] ->  {β : Type} -> [Inhabited β] -> β -> α -> β
axiom const'def {α : Type} {β : Type} [Inhabited α] [Inhabited β] (v : β) (x : α) : (const : β -> α -> β) v x = v
end Const
namespace MapEq
noncomputable def map_eq_sub {α : Type} [Inhabited α] (a1 : ℤ -> α) (a2 : ℤ -> α) (l : ℤ) (u : ℤ) := ∀(i : ℤ), l ≤ i ∧ i < u → a1 i = a2 i
end MapEq
namespace Unsigned
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
axiom max : ℤ
axiom to_int : t -> ℤ
noncomputable def in_bounds (n : ℤ) := (0 : ℤ) ≤ n ∧ n ≤ max
axiom to_int_in_bounds (n : t) : in_bounds (to_int n)
axiom extensionality (x : t) (y : t) (fact0 : to_int x = to_int y) : x = y
axiom zero_unsigned : t
axiom zero_unsigned_is_zero : to_int zero_unsigned = (0 : ℤ)
axiom radix : ℤ
axiom radix_def : radix = max + (1 : ℤ)
end Unsigned
namespace C
noncomputable def in_us_bounds (n : ℤ) := (0 : ℤ) ≤ n ∧ n ≤ (4294967295 : ℤ)
noncomputable def in_bounds (n : ℤ) := -(2147483648 : ℤ) ≤ n ∧ n ≤ (2147483647 : ℤ)
axiom zone : Type
axiom inhabited_axiom_zone : Inhabited zone
attribute [instance] inhabited_axiom_zone
axiom null_zone : zone
axiom ptr : Type -> Type
axiom inhabited_axiom_ptr {α : Type} [Inhabited α] : Inhabited (ptr α)
attribute [instance] inhabited_axiom_ptr
axiom data :  {α : Type} -> [Inhabited α] -> ptr α -> List α
axiom offset :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom min :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom max :  {α : Type} -> [Inhabited α] -> ptr α -> ℤ
axiom writable :  {α : Type} -> [Inhabited α] -> ptr α -> Bool
axiom zone1 :  {α : Type} -> [Inhabited α] -> ptr α -> zone
noncomputable def plength {α : Type} [Inhabited α] (p : ptr α) := Int.ofNat (List.length (data p))
noncomputable def pelts {α : Type} [Inhabited α] (p : ptr α) := getElem! (data p) ∘ Int.toNat
axiom is_not_null :  {α : Type} -> [Inhabited α] -> ptr α -> Prop
axiom is_not_null'spec {α : Type} [Inhabited α] (p : ptr α) : is_not_null p = (¬zone1 p = null_zone)
noncomputable def valid_ptr_shift {α : Type} [Inhabited α] (p : ptr α) (i : ℤ) := min p ≤ offset p + i ∧ offset p + i < max p
noncomputable def valid {α : Type} [Inhabited α] (p : ptr α) (sz : ℤ) := in_bounds sz ∧ (0 : ℤ) ≤ sz ∧ ((0 : ℤ) ≤ min p ∧ min p ≤ offset p) ∧ offset p + sz ≤ max p ∧ max p ≤ plength p
axiom valid_itv_to_shift {α : Type} [Inhabited α] (p : ptr α) (sz : ℤ) (i : ℤ) (fact0 : valid p sz) (fact1 : (0 : ℤ) ≤ i) (fact2 : i < sz) : valid_ptr_shift p i
end C
namespace Config
end Config
namespace Types
axiom limb : Type
axiom inhabited_axiom_limb : Inhabited limb
attribute [instance] inhabited_axiom_limb
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
end Types
namespace Int32Eq
end Int32Eq
namespace UInt64Eq
end UInt64Eq
namespace Lemmas
noncomputable def map_eq_sub_shift {α : Type} [Inhabited α] (x : ℤ -> α) (y : ℤ -> α) (xi : ℤ) (yi : ℤ) (sz : ℤ) := ∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < sz → x (xi + i) = y (yi + i)
axiom value_sub : (ℤ -> BitVec 64) -> ℤ -> ℤ -> ℤ
axiom value_sub'def (n : ℤ) (m : ℤ) (x : ℤ -> BitVec 64) : if n < m then value_sub x n m = BitVec.toUInt (x n) + ((18446744073709551615 : ℤ) + (1 : ℤ)) * value_sub x (n + (1 : ℤ)) m else value_sub x n m = (0 : ℤ)
noncomputable def value (x : C.ptr (BitVec 64)) (sz : ℤ) := value_sub (C.pelts x) (C.offset x) (C.offset x + sz)
end Lemmas
namespace Compare
noncomputable def compare_int (x : ℤ) (y : ℤ) := if x < y then -(1 : ℤ) else if x = y then (0 : ℤ) else (1 : ℤ)
end Compare
namespace Valuation
axiom valuation : ℤ -> ℤ -> ℤ
axiom valuation'def (p : ℤ) (n : ℤ) (fact0 : (1 : ℤ) < p) (fact1 : (1 : ℤ) ≤ n) : if Int.tmod n p = (0 : ℤ) then valuation n p = valuation (Int.tdiv n p) p + (1 : ℤ) else valuation n p = (0 : ℤ)
axiom valuation'spec'0 (p : ℤ) (n : ℤ) (fact0 : (1 : ℤ) < p) (fact1 : (1 : ℤ) ≤ n) : (0 : ℤ) ≤ valuation n p
axiom valuation'spec (p : ℤ) (n : ℤ) (fact0 : (1 : ℤ) < p) (fact1 : (1 : ℤ) ≤ n) : HPow.hPow p (Int.toNat (valuation n p)) ∣  n
end Valuation
namespace Alias
axiom mem : Type
axiom inhabited_axiom_mem : Inhabited mem
attribute [instance] inhabited_axiom_mem
axiom zr : mem -> C.zone
axiom zx : mem -> C.zone
axiom zy : mem -> C.zone
axiom mr : mem -> BitVec 32
axiom mx : mem -> BitVec 32
axiom my : mem -> BitVec 32
axiom lr : mem -> BitVec 32
axiom lx : mem -> BitVec 32
axiom ly : mem -> BitVec 32
axiom ok : mem -> Bool
noncomputable def identical (p1 : C.ptr (BitVec 64)) (p2 : C.ptr (BitVec 64)) := C.data p1 = C.data p2 ∧ C.offset p1 = C.offset p2 ∧ C.min p1 = C.min p2 ∧ C.max p1 = C.max p2 ∧ C.zone1 p1 = C.zone1 p2
end Alias
namespace Util
end Util
namespace UtilOld
end UtilOld
namespace Add
end Add
namespace AddOld
end AddOld
namespace SubOld
end SubOld
namespace Mul
end Mul
namespace Mul_basecase
end Mul_basecase
namespace LogicalUtil
end LogicalUtil
namespace Logical
end Logical
namespace LogicalOld
end LogicalOld
namespace Div
noncomputable def reciprocal (v : BitVec 64) (d : BitVec 64) := BitVec.toUInt v = (((18446744073709551615 : ℤ) + (1 : ℤ)) * ((18446744073709551615 : ℤ) + (1 : ℤ)) - (1 : ℤ)) / BitVec.toUInt d - ((18446744073709551615 : ℤ) + (1 : ℤ))
noncomputable def reciprocal_3by2 (v : BitVec 64) (dh : BitVec 64) (dl : BitVec 64) := BitVec.toUInt v = (((18446744073709551615 : ℤ) + (1 : ℤ)) * ((18446744073709551615 : ℤ) + (1 : ℤ)) * ((18446744073709551615 : ℤ) + (1 : ℤ)) - (1 : ℤ)) / (BitVec.toUInt dl + ((18446744073709551615 : ℤ) + (1 : ℤ)) * BitVec.toUInt dh) - ((18446744073709551615 : ℤ) + (1 : ℤ))
noncomputable def normalized (x : C.ptr (BitVec 64)) (sz : BitVec 32) := C.valid x (BitVec.toInt sz) ∧ ((18446744073709551615 : ℤ) + (1 : ℤ)) / (2 : ℤ) ≤ BitVec.toUInt (C.pelts x (C.offset x + BitVec.toInt sz - (1 : ℤ)))
end Div
namespace Add_1
end Add_1
namespace Sub_1
end Sub_1
namespace Toom
end Toom
namespace powm_Powm_wmpn_powmqtvc
noncomputable def redc (ur : ℤ) (u : ℤ) (n : ℤ) (m : ℤ) := ur % m = HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat n) * u % m
noncomputable def valueb (p : C.ptr (BitVec 64)) (nbits : ℤ) := if nbits < (0 : ℤ) then (0 : ℤ) else let i : ℤ := nbits / (64 : ℤ); Lemmas.value p i + HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat i) * (BitVec.toUInt (C.pelts p (C.offset p + i)) % HPow.hPow (2 : ℤ) (Int.toNat (nbits - (64 : ℤ) * i)))
lemma wmpn_powm'vc (rp : C.ptr (BitVec 64)) (n : BitVec 32) (bp : C.ptr (BitVec 64)) (bn : BitVec 32) (ep : C.ptr (BitVec 64)) (en : BitVec 32) (mp : C.ptr (BitVec 64)) (tp : C.ptr (BitVec 64)) (fact0 : C.valid rp (BitVec.toInt n)) (fact1 : C.valid bp (BitVec.toInt bn)) (fact2 : C.valid ep (BitVec.toInt en)) (fact3 : C.valid mp (BitVec.toInt n)) (fact4 : C.valid tp ((2 : ℤ) * BitVec.toInt n)) (fact5 : C.writable tp = true) (fact6 : C.writable rp = true) (fact7 : Odd (Lemmas.value mp (BitVec.toInt n))) (fact8 : (1 : ℤ) < Lemmas.value ep (BitVec.toInt en)) (fact9 : (1 : ℤ) ≤ BitVec.toInt en) (fact10 : (0 : ℤ) < BitVec.toUInt (C.pelts ep (C.offset ep + BitVec.toInt en - (1 : ℤ)))) (fact11 : (0 : ℤ) < BitVec.toUInt (C.pelts mp (C.offset mp + BitVec.toInt n - (1 : ℤ)))) (fact12 : (1 : ℤ) ≤ BitVec.toInt n) (fact13 : (1 : ℤ) ≤ BitVec.toInt bn) (fact14 : BitVec.toInt bn + BitVec.toInt n < (2147483647 : ℤ)) (fact15 : BitVec.toInt n * (512 : ℤ) ≤ (2147483647 : ℤ)) (fact16 : (64 : ℤ) * BitVec.toInt en < (2147483647 : ℤ) - (64 : ℤ)) : let vb : ℤ := Lemmas.value bp (BitVec.toInt bn); let vm : ℤ := Lemmas.value mp (BitVec.toInt n); let ve : ℤ := Lemmas.value ep (BitVec.toInt en); int'32_in_bounds (BitVec.toInt en - (1 : ℤ)) ∧ (∀(o1 : BitVec 32), BitVec.toInt o1 = BitVec.toInt en - (1 : ℤ) → (C.min ep ≤ C.offset ep + BitVec.toInt o1 ∧ C.offset ep + BitVec.toInt o1 < C.max ep) ∧ (let le : BitVec 64 := C.pelts ep (C.offset ep + BitVec.toInt o1); (0 : ℤ) < BitVec.toUInt le ∧ (∀(o2 : BitVec 32), HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o2)) * BitVec.toUInt le ≤ (18446744073709551615 : ℤ) ∧ (18446744073709551615 : ℤ) < (2 : ℤ) * HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o2)) * BitVec.toUInt le ∧ (0 : ℤ) ≤ BitVec.toInt o2 ∧ BitVec.toInt o2 < (64 : ℤ) → int'32_in_bounds ((64 : ℤ) * BitVec.toInt en) ∧ (∀(o3 : BitVec 32), BitVec.toInt o3 = (64 : ℤ) * BitVec.toInt en → int'32_in_bounds (BitVec.toInt o3 - BitVec.toInt o2) ∧ (∀(o4 : BitVec 32), BitVec.toInt o4 = BitVec.toInt o3 - BitVec.toInt o2 → (∀(windowsize : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize ≤ (10 : ℤ)) ∧ ((0 : ℤ) < BitVec.toInt o4 → (0 : ℤ) < BitVec.toInt windowsize) → (C.min mp ≤ C.offset mp ∧ C.offset mp < C.max mp) ∧ (let m0 : BitVec 64 := C.pelts mp (C.offset mp); Odd (BitVec.toUInt m0) ∧ (∀(im : BitVec 64), BitVec.toUInt im * BitVec.toUInt m0 % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (1 : ℤ) → (∀(mip : BitVec 64), BitVec.toUInt mip = -BitVec.toUInt im % ((18446744073709551615 : ℤ) + (1 : ℤ)) → (0 : ℤ) ≤ BitVec.toInt windowsize ∧ (∀(o5 : BitVec 32), BitVec.toUInt o5 = BitVec.toInt windowsize → uint'32_in_bounds (BitVec.toUInt o5 - (1 : ℤ)) ∧ (∀(o6 : BitVec 32), BitVec.toUInt o6 = BitVec.toUInt o5 - (1 : ℤ) → (0 : ℤ) ≤ BitVec.toInt n ∧ (∀(o7 : BitVec 32), BitVec.toUInt o7 = BitVec.toInt n → (((0 : ℤ) ≤ BitVec.toUInt o6 ∧ BitVec.toUInt o6 < (32 : ℤ)) ∧ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o6)) * BitVec.toUInt o7 ≤ (4294967295 : ℤ)) ∧ (∀(o8 : BitVec 32), BitVec.toUInt o8 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o6)) * BitVec.toUInt o7 → (0 : ℤ) ≤ BitVec.toUInt o8 ∧ (∀(pp : C.ptr (BitVec 64)), C.plength pp = BitVec.toUInt o8 ∧ C.offset pp = (0 : ℤ) ∧ C.min pp = (0 : ℤ) ∧ C.max pp = BitVec.toUInt o8 ∧ C.writable pp = true → (C.min pp ≤ C.offset pp + (0 : ℤ) ∧ C.offset pp + (0 : ℤ) ≤ C.max pp) ∧ (∀(o9 : C.ptr (BitVec 64)), C.offset o9 = C.offset pp + (0 : ℤ) ∧ C.plength o9 = C.plength pp ∧ C.pelts o9 = C.pelts pp ∧ C.data o9 = C.data pp ∧ C.min o9 = C.min pp ∧ C.max o9 = C.max pp ∧ C.zone1 o9 = C.zone1 pp ∧ C.writable o9 = C.writable pp → ((C.valid o9 (BitVec.toInt n) ∧ C.valid bp (BitVec.toInt bn) ∧ C.valid mp (BitVec.toInt n)) ∧ ((1 : ℤ) ≤ BitVec.toInt n ∧ (1 : ℤ) ≤ BitVec.toInt bn) ∧ BitVec.toInt bn + BitVec.toInt n < (2147483647 : ℤ) ∧ (0 : ℤ) < BitVec.toUInt (C.pelts mp (C.offset mp + BitVec.toInt n - (1 : ℤ))) ∧ C.writable o9 = true) ∧ (∀(this_pp : C.ptr (BitVec 64)) (pp1 : C.ptr (BitVec 64)), C.data this_pp = C.data pp1 ∧ List.length (C.data pp1) = List.length (C.data o9) ∧ C.offset this_pp = C.offset o9 ∧ C.min this_pp = C.min o9 ∧ C.max this_pp = C.max o9 ∧ C.writable this_pp = C.writable o9 ∧ C.zone1 this_pp = C.zone1 o9 → C.data this_pp = C.data pp1 ∧ List.length (C.data pp1) = List.length (C.data o9) ∧ C.offset this_pp = C.offset o9 ∧ C.min this_pp = C.min o9 ∧ C.max this_pp = C.max o9 ∧ C.writable this_pp = C.writable o9 ∧ C.zone1 this_pp = C.zone1 o9 → List.length (C.data pp1) = List.length (C.data pp) ∧ C.offset pp1 = C.offset pp ∧ C.min pp1 = C.min pp ∧ C.max pp1 = C.max pp ∧ C.writable pp1 = C.writable pp ∧ C.zone1 pp1 = C.zone1 pp → Lemmas.value this_pp (BitVec.toInt n) = HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value bp (BitVec.toInt bn) % Lemmas.value mp (BitVec.toInt n) ∧ redc (Lemmas.value this_pp (BitVec.toInt n)) (Lemmas.value bp (BitVec.toInt bn)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) → ((0 : ℤ) < BitVec.toInt n ∧ C.valid this_pp (BitVec.toInt n) ∧ C.valid this_pp (BitVec.toInt n) ∧ C.valid tp (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp1 : C.ptr (BitVec 64)), C.offset tp1 = C.offset tp ∧ C.writable tp1 = C.writable tp ∧ C.zone1 tp1 = C.zone1 tp → Lemmas.value tp1 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value this_pp (BitVec.toInt n) * Lemmas.value this_pp (BitVec.toInt n) ∧ C.min tp1 = C.min tp ∧ C.max tp1 = C.max tp ∧ C.plength tp1 = C.plength tp ∧ (∀(j : ℤ), C.min tp1 ≤ j ∧ j < C.offset tp1 ∨ C.offset tp1 + BitVec.toInt n + BitVec.toInt n ≤ j ∧ j < C.max tp1 → C.pelts tp1 j = C.pelts tp j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp1 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp1 = true ∧ C.writable rp = true) ∧ (∀(tp2 : C.ptr (BitVec 64)) (rp1 : C.ptr (BitVec 64)), List.length (C.data tp2) = List.length (C.data tp1) ∧ C.offset tp2 = C.offset tp1 ∧ C.min tp2 = C.min tp1 ∧ C.max tp2 = C.max tp1 ∧ C.writable tp2 = C.writable tp1 ∧ C.zone1 tp2 = C.zone1 tp1 → List.length (C.data rp1) = List.length (C.data rp) ∧ C.offset rp1 = C.offset rp ∧ C.min rp1 = C.min rp ∧ C.max rp1 = C.max rp ∧ C.writable rp1 = C.writable rp ∧ C.zone1 rp1 = C.zone1 rp → redc (Lemmas.value tp1 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp1 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp1 ∨ C.offset rp1 + BitVec.toInt n ≤ j → C.pelts rp1 j = C.pelts rp j) ∧ (Lemmas.value tp1 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp1 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → (0 : ℤ) ≤ BitVec.toInt windowsize ∧ (∀(o10 : BitVec 32), BitVec.toUInt o10 = BitVec.toInt windowsize → uint'32_in_bounds (BitVec.toUInt o10 - (1 : ℤ)) ∧ (∀(o11 : BitVec 32), BitVec.toUInt o11 = BitVec.toUInt o10 - (1 : ℤ) → (((0 : ℤ) ≤ BitVec.toUInt o11 ∧ BitVec.toUInt o11 < (32 : ℤ)) ∧ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o11)) * BitVec.toUInt (1 : BitVec 32) ≤ (4294967295 : ℤ)) ∧ (∀(o12 : BitVec 32), BitVec.toUInt o12 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o11)) * BitVec.toUInt (1 : BitVec 32) → uint'32_in_bounds (BitVec.toUInt o12 - (1 : ℤ)) ∧ (∀(o13 : BitVec 32), BitVec.toUInt o13 = BitVec.toUInt o12 - (1 : ℤ) → ((1 : ℤ) - (1 : ℤ) ≤ BitVec.toUInt o13 → ((0 : ℤ) = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) - (1 : ℤ) - BitVec.toUInt o13 ∧ (C.min pp1 = (0 : ℤ) ∧ (0 : ℤ) ≤ (0 : ℤ) * BitVec.toInt n) ∧ ((1 : ℤ) < BitVec.toInt windowsize → (1 : ℤ) < BitVec.toUInt o13 → (0 : ℤ) * BitVec.toInt n + BitVec.toInt n + BitVec.toInt n ≤ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n ∧ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n = C.max pp1) ∧ C.offset this_pp = (0 : ℤ) * BitVec.toInt n ∧ C.pelts this_pp = C.pelts pp1 ∧ C.min this_pp = C.min pp1 ∧ C.max this_pp = C.max pp1 ∧ C.plength this_pp = C.plength pp1 ∧ C.writable this_pp = true ∧ (∀(k : ℤ), (0 : ℤ) ≤ k ∧ k ≤ (0 : ℤ) → redc (Lemmas.value_sub (C.pelts pp1) (k * BitVec.toInt n) (k * BitVec.toInt n + BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * k + (1 : ℤ)))) (BitVec.toInt n) vm)) ∧ (∀(j : ℤ) (this_pp1 : C.ptr (BitVec 64)) (pp2 : C.ptr (BitVec 64)) (tp3 : C.ptr (BitVec 64)), List.length (C.data pp2) = List.length (C.data pp1) ∧ C.offset pp2 = C.offset pp1 ∧ C.min pp2 = C.min pp1 ∧ C.max pp2 = C.max pp1 ∧ C.writable pp2 = C.writable pp1 ∧ C.zone1 pp2 = C.zone1 pp1 → C.offset tp3 = C.offset tp2 ∧ C.writable tp3 = C.writable tp2 ∧ C.zone1 tp3 = C.zone1 tp2 → (∀(i : BitVec 32), let i1 : ℤ := BitVec.toUInt i; (i1 ≤ BitVec.toUInt o13 ∧ (1 : ℤ) ≤ i1) ∧ j = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) - (1 : ℤ) - i1 ∧ (C.min pp2 = (0 : ℤ) ∧ (0 : ℤ) ≤ j * BitVec.toInt n) ∧ ((1 : ℤ) < BitVec.toInt windowsize → (1 : ℤ) < i1 → j * BitVec.toInt n + BitVec.toInt n + BitVec.toInt n ≤ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n ∧ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n = C.max pp2) ∧ C.offset this_pp1 = j * BitVec.toInt n ∧ C.pelts this_pp1 = C.pelts pp2 ∧ C.min this_pp1 = C.min pp2 ∧ C.max this_pp1 = C.max pp2 ∧ C.plength this_pp1 = C.plength pp2 ∧ C.writable this_pp1 = true ∧ C.plength tp3 = C.plength tp2 ∧ C.min tp3 = C.min tp2 ∧ C.max tp3 = C.max tp2 ∧ (∀(k : ℤ), (0 : ℤ) ≤ k ∧ k ≤ j → redc (Lemmas.value_sub (C.pelts pp2) (k * BitVec.toInt n) (k * BitVec.toInt n + BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * k + (1 : ℤ)))) (BitVec.toInt n) vm) → ((0 : ℤ) < BitVec.toInt n ∧ C.valid this_pp1 (BitVec.toInt n) ∧ C.valid rp1 (BitVec.toInt n) ∧ C.valid tp3 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp3 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp4 : C.ptr (BitVec 64)), C.offset tp4 = C.offset tp3 ∧ C.writable tp4 = C.writable tp3 ∧ C.zone1 tp4 = C.zone1 tp3 → Lemmas.value tp4 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value this_pp1 (BitVec.toInt n) * Lemmas.value rp1 (BitVec.toInt n) ∧ C.min tp4 = C.min tp3 ∧ C.max tp4 = C.max tp3 ∧ C.plength tp4 = C.plength tp3 ∧ (∀(j1 : ℤ), C.min tp4 ≤ j1 ∧ j1 < C.offset tp4 ∨ C.offset tp4 + BitVec.toInt n + BitVec.toInt n ≤ j1 ∧ j1 < C.max tp4 → C.pelts tp4 j1 = C.pelts tp3 j1) → (C.min this_pp1 ≤ C.offset this_pp1 + BitVec.toInt n ∧ C.offset this_pp1 + BitVec.toInt n ≤ C.max this_pp1) ∧ (∀(o14 : C.ptr (BitVec 64)), C.offset o14 = C.offset this_pp1 + BitVec.toInt n ∧ C.plength o14 = C.plength this_pp1 ∧ C.pelts o14 = C.pelts this_pp1 ∧ C.data o14 = C.data this_pp1 ∧ C.min o14 = C.min this_pp1 ∧ C.max o14 = C.max this_pp1 ∧ C.zone1 o14 = C.zone1 this_pp1 ∧ C.writable o14 = C.writable this_pp1 → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp4 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid o14 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp4 = true ∧ C.writable o14 = true) ∧ (∀(this_pp2 : C.ptr (BitVec 64)) (pp3 : C.ptr (BitVec 64)) (tp5 : C.ptr (BitVec 64)), C.data this_pp2 = C.data pp3 ∧ List.length (C.data pp3) = List.length (C.data o14) ∧ C.offset this_pp2 = C.offset o14 ∧ C.min this_pp2 = C.min o14 ∧ C.max this_pp2 = C.max o14 ∧ C.writable this_pp2 = C.writable o14 ∧ C.zone1 this_pp2 = C.zone1 o14 → C.data this_pp2 = C.data pp3 ∧ List.length (C.data pp3) = List.length (C.data o14) ∧ C.offset this_pp2 = C.offset o14 ∧ C.min this_pp2 = C.min o14 ∧ C.max this_pp2 = C.max o14 ∧ C.writable this_pp2 = C.writable o14 ∧ C.zone1 this_pp2 = C.zone1 o14 → List.length (C.data pp3) = List.length (C.data pp2) ∧ C.offset pp3 = C.offset pp2 ∧ C.min pp3 = C.min pp2 ∧ C.max pp3 = C.max pp2 ∧ C.writable pp3 = C.writable pp2 ∧ C.zone1 pp3 = C.zone1 pp2 → List.length (C.data tp5) = List.length (C.data tp4) ∧ C.offset tp5 = C.offset tp4 ∧ C.min tp5 = C.min tp4 ∧ C.max tp5 = C.max tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → redc (Lemmas.value tp4 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value this_pp2 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset this_pp2 ∨ C.offset this_pp2 + BitVec.toInt n ≤ j1 → C.pelts this_pp2 j1 = C.pelts o14 j1) ∧ (Lemmas.value tp4 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value this_pp2 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → j + (1 : ℤ) = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) - (1 : ℤ) - (i1 - (1 : ℤ)) ∧ (C.min pp3 = (0 : ℤ) ∧ (0 : ℤ) ≤ (j + (1 : ℤ)) * BitVec.toInt n) ∧ ((1 : ℤ) < BitVec.toInt windowsize → (1 : ℤ) < i1 - (1 : ℤ) → (j + (1 : ℤ)) * BitVec.toInt n + BitVec.toInt n + BitVec.toInt n ≤ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n ∧ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n = C.max pp3) ∧ C.offset this_pp2 = (j + (1 : ℤ)) * BitVec.toInt n ∧ C.pelts this_pp2 = C.pelts pp3 ∧ C.min this_pp2 = C.min pp3 ∧ C.max this_pp2 = C.max pp3 ∧ C.plength this_pp2 = C.plength pp3 ∧ C.writable this_pp2 = true ∧ C.plength tp5 = C.plength tp2 ∧ C.min tp5 = C.min tp2 ∧ C.max tp5 = C.max tp2 ∧ (∀(k : ℤ), (0 : ℤ) ≤ k ∧ k ≤ j + (1 : ℤ) → redc (Lemmas.value_sub (C.pelts pp3) (k * BitVec.toInt n) (k * BitVec.toInt n + BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * k + (1 : ℤ)))) (BitVec.toInt n) vm))))) ∧ (j = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) - (1 : ℤ) - ((1 : ℤ) - (1 : ℤ)) ∧ (C.min pp2 = (0 : ℤ) ∧ (0 : ℤ) ≤ j * BitVec.toInt n) ∧ ((1 : ℤ) < BitVec.toInt windowsize → (1 : ℤ) < (1 : ℤ) - (1 : ℤ) → j * BitVec.toInt n + BitVec.toInt n + BitVec.toInt n ≤ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n ∧ HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize - (1 : ℤ))) * BitVec.toInt n = C.max pp2) ∧ C.offset this_pp1 = j * BitVec.toInt n ∧ C.pelts this_pp1 = C.pelts pp2 ∧ C.min this_pp1 = C.min pp2 ∧ C.max this_pp1 = C.max pp2 ∧ C.plength this_pp1 = C.plength pp2 ∧ C.writable this_pp1 = true ∧ C.plength tp3 = C.plength tp2 ∧ C.min tp3 = C.min tp2 ∧ C.max tp3 = C.max tp2 ∧ (∀(k : ℤ), (0 : ℤ) ≤ k ∧ k ≤ j → redc (Lemmas.value_sub (C.pelts pp2) (k * BitVec.toInt n) (k * BitVec.toInt n + BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * k + (1 : ℤ)))) (BitVec.toInt n) vm) → (((1 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize < (64 : ℤ)) ∧ (0 : ℤ) ≤ BitVec.toInt o4 ∧ (1 : ℤ) ≤ BitVec.toInt en ∧ C.valid ep (BitVec.toInt en) ∧ (BitVec.toInt o4 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o14 : BitVec 64), (BitVec.toInt windowsize ≤ BitVec.toInt o4 → valueb ep (BitVec.toInt o4) = valueb ep (BitVec.toInt o4 - BitVec.toInt windowsize) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o4 - BitVec.toInt windowsize)) * BitVec.toUInt o14) ∧ (BitVec.toInt o4 < BitVec.toInt windowsize → valueb ep (BitVec.toInt o4) = BitVec.toUInt o14) ∧ ((0 : ℤ) ≤ BitVec.toUInt o14 ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ BitVec.toUInt o14 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o4 - BitVec.toInt windowsize)) % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (if BitVec.toInt o4 < BitVec.toInt windowsize then ve = valueb ep (BitVec.toInt (0 : BitVec 32)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt (0 : BitVec 32))) * BitVec.toUInt o14 ∧ ((0 : ℤ) ≤ BitVec.toInt (0 : BitVec 32) ∧ BitVec.toInt (0 : BitVec 32) ≤ BitVec.toInt o4) ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) else int'32_in_bounds (BitVec.toInt o4 - BitVec.toInt windowsize) ∧ (∀(o15 : BitVec 32), BitVec.toInt o15 = BitVec.toInt o4 - BitVec.toInt windowsize → ve = valueb ep (BitVec.toInt o15) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o15)) * BitVec.toUInt o14 ∧ ((0 : ℤ) ≤ BitVec.toInt o15 ∧ BitVec.toInt o15 ≤ BitVec.toInt o4) ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)))) ∧ (∀(ebi : BitVec 32), ve = valueb ep (BitVec.toInt ebi) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi)) * BitVec.toUInt o14 ∧ ((0 : ℤ) ≤ BitVec.toInt ebi ∧ BitVec.toInt ebi ≤ BitVec.toInt o4) ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (0 : ℤ) < BitVec.toUInt o14 ∧ (∀(o15 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt o15 ∧ BitVec.toInt o15 < (64 : ℤ)) ∧ BitVec.toUInt o14 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o15)) = (0 : ℤ) ∧ ¬BitVec.toUInt o14 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o15 + (1 : ℤ))) = (0 : ℤ) → int'32_in_bounds (BitVec.toInt ebi + BitVec.toInt o15) ∧ (∀(o16 : BitVec 32), BitVec.toInt o16 = BitVec.toInt ebi + BitVec.toInt o15 → (0 : ℤ) ≤ BitVec.toInt o15 ∧ (∀(o17 : BitVec 64), BitVec.toUInt o17 = BitVec.toInt o15 → (((0 : ℤ) ≤ BitVec.toUInt o17 ∧ BitVec.toUInt o17 < (64 : ℤ)) ∧ BitVec.toUInt o14 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o17)) = (0 : ℤ)) ∧ (∀(o18 : BitVec 64), BitVec.toUInt o14 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o17)) * BitVec.toUInt o18 → ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < (64 : ℤ)) ∧ (∀(o19 : BitVec 64), BitVec.toUInt o19 = BitVec.toUInt o18 / HPow.hPow (2 : ℤ) (1 : ℕ) → BitVec.toUInt o19 ≤ (2147483647 : ℤ) ∧ (∀(ebh : BitVec 32), BitVec.toInt ebh = BitVec.toUInt o19 → int'32_in_bounds (BitVec.toInt n * BitVec.toInt ebh) ∧ (∀(o20 : BitVec 32), BitVec.toInt o20 = BitVec.toInt n * BitVec.toInt ebh → (C.min pp2 ≤ C.offset pp2 + BitVec.toInt o20 ∧ C.offset pp2 + BitVec.toInt o20 ≤ C.max pp2) ∧ (∀(ppn : C.ptr (BitVec 64)), C.offset ppn = C.offset pp2 + BitVec.toInt o20 ∧ C.plength ppn = C.plength pp2 ∧ C.pelts ppn = C.pelts pp2 ∧ C.data ppn = C.data pp2 ∧ C.min ppn = C.min pp2 ∧ C.max ppn = C.max pp2 ∧ C.zone1 ppn = C.zone1 pp2 ∧ C.writable ppn = C.writable pp2 → (C.valid ppn (BitVec.toInt n) ∧ C.valid rp1 (BitVec.toInt n) ∧ C.writable rp1 = true) ∧ (∀(rp2 : C.ptr (BitVec 64)), List.length (C.data rp2) = List.length (C.data rp1) ∧ C.offset rp2 = C.offset rp1 ∧ C.min rp2 = C.min rp1 ∧ C.max rp2 = C.max rp1 ∧ C.writable rp2 = C.writable rp1 ∧ C.zone1 rp2 = C.zone1 rp1 → Lemmas.map_eq_sub_shift (C.pelts rp2) (C.pelts ppn) (C.offset rp2) (C.offset ppn) (BitVec.toInt n) ∧ (∀(j1 : ℤ), j1 < C.offset rp2 ∨ C.offset rp2 + BitVec.toInt n ≤ j1 → C.pelts rp2 j1 = C.pelts rp1 j1) → (let o21 : ℤ := BitVec.toUInt o18; (((0 : ℤ) ≤ BitVec.toInt o16 ∧ BitVec.toInt o16 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ o21 ∧ (BitVec.toInt o16 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp2 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat o21)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o16) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o16)) * o21 ∧ C.plength tp3 = C.plength tp2 ∧ C.min tp3 = C.min tp2 ∧ C.max tp3 = C.max tp2) ∧ (∀(expdone : ℤ) (ebi1 : BitVec 32) (tp4 : C.ptr (BitVec 64)) (rp3 : C.ptr (BitVec 64)), C.offset tp4 = C.offset tp3 ∧ C.writable tp4 = C.writable tp3 ∧ C.zone1 tp4 = C.zone1 tp3 → List.length (C.data rp3) = List.length (C.data rp2) ∧ C.offset rp3 = C.offset rp2 ∧ C.min rp3 = C.min rp2 ∧ C.max rp3 = C.max rp2 ∧ C.writable rp3 = C.writable rp2 ∧ C.zone1 rp3 = C.zone1 rp2 → ((0 : ℤ) ≤ BitVec.toInt ebi1 ∧ BitVec.toInt ebi1 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ expdone ∧ (BitVec.toInt ebi1 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp3 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt ebi1) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi1)) * expdone ∧ C.plength tp4 = C.plength tp2 ∧ C.min tp4 = C.min tp2 ∧ C.max tp4 = C.max tp2 → (∀(o22 : Bool), (BitVec.toInt ebi1 = BitVec.toInt (0 : BitVec 32) → o22 = true) ∧ (o22 = true → ebi1 = (0 : BitVec 32)) → (if ¬o22 = true then (((1 : ℤ) ≤ BitVec.toInt ebi1 ∧ BitVec.toInt ebi1 ≤ BitVec.toInt ebi1) ∧ (0 : ℤ) ≤ expdone ∧ (BitVec.toInt ebi1 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp3 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt ebi1) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi1)) * expdone ∧ C.plength tp4 = C.plength tp2 ∧ C.min tp4 = C.min tp2 ∧ C.max tp4 = C.max tp2) ∧ (∀(expdone1 : ℤ) (ebi2 : BitVec 32) (tp5 : C.ptr (BitVec 64)) (rp4 : C.ptr (BitVec 64)), C.offset tp5 = C.offset tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → List.length (C.data rp4) = List.length (C.data rp3) ∧ C.offset rp4 = C.offset rp3 ∧ C.min rp4 = C.min rp3 ∧ C.max rp4 = C.max rp3 ∧ C.writable rp4 = C.writable rp3 ∧ C.zone1 rp4 = C.zone1 rp3 → ((1 : ℤ) ≤ BitVec.toInt ebi2 ∧ BitVec.toInt ebi2 ≤ BitVec.toInt ebi1) ∧ (0 : ℤ) ≤ expdone1 ∧ (BitVec.toInt ebi2 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp4 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone1)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt ebi2) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2)) * expdone1 ∧ C.plength tp5 = C.plength tp2 ∧ C.min tp5 = C.min tp2 ∧ C.max tp5 = C.max tp2 → (C.valid ep (BitVec.toInt en) ∧ (1 : ℤ) ≤ BitVec.toInt ebi2 ∧ (BitVec.toInt ebi2 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o23 : BitVec 64), ((0 : ℤ) ≤ BitVec.toUInt o23 ∧ BitVec.toUInt o23 ≤ (1 : ℤ)) ∧ BitVec.toUInt o23 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - (1 : ℤ))) % (2 : ℤ) ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt ebi2 - (1 : ℤ)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - (1 : ℤ))) * BitVec.toUInt o23 → (∀(o24 : Bool), (BitVec.toUInt o23 = BitVec.toUInt (0 : BitVec 64) → o24 = true) ∧ (o24 = true → o23 = (0 : BitVec 64)) → (if o24 = true then ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp4 (BitVec.toInt n) ∧ C.valid rp4 (BitVec.toInt n) ∧ C.valid tp5 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp5 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp6 : C.ptr (BitVec 64)), C.offset tp6 = C.offset tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → Lemmas.value tp6 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp4 (BitVec.toInt n) * Lemmas.value rp4 (BitVec.toInt n) ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.plength tp6 = C.plength tp5 ∧ (∀(j1 : ℤ), C.min tp6 ≤ j1 ∧ j1 < C.offset tp6 ∨ C.offset tp6 + BitVec.toInt n + BitVec.toInt n ≤ j1 ∧ j1 < C.max tp6 → C.pelts tp6 j1 = C.pelts tp5 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp6 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp4 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp6 = true ∧ C.writable rp4 = true) ∧ (∀(tp7 : C.ptr (BitVec 64)) (rp5 : C.ptr (BitVec 64)), List.length (C.data tp7) = List.length (C.data tp6) ∧ C.offset tp7 = C.offset tp6 ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → redc (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp5 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp5 ∨ C.offset rp5 + BitVec.toInt n ≤ j1 → C.pelts rp5 j1 = C.pelts rp4 j1) ∧ (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp5 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → int'32_in_bounds (BitVec.toInt ebi2 - (1 : ℤ)) ∧ (∀(o25 : BitVec 32), BitVec.toInt o25 = BitVec.toInt ebi2 - (1 : ℤ) → (∀(o26 : Bool), (BitVec.toInt o25 = BitVec.toInt (0 : BitVec 32) → o26 = true) ∧ (o26 = true → o25 = (0 : BitVec 32)) → (if o26 = true then ∀(o27 : Bool), (BitVec.toInt o25 = BitVec.toInt (0 : BitVec 32) → o27 = true) ∧ (o27 = true → o25 = (0 : BitVec 32)) → (if o27 = true then (C.valid rp5 (BitVec.toInt n) ∧ C.valid tp7 (BitVec.toInt n) ∧ C.writable tp7 = true) ∧ (∀(tp8 : C.ptr (BitVec 64)), List.length (C.data tp8) = List.length (C.data tp7) ∧ C.offset tp8 = C.offset tp7 ∧ C.min tp8 = C.min tp7 ∧ C.max tp8 = C.max tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → Lemmas.map_eq_sub_shift (C.pelts tp8) (C.pelts rp5) (C.offset tp8) (C.offset rp5) (BitVec.toInt n) ∧ (∀(j1 : ℤ), j1 < C.offset tp8 ∨ C.offset tp8 + BitVec.toInt n ≤ j1 → C.pelts tp8 j1 = C.pelts tp7 j1) → (C.min tp8 ≤ C.offset tp8 + BitVec.toInt n ∧ C.offset tp8 + BitVec.toInt n ≤ C.max tp8) ∧ (∀(o28 : C.ptr (BitVec 64)), C.offset o28 = C.offset tp8 + BitVec.toInt n ∧ C.plength o28 = C.plength tp8 ∧ C.pelts o28 = C.pelts tp8 ∧ C.data o28 = C.data tp8 ∧ C.min o28 = C.min tp8 ∧ C.max o28 = C.max tp8 ∧ C.zone1 o28 = C.zone1 tp8 ∧ C.writable o28 = C.writable tp8 → (C.valid o28 (BitVec.toInt n) ∧ C.writable o28 = true) ∧ (∀(o29 : C.ptr (BitVec 64)) (tp9 : C.ptr (BitVec 64)), C.data o29 = C.data tp9 ∧ List.length (C.data tp9) = List.length (C.data o28) ∧ C.offset o29 = C.offset o28 ∧ C.min o29 = C.min o28 ∧ C.max o29 = C.max o28 ∧ C.writable o29 = C.writable o28 ∧ C.zone1 o29 = C.zone1 o28 → List.length (C.data tp9) = List.length (C.data tp8) ∧ C.offset tp9 = C.offset tp8 ∧ C.min tp9 = C.min tp8 ∧ C.max tp9 = C.max tp8 ∧ C.writable tp9 = C.writable tp8 ∧ C.zone1 tp9 = C.zone1 tp8 → Lemmas.value o29 (BitVec.toInt n) = (0 : ℤ) ∧ (∀(j1 : ℤ), j1 < C.offset o29 ∨ C.offset o29 + BitVec.toInt n ≤ j1 → C.pelts o29 j1 = C.pelts o28 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp9 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp9 = true ∧ C.writable rp5 = true) ∧ (∀(rp6 : C.ptr (BitVec 64)), List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → redc (Lemmas.value tp9 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp6 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j1 → C.pelts rp6 j1 = C.pelts rp5 j1) ∧ (Lemmas.value tp9 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp6 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → ((C.valid rp6 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n)) ∧ (∀(o30 : BitVec 32), BitVec.toInt o30 = Compare.compare_int (Lemmas.value rp6 (BitVec.toInt n)) (Lemmas.value mp (BitVec.toInt n)) → (if (0 : ℤ) ≤ BitVec.toInt o30 then ((0 : ℤ) ≤ BitVec.toInt n ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n) ∧ C.writable rp6 = true) ∧ (∀(rp7 : C.ptr (BitVec 64)), List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → (∀(x_b : BitVec 64), Lemmas.value rp7 (BitVec.toInt n) - HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * BitVec.toUInt x_b = Lemmas.value rp6 (BitVec.toInt n) - Lemmas.value mp (BitVec.toInt n) ∧ ((0 : ℤ) ≤ BitVec.toUInt x_b ∧ BitVec.toUInt x_b ≤ (1 : ℤ)) ∧ (∀(j1 : ℤ), j1 < C.offset rp7 ∨ C.offset rp7 + BitVec.toInt n ≤ j1 → C.pelts rp7 j1 = C.pelts rp6 j1) → Lemmas.value rp7 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp7 (BitVec.toInt n) < vm)) else Lemmas.value rp6 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp6 (BitVec.toInt n) < vm))) ∧ (∀(rp7 : C.ptr (BitVec 64)), List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → Lemmas.value rp7 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp7 (BitVec.toInt n) < vm → Lemmas.value rp7 (BitVec.toInt n) = HPow.hPow (Lemmas.value bp (BitVec.toInt bn)) (Int.toNat (Lemmas.value ep (BitVec.toInt en))) % Lemmas.value mp (BitVec.toInt n)))))) else (((1 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize < (64 : ℤ)) ∧ (0 : ℤ) ≤ BitVec.toInt o25 ∧ (1 : ℤ) ≤ BitVec.toInt en ∧ C.valid ep (BitVec.toInt en) ∧ (BitVec.toInt o25 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o28 : BitVec 64), (BitVec.toInt windowsize ≤ BitVec.toInt o25 → valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt o25 - BitVec.toInt windowsize) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o25 - BitVec.toInt windowsize)) * BitVec.toUInt o28) ∧ (BitVec.toInt o25 < BitVec.toInt windowsize → valueb ep (BitVec.toInt o25) = BitVec.toUInt o28) ∧ ((0 : ℤ) ≤ BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ BitVec.toUInt o28 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o25 - BitVec.toInt windowsize)) % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (if BitVec.toInt o25 < BitVec.toInt windowsize then int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt o25) ∧ (∀(o29 : BitVec 32), BitVec.toInt o29 = BitVec.toInt windowsize - BitVec.toInt o25 → int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt o29) ∧ (∀(o30 : BitVec 32), BitVec.toInt o30 = BitVec.toInt windowsize - BitVec.toInt o29 → ((0 : ℤ) ≤ BitVec.toInt (0 : BitVec 32) ∧ BitVec.toInt (0 : BitVec 32) < BitVec.toInt o25) ∧ BitVec.toInt (0 : BitVec 32) + BitVec.toInt o30 = BitVec.toInt o25 ∧ valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt (0 : BitVec 32)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt (0 : BitVec 32))) * BitVec.toUInt o28 ∧ ((0 : ℤ) < BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o30))) ∧ (0 : ℤ) < BitVec.toInt o30 ∧ BitVec.toInt o30 ≤ BitVec.toInt windowsize)) else int'32_in_bounds (BitVec.toInt o25 - BitVec.toInt windowsize) ∧ (∀(o29 : BitVec 32), BitVec.toInt o29 = BitVec.toInt o25 - BitVec.toInt windowsize → ((0 : ℤ) ≤ BitVec.toInt o29 ∧ BitVec.toInt o29 < BitVec.toInt o25) ∧ BitVec.toInt o29 + BitVec.toInt windowsize = BitVec.toInt o25 ∧ valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * BitVec.toUInt o28 ∧ ((0 : ℤ) < BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ (0 : ℤ) < BitVec.toInt windowsize ∧ BitVec.toInt windowsize ≤ BitVec.toInt windowsize)) ∧ (∀(this_windowsize : BitVec 32) (ebi3 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt ebi3 ∧ BitVec.toInt ebi3 < BitVec.toInt o25) ∧ BitVec.toInt ebi3 + BitVec.toInt this_windowsize = BitVec.toInt o25 ∧ valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt ebi3) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi3)) * BitVec.toUInt o28 ∧ ((0 : ℤ) < BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize))) ∧ (0 : ℤ) < BitVec.toInt this_windowsize ∧ BitVec.toInt this_windowsize ≤ BitVec.toInt windowsize → (0 : ℤ) < BitVec.toUInt o28 ∧ (∀(o29 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt o29 ∧ BitVec.toInt o29 < (64 : ℤ)) ∧ BitVec.toUInt o28 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) = (0 : ℤ) ∧ ¬BitVec.toUInt o28 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29 + (1 : ℤ))) = (0 : ℤ) → int'32_in_bounds (BitVec.toInt this_windowsize - BitVec.toInt o29) ∧ (∀(o30 : BitVec 32), BitVec.toInt o30 = BitVec.toInt this_windowsize - BitVec.toInt o29 → int'32_in_bounds (BitVec.toInt ebi3 + BitVec.toInt o29) ∧ (∀(o31 : BitVec 32), BitVec.toInt o31 = BitVec.toInt ebi3 + BitVec.toInt o29 → (0 : ℤ) ≤ BitVec.toInt o29 ∧ (∀(o32 : BitVec 64), BitVec.toUInt o32 = BitVec.toInt o29 → (((0 : ℤ) ≤ BitVec.toUInt o32 ∧ BitVec.toUInt o32 < (64 : ℤ)) ∧ BitVec.toUInt o28 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o32)) = (0 : ℤ)) ∧ (∀(o33 : BitVec 64), BitVec.toUInt o28 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o32)) * BitVec.toUInt o33 → (((0 : ℤ) ≤ BitVec.toInt o30 ∧ BitVec.toInt o30 ≤ BitVec.toInt o30) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone1 ∧ redc (Lemmas.value rp5 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone1))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (BitVec.toUInt o33 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o30)) * ((2 : ℤ) * expdone1)) ∧ C.plength tp7 = C.plength tp2 ∧ C.min tp7 = C.min tp2 ∧ C.max tp7 = C.max tp2) ∧ (∀(this_windowsize1 : BitVec 32) (expdone2 : ℤ) (tp8 : C.ptr (BitVec 64)) (rp6 : C.ptr (BitVec 64)), C.offset tp8 = C.offset tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → ((0 : ℤ) ≤ BitVec.toInt this_windowsize1 ∧ BitVec.toInt this_windowsize1 ≤ BitVec.toInt o30) ∧ (0 : ℤ) ≤ expdone2 ∧ redc (Lemmas.value rp6 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone2)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (BitVec.toUInt o33 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize1)) * expdone2) ∧ C.plength tp8 = C.plength tp2 ∧ C.min tp8 = C.min tp2 ∧ C.max tp8 = C.max tp2 → (∀(o34 : Bool), (BitVec.toInt this_windowsize1 = BitVec.toInt (0 : BitVec 32) → o34 = true) ∧ (o34 = true → this_windowsize1 = (0 : BitVec 32)) → (if ¬o34 = true then ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid tp8 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp8 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp9 : C.ptr (BitVec 64)), C.offset tp9 = C.offset tp8 ∧ C.writable tp9 = C.writable tp8 ∧ C.zone1 tp9 = C.zone1 tp8 → Lemmas.value tp9 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp6 (BitVec.toInt n) * Lemmas.value rp6 (BitVec.toInt n) ∧ C.min tp9 = C.min tp8 ∧ C.max tp9 = C.max tp8 ∧ C.plength tp9 = C.plength tp8 ∧ (∀(j1 : ℤ), C.min tp9 ≤ j1 ∧ j1 < C.offset tp9 ∨ C.offset tp9 + BitVec.toInt n + BitVec.toInt n ≤ j1 ∧ j1 < C.max tp9 → C.pelts tp9 j1 = C.pelts tp8 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp9 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp6 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp9 = true ∧ C.writable rp6 = true) ∧ (∀(tp10 : C.ptr (BitVec 64)) (rp7 : C.ptr (BitVec 64)), List.length (C.data tp10) = List.length (C.data tp9) ∧ C.offset tp10 = C.offset tp9 ∧ C.min tp10 = C.min tp9 ∧ C.max tp10 = C.max tp9 ∧ C.writable tp10 = C.writable tp9 ∧ C.zone1 tp10 = C.zone1 tp9 → List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → redc (Lemmas.value tp9 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp7 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp7 ∨ C.offset rp7 + BitVec.toInt n ≤ j1 → C.pelts rp7 j1 = C.pelts rp6 j1) ∧ (Lemmas.value tp9 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp7 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → int'32_in_bounds (BitVec.toInt this_windowsize1 - (1 : ℤ)) ∧ (∀(o35 : BitVec 32), BitVec.toInt o35 = BitVec.toInt this_windowsize1 - (1 : ℤ) → BitVec.toInt o35 < BitVec.toInt this_windowsize1 ∧ ((0 : ℤ) ≤ BitVec.toInt o35 ∧ BitVec.toInt o35 ≤ BitVec.toInt o30) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone2 ∧ redc (Lemmas.value rp7 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone2))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (BitVec.toUInt o33 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o35)) * ((2 : ℤ) * expdone2)) ∧ C.plength tp10 = C.plength tp2 ∧ C.min tp10 = C.min tp2 ∧ C.max tp10 = C.max tp2))) else ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < (64 : ℤ)) ∧ (∀(o35 : BitVec 64), BitVec.toUInt o35 = BitVec.toUInt o33 / HPow.hPow (2 : ℤ) (1 : ℕ) → BitVec.toUInt o35 ≤ (2147483647 : ℤ) ∧ (∀(ebh1 : BitVec 32), BitVec.toInt ebh1 = BitVec.toUInt o35 → int'32_in_bounds (BitVec.toInt n * BitVec.toInt ebh1) ∧ (∀(o36 : BitVec 32), BitVec.toInt o36 = BitVec.toInt n * BitVec.toInt ebh1 → (C.min pp2 ≤ C.offset pp2 + BitVec.toInt o36 ∧ C.offset pp2 + BitVec.toInt o36 ≤ C.max pp2) ∧ (∀(ppn1 : C.ptr (BitVec 64)), C.offset ppn1 = C.offset pp2 + BitVec.toInt o36 ∧ C.plength ppn1 = C.plength pp2 ∧ C.pelts ppn1 = C.pelts pp2 ∧ C.data ppn1 = C.data pp2 ∧ C.min ppn1 = C.min pp2 ∧ C.max ppn1 = C.max pp2 ∧ C.zone1 ppn1 = C.zone1 pp2 ∧ C.writable ppn1 = C.writable pp2 → ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid ppn1 (BitVec.toInt n) ∧ C.valid tp8 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp8 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp9 : C.ptr (BitVec 64)), C.offset tp9 = C.offset tp8 ∧ C.writable tp9 = C.writable tp8 ∧ C.zone1 tp9 = C.zone1 tp8 → Lemmas.value tp9 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp6 (BitVec.toInt n) * Lemmas.value ppn1 (BitVec.toInt n) ∧ C.min tp9 = C.min tp8 ∧ C.max tp9 = C.max tp8 ∧ C.plength tp9 = C.plength tp8 ∧ (∀(j1 : ℤ), C.min tp9 ≤ j1 ∧ j1 < C.offset tp9 ∨ C.offset tp9 + BitVec.toInt n + BitVec.toInt n ≤ j1 ∧ j1 < C.max tp9 → C.pelts tp9 j1 = C.pelts tp8 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp9 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp6 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp9 = true ∧ C.writable rp6 = true) ∧ (∀(tp10 : C.ptr (BitVec 64)) (rp7 : C.ptr (BitVec 64)), List.length (C.data tp10) = List.length (C.data tp9) ∧ C.offset tp10 = C.offset tp9 ∧ C.min tp10 = C.min tp9 ∧ C.max tp10 = C.max tp9 ∧ C.writable tp10 = C.writable tp9 ∧ C.zone1 tp10 = C.zone1 tp9 → List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → redc (Lemmas.value tp9 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp7 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp7 ∨ C.offset rp7 + BitVec.toInt n ≤ j1 → C.pelts rp7 j1 = C.pelts rp6 j1) ∧ (Lemmas.value tp9 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp7 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → BitVec.toInt o31 < BitVec.toInt ebi1 ∧ ((0 : ℤ) ≤ BitVec.toInt o31 ∧ BitVec.toInt o31 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ expdone2 + BitVec.toUInt o33 ∧ (BitVec.toInt o31 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp7 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat (expdone2 + BitVec.toUInt o33))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (expdone2 + BitVec.toUInt o33) ∧ C.plength tp10 = C.plength tp2 ∧ C.min tp10 = C.min tp2 ∧ C.max tp10 = C.max tp2))))))))))))))))) else BitVec.toInt o25 < BitVec.toInt ebi2 ∧ ((1 : ℤ) ≤ BitVec.toInt o25 ∧ BitVec.toInt o25 ≤ BitVec.toInt ebi1) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone1 ∧ (BitVec.toInt o25 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp5 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone1))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o25) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o25)) * ((2 : ℤ) * expdone1) ∧ C.plength tp7 = C.plength tp2 ∧ C.min tp7 = C.min tp2 ∧ C.max tp7 = C.max tp2))))) else ∀(o25 : Bool), (BitVec.toInt ebi2 = BitVec.toInt (0 : BitVec 32) → o25 = true) ∧ (o25 = true → ebi2 = (0 : BitVec 32)) → (if o25 = true then (C.valid rp4 (BitVec.toInt n) ∧ C.valid tp5 (BitVec.toInt n) ∧ C.writable tp5 = true) ∧ (∀(tp6 : C.ptr (BitVec 64)), List.length (C.data tp6) = List.length (C.data tp5) ∧ C.offset tp6 = C.offset tp5 ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → Lemmas.map_eq_sub_shift (C.pelts tp6) (C.pelts rp4) (C.offset tp6) (C.offset rp4) (BitVec.toInt n) ∧ (∀(j1 : ℤ), j1 < C.offset tp6 ∨ C.offset tp6 + BitVec.toInt n ≤ j1 → C.pelts tp6 j1 = C.pelts tp5 j1) → (C.min tp6 ≤ C.offset tp6 + BitVec.toInt n ∧ C.offset tp6 + BitVec.toInt n ≤ C.max tp6) ∧ (∀(o26 : C.ptr (BitVec 64)), C.offset o26 = C.offset tp6 + BitVec.toInt n ∧ C.plength o26 = C.plength tp6 ∧ C.pelts o26 = C.pelts tp6 ∧ C.data o26 = C.data tp6 ∧ C.min o26 = C.min tp6 ∧ C.max o26 = C.max tp6 ∧ C.zone1 o26 = C.zone1 tp6 ∧ C.writable o26 = C.writable tp6 → (C.valid o26 (BitVec.toInt n) ∧ C.writable o26 = true) ∧ (∀(o27 : C.ptr (BitVec 64)) (tp7 : C.ptr (BitVec 64)), C.data o27 = C.data tp7 ∧ List.length (C.data tp7) = List.length (C.data o26) ∧ C.offset o27 = C.offset o26 ∧ C.min o27 = C.min o26 ∧ C.max o27 = C.max o26 ∧ C.writable o27 = C.writable o26 ∧ C.zone1 o27 = C.zone1 o26 → List.length (C.data tp7) = List.length (C.data tp6) ∧ C.offset tp7 = C.offset tp6 ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → Lemmas.value o27 (BitVec.toInt n) = (0 : ℤ) ∧ (∀(j1 : ℤ), j1 < C.offset o27 ∨ C.offset o27 + BitVec.toInt n ≤ j1 → C.pelts o27 j1 = C.pelts o26 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp7 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp4 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp7 = true ∧ C.writable rp4 = true) ∧ (∀(rp5 : C.ptr (BitVec 64)), List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → redc (Lemmas.value tp7 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp5 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp5 ∨ C.offset rp5 + BitVec.toInt n ≤ j1 → C.pelts rp5 j1 = C.pelts rp4 j1) ∧ (Lemmas.value tp7 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp5 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → ((C.valid rp5 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n)) ∧ (∀(o28 : BitVec 32), BitVec.toInt o28 = Compare.compare_int (Lemmas.value rp5 (BitVec.toInt n)) (Lemmas.value mp (BitVec.toInt n)) → (if (0 : ℤ) ≤ BitVec.toInt o28 then ((0 : ℤ) ≤ BitVec.toInt n ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n) ∧ C.writable rp5 = true) ∧ (∀(rp6 : C.ptr (BitVec 64)), List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → (∀(x_b : BitVec 64), Lemmas.value rp6 (BitVec.toInt n) - HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * BitVec.toUInt x_b = Lemmas.value rp5 (BitVec.toInt n) - Lemmas.value mp (BitVec.toInt n) ∧ ((0 : ℤ) ≤ BitVec.toUInt x_b ∧ BitVec.toUInt x_b ≤ (1 : ℤ)) ∧ (∀(j1 : ℤ), j1 < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j1 → C.pelts rp6 j1 = C.pelts rp5 j1) → Lemmas.value rp6 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp6 (BitVec.toInt n) < vm)) else Lemmas.value rp5 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp5 (BitVec.toInt n) < vm))) ∧ (∀(rp6 : C.ptr (BitVec 64)), List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → Lemmas.value rp6 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp6 (BitVec.toInt n) < vm → Lemmas.value rp6 (BitVec.toInt n) = HPow.hPow (Lemmas.value bp (BitVec.toInt bn)) (Int.toNat (Lemmas.value ep (BitVec.toInt en))) % Lemmas.value mp (BitVec.toInt n)))))) else (((1 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize < (64 : ℤ)) ∧ (0 : ℤ) ≤ BitVec.toInt ebi2 ∧ (1 : ℤ) ≤ BitVec.toInt en ∧ C.valid ep (BitVec.toInt en) ∧ (BitVec.toInt ebi2 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o26 : BitVec 64), (BitVec.toInt windowsize ≤ BitVec.toInt ebi2 → valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt ebi2 - BitVec.toInt windowsize) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - BitVec.toInt windowsize)) * BitVec.toUInt o26) ∧ (BitVec.toInt ebi2 < BitVec.toInt windowsize → valueb ep (BitVec.toInt ebi2) = BitVec.toUInt o26) ∧ ((0 : ℤ) ≤ BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ BitVec.toUInt o26 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - BitVec.toInt windowsize)) % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (if BitVec.toInt ebi2 < BitVec.toInt windowsize then int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt ebi2) ∧ (∀(o27 : BitVec 32), BitVec.toInt o27 = BitVec.toInt windowsize - BitVec.toInt ebi2 → int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt o27) ∧ (∀(o28 : BitVec 32), BitVec.toInt o28 = BitVec.toInt windowsize - BitVec.toInt o27 → ((0 : ℤ) ≤ BitVec.toInt (0 : BitVec 32) ∧ BitVec.toInt (0 : BitVec 32) < BitVec.toInt ebi2) ∧ BitVec.toInt (0 : BitVec 32) + BitVec.toInt o28 = BitVec.toInt ebi2 ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt (0 : BitVec 32)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt (0 : BitVec 32))) * BitVec.toUInt o26 ∧ ((0 : ℤ) < BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o28))) ∧ (0 : ℤ) < BitVec.toInt o28 ∧ BitVec.toInt o28 ≤ BitVec.toInt windowsize)) else int'32_in_bounds (BitVec.toInt ebi2 - BitVec.toInt windowsize) ∧ (∀(o27 : BitVec 32), BitVec.toInt o27 = BitVec.toInt ebi2 - BitVec.toInt windowsize → ((0 : ℤ) ≤ BitVec.toInt o27 ∧ BitVec.toInt o27 < BitVec.toInt ebi2) ∧ BitVec.toInt o27 + BitVec.toInt windowsize = BitVec.toInt ebi2 ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt o27) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o27)) * BitVec.toUInt o26 ∧ ((0 : ℤ) < BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ (0 : ℤ) < BitVec.toInt windowsize ∧ BitVec.toInt windowsize ≤ BitVec.toInt windowsize)) ∧ (∀(this_windowsize : BitVec 32) (ebi3 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt ebi3 ∧ BitVec.toInt ebi3 < BitVec.toInt ebi2) ∧ BitVec.toInt ebi3 + BitVec.toInt this_windowsize = BitVec.toInt ebi2 ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt ebi3) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi3)) * BitVec.toUInt o26 ∧ ((0 : ℤ) < BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize))) ∧ (0 : ℤ) < BitVec.toInt this_windowsize ∧ BitVec.toInt this_windowsize ≤ BitVec.toInt windowsize → (0 : ℤ) < BitVec.toUInt o26 ∧ (∀(o27 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt o27 ∧ BitVec.toInt o27 < (64 : ℤ)) ∧ BitVec.toUInt o26 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o27)) = (0 : ℤ) ∧ ¬BitVec.toUInt o26 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o27 + (1 : ℤ))) = (0 : ℤ) → int'32_in_bounds (BitVec.toInt this_windowsize - BitVec.toInt o27) ∧ (∀(o28 : BitVec 32), BitVec.toInt o28 = BitVec.toInt this_windowsize - BitVec.toInt o27 → int'32_in_bounds (BitVec.toInt ebi3 + BitVec.toInt o27) ∧ (∀(o29 : BitVec 32), BitVec.toInt o29 = BitVec.toInt ebi3 + BitVec.toInt o27 → (0 : ℤ) ≤ BitVec.toInt o27 ∧ (∀(o30 : BitVec 64), BitVec.toUInt o30 = BitVec.toInt o27 → (((0 : ℤ) ≤ BitVec.toUInt o30 ∧ BitVec.toUInt o30 < (64 : ℤ)) ∧ BitVec.toUInt o26 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o30)) = (0 : ℤ)) ∧ (∀(o31 : BitVec 64), BitVec.toUInt o26 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o30)) * BitVec.toUInt o31 → (((0 : ℤ) ≤ BitVec.toInt o28 ∧ BitVec.toInt o28 ≤ BitVec.toInt o28) ∧ (0 : ℤ) ≤ expdone1 ∧ redc (Lemmas.value rp4 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone1)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (BitVec.toUInt o31 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o28)) * expdone1) ∧ C.plength tp5 = C.plength tp2 ∧ C.min tp5 = C.min tp2 ∧ C.max tp5 = C.max tp2) ∧ (∀(this_windowsize1 : BitVec 32) (expdone2 : ℤ) (tp6 : C.ptr (BitVec 64)) (rp5 : C.ptr (BitVec 64)), C.offset tp6 = C.offset tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → ((0 : ℤ) ≤ BitVec.toInt this_windowsize1 ∧ BitVec.toInt this_windowsize1 ≤ BitVec.toInt o28) ∧ (0 : ℤ) ≤ expdone2 ∧ redc (Lemmas.value rp5 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone2)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (BitVec.toUInt o31 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize1)) * expdone2) ∧ C.plength tp6 = C.plength tp2 ∧ C.min tp6 = C.min tp2 ∧ C.max tp6 = C.max tp2 → (∀(o32 : Bool), (BitVec.toInt this_windowsize1 = BitVec.toInt (0 : BitVec 32) → o32 = true) ∧ (o32 = true → this_windowsize1 = (0 : BitVec 32)) → (if ¬o32 = true then ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid tp6 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp6 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp7 : C.ptr (BitVec 64)), C.offset tp7 = C.offset tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → Lemmas.value tp7 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp5 (BitVec.toInt n) * Lemmas.value rp5 (BitVec.toInt n) ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.plength tp7 = C.plength tp6 ∧ (∀(j1 : ℤ), C.min tp7 ≤ j1 ∧ j1 < C.offset tp7 ∨ C.offset tp7 + BitVec.toInt n + BitVec.toInt n ≤ j1 ∧ j1 < C.max tp7 → C.pelts tp7 j1 = C.pelts tp6 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp7 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp7 = true ∧ C.writable rp5 = true) ∧ (∀(tp8 : C.ptr (BitVec 64)) (rp6 : C.ptr (BitVec 64)), List.length (C.data tp8) = List.length (C.data tp7) ∧ C.offset tp8 = C.offset tp7 ∧ C.min tp8 = C.min tp7 ∧ C.max tp8 = C.max tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → redc (Lemmas.value tp7 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp6 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j1 → C.pelts rp6 j1 = C.pelts rp5 j1) ∧ (Lemmas.value tp7 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp6 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → int'32_in_bounds (BitVec.toInt this_windowsize1 - (1 : ℤ)) ∧ (∀(o33 : BitVec 32), BitVec.toInt o33 = BitVec.toInt this_windowsize1 - (1 : ℤ) → BitVec.toInt o33 < BitVec.toInt this_windowsize1 ∧ ((0 : ℤ) ≤ BitVec.toInt o33 ∧ BitVec.toInt o33 ≤ BitVec.toInt o28) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone2 ∧ redc (Lemmas.value rp6 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone2))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (BitVec.toUInt o31 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o33)) * ((2 : ℤ) * expdone2)) ∧ C.plength tp8 = C.plength tp2 ∧ C.min tp8 = C.min tp2 ∧ C.max tp8 = C.max tp2))) else ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < (64 : ℤ)) ∧ (∀(o33 : BitVec 64), BitVec.toUInt o33 = BitVec.toUInt o31 / HPow.hPow (2 : ℤ) (1 : ℕ) → BitVec.toUInt o33 ≤ (2147483647 : ℤ) ∧ (∀(ebh1 : BitVec 32), BitVec.toInt ebh1 = BitVec.toUInt o33 → int'32_in_bounds (BitVec.toInt n * BitVec.toInt ebh1) ∧ (∀(o34 : BitVec 32), BitVec.toInt o34 = BitVec.toInt n * BitVec.toInt ebh1 → (C.min pp2 ≤ C.offset pp2 + BitVec.toInt o34 ∧ C.offset pp2 + BitVec.toInt o34 ≤ C.max pp2) ∧ (∀(ppn1 : C.ptr (BitVec 64)), C.offset ppn1 = C.offset pp2 + BitVec.toInt o34 ∧ C.plength ppn1 = C.plength pp2 ∧ C.pelts ppn1 = C.pelts pp2 ∧ C.data ppn1 = C.data pp2 ∧ C.min ppn1 = C.min pp2 ∧ C.max ppn1 = C.max pp2 ∧ C.zone1 ppn1 = C.zone1 pp2 ∧ C.writable ppn1 = C.writable pp2 → ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid ppn1 (BitVec.toInt n) ∧ C.valid tp6 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp6 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp7 : C.ptr (BitVec 64)), C.offset tp7 = C.offset tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → Lemmas.value tp7 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp5 (BitVec.toInt n) * Lemmas.value ppn1 (BitVec.toInt n) ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.plength tp7 = C.plength tp6 ∧ (∀(j1 : ℤ), C.min tp7 ≤ j1 ∧ j1 < C.offset tp7 ∨ C.offset tp7 + BitVec.toInt n + BitVec.toInt n ≤ j1 ∧ j1 < C.max tp7 → C.pelts tp7 j1 = C.pelts tp6 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp7 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp7 = true ∧ C.writable rp5 = true) ∧ (∀(tp8 : C.ptr (BitVec 64)) (rp6 : C.ptr (BitVec 64)), List.length (C.data tp8) = List.length (C.data tp7) ∧ C.offset tp8 = C.offset tp7 ∧ C.min tp8 = C.min tp7 ∧ C.max tp8 = C.max tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → redc (Lemmas.value tp7 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp6 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j1 → C.pelts rp6 j1 = C.pelts rp5 j1) ∧ (Lemmas.value tp7 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp6 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → BitVec.toInt o29 < BitVec.toInt ebi1 ∧ ((0 : ℤ) ≤ BitVec.toInt o29 ∧ BitVec.toInt o29 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ expdone2 + BitVec.toUInt o31 ∧ (BitVec.toInt o29 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp6 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat (expdone2 + BitVec.toUInt o31))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (expdone2 + BitVec.toUInt o31) ∧ C.plength tp8 = C.plength tp2 ∧ C.min tp8 = C.min tp2 ∧ C.max tp8 = C.max tp2))))))))))))))))))))) else (C.valid rp3 (BitVec.toInt n) ∧ C.valid tp4 (BitVec.toInt n) ∧ C.writable tp4 = true) ∧ (∀(tp5 : C.ptr (BitVec 64)), List.length (C.data tp5) = List.length (C.data tp4) ∧ C.offset tp5 = C.offset tp4 ∧ C.min tp5 = C.min tp4 ∧ C.max tp5 = C.max tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → Lemmas.map_eq_sub_shift (C.pelts tp5) (C.pelts rp3) (C.offset tp5) (C.offset rp3) (BitVec.toInt n) ∧ (∀(j1 : ℤ), j1 < C.offset tp5 ∨ C.offset tp5 + BitVec.toInt n ≤ j1 → C.pelts tp5 j1 = C.pelts tp4 j1) → (C.min tp5 ≤ C.offset tp5 + BitVec.toInt n ∧ C.offset tp5 + BitVec.toInt n ≤ C.max tp5) ∧ (∀(o23 : C.ptr (BitVec 64)), C.offset o23 = C.offset tp5 + BitVec.toInt n ∧ C.plength o23 = C.plength tp5 ∧ C.pelts o23 = C.pelts tp5 ∧ C.data o23 = C.data tp5 ∧ C.min o23 = C.min tp5 ∧ C.max o23 = C.max tp5 ∧ C.zone1 o23 = C.zone1 tp5 ∧ C.writable o23 = C.writable tp5 → (C.valid o23 (BitVec.toInt n) ∧ C.writable o23 = true) ∧ (∀(o24 : C.ptr (BitVec 64)) (tp6 : C.ptr (BitVec 64)), C.data o24 = C.data tp6 ∧ List.length (C.data tp6) = List.length (C.data o23) ∧ C.offset o24 = C.offset o23 ∧ C.min o24 = C.min o23 ∧ C.max o24 = C.max o23 ∧ C.writable o24 = C.writable o23 ∧ C.zone1 o24 = C.zone1 o23 → List.length (C.data tp6) = List.length (C.data tp5) ∧ C.offset tp6 = C.offset tp5 ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → Lemmas.value o24 (BitVec.toInt n) = (0 : ℤ) ∧ (∀(j1 : ℤ), j1 < C.offset o24 ∨ C.offset o24 + BitVec.toInt n ≤ j1 → C.pelts o24 j1 = C.pelts o23 j1) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp6 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp3 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp6 = true ∧ C.writable rp3 = true) ∧ (∀(rp4 : C.ptr (BitVec 64)), List.length (C.data rp4) = List.length (C.data rp3) ∧ C.offset rp4 = C.offset rp3 ∧ C.min rp4 = C.min rp3 ∧ C.max rp4 = C.max rp3 ∧ C.writable rp4 = C.writable rp3 ∧ C.zone1 rp4 = C.zone1 rp3 → redc (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp4 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j1 : ℤ), j1 < C.offset rp4 ∨ C.offset rp4 + BitVec.toInt n ≤ j1 → C.pelts rp4 j1 = C.pelts rp3 j1) ∧ (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp4 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → ((C.valid rp4 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n)) ∧ (∀(o25 : BitVec 32), BitVec.toInt o25 = Compare.compare_int (Lemmas.value rp4 (BitVec.toInt n)) (Lemmas.value mp (BitVec.toInt n)) → (if (0 : ℤ) ≤ BitVec.toInt o25 then ((0 : ℤ) ≤ BitVec.toInt n ∧ C.valid rp4 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n) ∧ C.writable rp4 = true) ∧ (∀(rp5 : C.ptr (BitVec 64)), List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → (∀(x_b : BitVec 64), Lemmas.value rp5 (BitVec.toInt n) - HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * BitVec.toUInt x_b = Lemmas.value rp4 (BitVec.toInt n) - Lemmas.value mp (BitVec.toInt n) ∧ ((0 : ℤ) ≤ BitVec.toUInt x_b ∧ BitVec.toUInt x_b ≤ (1 : ℤ)) ∧ (∀(j1 : ℤ), j1 < C.offset rp5 ∨ C.offset rp5 + BitVec.toInt n ≤ j1 → C.pelts rp5 j1 = C.pelts rp4 j1) → Lemmas.value rp5 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp5 (BitVec.toInt n) < vm)) else Lemmas.value rp4 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp4 (BitVec.toInt n) < vm))) ∧ (∀(rp5 : C.ptr (BitVec 64)), List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → Lemmas.value rp5 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp5 (BitVec.toInt n) < vm → Lemmas.value rp5 (BitVec.toInt n) = HPow.hPow (Lemmas.value bp (BitVec.toInt bn)) (Int.toNat (Lemmas.value ep (BitVec.toInt en))) % Lemmas.value mp (BitVec.toInt n)))))))))))))))))))))))) ∧ (BitVec.toUInt o13 < (1 : ℤ) - (1 : ℤ) → (((1 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize < (64 : ℤ)) ∧ (0 : ℤ) ≤ BitVec.toInt o4 ∧ (1 : ℤ) ≤ BitVec.toInt en ∧ C.valid ep (BitVec.toInt en) ∧ (BitVec.toInt o4 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o14 : BitVec 64), (BitVec.toInt windowsize ≤ BitVec.toInt o4 → valueb ep (BitVec.toInt o4) = valueb ep (BitVec.toInt o4 - BitVec.toInt windowsize) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o4 - BitVec.toInt windowsize)) * BitVec.toUInt o14) ∧ (BitVec.toInt o4 < BitVec.toInt windowsize → valueb ep (BitVec.toInt o4) = BitVec.toUInt o14) ∧ ((0 : ℤ) ≤ BitVec.toUInt o14 ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ BitVec.toUInt o14 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o4 - BitVec.toInt windowsize)) % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (if BitVec.toInt o4 < BitVec.toInt windowsize then ve = valueb ep (BitVec.toInt (0 : BitVec 32)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt (0 : BitVec 32))) * BitVec.toUInt o14 ∧ ((0 : ℤ) ≤ BitVec.toInt (0 : BitVec 32) ∧ BitVec.toInt (0 : BitVec 32) ≤ BitVec.toInt o4) ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) else int'32_in_bounds (BitVec.toInt o4 - BitVec.toInt windowsize) ∧ (∀(o15 : BitVec 32), BitVec.toInt o15 = BitVec.toInt o4 - BitVec.toInt windowsize → ve = valueb ep (BitVec.toInt o15) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o15)) * BitVec.toUInt o14 ∧ ((0 : ℤ) ≤ BitVec.toInt o15 ∧ BitVec.toInt o15 ≤ BitVec.toInt o4) ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)))) ∧ (∀(ebi : BitVec 32), ve = valueb ep (BitVec.toInt ebi) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi)) * BitVec.toUInt o14 ∧ ((0 : ℤ) ≤ BitVec.toInt ebi ∧ BitVec.toInt ebi ≤ BitVec.toInt o4) ∧ BitVec.toUInt o14 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (0 : ℤ) < BitVec.toUInt o14 ∧ (∀(o15 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt o15 ∧ BitVec.toInt o15 < (64 : ℤ)) ∧ BitVec.toUInt o14 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o15)) = (0 : ℤ) ∧ ¬BitVec.toUInt o14 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o15 + (1 : ℤ))) = (0 : ℤ) → int'32_in_bounds (BitVec.toInt ebi + BitVec.toInt o15) ∧ (∀(o16 : BitVec 32), BitVec.toInt o16 = BitVec.toInt ebi + BitVec.toInt o15 → (0 : ℤ) ≤ BitVec.toInt o15 ∧ (∀(o17 : BitVec 64), BitVec.toUInt o17 = BitVec.toInt o15 → (((0 : ℤ) ≤ BitVec.toUInt o17 ∧ BitVec.toUInt o17 < (64 : ℤ)) ∧ BitVec.toUInt o14 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o17)) = (0 : ℤ)) ∧ (∀(o18 : BitVec 64), BitVec.toUInt o14 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o17)) * BitVec.toUInt o18 → ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < (64 : ℤ)) ∧ (∀(o19 : BitVec 64), BitVec.toUInt o19 = BitVec.toUInt o18 / HPow.hPow (2 : ℤ) (1 : ℕ) → BitVec.toUInt o19 ≤ (2147483647 : ℤ) ∧ (∀(ebh : BitVec 32), BitVec.toInt ebh = BitVec.toUInt o19 → int'32_in_bounds (BitVec.toInt n * BitVec.toInt ebh) ∧ (∀(o20 : BitVec 32), BitVec.toInt o20 = BitVec.toInt n * BitVec.toInt ebh → (C.min pp1 ≤ C.offset pp1 + BitVec.toInt o20 ∧ C.offset pp1 + BitVec.toInt o20 ≤ C.max pp1) ∧ (∀(ppn : C.ptr (BitVec 64)), C.offset ppn = C.offset pp1 + BitVec.toInt o20 ∧ C.plength ppn = C.plength pp1 ∧ C.pelts ppn = C.pelts pp1 ∧ C.data ppn = C.data pp1 ∧ C.min ppn = C.min pp1 ∧ C.max ppn = C.max pp1 ∧ C.zone1 ppn = C.zone1 pp1 ∧ C.writable ppn = C.writable pp1 → (C.valid ppn (BitVec.toInt n) ∧ C.valid rp1 (BitVec.toInt n) ∧ C.writable rp1 = true) ∧ (∀(rp2 : C.ptr (BitVec 64)), List.length (C.data rp2) = List.length (C.data rp1) ∧ C.offset rp2 = C.offset rp1 ∧ C.min rp2 = C.min rp1 ∧ C.max rp2 = C.max rp1 ∧ C.writable rp2 = C.writable rp1 ∧ C.zone1 rp2 = C.zone1 rp1 → Lemmas.map_eq_sub_shift (C.pelts rp2) (C.pelts ppn) (C.offset rp2) (C.offset ppn) (BitVec.toInt n) ∧ (∀(j : ℤ), j < C.offset rp2 ∨ C.offset rp2 + BitVec.toInt n ≤ j → C.pelts rp2 j = C.pelts rp1 j) → (let o21 : ℤ := BitVec.toUInt o18; (((0 : ℤ) ≤ BitVec.toInt o16 ∧ BitVec.toInt o16 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ o21 ∧ (BitVec.toInt o16 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp2 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat o21)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o16) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o16)) * o21) ∧ (∀(expdone : ℤ) (ebi1 : BitVec 32) (tp3 : C.ptr (BitVec 64)) (rp3 : C.ptr (BitVec 64)), C.offset tp3 = C.offset tp2 ∧ C.writable tp3 = C.writable tp2 ∧ C.zone1 tp3 = C.zone1 tp2 → List.length (C.data rp3) = List.length (C.data rp2) ∧ C.offset rp3 = C.offset rp2 ∧ C.min rp3 = C.min rp2 ∧ C.max rp3 = C.max rp2 ∧ C.writable rp3 = C.writable rp2 ∧ C.zone1 rp3 = C.zone1 rp2 → ((0 : ℤ) ≤ BitVec.toInt ebi1 ∧ BitVec.toInt ebi1 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ expdone ∧ (BitVec.toInt ebi1 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp3 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt ebi1) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi1)) * expdone ∧ C.plength tp3 = C.plength tp2 ∧ C.min tp3 = C.min tp2 ∧ C.max tp3 = C.max tp2 → (∀(o22 : Bool), (BitVec.toInt ebi1 = BitVec.toInt (0 : BitVec 32) → o22 = true) ∧ (o22 = true → ebi1 = (0 : BitVec 32)) → (if ¬o22 = true then (((1 : ℤ) ≤ BitVec.toInt ebi1 ∧ BitVec.toInt ebi1 ≤ BitVec.toInt ebi1) ∧ (0 : ℤ) ≤ expdone ∧ (BitVec.toInt ebi1 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp3 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt ebi1) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi1)) * expdone ∧ C.plength tp3 = C.plength tp2 ∧ C.min tp3 = C.min tp2 ∧ C.max tp3 = C.max tp2) ∧ (∀(expdone1 : ℤ) (ebi2 : BitVec 32) (tp4 : C.ptr (BitVec 64)) (rp4 : C.ptr (BitVec 64)), C.offset tp4 = C.offset tp3 ∧ C.writable tp4 = C.writable tp3 ∧ C.zone1 tp4 = C.zone1 tp3 → List.length (C.data rp4) = List.length (C.data rp3) ∧ C.offset rp4 = C.offset rp3 ∧ C.min rp4 = C.min rp3 ∧ C.max rp4 = C.max rp3 ∧ C.writable rp4 = C.writable rp3 ∧ C.zone1 rp4 = C.zone1 rp3 → ((1 : ℤ) ≤ BitVec.toInt ebi2 ∧ BitVec.toInt ebi2 ≤ BitVec.toInt ebi1) ∧ (0 : ℤ) ≤ expdone1 ∧ (BitVec.toInt ebi2 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp4 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone1)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt ebi2) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2)) * expdone1 ∧ C.plength tp4 = C.plength tp2 ∧ C.min tp4 = C.min tp2 ∧ C.max tp4 = C.max tp2 → (C.valid ep (BitVec.toInt en) ∧ (1 : ℤ) ≤ BitVec.toInt ebi2 ∧ (BitVec.toInt ebi2 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o23 : BitVec 64), ((0 : ℤ) ≤ BitVec.toUInt o23 ∧ BitVec.toUInt o23 ≤ (1 : ℤ)) ∧ BitVec.toUInt o23 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - (1 : ℤ))) % (2 : ℤ) ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt ebi2 - (1 : ℤ)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - (1 : ℤ))) * BitVec.toUInt o23 → (∀(o24 : Bool), (BitVec.toUInt o23 = BitVec.toUInt (0 : BitVec 64) → o24 = true) ∧ (o24 = true → o23 = (0 : BitVec 64)) → (if o24 = true then ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp4 (BitVec.toInt n) ∧ C.valid rp4 (BitVec.toInt n) ∧ C.valid tp4 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp4 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp5 : C.ptr (BitVec 64)), C.offset tp5 = C.offset tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → Lemmas.value tp5 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp4 (BitVec.toInt n) * Lemmas.value rp4 (BitVec.toInt n) ∧ C.min tp5 = C.min tp4 ∧ C.max tp5 = C.max tp4 ∧ C.plength tp5 = C.plength tp4 ∧ (∀(j : ℤ), C.min tp5 ≤ j ∧ j < C.offset tp5 ∨ C.offset tp5 + BitVec.toInt n + BitVec.toInt n ≤ j ∧ j < C.max tp5 → C.pelts tp5 j = C.pelts tp4 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp5 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp4 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp5 = true ∧ C.writable rp4 = true) ∧ (∀(tp6 : C.ptr (BitVec 64)) (rp5 : C.ptr (BitVec 64)), List.length (C.data tp6) = List.length (C.data tp5) ∧ C.offset tp6 = C.offset tp5 ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → redc (Lemmas.value tp5 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp5 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp5 ∨ C.offset rp5 + BitVec.toInt n ≤ j → C.pelts rp5 j = C.pelts rp4 j) ∧ (Lemmas.value tp5 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp5 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → int'32_in_bounds (BitVec.toInt ebi2 - (1 : ℤ)) ∧ (∀(o25 : BitVec 32), BitVec.toInt o25 = BitVec.toInt ebi2 - (1 : ℤ) → (∀(o26 : Bool), (BitVec.toInt o25 = BitVec.toInt (0 : BitVec 32) → o26 = true) ∧ (o26 = true → o25 = (0 : BitVec 32)) → (if o26 = true then ∀(o27 : Bool), (BitVec.toInt o25 = BitVec.toInt (0 : BitVec 32) → o27 = true) ∧ (o27 = true → o25 = (0 : BitVec 32)) → (if o27 = true then (C.valid rp5 (BitVec.toInt n) ∧ C.valid tp6 (BitVec.toInt n) ∧ C.writable tp6 = true) ∧ (∀(tp7 : C.ptr (BitVec 64)), List.length (C.data tp7) = List.length (C.data tp6) ∧ C.offset tp7 = C.offset tp6 ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → Lemmas.map_eq_sub_shift (C.pelts tp7) (C.pelts rp5) (C.offset tp7) (C.offset rp5) (BitVec.toInt n) ∧ (∀(j : ℤ), j < C.offset tp7 ∨ C.offset tp7 + BitVec.toInt n ≤ j → C.pelts tp7 j = C.pelts tp6 j) → (C.min tp7 ≤ C.offset tp7 + BitVec.toInt n ∧ C.offset tp7 + BitVec.toInt n ≤ C.max tp7) ∧ (∀(o28 : C.ptr (BitVec 64)), C.offset o28 = C.offset tp7 + BitVec.toInt n ∧ C.plength o28 = C.plength tp7 ∧ C.pelts o28 = C.pelts tp7 ∧ C.data o28 = C.data tp7 ∧ C.min o28 = C.min tp7 ∧ C.max o28 = C.max tp7 ∧ C.zone1 o28 = C.zone1 tp7 ∧ C.writable o28 = C.writable tp7 → (C.valid o28 (BitVec.toInt n) ∧ C.writable o28 = true) ∧ (∀(o29 : C.ptr (BitVec 64)) (tp8 : C.ptr (BitVec 64)), C.data o29 = C.data tp8 ∧ List.length (C.data tp8) = List.length (C.data o28) ∧ C.offset o29 = C.offset o28 ∧ C.min o29 = C.min o28 ∧ C.max o29 = C.max o28 ∧ C.writable o29 = C.writable o28 ∧ C.zone1 o29 = C.zone1 o28 → List.length (C.data tp8) = List.length (C.data tp7) ∧ C.offset tp8 = C.offset tp7 ∧ C.min tp8 = C.min tp7 ∧ C.max tp8 = C.max tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → Lemmas.value o29 (BitVec.toInt n) = (0 : ℤ) ∧ (∀(j : ℤ), j < C.offset o29 ∨ C.offset o29 + BitVec.toInt n ≤ j → C.pelts o29 j = C.pelts o28 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp8 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp8 = true ∧ C.writable rp5 = true) ∧ (∀(rp6 : C.ptr (BitVec 64)), List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → redc (Lemmas.value tp8 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp6 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j → C.pelts rp6 j = C.pelts rp5 j) ∧ (Lemmas.value tp8 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp6 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → ((C.valid rp6 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n)) ∧ (∀(o30 : BitVec 32), BitVec.toInt o30 = Compare.compare_int (Lemmas.value rp6 (BitVec.toInt n)) (Lemmas.value mp (BitVec.toInt n)) → (if (0 : ℤ) ≤ BitVec.toInt o30 then ((0 : ℤ) ≤ BitVec.toInt n ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n) ∧ C.writable rp6 = true) ∧ (∀(rp7 : C.ptr (BitVec 64)), List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → (∀(x_b : BitVec 64), Lemmas.value rp7 (BitVec.toInt n) - HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * BitVec.toUInt x_b = Lemmas.value rp6 (BitVec.toInt n) - Lemmas.value mp (BitVec.toInt n) ∧ ((0 : ℤ) ≤ BitVec.toUInt x_b ∧ BitVec.toUInt x_b ≤ (1 : ℤ)) ∧ (∀(j : ℤ), j < C.offset rp7 ∨ C.offset rp7 + BitVec.toInt n ≤ j → C.pelts rp7 j = C.pelts rp6 j) → Lemmas.value rp7 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp7 (BitVec.toInt n) < vm)) else Lemmas.value rp6 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp6 (BitVec.toInt n) < vm))) ∧ (∀(rp7 : C.ptr (BitVec 64)), List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → Lemmas.value rp7 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp7 (BitVec.toInt n) < vm → Lemmas.value rp7 (BitVec.toInt n) = HPow.hPow (Lemmas.value bp (BitVec.toInt bn)) (Int.toNat (Lemmas.value ep (BitVec.toInt en))) % Lemmas.value mp (BitVec.toInt n)))))) else (((1 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize < (64 : ℤ)) ∧ (0 : ℤ) ≤ BitVec.toInt o25 ∧ (1 : ℤ) ≤ BitVec.toInt en ∧ C.valid ep (BitVec.toInt en) ∧ (BitVec.toInt o25 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o28 : BitVec 64), (BitVec.toInt windowsize ≤ BitVec.toInt o25 → valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt o25 - BitVec.toInt windowsize) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o25 - BitVec.toInt windowsize)) * BitVec.toUInt o28) ∧ (BitVec.toInt o25 < BitVec.toInt windowsize → valueb ep (BitVec.toInt o25) = BitVec.toUInt o28) ∧ ((0 : ℤ) ≤ BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ BitVec.toUInt o28 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o25 - BitVec.toInt windowsize)) % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (if BitVec.toInt o25 < BitVec.toInt windowsize then int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt o25) ∧ (∀(o29 : BitVec 32), BitVec.toInt o29 = BitVec.toInt windowsize - BitVec.toInt o25 → int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt o29) ∧ (∀(o30 : BitVec 32), BitVec.toInt o30 = BitVec.toInt windowsize - BitVec.toInt o29 → ((0 : ℤ) ≤ BitVec.toInt (0 : BitVec 32) ∧ BitVec.toInt (0 : BitVec 32) < BitVec.toInt o25) ∧ BitVec.toInt (0 : BitVec 32) + BitVec.toInt o30 = BitVec.toInt o25 ∧ valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt (0 : BitVec 32)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt (0 : BitVec 32))) * BitVec.toUInt o28 ∧ ((0 : ℤ) < BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o30))) ∧ (0 : ℤ) < BitVec.toInt o30 ∧ BitVec.toInt o30 ≤ BitVec.toInt windowsize)) else int'32_in_bounds (BitVec.toInt o25 - BitVec.toInt windowsize) ∧ (∀(o29 : BitVec 32), BitVec.toInt o29 = BitVec.toInt o25 - BitVec.toInt windowsize → ((0 : ℤ) ≤ BitVec.toInt o29 ∧ BitVec.toInt o29 < BitVec.toInt o25) ∧ BitVec.toInt o29 + BitVec.toInt windowsize = BitVec.toInt o25 ∧ valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * BitVec.toUInt o28 ∧ ((0 : ℤ) < BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ (0 : ℤ) < BitVec.toInt windowsize ∧ BitVec.toInt windowsize ≤ BitVec.toInt windowsize)) ∧ (∀(this_windowsize : BitVec 32) (ebi3 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt ebi3 ∧ BitVec.toInt ebi3 < BitVec.toInt o25) ∧ BitVec.toInt ebi3 + BitVec.toInt this_windowsize = BitVec.toInt o25 ∧ valueb ep (BitVec.toInt o25) = valueb ep (BitVec.toInt ebi3) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi3)) * BitVec.toUInt o28 ∧ ((0 : ℤ) < BitVec.toUInt o28 ∧ BitVec.toUInt o28 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize))) ∧ (0 : ℤ) < BitVec.toInt this_windowsize ∧ BitVec.toInt this_windowsize ≤ BitVec.toInt windowsize → (0 : ℤ) < BitVec.toUInt o28 ∧ (∀(o29 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt o29 ∧ BitVec.toInt o29 < (64 : ℤ)) ∧ BitVec.toUInt o28 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) = (0 : ℤ) ∧ ¬BitVec.toUInt o28 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29 + (1 : ℤ))) = (0 : ℤ) → int'32_in_bounds (BitVec.toInt this_windowsize - BitVec.toInt o29) ∧ (∀(o30 : BitVec 32), BitVec.toInt o30 = BitVec.toInt this_windowsize - BitVec.toInt o29 → int'32_in_bounds (BitVec.toInt ebi3 + BitVec.toInt o29) ∧ (∀(o31 : BitVec 32), BitVec.toInt o31 = BitVec.toInt ebi3 + BitVec.toInt o29 → (0 : ℤ) ≤ BitVec.toInt o29 ∧ (∀(o32 : BitVec 64), BitVec.toUInt o32 = BitVec.toInt o29 → (((0 : ℤ) ≤ BitVec.toUInt o32 ∧ BitVec.toUInt o32 < (64 : ℤ)) ∧ BitVec.toUInt o28 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o32)) = (0 : ℤ)) ∧ (∀(o33 : BitVec 64), BitVec.toUInt o28 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o32)) * BitVec.toUInt o33 → (((0 : ℤ) ≤ BitVec.toInt o30 ∧ BitVec.toInt o30 ≤ BitVec.toInt o30) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone1 ∧ redc (Lemmas.value rp5 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone1))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (BitVec.toUInt o33 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o30)) * ((2 : ℤ) * expdone1)) ∧ C.plength tp6 = C.plength tp2 ∧ C.min tp6 = C.min tp2 ∧ C.max tp6 = C.max tp2) ∧ (∀(this_windowsize1 : BitVec 32) (expdone2 : ℤ) (tp7 : C.ptr (BitVec 64)) (rp6 : C.ptr (BitVec 64)), C.offset tp7 = C.offset tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → ((0 : ℤ) ≤ BitVec.toInt this_windowsize1 ∧ BitVec.toInt this_windowsize1 ≤ BitVec.toInt o30) ∧ (0 : ℤ) ≤ expdone2 ∧ redc (Lemmas.value rp6 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone2)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (BitVec.toUInt o33 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize1)) * expdone2) ∧ C.plength tp7 = C.plength tp2 ∧ C.min tp7 = C.min tp2 ∧ C.max tp7 = C.max tp2 → (∀(o34 : Bool), (BitVec.toInt this_windowsize1 = BitVec.toInt (0 : BitVec 32) → o34 = true) ∧ (o34 = true → this_windowsize1 = (0 : BitVec 32)) → (if ¬o34 = true then ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid tp7 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp7 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp8 : C.ptr (BitVec 64)), C.offset tp8 = C.offset tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → Lemmas.value tp8 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp6 (BitVec.toInt n) * Lemmas.value rp6 (BitVec.toInt n) ∧ C.min tp8 = C.min tp7 ∧ C.max tp8 = C.max tp7 ∧ C.plength tp8 = C.plength tp7 ∧ (∀(j : ℤ), C.min tp8 ≤ j ∧ j < C.offset tp8 ∨ C.offset tp8 + BitVec.toInt n + BitVec.toInt n ≤ j ∧ j < C.max tp8 → C.pelts tp8 j = C.pelts tp7 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp8 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp6 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp8 = true ∧ C.writable rp6 = true) ∧ (∀(tp9 : C.ptr (BitVec 64)) (rp7 : C.ptr (BitVec 64)), List.length (C.data tp9) = List.length (C.data tp8) ∧ C.offset tp9 = C.offset tp8 ∧ C.min tp9 = C.min tp8 ∧ C.max tp9 = C.max tp8 ∧ C.writable tp9 = C.writable tp8 ∧ C.zone1 tp9 = C.zone1 tp8 → List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → redc (Lemmas.value tp8 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp7 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp7 ∨ C.offset rp7 + BitVec.toInt n ≤ j → C.pelts rp7 j = C.pelts rp6 j) ∧ (Lemmas.value tp8 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp7 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → int'32_in_bounds (BitVec.toInt this_windowsize1 - (1 : ℤ)) ∧ (∀(o35 : BitVec 32), BitVec.toInt o35 = BitVec.toInt this_windowsize1 - (1 : ℤ) → BitVec.toInt o35 < BitVec.toInt this_windowsize1 ∧ ((0 : ℤ) ≤ BitVec.toInt o35 ∧ BitVec.toInt o35 ≤ BitVec.toInt o30) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone2 ∧ redc (Lemmas.value rp7 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone2))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (BitVec.toUInt o33 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o35)) * ((2 : ℤ) * expdone2)) ∧ C.plength tp9 = C.plength tp2 ∧ C.min tp9 = C.min tp2 ∧ C.max tp9 = C.max tp2))) else ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < (64 : ℤ)) ∧ (∀(o35 : BitVec 64), BitVec.toUInt o35 = BitVec.toUInt o33 / HPow.hPow (2 : ℤ) (1 : ℕ) → BitVec.toUInt o35 ≤ (2147483647 : ℤ) ∧ (∀(ebh1 : BitVec 32), BitVec.toInt ebh1 = BitVec.toUInt o35 → int'32_in_bounds (BitVec.toInt n * BitVec.toInt ebh1) ∧ (∀(o36 : BitVec 32), BitVec.toInt o36 = BitVec.toInt n * BitVec.toInt ebh1 → (C.min pp1 ≤ C.offset pp1 + BitVec.toInt o36 ∧ C.offset pp1 + BitVec.toInt o36 ≤ C.max pp1) ∧ (∀(ppn1 : C.ptr (BitVec 64)), C.offset ppn1 = C.offset pp1 + BitVec.toInt o36 ∧ C.plength ppn1 = C.plength pp1 ∧ C.pelts ppn1 = C.pelts pp1 ∧ C.data ppn1 = C.data pp1 ∧ C.min ppn1 = C.min pp1 ∧ C.max ppn1 = C.max pp1 ∧ C.zone1 ppn1 = C.zone1 pp1 ∧ C.writable ppn1 = C.writable pp1 → ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp6 (BitVec.toInt n) ∧ C.valid ppn1 (BitVec.toInt n) ∧ C.valid tp7 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp7 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp8 : C.ptr (BitVec 64)), C.offset tp8 = C.offset tp7 ∧ C.writable tp8 = C.writable tp7 ∧ C.zone1 tp8 = C.zone1 tp7 → Lemmas.value tp8 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp6 (BitVec.toInt n) * Lemmas.value ppn1 (BitVec.toInt n) ∧ C.min tp8 = C.min tp7 ∧ C.max tp8 = C.max tp7 ∧ C.plength tp8 = C.plength tp7 ∧ (∀(j : ℤ), C.min tp8 ≤ j ∧ j < C.offset tp8 ∨ C.offset tp8 + BitVec.toInt n + BitVec.toInt n ≤ j ∧ j < C.max tp8 → C.pelts tp8 j = C.pelts tp7 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp8 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp6 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp8 = true ∧ C.writable rp6 = true) ∧ (∀(tp9 : C.ptr (BitVec 64)) (rp7 : C.ptr (BitVec 64)), List.length (C.data tp9) = List.length (C.data tp8) ∧ C.offset tp9 = C.offset tp8 ∧ C.min tp9 = C.min tp8 ∧ C.max tp9 = C.max tp8 ∧ C.writable tp9 = C.writable tp8 ∧ C.zone1 tp9 = C.zone1 tp8 → List.length (C.data rp7) = List.length (C.data rp6) ∧ C.offset rp7 = C.offset rp6 ∧ C.min rp7 = C.min rp6 ∧ C.max rp7 = C.max rp6 ∧ C.writable rp7 = C.writable rp6 ∧ C.zone1 rp7 = C.zone1 rp6 → redc (Lemmas.value tp8 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp7 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp7 ∨ C.offset rp7 + BitVec.toInt n ≤ j → C.pelts rp7 j = C.pelts rp6 j) ∧ (Lemmas.value tp8 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp7 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → BitVec.toInt o31 < BitVec.toInt ebi1 ∧ ((0 : ℤ) ≤ BitVec.toInt o31 ∧ BitVec.toInt o31 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ expdone2 + BitVec.toUInt o33 ∧ (BitVec.toInt o31 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp7 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat (expdone2 + BitVec.toUInt o33))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o31) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o31)) * (expdone2 + BitVec.toUInt o33) ∧ C.plength tp9 = C.plength tp2 ∧ C.min tp9 = C.min tp2 ∧ C.max tp9 = C.max tp2))))))))))))))))) else BitVec.toInt o25 < BitVec.toInt ebi2 ∧ ((1 : ℤ) ≤ BitVec.toInt o25 ∧ BitVec.toInt o25 ≤ BitVec.toInt ebi1) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone1 ∧ (BitVec.toInt o25 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp5 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone1))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o25) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o25)) * ((2 : ℤ) * expdone1) ∧ C.plength tp6 = C.plength tp2 ∧ C.min tp6 = C.min tp2 ∧ C.max tp6 = C.max tp2))))) else ∀(o25 : Bool), (BitVec.toInt ebi2 = BitVec.toInt (0 : BitVec 32) → o25 = true) ∧ (o25 = true → ebi2 = (0 : BitVec 32)) → (if o25 = true then (C.valid rp4 (BitVec.toInt n) ∧ C.valid tp4 (BitVec.toInt n) ∧ C.writable tp4 = true) ∧ (∀(tp5 : C.ptr (BitVec 64)), List.length (C.data tp5) = List.length (C.data tp4) ∧ C.offset tp5 = C.offset tp4 ∧ C.min tp5 = C.min tp4 ∧ C.max tp5 = C.max tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → Lemmas.map_eq_sub_shift (C.pelts tp5) (C.pelts rp4) (C.offset tp5) (C.offset rp4) (BitVec.toInt n) ∧ (∀(j : ℤ), j < C.offset tp5 ∨ C.offset tp5 + BitVec.toInt n ≤ j → C.pelts tp5 j = C.pelts tp4 j) → (C.min tp5 ≤ C.offset tp5 + BitVec.toInt n ∧ C.offset tp5 + BitVec.toInt n ≤ C.max tp5) ∧ (∀(o26 : C.ptr (BitVec 64)), C.offset o26 = C.offset tp5 + BitVec.toInt n ∧ C.plength o26 = C.plength tp5 ∧ C.pelts o26 = C.pelts tp5 ∧ C.data o26 = C.data tp5 ∧ C.min o26 = C.min tp5 ∧ C.max o26 = C.max tp5 ∧ C.zone1 o26 = C.zone1 tp5 ∧ C.writable o26 = C.writable tp5 → (C.valid o26 (BitVec.toInt n) ∧ C.writable o26 = true) ∧ (∀(o27 : C.ptr (BitVec 64)) (tp6 : C.ptr (BitVec 64)), C.data o27 = C.data tp6 ∧ List.length (C.data tp6) = List.length (C.data o26) ∧ C.offset o27 = C.offset o26 ∧ C.min o27 = C.min o26 ∧ C.max o27 = C.max o26 ∧ C.writable o27 = C.writable o26 ∧ C.zone1 o27 = C.zone1 o26 → List.length (C.data tp6) = List.length (C.data tp5) ∧ C.offset tp6 = C.offset tp5 ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → Lemmas.value o27 (BitVec.toInt n) = (0 : ℤ) ∧ (∀(j : ℤ), j < C.offset o27 ∨ C.offset o27 + BitVec.toInt n ≤ j → C.pelts o27 j = C.pelts o26 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp6 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp4 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp6 = true ∧ C.writable rp4 = true) ∧ (∀(rp5 : C.ptr (BitVec 64)), List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → redc (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp5 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp5 ∨ C.offset rp5 + BitVec.toInt n ≤ j → C.pelts rp5 j = C.pelts rp4 j) ∧ (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp5 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → ((C.valid rp5 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n)) ∧ (∀(o28 : BitVec 32), BitVec.toInt o28 = Compare.compare_int (Lemmas.value rp5 (BitVec.toInt n)) (Lemmas.value mp (BitVec.toInt n)) → (if (0 : ℤ) ≤ BitVec.toInt o28 then ((0 : ℤ) ≤ BitVec.toInt n ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n) ∧ C.writable rp5 = true) ∧ (∀(rp6 : C.ptr (BitVec 64)), List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → (∀(x_b : BitVec 64), Lemmas.value rp6 (BitVec.toInt n) - HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * BitVec.toUInt x_b = Lemmas.value rp5 (BitVec.toInt n) - Lemmas.value mp (BitVec.toInt n) ∧ ((0 : ℤ) ≤ BitVec.toUInt x_b ∧ BitVec.toUInt x_b ≤ (1 : ℤ)) ∧ (∀(j : ℤ), j < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j → C.pelts rp6 j = C.pelts rp5 j) → Lemmas.value rp6 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp6 (BitVec.toInt n) < vm)) else Lemmas.value rp5 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp5 (BitVec.toInt n) < vm))) ∧ (∀(rp6 : C.ptr (BitVec 64)), List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → Lemmas.value rp6 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp6 (BitVec.toInt n) < vm → Lemmas.value rp6 (BitVec.toInt n) = HPow.hPow (Lemmas.value bp (BitVec.toInt bn)) (Int.toNat (Lemmas.value ep (BitVec.toInt en))) % Lemmas.value mp (BitVec.toInt n)))))) else (((1 : ℤ) ≤ BitVec.toInt windowsize ∧ BitVec.toInt windowsize < (64 : ℤ)) ∧ (0 : ℤ) ≤ BitVec.toInt ebi2 ∧ (1 : ℤ) ≤ BitVec.toInt en ∧ C.valid ep (BitVec.toInt en) ∧ (BitVec.toInt ebi2 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en) ∧ (∀(o26 : BitVec 64), (BitVec.toInt windowsize ≤ BitVec.toInt ebi2 → valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt ebi2 - BitVec.toInt windowsize) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - BitVec.toInt windowsize)) * BitVec.toUInt o26) ∧ (BitVec.toInt ebi2 < BitVec.toInt windowsize → valueb ep (BitVec.toInt ebi2) = BitVec.toUInt o26) ∧ ((0 : ℤ) ≤ BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ BitVec.toUInt o26 = Lemmas.value ep (BitVec.toInt en) / HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi2 - BitVec.toInt windowsize)) % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize)) → (if BitVec.toInt ebi2 < BitVec.toInt windowsize then int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt ebi2) ∧ (∀(o27 : BitVec 32), BitVec.toInt o27 = BitVec.toInt windowsize - BitVec.toInt ebi2 → int'32_in_bounds (BitVec.toInt windowsize - BitVec.toInt o27) ∧ (∀(o28 : BitVec 32), BitVec.toInt o28 = BitVec.toInt windowsize - BitVec.toInt o27 → ((0 : ℤ) ≤ BitVec.toInt (0 : BitVec 32) ∧ BitVec.toInt (0 : BitVec 32) < BitVec.toInt ebi2) ∧ BitVec.toInt (0 : BitVec 32) + BitVec.toInt o28 = BitVec.toInt ebi2 ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt (0 : BitVec 32)) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt (0 : BitVec 32))) * BitVec.toUInt o26 ∧ ((0 : ℤ) < BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o28))) ∧ (0 : ℤ) < BitVec.toInt o28 ∧ BitVec.toInt o28 ≤ BitVec.toInt windowsize)) else int'32_in_bounds (BitVec.toInt ebi2 - BitVec.toInt windowsize) ∧ (∀(o27 : BitVec 32), BitVec.toInt o27 = BitVec.toInt ebi2 - BitVec.toInt windowsize → ((0 : ℤ) ≤ BitVec.toInt o27 ∧ BitVec.toInt o27 < BitVec.toInt ebi2) ∧ BitVec.toInt o27 + BitVec.toInt windowsize = BitVec.toInt ebi2 ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt o27) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o27)) * BitVec.toUInt o26 ∧ ((0 : ℤ) < BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt windowsize))) ∧ (0 : ℤ) < BitVec.toInt windowsize ∧ BitVec.toInt windowsize ≤ BitVec.toInt windowsize)) ∧ (∀(this_windowsize : BitVec 32) (ebi3 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt ebi3 ∧ BitVec.toInt ebi3 < BitVec.toInt ebi2) ∧ BitVec.toInt ebi3 + BitVec.toInt this_windowsize = BitVec.toInt ebi2 ∧ valueb ep (BitVec.toInt ebi2) = valueb ep (BitVec.toInt ebi3) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt ebi3)) * BitVec.toUInt o26 ∧ ((0 : ℤ) < BitVec.toUInt o26 ∧ BitVec.toUInt o26 < HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize))) ∧ (0 : ℤ) < BitVec.toInt this_windowsize ∧ BitVec.toInt this_windowsize ≤ BitVec.toInt windowsize → (0 : ℤ) < BitVec.toUInt o26 ∧ (∀(o27 : BitVec 32), ((0 : ℤ) ≤ BitVec.toInt o27 ∧ BitVec.toInt o27 < (64 : ℤ)) ∧ BitVec.toUInt o26 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o27)) = (0 : ℤ) ∧ ¬BitVec.toUInt o26 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o27 + (1 : ℤ))) = (0 : ℤ) → int'32_in_bounds (BitVec.toInt this_windowsize - BitVec.toInt o27) ∧ (∀(o28 : BitVec 32), BitVec.toInt o28 = BitVec.toInt this_windowsize - BitVec.toInt o27 → int'32_in_bounds (BitVec.toInt ebi3 + BitVec.toInt o27) ∧ (∀(o29 : BitVec 32), BitVec.toInt o29 = BitVec.toInt ebi3 + BitVec.toInt o27 → (0 : ℤ) ≤ BitVec.toInt o27 ∧ (∀(o30 : BitVec 64), BitVec.toUInt o30 = BitVec.toInt o27 → (((0 : ℤ) ≤ BitVec.toUInt o30 ∧ BitVec.toUInt o30 < (64 : ℤ)) ∧ BitVec.toUInt o26 % HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o30)) = (0 : ℤ)) ∧ (∀(o31 : BitVec 64), BitVec.toUInt o26 = HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toUInt o30)) * BitVec.toUInt o31 → (((0 : ℤ) ≤ BitVec.toInt o28 ∧ BitVec.toInt o28 ≤ BitVec.toInt o28) ∧ (0 : ℤ) ≤ expdone1 ∧ redc (Lemmas.value rp4 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone1)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (BitVec.toUInt o31 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o28)) * expdone1) ∧ C.plength tp4 = C.plength tp2 ∧ C.min tp4 = C.min tp2 ∧ C.max tp4 = C.max tp2) ∧ (∀(this_windowsize1 : BitVec 32) (expdone2 : ℤ) (tp5 : C.ptr (BitVec 64)) (rp5 : C.ptr (BitVec 64)), C.offset tp5 = C.offset tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → ((0 : ℤ) ≤ BitVec.toInt this_windowsize1 ∧ BitVec.toInt this_windowsize1 ≤ BitVec.toInt o28) ∧ (0 : ℤ) ≤ expdone2 ∧ redc (Lemmas.value rp5 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat expdone2)) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (BitVec.toUInt o31 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt this_windowsize1)) * expdone2) ∧ C.plength tp5 = C.plength tp2 ∧ C.min tp5 = C.min tp2 ∧ C.max tp5 = C.max tp2 → (∀(o32 : Bool), (BitVec.toInt this_windowsize1 = BitVec.toInt (0 : BitVec 32) → o32 = true) ∧ (o32 = true → this_windowsize1 = (0 : BitVec 32)) → (if ¬o32 = true then ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid tp5 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp5 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp6 : C.ptr (BitVec 64)), C.offset tp6 = C.offset tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → Lemmas.value tp6 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp5 (BitVec.toInt n) * Lemmas.value rp5 (BitVec.toInt n) ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.plength tp6 = C.plength tp5 ∧ (∀(j : ℤ), C.min tp6 ≤ j ∧ j < C.offset tp6 ∨ C.offset tp6 + BitVec.toInt n + BitVec.toInt n ≤ j ∧ j < C.max tp6 → C.pelts tp6 j = C.pelts tp5 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp6 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp6 = true ∧ C.writable rp5 = true) ∧ (∀(tp7 : C.ptr (BitVec 64)) (rp6 : C.ptr (BitVec 64)), List.length (C.data tp7) = List.length (C.data tp6) ∧ C.offset tp7 = C.offset tp6 ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → redc (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp6 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j → C.pelts rp6 j = C.pelts rp5 j) ∧ (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp6 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → int'32_in_bounds (BitVec.toInt this_windowsize1 - (1 : ℤ)) ∧ (∀(o33 : BitVec 32), BitVec.toInt o33 = BitVec.toInt this_windowsize1 - (1 : ℤ) → BitVec.toInt o33 < BitVec.toInt this_windowsize1 ∧ ((0 : ℤ) ≤ BitVec.toInt o33 ∧ BitVec.toInt o33 ≤ BitVec.toInt o28) ∧ (0 : ℤ) ≤ (2 : ℤ) * expdone2 ∧ redc (Lemmas.value rp6 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat ((2 : ℤ) * expdone2))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (BitVec.toUInt o31 + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o33)) * ((2 : ℤ) * expdone2)) ∧ C.plength tp7 = C.plength tp2 ∧ C.min tp7 = C.min tp2 ∧ C.max tp7 = C.max tp2))) else ((0 : ℤ) ≤ (1 : ℤ) ∧ (1 : ℤ) < (64 : ℤ)) ∧ (∀(o33 : BitVec 64), BitVec.toUInt o33 = BitVec.toUInt o31 / HPow.hPow (2 : ℤ) (1 : ℕ) → BitVec.toUInt o33 ≤ (2147483647 : ℤ) ∧ (∀(ebh1 : BitVec 32), BitVec.toInt ebh1 = BitVec.toUInt o33 → int'32_in_bounds (BitVec.toInt n * BitVec.toInt ebh1) ∧ (∀(o34 : BitVec 32), BitVec.toInt o34 = BitVec.toInt n * BitVec.toInt ebh1 → (C.min pp1 ≤ C.offset pp1 + BitVec.toInt o34 ∧ C.offset pp1 + BitVec.toInt o34 ≤ C.max pp1) ∧ (∀(ppn1 : C.ptr (BitVec 64)), C.offset ppn1 = C.offset pp1 + BitVec.toInt o34 ∧ C.plength ppn1 = C.plength pp1 ∧ C.pelts ppn1 = C.pelts pp1 ∧ C.data ppn1 = C.data pp1 ∧ C.min ppn1 = C.min pp1 ∧ C.max ppn1 = C.max pp1 ∧ C.zone1 ppn1 = C.zone1 pp1 ∧ C.writable ppn1 = C.writable pp1 → ((0 : ℤ) < BitVec.toInt n ∧ C.valid rp5 (BitVec.toInt n) ∧ C.valid ppn1 (BitVec.toInt n) ∧ C.valid tp5 (BitVec.toInt n + BitVec.toInt n) ∧ C.writable tp5 = true ∧ (8 : ℤ) * BitVec.toInt n < (2147483647 : ℤ) ∧ BitVec.toInt n ≤ BitVec.toInt (29 : BitVec 32) * HPow.hPow (2 : ℤ) (64 : ℕ) ∧ (0 : ℤ) ≤ (64 : ℤ) ∧ (64 : ℤ) ≤ (64 : ℤ)) ∧ (∀(tp6 : C.ptr (BitVec 64)), C.offset tp6 = C.offset tp5 ∧ C.writable tp6 = C.writable tp5 ∧ C.zone1 tp6 = C.zone1 tp5 → Lemmas.value tp6 (BitVec.toInt n + BitVec.toInt n) = Lemmas.value rp5 (BitVec.toInt n) * Lemmas.value ppn1 (BitVec.toInt n) ∧ C.min tp6 = C.min tp5 ∧ C.max tp6 = C.max tp5 ∧ C.plength tp6 = C.plength tp5 ∧ (∀(j : ℤ), C.min tp6 ≤ j ∧ j < C.offset tp6 ∨ C.offset tp6 + BitVec.toInt n + BitVec.toInt n ≤ j ∧ j < C.max tp6 → C.pelts tp6 j = C.pelts tp5 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp6 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp5 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp6 = true ∧ C.writable rp5 = true) ∧ (∀(tp7 : C.ptr (BitVec 64)) (rp6 : C.ptr (BitVec 64)), List.length (C.data tp7) = List.length (C.data tp6) ∧ C.offset tp7 = C.offset tp6 ∧ C.min tp7 = C.min tp6 ∧ C.max tp7 = C.max tp6 ∧ C.writable tp7 = C.writable tp6 ∧ C.zone1 tp7 = C.zone1 tp6 → List.length (C.data rp6) = List.length (C.data rp5) ∧ C.offset rp6 = C.offset rp5 ∧ C.min rp6 = C.min rp5 ∧ C.max rp6 = C.max rp5 ∧ C.writable rp6 = C.writable rp5 ∧ C.zone1 rp6 = C.zone1 rp5 → redc (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp6 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp6 ∨ C.offset rp6 + BitVec.toInt n ≤ j → C.pelts rp6 j = C.pelts rp5 j) ∧ (Lemmas.value tp6 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp6 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → BitVec.toInt o29 < BitVec.toInt ebi1 ∧ ((0 : ℤ) ≤ BitVec.toInt o29 ∧ BitVec.toInt o29 ≤ BitVec.toInt o16) ∧ (0 : ℤ) ≤ expdone2 + BitVec.toUInt o31 ∧ (BitVec.toInt o29 + (63 : ℤ)) / (64 : ℤ) ≤ BitVec.toInt en ∧ redc (Lemmas.value rp6 (BitVec.toInt n)) (HPow.hPow vb (Int.toNat (expdone2 + BitVec.toUInt o31))) (BitVec.toInt n) vm ∧ ve = valueb ep (BitVec.toInt o29) + HPow.hPow (2 : ℤ) (Int.toNat (BitVec.toInt o29)) * (expdone2 + BitVec.toUInt o31) ∧ C.plength tp7 = C.plength tp2 ∧ C.min tp7 = C.min tp2 ∧ C.max tp7 = C.max tp2))))))))))))))))))))) else (C.valid rp3 (BitVec.toInt n) ∧ C.valid tp3 (BitVec.toInt n) ∧ C.writable tp3 = true) ∧ (∀(tp4 : C.ptr (BitVec 64)), List.length (C.data tp4) = List.length (C.data tp3) ∧ C.offset tp4 = C.offset tp3 ∧ C.min tp4 = C.min tp3 ∧ C.max tp4 = C.max tp3 ∧ C.writable tp4 = C.writable tp3 ∧ C.zone1 tp4 = C.zone1 tp3 → Lemmas.map_eq_sub_shift (C.pelts tp4) (C.pelts rp3) (C.offset tp4) (C.offset rp3) (BitVec.toInt n) ∧ (∀(j : ℤ), j < C.offset tp4 ∨ C.offset tp4 + BitVec.toInt n ≤ j → C.pelts tp4 j = C.pelts tp3 j) → (C.min tp4 ≤ C.offset tp4 + BitVec.toInt n ∧ C.offset tp4 + BitVec.toInt n ≤ C.max tp4) ∧ (∀(o23 : C.ptr (BitVec 64)), C.offset o23 = C.offset tp4 + BitVec.toInt n ∧ C.plength o23 = C.plength tp4 ∧ C.pelts o23 = C.pelts tp4 ∧ C.data o23 = C.data tp4 ∧ C.min o23 = C.min tp4 ∧ C.max o23 = C.max tp4 ∧ C.zone1 o23 = C.zone1 tp4 ∧ C.writable o23 = C.writable tp4 → (C.valid o23 (BitVec.toInt n) ∧ C.writable o23 = true) ∧ (∀(o24 : C.ptr (BitVec 64)) (tp5 : C.ptr (BitVec 64)), C.data o24 = C.data tp5 ∧ List.length (C.data tp5) = List.length (C.data o23) ∧ C.offset o24 = C.offset o23 ∧ C.min o24 = C.min o23 ∧ C.max o24 = C.max o23 ∧ C.writable o24 = C.writable o23 ∧ C.zone1 o24 = C.zone1 o23 → List.length (C.data tp5) = List.length (C.data tp4) ∧ C.offset tp5 = C.offset tp4 ∧ C.min tp5 = C.min tp4 ∧ C.max tp5 = C.max tp4 ∧ C.writable tp5 = C.writable tp4 ∧ C.zone1 tp5 = C.zone1 tp4 → Lemmas.value o24 (BitVec.toInt n) = (0 : ℤ) ∧ (∀(j : ℤ), j < C.offset o24 ∨ C.offset o24 + BitVec.toInt n ≤ j → C.pelts o24 j = C.pelts o23 j) → ((0 : ℤ) < BitVec.toInt n ∧ (C.valid mp (BitVec.toInt n) ∧ C.valid tp5 ((2 : ℤ) * BitVec.toInt n) ∧ C.valid rp3 (BitVec.toInt n)) ∧ Odd (Lemmas.value mp (BitVec.toInt n)) ∧ Lemmas.value mp (BitVec.toInt n) * BitVec.toUInt mip % ((18446744073709551615 : ℤ) + (1 : ℤ)) = (18446744073709551615 : ℤ) + (1 : ℤ) - (1 : ℤ) ∧ C.writable tp5 = true ∧ C.writable rp3 = true) ∧ (∀(rp4 : C.ptr (BitVec 64)), List.length (C.data rp4) = List.length (C.data rp3) ∧ C.offset rp4 = C.offset rp3 ∧ C.min rp4 = C.min rp3 ∧ C.max rp4 = C.max rp3 ∧ C.writable rp4 = C.writable rp3 ∧ C.zone1 rp4 = C.zone1 rp3 → redc (Lemmas.value tp5 ((2 : ℤ) * BitVec.toInt n)) (Lemmas.value rp4 (BitVec.toInt n)) (BitVec.toInt n) (Lemmas.value mp (BitVec.toInt n)) ∧ (∀(j : ℤ), j < C.offset rp4 ∨ C.offset rp4 + BitVec.toInt n ≤ j → C.pelts rp4 j = C.pelts rp3 j) ∧ (Lemmas.value tp5 ((2 : ℤ) * BitVec.toInt n) < HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * Lemmas.value mp (BitVec.toInt n) → Lemmas.value rp4 (BitVec.toInt n) < (2 : ℤ) * Lemmas.value mp (BitVec.toInt n)) → ((C.valid rp4 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n)) ∧ (∀(o25 : BitVec 32), BitVec.toInt o25 = Compare.compare_int (Lemmas.value rp4 (BitVec.toInt n)) (Lemmas.value mp (BitVec.toInt n)) → (if (0 : ℤ) ≤ BitVec.toInt o25 then ((0 : ℤ) ≤ BitVec.toInt n ∧ C.valid rp4 (BitVec.toInt n) ∧ C.valid mp (BitVec.toInt n) ∧ C.writable rp4 = true) ∧ (∀(rp5 : C.ptr (BitVec 64)), List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → (∀(x_b : BitVec 64), Lemmas.value rp5 (BitVec.toInt n) - HPow.hPow ((18446744073709551615 : ℤ) + (1 : ℤ)) (Int.toNat (BitVec.toInt n)) * BitVec.toUInt x_b = Lemmas.value rp4 (BitVec.toInt n) - Lemmas.value mp (BitVec.toInt n) ∧ ((0 : ℤ) ≤ BitVec.toUInt x_b ∧ BitVec.toUInt x_b ≤ (1 : ℤ)) ∧ (∀(j : ℤ), j < C.offset rp5 ∨ C.offset rp5 + BitVec.toInt n ≤ j → C.pelts rp5 j = C.pelts rp4 j) → Lemmas.value rp5 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp5 (BitVec.toInt n) < vm)) else Lemmas.value rp4 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp4 (BitVec.toInt n) < vm))) ∧ (∀(rp5 : C.ptr (BitVec 64)), List.length (C.data rp5) = List.length (C.data rp4) ∧ C.offset rp5 = C.offset rp4 ∧ C.min rp5 = C.min rp4 ∧ C.max rp5 = C.max rp4 ∧ C.writable rp5 = C.writable rp4 ∧ C.zone1 rp5 = C.zone1 rp4 → Lemmas.value rp5 (BitVec.toInt n) % vm = HPow.hPow vb (Int.toNat ve) % vm ∧ Lemmas.value rp5 (BitVec.toInt n) < vm → Lemmas.value rp5 (BitVec.toInt n) = HPow.hPow (Lemmas.value bp (BitVec.toInt bn)) (Int.toNat (Lemmas.value ep (BitVec.toInt en))) % Lemmas.value mp (BitVec.toInt n))))))))))))))))))))))))))))))))))))))))))))
  := sorry
end powm_Powm_wmpn_powmqtvc
