From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.map.Const.
Require Import Why3.map.MapEq.
Require Import Why3.mach.c.C.
Require Import Why3.mach.int.Unsigned.
Require Import multiprecision.types.Config.
Require Import multiprecision.types.Types.
Require Import multiprecision.types.Int32Eq.
Require Import multiprecision.types.UInt64Eq.
Require Import multiprecision.lemmas.Lemmas.
Require Import multiprecision.compare.Compare.
Require Import multiprecision.valuation.Valuation.
Require Import multiprecision.util.Util.
Require Import multiprecision.ptralias.Alias.
Require Import multiprecision.util.UtilOld.
Require Import multiprecision.add.Add.
Require Import multiprecision.add.AddOld.
Require Import multiprecision.sub.SubOld.
Require Import multiprecision.mul.Mul.
Require Import multiprecision.mul.Mul_basecase.
Require Import multiprecision.logical.LogicalUtil.
Require Import multiprecision.logical.Logical.
Require Import multiprecision.logical.LogicalOld.
Require Import multiprecision.div.Div.
Require Import multiprecision.toom.Toom.
Require Import multiprecision.add_1.Add_1.
Require Import multiprecision.sub_1.Sub_1.
Open Scope Z_scope.
Definition redc (ur : Z) (u : Z) (n : Z) (m : Z) := ZEuclid.modulo ur m = ZEuclid.modulo (Z.pow (18446744073709551615%Z + 1%Z) n * u) m.
Definition valueb (p : ptr (bv 64%N)) (nbits : Z) : Z := if decide (nbits < 0%Z) then 0%Z else let i : Z := ZEuclid.div nbits 64%Z in value p i + Z.pow (18446744073709551615%Z + 1%Z) i * ZEuclid.modulo (bv_unsigned (pelts p (offset p + i))) (Z.pow 2%Z (nbits - 64%Z * i)).
Theorem wmpn_powm'vc (rp : ptr (bv 64%N)) (n : bv 32%N) (bp : ptr (bv 64%N)) (bn : bv 32%N) (ep : ptr (bv 64%N)) (en : bv 32%N) (mp : ptr (bv 64%N)) (tp : ptr (bv 64%N)) (fact0 : valid rp (bv_signed n)) (fact1 : valid bp (bv_signed bn)) (fact2 : valid ep (bv_signed en)) (fact3 : valid mp (bv_signed n)) (fact4 : valid tp (2%Z * bv_signed n)) (fact5 : writable tp = true) (fact6 : writable rp = true) (fact7 : Z.Odd (value mp (bv_signed n))) (fact8 : 1%Z < value ep (bv_signed en)) (fact9 : 1%Z ≤ bv_signed en) (fact10 : 0%Z < bv_unsigned (pelts ep (offset ep + bv_signed en - 1%Z))) (fact11 : 0%Z < bv_unsigned (pelts mp (offset mp + bv_signed n - 1%Z))) (fact12 : 1%Z ≤ bv_signed n) (fact13 : 1%Z ≤ bv_signed bn) (fact14 : bv_signed bn + bv_signed n < 2147483647%Z) (fact15 : bv_signed n * 512%Z ≤ 2147483647%Z) (fact16 : 64%Z * bv_signed en < 2147483647%Z - 64%Z) : let vb : Z := value bp (bv_signed bn) in let vm : Z := value mp (bv_signed n) in let ve : Z := value ep (bv_signed en) in int'32_in_bounds (bv_signed en - 1%Z) ∧ (∀(o1 : bv 32%N), bv_signed o1 = bv_signed en - 1%Z -> (min ep ≤ offset ep + bv_signed o1 ∧ offset ep + bv_signed o1 < C.max ep) ∧ (let le : bv 64%N := pelts ep (offset ep + bv_signed o1) in 0%Z < bv_unsigned le ∧ (∀(o2 : bv 32%N), Z.pow 2%Z (bv_signed o2) * bv_unsigned le ≤ 18446744073709551615%Z ∧ 18446744073709551615%Z < 2%Z * Z.pow 2%Z (bv_signed o2) * bv_unsigned le ∧ 0%Z ≤ bv_signed o2 ∧ bv_signed o2 < 64%Z -> int'32_in_bounds (64%Z * bv_signed en) ∧ (∀(o3 : bv 32%N), bv_signed o3 = 64%Z * bv_signed en -> int'32_in_bounds (bv_signed o3 - bv_signed o2) ∧ (∀(o4 : bv 32%N), bv_signed o4 = bv_signed o3 - bv_signed o2 -> (∀(windowsize : bv 32%N), (0%Z ≤ bv_signed windowsize ∧ bv_signed windowsize ≤ 10%Z) ∧ (0%Z < bv_signed o4 -> 0%Z < bv_signed windowsize) -> (min mp ≤ offset mp ∧ offset mp < C.max mp) ∧ (let m0 : bv 64%N := pelts mp (offset mp) in Z.Odd (bv_unsigned m0) ∧ (∀(im : bv 64%N), ZEuclid.modulo (bv_unsigned im * bv_unsigned m0) (18446744073709551615%Z + 1%Z) = 1%Z -> (∀(mip : bv 64%N), bv_unsigned mip = ZEuclid.modulo (- bv_unsigned im) (18446744073709551615%Z + 1%Z) -> 0%Z ≤ bv_signed windowsize ∧ (∀(o5 : bv 32%N), bv_unsigned o5 = bv_signed windowsize -> uint'32_in_bounds (bv_unsigned o5 - 1%Z) ∧ (∀(o6 : bv 32%N), bv_unsigned o6 = bv_unsigned o5 - 1%Z -> 0%Z ≤ bv_signed n ∧ (∀(o7 : bv 32%N), bv_unsigned o7 = bv_signed n -> ((0%Z ≤ bv_unsigned o6 ∧ bv_unsigned o6 < 32%Z) ∧ Z.pow 2%Z (bv_unsigned o6) * bv_unsigned o7 ≤ 4294967295%Z) ∧ (∀(o8 : bv 32%N), bv_unsigned o8 = Z.pow 2%Z (bv_unsigned o6) * bv_unsigned o7 -> 0%Z ≤ bv_unsigned o8 ∧ (∀(pp : ptr (bv 64%N)), plength pp = bv_unsigned o8 ∧ offset pp = 0%Z ∧ min pp = 0%Z ∧ C.max pp = bv_unsigned o8 ∧ writable pp = true -> (min pp ≤ offset pp + 0%Z ∧ offset pp + 0%Z ≤ C.max pp) ∧ (∀(o9 : ptr (bv 64%N)), offset o9 = offset pp + 0%Z ∧ plength o9 = plength pp ∧ pelts o9 = pelts pp ∧ data o9 = data pp ∧ min o9 = min pp ∧ C.max o9 = C.max pp ∧ zone1 o9 = zone1 pp ∧ writable o9 = writable pp -> ((valid o9 (bv_signed n) ∧ valid bp (bv_signed bn) ∧ valid mp (bv_signed n)) ∧ (1%Z ≤ bv_signed n ∧ 1%Z ≤ bv_signed bn) ∧ bv_signed bn + bv_signed n < 2147483647%Z ∧ 0%Z < bv_unsigned (pelts mp (offset mp + bv_signed n - 1%Z)) ∧ writable o9 = true) ∧ (∀(this_pp : ptr (bv 64%N)) (pp1 : ptr (bv 64%N)), data this_pp = data pp1 ∧ length (data pp1) = length (data o9) ∧ offset this_pp = offset o9 ∧ min this_pp = min o9 ∧ C.max this_pp = C.max o9 ∧ writable this_pp = writable o9 ∧ zone1 this_pp = zone1 o9 -> data this_pp = data pp1 ∧ length (data pp1) = length (data o9) ∧ offset this_pp = offset o9 ∧ min this_pp = min o9 ∧ C.max this_pp = C.max o9 ∧ writable this_pp = writable o9 ∧ zone1 this_pp = zone1 o9 -> length (data pp1) = length (data pp) ∧ offset pp1 = offset pp ∧ min pp1 = min pp ∧ C.max pp1 = C.max pp ∧ writable pp1 = writable pp ∧ zone1 pp1 = zone1 pp -> value this_pp (bv_signed n) = ZEuclid.modulo (Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value bp (bv_signed bn)) (value mp (bv_signed n)) ∧ redc (value this_pp (bv_signed n)) (value bp (bv_signed bn)) (bv_signed n) (value mp (bv_signed n)) -> (0%Z < bv_signed n ∧ valid this_pp (bv_signed n) ∧ valid this_pp (bv_signed n) ∧ valid tp (bv_signed n + bv_signed n) ∧ writable tp = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp1 : ptr (bv 64%N)), offset tp1 = offset tp ∧ writable tp1 = writable tp ∧ zone1 tp1 = zone1 tp -> value tp1 (bv_signed n + bv_signed n) = value this_pp (bv_signed n) * value this_pp (bv_signed n) ∧ min tp1 = min tp ∧ C.max tp1 = C.max tp ∧ plength tp1 = plength tp ∧ (∀(j : Z), min tp1 ≤ j ∧ j < offset tp1 ∨ offset tp1 + bv_signed n + bv_signed n ≤ j ∧ j < C.max tp1 -> pelts tp1 j = pelts tp j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp1 (2%Z * bv_signed n) ∧ valid rp (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp1 = true ∧ writable rp = true) ∧ (∀(tp2 : ptr (bv 64%N)) (rp1 : ptr (bv 64%N)), length (data tp2) = length (data tp1) ∧ offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ C.max tp2 = C.max tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> length (data rp1) = length (data rp) ∧ offset rp1 = offset rp ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> redc (value tp1 (2%Z * bv_signed n)) (value rp1 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp1 ∨ offset rp1 + bv_signed n ≤ j -> pelts rp1 j = pelts rp j) ∧ (value tp1 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp1 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> 0%Z ≤ bv_signed windowsize ∧ (∀(o10 : bv 32%N), bv_unsigned o10 = bv_signed windowsize -> uint'32_in_bounds (bv_unsigned o10 - 1%Z) ∧ (∀(o11 : bv 32%N), bv_unsigned o11 = bv_unsigned o10 - 1%Z -> ((0%Z ≤ bv_unsigned o11 ∧ bv_unsigned o11 < 32%Z) ∧ Z.pow 2%Z (bv_unsigned o11) * bv_unsigned (1%bv : bv 32%N) ≤ 4294967295%Z) ∧ (∀(o12 : bv 32%N), bv_unsigned o12 = Z.pow 2%Z (bv_unsigned o11) * bv_unsigned (1%bv : bv 32%N) -> uint'32_in_bounds (bv_unsigned o12 - 1%Z) ∧ (∀(o13 : bv 32%N), bv_unsigned o13 = bv_unsigned o12 - 1%Z -> (1%Z - 1%Z ≤ bv_unsigned o13 -> (0%Z = Z.pow 2%Z (bv_signed windowsize - 1%Z) - 1%Z - bv_unsigned o13 ∧ (min pp1 = 0%Z ∧ 0%Z ≤ 0%Z * bv_signed n) ∧ (1%Z < bv_signed windowsize -> 1%Z < bv_unsigned o13 -> 0%Z * bv_signed n + bv_signed n + bv_signed n ≤ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n ∧ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n = C.max pp1) ∧ offset this_pp = 0%Z * bv_signed n ∧ pelts this_pp = pelts pp1 ∧ min this_pp = min pp1 ∧ C.max this_pp = C.max pp1 ∧ plength this_pp = plength pp1 ∧ writable this_pp = true ∧ (∀(k : Z), 0%Z ≤ k ∧ k ≤ 0%Z -> redc (value_sub (pelts pp1) (k * bv_signed n) (k * bv_signed n + bv_signed n)) (Z.pow vb (2%Z * k + 1%Z)) (bv_signed n) vm)) ∧ (∀(j : Z) (this_pp1 : ptr (bv 64%N)) (pp2 : ptr (bv 64%N)) (tp3 : ptr (bv 64%N)), length (data pp2) = length (data pp1) ∧ offset pp2 = offset pp1 ∧ min pp2 = min pp1 ∧ C.max pp2 = C.max pp1 ∧ writable pp2 = writable pp1 ∧ zone1 pp2 = zone1 pp1 -> offset tp3 = offset tp2 ∧ writable tp3 = writable tp2 ∧ zone1 tp3 = zone1 tp2 -> (∀(i : bv 32%N), let i1 : Z := bv_unsigned i in (i1 ≤ bv_unsigned o13 ∧ 1%Z ≤ i1) ∧ j = Z.pow 2%Z (bv_signed windowsize - 1%Z) - 1%Z - i1 ∧ (min pp2 = 0%Z ∧ 0%Z ≤ j * bv_signed n) ∧ (1%Z < bv_signed windowsize -> 1%Z < i1 -> j * bv_signed n + bv_signed n + bv_signed n ≤ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n ∧ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n = C.max pp2) ∧ offset this_pp1 = j * bv_signed n ∧ pelts this_pp1 = pelts pp2 ∧ min this_pp1 = min pp2 ∧ C.max this_pp1 = C.max pp2 ∧ plength this_pp1 = plength pp2 ∧ writable this_pp1 = true ∧ plength tp3 = plength tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2 ∧ (∀(k : Z), 0%Z ≤ k ∧ k ≤ j -> redc (value_sub (pelts pp2) (k * bv_signed n) (k * bv_signed n + bv_signed n)) (Z.pow vb (2%Z * k + 1%Z)) (bv_signed n) vm) -> (0%Z < bv_signed n ∧ valid this_pp1 (bv_signed n) ∧ valid rp1 (bv_signed n) ∧ valid tp3 (bv_signed n + bv_signed n) ∧ writable tp3 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp4 : ptr (bv 64%N)), offset tp4 = offset tp3 ∧ writable tp4 = writable tp3 ∧ zone1 tp4 = zone1 tp3 -> value tp4 (bv_signed n + bv_signed n) = value this_pp1 (bv_signed n) * value rp1 (bv_signed n) ∧ min tp4 = min tp3 ∧ C.max tp4 = C.max tp3 ∧ plength tp4 = plength tp3 ∧ (∀(j1 : Z), min tp4 ≤ j1 ∧ j1 < offset tp4 ∨ offset tp4 + bv_signed n + bv_signed n ≤ j1 ∧ j1 < C.max tp4 -> pelts tp4 j1 = pelts tp3 j1) -> (min this_pp1 ≤ offset this_pp1 + bv_signed n ∧ offset this_pp1 + bv_signed n ≤ C.max this_pp1) ∧ (∀(o14 : ptr (bv 64%N)), offset o14 = offset this_pp1 + bv_signed n ∧ plength o14 = plength this_pp1 ∧ pelts o14 = pelts this_pp1 ∧ data o14 = data this_pp1 ∧ min o14 = min this_pp1 ∧ C.max o14 = C.max this_pp1 ∧ zone1 o14 = zone1 this_pp1 ∧ writable o14 = writable this_pp1 -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp4 (2%Z * bv_signed n) ∧ valid o14 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp4 = true ∧ writable o14 = true) ∧ (∀(this_pp2 : ptr (bv 64%N)) (pp3 : ptr (bv 64%N)) (tp5 : ptr (bv 64%N)), data this_pp2 = data pp3 ∧ length (data pp3) = length (data o14) ∧ offset this_pp2 = offset o14 ∧ min this_pp2 = min o14 ∧ C.max this_pp2 = C.max o14 ∧ writable this_pp2 = writable o14 ∧ zone1 this_pp2 = zone1 o14 -> data this_pp2 = data pp3 ∧ length (data pp3) = length (data o14) ∧ offset this_pp2 = offset o14 ∧ min this_pp2 = min o14 ∧ C.max this_pp2 = C.max o14 ∧ writable this_pp2 = writable o14 ∧ zone1 this_pp2 = zone1 o14 -> length (data pp3) = length (data pp2) ∧ offset pp3 = offset pp2 ∧ min pp3 = min pp2 ∧ C.max pp3 = C.max pp2 ∧ writable pp3 = writable pp2 ∧ zone1 pp3 = zone1 pp2 -> length (data tp5) = length (data tp4) ∧ offset tp5 = offset tp4 ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> redc (value tp4 (2%Z * bv_signed n)) (value this_pp2 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset this_pp2 ∨ offset this_pp2 + bv_signed n ≤ j1 -> pelts this_pp2 j1 = pelts o14 j1) ∧ (value tp4 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value this_pp2 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> j + 1%Z = Z.pow 2%Z (bv_signed windowsize - 1%Z) - 1%Z - (i1 - 1%Z) ∧ (min pp3 = 0%Z ∧ 0%Z ≤ (j + 1%Z) * bv_signed n) ∧ (1%Z < bv_signed windowsize -> 1%Z < i1 - 1%Z -> (j + 1%Z) * bv_signed n + bv_signed n + bv_signed n ≤ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n ∧ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n = C.max pp3) ∧ offset this_pp2 = (j + 1%Z) * bv_signed n ∧ pelts this_pp2 = pelts pp3 ∧ min this_pp2 = min pp3 ∧ C.max this_pp2 = C.max pp3 ∧ plength this_pp2 = plength pp3 ∧ writable this_pp2 = true ∧ plength tp5 = plength tp2 ∧ min tp5 = min tp2 ∧ C.max tp5 = C.max tp2 ∧ (∀(k : Z), 0%Z ≤ k ∧ k ≤ j + 1%Z -> redc (value_sub (pelts pp3) (k * bv_signed n) (k * bv_signed n + bv_signed n)) (Z.pow vb (2%Z * k + 1%Z)) (bv_signed n) vm))))) ∧ (j = Z.pow 2%Z (bv_signed windowsize - 1%Z) - 1%Z - (1%Z - 1%Z) ∧ (min pp2 = 0%Z ∧ 0%Z ≤ j * bv_signed n) ∧ (1%Z < bv_signed windowsize -> 1%Z < 1%Z - 1%Z -> j * bv_signed n + bv_signed n + bv_signed n ≤ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n ∧ Z.pow 2%Z (bv_signed windowsize - 1%Z) * bv_signed n = C.max pp2) ∧ offset this_pp1 = j * bv_signed n ∧ pelts this_pp1 = pelts pp2 ∧ min this_pp1 = min pp2 ∧ C.max this_pp1 = C.max pp2 ∧ plength this_pp1 = plength pp2 ∧ writable this_pp1 = true ∧ plength tp3 = plength tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2 ∧ (∀(k : Z), 0%Z ≤ k ∧ k ≤ j -> redc (value_sub (pelts pp2) (k * bv_signed n) (k * bv_signed n + bv_signed n)) (Z.pow vb (2%Z * k + 1%Z)) (bv_signed n) vm) -> ((1%Z ≤ bv_signed windowsize ∧ bv_signed windowsize < 64%Z) ∧ 0%Z ≤ bv_signed o4 ∧ 1%Z ≤ bv_signed en ∧ valid ep (bv_signed en) ∧ ZEuclid.div (bv_signed o4 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o14 : bv 64%N), (bv_signed windowsize ≤ bv_signed o4 -> valueb ep (bv_signed o4) = valueb ep (bv_signed o4 - bv_signed windowsize) + Z.pow 2%Z (bv_signed o4 - bv_signed windowsize) * bv_unsigned o14) ∧ (bv_signed o4 < bv_signed windowsize -> valueb ep (bv_signed o4) = bv_unsigned o14) ∧ (0%Z ≤ bv_unsigned o14 ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize)) ∧ bv_unsigned o14 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed o4 - bv_signed windowsize))) (Z.pow 2%Z (bv_signed windowsize)) -> (if decide (bv_signed o4 < bv_signed windowsize) then ve = valueb ep (bv_signed (0%bv : bv 32%N)) + Z.pow 2%Z (bv_signed (0%bv : bv 32%N)) * bv_unsigned o14 ∧ (0%Z ≤ bv_signed (0%bv : bv 32%N) ∧ bv_signed (0%bv : bv 32%N) ≤ bv_signed o4) ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize) else int'32_in_bounds (bv_signed o4 - bv_signed windowsize) ∧ (∀(o15 : bv 32%N), bv_signed o15 = bv_signed o4 - bv_signed windowsize -> ve = valueb ep (bv_signed o15) + Z.pow 2%Z (bv_signed o15) * bv_unsigned o14 ∧ (0%Z ≤ bv_signed o15 ∧ bv_signed o15 ≤ bv_signed o4) ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize))) ∧ (∀(ebi : bv 32%N), ve = valueb ep (bv_signed ebi) + Z.pow 2%Z (bv_signed ebi) * bv_unsigned o14 ∧ (0%Z ≤ bv_signed ebi ∧ bv_signed ebi ≤ bv_signed o4) ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize) -> 0%Z < bv_unsigned o14 ∧ (∀(o15 : bv 32%N), (0%Z ≤ bv_signed o15 ∧ bv_signed o15 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o14) (Z.pow 2%Z (bv_signed o15)) = 0%Z ∧ ¬ ZEuclid.modulo (bv_unsigned o14) (Z.pow 2%Z (bv_signed o15 + 1%Z)) = 0%Z -> int'32_in_bounds (bv_signed ebi + bv_signed o15) ∧ (∀(o16 : bv 32%N), bv_signed o16 = bv_signed ebi + bv_signed o15 -> 0%Z ≤ bv_signed o15 ∧ (∀(o17 : bv 64%N), bv_unsigned o17 = bv_signed o15 -> ((0%Z ≤ bv_unsigned o17 ∧ bv_unsigned o17 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o14) (Z.pow 2%Z (bv_unsigned o17)) = 0%Z) ∧ (∀(o18 : bv 64%N), bv_unsigned o14 = Z.pow 2%Z (bv_unsigned o17) * bv_unsigned o18 -> (0%Z ≤ 1%Z ∧ 1%Z < 64%Z) ∧ (∀(o19 : bv 64%N), bv_unsigned o19 = ZEuclid.div (bv_unsigned o18) (Z.pow 2%Z 1%Z) -> bv_unsigned o19 ≤ 2147483647%Z ∧ (∀(ebh : bv 32%N), bv_signed ebh = bv_unsigned o19 -> int'32_in_bounds (bv_signed n * bv_signed ebh) ∧ (∀(o20 : bv 32%N), bv_signed o20 = bv_signed n * bv_signed ebh -> (min pp2 ≤ offset pp2 + bv_signed o20 ∧ offset pp2 + bv_signed o20 ≤ C.max pp2) ∧ (∀(ppn : ptr (bv 64%N)), offset ppn = offset pp2 + bv_signed o20 ∧ plength ppn = plength pp2 ∧ pelts ppn = pelts pp2 ∧ data ppn = data pp2 ∧ min ppn = min pp2 ∧ C.max ppn = C.max pp2 ∧ zone1 ppn = zone1 pp2 ∧ writable ppn = writable pp2 -> (valid ppn (bv_signed n) ∧ valid rp1 (bv_signed n) ∧ writable rp1 = true) ∧ (∀(rp2 : ptr (bv 64%N)), length (data rp2) = length (data rp1) ∧ offset rp2 = offset rp1 ∧ min rp2 = min rp1 ∧ C.max rp2 = C.max rp1 ∧ writable rp2 = writable rp1 ∧ zone1 rp2 = zone1 rp1 -> map_eq_sub_shift (pelts rp2) (pelts ppn) (offset rp2) (offset ppn) (bv_signed n) ∧ (∀(j1 : Z), j1 < offset rp2 ∨ offset rp2 + bv_signed n ≤ j1 -> pelts rp2 j1 = pelts rp1 j1) -> (let o21 : Z := bv_unsigned o18 in ((0%Z ≤ bv_signed o16 ∧ bv_signed o16 ≤ bv_signed o16) ∧ 0%Z ≤ o21 ∧ ZEuclid.div (bv_signed o16 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp2 (bv_signed n)) (Z.pow vb o21) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o16) + Z.pow 2%Z (bv_signed o16) * o21 ∧ plength tp3 = plength tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2) ∧ (∀(expdone : Z) (ebi1 : bv 32%N) (tp4 : ptr (bv 64%N)) (rp3 : ptr (bv 64%N)), offset tp4 = offset tp3 ∧ writable tp4 = writable tp3 ∧ zone1 tp4 = zone1 tp3 -> length (data rp3) = length (data rp2) ∧ offset rp3 = offset rp2 ∧ min rp3 = min rp2 ∧ C.max rp3 = C.max rp2 ∧ writable rp3 = writable rp2 ∧ zone1 rp3 = zone1 rp2 -> (0%Z ≤ bv_signed ebi1 ∧ bv_signed ebi1 ≤ bv_signed o16) ∧ 0%Z ≤ expdone ∧ ZEuclid.div (bv_signed ebi1 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp3 (bv_signed n)) (Z.pow vb expdone) (bv_signed n) vm ∧ ve = valueb ep (bv_signed ebi1) + Z.pow 2%Z (bv_signed ebi1) * expdone ∧ plength tp4 = plength tp2 ∧ min tp4 = min tp2 ∧ C.max tp4 = C.max tp2 -> (∀(o22 : bool), (bv_signed ebi1 = bv_signed (0%bv : bv 32%N) -> o22 = true) ∧ (o22 = true -> ebi1 = (0%bv : bv 32%N)) -> (if decide (¬ o22 = true) then ((1%Z ≤ bv_signed ebi1 ∧ bv_signed ebi1 ≤ bv_signed ebi1) ∧ 0%Z ≤ expdone ∧ ZEuclid.div (bv_signed ebi1 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp3 (bv_signed n)) (Z.pow vb expdone) (bv_signed n) vm ∧ ve = valueb ep (bv_signed ebi1) + Z.pow 2%Z (bv_signed ebi1) * expdone ∧ plength tp4 = plength tp2 ∧ min tp4 = min tp2 ∧ C.max tp4 = C.max tp2) ∧ (∀(expdone1 : Z) (ebi2 : bv 32%N) (tp5 : ptr (bv 64%N)) (rp4 : ptr (bv 64%N)), offset tp5 = offset tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> length (data rp4) = length (data rp3) ∧ offset rp4 = offset rp3 ∧ min rp4 = min rp3 ∧ C.max rp4 = C.max rp3 ∧ writable rp4 = writable rp3 ∧ zone1 rp4 = zone1 rp3 -> (1%Z ≤ bv_signed ebi2 ∧ bv_signed ebi2 ≤ bv_signed ebi1) ∧ 0%Z ≤ expdone1 ∧ ZEuclid.div (bv_signed ebi2 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp4 (bv_signed n)) (Z.pow vb expdone1) (bv_signed n) vm ∧ ve = valueb ep (bv_signed ebi2) + Z.pow 2%Z (bv_signed ebi2) * expdone1 ∧ plength tp5 = plength tp2 ∧ min tp5 = min tp2 ∧ C.max tp5 = C.max tp2 -> (valid ep (bv_signed en) ∧ 1%Z ≤ bv_signed ebi2 ∧ ZEuclid.div (bv_signed ebi2 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o23 : bv 64%N), (0%Z ≤ bv_unsigned o23 ∧ bv_unsigned o23 ≤ 1%Z) ∧ bv_unsigned o23 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed ebi2 - 1%Z))) 2%Z ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed ebi2 - 1%Z) + Z.pow 2%Z (bv_signed ebi2 - 1%Z) * bv_unsigned o23 -> (∀(o24 : bool), (bv_unsigned o23 = bv_unsigned (0%bv : bv 64%N) -> o24 = true) ∧ (o24 = true -> o23 = (0%bv : bv 64%N)) -> (if decide (o24 = true) then (0%Z < bv_signed n ∧ valid rp4 (bv_signed n) ∧ valid rp4 (bv_signed n) ∧ valid tp5 (bv_signed n + bv_signed n) ∧ writable tp5 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp6 : ptr (bv 64%N)), offset tp6 = offset tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> value tp6 (bv_signed n + bv_signed n) = value rp4 (bv_signed n) * value rp4 (bv_signed n) ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ plength tp6 = plength tp5 ∧ (∀(j1 : Z), min tp6 ≤ j1 ∧ j1 < offset tp6 ∨ offset tp6 + bv_signed n + bv_signed n ≤ j1 ∧ j1 < C.max tp6 -> pelts tp6 j1 = pelts tp5 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp6 (2%Z * bv_signed n) ∧ valid rp4 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp6 = true ∧ writable rp4 = true) ∧ (∀(tp7 : ptr (bv 64%N)) (rp5 : ptr (bv 64%N)), length (data tp7) = length (data tp6) ∧ offset tp7 = offset tp6 ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> redc (value tp6 (2%Z * bv_signed n)) (value rp5 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp5 ∨ offset rp5 + bv_signed n ≤ j1 -> pelts rp5 j1 = pelts rp4 j1) ∧ (value tp6 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp5 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> int'32_in_bounds (bv_signed ebi2 - 1%Z) ∧ (∀(o25 : bv 32%N), bv_signed o25 = bv_signed ebi2 - 1%Z -> (∀(o26 : bool), (bv_signed o25 = bv_signed (0%bv : bv 32%N) -> o26 = true) ∧ (o26 = true -> o25 = (0%bv : bv 32%N)) -> (if decide (o26 = true) then ∀(o27 : bool), (bv_signed o25 = bv_signed (0%bv : bv 32%N) -> o27 = true) ∧ (o27 = true -> o25 = (0%bv : bv 32%N)) -> (if decide (o27 = true) then (valid rp5 (bv_signed n) ∧ valid tp7 (bv_signed n) ∧ writable tp7 = true) ∧ (∀(tp8 : ptr (bv 64%N)), length (data tp8) = length (data tp7) ∧ offset tp8 = offset tp7 ∧ min tp8 = min tp7 ∧ C.max tp8 = C.max tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> map_eq_sub_shift (pelts tp8) (pelts rp5) (offset tp8) (offset rp5) (bv_signed n) ∧ (∀(j1 : Z), j1 < offset tp8 ∨ offset tp8 + bv_signed n ≤ j1 -> pelts tp8 j1 = pelts tp7 j1) -> (min tp8 ≤ offset tp8 + bv_signed n ∧ offset tp8 + bv_signed n ≤ C.max tp8) ∧ (∀(o28 : ptr (bv 64%N)), offset o28 = offset tp8 + bv_signed n ∧ plength o28 = plength tp8 ∧ pelts o28 = pelts tp8 ∧ data o28 = data tp8 ∧ min o28 = min tp8 ∧ C.max o28 = C.max tp8 ∧ zone1 o28 = zone1 tp8 ∧ writable o28 = writable tp8 -> (valid o28 (bv_signed n) ∧ writable o28 = true) ∧ (∀(o29 : ptr (bv 64%N)) (tp9 : ptr (bv 64%N)), data o29 = data tp9 ∧ length (data tp9) = length (data o28) ∧ offset o29 = offset o28 ∧ min o29 = min o28 ∧ C.max o29 = C.max o28 ∧ writable o29 = writable o28 ∧ zone1 o29 = zone1 o28 -> length (data tp9) = length (data tp8) ∧ offset tp9 = offset tp8 ∧ min tp9 = min tp8 ∧ C.max tp9 = C.max tp8 ∧ writable tp9 = writable tp8 ∧ zone1 tp9 = zone1 tp8 -> value o29 (bv_signed n) = 0%Z ∧ (∀(j1 : Z), j1 < offset o29 ∨ offset o29 + bv_signed n ≤ j1 -> pelts o29 j1 = pelts o28 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp9 (2%Z * bv_signed n) ∧ valid rp5 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp9 = true ∧ writable rp5 = true) ∧ (∀(rp6 : ptr (bv 64%N)), length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> redc (value tp9 (2%Z * bv_signed n)) (value rp6 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp6 ∨ offset rp6 + bv_signed n ≤ j1 -> pelts rp6 j1 = pelts rp5 j1) ∧ (value tp9 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp6 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> ((valid rp6 (bv_signed n) ∧ valid mp (bv_signed n)) ∧ (∀(o30 : bv 32%N), bv_signed o30 = compare_int (value rp6 (bv_signed n)) (value mp (bv_signed n)) -> (if decide (0%Z ≤ bv_signed o30) then (0%Z ≤ bv_signed n ∧ valid rp6 (bv_signed n) ∧ valid mp (bv_signed n) ∧ writable rp6 = true) ∧ (∀(rp7 : ptr (bv 64%N)), length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> (∀(x_b : bv 64%N), value rp7 (bv_signed n) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned x_b = value rp6 (bv_signed n) - value mp (bv_signed n) ∧ (0%Z ≤ bv_unsigned x_b ∧ bv_unsigned x_b ≤ 1%Z) ∧ (∀(j1 : Z), j1 < offset rp7 ∨ offset rp7 + bv_signed n ≤ j1 -> pelts rp7 j1 = pelts rp6 j1) -> ZEuclid.modulo (value rp7 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp7 (bv_signed n) < vm)) else ZEuclid.modulo (value rp6 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp6 (bv_signed n) < vm))) ∧ (∀(rp7 : ptr (bv 64%N)), length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> ZEuclid.modulo (value rp7 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp7 (bv_signed n) < vm -> value rp7 (bv_signed n) = ZEuclid.modulo (Z.pow (value bp (bv_signed bn)) (value ep (bv_signed en))) (value mp (bv_signed n))))))) else ((1%Z ≤ bv_signed windowsize ∧ bv_signed windowsize < 64%Z) ∧ 0%Z ≤ bv_signed o25 ∧ 1%Z ≤ bv_signed en ∧ valid ep (bv_signed en) ∧ ZEuclid.div (bv_signed o25 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o28 : bv 64%N), (bv_signed windowsize ≤ bv_signed o25 -> valueb ep (bv_signed o25) = valueb ep (bv_signed o25 - bv_signed windowsize) + Z.pow 2%Z (bv_signed o25 - bv_signed windowsize) * bv_unsigned o28) ∧ (bv_signed o25 < bv_signed windowsize -> valueb ep (bv_signed o25) = bv_unsigned o28) ∧ (0%Z ≤ bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed windowsize)) ∧ bv_unsigned o28 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed o25 - bv_signed windowsize))) (Z.pow 2%Z (bv_signed windowsize)) -> (if decide (bv_signed o25 < bv_signed windowsize) then int'32_in_bounds (bv_signed windowsize - bv_signed o25) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed windowsize - bv_signed o25 -> int'32_in_bounds (bv_signed windowsize - bv_signed o29) ∧ (∀(o30 : bv 32%N), bv_signed o30 = bv_signed windowsize - bv_signed o29 -> (0%Z ≤ bv_signed (0%bv : bv 32%N) ∧ bv_signed (0%bv : bv 32%N) < bv_signed o25) ∧ bv_signed (0%bv : bv 32%N) + bv_signed o30 = bv_signed o25 ∧ valueb ep (bv_signed o25) = valueb ep (bv_signed (0%bv : bv 32%N)) + Z.pow 2%Z (bv_signed (0%bv : bv 32%N)) * bv_unsigned o28 ∧ (0%Z < bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed o30)) ∧ 0%Z < bv_signed o30 ∧ bv_signed o30 ≤ bv_signed windowsize)) else int'32_in_bounds (bv_signed o25 - bv_signed windowsize) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed o25 - bv_signed windowsize -> (0%Z ≤ bv_signed o29 ∧ bv_signed o29 < bv_signed o25) ∧ bv_signed o29 + bv_signed windowsize = bv_signed o25 ∧ valueb ep (bv_signed o25) = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * bv_unsigned o28 ∧ (0%Z < bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed windowsize)) ∧ 0%Z < bv_signed windowsize ∧ bv_signed windowsize ≤ bv_signed windowsize)) ∧ (∀(this_windowsize : bv 32%N) (ebi3 : bv 32%N), (0%Z ≤ bv_signed ebi3 ∧ bv_signed ebi3 < bv_signed o25) ∧ bv_signed ebi3 + bv_signed this_windowsize = bv_signed o25 ∧ valueb ep (bv_signed o25) = valueb ep (bv_signed ebi3) + Z.pow 2%Z (bv_signed ebi3) * bv_unsigned o28 ∧ (0%Z < bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed this_windowsize)) ∧ 0%Z < bv_signed this_windowsize ∧ bv_signed this_windowsize ≤ bv_signed windowsize -> 0%Z < bv_unsigned o28 ∧ (∀(o29 : bv 32%N), (0%Z ≤ bv_signed o29 ∧ bv_signed o29 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o28) (Z.pow 2%Z (bv_signed o29)) = 0%Z ∧ ¬ ZEuclid.modulo (bv_unsigned o28) (Z.pow 2%Z (bv_signed o29 + 1%Z)) = 0%Z -> int'32_in_bounds (bv_signed this_windowsize - bv_signed o29) ∧ (∀(o30 : bv 32%N), bv_signed o30 = bv_signed this_windowsize - bv_signed o29 -> int'32_in_bounds (bv_signed ebi3 + bv_signed o29) ∧ (∀(o31 : bv 32%N), bv_signed o31 = bv_signed ebi3 + bv_signed o29 -> 0%Z ≤ bv_signed o29 ∧ (∀(o32 : bv 64%N), bv_unsigned o32 = bv_signed o29 -> ((0%Z ≤ bv_unsigned o32 ∧ bv_unsigned o32 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o28) (Z.pow 2%Z (bv_unsigned o32)) = 0%Z) ∧ (∀(o33 : bv 64%N), bv_unsigned o28 = Z.pow 2%Z (bv_unsigned o32) * bv_unsigned o33 -> ((0%Z ≤ bv_signed o30 ∧ bv_signed o30 ≤ bv_signed o30) ∧ 0%Z ≤ 2%Z * expdone1 ∧ redc (value rp5 (bv_signed n)) (Z.pow vb (2%Z * expdone1)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (bv_unsigned o33 + Z.pow 2%Z (bv_signed o30) * (2%Z * expdone1)) ∧ plength tp7 = plength tp2 ∧ min tp7 = min tp2 ∧ C.max tp7 = C.max tp2) ∧ (∀(this_windowsize1 : bv 32%N) (expdone2 : Z) (tp8 : ptr (bv 64%N)) (rp6 : ptr (bv 64%N)), offset tp8 = offset tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> (0%Z ≤ bv_signed this_windowsize1 ∧ bv_signed this_windowsize1 ≤ bv_signed o30) ∧ 0%Z ≤ expdone2 ∧ redc (value rp6 (bv_signed n)) (Z.pow vb expdone2) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (bv_unsigned o33 + Z.pow 2%Z (bv_signed this_windowsize1) * expdone2) ∧ plength tp8 = plength tp2 ∧ min tp8 = min tp2 ∧ C.max tp8 = C.max tp2 -> (∀(o34 : bool), (bv_signed this_windowsize1 = bv_signed (0%bv : bv 32%N) -> o34 = true) ∧ (o34 = true -> this_windowsize1 = (0%bv : bv 32%N)) -> (if decide (¬ o34 = true) then (0%Z < bv_signed n ∧ valid rp6 (bv_signed n) ∧ valid rp6 (bv_signed n) ∧ valid tp8 (bv_signed n + bv_signed n) ∧ writable tp8 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp9 : ptr (bv 64%N)), offset tp9 = offset tp8 ∧ writable tp9 = writable tp8 ∧ zone1 tp9 = zone1 tp8 -> value tp9 (bv_signed n + bv_signed n) = value rp6 (bv_signed n) * value rp6 (bv_signed n) ∧ min tp9 = min tp8 ∧ C.max tp9 = C.max tp8 ∧ plength tp9 = plength tp8 ∧ (∀(j1 : Z), min tp9 ≤ j1 ∧ j1 < offset tp9 ∨ offset tp9 + bv_signed n + bv_signed n ≤ j1 ∧ j1 < C.max tp9 -> pelts tp9 j1 = pelts tp8 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp9 (2%Z * bv_signed n) ∧ valid rp6 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp9 = true ∧ writable rp6 = true) ∧ (∀(tp10 : ptr (bv 64%N)) (rp7 : ptr (bv 64%N)), length (data tp10) = length (data tp9) ∧ offset tp10 = offset tp9 ∧ min tp10 = min tp9 ∧ C.max tp10 = C.max tp9 ∧ writable tp10 = writable tp9 ∧ zone1 tp10 = zone1 tp9 -> length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> redc (value tp9 (2%Z * bv_signed n)) (value rp7 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp7 ∨ offset rp7 + bv_signed n ≤ j1 -> pelts rp7 j1 = pelts rp6 j1) ∧ (value tp9 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp7 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> int'32_in_bounds (bv_signed this_windowsize1 - 1%Z) ∧ (∀(o35 : bv 32%N), bv_signed o35 = bv_signed this_windowsize1 - 1%Z -> bv_signed o35 < bv_signed this_windowsize1 ∧ (0%Z ≤ bv_signed o35 ∧ bv_signed o35 ≤ bv_signed o30) ∧ 0%Z ≤ 2%Z * expdone2 ∧ redc (value rp7 (bv_signed n)) (Z.pow vb (2%Z * expdone2)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (bv_unsigned o33 + Z.pow 2%Z (bv_signed o35) * (2%Z * expdone2)) ∧ plength tp10 = plength tp2 ∧ min tp10 = min tp2 ∧ C.max tp10 = C.max tp2))) else (0%Z ≤ 1%Z ∧ 1%Z < 64%Z) ∧ (∀(o35 : bv 64%N), bv_unsigned o35 = ZEuclid.div (bv_unsigned o33) (Z.pow 2%Z 1%Z) -> bv_unsigned o35 ≤ 2147483647%Z ∧ (∀(ebh1 : bv 32%N), bv_signed ebh1 = bv_unsigned o35 -> int'32_in_bounds (bv_signed n * bv_signed ebh1) ∧ (∀(o36 : bv 32%N), bv_signed o36 = bv_signed n * bv_signed ebh1 -> (min pp2 ≤ offset pp2 + bv_signed o36 ∧ offset pp2 + bv_signed o36 ≤ C.max pp2) ∧ (∀(ppn1 : ptr (bv 64%N)), offset ppn1 = offset pp2 + bv_signed o36 ∧ plength ppn1 = plength pp2 ∧ pelts ppn1 = pelts pp2 ∧ data ppn1 = data pp2 ∧ min ppn1 = min pp2 ∧ C.max ppn1 = C.max pp2 ∧ zone1 ppn1 = zone1 pp2 ∧ writable ppn1 = writable pp2 -> (0%Z < bv_signed n ∧ valid rp6 (bv_signed n) ∧ valid ppn1 (bv_signed n) ∧ valid tp8 (bv_signed n + bv_signed n) ∧ writable tp8 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp9 : ptr (bv 64%N)), offset tp9 = offset tp8 ∧ writable tp9 = writable tp8 ∧ zone1 tp9 = zone1 tp8 -> value tp9 (bv_signed n + bv_signed n) = value rp6 (bv_signed n) * value ppn1 (bv_signed n) ∧ min tp9 = min tp8 ∧ C.max tp9 = C.max tp8 ∧ plength tp9 = plength tp8 ∧ (∀(j1 : Z), min tp9 ≤ j1 ∧ j1 < offset tp9 ∨ offset tp9 + bv_signed n + bv_signed n ≤ j1 ∧ j1 < C.max tp9 -> pelts tp9 j1 = pelts tp8 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp9 (2%Z * bv_signed n) ∧ valid rp6 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp9 = true ∧ writable rp6 = true) ∧ (∀(tp10 : ptr (bv 64%N)) (rp7 : ptr (bv 64%N)), length (data tp10) = length (data tp9) ∧ offset tp10 = offset tp9 ∧ min tp10 = min tp9 ∧ C.max tp10 = C.max tp9 ∧ writable tp10 = writable tp9 ∧ zone1 tp10 = zone1 tp9 -> length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> redc (value tp9 (2%Z * bv_signed n)) (value rp7 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp7 ∨ offset rp7 + bv_signed n ≤ j1 -> pelts rp7 j1 = pelts rp6 j1) ∧ (value tp9 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp7 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> bv_signed o31 < bv_signed ebi1 ∧ (0%Z ≤ bv_signed o31 ∧ bv_signed o31 ≤ bv_signed o16) ∧ 0%Z ≤ expdone2 + bv_unsigned o33 ∧ ZEuclid.div (bv_signed o31 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp7 (bv_signed n)) (Z.pow vb (expdone2 + bv_unsigned o33)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (expdone2 + bv_unsigned o33) ∧ plength tp10 = plength tp2 ∧ min tp10 = min tp2 ∧ C.max tp10 = C.max tp2))))))))))))))))) else bv_signed o25 < bv_signed ebi2 ∧ (1%Z ≤ bv_signed o25 ∧ bv_signed o25 ≤ bv_signed ebi1) ∧ 0%Z ≤ 2%Z * expdone1 ∧ ZEuclid.div (bv_signed o25 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp5 (bv_signed n)) (Z.pow vb (2%Z * expdone1)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o25) + Z.pow 2%Z (bv_signed o25) * (2%Z * expdone1) ∧ plength tp7 = plength tp2 ∧ min tp7 = min tp2 ∧ C.max tp7 = C.max tp2))))) else ∀(o25 : bool), (bv_signed ebi2 = bv_signed (0%bv : bv 32%N) -> o25 = true) ∧ (o25 = true -> ebi2 = (0%bv : bv 32%N)) -> (if decide (o25 = true) then (valid rp4 (bv_signed n) ∧ valid tp5 (bv_signed n) ∧ writable tp5 = true) ∧ (∀(tp6 : ptr (bv 64%N)), length (data tp6) = length (data tp5) ∧ offset tp6 = offset tp5 ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> map_eq_sub_shift (pelts tp6) (pelts rp4) (offset tp6) (offset rp4) (bv_signed n) ∧ (∀(j1 : Z), j1 < offset tp6 ∨ offset tp6 + bv_signed n ≤ j1 -> pelts tp6 j1 = pelts tp5 j1) -> (min tp6 ≤ offset tp6 + bv_signed n ∧ offset tp6 + bv_signed n ≤ C.max tp6) ∧ (∀(o26 : ptr (bv 64%N)), offset o26 = offset tp6 + bv_signed n ∧ plength o26 = plength tp6 ∧ pelts o26 = pelts tp6 ∧ data o26 = data tp6 ∧ min o26 = min tp6 ∧ C.max o26 = C.max tp6 ∧ zone1 o26 = zone1 tp6 ∧ writable o26 = writable tp6 -> (valid o26 (bv_signed n) ∧ writable o26 = true) ∧ (∀(o27 : ptr (bv 64%N)) (tp7 : ptr (bv 64%N)), data o27 = data tp7 ∧ length (data tp7) = length (data o26) ∧ offset o27 = offset o26 ∧ min o27 = min o26 ∧ C.max o27 = C.max o26 ∧ writable o27 = writable o26 ∧ zone1 o27 = zone1 o26 -> length (data tp7) = length (data tp6) ∧ offset tp7 = offset tp6 ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> value o27 (bv_signed n) = 0%Z ∧ (∀(j1 : Z), j1 < offset o27 ∨ offset o27 + bv_signed n ≤ j1 -> pelts o27 j1 = pelts o26 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp7 (2%Z * bv_signed n) ∧ valid rp4 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp7 = true ∧ writable rp4 = true) ∧ (∀(rp5 : ptr (bv 64%N)), length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> redc (value tp7 (2%Z * bv_signed n)) (value rp5 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp5 ∨ offset rp5 + bv_signed n ≤ j1 -> pelts rp5 j1 = pelts rp4 j1) ∧ (value tp7 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp5 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> ((valid rp5 (bv_signed n) ∧ valid mp (bv_signed n)) ∧ (∀(o28 : bv 32%N), bv_signed o28 = compare_int (value rp5 (bv_signed n)) (value mp (bv_signed n)) -> (if decide (0%Z ≤ bv_signed o28) then (0%Z ≤ bv_signed n ∧ valid rp5 (bv_signed n) ∧ valid mp (bv_signed n) ∧ writable rp5 = true) ∧ (∀(rp6 : ptr (bv 64%N)), length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> (∀(x_b : bv 64%N), value rp6 (bv_signed n) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned x_b = value rp5 (bv_signed n) - value mp (bv_signed n) ∧ (0%Z ≤ bv_unsigned x_b ∧ bv_unsigned x_b ≤ 1%Z) ∧ (∀(j1 : Z), j1 < offset rp6 ∨ offset rp6 + bv_signed n ≤ j1 -> pelts rp6 j1 = pelts rp5 j1) -> ZEuclid.modulo (value rp6 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp6 (bv_signed n) < vm)) else ZEuclid.modulo (value rp5 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp5 (bv_signed n) < vm))) ∧ (∀(rp6 : ptr (bv 64%N)), length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> ZEuclid.modulo (value rp6 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp6 (bv_signed n) < vm -> value rp6 (bv_signed n) = ZEuclid.modulo (Z.pow (value bp (bv_signed bn)) (value ep (bv_signed en))) (value mp (bv_signed n))))))) else ((1%Z ≤ bv_signed windowsize ∧ bv_signed windowsize < 64%Z) ∧ 0%Z ≤ bv_signed ebi2 ∧ 1%Z ≤ bv_signed en ∧ valid ep (bv_signed en) ∧ ZEuclid.div (bv_signed ebi2 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o26 : bv 64%N), (bv_signed windowsize ≤ bv_signed ebi2 -> valueb ep (bv_signed ebi2) = valueb ep (bv_signed ebi2 - bv_signed windowsize) + Z.pow 2%Z (bv_signed ebi2 - bv_signed windowsize) * bv_unsigned o26) ∧ (bv_signed ebi2 < bv_signed windowsize -> valueb ep (bv_signed ebi2) = bv_unsigned o26) ∧ (0%Z ≤ bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed windowsize)) ∧ bv_unsigned o26 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed ebi2 - bv_signed windowsize))) (Z.pow 2%Z (bv_signed windowsize)) -> (if decide (bv_signed ebi2 < bv_signed windowsize) then int'32_in_bounds (bv_signed windowsize - bv_signed ebi2) ∧ (∀(o27 : bv 32%N), bv_signed o27 = bv_signed windowsize - bv_signed ebi2 -> int'32_in_bounds (bv_signed windowsize - bv_signed o27) ∧ (∀(o28 : bv 32%N), bv_signed o28 = bv_signed windowsize - bv_signed o27 -> (0%Z ≤ bv_signed (0%bv : bv 32%N) ∧ bv_signed (0%bv : bv 32%N) < bv_signed ebi2) ∧ bv_signed (0%bv : bv 32%N) + bv_signed o28 = bv_signed ebi2 ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed (0%bv : bv 32%N)) + Z.pow 2%Z (bv_signed (0%bv : bv 32%N)) * bv_unsigned o26 ∧ (0%Z < bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed o28)) ∧ 0%Z < bv_signed o28 ∧ bv_signed o28 ≤ bv_signed windowsize)) else int'32_in_bounds (bv_signed ebi2 - bv_signed windowsize) ∧ (∀(o27 : bv 32%N), bv_signed o27 = bv_signed ebi2 - bv_signed windowsize -> (0%Z ≤ bv_signed o27 ∧ bv_signed o27 < bv_signed ebi2) ∧ bv_signed o27 + bv_signed windowsize = bv_signed ebi2 ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed o27) + Z.pow 2%Z (bv_signed o27) * bv_unsigned o26 ∧ (0%Z < bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed windowsize)) ∧ 0%Z < bv_signed windowsize ∧ bv_signed windowsize ≤ bv_signed windowsize)) ∧ (∀(this_windowsize : bv 32%N) (ebi3 : bv 32%N), (0%Z ≤ bv_signed ebi3 ∧ bv_signed ebi3 < bv_signed ebi2) ∧ bv_signed ebi3 + bv_signed this_windowsize = bv_signed ebi2 ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed ebi3) + Z.pow 2%Z (bv_signed ebi3) * bv_unsigned o26 ∧ (0%Z < bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed this_windowsize)) ∧ 0%Z < bv_signed this_windowsize ∧ bv_signed this_windowsize ≤ bv_signed windowsize -> 0%Z < bv_unsigned o26 ∧ (∀(o27 : bv 32%N), (0%Z ≤ bv_signed o27 ∧ bv_signed o27 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o26) (Z.pow 2%Z (bv_signed o27)) = 0%Z ∧ ¬ ZEuclid.modulo (bv_unsigned o26) (Z.pow 2%Z (bv_signed o27 + 1%Z)) = 0%Z -> int'32_in_bounds (bv_signed this_windowsize - bv_signed o27) ∧ (∀(o28 : bv 32%N), bv_signed o28 = bv_signed this_windowsize - bv_signed o27 -> int'32_in_bounds (bv_signed ebi3 + bv_signed o27) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed ebi3 + bv_signed o27 -> 0%Z ≤ bv_signed o27 ∧ (∀(o30 : bv 64%N), bv_unsigned o30 = bv_signed o27 -> ((0%Z ≤ bv_unsigned o30 ∧ bv_unsigned o30 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o26) (Z.pow 2%Z (bv_unsigned o30)) = 0%Z) ∧ (∀(o31 : bv 64%N), bv_unsigned o26 = Z.pow 2%Z (bv_unsigned o30) * bv_unsigned o31 -> ((0%Z ≤ bv_signed o28 ∧ bv_signed o28 ≤ bv_signed o28) ∧ 0%Z ≤ expdone1 ∧ redc (value rp4 (bv_signed n)) (Z.pow vb expdone1) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (bv_unsigned o31 + Z.pow 2%Z (bv_signed o28) * expdone1) ∧ plength tp5 = plength tp2 ∧ min tp5 = min tp2 ∧ C.max tp5 = C.max tp2) ∧ (∀(this_windowsize1 : bv 32%N) (expdone2 : Z) (tp6 : ptr (bv 64%N)) (rp5 : ptr (bv 64%N)), offset tp6 = offset tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> (0%Z ≤ bv_signed this_windowsize1 ∧ bv_signed this_windowsize1 ≤ bv_signed o28) ∧ 0%Z ≤ expdone2 ∧ redc (value rp5 (bv_signed n)) (Z.pow vb expdone2) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (bv_unsigned o31 + Z.pow 2%Z (bv_signed this_windowsize1) * expdone2) ∧ plength tp6 = plength tp2 ∧ min tp6 = min tp2 ∧ C.max tp6 = C.max tp2 -> (∀(o32 : bool), (bv_signed this_windowsize1 = bv_signed (0%bv : bv 32%N) -> o32 = true) ∧ (o32 = true -> this_windowsize1 = (0%bv : bv 32%N)) -> (if decide (¬ o32 = true) then (0%Z < bv_signed n ∧ valid rp5 (bv_signed n) ∧ valid rp5 (bv_signed n) ∧ valid tp6 (bv_signed n + bv_signed n) ∧ writable tp6 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp7 : ptr (bv 64%N)), offset tp7 = offset tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> value tp7 (bv_signed n + bv_signed n) = value rp5 (bv_signed n) * value rp5 (bv_signed n) ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ plength tp7 = plength tp6 ∧ (∀(j1 : Z), min tp7 ≤ j1 ∧ j1 < offset tp7 ∨ offset tp7 + bv_signed n + bv_signed n ≤ j1 ∧ j1 < C.max tp7 -> pelts tp7 j1 = pelts tp6 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp7 (2%Z * bv_signed n) ∧ valid rp5 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp7 = true ∧ writable rp5 = true) ∧ (∀(tp8 : ptr (bv 64%N)) (rp6 : ptr (bv 64%N)), length (data tp8) = length (data tp7) ∧ offset tp8 = offset tp7 ∧ min tp8 = min tp7 ∧ C.max tp8 = C.max tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> redc (value tp7 (2%Z * bv_signed n)) (value rp6 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp6 ∨ offset rp6 + bv_signed n ≤ j1 -> pelts rp6 j1 = pelts rp5 j1) ∧ (value tp7 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp6 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> int'32_in_bounds (bv_signed this_windowsize1 - 1%Z) ∧ (∀(o33 : bv 32%N), bv_signed o33 = bv_signed this_windowsize1 - 1%Z -> bv_signed o33 < bv_signed this_windowsize1 ∧ (0%Z ≤ bv_signed o33 ∧ bv_signed o33 ≤ bv_signed o28) ∧ 0%Z ≤ 2%Z * expdone2 ∧ redc (value rp6 (bv_signed n)) (Z.pow vb (2%Z * expdone2)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (bv_unsigned o31 + Z.pow 2%Z (bv_signed o33) * (2%Z * expdone2)) ∧ plength tp8 = plength tp2 ∧ min tp8 = min tp2 ∧ C.max tp8 = C.max tp2))) else (0%Z ≤ 1%Z ∧ 1%Z < 64%Z) ∧ (∀(o33 : bv 64%N), bv_unsigned o33 = ZEuclid.div (bv_unsigned o31) (Z.pow 2%Z 1%Z) -> bv_unsigned o33 ≤ 2147483647%Z ∧ (∀(ebh1 : bv 32%N), bv_signed ebh1 = bv_unsigned o33 -> int'32_in_bounds (bv_signed n * bv_signed ebh1) ∧ (∀(o34 : bv 32%N), bv_signed o34 = bv_signed n * bv_signed ebh1 -> (min pp2 ≤ offset pp2 + bv_signed o34 ∧ offset pp2 + bv_signed o34 ≤ C.max pp2) ∧ (∀(ppn1 : ptr (bv 64%N)), offset ppn1 = offset pp2 + bv_signed o34 ∧ plength ppn1 = plength pp2 ∧ pelts ppn1 = pelts pp2 ∧ data ppn1 = data pp2 ∧ min ppn1 = min pp2 ∧ C.max ppn1 = C.max pp2 ∧ zone1 ppn1 = zone1 pp2 ∧ writable ppn1 = writable pp2 -> (0%Z < bv_signed n ∧ valid rp5 (bv_signed n) ∧ valid ppn1 (bv_signed n) ∧ valid tp6 (bv_signed n + bv_signed n) ∧ writable tp6 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp7 : ptr (bv 64%N)), offset tp7 = offset tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> value tp7 (bv_signed n + bv_signed n) = value rp5 (bv_signed n) * value ppn1 (bv_signed n) ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ plength tp7 = plength tp6 ∧ (∀(j1 : Z), min tp7 ≤ j1 ∧ j1 < offset tp7 ∨ offset tp7 + bv_signed n + bv_signed n ≤ j1 ∧ j1 < C.max tp7 -> pelts tp7 j1 = pelts tp6 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp7 (2%Z * bv_signed n) ∧ valid rp5 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp7 = true ∧ writable rp5 = true) ∧ (∀(tp8 : ptr (bv 64%N)) (rp6 : ptr (bv 64%N)), length (data tp8) = length (data tp7) ∧ offset tp8 = offset tp7 ∧ min tp8 = min tp7 ∧ C.max tp8 = C.max tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> redc (value tp7 (2%Z * bv_signed n)) (value rp6 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp6 ∨ offset rp6 + bv_signed n ≤ j1 -> pelts rp6 j1 = pelts rp5 j1) ∧ (value tp7 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp6 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> bv_signed o29 < bv_signed ebi1 ∧ (0%Z ≤ bv_signed o29 ∧ bv_signed o29 ≤ bv_signed o16) ∧ 0%Z ≤ expdone2 + bv_unsigned o31 ∧ ZEuclid.div (bv_signed o29 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp6 (bv_signed n)) (Z.pow vb (expdone2 + bv_unsigned o31)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (expdone2 + bv_unsigned o31) ∧ plength tp8 = plength tp2 ∧ min tp8 = min tp2 ∧ C.max tp8 = C.max tp2))))))))))))))))))))) else (valid rp3 (bv_signed n) ∧ valid tp4 (bv_signed n) ∧ writable tp4 = true) ∧ (∀(tp5 : ptr (bv 64%N)), length (data tp5) = length (data tp4) ∧ offset tp5 = offset tp4 ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> map_eq_sub_shift (pelts tp5) (pelts rp3) (offset tp5) (offset rp3) (bv_signed n) ∧ (∀(j1 : Z), j1 < offset tp5 ∨ offset tp5 + bv_signed n ≤ j1 -> pelts tp5 j1 = pelts tp4 j1) -> (min tp5 ≤ offset tp5 + bv_signed n ∧ offset tp5 + bv_signed n ≤ C.max tp5) ∧ (∀(o23 : ptr (bv 64%N)), offset o23 = offset tp5 + bv_signed n ∧ plength o23 = plength tp5 ∧ pelts o23 = pelts tp5 ∧ data o23 = data tp5 ∧ min o23 = min tp5 ∧ C.max o23 = C.max tp5 ∧ zone1 o23 = zone1 tp5 ∧ writable o23 = writable tp5 -> (valid o23 (bv_signed n) ∧ writable o23 = true) ∧ (∀(o24 : ptr (bv 64%N)) (tp6 : ptr (bv 64%N)), data o24 = data tp6 ∧ length (data tp6) = length (data o23) ∧ offset o24 = offset o23 ∧ min o24 = min o23 ∧ C.max o24 = C.max o23 ∧ writable o24 = writable o23 ∧ zone1 o24 = zone1 o23 -> length (data tp6) = length (data tp5) ∧ offset tp6 = offset tp5 ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> value o24 (bv_signed n) = 0%Z ∧ (∀(j1 : Z), j1 < offset o24 ∨ offset o24 + bv_signed n ≤ j1 -> pelts o24 j1 = pelts o23 j1) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp6 (2%Z * bv_signed n) ∧ valid rp3 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp6 = true ∧ writable rp3 = true) ∧ (∀(rp4 : ptr (bv 64%N)), length (data rp4) = length (data rp3) ∧ offset rp4 = offset rp3 ∧ min rp4 = min rp3 ∧ C.max rp4 = C.max rp3 ∧ writable rp4 = writable rp3 ∧ zone1 rp4 = zone1 rp3 -> redc (value tp6 (2%Z * bv_signed n)) (value rp4 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j1 : Z), j1 < offset rp4 ∨ offset rp4 + bv_signed n ≤ j1 -> pelts rp4 j1 = pelts rp3 j1) ∧ (value tp6 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp4 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> ((valid rp4 (bv_signed n) ∧ valid mp (bv_signed n)) ∧ (∀(o25 : bv 32%N), bv_signed o25 = compare_int (value rp4 (bv_signed n)) (value mp (bv_signed n)) -> (if decide (0%Z ≤ bv_signed o25) then (0%Z ≤ bv_signed n ∧ valid rp4 (bv_signed n) ∧ valid mp (bv_signed n) ∧ writable rp4 = true) ∧ (∀(rp5 : ptr (bv 64%N)), length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> (∀(x_b : bv 64%N), value rp5 (bv_signed n) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned x_b = value rp4 (bv_signed n) - value mp (bv_signed n) ∧ (0%Z ≤ bv_unsigned x_b ∧ bv_unsigned x_b ≤ 1%Z) ∧ (∀(j1 : Z), j1 < offset rp5 ∨ offset rp5 + bv_signed n ≤ j1 -> pelts rp5 j1 = pelts rp4 j1) -> ZEuclid.modulo (value rp5 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp5 (bv_signed n) < vm)) else ZEuclid.modulo (value rp4 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp4 (bv_signed n) < vm))) ∧ (∀(rp5 : ptr (bv 64%N)), length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> ZEuclid.modulo (value rp5 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp5 (bv_signed n) < vm -> value rp5 (bv_signed n) = ZEuclid.modulo (Z.pow (value bp (bv_signed bn)) (value ep (bv_signed en))) (value mp (bv_signed n))))))))))))))))))))))))) ∧ (bv_unsigned o13 < 1%Z - 1%Z -> ((1%Z ≤ bv_signed windowsize ∧ bv_signed windowsize < 64%Z) ∧ 0%Z ≤ bv_signed o4 ∧ 1%Z ≤ bv_signed en ∧ valid ep (bv_signed en) ∧ ZEuclid.div (bv_signed o4 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o14 : bv 64%N), (bv_signed windowsize ≤ bv_signed o4 -> valueb ep (bv_signed o4) = valueb ep (bv_signed o4 - bv_signed windowsize) + Z.pow 2%Z (bv_signed o4 - bv_signed windowsize) * bv_unsigned o14) ∧ (bv_signed o4 < bv_signed windowsize -> valueb ep (bv_signed o4) = bv_unsigned o14) ∧ (0%Z ≤ bv_unsigned o14 ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize)) ∧ bv_unsigned o14 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed o4 - bv_signed windowsize))) (Z.pow 2%Z (bv_signed windowsize)) -> (if decide (bv_signed o4 < bv_signed windowsize) then ve = valueb ep (bv_signed (0%bv : bv 32%N)) + Z.pow 2%Z (bv_signed (0%bv : bv 32%N)) * bv_unsigned o14 ∧ (0%Z ≤ bv_signed (0%bv : bv 32%N) ∧ bv_signed (0%bv : bv 32%N) ≤ bv_signed o4) ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize) else int'32_in_bounds (bv_signed o4 - bv_signed windowsize) ∧ (∀(o15 : bv 32%N), bv_signed o15 = bv_signed o4 - bv_signed windowsize -> ve = valueb ep (bv_signed o15) + Z.pow 2%Z (bv_signed o15) * bv_unsigned o14 ∧ (0%Z ≤ bv_signed o15 ∧ bv_signed o15 ≤ bv_signed o4) ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize))) ∧ (∀(ebi : bv 32%N), ve = valueb ep (bv_signed ebi) + Z.pow 2%Z (bv_signed ebi) * bv_unsigned o14 ∧ (0%Z ≤ bv_signed ebi ∧ bv_signed ebi ≤ bv_signed o4) ∧ bv_unsigned o14 < Z.pow 2%Z (bv_signed windowsize) -> 0%Z < bv_unsigned o14 ∧ (∀(o15 : bv 32%N), (0%Z ≤ bv_signed o15 ∧ bv_signed o15 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o14) (Z.pow 2%Z (bv_signed o15)) = 0%Z ∧ ¬ ZEuclid.modulo (bv_unsigned o14) (Z.pow 2%Z (bv_signed o15 + 1%Z)) = 0%Z -> int'32_in_bounds (bv_signed ebi + bv_signed o15) ∧ (∀(o16 : bv 32%N), bv_signed o16 = bv_signed ebi + bv_signed o15 -> 0%Z ≤ bv_signed o15 ∧ (∀(o17 : bv 64%N), bv_unsigned o17 = bv_signed o15 -> ((0%Z ≤ bv_unsigned o17 ∧ bv_unsigned o17 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o14) (Z.pow 2%Z (bv_unsigned o17)) = 0%Z) ∧ (∀(o18 : bv 64%N), bv_unsigned o14 = Z.pow 2%Z (bv_unsigned o17) * bv_unsigned o18 -> (0%Z ≤ 1%Z ∧ 1%Z < 64%Z) ∧ (∀(o19 : bv 64%N), bv_unsigned o19 = ZEuclid.div (bv_unsigned o18) (Z.pow 2%Z 1%Z) -> bv_unsigned o19 ≤ 2147483647%Z ∧ (∀(ebh : bv 32%N), bv_signed ebh = bv_unsigned o19 -> int'32_in_bounds (bv_signed n * bv_signed ebh) ∧ (∀(o20 : bv 32%N), bv_signed o20 = bv_signed n * bv_signed ebh -> (min pp1 ≤ offset pp1 + bv_signed o20 ∧ offset pp1 + bv_signed o20 ≤ C.max pp1) ∧ (∀(ppn : ptr (bv 64%N)), offset ppn = offset pp1 + bv_signed o20 ∧ plength ppn = plength pp1 ∧ pelts ppn = pelts pp1 ∧ data ppn = data pp1 ∧ min ppn = min pp1 ∧ C.max ppn = C.max pp1 ∧ zone1 ppn = zone1 pp1 ∧ writable ppn = writable pp1 -> (valid ppn (bv_signed n) ∧ valid rp1 (bv_signed n) ∧ writable rp1 = true) ∧ (∀(rp2 : ptr (bv 64%N)), length (data rp2) = length (data rp1) ∧ offset rp2 = offset rp1 ∧ min rp2 = min rp1 ∧ C.max rp2 = C.max rp1 ∧ writable rp2 = writable rp1 ∧ zone1 rp2 = zone1 rp1 -> map_eq_sub_shift (pelts rp2) (pelts ppn) (offset rp2) (offset ppn) (bv_signed n) ∧ (∀(j : Z), j < offset rp2 ∨ offset rp2 + bv_signed n ≤ j -> pelts rp2 j = pelts rp1 j) -> (let o21 : Z := bv_unsigned o18 in ((0%Z ≤ bv_signed o16 ∧ bv_signed o16 ≤ bv_signed o16) ∧ 0%Z ≤ o21 ∧ ZEuclid.div (bv_signed o16 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp2 (bv_signed n)) (Z.pow vb o21) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o16) + Z.pow 2%Z (bv_signed o16) * o21) ∧ (∀(expdone : Z) (ebi1 : bv 32%N) (tp3 : ptr (bv 64%N)) (rp3 : ptr (bv 64%N)), offset tp3 = offset tp2 ∧ writable tp3 = writable tp2 ∧ zone1 tp3 = zone1 tp2 -> length (data rp3) = length (data rp2) ∧ offset rp3 = offset rp2 ∧ min rp3 = min rp2 ∧ C.max rp3 = C.max rp2 ∧ writable rp3 = writable rp2 ∧ zone1 rp3 = zone1 rp2 -> (0%Z ≤ bv_signed ebi1 ∧ bv_signed ebi1 ≤ bv_signed o16) ∧ 0%Z ≤ expdone ∧ ZEuclid.div (bv_signed ebi1 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp3 (bv_signed n)) (Z.pow vb expdone) (bv_signed n) vm ∧ ve = valueb ep (bv_signed ebi1) + Z.pow 2%Z (bv_signed ebi1) * expdone ∧ plength tp3 = plength tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2 -> (∀(o22 : bool), (bv_signed ebi1 = bv_signed (0%bv : bv 32%N) -> o22 = true) ∧ (o22 = true -> ebi1 = (0%bv : bv 32%N)) -> (if decide (¬ o22 = true) then ((1%Z ≤ bv_signed ebi1 ∧ bv_signed ebi1 ≤ bv_signed ebi1) ∧ 0%Z ≤ expdone ∧ ZEuclid.div (bv_signed ebi1 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp3 (bv_signed n)) (Z.pow vb expdone) (bv_signed n) vm ∧ ve = valueb ep (bv_signed ebi1) + Z.pow 2%Z (bv_signed ebi1) * expdone ∧ plength tp3 = plength tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2) ∧ (∀(expdone1 : Z) (ebi2 : bv 32%N) (tp4 : ptr (bv 64%N)) (rp4 : ptr (bv 64%N)), offset tp4 = offset tp3 ∧ writable tp4 = writable tp3 ∧ zone1 tp4 = zone1 tp3 -> length (data rp4) = length (data rp3) ∧ offset rp4 = offset rp3 ∧ min rp4 = min rp3 ∧ C.max rp4 = C.max rp3 ∧ writable rp4 = writable rp3 ∧ zone1 rp4 = zone1 rp3 -> (1%Z ≤ bv_signed ebi2 ∧ bv_signed ebi2 ≤ bv_signed ebi1) ∧ 0%Z ≤ expdone1 ∧ ZEuclid.div (bv_signed ebi2 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp4 (bv_signed n)) (Z.pow vb expdone1) (bv_signed n) vm ∧ ve = valueb ep (bv_signed ebi2) + Z.pow 2%Z (bv_signed ebi2) * expdone1 ∧ plength tp4 = plength tp2 ∧ min tp4 = min tp2 ∧ C.max tp4 = C.max tp2 -> (valid ep (bv_signed en) ∧ 1%Z ≤ bv_signed ebi2 ∧ ZEuclid.div (bv_signed ebi2 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o23 : bv 64%N), (0%Z ≤ bv_unsigned o23 ∧ bv_unsigned o23 ≤ 1%Z) ∧ bv_unsigned o23 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed ebi2 - 1%Z))) 2%Z ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed ebi2 - 1%Z) + Z.pow 2%Z (bv_signed ebi2 - 1%Z) * bv_unsigned o23 -> (∀(o24 : bool), (bv_unsigned o23 = bv_unsigned (0%bv : bv 64%N) -> o24 = true) ∧ (o24 = true -> o23 = (0%bv : bv 64%N)) -> (if decide (o24 = true) then (0%Z < bv_signed n ∧ valid rp4 (bv_signed n) ∧ valid rp4 (bv_signed n) ∧ valid tp4 (bv_signed n + bv_signed n) ∧ writable tp4 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp5 : ptr (bv 64%N)), offset tp5 = offset tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> value tp5 (bv_signed n + bv_signed n) = value rp4 (bv_signed n) * value rp4 (bv_signed n) ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ plength tp5 = plength tp4 ∧ (∀(j : Z), min tp5 ≤ j ∧ j < offset tp5 ∨ offset tp5 + bv_signed n + bv_signed n ≤ j ∧ j < C.max tp5 -> pelts tp5 j = pelts tp4 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp5 (2%Z * bv_signed n) ∧ valid rp4 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp5 = true ∧ writable rp4 = true) ∧ (∀(tp6 : ptr (bv 64%N)) (rp5 : ptr (bv 64%N)), length (data tp6) = length (data tp5) ∧ offset tp6 = offset tp5 ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> redc (value tp5 (2%Z * bv_signed n)) (value rp5 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp5 ∨ offset rp5 + bv_signed n ≤ j -> pelts rp5 j = pelts rp4 j) ∧ (value tp5 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp5 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> int'32_in_bounds (bv_signed ebi2 - 1%Z) ∧ (∀(o25 : bv 32%N), bv_signed o25 = bv_signed ebi2 - 1%Z -> (∀(o26 : bool), (bv_signed o25 = bv_signed (0%bv : bv 32%N) -> o26 = true) ∧ (o26 = true -> o25 = (0%bv : bv 32%N)) -> (if decide (o26 = true) then ∀(o27 : bool), (bv_signed o25 = bv_signed (0%bv : bv 32%N) -> o27 = true) ∧ (o27 = true -> o25 = (0%bv : bv 32%N)) -> (if decide (o27 = true) then (valid rp5 (bv_signed n) ∧ valid tp6 (bv_signed n) ∧ writable tp6 = true) ∧ (∀(tp7 : ptr (bv 64%N)), length (data tp7) = length (data tp6) ∧ offset tp7 = offset tp6 ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> map_eq_sub_shift (pelts tp7) (pelts rp5) (offset tp7) (offset rp5) (bv_signed n) ∧ (∀(j : Z), j < offset tp7 ∨ offset tp7 + bv_signed n ≤ j -> pelts tp7 j = pelts tp6 j) -> (min tp7 ≤ offset tp7 + bv_signed n ∧ offset tp7 + bv_signed n ≤ C.max tp7) ∧ (∀(o28 : ptr (bv 64%N)), offset o28 = offset tp7 + bv_signed n ∧ plength o28 = plength tp7 ∧ pelts o28 = pelts tp7 ∧ data o28 = data tp7 ∧ min o28 = min tp7 ∧ C.max o28 = C.max tp7 ∧ zone1 o28 = zone1 tp7 ∧ writable o28 = writable tp7 -> (valid o28 (bv_signed n) ∧ writable o28 = true) ∧ (∀(o29 : ptr (bv 64%N)) (tp8 : ptr (bv 64%N)), data o29 = data tp8 ∧ length (data tp8) = length (data o28) ∧ offset o29 = offset o28 ∧ min o29 = min o28 ∧ C.max o29 = C.max o28 ∧ writable o29 = writable o28 ∧ zone1 o29 = zone1 o28 -> length (data tp8) = length (data tp7) ∧ offset tp8 = offset tp7 ∧ min tp8 = min tp7 ∧ C.max tp8 = C.max tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> value o29 (bv_signed n) = 0%Z ∧ (∀(j : Z), j < offset o29 ∨ offset o29 + bv_signed n ≤ j -> pelts o29 j = pelts o28 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp8 (2%Z * bv_signed n) ∧ valid rp5 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp8 = true ∧ writable rp5 = true) ∧ (∀(rp6 : ptr (bv 64%N)), length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> redc (value tp8 (2%Z * bv_signed n)) (value rp6 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp6 ∨ offset rp6 + bv_signed n ≤ j -> pelts rp6 j = pelts rp5 j) ∧ (value tp8 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp6 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> ((valid rp6 (bv_signed n) ∧ valid mp (bv_signed n)) ∧ (∀(o30 : bv 32%N), bv_signed o30 = compare_int (value rp6 (bv_signed n)) (value mp (bv_signed n)) -> (if decide (0%Z ≤ bv_signed o30) then (0%Z ≤ bv_signed n ∧ valid rp6 (bv_signed n) ∧ valid mp (bv_signed n) ∧ writable rp6 = true) ∧ (∀(rp7 : ptr (bv 64%N)), length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> (∀(x_b : bv 64%N), value rp7 (bv_signed n) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned x_b = value rp6 (bv_signed n) - value mp (bv_signed n) ∧ (0%Z ≤ bv_unsigned x_b ∧ bv_unsigned x_b ≤ 1%Z) ∧ (∀(j : Z), j < offset rp7 ∨ offset rp7 + bv_signed n ≤ j -> pelts rp7 j = pelts rp6 j) -> ZEuclid.modulo (value rp7 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp7 (bv_signed n) < vm)) else ZEuclid.modulo (value rp6 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp6 (bv_signed n) < vm))) ∧ (∀(rp7 : ptr (bv 64%N)), length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> ZEuclid.modulo (value rp7 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp7 (bv_signed n) < vm -> value rp7 (bv_signed n) = ZEuclid.modulo (Z.pow (value bp (bv_signed bn)) (value ep (bv_signed en))) (value mp (bv_signed n))))))) else ((1%Z ≤ bv_signed windowsize ∧ bv_signed windowsize < 64%Z) ∧ 0%Z ≤ bv_signed o25 ∧ 1%Z ≤ bv_signed en ∧ valid ep (bv_signed en) ∧ ZEuclid.div (bv_signed o25 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o28 : bv 64%N), (bv_signed windowsize ≤ bv_signed o25 -> valueb ep (bv_signed o25) = valueb ep (bv_signed o25 - bv_signed windowsize) + Z.pow 2%Z (bv_signed o25 - bv_signed windowsize) * bv_unsigned o28) ∧ (bv_signed o25 < bv_signed windowsize -> valueb ep (bv_signed o25) = bv_unsigned o28) ∧ (0%Z ≤ bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed windowsize)) ∧ bv_unsigned o28 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed o25 - bv_signed windowsize))) (Z.pow 2%Z (bv_signed windowsize)) -> (if decide (bv_signed o25 < bv_signed windowsize) then int'32_in_bounds (bv_signed windowsize - bv_signed o25) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed windowsize - bv_signed o25 -> int'32_in_bounds (bv_signed windowsize - bv_signed o29) ∧ (∀(o30 : bv 32%N), bv_signed o30 = bv_signed windowsize - bv_signed o29 -> (0%Z ≤ bv_signed (0%bv : bv 32%N) ∧ bv_signed (0%bv : bv 32%N) < bv_signed o25) ∧ bv_signed (0%bv : bv 32%N) + bv_signed o30 = bv_signed o25 ∧ valueb ep (bv_signed o25) = valueb ep (bv_signed (0%bv : bv 32%N)) + Z.pow 2%Z (bv_signed (0%bv : bv 32%N)) * bv_unsigned o28 ∧ (0%Z < bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed o30)) ∧ 0%Z < bv_signed o30 ∧ bv_signed o30 ≤ bv_signed windowsize)) else int'32_in_bounds (bv_signed o25 - bv_signed windowsize) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed o25 - bv_signed windowsize -> (0%Z ≤ bv_signed o29 ∧ bv_signed o29 < bv_signed o25) ∧ bv_signed o29 + bv_signed windowsize = bv_signed o25 ∧ valueb ep (bv_signed o25) = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * bv_unsigned o28 ∧ (0%Z < bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed windowsize)) ∧ 0%Z < bv_signed windowsize ∧ bv_signed windowsize ≤ bv_signed windowsize)) ∧ (∀(this_windowsize : bv 32%N) (ebi3 : bv 32%N), (0%Z ≤ bv_signed ebi3 ∧ bv_signed ebi3 < bv_signed o25) ∧ bv_signed ebi3 + bv_signed this_windowsize = bv_signed o25 ∧ valueb ep (bv_signed o25) = valueb ep (bv_signed ebi3) + Z.pow 2%Z (bv_signed ebi3) * bv_unsigned o28 ∧ (0%Z < bv_unsigned o28 ∧ bv_unsigned o28 < Z.pow 2%Z (bv_signed this_windowsize)) ∧ 0%Z < bv_signed this_windowsize ∧ bv_signed this_windowsize ≤ bv_signed windowsize -> 0%Z < bv_unsigned o28 ∧ (∀(o29 : bv 32%N), (0%Z ≤ bv_signed o29 ∧ bv_signed o29 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o28) (Z.pow 2%Z (bv_signed o29)) = 0%Z ∧ ¬ ZEuclid.modulo (bv_unsigned o28) (Z.pow 2%Z (bv_signed o29 + 1%Z)) = 0%Z -> int'32_in_bounds (bv_signed this_windowsize - bv_signed o29) ∧ (∀(o30 : bv 32%N), bv_signed o30 = bv_signed this_windowsize - bv_signed o29 -> int'32_in_bounds (bv_signed ebi3 + bv_signed o29) ∧ (∀(o31 : bv 32%N), bv_signed o31 = bv_signed ebi3 + bv_signed o29 -> 0%Z ≤ bv_signed o29 ∧ (∀(o32 : bv 64%N), bv_unsigned o32 = bv_signed o29 -> ((0%Z ≤ bv_unsigned o32 ∧ bv_unsigned o32 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o28) (Z.pow 2%Z (bv_unsigned o32)) = 0%Z) ∧ (∀(o33 : bv 64%N), bv_unsigned o28 = Z.pow 2%Z (bv_unsigned o32) * bv_unsigned o33 -> ((0%Z ≤ bv_signed o30 ∧ bv_signed o30 ≤ bv_signed o30) ∧ 0%Z ≤ 2%Z * expdone1 ∧ redc (value rp5 (bv_signed n)) (Z.pow vb (2%Z * expdone1)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (bv_unsigned o33 + Z.pow 2%Z (bv_signed o30) * (2%Z * expdone1)) ∧ plength tp6 = plength tp2 ∧ min tp6 = min tp2 ∧ C.max tp6 = C.max tp2) ∧ (∀(this_windowsize1 : bv 32%N) (expdone2 : Z) (tp7 : ptr (bv 64%N)) (rp6 : ptr (bv 64%N)), offset tp7 = offset tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> (0%Z ≤ bv_signed this_windowsize1 ∧ bv_signed this_windowsize1 ≤ bv_signed o30) ∧ 0%Z ≤ expdone2 ∧ redc (value rp6 (bv_signed n)) (Z.pow vb expdone2) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (bv_unsigned o33 + Z.pow 2%Z (bv_signed this_windowsize1) * expdone2) ∧ plength tp7 = plength tp2 ∧ min tp7 = min tp2 ∧ C.max tp7 = C.max tp2 -> (∀(o34 : bool), (bv_signed this_windowsize1 = bv_signed (0%bv : bv 32%N) -> o34 = true) ∧ (o34 = true -> this_windowsize1 = (0%bv : bv 32%N)) -> (if decide (¬ o34 = true) then (0%Z < bv_signed n ∧ valid rp6 (bv_signed n) ∧ valid rp6 (bv_signed n) ∧ valid tp7 (bv_signed n + bv_signed n) ∧ writable tp7 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp8 : ptr (bv 64%N)), offset tp8 = offset tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> value tp8 (bv_signed n + bv_signed n) = value rp6 (bv_signed n) * value rp6 (bv_signed n) ∧ min tp8 = min tp7 ∧ C.max tp8 = C.max tp7 ∧ plength tp8 = plength tp7 ∧ (∀(j : Z), min tp8 ≤ j ∧ j < offset tp8 ∨ offset tp8 + bv_signed n + bv_signed n ≤ j ∧ j < C.max tp8 -> pelts tp8 j = pelts tp7 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp8 (2%Z * bv_signed n) ∧ valid rp6 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp8 = true ∧ writable rp6 = true) ∧ (∀(tp9 : ptr (bv 64%N)) (rp7 : ptr (bv 64%N)), length (data tp9) = length (data tp8) ∧ offset tp9 = offset tp8 ∧ min tp9 = min tp8 ∧ C.max tp9 = C.max tp8 ∧ writable tp9 = writable tp8 ∧ zone1 tp9 = zone1 tp8 -> length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> redc (value tp8 (2%Z * bv_signed n)) (value rp7 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp7 ∨ offset rp7 + bv_signed n ≤ j -> pelts rp7 j = pelts rp6 j) ∧ (value tp8 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp7 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> int'32_in_bounds (bv_signed this_windowsize1 - 1%Z) ∧ (∀(o35 : bv 32%N), bv_signed o35 = bv_signed this_windowsize1 - 1%Z -> bv_signed o35 < bv_signed this_windowsize1 ∧ (0%Z ≤ bv_signed o35 ∧ bv_signed o35 ≤ bv_signed o30) ∧ 0%Z ≤ 2%Z * expdone2 ∧ redc (value rp7 (bv_signed n)) (Z.pow vb (2%Z * expdone2)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (bv_unsigned o33 + Z.pow 2%Z (bv_signed o35) * (2%Z * expdone2)) ∧ plength tp9 = plength tp2 ∧ min tp9 = min tp2 ∧ C.max tp9 = C.max tp2))) else (0%Z ≤ 1%Z ∧ 1%Z < 64%Z) ∧ (∀(o35 : bv 64%N), bv_unsigned o35 = ZEuclid.div (bv_unsigned o33) (Z.pow 2%Z 1%Z) -> bv_unsigned o35 ≤ 2147483647%Z ∧ (∀(ebh1 : bv 32%N), bv_signed ebh1 = bv_unsigned o35 -> int'32_in_bounds (bv_signed n * bv_signed ebh1) ∧ (∀(o36 : bv 32%N), bv_signed o36 = bv_signed n * bv_signed ebh1 -> (min pp1 ≤ offset pp1 + bv_signed o36 ∧ offset pp1 + bv_signed o36 ≤ C.max pp1) ∧ (∀(ppn1 : ptr (bv 64%N)), offset ppn1 = offset pp1 + bv_signed o36 ∧ plength ppn1 = plength pp1 ∧ pelts ppn1 = pelts pp1 ∧ data ppn1 = data pp1 ∧ min ppn1 = min pp1 ∧ C.max ppn1 = C.max pp1 ∧ zone1 ppn1 = zone1 pp1 ∧ writable ppn1 = writable pp1 -> (0%Z < bv_signed n ∧ valid rp6 (bv_signed n) ∧ valid ppn1 (bv_signed n) ∧ valid tp7 (bv_signed n + bv_signed n) ∧ writable tp7 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp8 : ptr (bv 64%N)), offset tp8 = offset tp7 ∧ writable tp8 = writable tp7 ∧ zone1 tp8 = zone1 tp7 -> value tp8 (bv_signed n + bv_signed n) = value rp6 (bv_signed n) * value ppn1 (bv_signed n) ∧ min tp8 = min tp7 ∧ C.max tp8 = C.max tp7 ∧ plength tp8 = plength tp7 ∧ (∀(j : Z), min tp8 ≤ j ∧ j < offset tp8 ∨ offset tp8 + bv_signed n + bv_signed n ≤ j ∧ j < C.max tp8 -> pelts tp8 j = pelts tp7 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp8 (2%Z * bv_signed n) ∧ valid rp6 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp8 = true ∧ writable rp6 = true) ∧ (∀(tp9 : ptr (bv 64%N)) (rp7 : ptr (bv 64%N)), length (data tp9) = length (data tp8) ∧ offset tp9 = offset tp8 ∧ min tp9 = min tp8 ∧ C.max tp9 = C.max tp8 ∧ writable tp9 = writable tp8 ∧ zone1 tp9 = zone1 tp8 -> length (data rp7) = length (data rp6) ∧ offset rp7 = offset rp6 ∧ min rp7 = min rp6 ∧ C.max rp7 = C.max rp6 ∧ writable rp7 = writable rp6 ∧ zone1 rp7 = zone1 rp6 -> redc (value tp8 (2%Z * bv_signed n)) (value rp7 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp7 ∨ offset rp7 + bv_signed n ≤ j -> pelts rp7 j = pelts rp6 j) ∧ (value tp8 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp7 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> bv_signed o31 < bv_signed ebi1 ∧ (0%Z ≤ bv_signed o31 ∧ bv_signed o31 ≤ bv_signed o16) ∧ 0%Z ≤ expdone2 + bv_unsigned o33 ∧ ZEuclid.div (bv_signed o31 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp7 (bv_signed n)) (Z.pow vb (expdone2 + bv_unsigned o33)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o31) + Z.pow 2%Z (bv_signed o31) * (expdone2 + bv_unsigned o33) ∧ plength tp9 = plength tp2 ∧ min tp9 = min tp2 ∧ C.max tp9 = C.max tp2))))))))))))))))) else bv_signed o25 < bv_signed ebi2 ∧ (1%Z ≤ bv_signed o25 ∧ bv_signed o25 ≤ bv_signed ebi1) ∧ 0%Z ≤ 2%Z * expdone1 ∧ ZEuclid.div (bv_signed o25 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp5 (bv_signed n)) (Z.pow vb (2%Z * expdone1)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o25) + Z.pow 2%Z (bv_signed o25) * (2%Z * expdone1) ∧ plength tp6 = plength tp2 ∧ min tp6 = min tp2 ∧ C.max tp6 = C.max tp2))))) else ∀(o25 : bool), (bv_signed ebi2 = bv_signed (0%bv : bv 32%N) -> o25 = true) ∧ (o25 = true -> ebi2 = (0%bv : bv 32%N)) -> (if decide (o25 = true) then (valid rp4 (bv_signed n) ∧ valid tp4 (bv_signed n) ∧ writable tp4 = true) ∧ (∀(tp5 : ptr (bv 64%N)), length (data tp5) = length (data tp4) ∧ offset tp5 = offset tp4 ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> map_eq_sub_shift (pelts tp5) (pelts rp4) (offset tp5) (offset rp4) (bv_signed n) ∧ (∀(j : Z), j < offset tp5 ∨ offset tp5 + bv_signed n ≤ j -> pelts tp5 j = pelts tp4 j) -> (min tp5 ≤ offset tp5 + bv_signed n ∧ offset tp5 + bv_signed n ≤ C.max tp5) ∧ (∀(o26 : ptr (bv 64%N)), offset o26 = offset tp5 + bv_signed n ∧ plength o26 = plength tp5 ∧ pelts o26 = pelts tp5 ∧ data o26 = data tp5 ∧ min o26 = min tp5 ∧ C.max o26 = C.max tp5 ∧ zone1 o26 = zone1 tp5 ∧ writable o26 = writable tp5 -> (valid o26 (bv_signed n) ∧ writable o26 = true) ∧ (∀(o27 : ptr (bv 64%N)) (tp6 : ptr (bv 64%N)), data o27 = data tp6 ∧ length (data tp6) = length (data o26) ∧ offset o27 = offset o26 ∧ min o27 = min o26 ∧ C.max o27 = C.max o26 ∧ writable o27 = writable o26 ∧ zone1 o27 = zone1 o26 -> length (data tp6) = length (data tp5) ∧ offset tp6 = offset tp5 ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> value o27 (bv_signed n) = 0%Z ∧ (∀(j : Z), j < offset o27 ∨ offset o27 + bv_signed n ≤ j -> pelts o27 j = pelts o26 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp6 (2%Z * bv_signed n) ∧ valid rp4 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp6 = true ∧ writable rp4 = true) ∧ (∀(rp5 : ptr (bv 64%N)), length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> redc (value tp6 (2%Z * bv_signed n)) (value rp5 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp5 ∨ offset rp5 + bv_signed n ≤ j -> pelts rp5 j = pelts rp4 j) ∧ (value tp6 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp5 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> ((valid rp5 (bv_signed n) ∧ valid mp (bv_signed n)) ∧ (∀(o28 : bv 32%N), bv_signed o28 = compare_int (value rp5 (bv_signed n)) (value mp (bv_signed n)) -> (if decide (0%Z ≤ bv_signed o28) then (0%Z ≤ bv_signed n ∧ valid rp5 (bv_signed n) ∧ valid mp (bv_signed n) ∧ writable rp5 = true) ∧ (∀(rp6 : ptr (bv 64%N)), length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> (∀(x_b : bv 64%N), value rp6 (bv_signed n) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned x_b = value rp5 (bv_signed n) - value mp (bv_signed n) ∧ (0%Z ≤ bv_unsigned x_b ∧ bv_unsigned x_b ≤ 1%Z) ∧ (∀(j : Z), j < offset rp6 ∨ offset rp6 + bv_signed n ≤ j -> pelts rp6 j = pelts rp5 j) -> ZEuclid.modulo (value rp6 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp6 (bv_signed n) < vm)) else ZEuclid.modulo (value rp5 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp5 (bv_signed n) < vm))) ∧ (∀(rp6 : ptr (bv 64%N)), length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> ZEuclid.modulo (value rp6 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp6 (bv_signed n) < vm -> value rp6 (bv_signed n) = ZEuclid.modulo (Z.pow (value bp (bv_signed bn)) (value ep (bv_signed en))) (value mp (bv_signed n))))))) else ((1%Z ≤ bv_signed windowsize ∧ bv_signed windowsize < 64%Z) ∧ 0%Z ≤ bv_signed ebi2 ∧ 1%Z ≤ bv_signed en ∧ valid ep (bv_signed en) ∧ ZEuclid.div (bv_signed ebi2 + 63%Z) 64%Z ≤ bv_signed en) ∧ (∀(o26 : bv 64%N), (bv_signed windowsize ≤ bv_signed ebi2 -> valueb ep (bv_signed ebi2) = valueb ep (bv_signed ebi2 - bv_signed windowsize) + Z.pow 2%Z (bv_signed ebi2 - bv_signed windowsize) * bv_unsigned o26) ∧ (bv_signed ebi2 < bv_signed windowsize -> valueb ep (bv_signed ebi2) = bv_unsigned o26) ∧ (0%Z ≤ bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed windowsize)) ∧ bv_unsigned o26 = ZEuclid.modulo (ZEuclid.div (value ep (bv_signed en)) (Z.pow 2%Z (bv_signed ebi2 - bv_signed windowsize))) (Z.pow 2%Z (bv_signed windowsize)) -> (if decide (bv_signed ebi2 < bv_signed windowsize) then int'32_in_bounds (bv_signed windowsize - bv_signed ebi2) ∧ (∀(o27 : bv 32%N), bv_signed o27 = bv_signed windowsize - bv_signed ebi2 -> int'32_in_bounds (bv_signed windowsize - bv_signed o27) ∧ (∀(o28 : bv 32%N), bv_signed o28 = bv_signed windowsize - bv_signed o27 -> (0%Z ≤ bv_signed (0%bv : bv 32%N) ∧ bv_signed (0%bv : bv 32%N) < bv_signed ebi2) ∧ bv_signed (0%bv : bv 32%N) + bv_signed o28 = bv_signed ebi2 ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed (0%bv : bv 32%N)) + Z.pow 2%Z (bv_signed (0%bv : bv 32%N)) * bv_unsigned o26 ∧ (0%Z < bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed o28)) ∧ 0%Z < bv_signed o28 ∧ bv_signed o28 ≤ bv_signed windowsize)) else int'32_in_bounds (bv_signed ebi2 - bv_signed windowsize) ∧ (∀(o27 : bv 32%N), bv_signed o27 = bv_signed ebi2 - bv_signed windowsize -> (0%Z ≤ bv_signed o27 ∧ bv_signed o27 < bv_signed ebi2) ∧ bv_signed o27 + bv_signed windowsize = bv_signed ebi2 ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed o27) + Z.pow 2%Z (bv_signed o27) * bv_unsigned o26 ∧ (0%Z < bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed windowsize)) ∧ 0%Z < bv_signed windowsize ∧ bv_signed windowsize ≤ bv_signed windowsize)) ∧ (∀(this_windowsize : bv 32%N) (ebi3 : bv 32%N), (0%Z ≤ bv_signed ebi3 ∧ bv_signed ebi3 < bv_signed ebi2) ∧ bv_signed ebi3 + bv_signed this_windowsize = bv_signed ebi2 ∧ valueb ep (bv_signed ebi2) = valueb ep (bv_signed ebi3) + Z.pow 2%Z (bv_signed ebi3) * bv_unsigned o26 ∧ (0%Z < bv_unsigned o26 ∧ bv_unsigned o26 < Z.pow 2%Z (bv_signed this_windowsize)) ∧ 0%Z < bv_signed this_windowsize ∧ bv_signed this_windowsize ≤ bv_signed windowsize -> 0%Z < bv_unsigned o26 ∧ (∀(o27 : bv 32%N), (0%Z ≤ bv_signed o27 ∧ bv_signed o27 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o26) (Z.pow 2%Z (bv_signed o27)) = 0%Z ∧ ¬ ZEuclid.modulo (bv_unsigned o26) (Z.pow 2%Z (bv_signed o27 + 1%Z)) = 0%Z -> int'32_in_bounds (bv_signed this_windowsize - bv_signed o27) ∧ (∀(o28 : bv 32%N), bv_signed o28 = bv_signed this_windowsize - bv_signed o27 -> int'32_in_bounds (bv_signed ebi3 + bv_signed o27) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed ebi3 + bv_signed o27 -> 0%Z ≤ bv_signed o27 ∧ (∀(o30 : bv 64%N), bv_unsigned o30 = bv_signed o27 -> ((0%Z ≤ bv_unsigned o30 ∧ bv_unsigned o30 < 64%Z) ∧ ZEuclid.modulo (bv_unsigned o26) (Z.pow 2%Z (bv_unsigned o30)) = 0%Z) ∧ (∀(o31 : bv 64%N), bv_unsigned o26 = Z.pow 2%Z (bv_unsigned o30) * bv_unsigned o31 -> ((0%Z ≤ bv_signed o28 ∧ bv_signed o28 ≤ bv_signed o28) ∧ 0%Z ≤ expdone1 ∧ redc (value rp4 (bv_signed n)) (Z.pow vb expdone1) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (bv_unsigned o31 + Z.pow 2%Z (bv_signed o28) * expdone1) ∧ plength tp4 = plength tp2 ∧ min tp4 = min tp2 ∧ C.max tp4 = C.max tp2) ∧ (∀(this_windowsize1 : bv 32%N) (expdone2 : Z) (tp5 : ptr (bv 64%N)) (rp5 : ptr (bv 64%N)), offset tp5 = offset tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> (0%Z ≤ bv_signed this_windowsize1 ∧ bv_signed this_windowsize1 ≤ bv_signed o28) ∧ 0%Z ≤ expdone2 ∧ redc (value rp5 (bv_signed n)) (Z.pow vb expdone2) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (bv_unsigned o31 + Z.pow 2%Z (bv_signed this_windowsize1) * expdone2) ∧ plength tp5 = plength tp2 ∧ min tp5 = min tp2 ∧ C.max tp5 = C.max tp2 -> (∀(o32 : bool), (bv_signed this_windowsize1 = bv_signed (0%bv : bv 32%N) -> o32 = true) ∧ (o32 = true -> this_windowsize1 = (0%bv : bv 32%N)) -> (if decide (¬ o32 = true) then (0%Z < bv_signed n ∧ valid rp5 (bv_signed n) ∧ valid rp5 (bv_signed n) ∧ valid tp5 (bv_signed n + bv_signed n) ∧ writable tp5 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp6 : ptr (bv 64%N)), offset tp6 = offset tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> value tp6 (bv_signed n + bv_signed n) = value rp5 (bv_signed n) * value rp5 (bv_signed n) ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ plength tp6 = plength tp5 ∧ (∀(j : Z), min tp6 ≤ j ∧ j < offset tp6 ∨ offset tp6 + bv_signed n + bv_signed n ≤ j ∧ j < C.max tp6 -> pelts tp6 j = pelts tp5 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp6 (2%Z * bv_signed n) ∧ valid rp5 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp6 = true ∧ writable rp5 = true) ∧ (∀(tp7 : ptr (bv 64%N)) (rp6 : ptr (bv 64%N)), length (data tp7) = length (data tp6) ∧ offset tp7 = offset tp6 ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> redc (value tp6 (2%Z * bv_signed n)) (value rp6 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp6 ∨ offset rp6 + bv_signed n ≤ j -> pelts rp6 j = pelts rp5 j) ∧ (value tp6 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp6 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> int'32_in_bounds (bv_signed this_windowsize1 - 1%Z) ∧ (∀(o33 : bv 32%N), bv_signed o33 = bv_signed this_windowsize1 - 1%Z -> bv_signed o33 < bv_signed this_windowsize1 ∧ (0%Z ≤ bv_signed o33 ∧ bv_signed o33 ≤ bv_signed o28) ∧ 0%Z ≤ 2%Z * expdone2 ∧ redc (value rp6 (bv_signed n)) (Z.pow vb (2%Z * expdone2)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (bv_unsigned o31 + Z.pow 2%Z (bv_signed o33) * (2%Z * expdone2)) ∧ plength tp7 = plength tp2 ∧ min tp7 = min tp2 ∧ C.max tp7 = C.max tp2))) else (0%Z ≤ 1%Z ∧ 1%Z < 64%Z) ∧ (∀(o33 : bv 64%N), bv_unsigned o33 = ZEuclid.div (bv_unsigned o31) (Z.pow 2%Z 1%Z) -> bv_unsigned o33 ≤ 2147483647%Z ∧ (∀(ebh1 : bv 32%N), bv_signed ebh1 = bv_unsigned o33 -> int'32_in_bounds (bv_signed n * bv_signed ebh1) ∧ (∀(o34 : bv 32%N), bv_signed o34 = bv_signed n * bv_signed ebh1 -> (min pp1 ≤ offset pp1 + bv_signed o34 ∧ offset pp1 + bv_signed o34 ≤ C.max pp1) ∧ (∀(ppn1 : ptr (bv 64%N)), offset ppn1 = offset pp1 + bv_signed o34 ∧ plength ppn1 = plength pp1 ∧ pelts ppn1 = pelts pp1 ∧ data ppn1 = data pp1 ∧ min ppn1 = min pp1 ∧ C.max ppn1 = C.max pp1 ∧ zone1 ppn1 = zone1 pp1 ∧ writable ppn1 = writable pp1 -> (0%Z < bv_signed n ∧ valid rp5 (bv_signed n) ∧ valid ppn1 (bv_signed n) ∧ valid tp5 (bv_signed n + bv_signed n) ∧ writable tp5 = true ∧ 8%Z * bv_signed n < 2147483647%Z ∧ bv_signed n ≤ bv_signed (29%bv : bv 32%N) * Z.pow 2%Z 64%Z ∧ 0%Z ≤ 64%Z ∧ 64%Z ≤ 64%Z) ∧ (∀(tp6 : ptr (bv 64%N)), offset tp6 = offset tp5 ∧ writable tp6 = writable tp5 ∧ zone1 tp6 = zone1 tp5 -> value tp6 (bv_signed n + bv_signed n) = value rp5 (bv_signed n) * value ppn1 (bv_signed n) ∧ min tp6 = min tp5 ∧ C.max tp6 = C.max tp5 ∧ plength tp6 = plength tp5 ∧ (∀(j : Z), min tp6 ≤ j ∧ j < offset tp6 ∨ offset tp6 + bv_signed n + bv_signed n ≤ j ∧ j < C.max tp6 -> pelts tp6 j = pelts tp5 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp6 (2%Z * bv_signed n) ∧ valid rp5 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp6 = true ∧ writable rp5 = true) ∧ (∀(tp7 : ptr (bv 64%N)) (rp6 : ptr (bv 64%N)), length (data tp7) = length (data tp6) ∧ offset tp7 = offset tp6 ∧ min tp7 = min tp6 ∧ C.max tp7 = C.max tp6 ∧ writable tp7 = writable tp6 ∧ zone1 tp7 = zone1 tp6 -> length (data rp6) = length (data rp5) ∧ offset rp6 = offset rp5 ∧ min rp6 = min rp5 ∧ C.max rp6 = C.max rp5 ∧ writable rp6 = writable rp5 ∧ zone1 rp6 = zone1 rp5 -> redc (value tp6 (2%Z * bv_signed n)) (value rp6 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp6 ∨ offset rp6 + bv_signed n ≤ j -> pelts rp6 j = pelts rp5 j) ∧ (value tp6 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp6 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> bv_signed o29 < bv_signed ebi1 ∧ (0%Z ≤ bv_signed o29 ∧ bv_signed o29 ≤ bv_signed o16) ∧ 0%Z ≤ expdone2 + bv_unsigned o31 ∧ ZEuclid.div (bv_signed o29 + 63%Z) 64%Z ≤ bv_signed en ∧ redc (value rp6 (bv_signed n)) (Z.pow vb (expdone2 + bv_unsigned o31)) (bv_signed n) vm ∧ ve = valueb ep (bv_signed o29) + Z.pow 2%Z (bv_signed o29) * (expdone2 + bv_unsigned o31) ∧ plength tp7 = plength tp2 ∧ min tp7 = min tp2 ∧ C.max tp7 = C.max tp2))))))))))))))))))))) else (valid rp3 (bv_signed n) ∧ valid tp3 (bv_signed n) ∧ writable tp3 = true) ∧ (∀(tp4 : ptr (bv 64%N)), length (data tp4) = length (data tp3) ∧ offset tp4 = offset tp3 ∧ min tp4 = min tp3 ∧ C.max tp4 = C.max tp3 ∧ writable tp4 = writable tp3 ∧ zone1 tp4 = zone1 tp3 -> map_eq_sub_shift (pelts tp4) (pelts rp3) (offset tp4) (offset rp3) (bv_signed n) ∧ (∀(j : Z), j < offset tp4 ∨ offset tp4 + bv_signed n ≤ j -> pelts tp4 j = pelts tp3 j) -> (min tp4 ≤ offset tp4 + bv_signed n ∧ offset tp4 + bv_signed n ≤ C.max tp4) ∧ (∀(o23 : ptr (bv 64%N)), offset o23 = offset tp4 + bv_signed n ∧ plength o23 = plength tp4 ∧ pelts o23 = pelts tp4 ∧ data o23 = data tp4 ∧ min o23 = min tp4 ∧ C.max o23 = C.max tp4 ∧ zone1 o23 = zone1 tp4 ∧ writable o23 = writable tp4 -> (valid o23 (bv_signed n) ∧ writable o23 = true) ∧ (∀(o24 : ptr (bv 64%N)) (tp5 : ptr (bv 64%N)), data o24 = data tp5 ∧ length (data tp5) = length (data o23) ∧ offset o24 = offset o23 ∧ min o24 = min o23 ∧ C.max o24 = C.max o23 ∧ writable o24 = writable o23 ∧ zone1 o24 = zone1 o23 -> length (data tp5) = length (data tp4) ∧ offset tp5 = offset tp4 ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> value o24 (bv_signed n) = 0%Z ∧ (∀(j : Z), j < offset o24 ∨ offset o24 + bv_signed n ≤ j -> pelts o24 j = pelts o23 j) -> (0%Z < bv_signed n ∧ (valid mp (bv_signed n) ∧ valid tp5 (2%Z * bv_signed n) ∧ valid rp3 (bv_signed n)) ∧ Z.Odd (value mp (bv_signed n)) ∧ ZEuclid.modulo (value mp (bv_signed n) * bv_unsigned mip) (18446744073709551615%Z + 1%Z) = 18446744073709551615%Z + 1%Z - 1%Z ∧ writable tp5 = true ∧ writable rp3 = true) ∧ (∀(rp4 : ptr (bv 64%N)), length (data rp4) = length (data rp3) ∧ offset rp4 = offset rp3 ∧ min rp4 = min rp3 ∧ C.max rp4 = C.max rp3 ∧ writable rp4 = writable rp3 ∧ zone1 rp4 = zone1 rp3 -> redc (value tp5 (2%Z * bv_signed n)) (value rp4 (bv_signed n)) (bv_signed n) (value mp (bv_signed n)) ∧ (∀(j : Z), j < offset rp4 ∨ offset rp4 + bv_signed n ≤ j -> pelts rp4 j = pelts rp3 j) ∧ (value tp5 (2%Z * bv_signed n) < Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * value mp (bv_signed n) -> value rp4 (bv_signed n) < 2%Z * value mp (bv_signed n)) -> ((valid rp4 (bv_signed n) ∧ valid mp (bv_signed n)) ∧ (∀(o25 : bv 32%N), bv_signed o25 = compare_int (value rp4 (bv_signed n)) (value mp (bv_signed n)) -> (if decide (0%Z ≤ bv_signed o25) then (0%Z ≤ bv_signed n ∧ valid rp4 (bv_signed n) ∧ valid mp (bv_signed n) ∧ writable rp4 = true) ∧ (∀(rp5 : ptr (bv 64%N)), length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> (∀(x_b : bv 64%N), value rp5 (bv_signed n) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned x_b = value rp4 (bv_signed n) - value mp (bv_signed n) ∧ (0%Z ≤ bv_unsigned x_b ∧ bv_unsigned x_b ≤ 1%Z) ∧ (∀(j : Z), j < offset rp5 ∨ offset rp5 + bv_signed n ≤ j -> pelts rp5 j = pelts rp4 j) -> ZEuclid.modulo (value rp5 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp5 (bv_signed n) < vm)) else ZEuclid.modulo (value rp4 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp4 (bv_signed n) < vm))) ∧ (∀(rp5 : ptr (bv 64%N)), length (data rp5) = length (data rp4) ∧ offset rp5 = offset rp4 ∧ min rp5 = min rp4 ∧ C.max rp5 = C.max rp4 ∧ writable rp5 = writable rp4 ∧ zone1 rp5 = zone1 rp4 -> ZEuclid.modulo (value rp5 (bv_signed n)) vm = ZEuclid.modulo (Z.pow vb ve) vm ∧ value rp5 (bv_signed n) < vm -> value rp5 (bv_signed n) = ZEuclid.modulo (Z.pow (value bp (bv_signed bn)) (value ep (bv_signed en))) (value mp (bv_signed n))))))))))))))))))))))))))))))))))))))))))))).
Admitted.
