From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.map.Const.
Require Import Why3.map.MapEq.
Require Import Why3.real.Truncate.
Require Import Why3.mach.c.C.
Require Import Why3.mach.int.Unsigned.
Require Import multiprecision.types.Config.
Require Import multiprecision.types.Types.
Require Import multiprecision.types.Int32Eq.
Require Import multiprecision.types.UInt64Eq.
Require Import multiprecision.lemmas.Lemmas.
Require Import multiprecision.compare.Compare.
Require Import multiprecision.util.Util.
Require Import multiprecision.ptralias.Alias.
Require Import multiprecision.util.UtilOld.
Require Import multiprecision.add_1.Add_1.
Require Import multiprecision.add.Add.
Require Import multiprecision.add.AddOld.
Require Import multiprecision.sub_1.Sub_1.
Require Import multiprecision.sub.SubOld.
Require Import multiprecision.mul.Mul.
Require Import multiprecision.mul.Mul_basecase.
Require Import multiprecision.logical.LogicalUtil.
Require Import multiprecision.logical.Logical.
Require Import multiprecision.logical.LogicalOld.
Require Import multiprecision.div.Div.
Require Import multiprecision.sqrt.Sqrt1.
Require Import Why3.mach.fxp.Fxp.
Require Import multiprecision.toom.Toom.
Require Import multiprecision.valuation.Valuation.
Open Scope Z_scope.
Definition ceilhalf (n : Z) : Z := Z.rem (n + 1%Z) 2%Z.
Axiom ceilhalf'spec'0 : forall  (n : Z), n ≤ 2%Z * ceilhalf n.
Axiom ceilhalf'spec : forall  (n : Z), n < 2%Z * (ceilhalf n + 1%Z).
Lemma wmpn_sqrtrem'vc (sp : ptr (bv 64%N)) (n : bv 32%N) (rp : ptr (bv 64%N)) (np : ptr (bv 64%N)) (fact0 : valid sp (ceilhalf (bv_signed n))) (fact1 : valid rp (bv_signed n)) (fact2 : valid np (bv_signed n)) (fact3 : writable sp = true) (fact4 : writable rp = true) (fact5 : writable np = true) (fact6 : 1%Z ≤ bv_signed n) (fact7 : 4%Z * bv_signed n < 2147483647%Z) (fact8 : 0%Z < bv_unsigned (pelts np (offset np + bv_signed n - 1%Z))) : let o1 : Z := bv_signed n in let k : Z := ceilhalf o1 in o1 ≤ 2%Z * k ∧ o1 < 2%Z * (k + 1%Z) -> int'32_in_bounds (bv_signed n - 1%Z) ∧ (∀(o2 : bv 32%N), bv_signed o2 = bv_signed n - 1%Z -> (min np ≤ offset np + bv_signed o2 ∧ offset np + bv_signed o2 < C.max np) ∧ (let high : bv 64%N := pelts np (offset np + bv_signed o2) in 0%Z < bv_unsigned high ∧ (∀(o3 : bv 32%N), Z.pow 2%Z (bv_signed o3) * bv_unsigned high ≤ 18446744073709551615%Z ∧ 18446744073709551615%Z < 2%Z * Z.pow 2%Z (bv_signed o3) * bv_unsigned high ∧ 0%Z ≤ bv_signed o3 ∧ bv_signed o3 < 64%Z -> 0%Z ≤ bv_signed o3 ∧ (∀(o4 : bv 64%N), bv_unsigned o4 = bv_signed o3 -> (¬ 2%Z = 0%Z ∧ uint'64_in_bounds (Z.rem (bv_unsigned o4) 2%Z)) ∧ (∀(o5 : bv 64%N), bv_unsigned o5 = Z.rem (bv_unsigned o4) 2%Z -> (∀(o6 : bool), (bv_signed n = bv_signed (1%bv : bv 32%N) -> o6 = true) ∧ (o6 = true -> n = (1%bv : bv 32%N)) -> (if decide (o6 = true) then ∀(o7 : bool), (bv_unsigned o5 = bv_unsigned (0%bv : bv 64%N) -> o7 = true) ∧ (o7 = true -> o5 = (0%bv : bv 64%N)) -> (if decide (o7 = true) then (valid rp 1%Z ∧ 4611686018427387904%Z ≤ bv_unsigned high ∧ writable rp = true) ∧ (∀(rp1 : ptr (bv 64%N)), length (data rp1) = length (data rp) ∧ offset rp1 = offset rp ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> (∀(s : bv 64%N), (bv_unsigned s * bv_unsigned s ≤ bv_unsigned high ∧ bv_unsigned high < (bv_unsigned s + 1%Z) * (bv_unsigned s + 1%Z)) ∧ bv_unsigned s * bv_unsigned s + bv_unsigned (pelts rp1 (offset rp1)) = bv_unsigned high ∧ bv_unsigned (pelts rp1 (offset rp1)) ≤ 2%Z * bv_unsigned s -> ((min sp ≤ offset sp ∧ offset sp < C.max sp) ∧ writable sp = true) ∧ (∀(sp1 : ptr (bv 64%N)), length (data sp1) = length (data sp) ∧ offset sp1 = offset sp ∧ min sp1 = min sp ∧ C.max sp1 = C.max sp ∧ writable sp1 = writable sp ∧ zone1 sp1 = zone1 sp -> pelts sp1 = fun_updt (pelts sp) (offset sp1) s -> (min rp1 ≤ offset rp1 ∧ offset rp1 < C.max rp1) ∧ (let o8 : bv 64%N := pelts rp1 (offset rp1) in ∀(o9 : bool), (bv_unsigned o8 = bv_unsigned (0%bv : bv 64%N) -> o9 = true) ∧ (o9 = true -> o8 = (0%bv : bv 64%N)) -> (∀(res : bv 32%N), (if decide (o9 = true) then res = (0%bv : bv 32%N) else res = (1%bv : bv 32%N)) -> value np (bv_signed n) = value sp1 (ceilhalf (bv_signed n)) * value sp1 (ceilhalf (bv_signed n)) + value rp1 (bv_signed res) ∧ (0%Z ≤ bv_signed res ∧ bv_signed res ≤ bv_signed n) ∧ value rp1 (bv_signed res) ≤ 2%Z * value sp1 (ceilhalf (bv_signed n)) ∧ (0%Z < bv_signed res -> 0%Z < bv_unsigned (pelts rp1 (offset rp1 + bv_signed res - 1%Z))) ∧ C.max rp1 = C.max rp ∧ min rp1 = min rp ∧ plength rp1 = plength rp ∧ C.max sp1 = C.max sp ∧ min sp1 = min sp ∧ plength sp1 = plength sp))))) else uint'64_in_bounds (2%Z * bv_unsigned o5) ∧ (∀(o8 : bv 64%N), bv_unsigned o8 = 2%Z * bv_unsigned o5 -> ((0%Z ≤ bv_unsigned o8 ∧ bv_unsigned o8 < 64%Z) ∧ Z.pow 2%Z (bv_unsigned o8) * bv_unsigned high ≤ 18446744073709551615%Z) ∧ (∀(nh : bv 64%N), bv_unsigned nh = Z.pow 2%Z (bv_unsigned o8) * bv_unsigned high -> (valid rp 1%Z ∧ 4611686018427387904%Z ≤ bv_unsigned nh ∧ writable rp = true) ∧ (∀(rp1 : ptr (bv 64%N)), length (data rp1) = length (data rp) ∧ offset rp1 = offset rp ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> (∀(ncc : bv 64%N), (bv_unsigned ncc * bv_unsigned ncc ≤ bv_unsigned nh ∧ bv_unsigned nh < (bv_unsigned ncc + 1%Z) * (bv_unsigned ncc + 1%Z)) ∧ bv_unsigned ncc * bv_unsigned ncc + bv_unsigned (pelts rp1 (offset rp1)) = bv_unsigned nh ∧ bv_unsigned (pelts rp1 (offset rp1)) ≤ 2%Z * bv_unsigned ncc -> (0%Z ≤ bv_unsigned o5 ∧ bv_unsigned o5 < 64%Z) ∧ (∀(cc : bv 64%N), bv_unsigned cc = ZEuclid.div (bv_unsigned ncc) (Z.pow 2%Z (bv_unsigned o5)) -> ((min sp ≤ offset sp ∧ offset sp < C.max sp) ∧ writable sp = true) ∧ (∀(sp1 : ptr (bv 64%N)), length (data sp1) = length (data sp) ∧ offset sp1 = offset sp ∧ min sp1 = min sp ∧ C.max sp1 = C.max sp ∧ writable sp1 = writable sp ∧ zone1 sp1 = zone1 sp -> pelts sp1 = fun_updt (pelts sp) (offset sp1) cc -> uint'64_in_bounds (bv_unsigned cc * bv_unsigned cc) ∧ (∀(o9 : bv 64%N), bv_unsigned o9 = bv_unsigned cc * bv_unsigned cc -> uint'64_in_bounds (bv_unsigned high - bv_unsigned o9) ∧ (∀(o10 : bv 64%N), bv_unsigned o10 = bv_unsigned high - bv_unsigned o9 -> ((min rp1 ≤ offset rp1 ∧ offset rp1 < C.max rp1) ∧ writable rp1 = true) ∧ (∀(rp2 : ptr (bv 64%N)), length (data rp2) = length (data rp1) ∧ offset rp2 = offset rp1 ∧ min rp2 = min rp1 ∧ C.max rp2 = C.max rp1 ∧ writable rp2 = writable rp1 ∧ zone1 rp2 = zone1 rp1 -> pelts rp2 = fun_updt (pelts rp1) (offset rp2) o10 -> (min rp2 ≤ offset rp2 ∧ offset rp2 < C.max rp2) ∧ (let o11 : bv 64%N := pelts rp2 (offset rp2) in ∀(o12 : bool), (bv_unsigned o11 = bv_unsigned (0%bv : bv 64%N) -> o12 = true) ∧ (o12 = true -> o11 = (0%bv : bv 64%N)) -> (∀(res : bv 32%N), (if decide (o12 = true) then res = (0%bv : bv 32%N) else res = (1%bv : bv 32%N)) -> value np (bv_signed n) = value sp1 (ceilhalf (bv_signed n)) * value sp1 (ceilhalf (bv_signed n)) + value rp2 (bv_signed res) ∧ (0%Z ≤ bv_signed res ∧ bv_signed res ≤ bv_signed n) ∧ value rp2 (bv_signed res) ≤ 2%Z * value sp1 (ceilhalf (bv_signed n)) ∧ (0%Z < bv_signed res -> 0%Z < bv_unsigned (pelts rp2 (offset rp2 + bv_signed res - 1%Z))) ∧ C.max rp2 = C.max rp ∧ min rp2 = min rp ∧ plength rp2 = plength rp ∧ C.max sp1 = C.max sp ∧ min sp1 = min sp ∧ plength sp1 = plength sp)))))))))))) else int'32_in_bounds (bv_signed n + 1%Z) ∧ (∀(o7 : bv 32%N), bv_signed o7 = bv_signed n + 1%Z -> (¬ 2%Z = 0%Z ∧ int'32_in_bounds (Z.rem (bv_signed o7) 2%Z)) ∧ (∀(o8 : bv 32%N), bv_signed o8 = Z.rem (bv_signed o7) 2%Z -> 0%Z ≤ bv_signed n ∧ (∀(o9 : bv 64%N), bv_unsigned o9 = bv_signed n -> (¬ 2%Z = 0%Z ∧ uint'64_in_bounds (Z.quot (bv_unsigned o9) 2%Z)) ∧ (∀(o10 : bv 64%N), bv_unsigned o10 = Z.quot (bv_unsigned o9) 2%Z -> bv_unsigned o10 ≤ 2147483647%Z ∧ (∀(adj : bv 32%N), bv_signed adj = bv_unsigned o10 -> 0%Z ≤ bv_signed o8 ∧ (∀(o11 : bv 32%N), bv_unsigned o11 = bv_signed o8 -> (¬ 2%Z = 0%Z ∧ uint'32_in_bounds (Z.rem (bv_unsigned o11) 2%Z)) ∧ (∀(o12 : bv 32%N), bv_unsigned o12 = Z.rem (bv_unsigned o11) 2%Z -> uint'32_in_bounds (bv_unsigned o12 + 1%Z) ∧ (∀(o13 : bv 32%N), bv_unsigned o13 = bv_unsigned o12 + 1%Z -> 0%Z ≤ bv_unsigned o13 ∧ (∀(scratch : ptr (bv 64%N)), plength scratch = bv_unsigned o13 ∧ offset scratch = 0%Z ∧ min scratch = 0%Z ∧ C.max scratch = bv_unsigned o13 ∧ writable scratch = true -> (∀(o14 : bool), (bv_signed adj = bv_signed (0%bv : bv 32%N) -> o14 = true) ∧ (o14 = true -> adj = (0%bv : bv 32%N)) -> (∀(o15 : bool), (if decide (¬ o14 = true) then o15 = true else ∃(o16 : bool), ((bv_unsigned o5 = bv_unsigned (0%bv : bv 64%N) -> o16 = true) ∧ (o16 = true -> o5 = (0%bv : bv 64%N))) ∧ o15 = (if decide (o16 = true) then false else true)) -> (if decide (o15 = true) then 0%Z ≤ bv_signed o8 ∧ (∀(o16 : bv 32%N), bv_unsigned o16 = bv_signed o8 -> uint'32_in_bounds (2%Z * bv_unsigned o16) ∧ (∀(o17 : bv 32%N), bv_unsigned o17 = 2%Z * bv_unsigned o16 -> 0%Z ≤ bv_unsigned o17 ∧ (∀(o18 : ptr (bv 64%N)), plength o18 = bv_unsigned o17 ∧ offset o18 = 0%Z ∧ min o18 = 0%Z ∧ C.max o18 = bv_unsigned o17 ∧ writable o18 = true -> ((min o18 ≤ offset o18 ∧ offset o18 < C.max o18) ∧ writable o18 = true) ∧ (∀(tp : ptr (bv 64%N)), length (data tp) = length (data o18) ∧ offset tp = offset o18 ∧ min tp = min o18 ∧ C.max tp = C.max o18 ∧ writable tp = writable o18 ∧ zone1 tp = zone1 o18 -> length (data tp) = length (data o18) ∧ offset tp = offset o18 ∧ min tp = min o18 ∧ C.max tp = C.max o18 ∧ writable tp = writable o18 ∧ zone1 tp = zone1 o18 -> pelts tp = fun_updt (pelts o18) (offset tp) (0%bv : bv 64%N) -> ((0%Z ≤ bv_signed adj ∧ (min tp ≤ offset tp + bv_signed adj ∧ offset tp + bv_signed adj ≤ C.max tp) ∧ writable tp = true) ∧ (∀(tp1 : ptr (bv 64%N)), offset tp1 = offset tp ∧ min tp1 = min tp ∧ writable tp1 = writable tp ∧ zone1 tp1 = zone1 tp -> offset tp1 = offset tp ∧ min tp1 = min tp ∧ writable tp1 = writable tp ∧ zone1 tp1 = zone1 tp -> (∀(tpa : ptr (bv 64%N)), writable tpa = true ∧ offset tpa = offset tp1 + bv_signed adj ∧ C.max tp1 = offset tp1 + bv_signed adj ∧ min tpa = offset tp1 + bv_signed adj ∧ C.max tpa = C.max tp ∧ zone1 tpa = zone1 tp1 ∧ pelts tp1 = pelts tp ∧ plength tp1 = plength tp ∧ pelts tpa = pelts tp ∧ plength tpa = plength tp -> (∀(o19 : bool), (bv_unsigned o5 = bv_unsigned (0%bv : bv 64%N) -> o19 = true) ∧ (o19 = true -> o5 = (0%bv : bv 64%N)) -> (if decide (¬ o19 = true) then uint'64_in_bounds (2%Z * bv_unsigned o5) ∧ (∀(o20 : bv 64%N), bv_unsigned o20 = 2%Z * bv_unsigned o5 -> ((0%Z < bv_unsigned o20 ∧ bv_unsigned o20 < 64%Z) ∧ valid tpa (bv_signed n) ∧ valid np (bv_signed n) ∧ writable tpa = true ∧ 0%Z < bv_signed n) ∧ (∀(tpa1 : ptr (bv 64%N)) (np1 : ptr (bv 64%N)), offset tpa1 = offset tpa ∧ writable tpa1 = writable tpa ∧ zone1 tpa1 = zone1 tpa -> offset np1 = offset np ∧ writable np1 = writable np ∧ zone1 np1 = zone1 np -> (∀(h : bv 64%N), value tpa1 (bv_signed n) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n) * bv_unsigned h = value np (bv_signed n) * Z.pow 2%Z (bv_unsigned o20) ∧ (∀(j : Z), j < offset tpa1 ∨ offset tpa1 + bv_signed n ≤ j -> pelts tpa1 j = pelts tpa j) ∧ (∀(j : Z), pelts np1 j = pelts np j) ∧ (min tpa1 = min tpa ∧ C.max tpa1 = C.max tpa ∧ plength tpa1 = plength tpa) ∧ min np1 = min np ∧ C.max np1 = C.max np ∧ plength np1 = plength np -> (zone1 tp1 = zone1 tpa1 ∧ C.max tp1 = min tpa1 ∧ writable tp1 = true ∧ writable tpa1 = true) ∧ (∀(tp2 : ptr (bv 64%N)), length (data tp2) = length (data tp1) ∧ offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> length (data tp2) = length (data tp1) ∧ offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> C.max tp2 = C.max tpa1 ∧ plength tp2 = plength tp1 ∧ (∀(i : Z), min tp1 ≤ i ∧ i < C.max tp1 -> pelts tp2 i = pelts tp1 i) ∧ (∀(i : Z), min tpa1 ≤ i ∧ i < C.max tpa1 -> pelts tp2 i = pelts tpa1 i) -> value tp2 (bv_signed n + bv_signed adj) = Z.pow 2%Z (2%Z * bv_unsigned o5) * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed adj) * value np1 (bv_signed n) ∧ Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n + bv_signed adj) ≤ 4%Z * value tp2 (bv_signed n + bv_signed adj) ∧ C.max tp2 = C.max tp ∧ plength tp2 = plength tp ∧ (min np1 = min np ∧ C.max np1 = C.max np ∧ plength np1 = plength np) ∧ (∀(j : Z), pelts np1 j = pelts np j))))) else (valid np (bv_signed n) ∧ valid tpa (bv_signed n) ∧ writable tpa = true) ∧ (∀(tpa1 : ptr (bv 64%N)), length (data tpa1) = length (data tpa) ∧ offset tpa1 = offset tpa ∧ min tpa1 = min tpa ∧ C.max tpa1 = C.max tpa ∧ writable tpa1 = writable tpa ∧ zone1 tpa1 = zone1 tpa -> map_eq_sub_shift (pelts tpa1) (pelts np) (offset tpa1) (offset np) (bv_signed n) ∧ (∀(j : Z), j < offset tpa1 ∨ offset tpa1 + bv_signed n ≤ j -> pelts tpa1 j = pelts tpa j) -> (zone1 tp1 = zone1 tpa1 ∧ C.max tp1 = min tpa1 ∧ writable tp1 = true ∧ writable tpa1 = true) ∧ (∀(tp2 : ptr (bv 64%N)), length (data tp2) = length (data tp1) ∧ offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> length (data tp2) = length (data tp1) ∧ offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> C.max tp2 = C.max tpa1 ∧ plength tp2 = plength tp1 ∧ (∀(i : Z), min tp1 ≤ i ∧ i < C.max tp1 -> pelts tp2 i = pelts tp1 i) ∧ (∀(i : Z), min tpa1 ≤ i ∧ i < C.max tpa1 -> pelts tp2 i = pelts tpa1 i) -> value tp2 (bv_signed n + bv_signed adj) = Z.pow 2%Z (2%Z * bv_unsigned o5) * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed adj) * value np (bv_signed n) ∧ Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n + bv_signed adj) ≤ 4%Z * value tp2 (bv_signed n + bv_signed adj) ∧ C.max tp2 = C.max tp ∧ plength tp2 = plength tp))))))) ∧ (∀(tp1 : ptr (bv 64%N)) (np1 : ptr (bv 64%N)), offset tp1 = offset tp ∧ min tp1 = min tp ∧ writable tp1 = writable tp ∧ zone1 tp1 = zone1 tp -> offset np1 = offset np ∧ writable np1 = writable np ∧ zone1 np1 = zone1 np -> value tp1 (bv_signed n + bv_signed adj) = Z.pow 2%Z (2%Z * bv_unsigned o5) * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed adj) * value np1 (bv_signed n) ∧ Z.pow (18446744073709551615%Z + 1%Z) (bv_signed n + bv_signed adj) ≤ 4%Z * value tp1 (bv_signed n + bv_signed adj) ∧ C.max tp1 = C.max tp ∧ plength tp1 = plength tp ∧ (min np1 = min np ∧ C.max np1 = C.max np ∧ plength np1 = plength np) ∧ (∀(j : Z), pelts np1 j = pelts np j) -> (∀(o19 : bool), (bv_signed adj = bv_signed (0%bv : bv 32%N) -> o19 = true) ∧ (o19 = true -> adj = (0%bv : bv 32%N)) -> (∀(o20 : bv 64%N), (if decide (¬ o19 = true) then o20 = (32%bv : bv 64%N) else o20 = (0%bv : bv 64%N)) -> uint'64_in_bounds (bv_unsigned o5 + bv_unsigned o20) ∧ (∀(o21 : bv 64%N), bv_unsigned o21 = bv_unsigned o5 + bv_unsigned o20 -> (let vn : Z := value np1 (bv_signed n) in (valid tp1 (bv_signed o8 + bv_signed o8) ∧ valid sp (bv_signed o8) ∧ 1%Z ≤ bv_signed o8 ∧ valid scratch (1%Z + ZEuclid.div (bv_signed o8) 2%Z) ∧ Z.pow 2%Z (64%Z - 2%Z) ≤ bv_unsigned (pelts tp1 (offset tp1 + bv_signed o8 + bv_signed o8 - 1%Z)) ∧ (writable sp = true ∧ writable scratch = true ∧ writable tp1 = true) ∧ 4%Z * bv_signed o8 < 2147483647%Z) ∧ (∀(tp2 : ptr (bv 64%N)) (scratch1 : ptr (bv 64%N)) (sp1 : ptr (bv 64%N)), offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> offset tp2 = offset tp1 ∧ min tp2 = min tp1 ∧ writable tp2 = writable tp1 ∧ zone1 tp2 = zone1 tp1 -> offset scratch1 = offset scratch ∧ writable scratch1 = writable scratch ∧ zone1 scratch1 = zone1 scratch -> offset sp1 = offset sp ∧ writable sp1 = writable sp ∧ zone1 sp1 = zone1 sp -> (∀(o22 : bv 64%N), value sp1 (bv_signed o8) * value sp1 (bv_signed o8) + value tp2 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned o22 = value tp1 (bv_signed o8 + bv_signed o8) ∧ value tp2 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned o22 ≤ 2%Z * value sp1 (bv_signed o8) ∧ Z.pow 2%Z (64%Z - 1%Z) ≤ bv_unsigned (pelts sp1 (offset sp1 + bv_signed o8 - 1%Z)) ∧ (0%Z ≤ bv_unsigned o22 ∧ bv_unsigned o22 ≤ 1%Z) ∧ C.max tp2 = C.max tp1 ∧ min tp2 = min tp1 ∧ plength tp2 = plength tp1 ∧ C.max scratch1 = C.max scratch ∧ min scratch1 = min scratch ∧ plength scratch1 = plength scratch ∧ C.max sp1 = C.max sp ∧ min sp1 = min sp ∧ plength sp1 = plength sp -> (let vs : Z := value sp1 (bv_signed o8) in let vr : Z := value tp2 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned o22 in let vs0 : Z := ZEuclid.modulo vs (Z.pow 2%Z (bv_unsigned o21)) in 0%Z ≤ 1%Z ∧ (∀(s0 : ptr (bv 64%N)), plength s0 = 1%Z ∧ offset s0 = 0%Z ∧ min s0 = 0%Z ∧ C.max s0 = 1%Z ∧ writable s0 = true -> ((0%Z ≤ bv_unsigned o21 ∧ bv_unsigned o21 < 64%Z) ∧ Z.pow 2%Z (bv_unsigned o21) * bv_unsigned (1%bv : bv 64%N) ≤ 18446744073709551615%Z) ∧ (∀(o23 : bv 64%N), bv_unsigned o23 = Z.pow 2%Z (bv_unsigned o21) * bv_unsigned (1%bv : bv 64%N) -> (min sp1 ≤ offset sp1 ∧ offset sp1 < C.max sp1) ∧ (let o24 : bv 64%N := pelts sp1 (offset sp1) in (¬ bv_unsigned o23 = 0%Z ∧ uint'64_in_bounds (Z.quot (bv_unsigned o24) (bv_unsigned o23))) ∧ (∀(s00 : bv 64%N), bv_unsigned s00 = Z.quot (bv_unsigned o24) (bv_unsigned o23) -> ((min s0 ≤ offset s0 ∧ offset s0 < C.max s0) ∧ writable s0 = true) ∧ (∀(s01 : ptr (bv 64%N)), length (data s01) = length (data s0) ∧ offset s01 = offset s0 ∧ min s01 = min s0 ∧ C.max s01 = C.max s0 ∧ writable s01 = writable s0 ∧ zone1 s01 = zone1 s0 -> pelts s01 = fun_updt (pelts s0) (offset s01) s00 -> uint'64_in_bounds (2%Z * bv_unsigned s00) ∧ (∀(o25 : bv 64%N), bv_unsigned o25 = 2%Z * bv_unsigned s00 -> (valid sp1 (bv_signed o8) ∧ valid tp2 (bv_signed o8) ∧ writable tp2 = true) ∧ (∀(tp3 : ptr (bv 64%N)), length (data tp3) = length (data tp2) ∧ offset tp3 = offset tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2 ∧ writable tp3 = writable tp2 ∧ zone1 tp3 = zone1 tp2 -> length (data tp3) = length (data tp2) ∧ offset tp3 = offset tp2 ∧ min tp3 = min tp2 ∧ C.max tp3 = C.max tp2 ∧ writable tp3 = writable tp2 ∧ zone1 tp3 = zone1 tp2 -> (∀(rc : bv 64%N), value tp3 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned rc = value tp2 (bv_signed o8) + value sp1 (bv_signed o8) * bv_unsigned o25 ∧ (∀(j : Z), j < offset tp3 ∨ offset tp3 + bv_signed o8 ≤ j -> pelts tp3 j = pelts tp2 j) -> uint'64_in_bounds (bv_unsigned o22 + bv_unsigned rc) ∧ (∀(o26 : bv 64%N), bv_unsigned o26 = bv_unsigned o22 + bv_unsigned rc -> (valid s01 1%Z ∧ valid tp3 1%Z ∧ writable tp3 = true) ∧ (∀(tp4 : ptr (bv 64%N)), length (data tp4) = length (data tp3) ∧ offset tp4 = offset tp3 ∧ min tp4 = min tp3 ∧ C.max tp4 = C.max tp3 ∧ writable tp4 = writable tp3 ∧ zone1 tp4 = zone1 tp3 -> length (data tp4) = length (data tp3) ∧ offset tp4 = offset tp3 ∧ min tp4 = min tp3 ∧ C.max tp4 = C.max tp3 ∧ writable tp4 = writable tp3 ∧ zone1 tp4 = zone1 tp3 -> (∀(o27 : bv 64%N), value tp4 1%Z - Z.pow (18446744073709551615%Z + 1%Z) 1%Z * bv_unsigned o27 = value tp3 1%Z - value s01 1%Z * bv_unsigned s00 ∧ (∀(j : Z), j < offset tp4 ∨ offset tp4 + 1%Z ≤ j -> pelts tp4 j = pelts tp3 j) -> (if decide (1%Z < bv_signed o8) then (min tp4 ≤ offset tp4 + 1%Z ∧ offset tp4 + 1%Z ≤ C.max tp4) ∧ (∀(tp11 : ptr (bv 64%N)), offset tp11 = offset tp4 + 1%Z ∧ plength tp11 = plength tp4 ∧ pelts tp11 = pelts tp4 ∧ data tp11 = data tp4 ∧ min tp11 = min tp4 ∧ C.max tp11 = C.max tp4 ∧ zone1 tp11 = zone1 tp4 ∧ writable tp11 = writable tp4 -> int'32_in_bounds (bv_signed o8 - 1%Z) ∧ (∀(o28 : bv 32%N), bv_signed o28 = bv_signed o8 - 1%Z -> (valid tp11 (bv_signed o28) ∧ 0%Z < bv_signed o28 ∧ writable tp11 = true) ∧ (∀(tp12 : ptr (bv 64%N)) (tp5 : ptr (bv 64%N)), length (data tp12) = length (data tp11) ∧ offset tp12 = offset tp11 ∧ min tp12 = min tp11 ∧ C.max tp12 = C.max tp11 ∧ writable tp12 = writable tp11 ∧ zone1 tp12 = zone1 tp11 -> data tp5 = data tp12 ∧ length (data tp12) = length (data tp4) ∧ offset tp5 = offset tp4 ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> (∀(o29 : bv 64%N), value tp12 (bv_signed o28) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o28) * bv_unsigned o29 = value tp11 (bv_signed o28) - bv_unsigned o27 ∧ (0%Z ≤ bv_unsigned o29 ∧ bv_unsigned o29 ≤ 1%Z) ∧ (∀(j : Z), j < offset tp12 ∨ offset tp12 + bv_signed o28 ≤ j -> pelts tp12 j = pelts tp11 j) -> uint'64_in_bounds (bv_unsigned o26 - bv_unsigned o29) ∧ (∀(o30 : bv 64%N), bv_unsigned o30 = bv_unsigned o26 - bv_unsigned o29 -> value tp5 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned o30 = vr + 2%Z * vs0 * vs - vs0 * vs0))))) else uint'64_in_bounds (bv_unsigned o26 - bv_unsigned o27) ∧ (∀(o28 : bv 64%N), bv_unsigned o28 = bv_unsigned o26 - bv_unsigned o27 -> value tp4 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned o28 = vr + 2%Z * vs0 * vs - vs0 * vs0)) ∧ (∀(rl : bv 64%N) (tp5 : ptr (bv 64%N)), length (data tp5) = length (data tp4) ∧ offset tp5 = offset tp4 ∧ min tp5 = min tp4 ∧ C.max tp5 = C.max tp4 ∧ writable tp5 = writable tp4 ∧ zone1 tp5 = zone1 tp4 -> value tp5 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned rl = vr + 2%Z * vs0 * vs - vs0 * vs0 -> ((0%Z < bv_unsigned o21 ∧ bv_unsigned o21 < 64%Z) ∧ valid sp1 (bv_signed o8) ∧ valid sp1 (bv_signed o8) ∧ 0%Z < bv_signed o8 ∧ writable sp1 = true ∧ (offset sp1 ≤ offset sp1 ∨ offset sp1 + bv_signed o8 ≤ offset sp1)) ∧ (∀(sp2 : ptr (bv 64%N)), length (data sp2) = length (data sp1) ∧ offset sp2 = offset sp1 ∧ min sp2 = min sp1 ∧ C.max sp2 = C.max sp1 ∧ writable sp2 = writable sp1 ∧ zone1 sp2 = zone1 sp1 -> (∀(r : bv 64%N), bv_unsigned r + (18446744073709551615%Z + 1%Z) * value sp2 (bv_signed o8) = value sp1 (bv_signed o8) * Z.pow 2%Z (64%Z - bv_unsigned o21) ∧ (∀(j : Z), j < offset sp2 ∨ offset sp2 + bv_signed o8 ≤ j -> pelts sp2 j = pelts sp1 j) ∧ min sp2 = min sp1 ∧ C.max sp2 = C.max sp1 ∧ plength sp2 = plength sp1 -> (let vsp : Z := value sp2 (bv_signed o8) in 0%Z < vn ∧ (0%Z < vn -> ((0%Z ≤ bv_unsigned (1%bv : bv 64%N) ∧ bv_unsigned (1%bv : bv 64%N) < 64%Z) ∧ Z.pow 2%Z (bv_unsigned (1%bv : bv 64%N)) * bv_unsigned o21 ≤ 18446744073709551615%Z) ∧ (∀(o28 : bv 64%N), bv_unsigned o28 = Z.pow 2%Z (bv_unsigned (1%bv : bv 64%N)) * bv_unsigned o21 -> (if decide (bv_unsigned o28 < 64%Z) then int'32_in_bounds (bv_signed o8 + 1%Z) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed o8 + 1%Z -> Z.pow 2%Z (bv_unsigned o28) * (vn - vsp * vsp) = value tp5 (bv_signed o29) ∧ (0%Z ≤ bv_unsigned o28 ∧ bv_unsigned o28 < 64%Z) ∧ valid tp5 (bv_signed o29) ∧ 0%Z < bv_signed o29 ∧ bv_signed o29 ≤ k + 1%Z) else (min tp5 ≤ offset tp5 + 1%Z ∧ offset tp5 + 1%Z ≤ C.max tp5) ∧ (∀(tp11 : ptr (bv 64%N)), offset tp11 = offset tp5 + 1%Z ∧ plength tp11 = plength tp5 ∧ pelts tp11 = pelts tp5 ∧ data tp11 = data tp5 ∧ min tp11 = min tp5 ∧ C.max tp11 = C.max tp5 ∧ zone1 tp11 = zone1 tp5 ∧ writable tp11 = writable tp5 -> uint'64_in_bounds (bv_unsigned o28 - 64%Z) ∧ (∀(o29 : bv 64%N), bv_unsigned o29 = bv_unsigned o28 - 64%Z -> Z.pow 2%Z (bv_unsigned o29) * (vn - vsp * vsp) = value tp11 (bv_signed o8) ∧ (0%Z ≤ bv_unsigned o29 ∧ bv_unsigned o29 < 64%Z) ∧ valid tp11 (bv_signed o8) ∧ 0%Z < bv_signed o8 ∧ bv_signed o8 ≤ k + 1%Z))) ∧ (∀(c2 : bv 64%N) (tp6 : ptr (bv 64%N)) (tn : bv 32%N), Z.pow 2%Z (bv_unsigned c2) * (vn - vsp * vsp) = value tp6 (bv_signed tn) ∧ (0%Z ≤ bv_unsigned c2 ∧ bv_unsigned c2 < 64%Z) ∧ valid tp6 (bv_signed tn) ∧ 0%Z < bv_signed tn ∧ bv_signed tn ≤ k + 1%Z -> (∀(o29 : bool), (bv_unsigned c2 = bv_unsigned (0%bv : bv 64%N) -> o29 = true) ∧ (o29 = true -> c2 = (0%bv : bv 64%N)) -> (if decide (¬ o29 = true) then (valid tp6 (bv_signed tn) ∧ valid rp (bv_signed tn) ∧ (0%Z < bv_unsigned c2 ∧ bv_unsigned c2 < 64%Z) ∧ 0%Z < bv_signed tn ∧ writable rp = true) ∧ (∀(o30 : ptr (bv 64%N)) (rp1 : ptr (bv 64%N)), offset o30 = offset tp6 ∧ writable o30 = writable tp6 ∧ zone1 o30 = zone1 tp6 -> offset rp1 = offset rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> (∀(b : bv 64%N), bv_unsigned b + (18446744073709551615%Z + 1%Z) * value rp1 (bv_signed tn) = value o30 (bv_signed tn) * Z.pow 2%Z (64%Z - bv_unsigned c2) ∧ (∀(j : Z), j < offset rp1 ∨ offset rp1 + bv_signed tn ≤ j -> pelts rp1 j = pelts rp j) ∧ pelts o30 = pelts tp6 ∧ (min o30 = min tp6 ∧ C.max o30 = C.max tp6 ∧ plength o30 = plength tp6) ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ plength rp1 = plength rp -> value rp1 (bv_signed tn) = vn - vsp * vsp ∧ (0%Z < bv_signed tn ∧ bv_signed tn ≤ k + 1%Z) ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ plength rp1 = plength rp)) else (valid tp6 (bv_signed tn) ∧ valid rp (bv_signed tn) ∧ writable rp = true) ∧ (∀(rp1 : ptr (bv 64%N)), length (data rp1) = length (data rp) ∧ offset rp1 = offset rp ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> map_eq_sub_shift (pelts rp1) (pelts tp6) (offset rp1) (offset tp6) (bv_signed tn) ∧ (∀(j : Z), j < offset rp1 ∨ offset rp1 + bv_signed tn ≤ j -> pelts rp1 j = pelts rp j) -> value rp1 (bv_signed tn) = vn - vsp * vsp ∧ (0%Z < bv_signed tn ∧ bv_signed tn ≤ k + 1%Z) ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ plength rp1 = plength rp))) ∧ (∀(rn : bv 32%N) (rp1 : ptr (bv 64%N)), offset rp1 = offset rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> value rp1 (bv_signed rn) = vn - vsp * vsp ∧ (0%Z < bv_signed rn ∧ bv_signed rn ≤ k + 1%Z) ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ plength rp1 = plength rp -> (1%Z ≤ bv_signed rn ∧ bv_signed rn ≤ bv_signed rn) ∧ (∀(rn1 : bv 32%N), value rp1 (bv_signed rn1) = value rp1 (bv_signed rn) ∧ 1%Z ≤ bv_signed rn1 ∧ bv_signed rn1 ≤ bv_signed rn -> int'32_in_bounds (bv_signed rn1 - 1%Z) ∧ (∀(o29 : bv 32%N), bv_signed o29 = bv_signed rn1 - 1%Z -> (min rp1 ≤ offset rp1 + bv_signed o29 ∧ offset rp1 + bv_signed o29 < C.max rp1) ∧ (let o30 : bv 64%N := pelts rp1 (offset rp1 + bv_signed o29) in ∀(o31 : bool), (bv_unsigned o30 = bv_unsigned (0%bv : bv 64%N) -> o31 = true) ∧ (o31 = true -> o30 = (0%bv : bv 64%N)) -> (if decide (o31 = true) then int'32_in_bounds (bv_signed rn1 - 1%Z) ∧ (∀(o32 : bv 32%N), bv_signed o32 = bv_signed rn1 - 1%Z -> (∀(o33 : bool), (bv_signed o32 = bv_signed (0%bv : bv 32%N) -> o33 = true) ∧ (o33 = true -> o32 = (0%bv : bv 32%N)) -> (if decide (o33 = true) then value np1 (bv_signed n) = value sp2 (ceilhalf (bv_signed n)) * value sp2 (ceilhalf (bv_signed n)) + value rp1 (bv_signed o32) ∧ (0%Z ≤ bv_signed o32 ∧ bv_signed o32 ≤ bv_signed n) ∧ value rp1 (bv_signed o32) ≤ 2%Z * value sp2 (ceilhalf (bv_signed n)) ∧ (0%Z < bv_signed o32 -> 0%Z < bv_unsigned (pelts rp1 (offset rp1 + bv_signed o32 - 1%Z))) ∧ (∀(j : Z), pelts np1 j = pelts np j) ∧ C.max np1 = C.max np ∧ min np1 = min np ∧ plength np1 = plength np ∧ C.max rp1 = C.max rp ∧ min rp1 = min rp ∧ plength rp1 = plength rp ∧ C.max sp2 = C.max sp ∧ min sp2 = min sp ∧ plength sp2 = plength sp else bv_signed o32 < bv_signed rn1 ∧ value rp1 (bv_signed o32) = value rp1 (bv_signed rn) ∧ 1%Z ≤ bv_signed o32 ∧ bv_signed o32 ≤ bv_signed rn))) else value np1 (bv_signed n) = value sp2 (ceilhalf (bv_signed n)) * value sp2 (ceilhalf (bv_signed n)) + value rp1 (bv_signed rn1) ∧ (0%Z ≤ bv_signed rn1 ∧ bv_signed rn1 ≤ bv_signed n) ∧ value rp1 (bv_signed rn1) ≤ 2%Z * value sp2 (ceilhalf (bv_signed n)) ∧ (0%Z < bv_signed rn1 -> 0%Z < bv_unsigned (pelts rp1 (offset rp1 + bv_signed rn1 - 1%Z))) ∧ (∀(j : Z), pelts np1 j = pelts np j) ∧ C.max np1 = C.max np ∧ min np1 = min np ∧ plength np1 = plength np ∧ C.max rp1 = C.max rp ∧ min rp1 = min rp ∧ plength rp1 = plength rp ∧ C.max sp2 = C.max sp ∧ min sp2 = min sp ∧ plength sp2 = plength sp))))))))))))))))))))))))))))))))))) else (valid np (bv_signed n) ∧ valid rp (bv_signed n) ∧ writable rp = true) ∧ (∀(rp1 : ptr (bv 64%N)), length (data rp1) = length (data rp) ∧ offset rp1 = offset rp ∧ min rp1 = min rp ∧ C.max rp1 = C.max rp ∧ writable rp1 = writable rp ∧ zone1 rp1 = zone1 rp -> map_eq_sub_shift (pelts rp1) (pelts np) (offset rp1) (offset np) (bv_signed n) ∧ (∀(j : Z), j < offset rp1 ∨ offset rp1 + bv_signed n ≤ j -> pelts rp1 j = pelts rp j) -> (valid rp1 (bv_signed o8 + bv_signed o8) ∧ valid sp (bv_signed o8) ∧ 1%Z ≤ bv_signed o8 ∧ valid scratch (1%Z + ZEuclid.div (bv_signed o8) 2%Z) ∧ Z.pow 2%Z (64%Z - 2%Z) ≤ bv_unsigned (pelts rp1 (offset rp1 + bv_signed o8 + bv_signed o8 - 1%Z)) ∧ (writable sp = true ∧ writable scratch = true ∧ writable rp1 = true) ∧ 4%Z * bv_signed o8 < 2147483647%Z) ∧ (∀(scratch1 : ptr (bv 64%N)) (rp2 : ptr (bv 64%N)) (sp1 : ptr (bv 64%N)), offset scratch1 = offset scratch ∧ writable scratch1 = writable scratch ∧ zone1 scratch1 = zone1 scratch -> offset rp2 = offset rp1 ∧ min rp2 = min rp1 ∧ writable rp2 = writable rp1 ∧ zone1 rp2 = zone1 rp1 -> offset sp1 = offset sp ∧ writable sp1 = writable sp ∧ zone1 sp1 = zone1 sp -> (∀(h : bv 64%N), value sp1 (bv_signed o8) * value sp1 (bv_signed o8) + value rp2 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned h = value rp1 (bv_signed o8 + bv_signed o8) ∧ value rp2 (bv_signed o8) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) * bv_unsigned h ≤ 2%Z * value sp1 (bv_signed o8) ∧ Z.pow 2%Z (64%Z - 1%Z) ≤ bv_unsigned (pelts sp1 (offset sp1 + bv_signed o8 - 1%Z)) ∧ (0%Z ≤ bv_unsigned h ∧ bv_unsigned h ≤ 1%Z) ∧ C.max rp2 = C.max rp1 ∧ min rp2 = min rp1 ∧ plength rp2 = plength rp1 ∧ C.max scratch1 = C.max scratch ∧ min scratch1 = min scratch ∧ plength scratch1 = plength scratch ∧ C.max sp1 = C.max sp ∧ min sp1 = min sp ∧ plength sp1 = plength sp -> ((min rp2 ≤ offset rp2 + bv_signed o8 ∧ offset rp2 + bv_signed o8 < C.max rp2) ∧ writable rp2 = true) ∧ (∀(rp3 : ptr (bv 64%N)), length (data rp3) = length (data rp2) ∧ offset rp3 = offset rp2 ∧ min rp3 = min rp2 ∧ C.max rp3 = C.max rp2 ∧ writable rp3 = writable rp2 ∧ zone1 rp3 = zone1 rp2 -> pelts rp3 = fun_updt (pelts rp2) (offset rp3 + bv_signed o8) h ∧ pelts rp3 (offset rp3 + bv_signed o8) = h -> bv_unsigned h ≤ 2147483647%Z ∧ (∀(o16 : bv 32%N), bv_signed o16 = bv_unsigned h -> int'32_in_bounds (bv_signed o8 + bv_signed o16) ∧ (∀(o17 : bv 32%N), bv_signed o17 = bv_signed o8 + bv_signed o16 -> (1%Z ≤ bv_signed o17 ∧ bv_signed o17 ≤ bv_signed o17) ∧ (∀(rn : bv 32%N), value rp3 (bv_signed rn) = value rp3 (bv_signed o17) ∧ 1%Z ≤ bv_signed rn ∧ bv_signed rn ≤ bv_signed o17 -> int'32_in_bounds (bv_signed rn - 1%Z) ∧ (∀(o18 : bv 32%N), bv_signed o18 = bv_signed rn - 1%Z -> (min rp3 ≤ offset rp3 + bv_signed o18 ∧ offset rp3 + bv_signed o18 < C.max rp3) ∧ (let o19 : bv 64%N := pelts rp3 (offset rp3 + bv_signed o18) in ∀(o20 : bool), (bv_unsigned o19 = bv_unsigned (0%bv : bv 64%N) -> o20 = true) ∧ (o20 = true -> o19 = (0%bv : bv 64%N)) -> (if decide (o20 = true) then int'32_in_bounds (bv_signed rn - 1%Z) ∧ (∀(o21 : bv 32%N), bv_signed o21 = bv_signed rn - 1%Z -> (∀(o22 : bool), (bv_signed o21 = bv_signed (0%bv : bv 32%N) -> o22 = true) ∧ (o22 = true -> o21 = (0%bv : bv 32%N)) -> (if decide (o22 = true) then value np (bv_signed n) = value sp1 (ceilhalf (bv_signed n)) * value sp1 (ceilhalf (bv_signed n)) + value rp3 (bv_signed o21) ∧ (0%Z ≤ bv_signed o21 ∧ bv_signed o21 ≤ bv_signed n) ∧ value rp3 (bv_signed o21) ≤ 2%Z * value sp1 (ceilhalf (bv_signed n)) ∧ (0%Z < bv_signed o21 -> 0%Z < bv_unsigned (pelts rp3 (offset rp3 + bv_signed o21 - 1%Z))) ∧ C.max rp3 = C.max rp ∧ min rp3 = min rp ∧ plength rp3 = plength rp ∧ C.max sp1 = C.max sp ∧ min sp1 = min sp ∧ plength sp1 = plength sp else bv_signed o21 < bv_signed rn ∧ value rp3 (bv_signed o21) = value rp3 (bv_signed o17) ∧ 1%Z ≤ bv_signed o21 ∧ bv_signed o21 ≤ bv_signed o17))) else value np (bv_signed n) = value sp1 (ceilhalf (bv_signed n)) * value sp1 (ceilhalf (bv_signed n)) + value rp3 (bv_signed rn) ∧ (0%Z ≤ bv_signed rn ∧ bv_signed rn ≤ bv_signed n) ∧ value rp3 (bv_signed rn) ≤ 2%Z * value sp1 (ceilhalf (bv_signed n)) ∧ (0%Z < bv_signed rn -> 0%Z < bv_unsigned (pelts rp3 (offset rp3 + bv_signed rn - 1%Z))) ∧ C.max rp3 = C.max rp ∧ min rp3 = min rp ∧ plength rp3 = plength rp ∧ C.max sp1 = C.max sp ∧ min sp1 = min sp ∧ plength sp1 = plength sp))))))))))))))))))))))))))))).
Admitted.
