theory exp_log_ExpLogDouble_example4qtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.real_Sum" "Why3STD.ieee_float_RoundingMode" "Why3STD.ufloat_UDouble" "Why3STD.ufloat_HelperLemmas" "Why3STD.ufloat_UDoubleLemmas"
begin
consts log_error :: "real"
axiomatization where log_error_bounds'0:   "(0 :: Real.real) \<le> log_error"
axiomatization where log_error_bounds'1:   "log_error \<le> (1 :: Real.real)"
consts log_cst_error :: "real"
axiomatization where log_cst_error_bounds'0:   "(0 :: Real.real) \<le> log_cst_error"
axiomatization where log_cst_error_bounds'1:   "log_cst_error \<le> (1 :: Real.real)"
consts log_approx :: "udouble \<Rightarrow> udouble"
axiomatization where log_approx'spec:   "abs (to_real (log_approx x) - ln (to_real x)) \<le> abs (ln (to_real x)) * log_error + log_cst_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "udouble"
consts exp_error :: "real"
axiomatization where exp_error_bounds'0:   "(0 :: Real.real) \<le> exp_error"
axiomatization where exp_error_bounds'1:   "exp_error \<le> (1 :: Real.real) / (2)"
consts exp_approx :: "udouble \<Rightarrow> udouble"
axiomatization where exp_approx'spec:   "abs (to_real (exp_approx x) - exp (to_real x)) \<le> exp_error * exp (to_real x)"
  for x :: "udouble"
consts log2_rel_error :: "real"
axiomatization where log2_rel_error_bounds'0:   "(0 :: Real.real) \<le> log2_rel_error"
axiomatization where log2_rel_error_bounds'1:   "log2_rel_error \<le> (1 :: Real.real)"
consts log2_abs_error :: "real"
axiomatization where log2_abs_error_bounds'0:   "(0 :: Real.real) \<le> log2_abs_error"
axiomatization where log2_abs_error_bounds'1:   "log2_abs_error \<le> (1 :: Real.real)"
consts log2_approx :: "udouble \<Rightarrow> udouble"
axiomatization where log2_approx'spec:   "abs (to_real (log2_approx x) - log (2) (to_real x)) \<le> abs (log (2) (to_real x)) * log2_rel_error + log2_abs_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "udouble"
consts log10_error :: "real"
axiomatization where log10_error_bounds'0:   "(0 :: Real.real) \<le> log10_error"
axiomatization where log10_error_bounds'1:   "log10_error \<le> (1 :: Real.real)"
consts log10_approx :: "udouble \<Rightarrow> udouble"
axiomatization where log10_approx'spec:   "abs (to_real (log10_approx x) - log (10) (to_real x)) \<le> abs (log (10) (to_real x)) * log10_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "udouble"
theorem example4'vc:
  fixes x :: "udouble"
  fixes y :: "udouble"
  assumes fact0: "(0 :: Real.real) < to_real x"
  assumes fact1: "(0 :: Real.real) < to_real y"
  shows "let o1 :: udouble = uadd x y in (0 :: Real.real) < to_real o1 \<and> (let result :: udouble = log10_approx o1 in abs (to_real result - log (10) (to_real o1)) \<le> abs (log (10) (to_real o1)) * log10_error \<longrightarrow> (let exact :: real = log (10) (to_real x + to_real y) in abs (to_real result - exact) \<le> abs exact * log10_error + -log (10) ((1 :: Real.real) - eps) * ((1 :: Real.real) + log10_error)))"
  sorry
end
