theory exp_log_ExpLogSingle_example4qtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.real_Sum" "Why3STD.ieee_float_RoundingMode" "Why3STD.ufloat_USingle" "Why3STD.ufloat_HelperLemmas" "Why3STD.ufloat_USingleLemmas"
begin
consts log_error :: "real"
axiomatization where log_error_bounds'0:   "(0 :: Real.real) \<le> log_error"
axiomatization where log_error_bounds'1:   "log_error \<le> (1 :: Real.real)"
consts log_cst_error :: "real"
axiomatization where log_cst_error_bounds'0:   "(0 :: Real.real) \<le> log_cst_error"
axiomatization where log_cst_error_bounds'1:   "log_cst_error \<le> (1 :: Real.real)"
consts log_approx :: "usingle \<Rightarrow> usingle"
axiomatization where log_approx'spec:   "abs (to_real (log_approx x) - ln (to_real x)) \<le> abs (ln (to_real x)) * log_error + log_cst_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "usingle"
consts log2_error :: "real"
axiomatization where log2_error_bounds'0:   "(0 :: Real.real) \<le> log2_error"
axiomatization where log2_error_bounds'1:   "log2_error \<le> (1 :: Real.real)"
consts log2_approx :: "usingle \<Rightarrow> usingle"
axiomatization where log2_approx'spec:   "abs (to_real (log2_approx x) - log (2) (to_real x)) \<le> abs (log (2) (to_real x)) * log2_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "usingle"
consts log10_error :: "real"
axiomatization where log10_error_bounds'0:   "(0 :: Real.real) \<le> log10_error"
axiomatization where log10_error_bounds'1:   "log10_error \<le> (1 :: Real.real)"
consts log10_approx :: "usingle \<Rightarrow> usingle"
axiomatization where log10_approx'spec:   "abs (to_real (log10_approx x) - log (10) (to_real x)) \<le> abs (log (10) (to_real x)) * log10_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "usingle"
consts exp_error :: "real"
axiomatization where exp_error_bounds'0:   "(0 :: Real.real) \<le> exp_error"
axiomatization where exp_error_bounds'1:   "exp_error \<le> (1 :: Real.real) / (4)"
consts exp_approx :: "usingle \<Rightarrow> usingle"
axiomatization where exp_approx'spec:   "abs (to_real (exp_approx x) - exp (to_real x)) \<le> exp_error * exp (to_real x)"
  for x :: "usingle"
theorem example4'vc:
  fixes x :: "usingle"
  fixes y :: "usingle"
  assumes fact0: "(0 :: Real.real) < to_real x"
  assumes fact1: "(0 :: Real.real) < to_real y"
  shows "let o1 :: usingle = uadd x y in (0 :: Real.real) < to_real o1 \<and> (let result :: usingle = log10_approx o1 in abs (to_real result - log (10) (to_real o1)) \<le> abs (log (10) (to_real o1)) * log10_error \<longrightarrow> (let exact :: real = log (10) (to_real x + to_real y) in abs (to_real result - exact) \<le> abs exact * log10_error + -log (10) ((1 :: Real.real) - eps) * ((1 :: Real.real) + log10_error)))"
  sorry
end
