From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.real.Sum.
Require Import Why3.ieee_float.RoundingMode.
Require Import Why3.ufloat.UDouble.
Require Import Why3.ufloat.HelperLemmas.
Require Import Why3.ufloat.UDoubleLemmas.
Open Scope Z_scope.
Axiom log_error : R.
Axiom log_error_bounds : Rle 0%R log_error ∧ Rle log_error 1%R.
Axiom log_cst_error : R.
Axiom log_cst_error_bounds : Rle 0%R log_cst_error ∧ Rle log_cst_error 1%R.
Axiom log_approx : udouble -> udouble.
Axiom log_approx'spec : forall  (x : udouble) (fact0 : Rlt 0%R (to_real x)), Rle (Rabs (Rminus (to_real (log_approx x)) (ln (to_real x)))) (Rplus (Rmult (Rabs (ln (to_real x))) log_error) log_cst_error).
Axiom exp_error : R.
Axiom exp_error_bounds : Rle 0%R exp_error ∧ Rle exp_error (Rdiv 1%R 2).
Axiom exp_approx : udouble -> udouble.
Axiom exp_approx'spec : forall  (x : udouble), Rle (Rabs (Rminus (to_real (exp_approx x)) (exp (to_real x)))) (Rmult exp_error (exp (to_real x))).
Axiom log2_rel_error : R.
Axiom log2_rel_error_bounds : Rle 0%R log2_rel_error ∧ Rle log2_rel_error 1%R.
Axiom log2_abs_error : R.
Axiom log2_abs_error_bounds : Rle 0%R log2_abs_error ∧ Rle log2_abs_error 1%R.
Axiom log2_approx : udouble -> udouble.
Axiom log2_approx'spec : forall  (x : udouble) (fact0 : Rlt 0%R (to_real x)), Rle (Rabs (Rminus (to_real (log2_approx x)) (Rlog 2 (to_real x)))) (Rplus (Rmult (Rabs (Rlog 2 (to_real x))) log2_rel_error) log2_abs_error).
Axiom log10_error : R.
Axiom log10_error_bounds : Rle 0%R log10_error ∧ Rle log10_error 1%R.
Axiom log10_approx : udouble -> udouble.
Axiom log10_approx'spec : forall  (x : udouble) (fact0 : Rlt 0%R (to_real x)), Rle (Rabs (Rminus (to_real (log10_approx x)) (Rlog 10 (to_real x)))) (Rmult (Rabs (Rlog 10 (to_real x))) log10_error).
Lemma example3'vc (x : udouble) (y : udouble) (fact0 : Rlt 0%R (to_real x)) (fact1 : Rlt 0%R (to_real y)) : let o1 : udouble := uadd x y in Rlt 0%R (to_real o1) ∧ (let result : udouble := log2_approx o1 in Rle (Rabs (Rminus (to_real result) (Rlog 2 (to_real o1)))) (Rplus (Rmult (Rabs (Rlog 2 (to_real o1))) log2_rel_error) log2_abs_error) -> (let exact : R := Rlog 2 (Rplus (to_real x) (to_real y)) in Rle (Rabs (Rminus (to_real result) exact)) (Rplus (Rplus (Rmult (Rabs exact) log2_rel_error) (Rmult (Ropp (Rlog 2 (Rminus 1%R eps))) (Rplus 1%R log2_rel_error))) log2_abs_error))).
Admitted.
