theory lse_Helpers
  imports "NTP4Verif.NTP4Verif" "Why3STD.real_Sum" "Why3STD.ieee_float_RoundingMode" "Why3STD.ufloat_USingle" "Why3STD.ufloat_HelperLemmas" "Why3STD.ufloat_USingleLemmas"
begin
consts abs_fun :: "(int \<Rightarrow> real) \<Rightarrow> int \<Rightarrow> real"
axiomatization where abs_fun'def:   "abs_fun f i = abs (f i)"
  for f :: "int \<Rightarrow> real"
  and i :: "int"
consts abs_real_fun :: "(int \<Rightarrow> usingle) \<Rightarrow> int \<Rightarrow> real"
axiomatization where abs_real_fun'def:   "abs_real_fun f i = abs_fun (real_fun f) i"
  for f :: "int \<Rightarrow> usingle"
  and i :: "int"
consts usum_rec :: "(int \<Rightarrow> usingle) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> usingle"
axiomatization where usum_rec'def:   "if b - a \<le> (0 :: int) then usum_rec f a b = uzero else if b - a = (1 :: int) then usum_rec f a b = f (b - (1 :: int)) else usum_rec f a b = uadd (usum_rec f a (b - (1 :: int))) (f (b - (1 :: int)))"
 if "(0 :: int) \<le> b - a"
  for b :: "int"
  and a :: "int"
  and f :: "int \<Rightarrow> usingle"
axiomatization where usum_rec'spec:   "abs (to_real (usum_rec f a b) - sum (real_fun f) a b) \<le> sum (abs_real_fun f) a b * (eps * real_of_int (b - a))"
 if "(0 :: int) \<le> b - a"
  for b :: "int"
  and a :: "int"
  and f :: "int \<Rightarrow> usingle"
consts log_error :: "real"
axiomatization where log_error_bounds'0:   "(0 :: Real.real) \<le> log_error"
axiomatization where log_error_bounds'1:   "log_error \<le> (1 :: Real.real)"
consts log_approx :: "usingle \<Rightarrow> usingle"
axiomatization where log_approx'spec:   "abs (to_real (log_approx x) - ln (to_real x)) \<le> abs (ln (to_real x)) * log_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "usingle"
consts log2_error :: "real"
axiomatization where log2_error_bounds'0:   "(0 :: Real.real) \<le> log2_error"
axiomatization where log2_error_bounds'1:   "log2_error \<le> (1 :: Real.real)"
consts log2_approx :: "usingle \<Rightarrow> usingle"
axiomatization where log2_approx'spec:   "abs (to_real (log2_approx x) - log (2) (to_real x)) \<le> abs (log (2) (to_real x)) * log2_error"
 if "(0 :: Real.real) < to_real x"
  for x :: "usingle"
consts exp_error :: "real"
axiomatization where exp_error_bounds'0:   "(0 :: Real.real) \<le> exp_error"
axiomatization where exp_error_bounds'1:   "exp_error \<le> (1 :: Real.real) / (8)"
consts exp_approx :: "usingle \<Rightarrow> usingle"
axiomatization where exp_approx'spec:   "abs (to_real (exp_approx x) - exp (to_real x)) \<le> exp_error * exp (to_real x)"
  for x :: "usingle"
end
