theory sin_cos_SinCosSingle_r_cos_thetaqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.real_Sum" "Why3STD.ieee_float_RoundingMode" "Why3STD.ufloat_USingle" "Why3STD.ufloat_HelperLemmas" "Why3STD.ufloat_USingleLemmas"
begin
consts sin_rel_err :: "real"
axiomatization where sin_rel_err_range:   "(0 :: Real.real) \<le> sin_rel_err"
consts sin_abs_err :: "real"
axiomatization where sin_abs_err_range:   "(0 :: Real.real) \<le> sin_abs_err"
consts sin_max :: "real"
axiomatization where sin_max_range:   "(0 :: Real.real) \<le> sin_max"
consts cos_rel_err :: "real"
axiomatization where cos_rel_err_range:   "(0 :: Real.real) \<le> cos_rel_err"
consts cos_abs_err :: "real"
axiomatization where cos_abs_err_range:   "(0 :: Real.real) \<le> cos_abs_err"
consts cos_max :: "real"
axiomatization where cos_max_range:   "(0 :: Real.real) \<le> cos_max"
theorem r_cos_theta'vc:
  fixes r :: "usingle"
  fixes r_exact :: "real"
  fixes theta :: "usingle"
  fixes theta_exact :: "real"
  fixes r_err :: "real"
  fixes theta_err :: "real"
  assumes fact0: "(3927 :: Real.real) / (1250) \<le> cos_max"
  assumes fact1: "(0 :: Real.real) \<le> to_real r"
  assumes fact2: "to_real r \<le> (1 :: Real.real)"
  assumes fact3: "(0 :: Real.real) \<le> r_exact"
  assumes fact4: "r_exact \<le> (1 :: Real.real)"
  assumes fact5: "-((3927 :: Real.real) / (1250)) \<le> to_real theta"
  assumes fact6: "to_real theta \<le> (3927 :: Real.real) / (1250)"
  assumes fact7: "-((3927 :: Real.real) / (1250)) \<le> theta_exact"
  assumes fact8: "theta_exact \<le> (3927 :: Real.real) / (1250)"
  assumes fact9: "abs (to_real r - r_exact) \<le> r_err"
  assumes fact10: "abs (to_real theta - theta_exact) \<le> theta_err"
  shows "abs (to_real theta) \<le> cos_max"
  and "\<forall>(o1 :: usingle). abs (to_real o1 - cos (to_real theta)) \<le> cos_rel_err * abs (cos (to_real theta)) + cos_abs_err \<longrightarrow> (let t1 :: real = (1 :: Real.real) + eps; t3 :: real = theta_err * ((1 :: Real.real) + cos_rel_err) + cos_abs_err in abs (to_real (umul r o1) - r_exact * cos theta_exact) \<le> (eps + cos_rel_err * t1) * abs (r_exact * cos theta_exact) + (t3 * abs r_exact + (r_err + r_err * cos_rel_err) * abs (cos theta_exact) + r_err * t3) * t1 + eta)"
  sorry
end
