File `Size.lean`:
```lean
namespace Size
mutual
noncomputable def size_heap : HeapType.raw_heap -> ℤ
  | HeapType.raw_heap.E => (0 : ℤ)
  | (HeapType.raw_heap.H t) => size_tree t
noncomputable def size_tree : HeapType.tree -> ℤ
  | (HeapType.tree.T x l) => (1 : ℤ) + size_list l
noncomputable def size_list : List HeapType.tree -> ℤ
  | ([] : List HeapType.tree) => (0 : ℤ)
  | (List.cons t l1) => size_tree t + size_list l1
end
end Size
```

