From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import prover.ISet.Types.
Require Import prover.Functions.Config.
Open Scope Z_scope.
Inductive iset_ok : list Z -> Prop :=
 | Set_empty : iset_ok ([] : list Z)
 | Set_one (x : Z) : iset_ok (cons x ([] : list Z))
 | Set_two (y : Z) (q : list Z) (x : Z) : iset_ok (cons y q) -> x < y -> iset_ok (cons x (cons y q)).
Lemma iset_ok_char'vc (x : Z) (l : list Z) : iset_ok (cons x l) = (iset_ok l ∧ (∀(y : Z), y ∈ l -> x < y)).
Admitted.
