theory OptionFuncs_Funcs_olift_compositionqtvc
  imports "NTP4Verif.NTP4Verif" "../../lib/isabelle/Functions_Config" "../../lib/isabelle/Functions_Func"
begin
consts some :: "'a \<Rightarrow> 'a option"
axiomatization where some_def:   "some x = Some x"
  for x :: "'a"
consts ocase :: "('a \<Rightarrow> 'b) \<Rightarrow> 'b \<Rightarrow> 'a option \<Rightarrow> 'b"
axiomatization where ocase_def:   "ocase f d x = (case x of (None :: 'a option) \<Rightarrow> d | Some x1 \<Rightarrow> f x1)"
  for f :: "'a \<Rightarrow> 'b"
  and d :: "'b"
  and x :: "'a option"
definition omap :: "('a \<Rightarrow> 'b) \<Rightarrow> 'a option \<Rightarrow> 'b option"
  where "omap f x = (case x of (None :: 'a option) \<Rightarrow> (None :: 'b option) | Some x1 \<Rightarrow> Some (f x1))" for f x
definition olift :: "('a \<Rightarrow> 'b) \<Rightarrow> 'a option \<Rightarrow> 'b option"
  where "olift f = ocase (compose some f) (None :: 'b option)" for f
theorem olift_composition'vc:
  fixes g :: "'b \<Rightarrow> 'c"
  fixes f :: "'a \<Rightarrow> 'b"
  shows "compose ((olift :: ('b \<Rightarrow> 'c) \<Rightarrow> 'b option \<Rightarrow> 'c option) g) ((olift :: ('a \<Rightarrow> 'b) \<Rightarrow> 'a option \<Rightarrow> 'b option) f) = (olift :: ('a \<Rightarrow> 'c) \<Rightarrow> 'a option \<Rightarrow> 'c option) (compose g f)"
  sorry
end
