From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import prover.Functions.Config.
Require Import prover.Functions.Func.
Open Scope Z_scope.
Axiom some : forall {α : Type} `{Inhabited α}, α -> option α.
Axiom some_def : forall  {α : Type} `{Inhabited α} (x : α), some x = Some x.
Axiom ocase : forall {β : Type} `{Inhabited β} {α : Type} `{Inhabited α}, (α -> β) -> β -> option α -> β.
Axiom ocase_def : forall  {β : Type} {α : Type} `{Inhabited β} `{Inhabited α} (f : α -> β) (d : β) (x : option α), ocase f d x = (match x with | None => d | Some x1 => f x1 end).
Definition omap {β : Type} {α : Type} `{Inhabited β} `{Inhabited α} (f : α -> β) (x : option α) : option β := match x with | None => (None : option β) | Some x1 => Some (f x1) end.
Definition olift {β : Type} {α : Type} `{Inhabited β} `{Inhabited α} (f : α -> β) : option α -> option β := ocase (compose some f) (None : option β).
Lemma olift_some_inversion'vc {β : Type} {α : Type} `{Inhabited β} `{Inhabited α} (x : option α) (f : α -> β) (y : β) (fact0 : match x with | None => True | Some x_x' => True end) : ((olift : (α -> β) -> option α -> option β) f x = Some y) = (match x with | None => False | Some x' => f x' = y end).
Admitted.
