theory register_allocation_OptimalNumberOfRegisters_compileqtvc
  imports "NTP4Verif.NTP4Verif" "./register_allocation_Spec" "./register_allocation_DWP"
begin
consts k :: "int"
axiomatization where k'def:   "(2 :: int) \<le> k"
fun n :: "expr \<Rightarrow> int"
  where "n (Evar x) = (1 :: int)" for x
      | "n (Eneg e1) = n e1" for e1
      | "n (Eadd e1 e2) = (let n1 :: int = n e1; n2 :: int = n e2 in if n1 = n2 then (1 :: int) + n1 else max n1 n2)" for e1 e2
fun measure :: "expr \<Rightarrow> int"
  where "measure (Evar x) = (0 :: int)" for x
      | "measure (Eneg e1) = (1 :: int) + measure e1" for e1
      | "measure (Eadd e1 e2) = (1 :: int) + (if n e2 \<le> n e1 then measure e1 + measure e2 else (1 :: int) + measure e1 + measure e2)" for e1 e2
consts identity :: "(state \<Rightarrow> bool) \<Rightarrow> state \<Rightarrow> bool"
consts exec_closure :: "instr \<Rightarrow> state \<Rightarrow> state"
axiomatization where identity_def:   "identity y = y"
  for y :: "state \<Rightarrow> bool"
axiomatization where exec_closure_def:   "exec_closure y y1 = exec y y1"
  for y :: "instr"
  and y1 :: "state"
theorem compile'vc:
  fixes r :: "int"
  fixes e :: "expr"
  assumes fact0: "(0 :: int) \<le> r"
  assumes fact1: "r < k"
  shows "let o1 :: state \<Rightarrow> state \<Rightarrow> bool = expr_post e r in (case e of Evar x \<Rightarrow> (\<forall>(o2 :: wcode). wcode_ok o2 \<and> trans1 o2 = identity \<longrightarrow> wcode_ok o2) | Eneg e1 \<Rightarrow> (\<forall>(o2 :: wcode). wcode_ok o2 \<and> trans1 o2 = identity \<longrightarrow> wcode_ok o2 \<and> (\<forall>(o3 :: wcode). wcode_ok o3 \<and> trans1 o3 = rcompose (trans1 o2) (rcompose (exec_closure (Ineg r))) \<longrightarrow> (((0 :: int) \<le> measure e \<and> measure e1 < measure e) \<and> (0 :: int) \<le> r \<and> r < k) \<and> (\<forall>(o4 :: hcode). hcode_ok o4 \<and> post1 o4 = expr_post e1 r \<longrightarrow> hcode_ok o4 \<and> (\<forall>(o5 :: wcode). wcode_ok o5 \<and> trans1 o5 = to_wp (post1 o4) \<longrightarrow> wcode_ok o5 \<and> wcode_ok o3)))) | Eadd e1 e2 \<Rightarrow> (if n e2 \<le> n e1 then if r < k - (1 :: int) then \<forall>(o2 :: wcode). wcode_ok o2 \<and> trans1 o2 = identity \<longrightarrow> wcode_ok o2 \<and> (\<forall>(o3 :: wcode). wcode_ok o3 \<and> trans1 o3 = rcompose (trans1 o2) (rcompose (exec_closure (Iadd (r + (1 :: int)) r))) \<longrightarrow> (let o4 :: int = r + (1 :: int) in (((0 :: int) \<le> measure e \<and> measure e2 < measure e) \<and> (0 :: int) \<le> o4 \<and> o4 < k) \<and> (\<forall>(o5 :: hcode). hcode_ok o5 \<and> post1 o5 = expr_post e2 o4 \<longrightarrow> hcode_ok o5 \<and> (\<forall>(o6 :: wcode). wcode_ok o6 \<and> trans1 o6 = to_wp (post1 o5) \<longrightarrow> (((0 :: int) \<le> measure e \<and> measure e1 < measure e) \<and> (0 :: int) \<le> r \<and> r < k) \<and> (\<forall>(o7 :: hcode). hcode_ok o7 \<and> post1 o7 = expr_post e1 r \<longrightarrow> hcode_ok o7 \<and> (\<forall>(o8 :: wcode). wcode_ok o8 \<and> trans1 o8 = to_wp (post1 o7) \<longrightarrow> (wcode_ok o8 \<and> wcode_ok o6) \<and> (\<forall>(o9 :: wcode). wcode_ok o9 \<and> trans1 o9 = rcompose (trans1 o6) (trans1 o8) \<longrightarrow> wcode_ok o9 \<and> wcode_ok o3))))))) else \<forall>(o2 :: wcode). wcode_ok o2 \<and> trans1 o2 = identity \<longrightarrow> wcode_ok o2 \<and> (\<forall>(o3 :: wcode). wcode_ok o3 \<and> trans1 o3 = rcompose (trans1 o2) (rcompose (exec_closure (Ipop (k - (2 :: int))))) \<longrightarrow> wcode_ok o3 \<and> (\<forall>(o4 :: wcode). wcode_ok o4 \<and> trans1 o4 = rcompose (trans1 o3) (rcompose (exec_closure (Iadd (k - (2 :: int)) (k - (1 :: int))))) \<longrightarrow> (let o5 :: int = k - (1 :: int) in (((0 :: int) \<le> measure e \<and> measure e2 < measure e) \<and> (0 :: int) \<le> o5 \<and> o5 < k) \<and> (\<forall>(o6 :: hcode). hcode_ok o6 \<and> post1 o6 = expr_post e2 o5 \<longrightarrow> hcode_ok o6 \<and> (\<forall>(o7 :: wcode). wcode_ok o7 \<and> trans1 o7 = to_wp (post1 o6) \<longrightarrow> (let o8 :: int = k - (2 :: int) in (((0 :: int) \<le> measure e \<and> measure e1 < measure e) \<and> (0 :: int) \<le> o8 \<and> o8 < k) \<and> (\<forall>(o9 :: hcode). hcode_ok o9 \<and> post1 o9 = expr_post e1 o8 \<longrightarrow> hcode_ok o9 \<and> (\<forall>(o10 :: wcode). wcode_ok o10 \<and> trans1 o10 = to_wp (post1 o9) \<longrightarrow> (wcode_ok o10 \<and> wcode_ok o7) \<and> (\<forall>(o11 :: wcode). wcode_ok o11 \<and> trans1 o11 = rcompose (trans1 o7) (trans1 o10) \<longrightarrow> (wcode_ok o11 \<and> wcode_ok o4) \<and> (\<forall>(o12 :: wcode). wcode_ok o12 \<and> trans1 o12 = rcompose (trans1 o4) (trans1 o11) \<longrightarrow> wcode_ok o12)))))))))) else let o2 :: expr = Eadd e2 e1 in (((0 :: int) \<le> measure e \<and> measure o2 < measure e) \<and> (0 :: int) \<le> r \<and> r < k) \<and> (\<forall>(o3 :: hcode). hcode_ok o3 \<and> post1 o3 = expr_post o2 r \<longrightarrow> hcode_ok o3))) \<and> (\<forall>(o2 :: wcode). (case e of Evar x \<Rightarrow> (\<exists>(o3 :: wcode). (wcode_ok o3 \<and> trans1 o3 = identity) \<and> wcode_ok o2 \<and> trans1 o2 = rcompose (trans1 o3) (rcompose (exec_closure (Iload x r)))) | Eneg e1 \<Rightarrow> (\<exists>(o3 :: wcode). (wcode_ok o3 \<and> trans1 o3 = identity) \<and> (\<exists>(o4 :: wcode). (wcode_ok o4 \<and> trans1 o4 = rcompose (trans1 o3) (rcompose (exec_closure (Ineg r)))) \<and> (\<exists>(o5 :: hcode). (hcode_ok o5 \<and> post1 o5 = expr_post e1 r) \<and> (\<exists>(o6 :: wcode). (wcode_ok o6 \<and> trans1 o6 = to_wp (post1 o5)) \<and> wcode_ok o2 \<and> trans1 o2 = rcompose (trans1 o4) (trans1 o6))))) | Eadd e1 e2 \<Rightarrow> (if n e2 \<le> n e1 then if r < k - (1 :: int) then \<exists>(o3 :: wcode). (wcode_ok o3 \<and> trans1 o3 = identity) \<and> (\<exists>(o4 :: wcode). (wcode_ok o4 \<and> trans1 o4 = rcompose (trans1 o3) (rcompose (exec_closure (Iadd (r + (1 :: int)) r)))) \<and> (\<exists>(o5 :: hcode). (hcode_ok o5 \<and> post1 o5 = expr_post e2 (r + (1 :: int))) \<and> (\<exists>(o6 :: wcode). (wcode_ok o6 \<and> trans1 o6 = to_wp (post1 o5)) \<and> (\<exists>(o7 :: hcode). (hcode_ok o7 \<and> post1 o7 = expr_post e1 r) \<and> (\<exists>(o8 :: wcode). (wcode_ok o8 \<and> trans1 o8 = to_wp (post1 o7)) \<and> (\<exists>(o9 :: wcode). (wcode_ok o9 \<and> trans1 o9 = rcompose (trans1 o6) (trans1 o8)) \<and> wcode_ok o2 \<and> trans1 o2 = rcompose (trans1 o4) (trans1 o9))))))) else \<exists>(o3 :: wcode). (wcode_ok o3 \<and> trans1 o3 = identity) \<and> (\<exists>(o4 :: wcode). (wcode_ok o4 \<and> trans1 o4 = rcompose (trans1 o3) (rcompose (exec_closure (Ipop (k - (2 :: int)))))) \<and> (\<exists>(o5 :: wcode). (wcode_ok o5 \<and> trans1 o5 = rcompose (trans1 o4) (rcompose (exec_closure (Iadd (k - (2 :: int)) (k - (1 :: int)))))) \<and> (\<exists>(o6 :: hcode). (hcode_ok o6 \<and> post1 o6 = expr_post e2 (k - (1 :: int))) \<and> (\<exists>(o7 :: wcode). (wcode_ok o7 \<and> trans1 o7 = to_wp (post1 o6)) \<and> (\<exists>(o8 :: hcode). (hcode_ok o8 \<and> post1 o8 = expr_post e1 (k - (2 :: int))) \<and> (\<exists>(o9 :: wcode). (wcode_ok o9 \<and> trans1 o9 = to_wp (post1 o8)) \<and> (\<exists>(o10 :: wcode). (wcode_ok o10 \<and> trans1 o10 = rcompose (trans1 o7) (trans1 o9)) \<and> (\<exists>(o11 :: wcode). (wcode_ok o11 \<and> trans1 o11 = rcompose (trans1 o5) (trans1 o10)) \<and> wcode_ok o2 \<and> trans1 o2 = rcompose (trans1 o11) (rcompose (exec_closure (Ipush (k - (2 :: int))))))))))))) else \<exists>(o3 :: hcode). (hcode_ok o3 \<and> post1 o3 = expr_post (Eadd e2 e1) r) \<and> wcode_ok o2 \<and> trans1 o2 = to_wp (post1 o3))) \<longrightarrow> (wcode_ok o2 \<and> (\<forall>(x :: state). trans1 o2 (o1 x) x = True)) \<and> (\<forall>(result :: hcode). hcode_ok result \<and> post1 result = o1 \<longrightarrow> hcode_ok result \<and> post1 result = expr_post e r))"
  sorry
end
