theory ringdecision_AssocAlgebraDecision_convqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  r
typedecl  a
consts rzero :: "r"
consts rone :: "r"
consts aone :: "a"
consts azero :: "a"
consts rplus :: "r \<Rightarrow> r \<Rightarrow> r"
consts rtimes :: "r \<Rightarrow> r \<Rightarrow> r"
consts ropp :: "r \<Rightarrow> r"
consts aplus :: "a \<Rightarrow> a \<Rightarrow> a"
consts atimes :: "a \<Rightarrow> a \<Rightarrow> a"
consts aopp :: "a \<Rightarrow> a"
axiomatization where Assoc:   "rplus (rplus x y) z = rplus x (rplus y z)"
  for x :: "r"
  and y :: "r"
  and z :: "r"
axiomatization where Unit_def_l:   "rplus rzero x = x"
  for x :: "r"
axiomatization where Unit_def_r:   "rplus x rzero = x"
  for x :: "r"
axiomatization where Inv_def_l:   "rplus (ropp x) x = rzero"
  for x :: "r"
axiomatization where Inv_def_r:   "rplus x (ropp x) = rzero"
  for x :: "r"
axiomatization where Comm:   "rplus x y = rplus y x"
  for x :: "r"
  and y :: "r"
axiomatization where Assoc1:   "rtimes (rtimes x y) z = rtimes x (rtimes y z)"
  for x :: "r"
  and y :: "r"
  and z :: "r"
axiomatization where Mul_distr_l:   "rtimes x (rplus y z) = rplus (rtimes x y) (rtimes x z)"
  for x :: "r"
  and y :: "r"
  and z :: "r"
axiomatization where Mul_distr_r:   "rtimes (rplus y z) x = rplus (rtimes y x) (rtimes z x)"
  for y :: "r"
  and z :: "r"
  and x :: "r"
axiomatization where Comm1:   "rtimes x y = rtimes y x"
  for x :: "r"
  and y :: "r"
axiomatization where Unitary:   "rtimes rone x = x"
  for x :: "r"
axiomatization where NonTrivialRing:   "\<not>rzero = rone"
axiomatization where Assoc2:   "aplus (aplus x y) z = aplus x (aplus y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Unit_def_l1:   "aplus azero x = x"
  for x :: "a"
axiomatization where Unit_def_r1:   "aplus x azero = x"
  for x :: "a"
axiomatization where Inv_def_l1:   "aplus (aopp x) x = azero"
  for x :: "a"
axiomatization where Inv_def_r1:   "aplus x (aopp x) = azero"
  for x :: "a"
axiomatization where Comm2:   "aplus x y = aplus y x"
  for x :: "a"
  and y :: "a"
axiomatization where Assoc3:   "atimes (atimes x y) z = atimes x (atimes y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_l1:   "atimes x (aplus y z) = aplus (atimes x y) (atimes x z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_r1:   "atimes (aplus y z) x = aplus (atimes y x) (atimes z x)"
  for y :: "a"
  and z :: "a"
  and x :: "a"
axiomatization where AUnitary'0:   "atimes aone x = atimes x aone"
  for x :: "a"
axiomatization where AUnitary'1:   "atimes x aone = x"
  for x :: "a"
axiomatization where ANonTrivial:   "\<not>azero = aone"
consts infix_dl :: "r \<Rightarrow> a \<Rightarrow> a"
axiomatization where ExtDistSumA:   "infix_dl r1 (aplus x y) = aplus (infix_dl r1 x) (infix_dl r1 y)"
  for r1 :: "r"
  and x :: "a"
  and y :: "a"
axiomatization where ExtDistSumR:   "infix_dl (rplus r1 s) x = aplus (infix_dl r1 x) (infix_dl s x)"
  for r1 :: "r"
  and s :: "r"
  and x :: "a"
axiomatization where AssocMulExt:   "infix_dl (rtimes r1 s) x = infix_dl r1 (infix_dl s x)"
  for r1 :: "r"
  and s :: "r"
  and x :: "a"
axiomatization where UnitExt:   "infix_dl rone x = x"
  for x :: "a"
axiomatization where CommMulExt'0:   "infix_dl r1 (atimes x y) = atimes (infix_dl r1 x) y"
  for r1 :: "r"
  and x :: "a"
  and y :: "a"
axiomatization where CommMulExt'1:   "atimes (infix_dl r1 x) y = atimes x (infix_dl r1 y)"
  for r1 :: "r"
  and x :: "a"
  and y :: "a"
consts eq0 :: "r \<Rightarrow> bool"
axiomatization where eq0'spec:   "eq0 r1 \<longleftrightarrow> r1 = rzero"
  for r1 :: "r"
datatype  t = Var "int" | Add "t" "t" | Mul "t" "t" | Ext "r" "t" | Sub "t" "t"
typedecl  vars
consts asub :: "a \<Rightarrow> a \<Rightarrow> a"
axiomatization where asub_def:   "asub x y = aplus x (aopp y)"
  for x :: "a"
  and y :: "a"
fun interp :: "t \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> a"
  where "interp (Var n) y = y n" for n y
      | "interp (Add x1 x2) y = aplus (interp x1 y) (interp x2 y)" for x1 x2 y
      | "interp (Mul x1 x2) y = atimes (interp x1 y) (interp x2 y)" for x1 x2 y
      | "interp (Sub x1 x2) y = asub (interp x1 y) (interp x2 y)" for x1 x2 y
      | "interp (Ext r1 x1) y = infix_dl r1 (interp x1 y)" for r1 x1 y
definition eq :: "t \<Rightarrow> t \<Rightarrow> _"
  where "eq x1 x2 \<longleftrightarrow> (\<forall>(y :: int \<Rightarrow> a). interp x1 y = interp x2 y)" for x1 x2
datatype  m = M "r" "int list"
typedecl  t'
fun mon :: "int list \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> a"
  where "mon (Nil :: int list) y = aone" for y
      | "mon (Cons x1 l) y = atimes (y x1) (mon l y)" for x1 l y
fun interp' :: "m list \<Rightarrow> (int \<Rightarrow> a) \<Rightarrow> a"
  where "interp' (Nil :: m list) y = azero" for y
      | "interp' (Cons (M r1 m1) l) y = aplus (infix_dl r1 (mon m1 y)) (interp' l y)" for r1 m1 l y
definition eq_mon :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "eq_mon m1 m2 \<longleftrightarrow> (\<forall>(y :: int \<Rightarrow> a). mon m1 y = mon m2 y)" for m1 m2
definition eq' :: "m list \<Rightarrow> m list \<Rightarrow> _"
  where "eq' x1 x2 \<longleftrightarrow> (\<forall>(y :: int \<Rightarrow> a). interp' x1 y = interp' x2 y)" for x1 x2
definition append_mon :: "m \<Rightarrow> m \<Rightarrow> m"
  where "append_mon m1 m2 = (case (m1, m2) of (M r1 l1, M r2 l2) \<Rightarrow> M (rtimes r1 r2) (l1 @ l2))" for m1 m2
axiomatization where append_mon'spec:   "interp' (Cons (append_mon m1 m2) (Nil :: m list)) y = atimes (interp' (Cons m1 (Nil :: m list)) y) (interp' (Cons m2 (Nil :: m list)) y)"
  for m1 :: "m"
  and m2 :: "m"
  and y :: "int \<Rightarrow> a"
fun mul_mon :: "m \<Rightarrow> m list \<Rightarrow> m list"
  where "mul_mon mon1 (Nil :: m list) = (Nil :: m list)" for mon1
      | "mul_mon mon1 (Cons m1 l) = Cons (append_mon mon1 m1) (mul_mon mon1 l)" for mon1 m1 l
axiomatization where mul_mon'spec:   "interp' (mul_mon mon1 x) y = atimes (interp' (Cons mon1 (Nil :: m list)) y) (interp' x y)"
  for mon1 :: "m"
  and x :: "m list"
  and y :: "int \<Rightarrow> a"
fun mul_devel :: "m list \<Rightarrow> m list \<Rightarrow> m list"
  where "mul_devel (Nil :: m list) x2 = (Nil :: m list)" for x2
      | "mul_devel (Cons (M r1 m1) l) x2 = mul_mon (M r1 m1) x2 @ mul_devel l x2" for r1 m1 l x2
axiomatization where mul_devel'spec:   "interp' (mul_devel x1 x2) y = atimes (interp' x1 y) (interp' x2 y)"
  for x1 :: "m list"
  and x2 :: "m list"
  and y :: "int \<Rightarrow> a"
fun ext :: "r \<Rightarrow> m list \<Rightarrow> m list"
  where "ext c (Nil :: m list) = (Nil :: m list)" for c
      | "ext c (Cons (M r1 m1) l) = Cons (M (rtimes c r1) m1) (ext c l)" for c r1 m1 l
axiomatization where ext'spec:   "interp' (ext c x) y = infix_dl c (interp' x y)"
  for c :: "r"
  and x :: "m list"
  and y :: "int \<Rightarrow> a"
theorem conv'vc:
  fixes x :: "t"
  shows "case x of Var v \<Rightarrow> True | Add x1 x2 \<Rightarrow> True | Mul x1 x2 \<Rightarrow> True | Ext r1 x1 \<Rightarrow> True | Sub x1 x2 \<Rightarrow> True"
  and "\<forall>(result :: m list). (case x of Var v \<Rightarrow> result = Cons (M rone (Cons v (Nil :: int list))) (Nil :: m list) | Add x1 x2 \<Rightarrow> (\<exists>(o1 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x2 y = interp' o1 y) \<and> (\<exists>(o2 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x1 y = interp' o2 y) \<and> result = o2 @ o1)) | Mul x1 x2 \<Rightarrow> (\<exists>(o1 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x2 y = interp' o1 y) \<and> (\<exists>(o2 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x1 y = interp' o2 y) \<and> result = mul_devel o2 o1 \<and> (\<forall>(y :: int \<Rightarrow> a). interp' result y = atimes (interp' o2 y) (interp' o1 y)))) | Ext r1 x1 \<Rightarrow> (\<exists>(o1 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x1 y = interp' o1 y) \<and> result = ext r1 o1 \<and> (\<forall>(y :: int \<Rightarrow> a). interp' result y = infix_dl r1 (interp' o1 y))) | Sub x1 x2 \<Rightarrow> (\<exists>(o1 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x2 y = interp' o1 y) \<and> (let o2 :: r = ropp rone; o3 :: m list = ext o2 o1 in (\<forall>(y :: int \<Rightarrow> a). interp' o3 y = infix_dl o2 (interp' o1 y)) \<and> (\<exists>(o4 :: m list). (\<forall>(y :: int \<Rightarrow> a). interp x1 y = interp' o4 y) \<and> result = o4 @ o3)))) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> a). interp x y = interp' result y)"
  sorry
end
