theory ringdecision_UnitaryCommutativeRingDecision_append_monqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  t
consts zero :: "t"
consts infix_pl :: "t \<Rightarrow> t \<Rightarrow> t"
consts prefix_mn :: "t \<Rightarrow> t"
consts infix_as :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l:   "infix_pl zero x = x"
  for x :: "t"
axiomatization where Unit_def_r:   "infix_pl x zero = x"
  for x :: "t"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = zero"
  for x :: "t"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = zero"
  for x :: "t"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "t"
  and y :: "t"
consts one :: "t"
axiomatization where Unitary:   "infix_as one x = x"
  for x :: "t"
axiomatization where NonTrivialRing:   "\<not>zero = one"
typedecl  t1
consts zero1 :: "t1"
consts infix_pl' :: "t1 \<Rightarrow> t1 \<Rightarrow> t1"
consts prefix_mn' :: "t1 \<Rightarrow> t1"
consts infix_as' :: "t1 \<Rightarrow> t1 \<Rightarrow> t1"
axiomatization where Assoc2:   "infix_pl' (infix_pl' x y) z = infix_pl' x (infix_pl' y z)"
  for x :: "t1"
  and y :: "t1"
  and z :: "t1"
axiomatization where Unit_def_l1:   "infix_pl' zero1 x = x"
  for x :: "t1"
axiomatization where Unit_def_r1:   "infix_pl' x zero1 = x"
  for x :: "t1"
axiomatization where Inv_def_l1:   "infix_pl' (prefix_mn' x) x = zero1"
  for x :: "t1"
axiomatization where Inv_def_r1:   "infix_pl' x (prefix_mn' x) = zero1"
  for x :: "t1"
axiomatization where Comm2:   "infix_pl' x y = infix_pl' y x"
  for x :: "t1"
  and y :: "t1"
axiomatization where Assoc3:   "infix_as' (infix_as' x y) z = infix_as' x (infix_as' y z)"
  for x :: "t1"
  and y :: "t1"
  and z :: "t1"
axiomatization where Mul_distr_l1:   "infix_as' x (infix_pl' y z) = infix_pl' (infix_as' x y) (infix_as' x z)"
  for x :: "t1"
  and y :: "t1"
  and z :: "t1"
axiomatization where Mul_distr_r1:   "infix_as' (infix_pl' y z) x = infix_pl' (infix_as' y x) (infix_as' z x)"
  for y :: "t1"
  and z :: "t1"
  and x :: "t1"
axiomatization where Comm3:   "infix_as' x y = infix_as' y x"
  for x :: "t1"
  and y :: "t1"
consts one1 :: "t1"
axiomatization where Unitary1:   "infix_as' one1 x = x"
  for x :: "t1"
axiomatization where NonTrivialRing1:   "\<not>zero1 = one1"
consts morph :: "t1 \<Rightarrow> t"
axiomatization where morph_zero:   "morph zero1 = zero"
axiomatization where morph_one:   "morph one1 = one"
axiomatization where morph_add:   "morph (infix_pl' z1 z2) = infix_pl (morph z1) (morph z2)"
  for z1 :: "t1"
  and z2 :: "t1"
axiomatization where morph_mul:   "morph (infix_as' z1 z2) = infix_as (morph z1) (morph z2)"
  for z1 :: "t1"
  and z2 :: "t1"
axiomatization where morph_inv:   "morph (prefix_mn' z) = prefix_mn (morph z)"
  for z :: "t1"
consts eq0 :: "t1 \<Rightarrow> bool"
axiomatization where eq0'spec:   "eq0 x \<longleftrightarrow> x = zero1"
  for x :: "t1"
datatype  t2 = Var "int" | Add "t2" "t2" | Mul "t2" "t2" | Cst "t1"
typedecl  vars
fun interp :: "t2 \<Rightarrow> (int \<Rightarrow> t) \<Rightarrow> t"
  where "interp (Var n) y = y n" for n y
      | "interp (Add x1 x2) y = infix_pl (interp x1 y) (interp x2 y)" for x1 x2 y
      | "interp (Mul x1 x2) y = infix_as (interp x1 y) (interp x2 y)" for x1 x2 y
      | "interp (Cst c) y = morph c" for c y
definition eq :: "t2 \<Rightarrow> t2 \<Rightarrow> _"
  where "eq x1 x2 \<longleftrightarrow> (\<forall>(y :: int \<Rightarrow> t). interp x1 y = interp x2 y)" for x1 x2
datatype  m = M "t1" "int list"
typedecl  t'
fun mon :: "int list \<Rightarrow> (int \<Rightarrow> t) \<Rightarrow> t"
  where "mon (Nil :: int list) y = one" for y
      | "mon (Cons x1 r) y = infix_as (y x1) (mon r y)" for x1 r y
fun interp' :: "m list \<Rightarrow> (int \<Rightarrow> t) \<Rightarrow> t"
  where "interp' (Nil :: m list) y = zero" for y
      | "interp' (Cons (M a m1) r) y = infix_pl (infix_as (morph a) (mon m1 y)) (interp' r y)" for a m1 r y
definition eq_mon :: "int list \<Rightarrow> int list \<Rightarrow> _"
  where "eq_mon m1 m2 \<longleftrightarrow> (\<forall>(y :: int \<Rightarrow> t). mon m1 y = mon m2 y)" for m1 m2
definition eq' :: "m list \<Rightarrow> m list \<Rightarrow> _"
  where "eq' x1 x2 \<longleftrightarrow> (\<forall>(y :: int \<Rightarrow> t). interp' x1 y = interp' x2 y)" for x1 x2
theorem append_mon'vc:
  fixes m2 :: "m"
  fixes m1 :: "m"
  shows "case m2 of M x x1 \<Rightarrow> (case m1 of M x2 x3 \<Rightarrow> True)"
  and "\<forall>(result :: m). (case m2 of M x x1 \<Rightarrow> (case m1 of M x2 x3 \<Rightarrow> result = M (infix_as' x2 x) (x3 @ x1))) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> t). interp' (Cons result (Nil :: m list)) y = infix_as (interp' (Cons m1 (Nil :: m list)) y) (interp' (Cons m2 (Nil :: m list)) y))"
  sorry
end
