theory strassen_InfIntMatrixDecision_Mul_distr_r
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum" "../../lib/isabelle/strassen_Sum_extended" "../../lib/isabelle/strassen_MaxFun" "../../lib/isabelle/strassen_InfIntMatrix"
begin
axiomatization where Assoc:   "x + y + z = x + (y + z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Unit_def_l:   "(0 :: int) + x = x"
  for x :: "int"
axiomatization where Unit_def_r:   "x + (0 :: int) = x"
  for x :: "int"
axiomatization where Inv_def_l:   "-x + x = (0 :: int)"
  for x :: "int"
axiomatization where Inv_def_r:   "x + -x = (0 :: int)"
  for x :: "int"
axiomatization where Comm:   "x + y = y + x"
  for x :: "int"
  and y :: "int"
axiomatization where Assoc1:   "x * y * z = x * (y * z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Mul_distr_l:   "x * (y + z) = x * y + x * z"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Mul_distr_r:   "(y + z) * x = y * x + z * x"
  for y :: "int"
  and z :: "int"
  and x :: "int"
axiomatization where Comm1:   "x * y = y * x"
  for x :: "int"
  and y :: "int"
axiomatization where Unitary:   "(1 :: int) * x = x"
  for x :: "int"
axiomatization where NonTrivialRing:   "\<not>(0 :: int) = (1 :: int)"
theorem Mul_distr_r1:
  fixes y :: "mat"
  fixes z :: "mat"
  fixes x :: "mat"
  shows "mul (add y z) x = add (mul y x) (mul z x)"
  sorry
end
