theory strassen_InfIntMatrix_add_sizeqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum"
begin
consts infix_pl :: "int \<Rightarrow> int \<Rightarrow> int"
consts prefix_mn :: "int \<Rightarrow> int"
consts infix_as :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Unit_def_l:   "infix_pl (0 :: int) x = x"
  for x :: "int"
axiomatization where Unit_def_r:   "infix_pl x (0 :: int) = x"
  for x :: "int"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = (0 :: int)"
  for x :: "int"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = (0 :: int)"
  for x :: "int"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "int"
  and y :: "int"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "int"
  and z :: "int"
  and x :: "int"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "int"
  and y :: "int"
consts one :: "int"
axiomatization where Unitary:   "infix_as one x = x"
  for x :: "int"
axiomatization where NonTrivialRing:   "\<not>(0 :: int) = one"
typedecl  mat
consts get :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts row_zeros :: "mat \<Rightarrow> int \<Rightarrow> int"
consts col_zeros :: "mat \<Rightarrow> int \<Rightarrow> int"
consts create :: "(int \<Rightarrow> int) \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> int) \<Rightarrow> mat"
axiomatization where create_rowz:   "row_zeros (create rz cz f) i = rz i"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> rz i"
  for i :: "int"
  and rz :: "int \<Rightarrow> int"
  and cz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where create_colz:   "col_zeros (create rz cz f) j = cz j"
 if "(0 :: int) \<le> j"
 and "(0 :: int) \<le> cz j"
  for j :: "int"
  and cz :: "int \<Rightarrow> int"
  and rz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where create_get_ib:   "get (create rz cz f) i j = f i j"
 if "(0 :: int) \<le> i"
 and "i < cz j"
 and "(0 :: int) \<le> j"
 and "j < rz i"
  for i :: "int"
  and cz :: "int \<Rightarrow> int"
  and j :: "int"
  and rz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where create_get_oob:   "get (create rz cz f) i j = (0 :: int)"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "cz j \<le> i \<or> rz i \<le> j"
  for i :: "int"
  and j :: "int"
  and cz :: "int \<Rightarrow> int"
  and rz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> int"
consts result :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts result1 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts result2 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where result'def:   "result m i j i1 = (if i1 = i then max (j + (1 :: int)) (row_zeros m i) else row_zeros m i1)"
  for m :: "mat"
  and i :: "int"
  and j :: "int"
  and i1 :: "int"
axiomatization where result'def1:   "result1 m i j j1 = (if j1 = j then max (i + (1 :: int)) (col_zeros m j) else col_zeros m j1)"
  for m :: "mat"
  and i :: "int"
  and j :: "int"
  and j1 :: "int"
axiomatization where result'def2:   "result2 m i j v i1 j1 = (if i1 = i \<and> j1 = j then v else get m i1 j1)"
  for m :: "mat"
  and i :: "int"
  and j :: "int"
  and v :: "int"
  and i1 :: "int"
  and j1 :: "int"
definition set :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> mat"
  where "set m i j v = (if (0 :: int) \<le> i \<and> (0 :: int) \<le> j then create (result m i j) (result1 m i j) (result2 m i j v) else m)" for m i j v
consts zero :: "int"
consts infix_pl' :: "int \<Rightarrow> int \<Rightarrow> int"
consts prefix_mn' :: "int \<Rightarrow> int"
consts infix_as' :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where Assoc2:   "infix_pl' (infix_pl' x y) z = infix_pl' x (infix_pl' y z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Unit_def_l1:   "infix_pl' zero x = x"
  for x :: "int"
axiomatization where Unit_def_r1:   "infix_pl' x zero = x"
  for x :: "int"
axiomatization where Inv_def_l1:   "infix_pl' (prefix_mn' x) x = zero"
  for x :: "int"
axiomatization where Inv_def_r1:   "infix_pl' x (prefix_mn' x) = zero"
  for x :: "int"
axiomatization where Comm2:   "infix_pl' x y = infix_pl' y x"
  for x :: "int"
  and y :: "int"
axiomatization where Assoc3:   "infix_as' (infix_as' x y) z = infix_as' x (infix_as' y z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Mul_distr_l1:   "infix_as' x (infix_pl' y z) = infix_pl' (infix_as' x y) (infix_as' x z)"
  for x :: "int"
  and y :: "int"
  and z :: "int"
axiomatization where Mul_distr_r1:   "infix_as' (infix_pl' y z) x = infix_pl' (infix_as' y x) (infix_as' z x)"
  for y :: "int"
  and z :: "int"
  and x :: "int"
axiomatization where Comm3:   "infix_as' x y = infix_as' y x"
  for x :: "int"
  and y :: "int"
consts one1 :: "int"
axiomatization where Unitary1:   "infix_as' one1 x = x"
  for x :: "int"
axiomatization where NonTrivialRing1:   "\<not>zero = one1"
axiomatization where row_zeros_def:   "get m i j = zero"
 if "(0 :: int) \<le> i"
 and "row_zeros m i \<le> j"
  for i :: "int"
  and m :: "mat"
  and j :: "int"
axiomatization where col_zeros_def:   "get m i j = zero"
 if "(0 :: int) \<le> j"
 and "col_zeros m j \<le> i"
  for j :: "int"
  and m :: "mat"
  and i :: "int"
axiomatization where row_zeros_nonneg:   "(0 :: int) \<le> row_zeros m i"
 if "(0 :: int) \<le> i"
  for i :: "int"
  and m :: "mat"
axiomatization where col_zeros_nonneg:   "(0 :: int) \<le> col_zeros m j"
 if "(0 :: int) \<le> j"
  for j :: "int"
  and m :: "mat"
axiomatization where set_def_changed:   "get (set m i j v) i j = v"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
  for i :: "int"
  and j :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_unchanged:   "get (set m i j v) i' j' = get m i' j'"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "(0 :: int) \<le> i'"
 and "(0 :: int) \<le> j'"
 and "\<not>i = i' \<or> \<not>j = j'"
  for i :: "int"
  and j :: "int"
  and i' :: "int"
  and j' :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_rowz_changed:   "row_zeros (set m i j v) i = j + (1 :: int)"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "row_zeros m i \<le> j"
  for i :: "int"
  and j :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_colz_changed:   "col_zeros (set m i j v) j = i + (1 :: int)"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "col_zeros m j \<le> i"
  for i :: "int"
  and j :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_rowz_unchanged:   "row_zeros (set m i j v) i = row_zeros m i"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "j < row_zeros m i"
  for i :: "int"
  and j :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_colz_unchanged:   "col_zeros (set m i j v) j = col_zeros m j"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "i < col_zeros m j"
  for i :: "int"
  and j :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_other_rowz:   "row_zeros (set m i j v) i' = row_zeros m i'"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "(0 :: int) \<le> i'"
 and "\<not>i = i'"
  for i :: "int"
  and j :: "int"
  and i' :: "int"
  and m :: "mat"
  and v :: "int"
axiomatization where set_def_other_colz:   "col_zeros (set m i j v) j' = col_zeros m j'"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "(0 :: int) \<le> j'"
 and "\<not>j = j'"
  for i :: "int"
  and j :: "int"
  and j' :: "int"
  and m :: "mat"
  and v :: "int"
definition infix_eqeq :: "mat \<Rightarrow> mat \<Rightarrow> _"
  where "infix_eqeq m1 m2 \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<longrightarrow> (0 :: int) \<le> j \<longrightarrow> get m1 i j = get m2 i j)" for m1 m2
axiomatization where extensionality:   "m1 = m2"
 if "infix_eqeq m1 m2"
  for m1 :: "mat"
  and m2 :: "mat"
definition infix_eqeqeq :: "mat \<Rightarrow> mat \<Rightarrow> _"
  where "infix_eqeqeq m1 m2 \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<longrightarrow> (0 :: int) \<le> j \<longrightarrow> row_zeros m1 i = row_zeros m2 i \<and> col_zeros m1 j = col_zeros m2 j)" for m1 m2
definition in_bounds :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "in_bounds m i j \<longleftrightarrow> ((0 :: int) \<le> i \<and> i < col_zeros m j) \<and> (0 :: int) \<le> j \<and> j < row_zeros m i" for m i j
definition size :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "size m r c \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<longrightarrow> row_zeros m i = c) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<longrightarrow> col_zeros m j = r)" for m r c
consts result3 :: "int \<Rightarrow> int \<Rightarrow> int"
consts result4 :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where result'def3:   "result3 c x = max (0 :: int) c"
  for c :: "int"
  and x :: "int"
axiomatization where result'def4:   "result4 r x = max (0 :: int) r"
  for r :: "int"
  and x :: "int"
definition fcreate :: "int \<Rightarrow> int \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> int) \<Rightarrow> mat"
  where "fcreate r c f = create (result3 c) (result4 r) f" for r c f
consts fc :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where fc'def:   "fc y0 y1 = (0 :: int)"
  for y0 :: "int"
  and y1 :: "int"
definition mzero :: "mat"
  where "mzero = fcreate (0 :: int) (0 :: int) fc"
consts fc1 :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where fc'def1:   "fc1 y0 y1 = (0 :: int)"
  for y0 :: "int"
  and y1 :: "int"
definition zerorc :: "int \<Rightarrow> int \<Rightarrow> mat"
  where "zerorc r c = fcreate r c fc1" for r c
definition idf :: "int \<Rightarrow> int \<Rightarrow> int"
  where "idf x y = (if x = y then 1 :: int else (0 :: int))" for x y
consts result5 :: "int \<Rightarrow> int"
consts result6 :: "int \<Rightarrow> int"
consts idf_closure :: "int \<Rightarrow> int \<Rightarrow> int"
axiomatization where result'def5:   "result5 i = i + (1 :: int)"
  for i :: "int"
axiomatization where result'def6:   "result6 j = j + (1 :: int)"
  for j :: "int"
axiomatization where idf_closure_def:   "idf_closure y y1 = idf y y1"
  for y :: "int"
  and y1 :: "int"
definition id1 :: "mat"
  where "id1 = create result5 result6 idf_closure"
definition idrc :: "int \<Rightarrow> int \<Rightarrow> mat"
  where "idrc r c = fcreate r c idf_closure" for r c
consts add2f :: "mat \<Rightarrow> mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where add2f'def:   "add2f a b x y = get a x y + get b x y"
  for a :: "mat"
  and b :: "mat"
  and x :: "int"
  and y :: "int"
consts fc2 :: "mat \<Rightarrow> mat \<Rightarrow> int \<Rightarrow> int"
consts fc3 :: "mat \<Rightarrow> mat \<Rightarrow> int \<Rightarrow> int"
axiomatization where fc'def2:   "fc2 a b i = max (row_zeros a i) (row_zeros b i)"
  for a :: "mat"
  and b :: "mat"
  and i :: "int"
axiomatization where fc'def3:   "fc3 a b j = max (col_zeros a j) (col_zeros b j)"
  for a :: "mat"
  and b :: "mat"
  and j :: "int"
definition f_add :: "mat \<Rightarrow> mat \<Rightarrow> mat"
  where "f_add a b = create (fc2 a b) (fc3 a b) (add2f a b)" for a b
consts add :: "mat \<Rightarrow> mat \<Rightarrow> mat"
axiomatization where add'spec:   "add a b = f_add a b"
  for a :: "mat"
  and b :: "mat"
theorem add_size'vc:
  fixes a :: "mat"
  fixes r :: "int"
  fixes c :: "int"
  fixes b :: "mat"
  assumes fact0: "size a r c"
  assumes fact1: "size b r c"
  shows "size (add a b) r c"
  sorry
end
