theory strassen_InfMatrixGen_size_to_boundsqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl 'a mat
typedecl  t
consts zero :: "t"
consts infix_pl :: "t \<Rightarrow> t \<Rightarrow> t"
consts prefix_mn :: "t \<Rightarrow> t"
consts infix_as :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l:   "infix_pl zero x = x"
  for x :: "t"
axiomatization where Unit_def_r:   "infix_pl x zero = x"
  for x :: "t"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = zero"
  for x :: "t"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = zero"
  for x :: "t"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "t"
  and y :: "t"
consts one :: "t"
axiomatization where Unitary:   "infix_as one x = x"
  for x :: "t"
axiomatization where NonTrivialRing:   "\<not>zero = one"
consts get :: "t mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> t"
consts set :: "t mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> t \<Rightarrow> t mat"
consts row_zeros :: "t mat \<Rightarrow> int \<Rightarrow> int"
consts col_zeros :: "t mat \<Rightarrow> int \<Rightarrow> int"
axiomatization where row_zeros_def:   "get m i j = zero"
 if "(0 :: int) \<le> i"
 and "row_zeros m i \<le> j"
  for i :: "int"
  and m :: "t mat"
  and j :: "int"
axiomatization where col_zeros_def:   "get m i j = zero"
 if "(0 :: int) \<le> j"
 and "col_zeros m j \<le> i"
  for j :: "int"
  and m :: "t mat"
  and i :: "int"
axiomatization where row_zeros_nonneg:   "(0 :: int) \<le> row_zeros m i"
 if "(0 :: int) \<le> i"
  for i :: "int"
  and m :: "t mat"
axiomatization where col_zeros_nonneg:   "(0 :: int) \<le> col_zeros m j"
 if "(0 :: int) \<le> j"
  for j :: "int"
  and m :: "t mat"
axiomatization where set_def_changed:   "get (set m i j v) i j = v"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
  for i :: "int"
  and j :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_unchanged:   "get (set m i j v) i' j' = get m i' j'"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "(0 :: int) \<le> i'"
 and "(0 :: int) \<le> j'"
 and "\<not>i = i' \<or> \<not>j = j'"
  for i :: "int"
  and j :: "int"
  and i' :: "int"
  and j' :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_rowz_changed:   "row_zeros (set m i j v) i = j + (1 :: int)"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "row_zeros m i \<le> j"
  for i :: "int"
  and j :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_colz_changed:   "col_zeros (set m i j v) j = i + (1 :: int)"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "col_zeros m j \<le> i"
  for i :: "int"
  and j :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_rowz_unchanged:   "row_zeros (set m i j v) i = row_zeros m i"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "j < row_zeros m i"
  for i :: "int"
  and j :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_colz_unchanged:   "col_zeros (set m i j v) j = col_zeros m j"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "i < col_zeros m j"
  for i :: "int"
  and j :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_other_rowz:   "row_zeros (set m i j v) i' = row_zeros m i'"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "(0 :: int) \<le> i'"
 and "\<not>i = i'"
  for i :: "int"
  and j :: "int"
  and i' :: "int"
  and m :: "t mat"
  and v :: "t"
axiomatization where set_def_other_colz:   "col_zeros (set m i j v) j' = col_zeros m j'"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "(0 :: int) \<le> j'"
 and "\<not>j = j'"
  for i :: "int"
  and j :: "int"
  and j' :: "int"
  and m :: "t mat"
  and v :: "t"
definition infix_eqeq :: "t mat \<Rightarrow> t mat \<Rightarrow> _"
  where "infix_eqeq m1 m2 \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<longrightarrow> (0 :: int) \<le> j \<longrightarrow> get m1 i j = get m2 i j)" for m1 m2
axiomatization where extensionality:   "m1 = m2"
 if "infix_eqeq m1 m2"
  for m1 :: "t mat"
  and m2 :: "t mat"
definition infix_eqeqeq :: "t mat \<Rightarrow> t mat \<Rightarrow> _"
  where "infix_eqeqeq m1 m2 \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<longrightarrow> (0 :: int) \<le> j \<longrightarrow> row_zeros m1 i = row_zeros m2 i \<and> col_zeros m1 j = col_zeros m2 j)" for m1 m2
definition in_bounds :: "t mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "in_bounds m i j \<longleftrightarrow> ((0 :: int) \<le> i \<and> i < col_zeros m j) \<and> (0 :: int) \<le> j \<and> j < row_zeros m i" for m i j
definition size :: "t mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "size m r c \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<longrightarrow> row_zeros m i = c) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<longrightarrow> col_zeros m j = r)" for m r c
theorem size_to_bounds'vc:
  fixes m :: "t mat"
  fixes r :: "int"
  fixes c :: "int"
  fixes i :: "int"
  fixes j :: "int"
  assumes fact0: "size m r c"
  shows "in_bounds m i j \<longleftrightarrow> ((0 :: int) \<le> i \<and> i < r) \<and> (0 :: int) \<le> j \<and> j < c"
  sorry
end
