theory strassen_InfMatrix_set_def_unchanged
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  t
consts tzero :: "t"
consts infix_pl :: "t \<Rightarrow> t \<Rightarrow> t"
consts prefix_mn :: "t \<Rightarrow> t"
consts infix_as :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l:   "infix_pl tzero x = x"
  for x :: "t"
axiomatization where Unit_def_r:   "infix_pl x tzero = x"
  for x :: "t"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = tzero"
  for x :: "t"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = tzero"
  for x :: "t"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "t"
  and y :: "t"
consts one :: "t"
axiomatization where Unitary:   "infix_as one x = x"
  for x :: "t"
axiomatization where NonTrivialRing:   "\<not>tzero = one"
typedecl  mat
consts get :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> t"
consts row_zeros :: "mat \<Rightarrow> int \<Rightarrow> int"
consts col_zeros :: "mat \<Rightarrow> int \<Rightarrow> int"
consts create :: "(int \<Rightarrow> int) \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> t) \<Rightarrow> mat"
axiomatization where create_rowz:   "row_zeros (create rz cz f) i = rz i"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> rz i"
  for i :: "int"
  and rz :: "int \<Rightarrow> int"
  and cz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> t"
axiomatization where create_colz:   "col_zeros (create rz cz f) j = cz j"
 if "(0 :: int) \<le> j"
 and "(0 :: int) \<le> cz j"
  for j :: "int"
  and cz :: "int \<Rightarrow> int"
  and rz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> t"
axiomatization where create_get_ib:   "get (create rz cz f) i j = f i j"
 if "(0 :: int) \<le> i"
 and "i < cz j"
 and "(0 :: int) \<le> j"
 and "j < rz i"
  for i :: "int"
  and cz :: "int \<Rightarrow> int"
  and j :: "int"
  and rz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> t"
axiomatization where create_get_oob:   "get (create rz cz f) i j = tzero"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
 and "cz j \<le> i \<or> rz i \<le> j"
  for i :: "int"
  and j :: "int"
  and cz :: "int \<Rightarrow> int"
  and rz :: "int \<Rightarrow> int"
  and f :: "int \<Rightarrow> int \<Rightarrow> t"
consts result :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts result1 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
consts result2 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> t \<Rightarrow> int \<Rightarrow> int \<Rightarrow> t"
axiomatization where result'def:   "result m i j i1 = (if i1 = i then max (j + (1 :: int)) (row_zeros m i) else row_zeros m i1)"
  for m :: "mat"
  and i :: "int"
  and j :: "int"
  and i1 :: "int"
axiomatization where result'def1:   "result1 m i j j1 = (if j1 = j then max (i + (1 :: int)) (col_zeros m j) else col_zeros m j1)"
  for m :: "mat"
  and i :: "int"
  and j :: "int"
  and j1 :: "int"
axiomatization where result'def2:   "result2 m i j v i1 j1 = (if i1 = i \<and> j1 = j then v else get m i1 j1)"
  for m :: "mat"
  and i :: "int"
  and j :: "int"
  and v :: "t"
  and i1 :: "int"
  and j1 :: "int"
definition set :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> t \<Rightarrow> mat"
  where "set m i j v = (if (0 :: int) \<le> i \<and> (0 :: int) \<le> j then create (result m i j) (result1 m i j) (result2 m i j v) else m)" for m i j v
consts zero :: "t"
consts infix_pl' :: "t \<Rightarrow> t \<Rightarrow> t"
consts prefix_mn' :: "t \<Rightarrow> t"
consts infix_as' :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc2:   "infix_pl' (infix_pl' x y) z = infix_pl' x (infix_pl' y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l1:   "infix_pl' zero x = x"
  for x :: "t"
axiomatization where Unit_def_r1:   "infix_pl' x zero = x"
  for x :: "t"
axiomatization where Inv_def_l1:   "infix_pl' (prefix_mn' x) x = zero"
  for x :: "t"
axiomatization where Inv_def_r1:   "infix_pl' x (prefix_mn' x) = zero"
  for x :: "t"
axiomatization where Comm2:   "infix_pl' x y = infix_pl' y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc3:   "infix_as' (infix_as' x y) z = infix_as' x (infix_as' y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_l1:   "infix_as' x (infix_pl' y z) = infix_pl' (infix_as' x y) (infix_as' x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r1:   "infix_as' (infix_pl' y z) x = infix_pl' (infix_as' y x) (infix_as' z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
axiomatization where Comm3:   "infix_as' x y = infix_as' y x"
  for x :: "t"
  and y :: "t"
consts one1 :: "t"
axiomatization where Unitary1:   "infix_as' one1 x = x"
  for x :: "t"
axiomatization where NonTrivialRing1:   "\<not>zero = one1"
axiomatization where row_zeros_def:   "get m i j = zero"
 if "(0 :: int) \<le> i"
 and "row_zeros m i \<le> j"
  for i :: "int"
  and m :: "mat"
  and j :: "int"
axiomatization where col_zeros_def:   "get m i j = zero"
 if "(0 :: int) \<le> j"
 and "col_zeros m j \<le> i"
  for j :: "int"
  and m :: "mat"
  and i :: "int"
axiomatization where row_zeros_nonneg:   "(0 :: int) \<le> row_zeros m i"
 if "(0 :: int) \<le> i"
  for i :: "int"
  and m :: "mat"
axiomatization where col_zeros_nonneg:   "(0 :: int) \<le> col_zeros m j"
 if "(0 :: int) \<le> j"
  for j :: "int"
  and m :: "mat"
axiomatization where set_def_changed:   "get (set m i j v) i j = v"
 if "(0 :: int) \<le> i"
 and "(0 :: int) \<le> j"
  for i :: "int"
  and j :: "int"
  and m :: "mat"
  and v :: "t"
theorem set_def_unchanged:
  fixes i :: "int"
  fixes j :: "int"
  fixes i' :: "int"
  fixes j' :: "int"
  fixes m :: "mat"
  fixes v :: "t"
  assumes fact0: "(0 :: int) \<le> i"
  assumes fact1: "(0 :: int) \<le> j"
  assumes fact2: "(0 :: int) \<le> i'"
  assumes fact3: "(0 :: int) \<le> j'"
  assumes fact4: "\<not>i = i' \<or> \<not>j = j'"
  shows "get (set m i j v) i' j' = get m i' j'"
  sorry
end
