theory strassen_MatrixTests_mul_splitqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum" "../../lib/isabelle/strassen_Sum_extended" "../../lib/isabelle/strassen_MaxFun" "../../lib/isabelle/strassen_InfIntMatrix" "../../lib/isabelle/strassen_InfIntMatrixDecision"
begin
consts cols :: "mat \<Rightarrow> int"
consts rows :: "mat \<Rightarrow> int"
axiomatization where rows_def:   "rows a = r"
 if "(0 :: int) \<le> r"
 and "(0 :: int) \<le> c"
 and "strassen_InfIntMatrix.size a r c"
  for r :: "int"
  and c :: "int"
  and a :: "mat"
axiomatization where cols_def:   "cols a = c"
 if "(0 :: int) \<le> r"
 and "(0 :: int) \<le> c"
 and "strassen_InfIntMatrix.size a r c"
  for r :: "int"
  and c :: "int"
  and a :: "mat"
definition is_finite :: "mat \<Rightarrow> _"
  where "is_finite m \<longleftrightarrow> strassen_InfIntMatrix.size m (rows m) (cols m)" for m
consts ofs2 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where ofs2'def:   "ofs2 a ai aj i j = get a (ai + i) (aj + j)"
  for a :: "mat"
  and ai :: "int"
  and aj :: "int"
  and i :: "int"
  and j :: "int"
definition block :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> mat"
  where "block a r dr c dc = fcreate dr dc (ofs2 a r c)" for a r dr c dc
definition c_blocks :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "c_blocks a a1 a2 \<longleftrightarrow> ((0 :: int) \<le> cols a1 \<and> cols a1 \<le> cols a) \<and> a1 = block a (0 :: int) (rows a) (0 :: int) (cols a1) \<and> a2 = block a (0 :: int) (rows a) (cols a1) (cols a - cols a1)" for a a1 a2
definition r_blocks :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "r_blocks a a1 a2 \<longleftrightarrow> ((0 :: int) \<le> rows a1 \<and> rows a1 \<le> rows a) \<and> a1 = block a (0 :: int) (rows a1) (0 :: int) (cols a) \<and> a2 = block a (rows a1) (rows a - rows a1) (0 :: int) (cols a)" for a a1 a2
theorem mul_split'vc:
  fixes a :: "mat"
  fixes b :: "mat"
  fixes a1 :: "mat"
  fixes b1 :: "mat"
  fixes a2 :: "mat"
  fixes b2 :: "mat"
  assumes fact0: "is_finite a"
  assumes fact1: "is_finite b"
  assumes fact2: "cols a = rows b"
  assumes fact3: "cols a1 = rows b1"
  assumes fact4: "(0 :: int) < rows a"
  assumes fact5: "(0 :: int) < cols a"
  assumes fact6: "(0 :: int) < cols b"
  assumes fact7: "(0 :: int) < cols a1"
  assumes fact8: "(0 :: int) < cols a2"
  assumes fact9: "c_blocks a a1 a2"
  assumes fact10: "r_blocks b b1 b2"
  shows "add (mul a1 b1) (mul a2 b2) = mul a b"
  sorry
end
