theory strassen_MatrixTests_naive_blocksqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum" "../../lib/isabelle/strassen_Sum_extended" "../../lib/isabelle/strassen_MaxFun" "../../lib/isabelle/strassen_InfIntMatrix" "../../lib/isabelle/strassen_InfIntMatrixDecision"
begin
consts cols :: "mat \<Rightarrow> int"
consts rows :: "mat \<Rightarrow> int"
axiomatization where rows_def:   "rows a = r"
 if "(0 :: int) \<le> r"
 and "(0 :: int) \<le> c"
 and "strassen_InfIntMatrix.size a r c"
  for r :: "int"
  and c :: "int"
  and a :: "mat"
axiomatization where cols_def:   "cols a = c"
 if "(0 :: int) \<le> r"
 and "(0 :: int) \<le> c"
 and "strassen_InfIntMatrix.size a r c"
  for r :: "int"
  and c :: "int"
  and a :: "mat"
definition is_finite :: "mat \<Rightarrow> _"
  where "is_finite m \<longleftrightarrow> strassen_InfIntMatrix.size m (rows m) (cols m)" for m
consts ofs2 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where ofs2'def:   "ofs2 a ai aj i j = get a (ai + i) (aj + j)"
  for a :: "mat"
  and ai :: "int"
  and aj :: "int"
  and i :: "int"
  and j :: "int"
definition block :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> mat"
  where "block a r dr c dc = fcreate dr dc (ofs2 a r c)" for a r dr c dc
definition c_blocks :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "c_blocks a a1 a2 \<longleftrightarrow> ((0 :: int) \<le> cols a1 \<and> cols a1 \<le> cols a) \<and> a1 = block a (0 :: int) (rows a) (0 :: int) (cols a1) \<and> a2 = block a (0 :: int) (rows a) (cols a1) (cols a - cols a1)" for a a1 a2
definition r_blocks :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "r_blocks a a1 a2 \<longleftrightarrow> ((0 :: int) \<le> rows a1 \<and> rows a1 \<le> rows a) \<and> a1 = block a (0 :: int) (rows a1) (0 :: int) (cols a) \<and> a2 = block a (rows a1) (rows a - rows a1) (0 :: int) (cols a)" for a a1 a2
definition quarters :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "quarters a a11 a12 a21 a22 \<longleftrightarrow> (is_finite a \<and> is_finite a11 \<and> is_finite a12 \<and> is_finite a21 \<and> is_finite a22) \<and> (rows a11 = rows a12 \<and> rows a12 = rows a21 \<and> rows a21 = rows a22 \<and> rows a22 = cols a11 \<and> cols a11 = cols a12 \<and> cols a12 = cols a21 \<and> cols a21 = cols a22) \<and> (rows a = cols a \<and> cols a = (2 :: int) * rows a11) \<and> a11 = block a (0 :: int) (rows a11) (0 :: int) (cols a11) \<and> a12 = block a (0 :: int) (rows a11) (cols a11) (cols a11) \<and> a21 = block a (rows a11) (rows a11) (0 :: int) (cols a11) \<and> a22 = block a (rows a11) (rows a11) (cols a11) (cols a11)" for a a11 a12 a21 a22
theorem naive_blocks'vc:
  fixes a :: "mat"
  fixes b :: "mat"
  fixes c :: "mat"
  fixes a11 :: "mat"
  fixes a12 :: "mat"
  fixes a21 :: "mat"
  fixes a22 :: "mat"
  fixes b11 :: "mat"
  fixes b12 :: "mat"
  fixes b21 :: "mat"
  fixes b22 :: "mat"
  assumes fact0: "is_finite a"
  assumes fact1: "is_finite b"
  assumes fact2: "is_finite c"
  assumes fact3: "quarters a a11 a12 a21 a22"
  assumes fact4: "quarters b b11 b12 b21 b22"
  assumes fact5: "quarters c (add (mul a11 b11) (mul a12 b21)) (add (mul a11 b12) (mul a12 b22)) (add (mul a21 b11) (mul a22 b21)) (add (mul a21 b12) (mul a22 b22))"
  shows "c = mul a b"
  sorry
end
