theory strassen_MatrixTests_strassen_pow2qtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.int_Sum" "../../lib/isabelle/strassen_Sum_extended" "../../lib/isabelle/strassen_MaxFun" "../../lib/isabelle/strassen_InfIntMatrix" "../../lib/isabelle/strassen_InfIntMatrixDecision"
begin
consts cols :: "mat \<Rightarrow> int"
consts rows :: "mat \<Rightarrow> int"
axiomatization where rows_def:   "rows a = r"
 if "(0 :: int) \<le> r"
 and "(0 :: int) \<le> c"
 and "strassen_InfIntMatrix.size a r c"
  for r :: "int"
  and c :: "int"
  and a :: "mat"
axiomatization where cols_def:   "cols a = c"
 if "(0 :: int) \<le> r"
 and "(0 :: int) \<le> c"
 and "strassen_InfIntMatrix.size a r c"
  for r :: "int"
  and c :: "int"
  and a :: "mat"
definition is_finite :: "mat \<Rightarrow> _"
  where "is_finite m \<longleftrightarrow> strassen_InfIntMatrix.size m (rows m) (cols m)" for m
consts ofs2 :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where ofs2'def:   "ofs2 a ai aj i j = get a (ai + i) (aj + j)"
  for a :: "mat"
  and ai :: "int"
  and aj :: "int"
  and i :: "int"
  and j :: "int"
definition block :: "mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> mat"
  where "block a r dr c dc = fcreate dr dc (ofs2 a r c)" for a r dr c dc
definition c_blocks :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "c_blocks a a1 a2 \<longleftrightarrow> ((0 :: int) \<le> cols a1 \<and> cols a1 \<le> cols a) \<and> a1 = block a (0 :: int) (rows a) (0 :: int) (cols a1) \<and> a2 = block a (0 :: int) (rows a) (cols a1) (cols a - cols a1)" for a a1 a2
definition r_blocks :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "r_blocks a a1 a2 \<longleftrightarrow> ((0 :: int) \<le> rows a1 \<and> rows a1 \<le> rows a) \<and> a1 = block a (0 :: int) (rows a1) (0 :: int) (cols a) \<and> a2 = block a (rows a1) (rows a - rows a1) (0 :: int) (cols a)" for a a1 a2
definition quarters :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> _"
  where "quarters a a11 a12 a21 a22 \<longleftrightarrow> (is_finite a \<and> is_finite a11 \<and> is_finite a12 \<and> is_finite a21 \<and> is_finite a22) \<and> (rows a11 = rows a12 \<and> rows a12 = rows a21 \<and> rows a21 = rows a22 \<and> rows a22 = cols a11 \<and> cols a11 = cols a12 \<and> cols a12 = cols a21 \<and> cols a21 = cols a22) \<and> (rows a = cols a \<and> cols a = (2 :: int) * rows a11) \<and> a11 = block a (0 :: int) (rows a11) (0 :: int) (cols a11) \<and> a12 = block a (0 :: int) (rows a11) (cols a11) (cols a11) \<and> a21 = block a (rows a11) (rows a11) (0 :: int) (cols a11) \<and> a22 = block a (rows a11) (rows a11) (cols a11) (cols a11)" for a a11 a12 a21 a22
consts cut_quarters :: "mat \<Rightarrow> mat \<times> mat \<times> mat \<times> mat"
axiomatization where cut_quarters'def:   "cut_quarters a = (block a (0 :: int) (rows a cdiv (2 :: int)) (0 :: int) (rows a cdiv (2 :: int)), block a (0 :: int) (rows a cdiv (2 :: int)) (rows a cdiv (2 :: int)) (rows a cdiv (2 :: int)), block a (rows a cdiv (2 :: int)) (rows a cdiv (2 :: int)) (0 :: int) (rows a cdiv (2 :: int)), block a (rows a cdiv (2 :: int)) (rows a cdiv (2 :: int)) (rows a cdiv (2 :: int)) (rows a cdiv (2 :: int)))"
 if "is_finite a"
 and "rows a = cols a"
 and "even (rows a)"
  for a :: "mat"
axiomatization where cut_quarters'spec:   "case cut_quarters a of (a11, a12, a21, a22) \<Rightarrow> quarters a a11 a12 a21 a22"
 if "is_finite a"
 and "rows a = cols a"
 and "even (rows a)"
  for a :: "mat"
consts paste_quarters :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat"
consts result :: "mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where result'def:   "result a11 a12 a21 a22 s i j = (if i < s \<and> j < s then get a11 i j else if i < s then get a12 i (j - s) else if j < s then get a21 (i - s) j else get a22 (i - s) (j - s))"
  for a11 :: "mat"
  and a12 :: "mat"
  and a21 :: "mat"
  and a22 :: "mat"
  and s :: "int"
  and i :: "int"
  and j :: "int"
axiomatization where paste_quarters'def:   "paste_quarters a11 a12 a21 a22 = fcreate ((2 :: int) * rows a11) ((2 :: int) * rows a11) (result a11 a12 a21 a22 (rows a11))"
 if "is_finite a11"
 and "is_finite a12"
 and "is_finite a21"
 and "is_finite a22"
 and "rows a11 = rows a12"
 and "rows a12 = rows a21"
 and "rows a21 = rows a22"
 and "rows a22 = cols a11"
 and "cols a11 = cols a12"
 and "cols a12 = cols a21"
 and "cols a21 = cols a22"
  for a11 :: "mat"
  and a12 :: "mat"
  and a21 :: "mat"
  and a22 :: "mat"
axiomatization where paste_quarters'spec:   "quarters (paste_quarters a11 a12 a21 a22) a11 a12 a21 a22"
 if "is_finite a11"
 and "is_finite a12"
 and "is_finite a21"
 and "is_finite a22"
 and "rows a11 = rows a12"
 and "rows a12 = rows a21"
 and "rows a21 = rows a22"
 and "rows a22 = cols a11"
 and "cols a11 = cols a12"
 and "cols a12 = cols a21"
 and "cols a21 = cols a22"
  for a11 :: "mat"
  and a12 :: "mat"
  and a21 :: "mat"
  and a22 :: "mat"
theorem strassen_pow2'vc:
  fixes k :: "int"
  fixes a :: "mat"
  fixes b :: "mat"
  assumes fact0: "(0 :: int) \<le> k"
  assumes fact1: "strassen_InfIntMatrix.size a ((2 :: int) ^\<^sub>i k) ((2 :: int) ^\<^sub>i k)"
  assumes fact2: "strassen_InfIntMatrix.size b ((2 :: int) ^\<^sub>i k) ((2 :: int) ^\<^sub>i k)"
  shows "(1 :: int) \<le> (4 :: int)"
  and "\<forall>(cutoff :: int). (1 :: int) \<le> cutoff \<longrightarrow> (\<not>k \<le> cutoff \<longrightarrow> (is_finite a \<and> rows a = cols a \<and> even (rows a)) \<and> (let o1 :: mat \<times> mat \<times> mat \<times> mat = cut_quarters a in (case o1 of (a11, a12, a21, a22) \<Rightarrow> quarters a a11 a12 a21 a22) \<longrightarrow> (case o1 of (a11, a12, a21, a22) \<Rightarrow> (is_finite b \<and> rows b = cols b \<and> even (rows b)) \<and> (let o2 :: mat \<times> mat \<times> mat \<times> mat = cut_quarters b in (case o2 of (a111, a121, a211, a221) \<Rightarrow> quarters b a111 a121 a211 a221) \<longrightarrow> (case o2 of (b11, b12, b21, b22) \<Rightarrow> (let o3 :: mat = mul a12 b21 in o3 = f_mul a12 b21 \<longrightarrow> (let o4 :: mat = mul a11 b11 in o4 = f_mul a11 b11 \<longrightarrow> (let c11 :: mat = add o4 o3 in c11 = f_add o4 o3 \<longrightarrow> (let o5 :: mat = mul a12 b22 in o5 = f_mul a12 b22 \<longrightarrow> (let o6 :: mat = mul a11 b12 in o6 = f_mul a11 b12 \<longrightarrow> (let c12 :: mat = add o6 o5 in c12 = f_add o6 o5 \<longrightarrow> (let o7 :: mat = mul a22 b21 in o7 = f_mul a22 b21 \<longrightarrow> (let o8 :: mat = mul a21 b11 in o8 = f_mul a21 b11 \<longrightarrow> (let c21 :: mat = add o8 o7 in c21 = f_add o8 o7 \<longrightarrow> (let o9 :: mat = mul a22 b22 in o9 = f_mul a22 b22 \<longrightarrow> (let o10 :: mat = mul a21 b12 in o10 = f_mul a21 b12 \<longrightarrow> (let c22 :: mat = add o10 o9 in c22 = f_add o10 o9 \<longrightarrow> ((is_finite c11 \<and> is_finite c12 \<and> is_finite c21 \<and> is_finite c22) \<and> rows c11 = rows c12 \<and> rows c12 = rows c21 \<and> rows c21 = rows c22 \<and> rows c22 = cols c11 \<and> cols c11 = cols c12 \<and> cols c12 = cols c21 \<and> cols c21 = cols c22) \<and> (quarters (paste_quarters c11 c12 c21 c22) c11 c12 c21 c22 \<longrightarrow> (let o11 :: int = k - (1 :: int); o12 :: mat = add b11 b22 in o12 = f_add b11 b22 \<longrightarrow> (let o13 :: mat = add a11 a22 in o13 = f_add a11 a22 \<longrightarrow> (((0 :: int) \<le> k \<and> o11 < k) \<and> (0 :: int) \<le> o11 \<and> strassen_InfIntMatrix.size o13 ((2 :: int) ^\<^sub>i o11) ((2 :: int) ^\<^sub>i o11) \<and> strassen_InfIntMatrix.size o12 ((2 :: int) ^\<^sub>i o11) ((2 :: int) ^\<^sub>i o11)) \<and> (let m1 :: mat = mul o13 o12; o14 :: int = k - (1 :: int); o15 :: mat = add a21 a22 in o15 = f_add a21 a22 \<longrightarrow> (((0 :: int) \<le> k \<and> o14 < k) \<and> (0 :: int) \<le> o14 \<and> strassen_InfIntMatrix.size o15 ((2 :: int) ^\<^sub>i o14) ((2 :: int) ^\<^sub>i o14) \<and> strassen_InfIntMatrix.size b11 ((2 :: int) ^\<^sub>i o14) ((2 :: int) ^\<^sub>i o14)) \<and> (let m2 :: mat = mul o15 b11; o16 :: int = k - (1 :: int); o17 :: mat = sub b12 b22 in (((0 :: int) \<le> k \<and> o16 < k) \<and> (0 :: int) \<le> o16 \<and> strassen_InfIntMatrix.size a11 ((2 :: int) ^\<^sub>i o16) ((2 :: int) ^\<^sub>i o16) \<and> strassen_InfIntMatrix.size o17 ((2 :: int) ^\<^sub>i o16) ((2 :: int) ^\<^sub>i o16)) \<and> (let m3 :: mat = mul a11 o17; o18 :: int = k - (1 :: int); o19 :: mat = sub b21 b11 in (((0 :: int) \<le> k \<and> o18 < k) \<and> (0 :: int) \<le> o18 \<and> strassen_InfIntMatrix.size a22 ((2 :: int) ^\<^sub>i o18) ((2 :: int) ^\<^sub>i o18) \<and> strassen_InfIntMatrix.size o19 ((2 :: int) ^\<^sub>i o18) ((2 :: int) ^\<^sub>i o18)) \<and> (let m4 :: mat = mul a22 o19; o20 :: int = k - (1 :: int); o21 :: mat = add a11 a12 in o21 = f_add a11 a12 \<longrightarrow> (((0 :: int) \<le> k \<and> o20 < k) \<and> (0 :: int) \<le> o20 \<and> strassen_InfIntMatrix.size o21 ((2 :: int) ^\<^sub>i o20) ((2 :: int) ^\<^sub>i o20) \<and> strassen_InfIntMatrix.size b22 ((2 :: int) ^\<^sub>i o20) ((2 :: int) ^\<^sub>i o20)) \<and> (let m5 :: mat = mul o21 b22; o22 :: int = k - (1 :: int); o23 :: mat = add b11 b12 in o23 = f_add b11 b12 \<longrightarrow> (let o24 :: mat = sub a21 a11 in (((0 :: int) \<le> k \<and> o22 < k) \<and> (0 :: int) \<le> o22 \<and> strassen_InfIntMatrix.size o24 ((2 :: int) ^\<^sub>i o22) ((2 :: int) ^\<^sub>i o22) \<and> strassen_InfIntMatrix.size o23 ((2 :: int) ^\<^sub>i o22) ((2 :: int) ^\<^sub>i o22)) \<and> (let o25 :: int = k - (1 :: int); o26 :: mat = add b21 b22 in o26 = f_add b21 b22 \<longrightarrow> (let o27 :: mat = sub a12 a22 in (((0 :: int) \<le> k \<and> o25 < k) \<and> (0 :: int) \<le> o25 \<and> strassen_InfIntMatrix.size o27 ((2 :: int) ^\<^sub>i o25) ((2 :: int) ^\<^sub>i o25) \<and> strassen_InfIntMatrix.size o26 ((2 :: int) ^\<^sub>i o25) ((2 :: int) ^\<^sub>i o25)) \<and> (let o28 :: mat = sub (mul o27 o26) m5; o29 :: mat = add m4 o28 in o29 = f_add m4 o28 \<longrightarrow> (let s11 :: mat = add m1 o29 in s11 = f_add m1 o29 \<longrightarrow> (let s12 :: mat = add m3 m5 in s12 = f_add m3 m5 \<longrightarrow> (let s21 :: mat = add m2 m4 in s21 = f_add m2 m4 \<longrightarrow> (let o30 :: mat = sub (mul o24 o23) m2; o31 :: mat = add m3 o30 in o31 = f_add m3 o30 \<longrightarrow> (let s22 :: mat = add m1 o31 in s22 = f_add m1 o31 \<longrightarrow> (is_finite s11 \<and> is_finite s12 \<and> is_finite s21 \<and> is_finite s22) \<and> rows s11 = rows s12 \<and> rows s12 = rows s21 \<and> rows s21 = rows s22 \<and> rows s22 = cols s11 \<and> cols s11 = cols s12 \<and> cols s12 = cols s21 \<and> cols s21 = cols s22)))))))))))))))))))))))))))))))))) \<and> (\<forall>(result1 :: mat). (if k \<le> cutoff then result1 = mul a b \<and> result1 = f_mul a b else let o1 :: mat \<times> mat \<times> mat \<times> mat = cut_quarters a in (case o1 of (a11, a12, a21, a22) \<Rightarrow> quarters a a11 a12 a21 a22) \<and> (case o1 of (a11, a12, a21, a22) \<Rightarrow> (let o2 :: mat \<times> mat \<times> mat \<times> mat = cut_quarters b in (case o2 of (a111, a121, a211, a221) \<Rightarrow> quarters b a111 a121 a211 a221) \<and> (case o2 of (b11, b12, b21, b22) \<Rightarrow> (let o3 :: mat = mul a12 b21 in o3 = f_mul a12 b21 \<and> (let o4 :: mat = mul a11 b11 in o4 = f_mul a11 b11 \<and> (let c11 :: mat = add o4 o3 in c11 = f_add o4 o3 \<and> (let o5 :: mat = mul a12 b22 in o5 = f_mul a12 b22 \<and> (let o6 :: mat = mul a11 b12 in o6 = f_mul a11 b12 \<and> (let c12 :: mat = add o6 o5 in c12 = f_add o6 o5 \<and> (let o7 :: mat = mul a22 b21 in o7 = f_mul a22 b21 \<and> (let o8 :: mat = mul a21 b11 in o8 = f_mul a21 b11 \<and> (let c21 :: mat = add o8 o7 in c21 = f_add o8 o7 \<and> (let o9 :: mat = mul a22 b22 in o9 = f_mul a22 b22 \<and> (let o10 :: mat = mul a21 b12 in o10 = f_mul a21 b12 \<and> (let c22 :: mat = add o10 o9 in c22 = f_add o10 o9 \<and> quarters (paste_quarters c11 c12 c21 c22) c11 c12 c21 c22 \<and> (let o11 :: mat = add b11 b22 in o11 = f_add b11 b22 \<and> (let o12 :: mat = add a11 a22 in o12 = f_add a11 a22 \<and> (let m1 :: mat = mul o12 o11; o13 :: mat = add a21 a22 in o13 = f_add a21 a22 \<and> (let m2 :: mat = mul o13 b11; m3 :: mat = mul a11 (sub b12 b22); m4 :: mat = mul a22 (sub b21 b11); o14 :: mat = add a11 a12 in o14 = f_add a11 a12 \<and> (let m5 :: mat = mul o14 b22; o15 :: mat = add b11 b12 in o15 = f_add b11 b12 \<and> (let o16 :: mat = add b21 b22 in o16 = f_add b21 b22 \<and> (let o17 :: mat = sub (mul (sub a12 a22) o16) m5; o18 :: mat = add m4 o17 in o18 = f_add m4 o17 \<and> (let s11 :: mat = add m1 o18 in s11 = f_add m1 o18 \<and> (let s12 :: mat = add m3 m5 in s12 = f_add m3 m5 \<and> (let s21 :: mat = add m2 m4 in s21 = f_add m2 m4 \<and> (let o19 :: mat = sub (mul (sub a21 a11) o15) m2; o20 :: mat = add m3 o19 in o20 = f_add m3 o19 \<and> (let s22 :: mat = add m1 o20 in s22 = f_add m1 o20 \<and> result1 = paste_quarters s11 s12 s21 s22 \<and> quarters result1 s11 s12 s21 s22)))))))))))))))))))))))))))) \<longrightarrow> result1 = mul a b)"
  sorry
end
