import Why3.Base
import Why3.int.Sum
import pearl.ring_decision.lib.lean.strassen.Sum_extended
import pearl.ring_decision.lib.lean.strassen.MaxFun
import pearl.ring_decision.lib.lean.strassen.InfIntMatrix
import pearl.ring_decision.lib.lean.strassen.InfIntMatrixDecision
open Classical
open Lean4Why3
namespace strassen_MatrixTests_strassen_pow2qtvc
axiom cols : InfIntMatrix.mat -> ℤ
axiom rows : InfIntMatrix.mat -> ℤ
axiom rows_def (r : ℤ) (c : ℤ) (a : InfIntMatrix.mat) (fact0 : (0 : ℤ) ≤ r) (fact1 : (0 : ℤ) ≤ c) (fact2 : InfIntMatrix.size a r c) : rows a = r
axiom cols_def (r : ℤ) (c : ℤ) (a : InfIntMatrix.mat) (fact0 : (0 : ℤ) ≤ r) (fact1 : (0 : ℤ) ≤ c) (fact2 : InfIntMatrix.size a r c) : cols a = c
noncomputable def is_finite (m : InfIntMatrix.mat) := InfIntMatrix.size m (rows m) (cols m)
axiom ofs2 : InfIntMatrix.mat -> ℤ -> ℤ -> ℤ -> ℤ -> ℤ
axiom ofs2'def (a : InfIntMatrix.mat) (ai : ℤ) (aj : ℤ) (i : ℤ) (j : ℤ) : ofs2 a ai aj i j = InfIntMatrix.get a (ai + i) (aj + j)
noncomputable def block (a : InfIntMatrix.mat) (r : ℤ) (dr : ℤ) (c : ℤ) (dc : ℤ) := InfIntMatrix.fcreate dr dc (ofs2 a r c)
noncomputable def c_blocks (a : InfIntMatrix.mat) (a1 : InfIntMatrix.mat) (a2 : InfIntMatrix.mat) := ((0 : ℤ) ≤ cols a1 ∧ cols a1 ≤ cols a) ∧ a1 = block a (0 : ℤ) (rows a) (0 : ℤ) (cols a1) ∧ a2 = block a (0 : ℤ) (rows a) (cols a1) (cols a - cols a1)
noncomputable def r_blocks (a : InfIntMatrix.mat) (a1 : InfIntMatrix.mat) (a2 : InfIntMatrix.mat) := ((0 : ℤ) ≤ rows a1 ∧ rows a1 ≤ rows a) ∧ a1 = block a (0 : ℤ) (rows a1) (0 : ℤ) (cols a) ∧ a2 = block a (rows a1) (rows a - rows a1) (0 : ℤ) (cols a)
noncomputable def quarters (a : InfIntMatrix.mat) (a11 : InfIntMatrix.mat) (a12 : InfIntMatrix.mat) (a21 : InfIntMatrix.mat) (a22 : InfIntMatrix.mat) := (is_finite a ∧ is_finite a11 ∧ is_finite a12 ∧ is_finite a21 ∧ is_finite a22) ∧ (rows a11 = rows a12 ∧ rows a12 = rows a21 ∧ rows a21 = rows a22 ∧ rows a22 = cols a11 ∧ cols a11 = cols a12 ∧ cols a12 = cols a21 ∧ cols a21 = cols a22) ∧ (rows a = cols a ∧ cols a = (2 : ℤ) * rows a11) ∧ a11 = block a (0 : ℤ) (rows a11) (0 : ℤ) (cols a11) ∧ a12 = block a (0 : ℤ) (rows a11) (cols a11) (cols a11) ∧ a21 = block a (rows a11) (rows a11) (0 : ℤ) (cols a11) ∧ a22 = block a (rows a11) (rows a11) (cols a11) (cols a11)
axiom cut_quarters : InfIntMatrix.mat -> InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat
axiom cut_quarters'def (a : InfIntMatrix.mat) (fact0 : is_finite a) (fact1 : rows a = cols a) (fact2 : Even (rows a)) : cut_quarters a = (block a (0 : ℤ) (Int.tdiv (rows a) (2 : ℤ)) (0 : ℤ) (Int.tdiv (rows a) (2 : ℤ)), block a (0 : ℤ) (Int.tdiv (rows a) (2 : ℤ)) (Int.tdiv (rows a) (2 : ℤ)) (Int.tdiv (rows a) (2 : ℤ)), block a (Int.tdiv (rows a) (2 : ℤ)) (Int.tdiv (rows a) (2 : ℤ)) (0 : ℤ) (Int.tdiv (rows a) (2 : ℤ)), block a (Int.tdiv (rows a) (2 : ℤ)) (Int.tdiv (rows a) (2 : ℤ)) (Int.tdiv (rows a) (2 : ℤ)) (Int.tdiv (rows a) (2 : ℤ)))
axiom cut_quarters'spec (a : InfIntMatrix.mat) (fact0 : is_finite a) (fact1 : rows a = cols a) (fact2 : Even (rows a)) : match cut_quarters a with | (a11, a12, a21, a22) => quarters a a11 a12 a21 a22
axiom paste_quarters : InfIntMatrix.mat -> InfIntMatrix.mat -> InfIntMatrix.mat -> InfIntMatrix.mat -> InfIntMatrix.mat
axiom result : InfIntMatrix.mat -> InfIntMatrix.mat -> InfIntMatrix.mat -> InfIntMatrix.mat -> ℤ -> ℤ -> ℤ -> ℤ
axiom result'def (a11 : InfIntMatrix.mat) (a12 : InfIntMatrix.mat) (a21 : InfIntMatrix.mat) (a22 : InfIntMatrix.mat) (s : ℤ) (i : ℤ) (j : ℤ) : result a11 a12 a21 a22 s i j = (if i < s ∧ j < s then InfIntMatrix.get a11 i j else if i < s then InfIntMatrix.get a12 i (j - s) else if j < s then InfIntMatrix.get a21 (i - s) j else InfIntMatrix.get a22 (i - s) (j - s))
axiom paste_quarters'def (a11 : InfIntMatrix.mat) (a12 : InfIntMatrix.mat) (a21 : InfIntMatrix.mat) (a22 : InfIntMatrix.mat) (fact0 : is_finite a11) (fact1 : is_finite a12) (fact2 : is_finite a21) (fact3 : is_finite a22) (fact4 : rows a11 = rows a12) (fact5 : rows a12 = rows a21) (fact6 : rows a21 = rows a22) (fact7 : rows a22 = cols a11) (fact8 : cols a11 = cols a12) (fact9 : cols a12 = cols a21) (fact10 : cols a21 = cols a22) : paste_quarters a11 a12 a21 a22 = InfIntMatrix.fcreate ((2 : ℤ) * rows a11) ((2 : ℤ) * rows a11) (result a11 a12 a21 a22 (rows a11))
axiom paste_quarters'spec (a11 : InfIntMatrix.mat) (a12 : InfIntMatrix.mat) (a21 : InfIntMatrix.mat) (a22 : InfIntMatrix.mat) (fact0 : is_finite a11) (fact1 : is_finite a12) (fact2 : is_finite a21) (fact3 : is_finite a22) (fact4 : rows a11 = rows a12) (fact5 : rows a12 = rows a21) (fact6 : rows a21 = rows a22) (fact7 : rows a22 = cols a11) (fact8 : cols a11 = cols a12) (fact9 : cols a12 = cols a21) (fact10 : cols a21 = cols a22) : quarters (paste_quarters a11 a12 a21 a22) a11 a12 a21 a22
lemma strassen_pow2'vc (k : ℤ) (a : InfIntMatrix.mat) (b : InfIntMatrix.mat) (fact0 : (0 : ℤ) ≤ k) (fact1 : InfIntMatrix.size a (HPow.hPow (2 : ℤ) (Int.toNat k)) (HPow.hPow (2 : ℤ) (Int.toNat k))) (fact2 : InfIntMatrix.size b (HPow.hPow (2 : ℤ) (Int.toNat k)) (HPow.hPow (2 : ℤ) (Int.toNat k))) : (1 : ℤ) ≤ (4 : ℤ) ∧ (∀(cutoff : ℤ), (1 : ℤ) ≤ cutoff → (¬k ≤ cutoff → (is_finite a ∧ rows a = cols a ∧ Even (rows a)) ∧ (let o1 : InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat := cut_quarters a; (match o1 with | (a11, a12, a21, a22) => quarters a a11 a12 a21 a22) → (match o1 with | (a11, a12, a21, a22) => (is_finite b ∧ rows b = cols b ∧ Even (rows b)) ∧ (let o2 : InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat := cut_quarters b; (match o2 with | (a111, a121, a211, a221) => quarters b a111 a121 a211 a221) → (match o2 with | (b11, b12, b21, b22) => (let o3 : InfIntMatrix.mat := InfIntMatrix.mul a12 b21; o3 = InfIntMatrix.f_mul a12 b21 → (let o4 : InfIntMatrix.mat := InfIntMatrix.mul a11 b11; o4 = InfIntMatrix.f_mul a11 b11 → (let c11 : InfIntMatrix.mat := InfIntMatrix.add o4 o3; c11 = InfIntMatrix.f_add o4 o3 → (let o5 : InfIntMatrix.mat := InfIntMatrix.mul a12 b22; o5 = InfIntMatrix.f_mul a12 b22 → (let o6 : InfIntMatrix.mat := InfIntMatrix.mul a11 b12; o6 = InfIntMatrix.f_mul a11 b12 → (let c12 : InfIntMatrix.mat := InfIntMatrix.add o6 o5; c12 = InfIntMatrix.f_add o6 o5 → (let o7 : InfIntMatrix.mat := InfIntMatrix.mul a22 b21; o7 = InfIntMatrix.f_mul a22 b21 → (let o8 : InfIntMatrix.mat := InfIntMatrix.mul a21 b11; o8 = InfIntMatrix.f_mul a21 b11 → (let c21 : InfIntMatrix.mat := InfIntMatrix.add o8 o7; c21 = InfIntMatrix.f_add o8 o7 → (let o9 : InfIntMatrix.mat := InfIntMatrix.mul a22 b22; o9 = InfIntMatrix.f_mul a22 b22 → (let o10 : InfIntMatrix.mat := InfIntMatrix.mul a21 b12; o10 = InfIntMatrix.f_mul a21 b12 → (let c22 : InfIntMatrix.mat := InfIntMatrix.add o10 o9; c22 = InfIntMatrix.f_add o10 o9 → ((is_finite c11 ∧ is_finite c12 ∧ is_finite c21 ∧ is_finite c22) ∧ rows c11 = rows c12 ∧ rows c12 = rows c21 ∧ rows c21 = rows c22 ∧ rows c22 = cols c11 ∧ cols c11 = cols c12 ∧ cols c12 = cols c21 ∧ cols c21 = cols c22) ∧ (quarters (paste_quarters c11 c12 c21 c22) c11 c12 c21 c22 → (let o11 : ℤ := k - (1 : ℤ); let o12 : InfIntMatrix.mat := InfIntMatrix.add b11 b22; o12 = InfIntMatrix.f_add b11 b22 → (let o13 : InfIntMatrix.mat := InfIntMatrix.add a11 a22; o13 = InfIntMatrix.f_add a11 a22 → (((0 : ℤ) ≤ k ∧ o11 < k) ∧ (0 : ℤ) ≤ o11 ∧ InfIntMatrix.size o13 (HPow.hPow (2 : ℤ) (Int.toNat o11)) (HPow.hPow (2 : ℤ) (Int.toNat o11)) ∧ InfIntMatrix.size o12 (HPow.hPow (2 : ℤ) (Int.toNat o11)) (HPow.hPow (2 : ℤ) (Int.toNat o11))) ∧ (let m1 : InfIntMatrix.mat := InfIntMatrix.mul o13 o12; let o14 : ℤ := k - (1 : ℤ); let o15 : InfIntMatrix.mat := InfIntMatrix.add a21 a22; o15 = InfIntMatrix.f_add a21 a22 → (((0 : ℤ) ≤ k ∧ o14 < k) ∧ (0 : ℤ) ≤ o14 ∧ InfIntMatrix.size o15 (HPow.hPow (2 : ℤ) (Int.toNat o14)) (HPow.hPow (2 : ℤ) (Int.toNat o14)) ∧ InfIntMatrix.size b11 (HPow.hPow (2 : ℤ) (Int.toNat o14)) (HPow.hPow (2 : ℤ) (Int.toNat o14))) ∧ (let m2 : InfIntMatrix.mat := InfIntMatrix.mul o15 b11; let o16 : ℤ := k - (1 : ℤ); let o17 : InfIntMatrix.mat := InfIntMatrix.sub b12 b22; (((0 : ℤ) ≤ k ∧ o16 < k) ∧ (0 : ℤ) ≤ o16 ∧ InfIntMatrix.size a11 (HPow.hPow (2 : ℤ) (Int.toNat o16)) (HPow.hPow (2 : ℤ) (Int.toNat o16)) ∧ InfIntMatrix.size o17 (HPow.hPow (2 : ℤ) (Int.toNat o16)) (HPow.hPow (2 : ℤ) (Int.toNat o16))) ∧ (let m3 : InfIntMatrix.mat := InfIntMatrix.mul a11 o17; let o18 : ℤ := k - (1 : ℤ); let o19 : InfIntMatrix.mat := InfIntMatrix.sub b21 b11; (((0 : ℤ) ≤ k ∧ o18 < k) ∧ (0 : ℤ) ≤ o18 ∧ InfIntMatrix.size a22 (HPow.hPow (2 : ℤ) (Int.toNat o18)) (HPow.hPow (2 : ℤ) (Int.toNat o18)) ∧ InfIntMatrix.size o19 (HPow.hPow (2 : ℤ) (Int.toNat o18)) (HPow.hPow (2 : ℤ) (Int.toNat o18))) ∧ (let m4 : InfIntMatrix.mat := InfIntMatrix.mul a22 o19; let o20 : ℤ := k - (1 : ℤ); let o21 : InfIntMatrix.mat := InfIntMatrix.add a11 a12; o21 = InfIntMatrix.f_add a11 a12 → (((0 : ℤ) ≤ k ∧ o20 < k) ∧ (0 : ℤ) ≤ o20 ∧ InfIntMatrix.size o21 (HPow.hPow (2 : ℤ) (Int.toNat o20)) (HPow.hPow (2 : ℤ) (Int.toNat o20)) ∧ InfIntMatrix.size b22 (HPow.hPow (2 : ℤ) (Int.toNat o20)) (HPow.hPow (2 : ℤ) (Int.toNat o20))) ∧ (let m5 : InfIntMatrix.mat := InfIntMatrix.mul o21 b22; let o22 : ℤ := k - (1 : ℤ); let o23 : InfIntMatrix.mat := InfIntMatrix.add b11 b12; o23 = InfIntMatrix.f_add b11 b12 → (let o24 : InfIntMatrix.mat := InfIntMatrix.sub a21 a11; (((0 : ℤ) ≤ k ∧ o22 < k) ∧ (0 : ℤ) ≤ o22 ∧ InfIntMatrix.size o24 (HPow.hPow (2 : ℤ) (Int.toNat o22)) (HPow.hPow (2 : ℤ) (Int.toNat o22)) ∧ InfIntMatrix.size o23 (HPow.hPow (2 : ℤ) (Int.toNat o22)) (HPow.hPow (2 : ℤ) (Int.toNat o22))) ∧ (let o25 : ℤ := k - (1 : ℤ); let o26 : InfIntMatrix.mat := InfIntMatrix.add b21 b22; o26 = InfIntMatrix.f_add b21 b22 → (let o27 : InfIntMatrix.mat := InfIntMatrix.sub a12 a22; (((0 : ℤ) ≤ k ∧ o25 < k) ∧ (0 : ℤ) ≤ o25 ∧ InfIntMatrix.size o27 (HPow.hPow (2 : ℤ) (Int.toNat o25)) (HPow.hPow (2 : ℤ) (Int.toNat o25)) ∧ InfIntMatrix.size o26 (HPow.hPow (2 : ℤ) (Int.toNat o25)) (HPow.hPow (2 : ℤ) (Int.toNat o25))) ∧ (let o28 : InfIntMatrix.mat := InfIntMatrix.sub (InfIntMatrix.mul o27 o26) m5; let o29 : InfIntMatrix.mat := InfIntMatrix.add m4 o28; o29 = InfIntMatrix.f_add m4 o28 → (let s11 : InfIntMatrix.mat := InfIntMatrix.add m1 o29; s11 = InfIntMatrix.f_add m1 o29 → (let s12 : InfIntMatrix.mat := InfIntMatrix.add m3 m5; s12 = InfIntMatrix.f_add m3 m5 → (let s21 : InfIntMatrix.mat := InfIntMatrix.add m2 m4; s21 = InfIntMatrix.f_add m2 m4 → (let o30 : InfIntMatrix.mat := InfIntMatrix.sub (InfIntMatrix.mul o24 o23) m2; let o31 : InfIntMatrix.mat := InfIntMatrix.add m3 o30; o31 = InfIntMatrix.f_add m3 o30 → (let s22 : InfIntMatrix.mat := InfIntMatrix.add m1 o31; s22 = InfIntMatrix.f_add m1 o31 → (is_finite s11 ∧ is_finite s12 ∧ is_finite s21 ∧ is_finite s22) ∧ rows s11 = rows s12 ∧ rows s12 = rows s21 ∧ rows s21 = rows s22 ∧ rows s22 = cols s11 ∧ cols s11 = cols s12 ∧ cols s12 = cols s21 ∧ cols s21 = cols s22)))))))))))))))))))))))))))))))))) ∧ (∀(result1 : InfIntMatrix.mat), (if k ≤ cutoff then result1 = InfIntMatrix.mul a b ∧ result1 = InfIntMatrix.f_mul a b else let o1 : InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat := cut_quarters a; (match o1 with | (a11, a12, a21, a22) => quarters a a11 a12 a21 a22) ∧ (match o1 with | (a11, a12, a21, a22) => (let o2 : InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat × InfIntMatrix.mat := cut_quarters b; (match o2 with | (a111, a121, a211, a221) => quarters b a111 a121 a211 a221) ∧ (match o2 with | (b11, b12, b21, b22) => (let o3 : InfIntMatrix.mat := InfIntMatrix.mul a12 b21; o3 = InfIntMatrix.f_mul a12 b21 ∧ (let o4 : InfIntMatrix.mat := InfIntMatrix.mul a11 b11; o4 = InfIntMatrix.f_mul a11 b11 ∧ (let c11 : InfIntMatrix.mat := InfIntMatrix.add o4 o3; c11 = InfIntMatrix.f_add o4 o3 ∧ (let o5 : InfIntMatrix.mat := InfIntMatrix.mul a12 b22; o5 = InfIntMatrix.f_mul a12 b22 ∧ (let o6 : InfIntMatrix.mat := InfIntMatrix.mul a11 b12; o6 = InfIntMatrix.f_mul a11 b12 ∧ (let c12 : InfIntMatrix.mat := InfIntMatrix.add o6 o5; c12 = InfIntMatrix.f_add o6 o5 ∧ (let o7 : InfIntMatrix.mat := InfIntMatrix.mul a22 b21; o7 = InfIntMatrix.f_mul a22 b21 ∧ (let o8 : InfIntMatrix.mat := InfIntMatrix.mul a21 b11; o8 = InfIntMatrix.f_mul a21 b11 ∧ (let c21 : InfIntMatrix.mat := InfIntMatrix.add o8 o7; c21 = InfIntMatrix.f_add o8 o7 ∧ (let o9 : InfIntMatrix.mat := InfIntMatrix.mul a22 b22; o9 = InfIntMatrix.f_mul a22 b22 ∧ (let o10 : InfIntMatrix.mat := InfIntMatrix.mul a21 b12; o10 = InfIntMatrix.f_mul a21 b12 ∧ (let c22 : InfIntMatrix.mat := InfIntMatrix.add o10 o9; c22 = InfIntMatrix.f_add o10 o9 ∧ quarters (paste_quarters c11 c12 c21 c22) c11 c12 c21 c22 ∧ (let o11 : InfIntMatrix.mat := InfIntMatrix.add b11 b22; o11 = InfIntMatrix.f_add b11 b22 ∧ (let o12 : InfIntMatrix.mat := InfIntMatrix.add a11 a22; o12 = InfIntMatrix.f_add a11 a22 ∧ (let m1 : InfIntMatrix.mat := InfIntMatrix.mul o12 o11; let o13 : InfIntMatrix.mat := InfIntMatrix.add a21 a22; o13 = InfIntMatrix.f_add a21 a22 ∧ (let m2 : InfIntMatrix.mat := InfIntMatrix.mul o13 b11; let m3 : InfIntMatrix.mat := InfIntMatrix.mul a11 (InfIntMatrix.sub b12 b22); let m4 : InfIntMatrix.mat := InfIntMatrix.mul a22 (InfIntMatrix.sub b21 b11); let o14 : InfIntMatrix.mat := InfIntMatrix.add a11 a12; o14 = InfIntMatrix.f_add a11 a12 ∧ (let m5 : InfIntMatrix.mat := InfIntMatrix.mul o14 b22; let o15 : InfIntMatrix.mat := InfIntMatrix.add b11 b12; o15 = InfIntMatrix.f_add b11 b12 ∧ (let o16 : InfIntMatrix.mat := InfIntMatrix.add b21 b22; o16 = InfIntMatrix.f_add b21 b22 ∧ (let o17 : InfIntMatrix.mat := InfIntMatrix.sub (InfIntMatrix.mul (InfIntMatrix.sub a12 a22) o16) m5; let o18 : InfIntMatrix.mat := InfIntMatrix.add m4 o17; o18 = InfIntMatrix.f_add m4 o17 ∧ (let s11 : InfIntMatrix.mat := InfIntMatrix.add m1 o18; s11 = InfIntMatrix.f_add m1 o18 ∧ (let s12 : InfIntMatrix.mat := InfIntMatrix.add m3 m5; s12 = InfIntMatrix.f_add m3 m5 ∧ (let s21 : InfIntMatrix.mat := InfIntMatrix.add m2 m4; s21 = InfIntMatrix.f_add m2 m4 ∧ (let o19 : InfIntMatrix.mat := InfIntMatrix.sub (InfIntMatrix.mul (InfIntMatrix.sub a21 a11) o15) m2; let o20 : InfIntMatrix.mat := InfIntMatrix.add m3 o19; o20 = InfIntMatrix.f_add m3 o19 ∧ (let s22 : InfIntMatrix.mat := InfIntMatrix.add m1 o20; s22 = InfIntMatrix.f_add m1 o20 ∧ result1 = paste_quarters s11 s12 s21 s22 ∧ quarters result1 s11 s12 s21 s22)))))))))))))))))))))))))))) → result1 = InfIntMatrix.mul a b))
  := sorry
end strassen_MatrixTests_strassen_pow2qtvc
