theory ropes_MyString
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  char
consts dummy_char :: "char"
typedecl  char_string
consts length :: "char_string \<Rightarrow> int"
axiomatization where length'spec:   "(0 :: int) \<le> length x"
  for x :: "char_string"
consts mixfix_lbrb :: "char_string \<Rightarrow> int \<Rightarrow> char"
consts empty :: "char_string"
axiomatization where empty'def:   "length empty = (0 :: int)"
definition infix_eqeq :: "char_string \<Rightarrow> char_string \<Rightarrow> _"
  where "infix_eqeq s1 s2 \<longleftrightarrow> length s1 = length s2 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < length s1 \<longrightarrow> mixfix_lbrb s1 i = mixfix_lbrb s2 i)" for s1 s2
axiomatization where extensionality:   "s1 = s2"
 if "infix_eqeq s1 s2"
  for s1 :: "char_string"
  and s2 :: "char_string"
consts app :: "char_string \<Rightarrow> char_string \<Rightarrow> char_string"
axiomatization where app_def1:   "length (app s1 s2) = length s1 + length s2"
  for s1 :: "char_string"
  and s2 :: "char_string"
axiomatization where app_def2:   "mixfix_lbrb (app s1 s2) i = mixfix_lbrb s1 i"
 if "(0 :: int) \<le> i"
 and "i < length s1"
  for i :: "int"
  and s1 :: "char_string"
  and s2 :: "char_string"
axiomatization where app_def3:   "mixfix_lbrb (app s1 s2) i = mixfix_lbrb s2 (i - length s1)"
 if "length s1 \<le> i"
 and "i < length s1 + length s2"
  for s1 :: "char_string"
  and i :: "int"
  and s2 :: "char_string"
consts sub :: "char_string \<Rightarrow> int \<Rightarrow> int \<Rightarrow> char_string"
axiomatization where sub_def1:   "length (sub s ofs len) = len"
 if "(0 :: int) \<le> len"
 and "(0 :: int) \<le> ofs"
 and "ofs \<le> length s"
 and "ofs + len \<le> length s"
  for len :: "int"
  and ofs :: "int"
  and s :: "char_string"
axiomatization where sub_def2:   "mixfix_lbrb (sub s ofs len) i = mixfix_lbrb s (ofs + i)"
 if "(0 :: int) \<le> len"
 and "(0 :: int) \<le> ofs"
 and "ofs \<le> length s"
 and "ofs + len \<le> length s"
 and "(0 :: int) \<le> i"
 and "i < len"
  for len :: "int"
  and ofs :: "int"
  and s :: "char_string"
  and i :: "int"
end
