theory ropes_Rope_concatqtvc
  imports "NTP4Verif.NTP4Verif" "./ropes_MyString"
begin
datatype  rope = Emp | Str "char_string" "int" "int" | App "rope" "rope" "int"
definition length :: "rope \<Rightarrow> int"
  where "length r = (case r of Emp \<Rightarrow> (0 :: int) | Str _ _ len \<Rightarrow> len | App _ _ len \<Rightarrow> len)" for r
fun inv :: "rope \<Rightarrow> _"
  where "inv Emp = True"
      | "inv (Str s ofs len) = ((0 :: int) < len \<and> ((0 :: int) \<le> ofs \<and> ofs < ropes_MyString.length s) \<and> ofs + len \<le> ropes_MyString.length s)" for s ofs len
      | "inv (App l r1 len) = ((0 :: int) < length l \<and> inv l \<and> (0 :: int) < length r1 \<and> inv r1 \<and> len = length l + length r1)" for l r1 len
fun string :: "rope \<Rightarrow> char_string"
  where "string Emp = empty"
      | "string (Str s ofs len) = sub s ofs len" for s ofs len
      | "string (App l r1 x) = app (string l) (string r1)" for l r1 x
consts empty :: "rope"
axiomatization where empty'def'0:   "length empty = (0 :: int)"
axiomatization where empty'def'1:   "inv empty"
axiomatization where empty'def'2:   "infix_eqeq (string empty) ropes_MyString.empty"
theorem concat'vc:
  fixes r1 :: "rope"
  fixes r2 :: "rope"
  assumes fact0: "inv r1"
  assumes fact1: "inv r2"
  shows "case r2 of Emp \<Rightarrow> (case r1 of Emp \<Rightarrow> True | _ \<Rightarrow> True) | _ \<Rightarrow> (case r1 of Emp \<Rightarrow> True | _ \<Rightarrow> True)"
  and "\<forall>(result :: rope). (case r2 of Emp \<Rightarrow> (case r1 of Emp \<Rightarrow> result = r2 | _ \<Rightarrow> result = r1) | _ \<Rightarrow> (case r1 of Emp \<Rightarrow> result = r2 | _ \<Rightarrow> result = App r1 r2 (length r1 + length r2))) \<longrightarrow> inv result \<and> infix_eqeq (string result) (app (string r1) (string r2))"
  sorry
end
