import Why3.Base
import pearl.ropes_vcg.lean.ropes.MyString
open Classical
open Lean4Why3
namespace ropes_Rope_concatqtvc
inductive rope where
  | Emp : rope
  | Str : MyString.char_string -> ℤ -> ℤ -> rope
  | App : rope -> rope -> ℤ -> rope
axiom inhabited_axiom_rope : Inhabited rope
attribute [instance] inhabited_axiom_rope
noncomputable def length (r : rope) := match r with | rope.Emp => (0 : ℤ) | rope.Str _ _ len => len | rope.App _ _ len => len
noncomputable def inv : rope -> Prop
  | rope.Emp => True
  | (rope.Str s ofs len) => (0 : ℤ) < len ∧ ((0 : ℤ) ≤ ofs ∧ ofs < MyString.length s) ∧ ofs + len ≤ MyString.length s
  | (rope.App l r1 len) => (0 : ℤ) < length l ∧ inv l ∧ (0 : ℤ) < length r1 ∧ inv r1 ∧ len = length l + length r1
noncomputable def string : rope -> MyString.char_string
  | rope.Emp => MyString.empty
  | (rope.Str s ofs len) => MyString.sub s ofs len
  | (rope.App l r1 x) => MyString.app (string l) (string r1)
axiom empty : rope
axiom empty'def : length empty = (0 : ℤ) ∧ inv empty ∧ MyString.infix_eqeq (string empty) MyString.empty
theorem concat'vc (r1 : rope) (r2 : rope) (fact0 : inv r1) (fact1 : inv r2) : (match r2 with | rope.Emp => (match r1 with | rope.Emp => True | _ => True) | _ => (match r1 with | rope.Emp => True | _ => True)) ∧ (∀(result : rope), (match r2 with | rope.Emp => (match r1 with | rope.Emp => result = r2 | _ => result = r1) | _ => (match r1 with | rope.Emp => result = r2 | _ => result = rope.App r1 r2 (length r1 + length r2))) → inv result ∧ MyString.infix_eqeq (string result) (MyString.app (string r1) (string r2)))
  := sorry
end ropes_Rope_concatqtvc
