theory schorr_waite_SchorrWaite_schorr_waiteqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
typedecl  loc
consts null :: "loc"
typedecl  stacknodes
definition not_in_stack :: "loc \<Rightarrow> loc list \<Rightarrow> _"
  where "not_in_stack n s \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length s) \<longrightarrow> \<not>n = s ! nat i)" for n s
definition last :: "loc list \<Rightarrow> loc"
  where "last s = s ! nat (int (length s) - (1 :: int))" for s
definition distinct :: "loc list \<Rightarrow> _"
  where "distinct s \<longleftrightarrow> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < int (length s) \<longrightarrow> (0 :: int) \<le> j \<and> j < int (length s) \<longrightarrow> \<not>i = j \<longrightarrow> \<not>s ! nat i = s ! nat j)" for s
definition edge :: "loc \<Rightarrow> loc \<Rightarrow> (loc \<Rightarrow> loc) \<Rightarrow> (loc \<Rightarrow> loc) \<Rightarrow> _"
  where "edge x y left1 right1 \<longleftrightarrow> \<not>x = null \<and> (left1 x = y \<or> right1 x = y)" for x y left1 right1
inductive path :: "(loc \<Rightarrow> loc) \<Rightarrow> (loc \<Rightarrow> loc) \<Rightarrow> loc \<Rightarrow> loc \<Rightarrow> loc list \<Rightarrow> bool" where
   path_nil: "path l r x x (Nil :: loc list)" for l :: "loc \<Rightarrow> loc" and r :: "loc \<Rightarrow> loc" and x :: "loc"
 | path_cons: "edge x z l r \<Longrightarrow> path l r z y p \<Longrightarrow> path l r x y (Cons x p)" for x :: "loc" and z :: "loc" and l :: "loc \<Rightarrow> loc" and r :: "loc \<Rightarrow> loc" and y :: "loc" and p :: "loc list"
definition reachable :: "(loc \<Rightarrow> loc) \<Rightarrow> (loc \<Rightarrow> loc) \<Rightarrow> loc \<Rightarrow> loc \<Rightarrow> _"
  where "reachable left1 right1 x y \<longleftrightarrow> (\<exists>(p :: loc list). path left1 right1 x y p)" for left1 right1 x y
theorem schorr_waite'vc:
  fixes root :: "loc"
  fixes graph :: "loc fset"
  fixes left1 :: "loc \<Rightarrow> loc"
  fixes right1 :: "loc \<Rightarrow> loc"
  fixes m :: "loc \<Rightarrow> bool"
  fixes c :: "loc \<Rightarrow> bool"
  fixes path_from_root :: "loc \<Rightarrow> loc list"
  assumes fact0: "\<not>root = null"
  assumes fact1: "root |\<in>| graph"
  assumes fact2: "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<and> (left1 n = null \<or> left1 n |\<in>| graph) \<and> (right1 n = null \<or> right1 n |\<in>| graph)"
  assumes fact3: "\<forall>(x :: loc). x |\<in>| graph \<longrightarrow> \<not>m x = True"
  shows "\<not>root = null"
  and "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n [] \<or> (\<exists>(i :: int). [] ! nat i = n)"
  and "not_in_stack null []"
  and "int (length []) = (0 :: int)"
  and "\<not>int (length []) = (0 :: int) \<longrightarrow> [] ! (0 :: nat) = null"
  and "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>m n = True \<longrightarrow> n |\<in>| graph"
  and "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>c n = True \<longrightarrow> n |\<in>| graph"
  and "\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length []) \<longrightarrow> [] ! nat i |\<in>| graph"
  and "\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length []) - (1 :: int) \<longrightarrow> (let p1 :: loc = [] ! nat i; p2 :: loc = [] ! nat (i + (1 :: int)) in (c p2 = True \<longrightarrow> right1 p2 = p1) \<and> (\<not>c p2 = True \<longrightarrow> left1 p2 = p1))"
  and "(path_from_root(root := (Nil :: loc list))) root = (Nil :: loc list)"
  and "\<not>int (length []) = (0 :: int) \<longrightarrow> (let first :: loc = last [] in if c first = True then right1 first = null else left1 first = null)"
  and "\<not>int (length []) = (0 :: int) \<longrightarrow> last [] = root"
  and "\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length []) - (1 :: int) \<longrightarrow> (if c ([] ! nat k) = True then right1 ([] ! nat k) = [] ! nat (k + (1 :: int)) else left1 ([] ! nat k) = [] ! nat (k + (1 :: int)))"
  and "\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length []) \<longrightarrow> m ([] ! nat i) = True"
  and "distinct []"
  and "\<not>int (length []) = (0 :: int) \<longrightarrow> (if c null = True then right1 null = root else left1 null = root)"
  and "\<forall>(k :: int). (0 :: int) < k \<and> k < int (length []) \<longrightarrow> (let n :: loc = [] ! nat k in if c n = True then [] ! nat (k - (1 :: int)) = right1 n else [] ! nat (k - (1 :: int)) = left1 n)"
  and "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m n = True \<longrightarrow> reachable left1 right1 root n"
  and "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m n = True \<longrightarrow> path left1 right1 root n ((path_from_root(root := (Nil :: loc list))) n)"
  and "\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<longrightarrow> m n = True \<longrightarrow> not_in_stack n [] \<longrightarrow> (\<not>left1 n = null \<longrightarrow> m (left1 n) = True) \<and> (\<not>right1 n = null \<longrightarrow> m (right1 n) = True)"
  and "\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length []) \<longrightarrow> (let n :: loc = [] ! nat i in c n = True \<longrightarrow> (\<not>left1 n = null \<longrightarrow> m (left1 n) = True) \<and> (\<not>right1 n = null \<longrightarrow> m (right1 n) = True))"
  and "\<forall>(c_false_nodes :: loc fset) (unmarked_nodes :: loc fset) (pth :: loc list) (stackNodes :: loc list) (p :: loc) (t :: loc) (path_from_root1 :: loc \<Rightarrow> loc list) (right2 :: loc \<Rightarrow> loc) (left2 :: loc \<Rightarrow> loc) (c1 :: loc \<Rightarrow> bool) (m1 :: loc \<Rightarrow> bool). (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n stackNodes \<or> (\<exists>(i :: int). stackNodes ! nat i = n)) \<and> not_in_stack null stackNodes \<and> (int (length stackNodes) = (0 :: int) \<longleftrightarrow> p = null) \<and> (\<not>p = null \<longrightarrow> p |\<in>| graph) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> stackNodes ! (0 :: nat) = p) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>m1 n = True \<longrightarrow> n |\<in>| unmarked_nodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>c1 n = True \<longrightarrow> n |\<in>| c_false_nodes) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> stackNodes ! nat i |\<in>| graph) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) - (1 :: int) \<longrightarrow> (let p1 :: loc = stackNodes ! nat i; p2 :: loc = stackNodes ! nat (i + (1 :: int)) in (c1 p2 = True \<longrightarrow> left1 p2 = left2 p2 \<and> right1 p2 = p1) \<and> (\<not>c1 p2 = True \<longrightarrow> left1 p2 = p1 \<and> right1 p2 = right2 p2))) \<and> path_from_root1 root = (Nil :: loc list) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n stackNodes \<longrightarrow> left2 n = left1 n \<and> right2 n = right1 n) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> (let first :: loc = last stackNodes in if c1 first = True then right2 first = null else left2 first = null)) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> last stackNodes = root) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length stackNodes) - (1 :: int) \<longrightarrow> (if c1 (stackNodes ! nat k) = True then right2 (stackNodes ! nat k) = stackNodes ! nat (k + (1 :: int)) else left2 (stackNodes ! nat k) = stackNodes ! nat (k + (1 :: int)))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> m1 (stackNodes ! nat i) = True) \<and> distinct stackNodes \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> (let n :: loc = stackNodes ! nat i in if c1 n = True then left2 n = left1 n else right2 n = right1 n)) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> (if c1 p = True then right1 p = t else left1 p = t)) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < int (length stackNodes) \<longrightarrow> (let n :: loc = stackNodes ! nat k in if c1 n = True then stackNodes ! nat (k - (1 :: int)) = right1 n else stackNodes ! nat (k - (1 :: int)) = left1 n)) \<and> (\<not>p = null \<longrightarrow> path left1 right1 root p pth) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> reachable left1 right1 root n) \<and> (p = null \<longrightarrow> t = root) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> path left1 right1 root n (path_from_root1 n)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<longrightarrow> m1 n = True \<longrightarrow> not_in_stack n stackNodes \<longrightarrow> (\<not>left2 n = null \<longrightarrow> m1 (left2 n) = True) \<and> (\<not>right2 n = null \<longrightarrow> m1 (right2 n) = True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> (let n :: loc = stackNodes ! nat i in c1 n = True \<longrightarrow> (\<not>left2 n = null \<longrightarrow> m1 (left2 n) = True) \<and> (\<not>right2 n = null \<longrightarrow> m1 (right2 n) = True))) \<longrightarrow> (\<forall>(o1 :: bool). (if \<not>p = null then o1 = True else if \<not>t = null then o1 = (if m1 t = True then False else True) else o1 = False) \<longrightarrow> (if o1 = True then \<forall>(o2 :: bool). (if t = null then o2 = True else o2 = m1 t) \<longrightarrow> (if o2 = True then \<not>p = null \<and> (if c1 p = True then (0 :: int) < int (length stackNodes) \<and> (let o3 :: loc list = drop (1 :: nat) stackNodes in (\<forall>(n :: loc). not_in_stack n stackNodes \<longrightarrow> not_in_stack n o3) \<longrightarrow> \<not>p = null \<and> \<not>p = null \<and> ((0 :: int) \<le> int (fcard unmarked_nodes) \<and> fcard unmarked_nodes < fcard unmarked_nodes \<or> (0 :: int) \<le> int (fcard c_false_nodes) \<and> fcard c_false_nodes < fcard c_false_nodes \<or> (0 :: int) \<le> int (length stackNodes) \<and> length o3 < length stackNodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n o3 \<or> (\<exists>(i :: int). o3 ! nat i = n)) \<and> not_in_stack null o3 \<and> (int (length o3) = (0 :: int) \<longleftrightarrow> right2 p = null) \<and> (\<not>right2 p = null \<longrightarrow> right2 p |\<in>| graph) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> o3 ! (0 :: nat) = right2 p) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>m1 n = True \<longrightarrow> n |\<in>| unmarked_nodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>c1 n = True \<longrightarrow> n |\<in>| c_false_nodes) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> o3 ! nat i |\<in>| graph) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) - (1 :: int) \<longrightarrow> (let p1 :: loc = o3 ! nat i; p2 :: loc = o3 ! nat (i + (1 :: int)) in (c1 p2 = True \<longrightarrow> left1 p2 = left2 p2 \<and> right1 p2 = p1) \<and> (\<not>c1 p2 = True \<longrightarrow> left1 p2 = p1 \<and> right1 p2 = (right2(p := t)) p2))) \<and> path_from_root1 root = (Nil :: loc list) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n o3 \<longrightarrow> left2 n = left1 n \<and> (right2(p := t)) n = right1 n) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> (let first :: loc = last o3 in if c1 first = True then (right2(p := t)) first = null else left2 first = null)) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> last o3 = root) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length o3) - (1 :: int) \<longrightarrow> (if c1 (o3 ! nat k) = True then (right2(p := t)) (o3 ! nat k) = o3 ! nat (k + (1 :: int)) else left2 (o3 ! nat k) = o3 ! nat (k + (1 :: int)))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> m1 (o3 ! nat i) = True) \<and> distinct o3 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat i in if c1 n = True then left2 n = left1 n else (right2(p := t)) n = right1 n)) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> (if c1 (right2 p) = True then right1 (right2 p) = p else left1 (right2 p) = p)) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat k in if c1 n = True then o3 ! nat (k - (1 :: int)) = right1 n else o3 ! nat (k - (1 :: int)) = left1 n)) \<and> (\<not>right2 p = null \<longrightarrow> path left1 right1 root (right2 p) (path_from_root1 (right2 p))) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> reachable left1 right1 root n) \<and> (right2 p = null \<longrightarrow> p = root) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> path left1 right1 root n (path_from_root1 n)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<longrightarrow> m1 n = True \<longrightarrow> not_in_stack n o3 \<longrightarrow> (\<not>left2 n = null \<longrightarrow> m1 (left2 n) = True) \<and> (\<not>(right2(p := t)) n = null \<longrightarrow> m1 ((right2(p := t)) n) = True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat i in c1 n = True \<longrightarrow> (\<not>left2 n = null \<longrightarrow> m1 (left2 n) = True) \<and> (\<not>(right2(p := t)) n = null \<longrightarrow> m1 ((right2(p := t)) n) = True)))) else \<not>p = null \<and> \<not>p = null \<and> \<not>p = null \<and> \<not>p = null \<and> \<not>p = null \<and> ((0 :: int) \<le> int (fcard unmarked_nodes) \<and> fcard unmarked_nodes < fcard unmarked_nodes \<or> (0 :: int) \<le> int (fcard c_false_nodes) \<and> fcard (fset_remove p c_false_nodes) < fcard c_false_nodes \<or> fcard c_false_nodes = fcard (fset_remove p c_false_nodes) \<and> (0 :: int) \<le> int (length stackNodes) \<and> length stackNodes < length stackNodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n stackNodes \<or> (\<exists>(i :: int). stackNodes ! nat i = n)) \<and> not_in_stack null stackNodes \<and> (int (length stackNodes) = (0 :: int) \<longleftrightarrow> p = null) \<and> (\<not>p = null \<longrightarrow> p |\<in>| graph) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> stackNodes ! (0 :: nat) = p) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>m1 n = True \<longrightarrow> n |\<in>| unmarked_nodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>(c1(p := True)) n = True \<longrightarrow> n |\<in>| fset_remove p c_false_nodes) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> stackNodes ! nat i |\<in>| graph) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) - (1 :: int) \<longrightarrow> (let p1 :: loc = stackNodes ! nat i; p2 :: loc = stackNodes ! nat (i + (1 :: int)) in ((c1(p := True)) p2 = True \<longrightarrow> left1 p2 = (left2(p := t)) p2 \<and> right1 p2 = p1) \<and> (\<not>(c1(p := True)) p2 = True \<longrightarrow> left1 p2 = p1 \<and> right1 p2 = (right2(p := left2 p)) p2))) \<and> path_from_root1 root = (Nil :: loc list) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n stackNodes \<longrightarrow> (left2(p := t)) n = left1 n \<and> (right2(p := left2 p)) n = right1 n) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> (let first :: loc = last stackNodes in if (c1(p := True)) first = True then (right2(p := left2 p)) first = null else (left2(p := t)) first = null)) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> last stackNodes = root) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length stackNodes) - (1 :: int) \<longrightarrow> (if (c1(p := True)) (stackNodes ! nat k) = True then (right2(p := left2 p)) (stackNodes ! nat k) = stackNodes ! nat (k + (1 :: int)) else (left2(p := t)) (stackNodes ! nat k) = stackNodes ! nat (k + (1 :: int)))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> m1 (stackNodes ! nat i) = True) \<and> distinct stackNodes \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> (let n :: loc = stackNodes ! nat i in if (c1(p := True)) n = True then (left2(p := t)) n = left1 n else (right2(p := left2 p)) n = right1 n)) \<and> (\<not>int (length stackNodes) = (0 :: int) \<longrightarrow> (if (c1(p := True)) p = True then right1 p = right2 p else left1 p = right2 p)) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < int (length stackNodes) \<longrightarrow> (let n :: loc = stackNodes ! nat k in if (c1(p := True)) n = True then stackNodes ! nat (k - (1 :: int)) = right1 n else stackNodes ! nat (k - (1 :: int)) = left1 n)) \<and> (\<not>p = null \<longrightarrow> path left1 right1 root p pth) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> reachable left1 right1 root n) \<and> (p = null \<longrightarrow> right2 p = root) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> path left1 right1 root n (path_from_root1 n)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<longrightarrow> m1 n = True \<longrightarrow> not_in_stack n stackNodes \<longrightarrow> (\<not>(left2(p := t)) n = null \<longrightarrow> m1 ((left2(p := t)) n) = True) \<and> (\<not>(right2(p := left2 p)) n = null \<longrightarrow> m1 ((right2(p := left2 p)) n) = True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length stackNodes) \<longrightarrow> (let n :: loc = stackNodes ! nat i in (c1(p := True)) n = True \<longrightarrow> (\<not>(left2(p := t)) n = null \<longrightarrow> m1 ((left2(p := t)) n) = True) \<and> (\<not>(right2(p := left2 p)) n = null \<longrightarrow> m1 ((right2(p := left2 p)) n) = True)))) else let o3 :: loc list = Cons t stackNodes in int (length o3) = (1 :: int) + int (length stackNodes) \<and> o3 ! (0 :: nat) = t \<and> (\<forall>(i :: int). (0 :: int) < i \<and> i \<le> int (length stackNodes) \<longrightarrow> o3 ! nat i = stackNodes ! nat (i - (1 :: int))) \<longrightarrow> \<not>t = null \<and> \<not>t = null \<and> \<not>t = null \<and> (if \<not>t = root then \<not>t = null \<and> \<not>t = null \<and> ((0 :: int) \<le> int (fcard unmarked_nodes) \<and> fcard (fset_remove t unmarked_nodes) < fcard unmarked_nodes \<or> fcard unmarked_nodes = fcard (fset_remove t unmarked_nodes) \<and> ((0 :: int) \<le> int (fcard c_false_nodes) \<and> fcard (finsert t c_false_nodes) < fcard c_false_nodes \<or> fcard c_false_nodes = fcard (finsert t c_false_nodes) \<and> (0 :: int) \<le> int (length stackNodes) \<and> length o3 < length stackNodes)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n o3 \<or> (\<exists>(i :: int). o3 ! nat i = n)) \<and> not_in_stack null o3 \<and> (int (length o3) = (0 :: int) \<longleftrightarrow> t = null) \<and> (\<not>t = null \<longrightarrow> t |\<in>| graph) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> o3 ! (0 :: nat) = t) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>(m1(t := True)) n = True \<longrightarrow> n |\<in>| fset_remove t unmarked_nodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>(c1(t := False)) n = True \<longrightarrow> n |\<in>| finsert t c_false_nodes) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> o3 ! nat i |\<in>| graph) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) - (1 :: int) \<longrightarrow> (let p1 :: loc = o3 ! nat i; p2 :: loc = o3 ! nat (i + (1 :: int)) in ((c1(t := False)) p2 = True \<longrightarrow> left1 p2 = (left2(t := p)) p2 \<and> right1 p2 = p1) \<and> (\<not>(c1(t := False)) p2 = True \<longrightarrow> left1 p2 = p1 \<and> right1 p2 = right2 p2))) \<and> (path_from_root1(t := pth @ Cons p (Nil :: loc list))) root = (Nil :: loc list) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n o3 \<longrightarrow> (left2(t := p)) n = left1 n \<and> right2 n = right1 n) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> (let first :: loc = last o3 in if (c1(t := False)) first = True then right2 first = null else (left2(t := p)) first = null)) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> last o3 = root) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length o3) - (1 :: int) \<longrightarrow> (if (c1(t := False)) (o3 ! nat k) = True then right2 (o3 ! nat k) = o3 ! nat (k + (1 :: int)) else (left2(t := p)) (o3 ! nat k) = o3 ! nat (k + (1 :: int)))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (m1(t := True)) (o3 ! nat i) = True) \<and> distinct o3 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat i in if (c1(t := False)) n = True then (left2(t := p)) n = left1 n else right2 n = right1 n)) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> (if (c1(t := False)) t = True then right1 t = left2 t else left1 t = left2 t)) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat k in if (c1(t := False)) n = True then o3 ! nat (k - (1 :: int)) = right1 n else o3 ! nat (k - (1 :: int)) = left1 n)) \<and> (\<not>t = null \<longrightarrow> path left1 right1 root t (pth @ Cons p (Nil :: loc list))) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> (m1(t := True)) n = True \<longrightarrow> reachable left1 right1 root n) \<and> (t = null \<longrightarrow> left2 t = root) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> (m1(t := True)) n = True \<longrightarrow> path left1 right1 root n ((path_from_root1(t := pth @ Cons p (Nil :: loc list))) n)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<longrightarrow> (m1(t := True)) n = True \<longrightarrow> not_in_stack n o3 \<longrightarrow> (\<not>(left2(t := p)) n = null \<longrightarrow> (m1(t := True)) ((left2(t := p)) n) = True) \<and> (\<not>right2 n = null \<longrightarrow> (m1(t := True)) (right2 n) = True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat i in (c1(t := False)) n = True \<longrightarrow> (\<not>(left2(t := p)) n = null \<longrightarrow> (m1(t := True)) ((left2(t := p)) n) = True) \<and> (\<not>right2 n = null \<longrightarrow> (m1(t := True)) (right2 n) = True))) else \<not>t = null \<and> \<not>t = null \<and> ((0 :: int) \<le> int (fcard unmarked_nodes) \<and> fcard (fset_remove t unmarked_nodes) < fcard unmarked_nodes \<or> fcard unmarked_nodes = fcard (fset_remove t unmarked_nodes) \<and> ((0 :: int) \<le> int (fcard c_false_nodes) \<and> fcard (finsert t c_false_nodes) < fcard c_false_nodes \<or> fcard c_false_nodes = fcard (finsert t c_false_nodes) \<and> (0 :: int) \<le> int (length stackNodes) \<and> length o3 < length stackNodes)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n o3 \<or> (\<exists>(i :: int). o3 ! nat i = n)) \<and> not_in_stack null o3 \<and> (int (length o3) = (0 :: int) \<longleftrightarrow> t = null) \<and> (\<not>t = null \<longrightarrow> t |\<in>| graph) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> o3 ! (0 :: nat) = t) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>(m1(t := True)) n = True \<longrightarrow> n |\<in>| fset_remove t unmarked_nodes) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>(c1(t := False)) n = True \<longrightarrow> n |\<in>| finsert t c_false_nodes) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> o3 ! nat i |\<in>| graph) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) - (1 :: int) \<longrightarrow> (let p1 :: loc = o3 ! nat i; p2 :: loc = o3 ! nat (i + (1 :: int)) in ((c1(t := False)) p2 = True \<longrightarrow> left1 p2 = (left2(t := p)) p2 \<and> right1 p2 = p1) \<and> (\<not>(c1(t := False)) p2 = True \<longrightarrow> left1 p2 = p1 \<and> right1 p2 = right2 p2))) \<and> (path_from_root1(t := (Nil :: loc list))) root = (Nil :: loc list) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> not_in_stack n o3 \<longrightarrow> (left2(t := p)) n = left1 n \<and> right2 n = right1 n) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> (let first :: loc = last o3 in if (c1(t := False)) first = True then right2 first = null else (left2(t := p)) first = null)) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> last o3 = root) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length o3) - (1 :: int) \<longrightarrow> (if (c1(t := False)) (o3 ! nat k) = True then right2 (o3 ! nat k) = o3 ! nat (k + (1 :: int)) else (left2(t := p)) (o3 ! nat k) = o3 ! nat (k + (1 :: int)))) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (m1(t := True)) (o3 ! nat i) = True) \<and> distinct o3 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat i in if (c1(t := False)) n = True then (left2(t := p)) n = left1 n else right2 n = right1 n)) \<and> (\<not>int (length o3) = (0 :: int) \<longrightarrow> (if (c1(t := False)) t = True then right1 t = left2 t else left1 t = left2 t)) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat k in if (c1(t := False)) n = True then o3 ! nat (k - (1 :: int)) = right1 n else o3 ! nat (k - (1 :: int)) = left1 n)) \<and> (\<not>t = null \<longrightarrow> path left1 right1 root t (Nil :: loc list)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> (m1(t := True)) n = True \<longrightarrow> reachable left1 right1 root n) \<and> (t = null \<longrightarrow> left2 t = root) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> (m1(t := True)) n = True \<longrightarrow> path left1 right1 root n ((path_from_root1(t := (Nil :: loc list))) n)) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> \<not>n = null \<longrightarrow> (m1(t := True)) n = True \<longrightarrow> not_in_stack n o3 \<longrightarrow> (\<not>(left2(t := p)) n = null \<longrightarrow> (m1(t := True)) ((left2(t := p)) n) = True) \<and> (\<not>right2 n = null \<longrightarrow> (m1(t := True)) (right2 n) = True)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length o3) \<longrightarrow> (let n :: loc = o3 ! nat i in (c1(t := False)) n = True \<longrightarrow> (\<not>(left2(t := p)) n = null \<longrightarrow> (m1(t := True)) ((left2(t := p)) n) = True) \<and> (\<not>right2 n = null \<longrightarrow> (m1(t := True)) (right2 n) = True))))) else (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> left1 n = left2 n \<and> right1 n = right2 n) \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> reachable left1 right1 root n) \<and> m1 root = True \<and> (\<forall>(n :: loc). n |\<in>| graph \<longrightarrow> m1 n = True \<longrightarrow> (\<forall>(ch :: loc). edge n ch left2 right2 \<longrightarrow> \<not>ch = null \<longrightarrow> m1 ch = True))))"
  sorry
end
