From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Open Scope Z_scope.
Axiom loc : Type.
Axiom loc_inhabited : Inhabited loc.
Global Existing Instance loc_inhabited.
Axiom loc_countable : Countable loc.
Global Existing Instance loc_countable.
Axiom null : loc.
Axiom stacknodes : Type.
Axiom stacknodes_inhabited : Inhabited stacknodes.
Global Existing Instance stacknodes_inhabited.
Axiom stacknodes_countable : Countable stacknodes.
Global Existing Instance stacknodes_countable.
Definition not_in_stack (n : loc) (s : list loc) := ∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length s) -> ¬ n = nth (Z.to_nat i) s inhabitant.
Definition last (s : list loc) : loc := nth (Z.to_nat (Z.of_nat (length s) - 1%Z)) s inhabitant.
Definition distinct (s : list loc) := ∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < Z.of_nat (length s) -> 0%Z ≤ j ∧ j < Z.of_nat (length s) -> ¬ i = j -> ¬ nth (Z.to_nat i) s inhabitant = nth (Z.to_nat j) s inhabitant.
Definition edge (x : loc) (y : loc) (left1 : loc -> loc) (right1 : loc -> loc) := ¬ x = null ∧ (left1 x = y ∨ right1 x = y).
Inductive path : (loc -> loc) -> (loc -> loc) -> loc -> loc -> list loc -> Prop :=
 | path_nil (l : loc -> loc) (r : loc -> loc) (x : loc) : path l r x x ([] : list loc)
 | path_cons (x : loc) (z : loc) (l : loc -> loc) (r : loc -> loc) (y : loc) (p : list loc) : edge x z l r -> path l r z y p -> path l r x y (cons x p).
Definition reachable (left1 : loc -> loc) (right1 : loc -> loc) (x : loc) (y : loc) := ∃(p : list loc), path left1 right1 x y p.
Theorem schorr_waite'vc (root : loc) (graph : gset loc) (left1 : loc -> loc) (right1 : loc -> loc) (m : loc -> bool) (c : loc -> bool) (path_from_root : loc -> list loc) (fact0 : ¬ root = null) (fact1 : root ∈ graph) (fact2 : ∀(n : loc), n ∈ graph -> ¬ n = null ∧ (left1 n = null ∨ left1 n ∈ graph) ∧ (right1 n = null ∨ right1 n ∈ graph)) (fact3 : ∀(x : loc), x ∈ graph -> ¬ m x = true) : ¬ root = null ∧ (∀(n : loc), n ∈ graph -> not_in_stack n ([] : list loc) ∨ (∃(i : Z), nth (Z.to_nat i) ([] : list loc) inhabitant = n)) ∧ not_in_stack null ([] : list loc) ∧ Z.of_nat (length ([] : list loc)) = 0%Z ∧ (¬ Z.of_nat (length ([] : list loc)) = 0%Z -> nth 0%nat ([] : list loc) inhabitant = null) ∧ (∀(n : loc), n ∈ graph -> ¬ m n = true -> n ∈ graph) ∧ (∀(n : loc), n ∈ graph -> ¬ c n = true -> n ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length ([] : list loc)) -> nth (Z.to_nat i) ([] : list loc) inhabitant ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length ([] : list loc)) - 1%Z -> (let p1 : loc := nth (Z.to_nat i) ([] : list loc) inhabitant in let p2 : loc := nth (Z.to_nat (i + 1%Z)) ([] : list loc) inhabitant in (c p2 = true -> right1 p2 = p1) ∧ (¬ c p2 = true -> left1 p2 = p1))) ∧ fun_updt path_from_root root ([] : list loc) root = ([] : list loc) ∧ (¬ Z.of_nat (length ([] : list loc)) = 0%Z -> (let first : loc := last ([] : list loc) in if decide (c first = true) then right1 first = null else left1 first = null)) ∧ (¬ Z.of_nat (length ([] : list loc)) = 0%Z -> last ([] : list loc) = root) ∧ (∀(k : Z), 0%Z ≤ k ∧ k < Z.of_nat (length ([] : list loc)) - 1%Z -> (if decide (c (nth (Z.to_nat k) ([] : list loc) inhabitant) = true) then right1 (nth (Z.to_nat k) ([] : list loc) inhabitant) = nth (Z.to_nat (k + 1%Z)) ([] : list loc) inhabitant else left1 (nth (Z.to_nat k) ([] : list loc) inhabitant) = nth (Z.to_nat (k + 1%Z)) ([] : list loc) inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length ([] : list loc)) -> m (nth (Z.to_nat i) ([] : list loc) inhabitant) = true) ∧ distinct ([] : list loc) ∧ (¬ Z.of_nat (length ([] : list loc)) = 0%Z -> (if decide (c null = true) then right1 null = root else left1 null = root)) ∧ (∀(k : Z), 0%Z < k ∧ k < Z.of_nat (length ([] : list loc)) -> (let n : loc := nth (Z.to_nat k) ([] : list loc) inhabitant in if decide (c n = true) then nth (Z.to_nat (k - 1%Z)) ([] : list loc) inhabitant = right1 n else nth (Z.to_nat (k - 1%Z)) ([] : list loc) inhabitant = left1 n)) ∧ (∀(n : loc), n ∈ graph -> m n = true -> reachable left1 right1 root n) ∧ (∀(n : loc), n ∈ graph -> m n = true -> path left1 right1 root n (fun_updt path_from_root root ([] : list loc) n)) ∧ (∀(n : loc), n ∈ graph -> ¬ n = null -> m n = true -> not_in_stack n ([] : list loc) -> (¬ left1 n = null -> m (left1 n) = true) ∧ (¬ right1 n = null -> m (right1 n) = true)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length ([] : list loc)) -> (let n : loc := nth (Z.to_nat i) ([] : list loc) inhabitant in c n = true -> (¬ left1 n = null -> m (left1 n) = true) ∧ (¬ right1 n = null -> m (right1 n) = true))) ∧ (∀(c_false_nodes : gset loc) (unmarked_nodes : gset loc) (pth : list loc) (stackNodes : list loc) (p : loc) (t : loc) (path_from_root1 : loc -> list loc) (right2 : loc -> loc) (left2 : loc -> loc) (c1 : loc -> bool) (m1 : loc -> bool), (∀(n : loc), n ∈ graph -> not_in_stack n stackNodes ∨ (∃(i : Z), nth (Z.to_nat i) stackNodes inhabitant = n)) ∧ not_in_stack null stackNodes ∧ (Z.of_nat (length stackNodes) = 0%Z) = (p = null) ∧ (¬ p = null -> p ∈ graph) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> nth 0%nat stackNodes inhabitant = p) ∧ (∀(n : loc), n ∈ graph -> ¬ m1 n = true -> n ∈ unmarked_nodes) ∧ (∀(n : loc), n ∈ graph -> ¬ c1 n = true -> n ∈ c_false_nodes) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> nth (Z.to_nat i) stackNodes inhabitant ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) - 1%Z -> (let p1 : loc := nth (Z.to_nat i) stackNodes inhabitant in let p2 : loc := nth (Z.to_nat (i + 1%Z)) stackNodes inhabitant in (c1 p2 = true -> left1 p2 = left2 p2 ∧ right1 p2 = p1) ∧ (¬ c1 p2 = true -> left1 p2 = p1 ∧ right1 p2 = right2 p2))) ∧ path_from_root1 root = ([] : list loc) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n stackNodes -> left2 n = left1 n ∧ right2 n = right1 n) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> (let first : loc := last stackNodes in if decide (c1 first = true) then right2 first = null else left2 first = null)) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> last stackNodes = root) ∧ (∀(k : Z), 0%Z ≤ k ∧ k < Z.of_nat (length stackNodes) - 1%Z -> (if decide (c1 (nth (Z.to_nat k) stackNodes inhabitant) = true) then right2 (nth (Z.to_nat k) stackNodes inhabitant) = nth (Z.to_nat (k + 1%Z)) stackNodes inhabitant else left2 (nth (Z.to_nat k) stackNodes inhabitant) = nth (Z.to_nat (k + 1%Z)) stackNodes inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> m1 (nth (Z.to_nat i) stackNodes inhabitant) = true) ∧ distinct stackNodes ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> (let n : loc := nth (Z.to_nat i) stackNodes inhabitant in if decide (c1 n = true) then left2 n = left1 n else right2 n = right1 n)) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> (if decide (c1 p = true) then right1 p = t else left1 p = t)) ∧ (∀(k : Z), 0%Z < k ∧ k < Z.of_nat (length stackNodes) -> (let n : loc := nth (Z.to_nat k) stackNodes inhabitant in if decide (c1 n = true) then nth (Z.to_nat (k - 1%Z)) stackNodes inhabitant = right1 n else nth (Z.to_nat (k - 1%Z)) stackNodes inhabitant = left1 n)) ∧ (¬ p = null -> path left1 right1 root p pth) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> reachable left1 right1 root n) ∧ (p = null -> t = root) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> path left1 right1 root n (path_from_root1 n)) ∧ (∀(n : loc), n ∈ graph -> ¬ n = null -> m1 n = true -> not_in_stack n stackNodes -> (¬ left2 n = null -> m1 (left2 n) = true) ∧ (¬ right2 n = null -> m1 (right2 n) = true)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> (let n : loc := nth (Z.to_nat i) stackNodes inhabitant in c1 n = true -> (¬ left2 n = null -> m1 (left2 n) = true) ∧ (¬ right2 n = null -> m1 (right2 n) = true))) -> (∀(o1 : bool), (if decide (¬ p = null) then o1 = true else if decide (¬ t = null) then o1 = (if decide (m1 t = true) then false else true) else o1 = false) -> (if decide (o1 = true) then ∀(o2 : bool), (if decide (t = null) then o2 = true else o2 = m1 t) -> (if decide (o2 = true) then ¬ p = null ∧ (if decide (c1 p = true) then 0%Z < Z.of_nat (length stackNodes) ∧ (let o3 : list loc := drop 1%nat stackNodes in (∀(n : loc), not_in_stack n stackNodes -> not_in_stack n o3) -> ¬ p = null ∧ ¬ p = null ∧ (0%Z ≤ Z.of_nat (size unmarked_nodes) ∧ Z.of_nat (size unmarked_nodes) < Z.of_nat (size unmarked_nodes) ∨ 0%Z ≤ Z.of_nat (size c_false_nodes) ∧ Z.of_nat (size c_false_nodes) < Z.of_nat (size c_false_nodes) ∨ 0%Z ≤ Z.of_nat (length stackNodes) ∧ Z.of_nat (length o3) < Z.of_nat (length stackNodes)) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n o3 ∨ (∃(i : Z), nth (Z.to_nat i) o3 inhabitant = n)) ∧ not_in_stack null o3 ∧ (Z.of_nat (length o3) = 0%Z) = (right2 p = null) ∧ (¬ right2 p = null -> right2 p ∈ graph) ∧ (¬ Z.of_nat (length o3) = 0%Z -> nth 0%nat o3 inhabitant = right2 p) ∧ (∀(n : loc), n ∈ graph -> ¬ m1 n = true -> n ∈ unmarked_nodes) ∧ (∀(n : loc), n ∈ graph -> ¬ c1 n = true -> n ∈ c_false_nodes) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> nth (Z.to_nat i) o3 inhabitant ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) - 1%Z -> (let p1 : loc := nth (Z.to_nat i) o3 inhabitant in let p2 : loc := nth (Z.to_nat (i + 1%Z)) o3 inhabitant in (c1 p2 = true -> left1 p2 = left2 p2 ∧ right1 p2 = p1) ∧ (¬ c1 p2 = true -> left1 p2 = p1 ∧ right1 p2 = fun_updt right2 p t p2))) ∧ path_from_root1 root = ([] : list loc) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n o3 -> left2 n = left1 n ∧ fun_updt right2 p t n = right1 n) ∧ (¬ Z.of_nat (length o3) = 0%Z -> (let first : loc := last o3 in if decide (c1 first = true) then fun_updt right2 p t first = null else left2 first = null)) ∧ (¬ Z.of_nat (length o3) = 0%Z -> last o3 = root) ∧ (∀(k : Z), 0%Z ≤ k ∧ k < Z.of_nat (length o3) - 1%Z -> (if decide (c1 (nth (Z.to_nat k) o3 inhabitant) = true) then fun_updt right2 p t (nth (Z.to_nat k) o3 inhabitant) = nth (Z.to_nat (k + 1%Z)) o3 inhabitant else left2 (nth (Z.to_nat k) o3 inhabitant) = nth (Z.to_nat (k + 1%Z)) o3 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> m1 (nth (Z.to_nat i) o3 inhabitant) = true) ∧ distinct o3 ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat i) o3 inhabitant in if decide (c1 n = true) then left2 n = left1 n else fun_updt right2 p t n = right1 n)) ∧ (¬ Z.of_nat (length o3) = 0%Z -> (if decide (c1 (right2 p) = true) then right1 (right2 p) = p else left1 (right2 p) = p)) ∧ (∀(k : Z), 0%Z < k ∧ k < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat k) o3 inhabitant in if decide (c1 n = true) then nth (Z.to_nat (k - 1%Z)) o3 inhabitant = right1 n else nth (Z.to_nat (k - 1%Z)) o3 inhabitant = left1 n)) ∧ (¬ right2 p = null -> path left1 right1 root (right2 p) (path_from_root1 (right2 p))) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> reachable left1 right1 root n) ∧ (right2 p = null -> p = root) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> path left1 right1 root n (path_from_root1 n)) ∧ (∀(n : loc), n ∈ graph -> ¬ n = null -> m1 n = true -> not_in_stack n o3 -> (¬ left2 n = null -> m1 (left2 n) = true) ∧ (¬ fun_updt right2 p t n = null -> m1 (fun_updt right2 p t n) = true)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat i) o3 inhabitant in c1 n = true -> (¬ left2 n = null -> m1 (left2 n) = true) ∧ (¬ fun_updt right2 p t n = null -> m1 (fun_updt right2 p t n) = true)))) else ¬ p = null ∧ ¬ p = null ∧ ¬ p = null ∧ ¬ p = null ∧ ¬ p = null ∧ (0%Z ≤ Z.of_nat (size unmarked_nodes) ∧ Z.of_nat (size unmarked_nodes) < Z.of_nat (size unmarked_nodes) ∨ 0%Z ≤ Z.of_nat (size c_false_nodes) ∧ Z.of_nat (size (remove_set p c_false_nodes)) < Z.of_nat (size c_false_nodes) ∨ size c_false_nodes = size (remove_set p c_false_nodes) ∧ 0%Z ≤ Z.of_nat (length stackNodes) ∧ Z.of_nat (length stackNodes) < Z.of_nat (length stackNodes)) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n stackNodes ∨ (∃(i : Z), nth (Z.to_nat i) stackNodes inhabitant = n)) ∧ not_in_stack null stackNodes ∧ (Z.of_nat (length stackNodes) = 0%Z) = (p = null) ∧ (¬ p = null -> p ∈ graph) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> nth 0%nat stackNodes inhabitant = p) ∧ (∀(n : loc), n ∈ graph -> ¬ m1 n = true -> n ∈ unmarked_nodes) ∧ (∀(n : loc), n ∈ graph -> ¬ fun_updt c1 p true n = true -> n ∈ remove_set p c_false_nodes) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> nth (Z.to_nat i) stackNodes inhabitant ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) - 1%Z -> (let p1 : loc := nth (Z.to_nat i) stackNodes inhabitant in let p2 : loc := nth (Z.to_nat (i + 1%Z)) stackNodes inhabitant in (fun_updt c1 p true p2 = true -> left1 p2 = fun_updt left2 p t p2 ∧ right1 p2 = p1) ∧ (¬ fun_updt c1 p true p2 = true -> left1 p2 = p1 ∧ right1 p2 = fun_updt right2 p (left2 p) p2))) ∧ path_from_root1 root = ([] : list loc) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n stackNodes -> fun_updt left2 p t n = left1 n ∧ fun_updt right2 p (left2 p) n = right1 n) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> (let first : loc := last stackNodes in if decide (fun_updt c1 p true first = true) then fun_updt right2 p (left2 p) first = null else fun_updt left2 p t first = null)) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> last stackNodes = root) ∧ (∀(k : Z), 0%Z ≤ k ∧ k < Z.of_nat (length stackNodes) - 1%Z -> (if decide (fun_updt c1 p true (nth (Z.to_nat k) stackNodes inhabitant) = true) then fun_updt right2 p (left2 p) (nth (Z.to_nat k) stackNodes inhabitant) = nth (Z.to_nat (k + 1%Z)) stackNodes inhabitant else fun_updt left2 p t (nth (Z.to_nat k) stackNodes inhabitant) = nth (Z.to_nat (k + 1%Z)) stackNodes inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> m1 (nth (Z.to_nat i) stackNodes inhabitant) = true) ∧ distinct stackNodes ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> (let n : loc := nth (Z.to_nat i) stackNodes inhabitant in if decide (fun_updt c1 p true n = true) then fun_updt left2 p t n = left1 n else fun_updt right2 p (left2 p) n = right1 n)) ∧ (¬ Z.of_nat (length stackNodes) = 0%Z -> (if decide (fun_updt c1 p true p = true) then right1 p = right2 p else left1 p = right2 p)) ∧ (∀(k : Z), 0%Z < k ∧ k < Z.of_nat (length stackNodes) -> (let n : loc := nth (Z.to_nat k) stackNodes inhabitant in if decide (fun_updt c1 p true n = true) then nth (Z.to_nat (k - 1%Z)) stackNodes inhabitant = right1 n else nth (Z.to_nat (k - 1%Z)) stackNodes inhabitant = left1 n)) ∧ (¬ p = null -> path left1 right1 root p pth) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> reachable left1 right1 root n) ∧ (p = null -> right2 p = root) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> path left1 right1 root n (path_from_root1 n)) ∧ (∀(n : loc), n ∈ graph -> ¬ n = null -> m1 n = true -> not_in_stack n stackNodes -> (¬ fun_updt left2 p t n = null -> m1 (fun_updt left2 p t n) = true) ∧ (¬ fun_updt right2 p (left2 p) n = null -> m1 (fun_updt right2 p (left2 p) n) = true)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length stackNodes) -> (let n : loc := nth (Z.to_nat i) stackNodes inhabitant in fun_updt c1 p true n = true -> (¬ fun_updt left2 p t n = null -> m1 (fun_updt left2 p t n) = true) ∧ (¬ fun_updt right2 p (left2 p) n = null -> m1 (fun_updt right2 p (left2 p) n) = true)))) else let o3 : list loc := cons t stackNodes in Z.of_nat (length o3) = 1%Z + Z.of_nat (length stackNodes) ∧ nth 0%nat o3 inhabitant = t ∧ (∀(i : Z), 0%Z < i ∧ i ≤ Z.of_nat (length stackNodes) -> nth (Z.to_nat i) o3 inhabitant = nth (Z.to_nat (i - 1%Z)) stackNodes inhabitant) -> ¬ t = null ∧ ¬ t = null ∧ ¬ t = null ∧ (if decide (¬ t = root) then ¬ t = null ∧ ¬ t = null ∧ (0%Z ≤ Z.of_nat (size unmarked_nodes) ∧ Z.of_nat (size (remove_set t unmarked_nodes)) < Z.of_nat (size unmarked_nodes) ∨ size unmarked_nodes = size (remove_set t unmarked_nodes) ∧ (0%Z ≤ Z.of_nat (size c_false_nodes) ∧ Z.of_nat (size (insert_set t c_false_nodes)) < Z.of_nat (size c_false_nodes) ∨ size c_false_nodes = size (insert_set t c_false_nodes) ∧ 0%Z ≤ Z.of_nat (length stackNodes) ∧ Z.of_nat (length o3) < Z.of_nat (length stackNodes))) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n o3 ∨ (∃(i : Z), nth (Z.to_nat i) o3 inhabitant = n)) ∧ not_in_stack null o3 ∧ (Z.of_nat (length o3) = 0%Z) = (t = null) ∧ (¬ t = null -> t ∈ graph) ∧ (¬ Z.of_nat (length o3) = 0%Z -> nth 0%nat o3 inhabitant = t) ∧ (∀(n : loc), n ∈ graph -> ¬ fun_updt m1 t true n = true -> n ∈ remove_set t unmarked_nodes) ∧ (∀(n : loc), n ∈ graph -> ¬ fun_updt c1 t false n = true -> n ∈ insert_set t c_false_nodes) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> nth (Z.to_nat i) o3 inhabitant ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) - 1%Z -> (let p1 : loc := nth (Z.to_nat i) o3 inhabitant in let p2 : loc := nth (Z.to_nat (i + 1%Z)) o3 inhabitant in (fun_updt c1 t false p2 = true -> left1 p2 = fun_updt left2 t p p2 ∧ right1 p2 = p1) ∧ (¬ fun_updt c1 t false p2 = true -> left1 p2 = p1 ∧ right1 p2 = right2 p2))) ∧ fun_updt path_from_root1 t (pth ++ cons p ([] : list loc)) root = ([] : list loc) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n o3 -> fun_updt left2 t p n = left1 n ∧ right2 n = right1 n) ∧ (¬ Z.of_nat (length o3) = 0%Z -> (let first : loc := last o3 in if decide (fun_updt c1 t false first = true) then right2 first = null else fun_updt left2 t p first = null)) ∧ (¬ Z.of_nat (length o3) = 0%Z -> last o3 = root) ∧ (∀(k : Z), 0%Z ≤ k ∧ k < Z.of_nat (length o3) - 1%Z -> (if decide (fun_updt c1 t false (nth (Z.to_nat k) o3 inhabitant) = true) then right2 (nth (Z.to_nat k) o3 inhabitant) = nth (Z.to_nat (k + 1%Z)) o3 inhabitant else fun_updt left2 t p (nth (Z.to_nat k) o3 inhabitant) = nth (Z.to_nat (k + 1%Z)) o3 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> fun_updt m1 t true (nth (Z.to_nat i) o3 inhabitant) = true) ∧ distinct o3 ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat i) o3 inhabitant in if decide (fun_updt c1 t false n = true) then fun_updt left2 t p n = left1 n else right2 n = right1 n)) ∧ (¬ Z.of_nat (length o3) = 0%Z -> (if decide (fun_updt c1 t false t = true) then right1 t = left2 t else left1 t = left2 t)) ∧ (∀(k : Z), 0%Z < k ∧ k < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat k) o3 inhabitant in if decide (fun_updt c1 t false n = true) then nth (Z.to_nat (k - 1%Z)) o3 inhabitant = right1 n else nth (Z.to_nat (k - 1%Z)) o3 inhabitant = left1 n)) ∧ (¬ t = null -> path left1 right1 root t (pth ++ cons p ([] : list loc))) ∧ (∀(n : loc), n ∈ graph -> fun_updt m1 t true n = true -> reachable left1 right1 root n) ∧ (t = null -> left2 t = root) ∧ (∀(n : loc), n ∈ graph -> fun_updt m1 t true n = true -> path left1 right1 root n (fun_updt path_from_root1 t (pth ++ cons p ([] : list loc)) n)) ∧ (∀(n : loc), n ∈ graph -> ¬ n = null -> fun_updt m1 t true n = true -> not_in_stack n o3 -> (¬ fun_updt left2 t p n = null -> fun_updt m1 t true (fun_updt left2 t p n) = true) ∧ (¬ right2 n = null -> fun_updt m1 t true (right2 n) = true)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat i) o3 inhabitant in fun_updt c1 t false n = true -> (¬ fun_updt left2 t p n = null -> fun_updt m1 t true (fun_updt left2 t p n) = true) ∧ (¬ right2 n = null -> fun_updt m1 t true (right2 n) = true))) else ¬ t = null ∧ ¬ t = null ∧ (0%Z ≤ Z.of_nat (size unmarked_nodes) ∧ Z.of_nat (size (remove_set t unmarked_nodes)) < Z.of_nat (size unmarked_nodes) ∨ size unmarked_nodes = size (remove_set t unmarked_nodes) ∧ (0%Z ≤ Z.of_nat (size c_false_nodes) ∧ Z.of_nat (size (insert_set t c_false_nodes)) < Z.of_nat (size c_false_nodes) ∨ size c_false_nodes = size (insert_set t c_false_nodes) ∧ 0%Z ≤ Z.of_nat (length stackNodes) ∧ Z.of_nat (length o3) < Z.of_nat (length stackNodes))) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n o3 ∨ (∃(i : Z), nth (Z.to_nat i) o3 inhabitant = n)) ∧ not_in_stack null o3 ∧ (Z.of_nat (length o3) = 0%Z) = (t = null) ∧ (¬ t = null -> t ∈ graph) ∧ (¬ Z.of_nat (length o3) = 0%Z -> nth 0%nat o3 inhabitant = t) ∧ (∀(n : loc), n ∈ graph -> ¬ fun_updt m1 t true n = true -> n ∈ remove_set t unmarked_nodes) ∧ (∀(n : loc), n ∈ graph -> ¬ fun_updt c1 t false n = true -> n ∈ insert_set t c_false_nodes) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> nth (Z.to_nat i) o3 inhabitant ∈ graph) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) - 1%Z -> (let p1 : loc := nth (Z.to_nat i) o3 inhabitant in let p2 : loc := nth (Z.to_nat (i + 1%Z)) o3 inhabitant in (fun_updt c1 t false p2 = true -> left1 p2 = fun_updt left2 t p p2 ∧ right1 p2 = p1) ∧ (¬ fun_updt c1 t false p2 = true -> left1 p2 = p1 ∧ right1 p2 = right2 p2))) ∧ fun_updt path_from_root1 t ([] : list loc) root = ([] : list loc) ∧ (∀(n : loc), n ∈ graph -> not_in_stack n o3 -> fun_updt left2 t p n = left1 n ∧ right2 n = right1 n) ∧ (¬ Z.of_nat (length o3) = 0%Z -> (let first : loc := last o3 in if decide (fun_updt c1 t false first = true) then right2 first = null else fun_updt left2 t p first = null)) ∧ (¬ Z.of_nat (length o3) = 0%Z -> last o3 = root) ∧ (∀(k : Z), 0%Z ≤ k ∧ k < Z.of_nat (length o3) - 1%Z -> (if decide (fun_updt c1 t false (nth (Z.to_nat k) o3 inhabitant) = true) then right2 (nth (Z.to_nat k) o3 inhabitant) = nth (Z.to_nat (k + 1%Z)) o3 inhabitant else fun_updt left2 t p (nth (Z.to_nat k) o3 inhabitant) = nth (Z.to_nat (k + 1%Z)) o3 inhabitant)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> fun_updt m1 t true (nth (Z.to_nat i) o3 inhabitant) = true) ∧ distinct o3 ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat i) o3 inhabitant in if decide (fun_updt c1 t false n = true) then fun_updt left2 t p n = left1 n else right2 n = right1 n)) ∧ (¬ Z.of_nat (length o3) = 0%Z -> (if decide (fun_updt c1 t false t = true) then right1 t = left2 t else left1 t = left2 t)) ∧ (∀(k : Z), 0%Z < k ∧ k < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat k) o3 inhabitant in if decide (fun_updt c1 t false n = true) then nth (Z.to_nat (k - 1%Z)) o3 inhabitant = right1 n else nth (Z.to_nat (k - 1%Z)) o3 inhabitant = left1 n)) ∧ (¬ t = null -> path left1 right1 root t ([] : list loc)) ∧ (∀(n : loc), n ∈ graph -> fun_updt m1 t true n = true -> reachable left1 right1 root n) ∧ (t = null -> left2 t = root) ∧ (∀(n : loc), n ∈ graph -> fun_updt m1 t true n = true -> path left1 right1 root n (fun_updt path_from_root1 t ([] : list loc) n)) ∧ (∀(n : loc), n ∈ graph -> ¬ n = null -> fun_updt m1 t true n = true -> not_in_stack n o3 -> (¬ fun_updt left2 t p n = null -> fun_updt m1 t true (fun_updt left2 t p n) = true) ∧ (¬ right2 n = null -> fun_updt m1 t true (right2 n) = true)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length o3) -> (let n : loc := nth (Z.to_nat i) o3 inhabitant in fun_updt c1 t false n = true -> (¬ fun_updt left2 t p n = null -> fun_updt m1 t true (fun_updt left2 t p n) = true) ∧ (¬ right2 n = null -> fun_updt m1 t true (right2 n) = true))))) else (∀(n : loc), n ∈ graph -> left1 n = left2 n ∧ right1 n = right2 n) ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> reachable left1 right1 root n) ∧ m1 root = true ∧ (∀(n : loc), n ∈ graph -> m1 n = true -> (∀(ch : loc), edge n ch left2 right2 -> ¬ ch = null -> m1 ch = true))))).
Admitted.
