theory stringCheck_StringCheck_at_out_of_range
  imports "NTP4Verif.NTP4Verif" "Why3STD.string_StringRealization"
begin
axiomatization where concat_assoc:   "concat (concat s1 s2) s3 = concat s1 (concat s2 s3)"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where concat_empty'0:   "concat s '''' = concat '''' s"
  for s :: "string"
axiomatization where concat_empty'1:   "concat '''' s = s"
  for s :: "string"
axiomatization where length_empty:   "string_StringRealization.length '''' = (0 :: int)"
axiomatization where length_concat:   "string_StringRealization.length (concat s1 s2) = string_StringRealization.length s1 + string_StringRealization.length s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_empty:   "lt '''' s"
 if "\<not>s = ''''"
  for s :: "string"
axiomatization where lt_not_com:   "\<not>lt s2 s1"
 if "lt s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_ref:   "\<not>lt s1 s1"
  for s1 :: "string"
axiomatization where lt_trans:   "lt s1 s3"
 if "lt s1 s2"
 and "lt s2 s3"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where le_empty:   "le '''' s"
  for s :: "string"
axiomatization where le_ref:   "le s1 s1"
  for s1 :: "string"
axiomatization where lt_le:   "le s1 s2"
 if "lt s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_le_eq:   "lt s1 s2 \<or> s1 = s2"
 if "le s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where le_trans:   "le s1 s3"
 if "le s1 s2"
 and "le s2 s3"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
theorem at_out_of_range:
  fixes i :: "int"
  fixes s :: "string"
  assumes fact0: "i < (0 :: int) \<or> string_StringRealization.length s \<le> i"
  shows "s_at s i = ''''"
  sorry
end
