theory stringCheck_StringCheck_concat_at
  imports "NTP4Verif.NTP4Verif" "Why3STD.string_StringRealization"
begin
axiomatization where concat_assoc:   "concat (concat s1 s2) s3 = concat s1 (concat s2 s3)"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where concat_empty'0:   "concat s '''' = concat '''' s"
  for s :: "string"
axiomatization where concat_empty'1:   "concat '''' s = s"
  for s :: "string"
axiomatization where length_empty:   "string_StringRealization.length '''' = (0 :: int)"
axiomatization where length_concat:   "string_StringRealization.length (concat s1 s2) = string_StringRealization.length s1 + string_StringRealization.length s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_empty:   "lt '''' s"
 if "\<not>s = ''''"
  for s :: "string"
axiomatization where lt_not_com:   "\<not>lt s2 s1"
 if "lt s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_ref:   "\<not>lt s1 s1"
  for s1 :: "string"
axiomatization where lt_trans:   "lt s1 s3"
 if "lt s1 s2"
 and "lt s2 s3"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where le_empty:   "le '''' s"
  for s :: "string"
axiomatization where le_ref:   "le s1 s1"
  for s1 :: "string"
axiomatization where lt_le:   "le s1 s2"
 if "lt s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_le_eq:   "lt s1 s2 \<or> s1 = s2"
 if "le s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where le_trans:   "le s1 s3"
 if "le s1 s2"
 and "le s2 s3"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where at_out_of_range:   "s_at s i = ''''"
 if "i < (0 :: int) \<or> string_StringRealization.length s \<le> i"
  for i :: "int"
  and s :: "string"
axiomatization where at_empty:   "s_at '''' i = ''''"
  for i :: "int"
axiomatization where at_length:   "if (0 :: int) \<le> i \<and> i < string_StringRealization.length s then string_StringRealization.length (s_at s i) = (1 :: int) else string_StringRealization.length (s_at s i) = (0 :: int)"
  for s :: "string"
  and i :: "int"
theorem concat_at:
  fixes s1 :: "string"
  fixes s2 :: "string"
  shows "let s :: string = concat s1 s2 in \<forall>(i :: int). ((0 :: int) \<le> i \<and> i < string_StringRealization.length s1 \<longrightarrow> s_at s i = s_at s1 i) \<and> (string_StringRealization.length s1 \<le> i \<and> i < string_StringRealization.length s \<longrightarrow> s_at s i = s_at s2 (i - string_StringRealization.length s1))"
  sorry
end
