theory stringCheck_StringCheck_substring_at
  imports "NTP4Verif.NTP4Verif" "Why3STD.string_StringRealization"
begin
axiomatization where concat_assoc:   "concat (concat s1 s2) s3 = concat s1 (concat s2 s3)"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where concat_empty'0:   "concat s '''' = concat '''' s"
  for s :: "string"
axiomatization where concat_empty'1:   "concat '''' s = s"
  for s :: "string"
axiomatization where length_empty:   "string_StringRealization.length '''' = (0 :: int)"
axiomatization where length_concat:   "string_StringRealization.length (concat s1 s2) = string_StringRealization.length s1 + string_StringRealization.length s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_empty:   "lt '''' s"
 if "\<not>s = ''''"
  for s :: "string"
axiomatization where lt_not_com:   "\<not>lt s2 s1"
 if "lt s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_ref:   "\<not>lt s1 s1"
  for s1 :: "string"
axiomatization where lt_trans:   "lt s1 s3"
 if "lt s1 s2"
 and "lt s2 s3"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where le_empty:   "le '''' s"
  for s :: "string"
axiomatization where le_ref:   "le s1 s1"
  for s1 :: "string"
axiomatization where lt_le:   "le s1 s2"
 if "lt s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where lt_le_eq:   "lt s1 s2 \<or> s1 = s2"
 if "le s1 s2"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where le_trans:   "le s1 s3"
 if "le s1 s2"
 and "le s2 s3"
  for s1 :: "string"
  and s2 :: "string"
  and s3 :: "string"
axiomatization where at_out_of_range:   "s_at s i = ''''"
 if "i < (0 :: int) \<or> string_StringRealization.length s \<le> i"
  for i :: "int"
  and s :: "string"
axiomatization where at_empty:   "s_at '''' i = ''''"
  for i :: "int"
axiomatization where at_length:   "if (0 :: int) \<le> i \<and> i < string_StringRealization.length s then string_StringRealization.length (s_at s i) = (1 :: int) else string_StringRealization.length (s_at s i) = (0 :: int)"
  for s :: "string"
  and i :: "int"
axiomatization where concat_at:   "\<forall>(i :: int). ((0 :: int) \<le> i \<and> i < string_StringRealization.length s1 \<longrightarrow> s_at (concat s1 s2) i = s_at s1 i) \<and> (string_StringRealization.length s1 \<le> i \<and> i < string_StringRealization.length (concat s1 s2) \<longrightarrow> s_at (concat s1 s2) i = s_at s2 (i - string_StringRealization.length s1))"
  for s1 :: "string"
  and s2 :: "string"
axiomatization where substring_out_of_range:   "substring s i x = ''''"
 if "i < (0 :: int) \<or> string_StringRealization.length s \<le> i"
  for i :: "int"
  and s :: "string"
  and x :: "int"
axiomatization where substring_of_length_zero_or_less:   "substring s i x = ''''"
 if "x \<le> (0 :: int)"
  for x :: "int"
  and s :: "string"
  and i :: "int"
axiomatization where substring_of_empty:   "substring '''' i x = ''''"
  for i :: "int"
  and x :: "int"
axiomatization where substring_smaller:   "string_StringRealization.length (substring s i x) \<le> string_StringRealization.length s"
  for s :: "string"
  and i :: "int"
  and x :: "int"
axiomatization where substring_smaller_x:   "string_StringRealization.length (substring s i x) \<le> x"
 if "(0 :: int) \<le> x"
  for x :: "int"
  and s :: "string"
  and i :: "int"
axiomatization where substring_length:   "if string_StringRealization.length s < i + x then string_StringRealization.length (substring s i x) = string_StringRealization.length s - i else string_StringRealization.length (substring s i x) = x"
 if "(0 :: int) \<le> x"
 and "(0 :: int) \<le> i"
 and "i < string_StringRealization.length s"
  for x :: "int"
  and i :: "int"
  and s :: "string"
theorem substring_at:
  fixes s :: "string"
  fixes i :: "int"
  shows "s_at s i = substring s i (1 :: int)"
  sorry
end
