import Mathlib

open Classical

namespace Lean4Why3

instance {n : Nat} : HShiftLeft (BitVec n) Int (BitVec n) where
  hShiftLeft x k := x <<< k.toNat

instance {n : Nat} : HShiftRight (BitVec n) Int (BitVec n) where
  hShiftRight x k := x >>> k.toNat

abbrev sshiftRight'i {n : ℕ} (a : BitVec n) (s : Int) : BitVec n := a.sshiftRight s.toNat

abbrev make_str_i (size : Int) := String.mk (List.replicate (Int.toNat size) 'a')
abbrev _root_.List.create_i {α} (n : ℤ) (f : ℤ -> α) := (List.range n.toNat).map f
abbrev _root_.List.create {α} (n : ℕ) (f : ℕ -> α) := (List.range n).map f

abbrev _root_.Bool.imp (a b : Bool) : Bool := !a || b

abbrev _root_.List.replicate_i {α} (n : ℤ) (x : α) := List.replicate (Int.toNat n) x

abbrev take_i {α : Type} (n : ℤ) (l : List α) := List.take n.toNat l
abbrev drop_i {α : Type} (n : ℤ) (l : List α) := List.drop n.toNat l

abbrev getElem_i! {α : Type} [Inhabited α] (l : List α) (i : Int) := l[i.toNat]!
abbrev getElem_i? {α : Type} (l : List α) (i : Int) := l[i.toNat]?

abbrev length_i {α : Type} (l : List α) := Int.ofNat l.length
abbrev slice {α : Type} (l : List α) (i j : Nat) : List α :=
  (l.drop i).take (j - i)
abbrev slice_i {α : Type} (l : List α) (i j : Int) : List α :=
  (l.drop i.toNat).take (j.toNat - i.toNat)

abbrev Sorted {α : Type} [LE α] (l : List α) := List.Sorted LE.le l
abbrev _root_.List.set_i {α : Type} (l : List α) (n : ℤ) (a : α) :=
  List.set l n.toNat a

abbrev implication (P : Prop) (Q : Prop) := P -> Q

noncomputable def map_occ {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := {n | l ≤ n ∧ n < u ∧ m n = v }.ncard
noncomputable abbrev map_occ_i {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := Int.ofNat (map_occ (v : α) (m : Int -> α) (l : Int) u)

abbrev _root_.BitVec.toUInt {n : Nat} (x : BitVec n) := Int.ofNat x.toNat

abbrev int'16_max : BitVec 16 := 32767
abbrev int'16_min : BitVec 16 := -32768
abbrev int'31_max : BitVec 31 := 1073741823
abbrev int'31_min : BitVec 31 := -1073741824
abbrev int'32_max : BitVec 32 := 2147483647
abbrev int'32_min : BitVec 32 := -2147483648
abbrev int'63_max : BitVec 63 := 4611686018427387903
abbrev int'63_min : BitVec 63 := -4611686018427387904
abbrev int'64_max : BitVec 64 := 9223372036854775807
abbrev int'64_min : BitVec 64 := -9223372036854775808
abbrev uint'16_max : BitVec 16 := 65535
abbrev uint'16_min : BitVec 16 := 0
abbrev uint'31_max : BitVec 31 := 2147483647
abbrev uint'31_min : BitVec 31 := 0
abbrev uint'32_max : BitVec 32 := 4294967295
abbrev uint'32_min : BitVec 32 := 0
abbrev uint'63_max : BitVec 63 := 9223372036854775807
abbrev uint'63_min : BitVec 63 := 0
abbrev uint'64_max : BitVec 64 := 18446744073709551615
abbrev uint'64_min : BitVec 64 := 0

abbrev int'16_in_bounds (x : Int) := int'16_min.toInt ≤ x ∧ x ≤ int'16_max.toInt
abbrev int'31_in_bounds (x : Int) := int'31_min.toInt ≤ x ∧ x ≤ int'31_max.toInt
abbrev int'32_in_bounds (x : Int) := int'32_min.toInt ≤ x ∧ x ≤ int'32_max.toInt
abbrev int'63_in_bounds (x : Int) := int'63_min.toInt ≤ x ∧ x ≤ int'63_max.toInt
abbrev int'64_in_bounds (x : Int) := int'64_min.toInt ≤ x ∧ x ≤ int'64_max.toInt
abbrev uint'8_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ 256
abbrev uint'16_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'16_max.toUInt
abbrev uint'31_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'31_max.toUInt
abbrev uint'32_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'32_max.toUInt
abbrev uint'63_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'63_max.toUInt
abbrev uint'64_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'64_max.toUInt

axiom array31 : Type -> Type
axiom array32 : Type -> Type
axiom array63 : Type -> Type

axiom array31_elts : {α : Type} -> array31 α -> Int -> α
axiom array32_elts : {α : Type} -> array32 α -> Int -> α
axiom array63_elts : {α : Type} -> array63 α -> List α

noncomputable abbrev array63_nth {α : Type} [Inhabited α] (a : array63 α) (i : Int) := (array63_elts a)[i.toNat]!

axiom array31_length : {α : Type} -> array31 α -> BitVec 31
axiom array32_length : {α : Type} -> array32 α -> BitVec 32
axiom array63_length : {α : Type} -> array63 α -> BitVec 63

abbrev is_none {α : Type} (x : Option α) := x = none
abbrev is_nil {α : Type} (x : List α) := x = []

abbrev _root_.List.rev_append {α : Type} (a : List α) (b : List α) := a.reverse ++ b
abbrev _root_.Finset.is_empty {α : Type} (s : Finset α) := s = ∅
abbrev _root_.Finset.filter' {α : Type} (s : Finset α) (p : α → Prop) [DecidablePred p] : Finset α
  := Finset.filter p s

abbrev _root_.Finset.card_i {α : Type} (s : Finset α) := Int.ofNat s.card

abbrev int_power (x : Int) (n : Int) := x ^ n.toNat
abbrev bv2_power (n : Int) := Int.ofNat (2 ^ n.toNat)

abbrev take_bit_i {n : Nat} (x : BitVec n) (i : Int) := x[i.toNat]!
abbrev take_bit_bv {n m : Nat} (x : BitVec n) (i : BitVec m) := x[i.toNat]!

noncomputable def _root_.Finset.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default
noncomputable def _root_.Set.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default

noncomputable abbrev _root_.BitVec.eq_sub {m : Nat} (a b : BitVec m) (i n : Nat) :=
  BitVec.extractLsb (i+n-1) i a = BitVec.extractLsb (i+n-1) i b

noncomputable abbrev _root_.BitVec.eq_sub_i {m : Nat} (a b : BitVec m) (i n : Int) :=
  BitVec.eq_sub a b i.toNat n.toNat

noncomputable abbrev _root_.BitVec.eq_sub_bv {m : Nat} {m1 : Nat} {m2 : Nat} (a b : BitVec m) (i : BitVec m1) (n : BitVec m2) :=
  BitVec.eq_sub a b i.toNat n.toNat

abbrev w8_size_bv := (8 : BitVec 8)
abbrev w16_size_bv := (16 : BitVec 16)
abbrev w32_size_bv := (32 : BitVec 32)
abbrev w64_size_bv := (64 : BitVec 64)
abbrev w128_size_bv := (128 : BitVec 128)
abbrev w256_size_bv := (256 : BitVec 256)
abbrev w8_size_i := (8 : Int)
abbrev w16_size_i := (16 : Int)
abbrev w32_size_i := (32 : Int)
abbrev w64_size_i := (64 : Int)
abbrev w128_size_i := (128 : Int)
abbrev w256_size_i := (256 : Int)

abbrev _root_.Finset.erase' {α : Type} [DecidableEq α] (a : α) (s : Finset α) : Finset α
  := Finset.erase s a

abbrev _root_.BitVec.sge {n : ℕ} (x y : BitVec n) := BitVec.sle y x
abbrev _root_.BitVec.sgt {n : ℕ} (x y : BitVec n) := BitVec.slt y x

abbrev _root_.BitVec.sshiftRight_i {n : ℕ} (x : BitVec n) (s : ℤ) := BitVec.sshiftRight x s.toNat
abbrev _root_.BitVec.sshiftRight_bv {n m : ℕ} (x : BitVec n) (s : BitVec m)
  := BitVec.sshiftRight x s.toNat

abbrev _root_.BitVec.rotateLeft_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateLeft x n.toNat
abbrev _root_.BitVec.rotateLeft_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateLeft x n.toNat

abbrev _root_.BitVec.rotateRight_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateRight x n.toNat
abbrev _root_.BitVec.rotateRight_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateRight x n.toNat

abbrev _root_.Multiset.count_i {α : Type} [DecidableEq α] (a : α) (s : Multiset α)
  := Int.ofNat (s.count a)

abbrev _root_.Multiset.card_i {α : Type} (S : Multiset α) := Int.ofNat S.card

abbrev _root_.Int.gcd_i (a : ℤ) (b : ℤ) := Int.ofNat (Int.gcd a b)

abbrev _root_.Int.Prime (p : ℤ) := Nat.Prime p.toNat
abbrev _root_.Int.Coprime (a b : ℤ) := Nat.Coprime a.toNat b.toNat

abbrev _root_.Set.remove {α : Type} (x : α) (A : Set α) := A \ {x}
abbrev _root_.Set.filter {α : Type} (S : Set α) (P : α -> Bool) := {x ∈ S | P x }

abbrev _root_.Option.the {α : Type} [Inhabited α] (opt : Option α) := opt.getD default

noncomputable abbrev _root_.Finmap.lookup! {K : Type} {V : Type} [Inhabited V] (m : Finmap (fun _ : K => V)) (k : K) :=
  (Finmap.lookup k m).getD default

noncomputable abbrev _root_.Finmap.mapsto {K V : Type} (k : K) (v : V) (m : Finmap (fun _ : K => V))
  := Finmap.lookup k m = some v

abbrev _root_.Finmap.is_empty {K V : Type} (m : Finmap (fun _ : K => V)) := m = ∅
abbrev _root_.Finmap.size {K V : Type} (m : Finmap (fun _ : K => V)) := m.keys.card

abbrev _root_.Finset.min'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.min with
  | ⊤        => default
  | .some a  => a

abbrev _root_.Finset.max'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.max with
  | ⊥        => default
  | .some a  => a

abbrev arrayExchange {α} [Inhabited α] (a1 a2 : List α) (i j : Int) : Prop :=
  let i' := i.toNat
  let j' := j.toNat
  a1 = (a2.set i' a1[j']!).set j' (a1[i']!)

abbrev _root_.List.permut_sub {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ (0 ≤ l ∧ l ≤ a1.length) ∧ (0 ≤ u ∧ u ≤ a1.length) ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.permut_sub' {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ slice a1 0 l = slice a2 0 l ∧
  slice a1 u a1.length = slice a2 u a1.length ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.foldr' {α β} (f : α -> β -> β) (l : List α) (x : β) := List.foldr f x l

abbrev _root_.Int.to_Real (z : ℤ) : ℝ := z

abbrev _root_.List.mem' {α} (eq : α -> α -> Bool) (x : α) (l : List α) := List.all l (eq x)

noncomputable abbrev _root_.Real.truncate (x : ℝ) : ℤ := if 0 ≤ x then Int.floor x  else Int.ceil x

alias _root_.Math.abs := abs

end Lean4Why3

open Classical
open Lean4Why3

namespace StringRealization
axiom concat : List (BitVec 8) -> List (BitVec 8) -> List (BitVec 8)
axiom length : List (BitVec 8) -> ℤ
axiom lt : List (BitVec 8) -> List (BitVec 8) -> Prop
axiom le : List (BitVec 8) -> List (BitVec 8) -> Prop
axiom s_at : List (BitVec 8) -> ℤ -> List (BitVec 8)
axiom substring : List (BitVec 8) -> ℤ -> ℤ -> List (BitVec 8)
axiom prefixof : List (BitVec 8) -> List (BitVec 8) -> Prop
axiom suffixof : List (BitVec 8) -> List (BitVec 8) -> Prop
axiom contains : List (BitVec 8) -> List (BitVec 8) -> Prop
axiom indexof : List (BitVec 8) -> List (BitVec 8) -> ℤ -> ℤ
axiom replace : List (BitVec 8) -> List (BitVec 8) -> List (BitVec 8) -> List (BitVec 8)
axiom replaceall : List (BitVec 8) -> List (BitVec 8) -> List (BitVec 8) -> List (BitVec 8)
axiom to_int : List (BitVec 8) -> ℤ
noncomputable def is_digit (s : List (BitVec 8)) := ((0 : ℤ) ≤ to_int s ∧ to_int s ≤ (9 : ℤ)) ∧ length s = (1 : ℤ)
axiom from_int : ℤ -> List (BitVec 8)
end StringRealization
namespace stringCheck_StringCheck_to_int_gt_minus_1
axiom concat_assoc (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) : StringRealization.concat (StringRealization.concat s1 s2) s3 = StringRealization.concat s1 (StringRealization.concat s2 s3)
axiom concat_empty (s : List (BitVec 8)) : StringRealization.concat s ([] : List (BitVec 8)) = StringRealization.concat ([] : List (BitVec 8)) s ∧ StringRealization.concat ([] : List (BitVec 8)) s = s
axiom length_empty : StringRealization.length ([] : List (BitVec 8)) = (0 : ℤ)
axiom length_concat (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : StringRealization.length (StringRealization.concat s1 s2) = StringRealization.length s1 + StringRealization.length s2
axiom lt_empty (s : List (BitVec 8)) (fact0 : ¬s = ([] : List (BitVec 8))) : StringRealization.lt ([] : List (BitVec 8)) s
axiom lt_not_com (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : StringRealization.lt s1 s2) : ¬StringRealization.lt s2 s1
axiom lt_ref (s1 : List (BitVec 8)) : ¬StringRealization.lt s1 s1
axiom lt_trans (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) (fact0 : StringRealization.lt s1 s2) (fact1 : StringRealization.lt s2 s3) : StringRealization.lt s1 s3
axiom le_empty (s : List (BitVec 8)) : StringRealization.le ([] : List (BitVec 8)) s
axiom le_ref (s1 : List (BitVec 8)) : StringRealization.le s1 s1
axiom lt_le (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : StringRealization.lt s1 s2) : StringRealization.le s1 s2
axiom lt_le_eq (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : StringRealization.le s1 s2) : StringRealization.lt s1 s2 ∨ s1 = s2
axiom le_trans (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) (fact0 : StringRealization.le s1 s2) (fact1 : StringRealization.le s2 s3) : StringRealization.le s1 s3
axiom at_out_of_range (i : ℤ) (s : List (BitVec 8)) (fact0 : i < (0 : ℤ) ∨ StringRealization.length s ≤ i) : StringRealization.s_at s i = ([] : List (BitVec 8))
axiom at_empty (i : ℤ) : StringRealization.s_at ([] : List (BitVec 8)) i = ([] : List (BitVec 8))
axiom at_length (s : List (BitVec 8)) (i : ℤ) : if (0 : ℤ) ≤ i ∧ i < StringRealization.length s then StringRealization.length (StringRealization.s_at s i) = (1 : ℤ) else StringRealization.length (StringRealization.s_at s i) = (0 : ℤ)
axiom concat_at (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : ∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < StringRealization.length s1 → StringRealization.s_at (StringRealization.concat s1 s2) i = StringRealization.s_at s1 i) ∧ (StringRealization.length s1 ≤ i ∧ i < StringRealization.length (StringRealization.concat s1 s2) → StringRealization.s_at (StringRealization.concat s1 s2) i = StringRealization.s_at s2 (i - StringRealization.length s1))
axiom substring_out_of_range (i : ℤ) (s : List (BitVec 8)) (x : ℤ) (fact0 : i < (0 : ℤ) ∨ StringRealization.length s ≤ i) : StringRealization.substring s i x = ([] : List (BitVec 8))
axiom substring_of_length_zero_or_less (x : ℤ) (s : List (BitVec 8)) (i : ℤ) (fact0 : x ≤ (0 : ℤ)) : StringRealization.substring s i x = ([] : List (BitVec 8))
axiom substring_of_empty (i : ℤ) (x : ℤ) : StringRealization.substring ([] : List (BitVec 8)) i x = ([] : List (BitVec 8))
axiom substring_smaller (s : List (BitVec 8)) (i : ℤ) (x : ℤ) : StringRealization.length (StringRealization.substring s i x) ≤ StringRealization.length s
axiom substring_smaller_x (x : ℤ) (s : List (BitVec 8)) (i : ℤ) (fact0 : (0 : ℤ) ≤ x) : StringRealization.length (StringRealization.substring s i x) ≤ x
axiom substring_length (x : ℤ) (i : ℤ) (s : List (BitVec 8)) (fact0 : (0 : ℤ) ≤ x) (fact1 : (0 : ℤ) ≤ i) (fact2 : i < StringRealization.length s) : if StringRealization.length s < i + x then StringRealization.length (StringRealization.substring s i x) = StringRealization.length s - i else StringRealization.length (StringRealization.substring s i x) = x
axiom substring_at (s : List (BitVec 8)) (i : ℤ) : StringRealization.s_at s i = StringRealization.substring s i (1 : ℤ)
axiom substring_substring (ofs : ℤ) (s : List (BitVec 8)) (len : ℤ) (ofs' : ℤ) (len' : ℤ) (fact0 : (0 : ℤ) ≤ ofs) (fact1 : ofs ≤ StringRealization.length s) (fact2 : (0 : ℤ) ≤ len) (fact3 : ofs + len ≤ StringRealization.length s) (fact4 : (0 : ℤ) ≤ ofs') (fact5 : ofs' ≤ len) (fact6 : (0 : ℤ) ≤ len') (fact7 : ofs' + len' ≤ len) : StringRealization.substring (StringRealization.substring s ofs len) ofs' len' = StringRealization.substring s (ofs + ofs') len'
axiom concat_substring (ofs : ℤ) (s : List (BitVec 8)) (len : ℤ) (len' : ℤ) (fact0 : (0 : ℤ) ≤ ofs) (fact1 : ofs ≤ StringRealization.length s) (fact2 : (0 : ℤ) ≤ len) (fact3 : ofs + len ≤ StringRealization.length s) (fact4 : (0 : ℤ) ≤ len') (fact5 : (0 : ℤ) ≤ ofs + len + len') (fact6 : ofs + len + len' ≤ StringRealization.length s) : StringRealization.concat (StringRealization.substring s ofs len) (StringRealization.substring s (ofs + len) len') = StringRealization.substring s ofs (len + len')
axiom prefixof_substring (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : StringRealization.prefixof s1 s2 = (s1 = StringRealization.substring s2 (0 : ℤ) (StringRealization.length s1))
axiom prefixof_concat (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : StringRealization.prefixof s1 (StringRealization.concat s1 s2)
axiom prefixof_empty (s2 : List (BitVec 8)) : StringRealization.prefixof ([] : List (BitVec 8)) s2
axiom prefixof_empty2 (s1 : List (BitVec 8)) (fact0 : ¬s1 = ([] : List (BitVec 8))) : ¬StringRealization.prefixof s1 ([] : List (BitVec 8))
axiom suffixof_substring (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : StringRealization.suffixof s1 s2 = (s1 = StringRealization.substring s2 (StringRealization.length s2 - StringRealization.length s1) (StringRealization.length s1))
axiom suffixof_concat (s2 : List (BitVec 8)) (s1 : List (BitVec 8)) : StringRealization.suffixof s2 (StringRealization.concat s1 s2)
axiom suffixof_empty (s2 : List (BitVec 8)) : StringRealization.suffixof ([] : List (BitVec 8)) s2
axiom suffixof_empty2 (s1 : List (BitVec 8)) (fact0 : ¬s1 = ([] : List (BitVec 8))) : ¬StringRealization.suffixof s1 ([] : List (BitVec 8))
axiom contains_prefixof (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : StringRealization.prefixof s1 s2) : StringRealization.contains s2 s1
axiom contains_suffixof (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : StringRealization.suffixof s1 s2) : StringRealization.contains s2 s1
axiom contains_empty (s2 : List (BitVec 8)) : StringRealization.contains ([] : List (BitVec 8)) s2 = (s2 = ([] : List (BitVec 8)))
axiom contains_empty2 (s1 : List (BitVec 8)) : StringRealization.contains s1 ([] : List (BitVec 8))
axiom contains_substring (s1 : List (BitVec 8)) (i : ℤ) (s2 : List (BitVec 8)) (fact0 : StringRealization.substring s1 i (StringRealization.length s2) = s2) : StringRealization.contains s1 s2
axiom contains_concat (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : StringRealization.contains (StringRealization.concat s1 s2) s1 ∧ StringRealization.contains (StringRealization.concat s1 s2) s2
axiom contains_at (s1 : List (BitVec 8)) (i : ℤ) (s2 : List (BitVec 8)) (fact0 : StringRealization.s_at s1 i = s2) : StringRealization.contains s1 s2
axiom indexof_empty (i : ℤ) (s : List (BitVec 8)) (fact0 : (0 : ℤ) ≤ i) (fact1 : i ≤ StringRealization.length s) : StringRealization.indexof s ([] : List (BitVec 8)) i = i
axiom indexof_empty1 (s : List (BitVec 8)) (i : ℤ) : StringRealization.indexof ([] : List (BitVec 8)) s i = -(1 : ℤ) ∨ s = ([] : List (BitVec 8)) ∧ i = StringRealization.indexof ([] : List (BitVec 8)) s i ∧ StringRealization.indexof ([] : List (BitVec 8)) s i = (0 : ℤ)
axiom indexof_contains (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) : StringRealization.contains s1 s2 → ((0 : ℤ) ≤ StringRealization.indexof s1 s2 (0 : ℤ) ∧ StringRealization.indexof s1 s2 (0 : ℤ) ≤ StringRealization.length s1) ∧ StringRealization.substring s1 (StringRealization.indexof s1 s2 (0 : ℤ)) (StringRealization.length s2) = s2
axiom contains_indexof (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (i : ℤ) (fact0 : (0 : ℤ) ≤ StringRealization.indexof s1 s2 i) : StringRealization.contains s1 s2
axiom not_contains_indexof (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (i : ℤ) (fact0 : ¬StringRealization.contains s1 s2) : StringRealization.indexof s1 s2 i = -(1 : ℤ)
axiom substring_indexof (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (i : ℤ) : (0 : ℤ) ≤ StringRealization.indexof s1 s2 i → StringRealization.substring s1 (StringRealization.indexof s1 s2 i) (StringRealization.length s2) = s2
axiom indexof_out_of_range (i : ℤ) (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : ¬((0 : ℤ) ≤ i ∧ i ≤ StringRealization.length s1)) : StringRealization.indexof s1 s2 i = -(1 : ℤ)
axiom indexof_in_range (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (i : ℤ) : (0 : ℤ) ≤ i ∧ i ≤ StringRealization.length s1 → StringRealization.indexof s1 s2 i = -(1 : ℤ) ∨ i ≤ StringRealization.indexof s1 s2 i ∧ StringRealization.indexof s1 s2 i ≤ StringRealization.length s1
axiom indexof_contains_substring (i : ℤ) (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (fact0 : (0 : ℤ) ≤ i) (fact1 : i ≤ StringRealization.length s1) (fact2 : StringRealization.contains (StringRealization.substring s1 i (StringRealization.length s1 - i)) s2) : i ≤ StringRealization.indexof s1 s2 i ∧ StringRealization.indexof s1 s2 i ≤ StringRealization.length s1
axiom replace_empty (s1 : List (BitVec 8)) (s3 : List (BitVec 8)) : StringRealization.replace s1 ([] : List (BitVec 8)) s3 = StringRealization.concat s3 s1
axiom replace_not_contains (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) (fact0 : ¬StringRealization.contains s1 s2) : StringRealization.replace s1 s2 s3 = s1
axiom replace_empty2 (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) : if s2 = ([] : List (BitVec 8)) then StringRealization.replace ([] : List (BitVec 8)) s2 s3 = s3 else StringRealization.replace ([] : List (BitVec 8)) s2 s3 = ([] : List (BitVec 8))
axiom replace_substring_indexof (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) : StringRealization.replace s1 s2 s3 = (if StringRealization.indexof s1 s2 (0 : ℤ) < (0 : ℤ) then s1 else StringRealization.concat (StringRealization.concat (StringRealization.substring s1 (0 : ℤ) (StringRealization.indexof s1 s2 (0 : ℤ))) s3) (StringRealization.substring s1 (StringRealization.indexof s1 s2 (0 : ℤ) + StringRealization.length s2) (StringRealization.length s1 - StringRealization.indexof s1 s2 (0 : ℤ) - StringRealization.length s2)))
axiom replaceall_empty1 (s1 : List (BitVec 8)) (s3 : List (BitVec 8)) : StringRealization.replaceall s1 ([] : List (BitVec 8)) s3 = s1
axiom not_contains_replaceall (s1 : List (BitVec 8)) (s2 : List (BitVec 8)) (s3 : List (BitVec 8)) (fact0 : ¬StringRealization.contains s1 s2) : StringRealization.replaceall s1 s2 s3 = s1
lemma to_int_gt_minus_1 (s : List (BitVec 8)) : -(1 : ℤ) ≤ StringRealization.to_int s
  := sorry
end stringCheck_StringCheck_to_int_gt_minus_1
