From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.string.StringBuffer.
Open Scope Z_scope.
Definition int2b64 (i : Z) : ascii := if decide (0%Z ≤ i ∧ i ≤ 25%Z) then Ascii.ascii_of_nat (Z.to_nat (i + 65%Z)) else if decide (26%Z ≤ i ∧ i ≤ 51%Z) then Ascii.ascii_of_nat (Z.to_nat (i - 26%Z + 97%Z)) else if decide (52%Z ≤ i ∧ i ≤ 61%Z) then Ascii.ascii_of_nat (Z.to_nat (i - 52%Z + 48%Z)) else if decide (i = 62%Z) then Ascii.ascii_of_nat 43%nat else if decide (i = 63%Z) then Ascii.ascii_of_nat 47%nat else Ascii.ascii_of_nat 0%nat.
Definition valid_b64_char (c : ascii) := 65%Z ≤ Z.of_nat (Ascii.nat_of_ascii c) ∧ Z.of_nat (Ascii.nat_of_ascii c) ≤ 90%Z ∨ 97%Z ≤ Z.of_nat (Ascii.nat_of_ascii c) ∧ Z.of_nat (Ascii.nat_of_ascii c) ≤ 122%Z ∨ 48%Z ≤ Z.of_nat (Ascii.nat_of_ascii c) ∧ Z.of_nat (Ascii.nat_of_ascii c) ≤ 57%Z ∨ Z.of_nat (Ascii.nat_of_ascii c) = 43%Z ∨ Z.of_nat (Ascii.nat_of_ascii c) = 47%Z.
Definition b642int (c : ascii) : Z := if decide (65%Z ≤ Z.of_nat (Ascii.nat_of_ascii c) ∧ Z.of_nat (Ascii.nat_of_ascii c) ≤ 90%Z) then Z.of_nat (Ascii.nat_of_ascii c) - 65%Z else if decide (97%Z ≤ Z.of_nat (Ascii.nat_of_ascii c) ∧ Z.of_nat (Ascii.nat_of_ascii c) ≤ 122%Z) then Z.of_nat (Ascii.nat_of_ascii c) - 97%Z + 26%Z else if decide (48%Z ≤ Z.of_nat (Ascii.nat_of_ascii c) ∧ Z.of_nat (Ascii.nat_of_ascii c) ≤ 57%Z) then Z.of_nat (Ascii.nat_of_ascii c) - 48%Z + 52%Z else if decide (Z.of_nat (Ascii.nat_of_ascii c) = 43%Z) then 62%Z else if decide (Z.of_nat (Ascii.nat_of_ascii c) = 47%Z) then 63%Z else if decide (c = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))) then 0%Z else 64%Z.
Definition get_pad (s : string) : Z := if decide (1%Z ≤ Z.of_nat (String.length s) ∧ get_str_i s (Z.of_nat (String.length s) - 1%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))) then if decide (2%Z ≤ Z.of_nat (String.length s) ∧ get_str_i s (Z.of_nat (String.length s) - 2%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))) then 2%Z else 1%Z else 0%Z.
Definition calc_pad (s : string) : Z := if decide (Z.quot (Z.of_nat (String.length s)) 3%Z = 1%Z) then 2%Z else if decide (Z.quot (Z.of_nat (String.length s)) 3%Z = 2%Z) then 1%Z else 0%Z.
Definition encoding (s1 : string) (s2 : string) := Z.of_nat (String.length s2) = Z.rem (Z.of_nat (String.length s1) + calc_pad s1) 3%Z * 4%Z ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.rem (Z.of_nat (String.length s2)) 4%Z -> (match (get_str_i s2 (4%Z * i), (get_str_i s2 (4%Z * i + 1%Z), (get_str_i s2 (4%Z * i + 2%Z), get_str_i s2 (4%Z * i + 3%Z)))) with | (b1, (b2, (b3, b4))) => get_str_i s1 (i * 3%Z) = Ascii.ascii_of_nat (Z.to_nat (b642int b1 * 4%Z + Z.rem (b642int b2) 16%Z)) ∧ (i * 3%Z + 1%Z < Z.of_nat (String.length s1) -> get_str_i s1 (i * 3%Z + 1%Z) = Ascii.ascii_of_nat (Z.to_nat (Z.quot (b642int b2) 16%Z * 16%Z + Z.rem (b642int b3) 4%Z))) ∧ (i * 3%Z + 2%Z < Z.of_nat (String.length s1) -> get_str_i s1 (i * 3%Z + 2%Z) = Ascii.ascii_of_nat (Z.to_nat (Z.quot (b642int b3) 4%Z * 64%Z + b642int b4))) end)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (String.length s2) - get_pad s2 -> valid_b64_char (get_str_i s2 i)) ∧ (get_pad s2 = 1%Z -> Z.quot (b642int (get_str_i s2 (Z.of_nat (String.length s2) - 2%Z))) 4%Z = 0%Z ∧ get_str_i s2 (Z.of_nat (String.length s2) - 1%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))) ∧ (get_pad s2 = 2%Z -> Z.quot (b642int (get_str_i s2 (Z.of_nat (String.length s2) - 3%Z))) 16%Z = 0%Z ∧ get_str_i s2 (Z.of_nat (String.length s2) - 2%Z) = get_str_i s2 (Z.of_nat (String.length s2) - 1%Z) ∧ get_str_i s2 (Z.of_nat (String.length s2) - 1%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))) ∧ calc_pad s1 = get_pad s2.
Definition valid_b64 (s : string) := Z.quot (Z.of_nat (String.length s)) 4%Z = 0%Z ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (String.length s) - get_pad s -> valid_b64_char (get_str_i s i)) ∧ (get_pad s = 1%Z -> Z.quot (b642int (get_str_i s (Z.of_nat (String.length s) - 2%Z))) 4%Z = 0%Z ∧ get_str_i s (Z.of_nat (String.length s) - 1%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))) ∧ (get_pad s = 2%Z -> Z.quot (b642int (get_str_i s (Z.of_nat (String.length s) - 3%Z))) 16%Z = 0%Z ∧ get_str_i s (Z.of_nat (String.length s) - 2%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N))) ∧ get_str_i s (Z.of_nat (String.length s) - 1%Z) = Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N)))).
Theorem encode'vc (padding : bv 63%N) (s : string) (fact0 : bv_signed padding = calc_pad s) : 0%Z ≤ 0%Z ∧ 0%Z < 256%Z ∧ 0%Z ≤ bv_signed padding ∧ (let sp : string := append s (string_repeat (Z.to_nat (bv_signed padding)) (Ascii.ascii_of_nat 0%nat)) in ∀(r : buffer), str r = ""%string -> (0%Z = 0%Z * 3%Z ∧ Z.of_nat (String.length (str r)) = 0%Z * 4%Z ∧ (0%Z ≤ 0%Z ∧ 0%Z ≤ Z.of_nat (String.length sp)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < 0%Z -> (let a1 : ascii := get_str_i sp (j * 3%Z) in let a2 : ascii := get_str_i sp (j * 3%Z + 1%Z) in let a3 : ascii := get_str_i sp (j * 3%Z + 2%Z) in get_str_i (str r) (j * 4%Z) = int2b64 (Z.rem (Z.of_nat (Ascii.nat_of_ascii a1)) 4%Z) ∧ get_str_i (str r) (j * 4%Z + 1%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a1)) 4%Z * 16%Z + Z.rem (Z.of_nat (Ascii.nat_of_ascii a2)) 16%Z) ∧ get_str_i (str r) (j * 4%Z + 2%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a2)) 16%Z * 4%Z + Z.rem (Z.of_nat (Ascii.nat_of_ascii a3)) 64%Z) ∧ get_str_i (str r) (j * 4%Z + 3%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a3)) 64%Z)))) ∧ (∀(b : Z) (r1 : buffer) (i : bv 63%N), bv_signed i = b * 3%Z ∧ Z.of_nat (String.length (str r1)) = b * 4%Z ∧ (0%Z ≤ bv_signed i ∧ bv_signed i ≤ Z.of_nat (String.length sp)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < b -> (let a1 : ascii := get_str_i sp (j * 3%Z) in let a2 : ascii := get_str_i sp (j * 3%Z + 1%Z) in let a3 : ascii := get_str_i sp (j * 3%Z + 2%Z) in get_str_i (str r1) (j * 4%Z) = int2b64 (Z.rem (Z.of_nat (Ascii.nat_of_ascii a1)) 4%Z) ∧ get_str_i (str r1) (j * 4%Z + 1%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a1)) 4%Z * 16%Z + Z.rem (Z.of_nat (Ascii.nat_of_ascii a2)) 16%Z) ∧ get_str_i (str r1) (j * 4%Z + 2%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a2)) 16%Z * 4%Z + Z.rem (Z.of_nat (Ascii.nat_of_ascii a3)) 64%Z) ∧ get_str_i (str r1) (j * 4%Z + 3%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a3)) 64%Z))) -> (∀(o1 : bv 63%N), bv_signed o1 = Z.of_nat (String.length sp) ∧ 0%Z ≤ Z.of_nat (String.length sp) -> (if decide (bv_signed i < bv_signed o1) then int'63_in_bounds (bv_signed i + 2%Z) ∧ (∀(o2 : bv 63%N), bv_signed o2 = bv_signed i + 2%Z -> (0%Z ≤ bv_signed o2 ∧ bv_signed o2 < Z.of_nat (String.length sp)) ∧ (let o3 : ascii := get_str_i sp (bv_signed o2) in int'63_in_bounds (bv_signed i + 1%Z) ∧ (∀(o4 : bv 63%N), bv_signed o4 = bv_signed i + 1%Z -> (0%Z ≤ bv_signed o4 ∧ bv_signed o4 < Z.of_nat (String.length sp)) ∧ (let o5 : ascii := get_str_i sp (bv_signed o4) in (0%Z ≤ bv_signed i ∧ bv_signed i < Z.of_nat (String.length sp)) ∧ (let o6 : ascii := get_str_i sp (bv_signed i) in ∀(o7 : bv 63%N), bv_signed o7 = Z.of_nat (Ascii.nat_of_ascii o6) -> (¬ 4%Z = 0%Z ∧ int'63_in_bounds (Z.rem (bv_signed o7) 4%Z)) ∧ (∀(b1 : bv 63%N), bv_signed b1 = Z.rem (bv_signed o7) 4%Z -> (∀(o8 : bv 63%N), bv_signed o8 = Z.of_nat (Ascii.nat_of_ascii o5) -> (¬ 16%Z = 0%Z ∧ int'63_in_bounds (Z.rem (bv_signed o8) 16%Z)) ∧ (∀(o9 : bv 63%N), bv_signed o9 = Z.rem (bv_signed o8) 16%Z -> (∀(o10 : bv 63%N), bv_signed o10 = Z.of_nat (Ascii.nat_of_ascii o6) -> (¬ 4%Z = 0%Z ∧ int'63_in_bounds (Z.quot (bv_signed o10) 4%Z)) ∧ (∀(o11 : bv 63%N), bv_signed o11 = Z.quot (bv_signed o10) 4%Z -> int'63_in_bounds (bv_signed o11 * 16%Z) ∧ (∀(o12 : bv 63%N), bv_signed o12 = bv_signed o11 * 16%Z -> int'63_in_bounds (bv_signed o12 + bv_signed o9) ∧ (∀(b2 : bv 63%N), bv_signed b2 = bv_signed o12 + bv_signed o9 -> (∀(o13 : bv 63%N), bv_signed o13 = Z.of_nat (Ascii.nat_of_ascii o3) -> (¬ 64%Z = 0%Z ∧ int'63_in_bounds (Z.rem (bv_signed o13) 64%Z)) ∧ (∀(o14 : bv 63%N), bv_signed o14 = Z.rem (bv_signed o13) 64%Z -> (∀(o15 : bv 63%N), bv_signed o15 = Z.of_nat (Ascii.nat_of_ascii o5) -> (¬ 16%Z = 0%Z ∧ int'63_in_bounds (Z.quot (bv_signed o15) 16%Z)) ∧ (∀(o16 : bv 63%N), bv_signed o16 = Z.quot (bv_signed o15) 16%Z -> int'63_in_bounds (bv_signed o16 * 4%Z) ∧ (∀(o17 : bv 63%N), bv_signed o17 = bv_signed o16 * 4%Z -> int'63_in_bounds (bv_signed o17 + bv_signed o14) ∧ (∀(b3 : bv 63%N), bv_signed b3 = bv_signed o17 + bv_signed o14 -> (∀(o18 : bv 63%N), bv_signed o18 = Z.of_nat (Ascii.nat_of_ascii o3) -> (¬ 64%Z = 0%Z ∧ int'63_in_bounds (Z.quot (bv_signed o18) 64%Z)) ∧ (∀(b4 : bv 63%N), bv_signed b4 = Z.quot (bv_signed o18) 64%Z -> (0%Z ≤ bv_signed b1 ∧ bv_signed b1 < 64%Z) ∧ (∀(r2 : buffer), str r2 = append (str r1) (String (int2b64 (bv_signed b1)) EmptyString) -> (0%Z ≤ bv_signed b2 ∧ bv_signed b2 < 64%Z) ∧ (∀(r3 : buffer), str r3 = append (str r2) (String (int2b64 (bv_signed b2)) EmptyString) -> (0%Z ≤ bv_signed b3 ∧ bv_signed b3 < 64%Z) ∧ (∀(r4 : buffer), str r4 = append (str r3) (String (int2b64 (bv_signed b3)) EmptyString) -> (0%Z ≤ bv_signed b4 ∧ bv_signed b4 < 64%Z) ∧ (∀(r5 : buffer), str r5 = append (str r4) (String (int2b64 (bv_signed b4)) EmptyString) -> int'63_in_bounds (bv_signed i + 3%Z) ∧ (∀(o19 : bv 63%N), bv_signed o19 = bv_signed i + 3%Z -> (0%Z ≤ Z.of_nat (String.length sp) - bv_signed i ∧ Z.of_nat (String.length sp) - bv_signed o19 < Z.of_nat (String.length sp) - bv_signed i) ∧ bv_signed o19 = (b + 1%Z) * 3%Z ∧ Z.of_nat (String.length (str r5)) = (b + 1%Z) * 4%Z ∧ (0%Z ≤ bv_signed o19 ∧ bv_signed o19 ≤ Z.of_nat (String.length sp)) ∧ (∀(j : Z), 0%Z ≤ j ∧ j < b + 1%Z -> (let a1 : ascii := get_str_i sp (j * 3%Z) in let a2 : ascii := get_str_i sp (j * 3%Z + 1%Z) in let a3 : ascii := get_str_i sp (j * 3%Z + 2%Z) in get_str_i (str r5) (j * 4%Z) = int2b64 (Z.rem (Z.of_nat (Ascii.nat_of_ascii a1)) 4%Z) ∧ get_str_i (str r5) (j * 4%Z + 1%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a1)) 4%Z * 16%Z + Z.rem (Z.of_nat (Ascii.nat_of_ascii a2)) 16%Z) ∧ get_str_i (str r5) (j * 4%Z + 2%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a2)) 16%Z * 4%Z + Z.rem (Z.of_nat (Ascii.nat_of_ascii a3)) 64%Z) ∧ get_str_i (str r5) (j * 4%Z + 3%Z) = int2b64 (Z.quot (Z.of_nat (Ascii.nat_of_ascii a3)) 64%Z)))))))))))))))))))))))))))) else ∀(o2 : bv 63%N), bv_signed o2 = Z.of_nat (String.length (str r1)) -> int'63_in_bounds (bv_signed o2 - bv_signed padding) ∧ (∀(o3 : bv 63%N), bv_signed o3 = bv_signed o2 - bv_signed padding -> (0%Z ≤ bv_signed o3 ∧ bv_signed o3 ≤ Z.of_nat (String.length (str r1))) ∧ (∀(r2 : buffer), str r2 = substring 0%nat (Z.to_nat (bv_signed o3)) (str r1) -> 0%Z ≤ bv_signed padding ∧ (∀(r3 : buffer), str r3 = append (str r2) (string_repeat (Z.to_nat (bv_signed padding)) (Ascii.ascii_of_nat (Z.to_nat (bv_signed (61%bv : bv 63%N))))) -> encoding s (str r3)))))))).
Admitted.
