theory sudoku_Solver_solve_auxqtvc
  imports "NTP4Verif.NTP4Verif" "./sudoku_Grid"
begin
definition valid_chunk_up_to :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> int list \<Rightarrow> int list \<Rightarrow> int \<Rightarrow> _"
  where "valid_chunk_up_to g i start offsets off \<longleftrightarrow> (let s :: int = start ! nat i in \<forall>(o1 :: int) (o2 :: int). ((0 :: int) \<le> o1 \<and> o1 < off) \<and> ((0 :: int) \<le> o2 \<and> o2 < off) \<and> \<not>o1 = o2 \<longrightarrow> (let i1 :: int = s + offsets ! nat o1; i2 :: int = s + offsets ! nat o2 in ((1 :: int) \<le> g i1 \<and> g i1 \<le> (9 :: int)) \<and> (1 :: int) \<le> g i2 \<and> g i2 \<le> (9 :: int) \<longrightarrow> \<not>g i1 = g i2))" for g i start offsets off
definition valid_up_to :: "sudoku_chunks \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> _"
  where "valid_up_to s g i \<longleftrightarrow> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> valid_column s g j \<and> valid_row s g j \<and> valid_square s g j)" for s g i
definition full_up_to :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> _"
  where "full_up_to g i \<longleftrightarrow> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < i \<longrightarrow> (1 :: int) \<le> g j \<and> g j \<le> (9 :: int))" for g i
theorem solve_aux'vc:
  fixes s :: "sudoku_chunks"
  fixes g :: "int list"
  fixes i :: "int"
  assumes fact0: "well_formed_sudoku s"
  assumes fact1: "int (length g) = (81 :: int)"
  assumes fact2: "valid_values (nth g o nat)"
  assumes fact3: "(0 :: int) \<le> i"
  assumes fact4: "i \<le> (81 :: int)"
  assumes fact5: "valid_up_to s (nth g o nat) i"
  assumes fact6: "full_up_to (nth g o nat) i"
  shows "if i = (81 :: int) then is_solution_for s (nth g o nat) (nth g o nat) else ((0 :: int) \<le> i \<and> i < int (length g)) \<and> (if \<not>g ! nat i = (0 :: int) then let o1 :: int list = column_offsets s; o2 :: int list = column_start s in (int (length g) = (81 :: int) \<and> valid_values (nth g o nat) \<and> is_index i \<and> chunk_valid_indexes o2 o1) \<and> (valid_chunk (nth g o nat) i o2 o1 \<longrightarrow> (let o3 :: int list = row_offsets s; o4 :: int list = row_start s in (int (length g) = (81 :: int) \<and> valid_values (nth g o nat) \<and> is_index i \<and> chunk_valid_indexes o4 o3) \<and> (valid_chunk (nth g o nat) i o4 o3 \<longrightarrow> (let o5 :: int list = square_offsets s; o6 :: int list = square_start s in (int (length g) = (81 :: int) \<and> valid_values (nth g o nat) \<and> is_index i \<and> chunk_valid_indexes o6 o5) \<and> (valid_chunk (nth g o nat) i o6 o5 \<longrightarrow> (let o7 :: int = i + (1 :: int) in ((0 :: int) \<le> (81 :: int) - i \<and> (81 :: int) - o7 < (81 :: int) - i) \<and> well_formed_sudoku s \<and> int (length g) = (81 :: int) \<and> valid_values (nth g o nat) \<and> ((0 :: int) \<le> o7 \<and> o7 \<le> (81 :: int)) \<and> valid_up_to s (nth g o nat) o7 \<and> full_up_to (nth g o nat) o7)) \<and> (\<not>valid_chunk (nth g o nat) i o6 o5 \<longrightarrow> grid_eq_sub (nth g o nat) (nth g o nat) (0 :: int) (81 :: int) \<and> (\<forall>(h :: int \<Rightarrow> int). included (nth g o nat) h \<and> full h \<longrightarrow> \<not>valid s h)))) \<and> (\<not>valid_chunk (nth g o nat) i o4 o3 \<longrightarrow> grid_eq_sub (nth g o nat) (nth g o nat) (0 :: int) (81 :: int) \<and> (\<forall>(h :: int \<Rightarrow> int). included (nth g o nat) h \<and> full h \<longrightarrow> \<not>valid s h)))) \<and> (\<not>valid_chunk (nth g o nat) i o2 o1 \<longrightarrow> grid_eq_sub (nth g o nat) (nth g o nat) (0 :: int) (81 :: int) \<and> (\<forall>(h :: int \<Rightarrow> int). included (nth g o nat) h \<and> full h \<longrightarrow> \<not>valid s h)) else let old_g :: int \<Rightarrow> int = nth g o nat in ((1 :: int) \<le> (9 :: int) + (1 :: int) \<longrightarrow> (grid_eq_sub old_g ((nth g o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth g o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < (1 :: int) \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h))) \<and> (\<forall>(g1 :: int list). length g1 = length g \<longrightarrow> (\<forall>(k :: int). ((1 :: int) \<le> k \<and> k \<le> (9 :: int)) \<and> grid_eq_sub old_g ((nth g1 o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth g1 o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < k \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h)) \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length g1)) \<and> (length (g1[nat i := k]) = length g1 \<longrightarrow> nth (g1[nat i := k]) o nat = (nth g1 o nat)(i := k) \<longrightarrow> (let o1 :: int list = column_offsets s; o2 :: int list = column_start s in (int (length (g1[nat i := k])) = (81 :: int) \<and> valid_values (nth (g1[nat i := k]) o nat) \<and> is_index i \<and> chunk_valid_indexes o2 o1) \<and> (valid_chunk (nth (g1[nat i := k]) o nat) i o2 o1 \<longrightarrow> (let o3 :: int list = row_offsets s; o4 :: int list = row_start s in (int (length (g1[nat i := k])) = (81 :: int) \<and> valid_values (nth (g1[nat i := k]) o nat) \<and> is_index i \<and> chunk_valid_indexes o4 o3) \<and> (valid_chunk (nth (g1[nat i := k]) o nat) i o4 o3 \<longrightarrow> (let o5 :: int list = square_offsets s; o6 :: int list = square_start s in (int (length (g1[nat i := k])) = (81 :: int) \<and> valid_values (nth (g1[nat i := k]) o nat) \<and> is_index i \<and> chunk_valid_indexes o6 o5) \<and> (valid_chunk (nth (g1[nat i := k]) o nat) i o6 o5 \<longrightarrow> (well_formed_sudoku s \<and> is_index i \<and> valid_up_to s old_g i \<and> ((1 :: int) \<le> k \<and> k \<le> (9 :: int)) \<and> valid_column s (old_g(i := k)) i \<and> valid_row s (old_g(i := k)) i \<and> valid_square s (old_g(i := k)) i) \<and> (valid_up_to s (old_g(i := k)) (i + (1 :: int)) \<longrightarrow> (let o7 :: int = i + (1 :: int) in (((0 :: int) \<le> (81 :: int) - i \<and> (81 :: int) - o7 < (81 :: int) - i) \<and> well_formed_sudoku s \<and> int (length (g1[nat i := k])) = (81 :: int) \<and> valid_values (nth (g1[nat i := k]) o nat) \<and> ((0 :: int) \<le> o7 \<and> o7 \<le> (81 :: int)) \<and> valid_up_to s (nth (g1[nat i := k]) o nat) o7 \<and> full_up_to (nth (g1[nat i := k]) o nat) o7) \<and> (\<forall>(g2 :: int list). length g2 = length (g1[nat i := k]) \<longrightarrow> (grid_eq_sub (nth (g1[nat i := k]) o nat) (nth g2 o nat) (0 :: int) (81 :: int) \<and> (\<forall>(h :: int \<Rightarrow> int). included (nth g2 o nat) h \<and> full h \<longrightarrow> \<not>valid s h) \<longrightarrow> grid_eq_sub old_g ((nth g2 o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth g2 o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < k + (1 :: int) \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h))) \<and> (is_solution_for s (nth g2 o nat) (nth (g1[nat i := k]) o nat) \<longrightarrow> is_solution_for s (nth g2 o nat) (nth g o nat)))))) \<and> (\<not>valid_chunk (nth (g1[nat i := k]) o nat) i o6 o5 \<longrightarrow> grid_eq_sub old_g ((nth (g1[nat i := k]) o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth (g1[nat i := k]) o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < k + (1 :: int) \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h))))) \<and> (\<not>valid_chunk (nth (g1[nat i := k]) o nat) i o4 o3 \<longrightarrow> grid_eq_sub old_g ((nth (g1[nat i := k]) o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth (g1[nat i := k]) o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < k + (1 :: int) \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h))))) \<and> (\<not>valid_chunk (nth (g1[nat i := k]) o nat) i o2 o1 \<longrightarrow> grid_eq_sub old_g ((nth (g1[nat i := k]) o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth (g1[nat i := k]) o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < k + (1 :: int) \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h)))))) \<and> (grid_eq_sub old_g ((nth g1 o nat)(i := 0 :: int)) (0 :: int) (81 :: int) \<and> full_up_to (nth g1 o nat) i \<and> (\<forall>(k' :: int). (1 :: int) \<le> k' \<and> k' < (9 :: int) + (1 :: int) \<longrightarrow> (\<forall>(h :: int \<Rightarrow> int). included (old_g(i := k')) h \<and> full h \<longrightarrow> \<not>valid s h)) \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length g1)) \<and> (length (g1[nat i := 0 :: int]) = length g1 \<longrightarrow> nth (g1[nat i := 0 :: int]) o nat = (nth g1 o nat)(i := 0 :: int) \<longrightarrow> grid_eq_sub (nth g o nat) (nth (g1[nat i := 0 :: int]) o nat) (0 :: int) (81 :: int) \<and> (\<forall>(h :: int \<Rightarrow> int). included (nth (g1[nat i := 0 :: int]) o nat) h \<and> full h \<longrightarrow> \<not>valid s h))))) \<and> ((9 :: int) + (1 :: int) < (1 :: int) \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length g)) \<and> (length (g[nat i := 0 :: int]) = length g \<longrightarrow> nth (g[nat i := 0 :: int]) o nat = (nth g o nat)(i := 0 :: int) \<longrightarrow> grid_eq_sub (nth g o nat) (nth (g[nat i := 0 :: int]) o nat) (0 :: int) (81 :: int) \<and> (\<forall>(h :: int \<Rightarrow> int). included (nth (g[nat i := 0 :: int]) o nat) h \<and> full h \<longrightarrow> \<not>valid s h))))"
  sorry
end
