From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Open Scope Z_scope.
Inductive list (α : Type) :=
  | Nil : list α
  | Cons : α -> list α -> list α.
Axiom list_inhabited : forall  {α : Type} `{Inhabited α}, Inhabited (list α).
Global Existing Instance list_inhabited.
Arguments Nil {α}.
Arguments Cons {α}.
Program Fixpoint length {α : Type} `{Inhabited α} (l : list α) : Z :=
match l with | Nil => 0%Z | Cons _ r => 1%Z + length r end.
Admit Obligations.
Lemma toy_example'vc {α : Type} `{Inhabited α} (l : list α) : match l with | Nil => True | Cons _ Nil => True | Cons x (Cons _ r) => 0%Z ≤ length l -> 0%Z ≤ length l ∧ length (Cons x r) < length l end.
Admitted.
