theory three_idem_ring_Top_null_star_rqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  t
consts zero :: "t"
consts infix_pl :: "t \<Rightarrow> t \<Rightarrow> t"
consts prefix_mn :: "t \<Rightarrow> t"
consts infix_as :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l:   "infix_pl zero x = x"
  for x :: "t"
axiomatization where Unit_def_r:   "infix_pl x zero = x"
  for x :: "t"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = zero"
  for x :: "t"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = zero"
  for x :: "t"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
consts mul :: "t \<Rightarrow> int \<Rightarrow> t"
axiomatization where mul'def:   "if n = (0 :: int) then mul x n = zero else mul x n = infix_pl x (mul x (n - (1 :: int)))"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "t"
axiomatization where Assoc2:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l1:   "infix_pl zero x = x"
  for x :: "t"
axiomatization where Unit_def_r1:   "infix_pl x zero = x"
  for x :: "t"
axiomatization where Power_0:   "mul x (0 :: int) = zero"
  for x :: "t"
axiomatization where Power_s:   "mul x (n + (1 :: int)) = infix_pl x (mul x n)"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "t"
axiomatization where Power_s_alt:   "mul x n = infix_pl x (mul x (n - (1 :: int)))"
 if "(0 :: int) < n"
  for n :: "int"
  and x :: "t"
axiomatization where Power_1:   "mul x (1 :: int) = x"
  for x :: "t"
axiomatization where Power_sum:   "mul x (n + m) = infix_pl (mul x n) (mul x m)"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "t"
axiomatization where Power_mult:   "mul x (n * m) = mul (mul x n) m"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "t"
axiomatization where Power_comm1:   "infix_pl (mul x n) y = infix_pl y (mul x n)"
 if "infix_pl x y = infix_pl y x"
 and "(0 :: int) \<le> n"
  for x :: "t"
  and y :: "t"
  and n :: "int"
axiomatization where Power_comm2:   "mul (infix_pl x y) n = infix_pl (mul x n) (mul y n)"
 if "infix_pl x y = infix_pl y x"
 and "(0 :: int) \<le> n"
  for x :: "t"
  and y :: "t"
  and n :: "int"
definition null :: "t \<Rightarrow> int \<Rightarrow> _"
  where "null x n \<longleftrightarrow> mul x n = zero" for x n
theorem null_star_r'vc:
  fixes n :: "int"
  fixes y :: "t"
  fixes x :: "t"
  assumes fact0: "(0 :: int) \<le> n"
  assumes fact1: "null y n"
  shows "null (infix_as x y) n"
  sorry
end
