theory verifythis_2015_parallel_gcd_Interleaving_parallel_gcdqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
datatype  state = ReadA | ReadB | Compare | Halt
datatype  thread = thread'mk (local_a: "int") (local_b: "int") (state1: "state")
definition inv :: "thread \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "inv th d a b \<longleftrightarrow> (0 :: int) < a \<and> (0 :: int) < b \<and> gcd a b = d \<and> (case state1 th of ReadA \<Rightarrow> True | ReadB \<Rightarrow> local_a th = a | Compare \<Rightarrow> local_a th = a \<and> b \<le> local_b th \<and> (local_b th \<le> local_a th \<longrightarrow> local_b th = b) | Halt \<Rightarrow> local_a th = a \<and> a = b)" for th d a b
definition progress_thread :: "thread \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "progress_thread th a b \<longleftrightarrow> b < a \<or> a = b \<and> \<not>state1 th = Halt" for th a b
definition state_index :: "state \<Rightarrow> int"
  where "state_index s = (case s of ReadA \<Rightarrow> (7 :: int) | ReadB \<Rightarrow> (5 :: int) | Compare \<Rightarrow> (3 :: int) | Halt \<Rightarrow> (2 :: int))" for s
definition sync :: "thread \<Rightarrow> int \<Rightarrow> _"
  where "sync th b \<longleftrightarrow> (case state1 th of Compare \<Rightarrow> local_b th = b | _ \<Rightarrow> True)" for th b
definition sync_index :: "thread \<Rightarrow> int \<Rightarrow> int"
  where "sync_index th b = (if sync th b then 0 :: int else (42 :: int))" for th b
definition prog_index :: "thread \<Rightarrow> int \<Rightarrow> int"
  where "prog_index th b = sync_index th b + state_index (state1 th)" for th b
theorem parallel_gcd'vc:
  fixes a0 :: "int"
  fixes b0 :: "int"
  assumes fact0: "(0 :: int) < a0"
  assumes fact1: "(0 :: int) < b0"
  shows "let d :: int = gcd a0 b0 in \<forall>(th1 :: thread). state1 th1 = ReadA \<longrightarrow> (\<forall>(th2 :: thread). state1 th2 = ReadA \<longrightarrow> (inv th1 d a0 b0 \<and> inv th2 d b0 a0) \<and> (\<forall>(th21 :: thread) (th11 :: thread) (b :: int) (a :: int) (timer :: int) (scheduled :: bool). inv th11 d a b \<and> inv th21 d b a \<longrightarrow> (\<forall>(o1 :: bool). (if \<not>state1 th11 = Halt then o1 = True else o1 = (if \<not>state1 th21 = Halt then True else False)) \<longrightarrow> (if o1 = True then \<forall>(timer1 :: int) (scheduled1 :: bool). (scheduled1 = scheduled \<longrightarrow> (0 :: int) \<le> timer1 \<and> timer1 < timer) \<longrightarrow> (if scheduled1 = True then inv th11 d a b \<and> (\<forall>(th12 :: thread) (a1 :: int). inv th12 d a1 b \<and> ((0 :: int) < a1 \<and> a1 \<le> a) \<and> (a1 < a \<longrightarrow> a1 + b \<le> a) \<and> (progress_thread th12 a1 b \<longrightarrow> prog_index th12 b < prog_index th11 b \<or> a1 < a) \<longrightarrow> ((0 :: int) \<le> a + b \<and> a1 + b < a + b \<or> a + b = a1 + b \<and> ((0 :: int) \<le> (if a = b then prog_index th21 a + prog_index th11 b else if a < b then prog_index th21 a else prog_index th11 b) \<and> (if a1 = b then prog_index th21 a1 + prog_index th12 b else if a1 < b then prog_index th21 a1 else prog_index th12 b) < (if a = b then prog_index th21 a + prog_index th11 b else if a < b then prog_index th21 a else prog_index th11 b) \<or> (if a = b then prog_index th21 a + prog_index th11 b else if a < b then prog_index th21 a else prog_index th11 b) = (if a1 = b then prog_index th21 a1 + prog_index th12 b else if a1 < b then prog_index th21 a1 else prog_index th12 b) \<and> ((0 :: int) \<le> (if progress_thread th11 a b then if scheduled = True then 1 :: int else (0 :: int) else if progress_thread th21 b a then if scheduled = True then 0 :: int else (1 :: int) else (0 :: int)) \<and> (if progress_thread th12 a1 b then if scheduled1 = True then 1 :: int else (0 :: int) else if progress_thread th21 b a1 then if scheduled1 = True then 0 :: int else (1 :: int) else (0 :: int)) < (if progress_thread th11 a b then if scheduled = True then 1 :: int else (0 :: int) else if progress_thread th21 b a then if scheduled = True then 0 :: int else (1 :: int) else (0 :: int)) \<or> (if progress_thread th11 a b then if scheduled = True then 1 :: int else (0 :: int) else if progress_thread th21 b a then if scheduled = True then 0 :: int else (1 :: int) else (0 :: int)) = (if progress_thread th12 a1 b then if scheduled1 = True then 1 :: int else (0 :: int) else if progress_thread th21 b a1 then if scheduled1 = True then 0 :: int else (1 :: int) else (0 :: int)) \<and> (0 :: int) \<le> timer \<and> timer1 < timer))) \<and> inv th12 d a1 b \<and> inv th21 d b a1) else inv th21 d b a \<and> (\<forall>(th22 :: thread) (b1 :: int). inv th22 d b1 a \<and> ((0 :: int) < b1 \<and> b1 \<le> b) \<and> (b1 < b \<longrightarrow> b1 + a \<le> b) \<and> (progress_thread th22 b1 a \<longrightarrow> prog_index th22 a < prog_index th21 a \<or> b1 < b) \<longrightarrow> ((0 :: int) \<le> a + b \<and> a + b1 < a + b \<or> a + b = a + b1 \<and> ((0 :: int) \<le> (if a = b then prog_index th21 a + prog_index th11 b else if a < b then prog_index th21 a else prog_index th11 b) \<and> (if a = b1 then prog_index th22 a + prog_index th11 b1 else if a < b1 then prog_index th22 a else prog_index th11 b1) < (if a = b then prog_index th21 a + prog_index th11 b else if a < b then prog_index th21 a else prog_index th11 b) \<or> (if a = b then prog_index th21 a + prog_index th11 b else if a < b then prog_index th21 a else prog_index th11 b) = (if a = b1 then prog_index th22 a + prog_index th11 b1 else if a < b1 then prog_index th22 a else prog_index th11 b1) \<and> ((0 :: int) \<le> (if progress_thread th11 a b then if scheduled = True then 1 :: int else (0 :: int) else if progress_thread th21 b a then if scheduled = True then 0 :: int else (1 :: int) else (0 :: int)) \<and> (if progress_thread th11 a b1 then if scheduled1 = True then 1 :: int else (0 :: int) else if progress_thread th22 b1 a then if scheduled1 = True then 0 :: int else (1 :: int) else (0 :: int)) < (if progress_thread th11 a b then if scheduled = True then 1 :: int else (0 :: int) else if progress_thread th21 b a then if scheduled = True then 0 :: int else (1 :: int) else (0 :: int)) \<or> (if progress_thread th11 a b then if scheduled = True then 1 :: int else (0 :: int) else if progress_thread th21 b a then if scheduled = True then 0 :: int else (1 :: int) else (0 :: int)) = (if progress_thread th11 a b1 then if scheduled1 = True then 1 :: int else (0 :: int) else if progress_thread th22 b1 a then if scheduled1 = True then 0 :: int else (1 :: int) else (0 :: int)) \<and> (0 :: int) \<le> timer \<and> timer1 < timer))) \<and> inv th11 d a b1 \<and> inv th22 d b1 a)) else a = gcd a0 b0))))"
  sorry
end
