theory matrices_MatrixGen
  imports "NTP4Verif.NTP4Verif"
begin
typedecl 'a mat
consts rows :: "'a mat \<Rightarrow> int"
consts cols :: "'a mat \<Rightarrow> int"
axiomatization where rows_and_cols_nonnegative'0:   "(0 :: int) \<le> rows m"
  for m :: "'a mat"
axiomatization where rows_and_cols_nonnegative'1:   "(0 :: int) \<le> cols m"
  for m :: "'a mat"
consts get :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
consts set :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a mat"
axiomatization where set_def1:   "rows (set m i j v) = rows m"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and v :: "'a"
axiomatization where set_def2:   "cols (set m i j v) = cols m"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and v :: "'a"
axiomatization where set_def3:   "get (set m i j v) i j = v"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and v :: "'a"
axiomatization where set_def4:   "get (set m i j v) i' j' = get m i' j'"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
 and "(0 :: int) \<le> i'"
 and "i' < rows m"
 and "(0 :: int) \<le> j'"
 and "j' < cols m"
 and "\<not>i = i' \<or> \<not>j = j'"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and i' :: "int"
  and j' :: "int"
  and v :: "'a"
definition infix_eqeq :: "'a mat \<Rightarrow> 'a mat \<Rightarrow> _"
  where "infix_eqeq m1 m2 \<longleftrightarrow> rows m1 = rows m2 \<and> cols m1 = cols m2 \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < rows m1 \<longrightarrow> (0 :: int) \<le> j \<and> j < cols m1 \<longrightarrow> get m1 i j = get m2 i j)" for m1 m2
axiomatization where extensionality:   "m1 = m2"
 if "infix_eqeq m1 m2"
  for m1 :: "'a mat"
  and m2 :: "'a mat"
definition infix_eqeqeq :: "'a mat \<Rightarrow> 'a mat \<Rightarrow> _"
  where "infix_eqeqeq a b \<longleftrightarrow> rows a = rows b \<and> cols a = cols b" for a b
end
