theory matrices_MyMatrix
  imports "NTP4Verif.NTP4Verif"
begin
typedecl 'a mat
consts rows :: "'a mat \<Rightarrow> int"
consts cols :: "'a mat \<Rightarrow> int"
consts get :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
consts create :: "int \<Rightarrow> int \<Rightarrow> (int \<Rightarrow> int \<Rightarrow> 'a) \<Rightarrow> 'a mat"
axiomatization where create_rows:   "rows (create r c f) = r"
 if "(0 :: int) \<le> r"
  for r :: "int"
  and c :: "int"
  and f :: "int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where create_cols:   "cols (create r c f) = c"
 if "(0 :: int) \<le> c"
  for c :: "int"
  and r :: "int"
  and f :: "int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where create_get:   "get (create r c f) i j = f i j"
 if "(0 :: int) \<le> i"
 and "i < r"
 and "(0 :: int) \<le> j"
 and "j < c"
  for i :: "int"
  and r :: "int"
  and j :: "int"
  and c :: "int"
  and f :: "int \<Rightarrow> int \<Rightarrow> 'a"
consts fc :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where fc'def:   "fc m x y z x1 y1 = (if x1 = x \<and> y1 = y then z else get m x1 y1)"
  for m :: "'a mat"
  and x :: "int"
  and y :: "int"
  and z :: "'a"
  and x1 :: "int"
  and y1 :: "int"
definition set :: "'a mat \<Rightarrow> int \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a mat"
  where "set m x y z = create (rows m) (cols m) (fc m x y z)" for m x y z
axiomatization where rows_and_cols_nonnegative'0:   "(0 :: int) \<le> rows m"
  for m :: "'a mat"
axiomatization where rows_and_cols_nonnegative'1:   "(0 :: int) \<le> cols m"
  for m :: "'a mat"
axiomatization where set_def1:   "rows (set m i j v) = rows m"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and v :: "'a"
axiomatization where set_def2:   "cols (set m i j v) = cols m"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and v :: "'a"
axiomatization where set_def3:   "get (set m i j v) i j = v"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and v :: "'a"
axiomatization where set_def4:   "get (set m i j v) i' j' = get m i' j'"
 if "(0 :: int) \<le> i"
 and "i < rows m"
 and "(0 :: int) \<le> j"
 and "j < cols m"
 and "(0 :: int) \<le> i'"
 and "i' < rows m"
 and "(0 :: int) \<le> j'"
 and "j' < cols m"
 and "\<not>i = i' \<or> \<not>j = j'"
  for i :: "int"
  and m :: "'a mat"
  and j :: "int"
  and i' :: "int"
  and j' :: "int"
  and v :: "'a"
definition infix_eqeq :: "'a mat \<Rightarrow> 'a mat \<Rightarrow> _"
  where "infix_eqeq m1 m2 \<longleftrightarrow> rows m1 = rows m2 \<and> cols m1 = cols m2 \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < rows m1 \<longrightarrow> (0 :: int) \<le> j \<and> j < cols m1 \<longrightarrow> get m1 i j = get m2 i j)" for m1 m2
axiomatization where extensionality:   "m1 = m2"
 if "infix_eqeq m1 m2"
  for m1 :: "'a mat"
  and m2 :: "'a mat"
definition infix_eqeqeq :: "'a mat \<Rightarrow> 'a mat \<Rightarrow> _"
  where "infix_eqeqeq a b \<longleftrightarrow> rows a = rows b \<and> cols a = cols b" for a b
end
