import Why3.Base
import Why3.int.Sum
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.MyMatrix
import pearl.verifythis_2016_matrix_multiplication.lib.lean.matrices.MatrixArithmetic
import pearl.verifythis_2016_matrix_multiplication.lib.lean.sum_extended.Sum_extended
open Classical
open Lean4Why3
namespace matrices_ring_simp_Symb_harnessqtvc
structure mono where
  m_prod : List ℤ
  m_pos : Bool
axiom inhabited_axiom_mono : Inhabited mono
attribute [instance] inhabited_axiom_mono
noncomputable def l_mdl : (ℤ -> MyMatrix.mat ℤ) -> List ℤ -> MyMatrix.mat ℤ
  | f, ([] : List ℤ) => MyMatrix.create (-(1 : ℤ)) (-(1 : ℤ)) MatrixArithmetic.zerof
  | f, (List.cons x ([] : List ℤ)) => f x
  | f, (List.cons x q) => MatrixArithmetic.mul (f x) (l_mdl f q)
noncomputable def l_vld : (ℤ -> MyMatrix.mat ℤ) -> ℤ -> ℤ -> List ℤ -> Prop
  | f, r, c, ([] : List ℤ) => False
  | f, r, c, (List.cons x ([] : List ℤ)) => MyMatrix.rows (f x) = r ∧ MyMatrix.cols (f x) = c
  | f, r, c, (List.cons x q) => MyMatrix.rows (f x) = r ∧ l_vld f (MyMatrix.cols (f x)) c q
noncomputable def m_mdl (f : ℤ -> MyMatrix.mat ℤ) (m : mono) := let m0 : MyMatrix.mat ℤ := l_mdl f (mono.m_prod m); if mono.m_pos m = true then m0 else MatrixArithmetic.opp m0
noncomputable def lm_mdl : (ℤ -> MyMatrix.mat ℤ) -> ℤ -> ℤ -> List mono -> MyMatrix.mat ℤ
  | f, r, c, ([] : List mono) => MyMatrix.create r c MatrixArithmetic.zerof
  | f, r, c, (List.cons x q) => MatrixArithmetic.add (lm_mdl f r c q) (m_mdl f x)
noncomputable def lm_mdl_simp : (ℤ -> MyMatrix.mat ℤ) -> ℤ -> ℤ -> List mono -> MyMatrix.mat ℤ
  | f, r, c, ([] : List mono) => MyMatrix.create r c MatrixArithmetic.zerof
  | f, r, c, (List.cons x ([] : List mono)) => m_mdl f x
  | f, r, c, (List.cons x q) => MatrixArithmetic.add (lm_mdl_simp f r c q) (m_mdl f x)
noncomputable def lm_vld : (ℤ -> MyMatrix.mat ℤ) -> ℤ -> ℤ -> List mono -> Prop
  | f, r, c, ([] : List mono) => True
  | f, r, c, (List.cons x q) => l_vld f r c (mono.m_prod x) ∧ lm_vld f r c q
noncomputable def l_compare : List ℤ -> List ℤ -> ℤ
  | ([] : List ℤ), ([] : List ℤ) => (0 : ℤ)
  | ([] : List ℤ), x => -(1 : ℤ)
  | x, ([] : List ℤ) => (1 : ℤ)
  | (List.cons x q), (List.cons y r) => if x < y then -(1 : ℤ) else if y < x then (1 : ℤ) else l_compare q r
noncomputable def m_lower (m1 : mono) (m2 : mono) := let cmp : ℤ := l_compare (mono.m_prod m1) (mono.m_prod m2); cmp < (0 : ℤ) ∨ cmp = (0 : ℤ) ∧ (mono.m_pos m1 = true → mono.m_pos m2 = true)
noncomputable def m_collapse (l : List mono) (m : mono) := match l with | ([] : List mono) => List.cons m ([] : List mono) | List.cons x q => (if ¬mono.m_pos x = true ∧ mono.m_pos m = true ∧ l_compare (mono.m_prod m) (mono.m_prod x) = (0 : ℤ) then q else List.cons m l)
noncomputable def lm_collapse : List mono -> List mono -> List mono
  | acc, ([] : List mono) => acc
  | acc, (List.cons x q) => lm_collapse (m_collapse acc x) q
noncomputable def cat_rev {α : Type} [Inhabited α] : List α -> List α -> List α
  | acc, ([] : List α) => acc
  | acc, (List.cons x q) => cat_rev (List.cons x acc) q
noncomputable def lm_dump : mono -> List mono -> List mono -> List mono × List mono
  | x, acc, ([] : List mono) => (acc, ([] : List mono))
  | x, acc, (List.cons y q) => if m_lower x y then (acc, List.cons y q) else lm_dump x (m_collapse acc y) q
noncomputable def lm_merge : List mono -> List mono -> List mono -> List mono
  | acc, ([] : List mono), l2 => cat_rev ([] : List mono) (lm_collapse acc l2)
  | acc, (List.cons x q), l2 => match lm_dump x acc l2 with | (acc1, l21) => lm_merge (m_collapse acc1 x) q l21
noncomputable def cat {α : Type} [Inhabited α] : List α -> List α -> List α
  | ([] : List α), l2 => l2
  | (List.cons x q), l2 => List.cons x (cat q l2)
noncomputable def m_mul (m1 : mono) (m2 : mono) := mono.mk (cat (mono.m_prod m1) (mono.m_prod m2)) (if (mono.m_pos m1 = true) = (mono.m_pos m2 = true) then true else false)
noncomputable def m_distribute : mono -> List mono -> List mono
  | m, ([] : List mono) => ([] : List mono)
  | m, (List.cons x q) => List.cons (m_mul m x) (m_distribute m q)
noncomputable def lm_distribute : List mono -> List mono -> List mono
  | ([] : List mono), l2 => ([] : List mono)
  | (List.cons x q), l2 => lm_merge ([] : List mono) (m_distribute x l2) (lm_distribute q l2)
noncomputable def lm_opp : List mono -> List mono
  | ([] : List mono) => ([] : List mono)
  | (List.cons x q) => lm_merge ([] : List mono) (List.cons (mono.mk (mono.m_prod x) (if ¬mono.m_pos x = true then true else false)) ([] : List mono)) (lm_opp q)
axiom fc : ℤ -> ℤ -> MyMatrix.mat ℤ
axiom fc'def (y0 : ℤ) (y1 : ℤ) : fc y0 y1 = MyMatrix.create y0 y1 MatrixArithmetic.zerof
noncomputable def empty := fc (0 : ℤ)
structure env where
  ev_f : ℤ -> MyMatrix.mat ℤ
  ev_c : ℤ
axiom inhabited_axiom_env : Inhabited env
attribute [instance] inhabited_axiom_env
structure expr where
  e_body : List mono
  e_rows : ℤ
  e_cols : ℤ
axiom inhabited_axiom_expr : Inhabited expr
attribute [instance] inhabited_axiom_expr
noncomputable def e_vld (env1 : env) (e : expr) := (0 : ℤ) ≤ expr.e_rows e ∧ (0 : ℤ) ≤ expr.e_cols e ∧ lm_vld (env.ev_f env1) (expr.e_rows e) (expr.e_cols e) (expr.e_body e)
noncomputable def e_mdl (env1 : env) (e : expr) := lm_mdl_simp (env.ev_f env1) (expr.e_rows e) (expr.e_cols e) (expr.e_body e)
axiom extends1 : (ℤ -> MyMatrix.mat ℤ) -> ℤ -> MyMatrix.mat ℤ -> ℤ -> MyMatrix.mat ℤ
axiom extends'def (f : ℤ -> MyMatrix.mat ℤ) (c : ℤ) (v : MyMatrix.mat ℤ) (n : ℤ) : extends1 f c v n = (if ¬n = c then f n else v)
noncomputable def symb_mat (m : MyMatrix.mat ℤ) (n : ℤ) := expr.mk (List.cons (mono.mk (List.cons n ([] : List ℤ)) true) ([] : List mono)) (MyMatrix.rows m) (MyMatrix.cols m)
noncomputable def symb_opp (e : expr) := expr.mk (lm_opp (expr.e_body e)) (expr.e_rows e) (expr.e_cols e)
noncomputable def symb_add (e1 : expr) (e2 : expr) := expr.mk (lm_merge ([] : List mono) (expr.e_body e1) (expr.e_body e2)) (expr.e_rows e1) (expr.e_cols e1)
noncomputable def symb_sub (e1 : expr) (e2 : expr) := symb_add e1 (symb_opp e2)
noncomputable def symb_mul (e1 : expr) (e2 : expr) := expr.mk (lm_distribute (expr.e_body e1) (expr.e_body e2)) (expr.e_rows e1) (expr.e_cols e2)
lemma harness'vc (a11 : MyMatrix.mat ℤ) (a12 : MyMatrix.mat ℤ) (a22 : MyMatrix.mat ℤ) (b11 : MyMatrix.mat ℤ) (b21 : MyMatrix.mat ℤ) (b22 : MyMatrix.mat ℤ) (env1 : env) (env2 : env) (env3 : env) (env4 : env) (env5 : env) (env6 : env) (env7 : env) (fact0 : MyMatrix.infix_eqeqeq a11 a12) (fact1 : MyMatrix.infix_eqeqeq a12 a22) (fact2 : MyMatrix.infix_eqeqeq a22 b11) (fact3 : MyMatrix.infix_eqeqeq b11 b21) (fact4 : MyMatrix.infix_eqeqeq b21 b22) (fact5 : MyMatrix.rows a11 = MyMatrix.cols a11) (fact6 : env.ev_c env1 = (0 : ℤ)) (fact7 : env.ev_c env2 = env.ev_c env1 + (1 : ℤ)) (fact8 : env.ev_f env2 = extends1 (env.ev_f env1) (env.ev_c env1) a11) (fact9 : e_vld env2 (symb_mat a11 (env.ev_c env1))) (fact10 : env.ev_c env3 = env.ev_c env2 + (1 : ℤ)) (fact11 : env.ev_f env3 = extends1 (env.ev_f env2) (env.ev_c env2) a12) (fact12 : e_vld env3 (symb_mat a12 (env.ev_c env2))) (fact13 : env.ev_c env4 = env.ev_c env3 + (1 : ℤ)) (fact14 : env.ev_f env4 = extends1 (env.ev_f env3) (env.ev_c env3) a22) (fact15 : e_vld env4 (symb_mat a22 (env.ev_c env3))) (fact16 : env.ev_c env5 = env.ev_c env4 + (1 : ℤ)) (fact17 : env.ev_f env5 = extends1 (env.ev_f env4) (env.ev_c env4) b11) (fact18 : e_vld env5 (symb_mat b11 (env.ev_c env4))) (fact19 : env.ev_c env6 = env.ev_c env5 + (1 : ℤ)) (fact20 : env.ev_f env6 = extends1 (env.ev_f env5) (env.ev_c env5) b21) (fact21 : e_vld env6 (symb_mat b21 (env.ev_c env5))) (fact22 : env.ev_c env7 = env.ev_c env6 + (1 : ℤ)) (fact23 : env.ev_f env7 = extends1 (env.ev_f env6) (env.ev_c env6) b22) (fact24 : e_vld env7 (symb_mat b22 (env.ev_c env6))) : e_vld env7 (symb_mat b11 (env.ev_c env4)) ∧ e_vld env7 (symb_mat b22 (env.ev_c env6)) ∧ expr.e_rows (symb_mat b11 (env.ev_c env4)) = expr.e_rows (symb_mat b22 (env.ev_c env6)) ∧ expr.e_cols (symb_mat b11 (env.ev_c env4)) = expr.e_cols (symb_mat b22 (env.ev_c env6)) ∧ (e_vld env7 (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6))) ∧ e_mdl env7 (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6))) = MatrixArithmetic.add (e_mdl env7 (symb_mat b11 (env.ev_c env4))) (e_mdl env7 (symb_mat b22 (env.ev_c env6))) → ((e_vld env7 (symb_mat a11 (env.ev_c env1)) ∧ e_vld env7 (symb_mat a22 (env.ev_c env3))) ∧ expr.e_rows (symb_mat a11 (env.ev_c env1)) = expr.e_rows (symb_mat a22 (env.ev_c env3)) ∧ expr.e_cols (symb_mat a11 (env.ev_c env1)) = expr.e_cols (symb_mat a22 (env.ev_c env3))) ∧ (e_vld env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) ∧ e_mdl env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) = MatrixArithmetic.add (e_mdl env7 (symb_mat a11 (env.ev_c env1))) (e_mdl env7 (symb_mat a22 (env.ev_c env3))) → ((e_vld env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) ∧ e_vld env7 (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) ∧ expr.e_cols (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) = expr.e_rows (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) ∧ (e_vld env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) ∧ e_mdl env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) = MatrixArithmetic.mul (e_mdl env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3)))) (e_mdl env7 (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) → ((e_vld env7 (symb_mat b21 (env.ev_c env5)) ∧ e_vld env7 (symb_mat b11 (env.ev_c env4))) ∧ expr.e_rows (symb_mat b21 (env.ev_c env5)) = expr.e_rows (symb_mat b11 (env.ev_c env4)) ∧ expr.e_cols (symb_mat b21 (env.ev_c env5)) = expr.e_cols (symb_mat b11 (env.ev_c env4))) ∧ (e_vld env7 (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))) ∧ e_mdl env7 (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))) = MatrixArithmetic.sub (e_mdl env7 (symb_mat b21 (env.ev_c env5))) (e_mdl env7 (symb_mat b11 (env.ev_c env4))) → ((e_vld env7 (symb_mat a22 (env.ev_c env3)) ∧ e_vld env7 (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))) ∧ expr.e_cols (symb_mat a22 (env.ev_c env3)) = expr.e_rows (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))) ∧ (e_vld env7 (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))) ∧ e_mdl env7 (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))) = MatrixArithmetic.mul (e_mdl env7 (symb_mat a22 (env.ev_c env3))) (e_mdl env7 (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))) → ((e_vld env7 (symb_mat a11 (env.ev_c env1)) ∧ e_vld env7 (symb_mat a12 (env.ev_c env2))) ∧ expr.e_rows (symb_mat a11 (env.ev_c env1)) = expr.e_rows (symb_mat a12 (env.ev_c env2)) ∧ expr.e_cols (symb_mat a11 (env.ev_c env1)) = expr.e_cols (symb_mat a12 (env.ev_c env2))) ∧ (e_vld env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) ∧ e_mdl env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) = MatrixArithmetic.add (e_mdl env7 (symb_mat a11 (env.ev_c env1))) (e_mdl env7 (symb_mat a12 (env.ev_c env2))) → ((e_vld env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) ∧ e_vld env7 (symb_mat b22 (env.ev_c env6))) ∧ expr.e_cols (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) = expr.e_rows (symb_mat b22 (env.ev_c env6))) ∧ (e_vld env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6))) ∧ e_mdl env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6))) = MatrixArithmetic.mul (e_mdl env7 (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2)))) (e_mdl env7 (symb_mat b22 (env.ev_c env6))) → ((e_vld env7 (symb_mat b21 (env.ev_c env5)) ∧ e_vld env7 (symb_mat b22 (env.ev_c env6))) ∧ expr.e_rows (symb_mat b21 (env.ev_c env5)) = expr.e_rows (symb_mat b22 (env.ev_c env6)) ∧ expr.e_cols (symb_mat b21 (env.ev_c env5)) = expr.e_cols (symb_mat b22 (env.ev_c env6))) ∧ (e_vld env7 (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))) ∧ e_mdl env7 (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))) = MatrixArithmetic.add (e_mdl env7 (symb_mat b21 (env.ev_c env5))) (e_mdl env7 (symb_mat b22 (env.ev_c env6))) → ((e_vld env7 (symb_mat a12 (env.ev_c env2)) ∧ e_vld env7 (symb_mat a22 (env.ev_c env3))) ∧ expr.e_rows (symb_mat a12 (env.ev_c env2)) = expr.e_rows (symb_mat a22 (env.ev_c env3)) ∧ expr.e_cols (symb_mat a12 (env.ev_c env2)) = expr.e_cols (symb_mat a22 (env.ev_c env3))) ∧ (e_vld env7 (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) ∧ e_mdl env7 (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) = MatrixArithmetic.sub (e_mdl env7 (symb_mat a12 (env.ev_c env2))) (e_mdl env7 (symb_mat a22 (env.ev_c env3))) → ((e_vld env7 (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) ∧ e_vld env7 (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6)))) ∧ expr.e_cols (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) = expr.e_rows (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6)))) ∧ (e_vld env7 (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6)))) ∧ e_mdl env7 (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6)))) = MatrixArithmetic.mul (e_mdl env7 (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3)))) (e_mdl env7 (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6)))) → ((e_vld env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) ∧ e_vld env7 (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) ∧ expr.e_rows (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) = expr.e_rows (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))) ∧ expr.e_cols (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) = expr.e_cols (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) ∧ (e_vld env7 (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) ∧ e_mdl env7 (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) = MatrixArithmetic.add (e_mdl env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6))))) (e_mdl env7 (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) → ((e_vld env7 (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) ∧ e_vld env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) ∧ expr.e_rows (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) = expr.e_rows (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6))) ∧ expr.e_cols (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) = expr.e_cols (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) ∧ (e_vld env7 (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) ∧ e_mdl env7 (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) = MatrixArithmetic.sub (e_mdl env7 (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4)))))) (e_mdl env7 (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) → ((e_vld env7 (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) ∧ e_vld env7 (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))))) ∧ expr.e_rows (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) = expr.e_rows (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6)))) ∧ expr.e_cols (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) = expr.e_cols (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))))) ∧ (e_vld env7 (symb_add (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))))) ∧ e_mdl env7 (symb_add (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))))) = MatrixArithmetic.add (e_mdl env7 (symb_sub (symb_add (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b11 (env.ev_c env4)) (symb_mat b22 (env.ev_c env6)))) (symb_mul (symb_mat a22 (env.ev_c env3)) (symb_sub (symb_mat b21 (env.ev_c env5)) (symb_mat b11 (env.ev_c env4))))) (symb_mul (symb_add (symb_mat a11 (env.ev_c env1)) (symb_mat a12 (env.ev_c env2))) (symb_mat b22 (env.ev_c env6))))) (e_mdl env7 (symb_mul (symb_sub (symb_mat a12 (env.ev_c env2)) (symb_mat a22 (env.ev_c env3))) (symb_add (symb_mat b21 (env.ev_c env5)) (symb_mat b22 (env.ev_c env6))))) → ((e_vld env7 (symb_mat a12 (env.ev_c env2)) ∧ e_vld env7 (symb_mat b21 (env.ev_c env5))) ∧ expr.e_cols (symb_mat a12 (env.ev_c env2)) = expr.e_rows (symb_mat b21 (env.ev_c env5))) ∧ (e_vld env7 (symb_mul (symb_mat a12 (env.ev_c env2)) (symb_mat b21 (env.ev_c env5))) ∧ e_mdl env7 (symb_mul (symb_mat a12 (env.ev_c env2)) (symb_mat b21 (env.ev_c env5))) = MatrixArithmetic.mul (e_mdl env7 (symb_mat a12 (env.ev_c env2))) (e_mdl env7 (symb_mat b21 (env.ev_c env5))) → ((e_vld env7 (symb_mat a11 (env.ev_c env1)) ∧ e_vld env7 (symb_mat b11 (env.ev_c env4))) ∧ expr.e_cols (symb_mat a11 (env.ev_c env1)) = expr.e_rows (symb_mat b11 (env.ev_c env4))) ∧ (e_vld env7 (symb_mul (symb_mat a11 (env.ev_c env1)) (symb_mat b11 (env.ev_c env4))) ∧ e_mdl env7 (symb_mul (symb_mat a11 (env.ev_c env1)) (symb_mat b11 (env.ev_c env4))) = MatrixArithmetic.mul (e_mdl env7 (symb_mat a11 (env.ev_c env1))) (e_mdl env7 (symb_mat b11 (env.ev_c env4))) → (e_vld env7 (symb_mul (symb_mat a11 (env.ev_c env1)) (symb_mat b11 (env.ev_c env4))) ∧ e_vld env7 (symb_mul (symb_mat a12 (env.ev_c env2)) (symb_mat b21 (env.ev_c env5)))) ∧ expr.e_rows (symb_mul (symb_mat a11 (env.ev_c env1)) (symb_mat b11 (env.ev_c env4))) = expr.e_rows (symb_mul (symb_mat a12 (env.ev_c env2)) (symb_mat b21 (env.ev_c env5))) ∧ expr.e_cols (symb_mul (symb_mat a11 (env.ev_c env1)) (symb_mat b11 (env.ev_c env4))) = expr.e_cols (symb_mul (symb_mat a12 (env.ev_c env2)) (symb_mat b21 (env.ev_c env5))))))))))))))))))
  := sorry
end matrices_ring_simp_Symb_harnessqtvc
